function mpc = case2736sp
%CASE2736SP  Power flow data for Polish system - summer 2004 peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   summer 2004 peak conditions. Multiple centrally dispatchable
%   generators at a bus have not been aggregated. Generators that are
%   not centrally dispatchable in the Polish energy market are given a
%   cost of zero.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case2736sp.m 1559 2010-03-10 18:08:32Z ray $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin	lam_P	lam_Q	mu_Vmax	mu_Vmin
mpc.bus = [
	1	1	0	0	0	0	1	1.1010186	36.775787	220	1	1.11	0.95	97.9642	0.1737	0.0000	0.0000;
	2	1	0	0	0	0	1	1.1060162	38.502827	220	1	1.11	0.95	97.5886	0.0592	0.0000	0.0000;
	3	1	0	0	0	0	1	1.0848541	13.549052	220	1	1.11	0.95	110.9086	0.1409	0.0000	0.0000;
	4	1	0	0	0	0	1	1.092332	32.518852	220	1	1.11	0.95	100.0063	0.4639	0.0000	0.0000;
	5	1	0	0	0	0	1	1.092363	32.517423	220	1	1.11	0.95	100.0073	0.4634	0.0000	0.0000;
	6	1	0	0	0	0	1	1.0653306	22.234545	220	1	1.11	0.95	104.7833	0.8183	0.0000	0.0000;
	7	1	0	0	0	0	1	1.0654455	22.247039	220	1	1.11	0.95	104.7745	0.8156	0.0000	0.0000;
	8	1	0	0	0	0	1	1.0256415	25.401189	400	1	1.05	0.95	103.5752	0.3513	0.0000	0.0000;
	9	1	0	0	0	0	1	1.0256531	25.407157	400	1	1.05	0.95	103.5718	0.3500	0.0000	0.0000;
	10	1	0	0	0	0	1	1.0586771	21.759947	220	1	1.11	0.95	105.6057	1.0277	0.0000	0.0000;
	11	1	0	0	0	0	1	1.058595	21.754988	220	1	1.11	0.95	105.6080	1.0297	0.0000	0.0000;
	12	1	0	0	0	0	1	1.0585464	21.761505	220	1	1.11	0.95	105.6066	1.0315	0.0000	0.0000;
	13	1	0	0	0	0	1	1.0585095	21.754125	220	1	1.11	0.95	105.6077	1.0320	0.0000	0.0000;
	14	1	0	0	0	0	1	1.0183879	26.785477	400	1	1.05	0.95	102.9672	0.6071	0.0000	0.0000;
	15	1	0	0	0	0	1	1.0315259	22.695731	400	1	1.05	0.95	104.4832	0.0632	0.0000	0.0000;
	16	1	0	0	0	0	1	1.0315259	22.695731	400	1	1.05	0.95	104.4832	0.0632	0.0000	0.0000;
	17	2	0	0	0	0	1	1.0932112	16.45159	220	1	1.11	0.95	108.4499	0.1084	0.0000	0.0000;
	18	1	0	0	0	0	1	1.0932634	16.451047	220	1	1.11	0.95	108.4483	0.1077	0.0000	0.0000;
	19	1	0	0	0	0	1	1.096849	33.519934	220	1	1.11	0.95	99.4431	0.3577	0.0000	0.0000;
	20	1	0	0	0	0	1	1.0968889	33.522277	220	1	1.11	0.95	99.4429	0.3572	0.0000	0.0000;
	21	1	0	0	0	0	1	1.0778181	20.631124	220	1	1.11	0.95	105.9001	0.5847	0.0000	0.0000;
	22	1	0	0	0	0	1	1.0778181	20.631124	220	1	1.11	0.95	105.9001	0.5847	0.0000	0.0000;
	23	1	0	0	0	0	1	1.0563162	21.749861	220	1	1.11	0.95	105.5971	1.0403	0.0000	0.0000;
	24	1	0	0	0	0	1	1.0981385	35.282073	220	1	1.11	0.95	98.8433	0.2741	0.0000	0.0000;
	25	1	0	0	0	0	1	1.0325941	25.080263	400	1	1.05	0.95	103.8800	0.3703	0.0000	0.0000;
	26	2	61.358	72.054	0	0	1	1.11	37.105871	220	1	1.11	0.95	97.7882	0.0000	1044.8801	0.0000;
	27	2	84.861	122.06	0	0	1	1.11	38.794264	220	1	1.11	0.95	97.4519	0.0000	1601.4174	0.0000;
	28	3	49	74	0	0	1	1.0461868	36.029099	400	1	1.05	0.95	98.6073	-0.0008	0.0000	0.0000;
	29	2	49	74	0	0	1	1.0461977	36.03466	400	1	1.05	0.95	98.6040	-0.0000	0.0000	0.0000;
	30	1	0	0	0	0	1	1.0661645	21.34895	220	1	1.11	0.95	105.6749	0.8355	0.0000	0.0000;
	31	1	0	0	0	0	1	1.0438875	34.595074	400	1	1.05	0.95	98.8892	-0.0693	0.0000	0.0000;
	32	1	0	0	0	0	1	1.0557975	21.446015	220	1	1.11	0.95	105.8196	1.0971	0.0000	0.0000;
	33	1	0	0	0	0	1	1.0992548	30.103534	220	1	1.11	0.95	100.8633	0.2948	0.0000	0.0000;
	34	1	0	0	0	0	1	1.0766806	27.272544	220	2	1.11	0.95	101.9122	-0.3204	0.0000	0.0000;
	35	1	0	0	0	0	1	1.0798203	27.673736	220	2	1.11	0.95	102.0744	-0.6743	0.0000	0.0000;
	36	1	0	0	0	0	1	1.0876123	28.64882	220	2	1.11	0.95	101.3876	-0.8651	0.0000	0.0000;
	37	1	0	0	0	0	1	1.0876009	28.646874	220	2	1.11	0.95	101.3886	-0.8649	0.0000	0.0000;
	38	1	0	0	0	0	1	1.0668339	26.033164	220	2	1.11	0.95	102.7618	-0.4427	0.0000	0.0000;
	39	1	0	0	0	0	1	1.11	28.98362	220	2	1.11	0.95	101.1082	-3.0865	18045.9803	0.0000;
	40	1	0	0	0	0	1	1.109887	28.984018	220	2	1.11	0.95	101.1098	-3.0744	0.0000	0.0000;
	41	1	0	0	0	0	1	1.0237808	29.189245	400	2	1.05	0.95	101.1345	-2.0956	0.0000	0.0000;
	42	2	25	0	0	0	1	1.0911339	27.827571	220	2	1.11	0.95	101.8427	-0.1316	0.0000	0.0000;
	43	2	26	0	0	0	1	1.0910418	27.846018	220	2	1.11	0.95	101.8368	-0.1325	0.0000	0.0000;
	44	2	25	0	0	0	1	1.0274551	28.252061	400	2	1.05	0.95	102.0500	-0.0378	0.0000	0.0000;
	45	1	0	0	0	0	1	1.0274089	28.249417	400	2	1.05	0.95	102.0499	-0.0374	0.0000	0.0000;
	46	1	0	0	0	0	1	1.1065267	28.489454	220	2	1.11	0.95	101.4510	-2.8780	0.0000	0.0000;
	47	1	0	0	0	0	1	1.0378593	25.850056	400	2	1.05	0.95	102.2308	-0.8351	0.0000	0.0000;
	48	1	0	0	0	0	1	1.037829	25.84432	400	2	1.05	0.95	102.2336	-0.8342	0.0000	0.0000;
	49	1	0	0	0	0	1	1.0341541	27.739862	400	2	1.05	0.95	102.0681	-0.1569	0.0000	0.0000;
	50	1	0	0	0	0	1	1.0744468	27.089094	220	2	1.11	0.95	102.0731	-0.4925	0.0000	0.0000;
	51	1	0	0	0	0	1	1.0744293	27.091895	220	2	1.11	0.95	102.0731	-0.4924	0.0000	0.0000;
	52	1	0	0	0	0	1	1.0381233	28.457244	400	2	1.05	0.95	101.6773	-0.7629	0.0000	0.0000;
	53	1	0	0	0	0	1	1.0381438	28.459291	400	2	1.05	0.95	101.6757	-0.7648	0.0000	0.0000;
	54	2	13	0	0	0	1	1.092432	29.660532	220	2	1.11	0.95	100.9266	-1.0086	0.0000	0.0000;
	55	2	13	0	0	0	1	1.0923941	29.657448	220	2	1.11	0.95	100.9250	-1.0101	0.0000	0.0000;
	56	2	13	0	0	0	1	1.0448325	29.371186	400	2	1.05	0.95	101.1741	-1.1458	0.0000	0.0000;
	57	2	26	0	0	0	1	1.0448051	29.367657	400	2	1.05	0.95	101.1759	-1.1461	0.0000	0.0000;
	58	2	89.067	40	0	0	1	1.0849742	27.40234	220	2	1.11	0.95	102.0281	-0.2262	0.0000	0.0000;
	59	1	0	0	0	0	1	1.0849851	27.403911	220	2	1.11	0.95	102.0268	-0.2267	0.0000	0.0000;
	60	1	0	0	0	0	1	1.10181	28.422003	220	2	1.11	0.95	101.4486	-2.4534	0.0000	0.0000;
	61	1	0	0	0	0	1	1.0925329	27.376057	220	2	1.11	0.95	102.1670	-0.6982	0.0000	0.0000;
	62	1	0	0	0	0	1	1.0924964	27.373267	220	2	1.11	0.95	102.1674	-0.6941	0.0000	0.0000;
	63	1	0	0	0	0	1	1.0484928	28.281312	400	2	1.05	0.95	101.4167	-1.0744	0.0000	0.0000;
	64	1	0	0	0	0	1	1.048443	28.269845	400	2	1.05	0.95	101.4211	-1.0730	0.0000	0.0000;
	65	1	0	0	0	0	1	1.08105	27.580632	220	2	1.11	0.95	101.8675	-0.6568	0.0000	0.0000;
	66	1	0	0	0	0	1	1.0825042	27.745917	220	2	1.11	0.95	101.7568	-0.6842	0.0000	0.0000;
	67	1	0	0	0	0	1	1.0750296	27.807377	220	2	1.11	0.95	101.7225	-0.4651	0.0000	0.0000;
	68	1	0	0	0	0	1	1.1010761	32.590465	220	3	1.11	0.95	99.8077	-0.3688	0.0000	0.0000;
	69	1	10.327	0	0	0	1	1.0960299	29.336414	220	3	1.11	0.95	101.2532	-0.5368	0.0000	0.0000;
	70	1	8.032	3.714	0	0	1	1.0958743	29.343331	220	3	1.11	0.95	101.2506	-0.5330	0.0000	0.0000;
	71	1	0	0	0	0	1	1.0988119	32.340582	220	3	1.11	0.95	99.5961	0.0929	0.0000	0.0000;
	72	1	0	0	0	0	1	1.0988429	32.352565	220	3	1.11	0.95	99.5928	0.0917	0.0000	0.0000;
	73	1	0	0	0	0	1	1.0958718	32.07566	220	3	1.11	0.95	99.7104	0.0192	0.0000	0.0000;
	74	1	0	0	0	0	1	1.0958515	32.070879	220	3	1.11	0.95	99.7113	0.0193	0.0000	0.0000;
	75	1	0	0	0	0	1	1.0981431	30.779823	220	3	1.11	0.95	100.6839	0.1752	0.0000	0.0000;
	76	1	0	0	0	0	1	1.0980313	30.772798	220	3	1.11	0.95	100.6881	0.1774	0.0000	0.0000;
	77	2	27	70	0	0	1	1.1017006	33.163979	220	3	1.11	0.95	99.2188	0.0000	0.0000	0.0000;
	78	2	18.7	42	0	0	1	1.1001979	33.206703	220	3	1.11	0.95	99.2865	0.0000	0.0000	0.0000;
	79	1	4.934	0.817	0	0	1	1.0917918	31.874096	220	3	1.11	0.95	100.0821	0.2170	0.0000	0.0000;
	80	1	0	0	0	0	1	1.0918096	31.875195	220	3	1.11	0.95	100.0813	0.2168	0.0000	0.0000;
	81	2	18	57	0	0	1	1.0324377	32.199744	400	3	1.05	0.95	99.4311	-0.0467	0.0000	0.0000;
	82	1	0	0	0	0	1	1.088144	31.187203	220	3	1.11	0.95	99.9377	-0.6237	0.0000	0.0000;
	83	1	0	0	0	0	1	1.0979531	31.585593	220	3	1.11	0.95	100.0804	0.0223	0.0000	0.0000;
	84	1	0	0	0	0	1	1.0979533	31.590664	220	3	1.11	0.95	100.0786	0.0222	0.0000	0.0000;
	85	1	44.864	-6.4	0	0	1	1.101997	32.578494	220	3	1.11	0.95	99.7311	-0.3991	0.0000	0.0000;
	86	1	0	0	0	0	1	1.1019728	32.573278	220	3	1.11	0.95	99.7331	-0.3985	0.0000	0.0000;
	87	1	0	0	0	0	1	1.0921611	31.890439	220	3	1.11	0.95	99.8837	0.1014	0.0000	0.0000;
	88	1	0	0	0	0	1	1.0921486	31.896061	220	3	1.11	0.95	99.8819	0.1022	0.0000	0.0000;
	89	1	0	0	0	0	1	1.1032657	33.033004	220	3	1.11	0.95	99.5000	-0.4139	0.0000	0.0000;
	90	1	0	0	0	0	1	1.103263	33.028595	220	3	1.11	0.95	99.5022	-0.4161	0.0000	0.0000;
	91	1	0	0	0	0	1	1.0475653	34.208064	400	3	1.05	0.95	99.2147	-0.2518	0.0000	0.0000;
	92	1	0	0	0	0	1	1.0475601	34.20635	400	3	1.05	0.95	99.2150	-0.2518	0.0000	0.0000;
	93	1	0	0	0	0	1	1.0935069	31.482247	220	3	1.11	0.95	100.0665	0.0637	0.0000	0.0000;
	94	1	0	0	0	0	1	1.0935303	31.477652	220	3	1.11	0.95	100.0682	0.0640	0.0000	0.0000;
	95	1	0	0	0	0	1	1.0927523	31.68528	220	3	1.11	0.95	100.0032	-0.1863	0.0000	0.0000;
	96	1	0	0	0	0	1	1.0927385	31.682752	220	3	1.11	0.95	100.0027	-0.1888	0.0000	0.0000;
	97	2	12.49	3.696	0	0	1	1.0988887	32.455083	220	3	1.11	0.95	99.6560	-0.2413	0.0000	0.0000;
	98	1	17.327	6.126	0	0	1	1.0988852	32.448472	220	3	1.11	0.95	99.6584	-0.2434	0.0000	0.0000;
	99	1	0	0	0	0	1	1.0960777	29.360785	220	3	1.11	0.95	101.2403	-0.5372	0.0000	0.0000;
	100	1	0	0	0	0	1	1.0960847	29.360593	220	3	1.11	0.95	101.2400	-0.5362	0.0000	0.0000;
	101	1	0	0	0	0	1	1.091473	30.406145	220	3	1.11	0.95	100.9840	0.3400	0.0000	0.0000;
	102	1	0	0	0	0	1	1.0914416	30.406439	220	3	1.11	0.95	100.9833	0.3405	0.0000	0.0000;
	103	2	14	40	0	0	1	1.0995351	31.562811	220	3	1.11	0.95	100.1083	0.0000	0.0000	0.0000;
	104	2	0	0	0	0	1	1.0994826	31.535777	220	3	1.11	0.95	100.1174	0.0013	0.0000	0.0000;
	105	2	7	18	0	0	1	1.0951885	31.964706	220	3	1.11	0.95	99.8094	0.0000	0.0000	0.0000;
	106	2	0	0	0	0	1	1.095137	31.962104	220	3	1.11	0.95	99.8116	0.0000	0.0000	0.0000;
	107	1	0	13.892	0	0	1	1.0993639	31.893822	220	3	1.11	0.95	99.9190	-0.5043	0.0000	0.0000;
	108	1	73.779	8.097	0	0	1	1.0993779	31.884324	220	3	1.11	0.95	99.9214	-0.5078	0.0000	0.0000;
	109	1	0	0	0	0	1	1.0935543	31.15097	220	3	1.11	0.95	100.6245	0.0315	0.0000	0.0000;
	110	1	0	0	0	0	1	1.0870297	31.776981	220	3	1.11	0.95	100.2389	0.3415	0.0000	0.0000;
	111	1	0	0	0	0	1	1.0870594	31.777527	220	3	1.11	0.95	100.2383	0.3411	0.0000	0.0000;
	112	1	0	0	0	0	1	1.09294	31.951505	220	3	1.11	0.95	100.0151	0.1993	0.0000	0.0000;
	113	1	0	0	0	0	1	1.0929963	31.960626	220	3	1.11	0.95	100.0113	0.1982	0.0000	0.0000;
	114	1	0	0	0	0	1	1.0414756	31.315391	400	3	1.05	0.95	100.0335	-0.6552	0.0000	0.0000;
	115	2	0	0	0	0	1	1.0996551	32.842783	220	3	1.11	0.95	99.3961	-0.0492	0.0000	0.0000;
	116	2	8	15	0	0	1	1.0996683	32.845139	220	3	1.11	0.95	99.3969	-0.0498	0.0000	0.0000;
	117	2	5.5	10	0	0	1	1.0980564	31.963394	220	3	1.11	0.95	100.0549	-0.0505	0.0000	0.0000;
	118	1	0	0	0	0	1	1.0980782	31.954501	220	3	1.11	0.95	100.0569	-0.0515	0.0000	0.0000;
	119	1	0	0	0	0	1	1.0496156	29.100897	400	3	1.05	0.95	101.1591	-1.1087	0.0000	0.0000;
	120	1	0	0	0	0	1	1.0496497	29.105654	400	3	1.05	0.95	101.1569	-1.1097	0.0000	0.0000;
	121	1	0	0	0	0	1	1.0499794	31.482429	400	3	1.05	0.95	99.9752	-1.1326	0.0000	0.0000;
	122	1	0	0	0	0	1	1.05	31.48757	400	3	1.05	0.95	99.9734	-1.1353	8588.8847	0.0000;
	123	1	0	0	0	0	1	1.0928602	31.085037	220	3	1.11	0.95	100.7429	0.0437	0.0000	0.0000;
	124	2	11	17.5	0	0	1	1.0993585	33.009613	220	3	1.11	0.95	99.3793	-0.0039	0.0000	0.0000;
	125	2	41.353	61.2	0	0	1	1.0992582	33.027058	220	3	1.11	0.95	99.3738	0.0000	0.0000	0.0000;
	126	2	14	33	0	0	1	1.0363847	31.71386	400	3	1.05	0.95	99.7881	-0.2925	0.0000	0.0000;
	127	1	0	0	0	0	1	1.0363725	31.714405	400	3	1.05	0.95	99.7881	-0.2933	0.0000	0.0000;
	128	1	0	0	0	0	1	1.1013954	32.470129	220	3	1.11	0.95	99.7900	-0.3859	0.0000	0.0000;
	129	1	0	0	0	0	1	1.1013663	32.472326	220	3	1.11	0.95	99.7883	-0.3854	0.0000	0.0000;
	130	1	0	0	0	0	1	1.1018746	32.696256	220	3	1.11	0.95	99.6716	-0.3775	0.0000	0.0000;
	131	2	1.5	9	0	0	1	1.1008625	31.132371	220	3	1.11	0.95	100.5080	0.1314	0.0000	0.0000;
	132	2	0	0	0	0	1	1.0980639	30.772568	220	3	1.11	0.95	100.6881	0.1766	0.0000	0.0000;
	133	2	11.215	8.3	0	0	1	1.11	28.903756	220	4	1.11	0.95	101.2167	0.0000	1024.1353	0.0000;
	134	2	10.333	7.7	0	0	1	1.1099315	28.901135	220	4	1.11	0.95	101.2175	0.0022	0.0000	0.0000;
	135	1	0	0	0	0	1	1.0810731	25.003209	220	4	1.11	0.95	100.9562	-2.0325	0.0000	0.0000;
	136	1	0	0	0	0	1	1.0828301	25.845304	220	4	1.11	0.95	100.8377	-1.3233	0.0000	0.0000;
	137	1	0	0	0	0	1	1.0065862	25.629604	400	4	1.05	0.95	101.9525	0.0152	0.0000	0.0000;
	138	1	0	0	0	0	1	1.0066041	25.629594	400	4	1.05	0.95	101.9534	0.0152	0.0000	0.0000;
	139	1	0	0	0	0	1	1.0954147	18.201899	220	4	1.11	0.95	108.0210	0.2680	0.0000	0.0000;
	140	1	0	0	0	0	1	1.1000855	14.087622	220	4	1.11	0.95	110.4893	0.1754	0.0000	0.0000;
	141	1	0	0	0	0	1	1.1000855	14.087622	220	4	1.11	0.95	110.4893	0.1754	0.0000	0.0000;
	142	1	0	0	0	0	1	1.0997348	16.013776	220	4	1.11	0.95	108.7946	0.2311	0.0000	0.0000;
	143	1	0	0	0	0	1	1.0776819	23.706483	220	4	1.11	0.95	101.6440	-1.1967	0.0000	0.0000;
	144	1	0	0	0	0	1	1.0776819	23.706483	220	4	1.11	0.95	101.6440	-1.1967	0.0000	0.0000;
	145	2	0	0	0	0	1	1.1088684	25.389294	220	4	1.11	0.95	103.0118	0.0224	0.0000	0.0000;
	146	2	0	0	0	0	1	1.1088509	25.388257	220	4	1.11	0.95	103.0087	0.0234	0.0000	0.0000;
	147	2	25.553	12.9	0	0	1	1.11	16.402836	220	4	1.11	0.95	108.8237	0.0000	137.4001	0.0000;
	148	1	0	0	0	0	1	1.1099376	16.407478	220	4	1.11	0.95	108.8222	0.0012	0.0000	0.0000;
	149	2	11	12	0	0	1	1.0401684	17.664753	400	4	1.05	0.95	108.5541	-0.1626	0.0000	0.0000;
	150	2	11.922	13.7	0	0	1	1.0401565	17.665765	400	4	1.05	0.95	108.5538	-0.1620	0.0000	0.0000;
	151	1	0	0	0	0	1	1.069707	17.919442	220	4	1.11	0.95	108.6543	0.9181	0.0000	0.0000;
	152	1	0	0	0	0	1	1.0969163	20.247111	220	4	1.11	0.95	105.8110	0.2418	0.0000	0.0000;
	153	1	0	0	0	0	1	1.096869	20.242733	220	4	1.11	0.95	105.8119	0.2429	0.0000	0.0000;
	154	2	19.475	64.3	0	0	1	1.0864589	28.005014	220	4	1.11	0.95	100.2380	-0.0784	0.0000	0.0000;
	155	2	16	33	0	0	1	1.0864932	27.996658	220	4	1.11	0.95	100.2439	-0.0748	0.0000	0.0000;
	156	1	0	0	0	0	1	1.0043516	27.561652	400	4	1.05	0.95	100.5569	-0.0001	0.0000	0.0000;
	157	2	10	25	0	0	1	1.0043458	27.567359	400	4	1.05	0.95	100.5542	0.0000	0.0000	0.0000;
	158	1	0	0	0	0	1	1.0991142	14.121984	220	4	1.11	0.95	110.3861	0.1678	0.0000	0.0000;
	159	1	0	0	0	0	1	1.0991142	14.121984	220	4	1.11	0.95	110.3861	0.1678	0.0000	0.0000;
	160	1	0	0	0	0	1	1.01267	25.596022	400	4	1.05	0.95	101.9142	0.0037	0.0000	0.0000;
	161	1	0	0	0	0	1	1.0153659	26.740571	400	4	1.05	0.95	101.4418	-0.0330	0.0000	0.0000;
	162	1	0	0	0	0	1	1.015348	26.736535	400	4	1.05	0.95	101.4436	-0.0331	0.0000	0.0000;
	163	2	5.54	2.93	0	0	1	1.11	25.217368	220	4	1.11	0.95	103.0649	0.0000	332.7039	0.0000;
	164	2	18.255	11.5	0	0	1	1.11	25.208728	220	4	1.11	0.95	103.0713	0.0000	1279.9799	0.0000;
	165	1	0	0	0	0	1	1.11	25.208728	220	4	1.11	0.95	103.0713	0.0000	0.0000	0.0000;
	166	1	0	0	0	0	1	1.0904059	14.08851	220	4	1.11	0.95	110.8567	0.0398	0.0000	0.0000;
	167	1	0	0	0	0	1	1.0992392	13.957564	220	4	1.11	0.95	110.5522	0.1850	0.0000	0.0000;
	168	1	0	0	0	0	1	1.0934021	17.056139	220	4	1.11	0.95	108.8217	0.1748	0.0000	0.0000;
	169	1	0	0	0	0	1	1.0933821	17.048382	220	4	1.11	0.95	108.8244	0.1745	0.0000	0.0000;
	170	1	0	0	0	0	1	1.0280759	16.561836	400	4	1.05	0.95	108.9582	0.2096	0.0000	0.0000;
	171	1	0	0	0	0	1	1.0280759	16.561836	400	4	1.05	0.95	108.9582	0.2096	0.0000	0.0000;
	172	1	0	0	0	0	1	1.0678718	20.601469	220	4	1.11	0.95	106.2796	0.8193	0.0000	0.0000;
	173	1	0	0	0	0	1	1.0678575	20.607682	220	4	1.11	0.95	106.2773	0.8197	0.0000	0.0000;
	174	1	0	0	0	0	1	1.0911492	20.353191	220	4	1.11	0.95	105.2017	0.4016	0.0000	0.0000;
	175	1	0	0	0	0	1	1.0802612	25.257031	220	4	1.11	0.95	100.9532	-1.9153	0.0000	0.0000;
	176	1	0	0	0	0	1	1.0802658	25.266041	220	4	1.11	0.95	100.9503	-1.9197	0.0000	0.0000;
	177	1	0	0	0	0	1	1.0817101	26.557252	220	4	1.11	0.95	100.4934	-2.2064	0.0000	0.0000;
	178	1	0	0	0	0	1	1.0817101	26.557252	220	4	1.11	0.95	100.4934	-2.2064	0.0000	0.0000;
	179	2	3.13	1.5	0	0	1	1.1099162	21.486859	220	4	1.11	0.95	105.1553	0.0000	0.0000	0.0000;
	180	1	0	0	0	0	1	1.0673522	19.657735	220	4	1.11	0.95	106.7210	0.8008	0.0000	0.0000;
	181	1	0	0	0	0	1	1.0732574	17.553962	220	5	1.11	0.95	107.4384	0.2064	0.0000	0.0000;
	182	1	0	0	0	0	1	1.0910728	16.004643	220	5	1.11	0.95	108.8386	-0.4811	0.0000	0.0000;
	183	1	0	0	0	0	1	1.0378187	17.132387	400	5	1.05	0.95	108.4907	-0.4744	0.0000	0.0000;
	184	1	0	0	0	0	1	1.0378411	17.130523	400	5	1.05	0.95	108.4921	-0.4746	0.0000	0.0000;
	185	1	0	0	0	0	1	1.0320725	19.082224	400	5	1.05	0.95	107.5507	0.1630	0.0000	0.0000;
	186	1	0	0	0	0	1	1.0320886	19.078437	400	5	1.05	0.95	107.5529	0.1627	0.0000	0.0000;
	187	1	0	0	0	0	1	1.0799827	14.890281	220	5	1.11	0.95	109.3264	0.2353	0.0000	0.0000;
	188	1	0	0	0	0	1	1.0800155	14.889078	220	5	1.11	0.95	109.3271	0.2342	0.0000	0.0000;
	189	1	0	0	0	0	1	1.075878	16.448322	220	5	1.11	0.95	107.5941	0.3848	0.0000	0.0000;
	190	1	0	0	0	0	1	1.0758447	16.450906	220	5	1.11	0.95	107.5949	0.3844	0.0000	0.0000;
	191	1	0	0	0	0	1	1.018295	20.502011	400	5	1.05	0.95	106.7351	0.4434	0.0000	0.0000;
	192	1	0	0	0	0	1	1.0770296	18.223772	220	5	1.11	0.95	107.1996	0.2301	0.0000	0.0000;
	193	1	0	0	0	0	1	1.0770074	18.226404	220	5	1.11	0.95	107.1982	0.2309	0.0000	0.0000;
	194	1	0	0	0	0	1	1.0326582	17.355132	400	5	1.05	0.95	108.4815	0.3003	0.0000	0.0000;
	195	1	0	0	0	0	1	1.0326384	17.350893	400	5	1.05	0.95	108.4841	0.3010	0.0000	0.0000;
	196	1	0	0	0	0	1	1.0748167	14.510003	220	5	1.11	0.95	109.8816	0.5588	0.0000	0.0000;
	197	1	0	0	0	0	1	1.074833	14.50988	220	5	1.11	0.95	109.8811	0.5586	0.0000	0.0000;
	198	1	0	0	0	-117	1	1.029285	18.184061	400	5	1.05	0.95	107.8538	-0.3758	0.0000	0.0000;
	199	1	0	0	0	0	1	1.0293306	18.17969	400	5	1.05	0.95	107.8567	-0.3766	0.0000	0.0000;
	200	1	0	0	0	0	1	1.0688896	16.199594	220	5	1.11	0.95	108.4342	0.6220	0.0000	0.0000;
	201	1	0	0	0	0	1	1.0688729	16.202922	220	5	1.11	0.95	108.4350	0.6227	0.0000	0.0000;
	202	1	0	0	0	0	1	1.0716109	17.886372	220	5	1.11	0.95	107.9103	0.7152	0.0000	0.0000;
	203	1	0	0	0	0	1	1.0715607	17.874031	220	5	1.11	0.95	107.9148	0.7153	0.0000	0.0000;
	204	2	0	0	0	0	1	1.0342258	20.333595	400	5	1.05	0.95	107.0336	-0.0006	0.0000	0.0000;
	205	2	0	0	0	0	1	1.0342303	20.334571	400	5	1.05	0.95	107.0337	0.0000	0.0000	0.0000;
	206	1	0	0	0	0	1	1.0867692	14.60567	220	5	1.11	0.95	109.8891	-0.5288	0.0000	0.0000;
	207	1	0	0	0	0	1	1.0867775	14.609789	220	5	1.11	0.95	109.8857	-0.5291	0.0000	0.0000;
	208	1	9.59	1	0	0	1	1.0888166	17.930099	110	1	1.12	0.95	108.3381	0.2777	0.0000	0.0000;
	209	1	4.795	0.5	0	0	1	1.0763513	10.051065	110	1	1.12	0.95	114.9045	0.2246	0.0000	0.0000;
	210	1	4.262	2	0	0	1	1.0944055	18.865464	110	1	1.12	0.95	105.4624	1.1041	0.0000	0.0000;
	211	1	6.5	5.4	0	0	1	1.0655484	17.232932	110	1	1.12	0.95	108.9990	2.0787	0.0000	0.0000;
	212	1	2.877	0.6	0	0	1	1.090314	35.891165	110	1	1.12	0.95	98.3759	0.1886	0.0000	0.0000;
	213	1	3.197	0.3	0	0	1	1.0968887	34.313591	110	1	1.12	0.95	98.4292	0.2878	0.0000	0.0000;
	214	2	21.711	12.3	0	0	1	1.1118352	17.616824	110	1	1.12	0.95	106.3528	0.0000	0.0000	0.0000;
	215	1	12.254	2	0	0	1	1.1129922	17.864133	110	1	1.12	0.95	106.0357	-0.0057	0.0000	0.0000;
	216	1	6.926	2	0	0	1	1.1125137	17.785716	110	1	1.12	0.95	106.1331	0.0014	0.0000	0.0000;
	217	1	10.655	1.5	0	0	1	1.1114167	17.495993	110	1	1.12	0.95	106.4693	0.0065	0.0000	0.0000;
	218	1	7.672	3	0	0	1	1.0812449	17.63771	110	1	1.12	0.95	107.8823	1.4420	0.0000	0.0000;
	219	1	8.524	2	0	0	1	1.081005	17.254656	110	1	1.12	0.95	107.7625	1.3996	0.0000	0.0000;
	220	2	0	0	0	0	1	1.1012585	20.703401	110	1	1.12	0.95	102.9820	-0.0000	0.0000	0.0000;
	221	2	6.606	2.1	0	0	1	1.0943315	28.897343	110	1	1.12	0.95	102.1784	0.1191	0.0000	0.0000;
	222	1	8.099	1.5	0	0	1	1.0912687	18.207913	110	1	1.12	0.95	106.3238	1.0409	0.0000	0.0000;
	223	1	0.746	0.1	0	0	1	1.0754351	34.329856	110	1	1.12	0.95	99.7831	0.4544	0.0000	0.0000;
	224	1	3.943	0.2	0	0	1	1.1051233	17.579856	110	1	1.12	0.95	106.6097	0.3462	0.0000	0.0000;
	225	1	3.197	0.5	0	0	1	1.0928473	13.186131	110	1	1.12	0.95	111.3766	0.0711	0.0000	0.0000;
	226	1	12.787	1	0	0	1	1.1035287	17.749421	110	1	1.12	0.95	107.3093	-0.0552	0.0000	0.0000;
	227	1	4.475	0.7	0	0	1	1.0926342	18.011529	110	1	1.12	0.95	106.4583	0.9337	0.0000	0.0000;
	228	1	4.262	0.7	0	0	1	1.092672	18.018912	110	1	1.12	0.95	106.4553	0.9331	0.0000	0.0000;
	229	1	2.451	0.98	0	0	1	1.1120912	29.310466	110	1	1.12	0.95	100.9712	0.2943	0.0000	0.0000;
	230	1	2.451	0.98	0	0	1	1.0943126	27.612219	110	1	1.12	0.95	102.6728	0.7299	0.0000	0.0000;
	231	1	5.327	1	0	0	1	1.0838177	17.940437	110	1	1.12	0.95	106.8773	1.2828	0.0000	0.0000;
	232	1	4.262	1	0	0	1	1.0970947	34.361997	110	1	1.12	0.95	98.3785	0.2918	0.0000	0.0000;
	233	1	9.057	0.4	0	0	1	1.0734703	26.634249	110	1	1.12	0.95	102.9378	-0.4753	0.0000	0.0000;
	234	1	31.966	28.001	0	0	1	1.0796816	35.051462	110	1	1.12	0.95	98.3864	0.5689	0.0000	0.0000;
	235	1	5.86	0.8	0	0	1	1.0868262	14.976994	110	1	1.12	0.95	110.1179	0.4119	0.0000	0.0000;
	236	1	8.631	2.94	0	0	1	1.1086811	29.751751	110	1	1.12	0.95	100.2155	0.5540	0.0000	0.0000;
	237	1	5.967	0.2	0	0	1	1.0862746	14.864574	110	1	1.12	0.95	110.2606	0.4057	0.0000	0.0000;
	238	1	5.328	0.5	0	0	1	1.093531	15.964334	110	1	1.12	0.95	109.1243	0.2496	0.0000	0.0000;
	239	2	0	0	0	0	1	1.0840654	16.48701	110	1	1.12	0.95	108.7679	1.0653	0.0000	0.0000;
	240	1	12.04	1	0	0	1	1.0860973	13.990755	110	1	1.12	0.95	110.3373	0.7135	0.0000	0.0000;
	241	1	3.836	1.18	0	0	1	1.1000107	28.4248	110	1	1.12	0.95	101.6194	0.6764	0.0000	0.0000;
	242	1	3.729	0.4	0	0	1	1.1139775	31.554359	110	1	1.12	0.95	98.9178	-0.2346	0.0000	0.0000;
	243	1	3.729	0.4	0	0	1	1.1140714	31.567922	110	1	1.12	0.95	98.9136	-0.2315	0.0000	0.0000;
	244	1	2.131	1.1	0	0	1	1.1061558	17.474939	110	1	1.12	0.95	107.7712	0.0149	0.0000	0.0000;
	245	1	0	0	0	0	1	1.0983181	36.948163	110	1	1.12	0.95	97.6738	0.0465	0.0000	0.0000;
	246	2	0	5	0	0	1	1.0790447	40.237314	22	1	1.12	0.95	97.9055	-0.0000	0.0000	0.0000;
	247	1	7.458	1	0	0	1	1.0886183	11.969282	110	1	1.12	0.95	112.6771	0.1192	0.0000	0.0000;
	248	1	2.131	0	0	0	1	1.0888205	11.820712	110	1	1.12	0.95	111.5455	0.2852	0.0000	0.0000;
	249	1	2.131	0	0	0	1	1.0955405	12.787709	110	1	1.12	0.95	111.3188	0.0353	0.0000	0.0000;
	250	1	2.664	0.5	0	0	1	1.0656001	8.6138542	110	1	1.12	0.95	118.1059	-0.0131	0.0000	0.0000;
	251	1	3.516	0.1	0	0	1	1.1080612	18.866915	110	1	1.12	0.95	105.3977	0.2954	0.0000	0.0000;
	252	1	11.721	5.4	0	0	1	1.0885084	22.800938	110	1	1.12	0.95	103.6253	0.7883	0.0000	0.0000;
	253	1	11.721	4	0	0	1	1.0850344	17.911044	110	1	1.12	0.95	106.8505	1.2318	0.0000	0.0000;
	254	1	10.122	1	0	0	1	1.0778039	10.575275	110	1	1.12	0.95	113.3108	0.4860	0.0000	0.0000;
	255	1	12.787	1.5	0	0	1	1.095206	13.351182	110	1	1.12	0.95	110.8171	0.1575	0.0000	0.0000;
	256	1	4.795	0	0	0	1	1.0954886	13.191103	110	1	1.12	0.95	110.9039	0.1461	0.0000	0.0000;
	257	1	3.197	0.65	0	0	1	1.0900687	35.741435	110	1	1.12	0.95	98.8092	0.2119	0.0000	0.0000;
	258	1	3.197	0.65	0	0	1	1.0900172	35.729503	110	1	1.12	0.95	98.8135	0.2127	0.0000	0.0000;
	259	1	7.992	2.47	0	0	1	1.1039829	28.588006	110	1	1.12	0.95	101.8938	0.4934	0.0000	0.0000;
	260	1	4.795	0	0	0	1	1.0647876	8.2670221	110	1	1.12	0.95	118.5529	-0.0999	0.0000	0.0000;
	261	1	8.098	1.5	0	0	1	1.0892538	18.399241	110	1	1.12	0.95	106.3940	1.2363	0.0000	0.0000;
	262	1	0	0	0	0	1	1.08791	19.323527	110	1	1.12	0.95	105.7274	1.0744	0.0000	0.0000;
	263	1	1.279	1	0	0	1	1.0846324	14.362844	110	1	1.12	0.95	110.6104	0.4644	0.0000	0.0000;
	264	1	25.574	22	0	0	1	1.0967395	36.708239	110	1	1.12	0.95	97.7521	0.0829	0.0000	0.0000;
	265	1	34.097	30	0	0	1	1.0890012	34.374325	110	1	1.12	0.95	98.3746	0.4827	0.0000	0.0000;
	266	1	27.704	0.8	0	0	1	1.1007233	36.847165	110	1	1.12	0.95	97.7278	-0.0657	0.0000	0.0000;
	267	1	1.066	0	0	0	1	1.0833557	18.096812	110	1	1.12	0.95	106.7609	1.3259	0.0000	0.0000;
	268	1	9.59	0.8	0	0	1	1.0851905	17.171262	110	1	1.12	0.95	107.9081	0.7898	0.0000	0.0000;
	269	1	5.967	2	0	0	1	1.1114105	19.185973	110	1	1.12	0.95	105.0311	0.1993	0.0000	0.0000;
	270	1	9.057	1.5	0	0	1	1.1022215	17.329415	110	1	1.12	0.95	107.7608	-0.0569	0.0000	0.0000;
	271	1	6.393	0.5	0	0	1	1.0663813	8.9665841	110	1	1.12	0.95	117.6812	0.0605	0.0000	0.0000;
	272	1	7.885	1.85	0	0	1	1.0833853	18.135283	110	1	1.12	0.95	106.7596	1.3745	0.0000	0.0000;
	273	1	0.426	0.1	0	0	1	1.0792157	17.625822	110	1	1.12	0.95	108.0473	1.5545	0.0000	0.0000;
	274	1	0.213	0.06	0	0	1	1.0900879	18.338658	110	1	1.12	0.95	106.1249	1.2102	0.0000	0.0000;
	275	1	0	0	0	0	1	1.0889678	18.159177	110	1	1.12	0.95	106.2866	1.2612	0.0000	0.0000;
	276	1	11.401	5.18	0	0	1	1.1150578	30.135091	110	1	1.12	0.95	100.1467	0.4513	0.0000	0.0000;
	277	1	0	0	0	0	1	1.1084132	29.441744	110	1	1.12	0.95	100.2703	0.5394	0.0000	0.0000;
	278	1	5.328	1.4	0	0	1	1.0968772	29.110755	110	1	1.12	0.95	101.7963	0.0741	0.0000	0.0000;
	279	1	2.131	0.5	0	0	1	1.1069276	16.811099	110	1	1.12	0.95	107.4812	0.0233	0.0000	0.0000;
	280	1	5.328	0.5	0	0	1	1.0992968	15.812566	110	1	1.12	0.95	109.0530	0.0871	0.0000	0.0000;
	281	1	5.328	1	0	0	1	1.0926239	18.465624	110	1	1.12	0.95	105.9008	1.1420	0.0000	0.0000;
	282	1	5.328	1	0	0	1	1.092756	19.359052	110	1	1.12	0.95	105.6253	0.8809	0.0000	0.0000;
	283	1	14.918	12	0	0	1	1.0788213	34.359675	110	1	1.12	0.95	98.5469	0.6363	0.0000	0.0000;
	284	1	37.294	33	0	0	1	1.0785542	34.364478	110	1	1.12	0.95	98.5509	0.6394	0.0000	0.0000;
	285	1	1.386	0.4	0	0	1	1.1044943	36.735701	110	1	1.12	0.95	97.7556	-0.4027	0.0000	0.0000;
	286	1	0	0	0	0	1	1.0986013	36.715258	110	1	1.12	0.95	97.7198	0.0402	0.0000	0.0000;
	287	1	8.525	2.9	0	0	1	1.115557	30.326573	110	1	1.12	0.95	99.9826	0.4791	0.0000	0.0000;
	288	1	7.459	2	0	0	1	1.1097537	29.572175	110	1	1.12	0.95	100.7916	0.5612	0.0000	0.0000;
	289	1	6.926	0.5	0	0	1	1.0905924	13.708256	110	1	1.12	0.95	111.2699	0.1398	0.0000	0.0000;
	290	1	4.795	0	0	0	1	1.1050274	15.883572	110	1	1.12	0.95	108.0311	0.1144	0.0000	0.0000;
	291	1	3.729	2.5	0	0	1	1.0845059	17.25446	110	1	1.12	0.95	107.9124	1.1278	0.0000	0.0000;
	292	1	2.344	0.2	0	0	1	1.0978273	27.050252	110	1	1.12	0.95	103.1786	0.4493	0.0000	0.0000;
	293	1	11.402	4.1	0	0	1	1.0934149	19.430047	110	1	1.12	0.95	105.5382	0.8674	0.0000	0.0000;
	294	1	8.311	1.5	0	0	1	1.0900309	18.418866	110	1	1.12	0.95	106.1755	1.2228	0.0000	0.0000;
	295	1	4.902	1.51	0	0	1	1.1173899	30.590613	110	1	1.12	0.95	99.6830	0.4629	0.0000	0.0000;
	296	1	1.704	1.4	0	0	1	1.0896499	20.4236	110	1	1.12	0.95	105.1630	0.7839	0.0000	0.0000;
	297	1	4.582	0.5	0	0	1	1.0821362	16.826872	110	1	1.12	0.95	108.5430	0.8375	0.0000	0.0000;
	298	1	7.672	0.8	0	0	1	1.0964546	26.985327	110	1	1.12	0.95	103.2966	0.4990	0.0000	0.0000;
	299	1	4.262	0.7	0	0	1	1.1058044	29.637653	110	1	1.12	0.95	100.8875	0.0854	0.0000	0.0000;
	300	1	6.18	2.11	0	0	1	1.110566	29.286063	110	1	1.12	0.95	100.9817	0.3499	0.0000	0.0000;
	301	1	8.205	2.53	0	0	1	1.0936642	27.562771	110	1	1.12	0.95	102.7397	0.7492	0.0000	0.0000;
	302	1	8.524	0.5	0	0	1	1.1090796	17.4445	110	1	1.12	0.95	106.7655	0.0142	0.0000	0.0000;
	303	1	0	0	0	0	1	1.1086778	29.437585	110	1	1.12	0.95	100.2704	0.5248	0.0000	0.0000;
	304	1	4.049	1.5	0	0	1	1.0697496	33.774693	110	1	1.12	0.95	100.5325	0.5772	0.0000	0.0000;
	305	1	7.992	2.72	0	0	1	1.1174004	30.594184	110	1	1.12	0.95	99.6793	0.4634	0.0000	0.0000;
	306	1	7.779	2.4	0	0	1	1.1003819	28.478755	110	1	1.12	0.95	101.5456	0.6748	0.0000	0.0000;
	307	1	13.746	4.24	0	0	1	1.1148589	30.145937	110	1	1.12	0.95	100.1537	0.4687	0.0000	0.0000;
	308	1	12.254	3.78	0	0	1	1.1108519	29.231315	110	1	1.12	0.95	101.0487	0.3232	0.0000	0.0000;
	309	2	14.147	9.046	0	0	1	1.109326	29.572565	110	1	1.12	0.95	100.5960	0.4579	0.0000	0.0000;
	310	2	11.759	7	0	0	1	1.1118607	29.261004	110	1	1.12	0.95	101.0131	0.2846	0.0000	0.0000;
	311	2	15.573	8.3	0	0	1	1.0971805	27.960525	110	1	1.12	0.95	102.2436	0.6692	0.0000	0.0000;
	312	1	0	0	0	0	1	1.1106712	29.265999	110	1	1.12	0.95	101.0067	0.3395	0.0000	0.0000;
	313	2	10.354	5.48	0	0	1	1.1155075	30.132234	110	1	1.12	0.95	100.1466	0.4246	0.0000	0.0000;
	314	2	6.18	5.15	0	0	1	1.1064786	29.492707	110	1	1.12	0.95	100.3977	0.6172	0.0000	0.0000;
	315	1	8.525	1.2	0	0	1	1.097328	27.336383	110	1	1.12	0.95	102.9287	0.5474	0.0000	0.0000;
	316	1	2.131	0.5	0	0	1	1.1049384	17.287793	110	1	1.12	0.95	107.4558	-0.1016	0.0000	0.0000;
	317	1	4.794	1.5	0	0	1	1.0811616	16.656864	110	1	1.12	0.95	108.5690	1.2503	0.0000	0.0000;
	318	1	3.996	1.25	0	0	1	1.0818273	16.490006	110	1	1.12	0.95	108.7930	1.1805	0.0000	0.0000;
	319	1	6.127	1.25	0	0	1	1.0817721	16.492949	110	1	1.12	0.95	108.7903	1.1808	0.0000	0.0000;
	320	1	6.926	2.5	0	0	1	1.0892829	18.455761	110	1	1.12	0.95	106.0968	1.2303	0.0000	0.0000;
	321	1	8.205	2.53	0	0	1	1.1153908	30.254283	110	1	1.12	0.95	100.0324	0.4749	0.0000	0.0000;
	322	2	14.598	4.51	0	0	1	1.1139769	30.001341	110	1	1.12	0.95	100.3025	0.4638	0.0000	0.0000;
	323	1	12.787	1.5	0	0	1	1.0975569	15.565517	110	1	1.12	0.95	109.4417	0.1012	0.0000	0.0000;
	324	1	13.959	4.76	0	0	1	1.1065538	29.51494	110	1	1.12	0.95	100.3897	0.6147	0.0000	0.0000;
	325	1	5.967	1.84	0	0	1	1.108802	29.531824	110	1	1.12	0.95	100.6460	0.4725	0.0000	0.0000;
	326	1	5.967	1.84	0	0	1	1.1091726	29.466711	110	1	1.12	0.95	100.7332	0.4450	0.0000	0.0000;
	327	1	7.459	1	0	0	1	1.0989807	15.778859	110	1	1.12	0.95	109.1187	0.0915	0.0000	0.0000;
	328	1	13.852	3	0	0	1	1.0821851	17.179478	110	1	1.12	0.95	108.3906	1.0377	0.0000	0.0000;
	329	1	9.057	2.8	0	0	1	1.1091807	29.463542	110	1	1.12	0.95	100.7368	0.4445	0.0000	0.0000;
	330	1	5.328	2	0	0	1	1.1064358	29.475351	110	1	1.12	0.95	100.7850	0.3157	0.0000	0.0000;
	331	1	3.197	1	0	0	1	1.106047	29.430653	110	1	1.12	0.95	100.8602	0.2953	0.0000	0.0000;
	332	1	26.852	8.29	0	0	1	1.1127952	29.937803	110	1	1.12	0.95	100.3845	0.5063	0.0000	0.0000;
	333	1	7.459	1	0	0	1	1.0912164	24.701894	110	1	1.12	0.95	102.2449	0.0270	0.0000	0.0000;
	334	1	2.664	0.8	0	0	1	1.1026807	28.491161	110	1	1.12	0.95	102.0885	0.5191	0.0000	0.0000;
	335	1	5.86	0.8	0	0	1	1.0814444	17.116472	110	1	1.12	0.95	108.5126	1.0519	0.0000	0.0000;
	336	1	5.434	0.2	0	0	1	1.0823415	13.421735	110	1	1.12	0.95	110.9120	1.0025	0.0000	0.0000;
	337	1	7.352	2.27	0	0	1	1.1020343	28.731485	110	1	1.12	0.95	101.2655	0.6526	0.0000	0.0000;
	338	1	7.459	2.7	0	0	1	1.0894284	16.001245	110	1	1.12	0.95	109.3463	0.3928	0.0000	0.0000;
	339	1	9.59	2.7	0	0	1	1.0887891	18.261289	110	1	1.12	0.95	106.2745	1.2510	0.0000	0.0000;
	340	1	9.59	2.7	0	0	1	1.0758718	17.555759	110	1	1.12	0.95	107.7210	1.5130	0.0000	0.0000;
	341	1	2.664	0.5	0	0	1	1.1070738	17.340122	110	1	1.12	0.95	107.1642	-0.0849	0.0000	0.0000;
	342	1	0	0	0	0	1	1.0962765	18.767314	110	1	1.12	0.95	105.4764	1.0372	0.0000	0.0000;
	343	1	0	0	0	0	1	1.1018629	20.113718	110	1	1.12	0.95	104.6287	0.6185	0.0000	0.0000;
	344	1	11.188	4	0	0	1	1.0891147	20.3213	110	1	1.12	0.95	105.4990	0.7813	0.0000	0.0000;
	345	1	11.188	3.5	0	0	1	1.0892454	20.316005	110	1	1.12	0.95	105.4875	0.7845	0.0000	0.0000;
	346	1	0	0	0	0	1	1.096487	18.763069	110	1	1.12	0.95	105.4766	1.0216	0.0000	0.0000;
	347	1	3.729	0.5	0	0	1	1.0725538	10.358287	110	1	1.12	0.95	113.6714	0.7163	0.0000	0.0000;
	348	1	5.328	1	0	0	1	1.092721	16.715926	110	1	1.12	0.95	109.0741	0.5669	0.0000	0.0000;
	349	1	6.926	0.4	0	0	1	1.0827192	13.738226	110	1	1.12	0.95	111.0946	0.5304	0.0000	0.0000;
	350	1	11.614	3.59	0	0	1	1.1170831	30.564704	110	1	1.12	0.95	99.7223	0.4702	0.0000	0.0000;
	351	1	7.672	1.8	0	0	1	1.0825148	17.673573	110	1	1.12	0.95	107.1641	1.4370	0.0000	0.0000;
	352	1	0	0	0	0	1	1.0937702	18.717293	110	1	1.12	0.95	105.6135	1.1146	0.0000	0.0000;
	353	1	4.262	1	0	0	1	1.0999503	15.189283	110	1	1.12	0.95	109.1964	0.1296	0.0000	0.0000;
	354	1	0	0	0	0	1	1.088846	18.568889	110	1	1.12	0.95	105.9810	1.2617	0.0000	0.0000;
	355	1	1.066	0.3	0	0	1	1.0873727	18.648961	110	1	1.12	0.95	105.9690	1.2654	0.0000	0.0000;
	356	1	0	0	0	0	1	1.0875699	18.677241	110	1	1.12	0.95	105.9503	1.2641	0.0000	0.0000;
	357	1	0	0	0	0	1	1.0873622	18.646901	110	1	1.12	0.95	105.9704	1.2655	0.0000	0.0000;
	358	1	6.393	1.9	0	0	1	1.0884634	20.265545	110	1	1.12	0.95	105.4479	0.8059	0.0000	0.0000;
	359	1	6.926	2.5	0	0	1	1.0785867	17.547796	110	1	1.12	0.95	108.1500	1.5744	0.0000	0.0000;
	360	1	9.057	1.2	0	0	1	1.0921222	18.042965	110	1	1.12	0.95	106.6079	0.6721	0.0000	0.0000;
	361	1	0	0	0	0	1	1.10063	19.205351	110	1	1.12	0.95	104.9056	0.9258	0.0000	0.0000;
	362	1	0	0	0	0	1	1.1001956	19.161474	110	1	1.12	0.95	104.9321	0.9312	0.0000	0.0000;
	363	1	5.861	0.8	0	0	1	1.0716895	26.09511	110	1	1.12	0.95	103.2231	-0.8179	0.0000	0.0000;
	364	1	4.156	0.8	0	0	1	1.1049361	17.306531	110	1	1.12	0.95	107.9685	0.0277	0.0000	0.0000;
	365	2	53.277	10	0	0	1	1.1119447	19.109136	110	1	1.12	0.95	105.1480	0.1215	0.0000	0.0000;
	366	2	53.277	10	0	0	1	1.0922113	17.713646	110	1	1.12	0.95	106.9522	0.5644	0.0000	0.0000;
	367	2	53.277	10	0	0	1	1.1187323	19.901484	110	1	1.12	0.95	104.2165	0.0000	0.0000	0.0000;
	368	2	53.277	10	0	0	1	1.1111137	19.081815	110	1	1.12	0.95	106.1289	0.5321	0.0000	0.0000;
	369	1	0	0	0	0	1	1.12	18.906275	110	1	1.12	0.95	104.8660	-0.1376	746.3077	0.0000;
	370	1	8.524	0.8	0	0	1	1.0836579	15.874025	110	1	1.12	0.95	109.4071	0.9147	0.0000	0.0000;
	371	1	17.048	1	0	0	1	1.0882143	15.211988	110	1	1.12	0.95	109.8237	0.4103	0.0000	0.0000;
	372	1	4.262	1	0	0	1	1.0772135	12.553552	110	1	1.12	0.95	113.1991	0.5260	0.0000	0.0000;
	373	1	0	0	0	0	1	1.0953978	15.169591	110	1	1.12	0.95	110.0700	0.0686	0.0000	0.0000;
	374	1	11.721	3.1	0	0	1	1.0821949	16.351549	110	1	1.12	0.95	109.0644	1.1295	0.0000	0.0000;
	375	1	2.664	0.7	0	0	1	1.1091155	29.49798	110	1	1.12	0.95	100.8766	0.5725	0.0000	0.0000;
	376	1	2.664	0.7	0	0	1	1.1026527	28.443375	110	1	1.12	0.95	100.8883	0.5411	0.0000	0.0000;
	377	1	6.393	1.5	0	0	1	1.0769854	10.538922	110	1	1.12	0.95	115.1345	0.1794	0.0000	0.0000;
	378	1	6.607	0.4	0	0	1	1.0833934	13.88009	110	1	1.12	0.95	110.9256	0.5102	0.0000	0.0000;
	379	1	5.86	1.2	0	0	1	1.0739702	26.752684	110	1	1.12	0.95	102.8461	-0.4325	0.0000	0.0000;
	380	1	4.795	0.8	0	0	1	1.0740079	26.736083	110	1	1.12	0.95	102.8417	-0.4336	0.0000	0.0000;
	381	1	2.131	1	0	0	1	1.0827573	16.382176	110	1	1.12	0.95	108.9748	1.1060	0.0000	0.0000;
	382	1	10.655	2.1	0	0	1	1.1048396	17.445955	110	1	1.12	0.95	107.8730	0.0714	0.0000	0.0000;
	383	1	7.459	1.8	0	0	1	1.1058697	17.475803	110	1	1.12	0.95	107.7668	0.0286	0.0000	0.0000;
	384	1	12.254	3.5	0	0	1	1.0908721	15.705998	110	1	1.12	0.95	109.5150	0.2947	0.0000	0.0000;
	385	2	0	0	0	0	1	1.1073564	17.637812	110	1	1.12	0.95	107.5853	0.0000	0.0000	0.0015;
	386	2	0	0	0	0	1	1.1024838	15.781836	110	1	1.12	0.95	108.7789	0.0000	0.0000	0.0000;
	387	1	2.131	0.5	0	0	1	1.0979925	14.478532	110	1	1.12	0.95	109.8319	0.1444	0.0000	0.0000;
	388	1	7.779	2.8	0	0	1	1.0930522	18.510523	110	1	1.12	0.95	105.8450	1.1327	0.0000	0.0000;
	389	1	11.934	3.68	0	0	1	1.0944974	27.29709	110	1	1.12	0.95	103.0156	0.6572	0.0000	0.0000;
	390	1	6.394	2	0	0	1	1.0887198	18.462614	110	1	1.12	0.95	106.0989	1.2405	0.0000	0.0000;
	391	1	12.36	4.94	0	0	1	1.1182873	30.663522	110	1	1.12	0.95	99.5959	0.4394	0.0000	0.0000;
	392	1	2.131	0.73	0	0	1	1.1123844	30.080222	110	1	1.12	0.95	99.8585	0.4431	0.0000	0.0000;
	393	1	0	0	0	0	1	1.0982826	34.545334	110	1	1.12	0.95	98.1807	0.2858	0.0000	0.0000;
	394	1	0	0	0	0	1	1.0985644	36.717702	110	1	1.12	0.95	97.7193	0.0440	0.0000	0.0000;
	395	1	3.729	0.3	0	0	1	1.108148	18.864108	110	1	1.12	0.95	106.3615	0.6240	0.0000	0.0000;
	396	1	1.066	0	0	0	1	1.0964649	16.468357	110	1	1.12	0.95	108.8684	0.2057	0.0000	0.0000;
	397	1	4.262	1.2	0	0	1	1.1093176	28.911743	110	1	1.12	0.95	101.1390	0.1077	0.0000	0.0000;
	398	1	4.262	1	0	0	1	1.0934458	18.285536	110	1	1.12	0.95	106.3089	0.6834	0.0000	0.0000;
	399	1	0	0	0	0	1	1.1113699	19.235775	110	1	1.12	0.95	105.9609	0.5684	0.0000	0.0000;
	400	1	3.836	1	0	0	1	1.1124238	19.260452	110	1	1.12	0.95	104.9458	0.1651	0.0000	0.0000;
	401	1	2.065	0.92	0	0	1	1.0896574	17.813614	110	1	1.12	0.95	106.9755	0.7462	0.0000	0.0000;
	402	1	4.262	1	0	0	1	1.0855065	17.604808	110	1	1.12	0.95	107.5044	1.1168	0.0000	0.0000;
	403	1	3.197	0.3	0	0	1	1.0712893	25.838908	110	1	1.12	0.95	103.2061	-1.1420	0.0000	0.0000;
	404	1	27.172	7	0	0	1	1.0922543	18.609528	110	1	1.12	0.95	105.9233	1.1662	0.0000	0.0000;
	405	1	22.909	6.601	0	0	1	1.0877271	19.32865	110	1	1.12	0.95	105.7272	1.0933	0.0000	0.0000;
	406	1	7.459	1	0	0	1	1.1017689	32.974451	110	1	1.12	0.95	98.5474	0.0561	0.0000	0.0000;
	407	1	6.393	1	0	0	1	1.0797234	34.905993	110	1	1.12	0.95	99.1400	0.3951	0.0000	0.0000;
	408	1	7.459	1	0	0	1	1.0829924	12.889512	110	1	1.12	0.95	112.3476	0.3169	0.0000	0.0000;
	409	1	5.754	1.4	0	0	1	1.1012096	33.101943	110	1	1.12	0.95	98.5276	0.0889	0.0000	0.0000;
	410	1	10.229	0.5	0	0	1	1.0924407	18.115557	110	1	1.12	0.95	106.5189	0.6805	0.0000	0.0000;
	411	1	6.713	0.8	0	0	1	1.0876239	22.2082	110	1	1.12	0.95	104.1779	0.7999	0.0000	0.0000;
	412	1	2.557	0.5	0	0	1	1.0899952	17.836705	110	1	1.12	0.95	106.9438	0.7346	0.0000	0.0000;
	413	1	0	0	0	0	1	1.12	20.055405	110	1	1.12	0.95	104.0388	-0.0181	1291.4394	0.0000;
	414	1	0	0	0	0	1	1.0925659	17.991862	110	1	1.12	0.95	106.6556	0.6312	0.0000	0.0000;
	415	1	11.188	1.5	0	0	1	1.081629	35.041326	110	1	1.12	0.95	99.0290	0.3433	0.0000	0.0000;
	416	1	7.459	0.2	0	0	1	1.0821314	16.332457	110	1	1.12	0.95	109.0909	1.1204	0.0000	0.0000;
	417	1	6.926	0.8	0	0	1	1.0929266	18.200986	110	1	1.12	0.95	106.4118	0.6838	0.0000	0.0000;
	418	1	16.516	2	0	0	1	1.0895389	16.88045	110	1	1.12	0.95	108.5563	0.9588	0.0000	0.0000;
	419	1	3.197	0.8	0	0	1	1.1097214	28.932893	110	1	1.12	0.95	101.0885	0.0943	0.0000	0.0000;
	420	1	5.221	0.8	0	0	1	1.1033462	17.341774	110	1	1.12	0.95	108.0371	0.1193	0.0000	0.0000;
	421	1	14.918	4.2	0	0	1	1.0779171	17.766469	110	1	1.12	0.95	107.3346	1.5101	0.0000	0.0000;
	422	1	14.918	4.2	0	0	1	1.0778691	17.758171	110	1	1.12	0.95	107.3382	1.5108	0.0000	0.0000;
	423	1	5.328	1	0	0	1	1.0833235	18.029207	110	1	1.12	0.95	106.8208	1.3163	0.0000	0.0000;
	424	1	8.737	2.7	0	0	1	1.0834043	18.16779	110	1	1.12	0.95	106.6971	1.3356	0.0000	0.0000;
	425	1	8.098	1.7	0	0	1	1.0896772	14.917065	110	1	1.12	0.95	110.0833	0.2934	0.0000	0.0000;
	426	1	7.459	0.499	0	0	1	1.0872979	16.453054	110	1	1.12	0.95	109.3975	0.8861	0.0000	0.0000;
	427	1	8.524	0.3	0	0	1	1.082992	18.088815	110	1	1.12	0.95	107.0082	1.2186	0.0000	0.0000;
	428	1	5.328	2	0	0	1	1.0842798	18.315538	110	1	1.12	0.95	106.5177	1.3267	0.0000	0.0000;
	429	1	9.91	3.06	0	0	1	1.1163184	30.493595	110	1	1.12	0.95	99.8112	0.4869	0.0000	0.0000;
	430	1	0	0	0	0	1	1.1163234	30.492996	110	1	1.12	0.95	99.8114	0.4868	0.0000	0.0000;
	431	1	7.672	1.2	0	0	1	1.081199	34.689451	110	1	1.12	0.95	99.9783	0.3698	0.0000	0.0000;
	432	1	4.688	0.3	0	0	1	1.0914726	18.035931	110	1	1.12	0.95	106.6711	0.7120	0.0000	0.0000;
	433	1	6.926	2.2	0	0	1	1.0888245	27.135816	110	1	1.12	0.95	102.8092	0.6676	0.0000	0.0000;
	434	1	8.311	1	0	0	1	1.1009728	17.238342	110	1	1.12	0.95	107.3666	0.3066	0.0000	0.0000;
	435	1	5.541	1.71	0	0	1	1.1123586	29.487113	110	1	1.12	0.95	100.8296	0.3384	0.0000	0.0000;
	436	1	5.86	2	0	0	1	1.0754308	17.555555	110	1	1.12	0.95	107.9550	1.4824	0.0000	0.0000;
	437	1	4.262	1.7	0	0	1	1.083956	15.573193	110	1	1.12	0.95	110.4098	0.5627	0.0000	0.0000;
	438	1	16.516	3	0	0	1	1.0801964	34.586974	110	1	1.12	0.95	100.1061	0.3901	0.0000	0.0000;
	439	1	0	0	0	0	1	1.0937512	29.812234	110	1	1.12	0.95	100.6851	-0.2583	0.0000	0.0000;
	440	1	8.525	0.5	0	0	1	1.0663961	8.9384259	110	1	1.12	0.95	117.6216	0.0755	0.0000	0.0000;
	441	1	2.131	0.3	0	0	1	1.0978117	36.827957	110	1	1.12	0.95	97.7109	0.0582	0.0000	0.0000;
	442	1	2.664	0.4	0	0	1	1.0977405	36.818601	110	1	1.12	0.95	97.7128	0.0595	0.0000	0.0000;
	443	2	4.263	1.5	0	0	1	1.0808287	34.646657	110	1	1.12	0.95	100.0280	0.3760	0.0000	0.0000;
	444	1	2.664	0.3	0	0	1	1.0721308	33.971905	110	1	1.12	0.95	100.2606	0.5137	0.0000	0.0000;
	445	1	2.77	0.94	0	0	1	1.1105941	29.772186	110	1	1.12	0.95	100.2793	0.4590	0.0000	0.0000;
	446	1	12.467	3.85	0	0	1	1.1090101	29.049413	110	1	1.12	0.95	101.3074	0.3742	0.0000	0.0000;
	447	1	4.795	0.5	0	0	1	1.109508	30.524725	110	1	1.12	0.95	100.0710	-0.0627	0.0000	0.0000;
	448	1	2.557	0.8	0	0	1	1.0868686	26.257162	110	1	1.12	0.95	103.0102	0.4801	0.0000	0.0000;
	449	1	6.393	1.8	0	0	1	1.1051545	29.070405	110	1	1.12	0.95	101.3204	0.1402	0.0000	0.0000;
	450	2	0	0	0	0	1	1.0907525	20.536257	110	1	1.12	0.95	104.9704	0.7549	0.0000	0.0000;
	451	1	4.476	0	0	0	1	1.0916318	21.150364	110	1	1.12	0.95	104.4655	0.6755	0.0000	0.0000;
	452	2	6.819	0.4	0	0	1	1.0928766	21.804103	110	1	1.12	0.95	103.9109	0.5886	0.0000	0.0000;
	453	1	3.197	0.5	0	0	1	1.064662	8.7987374	110	1	1.12	0.95	118.0877	0.0459	0.0000	0.0000;
	454	1	4.262	1.5	0	0	1	1.0846958	16.421766	110	1	1.12	0.95	109.0550	1.0236	0.0000	0.0000;
	455	1	14.918	4	0	0	1	1.0865892	18.879149	110	1	1.12	0.95	106.0127	1.2052	0.0000	0.0000;
	456	1	1.492	0.2	0	0	1	1.11432	31.359225	110	1	1.12	0.95	99.0832	-0.1782	0.0000	0.0000;
	457	1	9.59	2.4	0	0	1	1.1036456	28.932561	110	1	1.12	0.95	101.5332	0.6888	0.0000	0.0000;
	458	1	7.459	1.7	0	0	1	1.0843581	17.218014	110	1	1.12	0.95	107.4561	1.1512	0.0000	0.0000;
	459	1	10.016	1.8	0	0	1	1.0997236	19.881499	110	1	1.12	0.95	104.8935	0.6903	0.0000	0.0000;
	460	1	7.459	0.401	0	0	1	1.0820515	16.734925	110	1	1.12	0.95	108.5542	0.8251	0.0000	0.0000;
	461	1	4.262	1	0	0	1	1.095863	26.929025	110	1	1.12	0.95	103.3692	0.5126	0.0000	0.0000;
	462	1	11.188	1.5	0	0	1	1.0851716	18.380711	110	1	1.12	0.95	108.1384	0.3890	0.0000	0.0000;
	463	1	6.393	3	0	0	1	1.0943288	25.210811	110	1	1.12	0.95	101.9632	0.0090	0.0000	0.0000;
	464	1	6.926	1.5	0	0	1	1.0953998	18.311516	110	1	1.12	0.95	106.0964	0.8707	0.0000	0.0000;
	465	1	7.459	1.6	0	0	1	1.0954379	18.331135	110	1	1.12	0.95	106.0899	0.8705	0.0000	0.0000;
	466	1	12.68	5.4	0	0	1	1.0840634	18.679433	110	1	1.12	0.95	106.8257	0.9697	0.0000	0.0000;
	467	1	10.656	1.2	0	0	1	1.0978323	28.985057	110	1	1.12	0.95	101.8276	0.1011	0.0000	0.0000;
	468	1	6.394	0.5	0	0	1	1.1081021	18.072298	110	1	1.12	0.95	106.0625	0.2822	0.0000	0.0000;
	469	1	6.18	1.91	0	0	1	1.1092629	29.788134	110	1	1.12	0.95	100.1477	0.5345	0.0000	0.0000;
	470	1	2.984	1	0	0	1	1.0944641	24.979385	110	1	1.12	0.95	101.9821	-0.0072	0.0000	0.0000;
	471	1	4.156	1.28	0	0	1	1.105639	28.739026	110	1	1.12	0.95	101.7012	0.4540	0.0000	0.0000;
	472	1	2.025	0.1	0	0	1	1.1010698	18.084005	110	1	1.12	0.95	107.2193	0.7489	0.0000	0.0000;
	473	1	3.197	0.5	0	0	1	1.0773032	34.580349	110	1	1.12	0.95	99.5037	0.4286	0.0000	0.0000;
	474	1	13.319	1	0	0	1	1.0678034	9.0159724	110	1	1.12	0.95	117.1733	0.1402	0.0000	0.0000;
	475	1	1.066	0.5	0	0	1	1.0888084	20.285221	110	1	1.12	0.95	105.5520	0.7847	0.0000	0.0000;
	476	1	1.066	0.5	0	0	1	1.0961327	19.65279	110	1	1.12	0.95	105.2534	0.7882	0.0000	0.0000;
	477	1	7.992	1.5	0	0	1	1.086193	11.4646	110	1	1.12	0.95	112.1772	0.2955	0.0000	0.0000;
	478	1	2.984	0.2	0	0	1	1.1043653	18.626355	110	1	1.12	0.95	105.6763	0.4361	0.0000	0.0000;
	479	1	2.344	0.5	0	0	1	1.0712316	25.770773	110	1	1.12	0.95	103.0835	-1.3429	0.0000	0.0000;
	480	1	12.254	5	0	0	1	1.0824331	18.002691	110	1	1.12	0.95	107.3487	1.5125	0.0000	0.0000;
	481	1	16.729	5.17	0	0	1	1.0950557	27.734832	110	1	1.12	0.95	102.5322	0.7195	0.0000	0.0000;
	482	1	5.86	1	0	0	1	1.089432	18.012542	110	1	1.12	0.95	106.8710	1.0930	0.0000	0.0000;
	483	1	2.131	0.5	0	0	1	1.0841134	13.669277	110	1	1.12	0.95	110.6661	0.8521	0.0000	0.0000;
	484	1	2.131	0	0	0	1	1.0717061	17.402877	110	1	1.12	0.95	108.3930	1.6807	0.0000	0.0000;
	485	2	4.795	0.6	0	0	1	1.0731501	34.040104	110	1	1.12	0.95	100.1099	0.4896	0.0000	0.0000;
	486	1	4.475	0.6	0	0	1	1.0834579	29.625447	110	1	1.12	0.95	101.1420	-0.0522	0.0000	0.0000;
	487	1	5.328	1.2	0	0	1	1.0714355	33.921906	110	1	1.12	0.95	100.3567	0.5315	0.0000	0.0000;
	488	1	5.647	1.3	0	0	1	1.0826447	29.563962	110	1	1.12	0.95	101.2442	-0.0308	0.0000	0.0000;
	489	1	19.18	7	0	0	1	1.1159998	31.728819	110	1	1.12	0.95	98.7314	-0.2298	0.0000	0.0000;
	490	1	7.459	4	0	0	1	1.1089331	31.940407	110	1	1.12	0.95	99.0702	-0.1654	0.0000	0.0000;
	491	1	3.197	0.9	0	0	1	1.0885432	18.594199	110	1	1.12	0.95	105.9929	1.2573	0.0000	0.0000;
	492	1	6.393	1.8	0	0	1	1.0882752	18.521552	110	1	1.12	0.95	106.0424	1.2785	0.0000	0.0000;
	493	1	3.729	0	0	0	1	1.1116013	17.572157	110	1	1.12	0.95	106.4054	-0.0025	0.0000	0.0000;
	494	1	17.049	4.8	0	0	1	1.0807277	18.101008	110	1	1.12	0.95	106.8931	1.4540	0.0000	0.0000;
	495	1	17.049	4.8	0	0	1	1.0808231	18.118966	110	1	1.12	0.95	106.8836	1.4521	0.0000	0.0000;
	496	1	24.507	6.9	0	0	1	1.082024	17.846596	110	1	1.12	0.95	106.7677	1.3231	0.0000	0.0000;
	497	1	23.762	5.58	0	0	1	1.0790913	17.415658	110	1	1.12	0.95	107.5727	1.5525	0.0000	0.0000;
	498	1	2.131	1	0	0	1	1.0840391	16.634578	110	1	1.12	0.95	108.6034	1.0841	0.0000	0.0000;
	499	1	6.926	2	0	0	1	1.0846626	17.246586	110	1	1.12	0.95	107.4199	1.1432	0.0000	0.0000;
	500	1	5.328	0.5	0	0	1	1.0825229	17.300225	110	1	1.12	0.95	108.6421	0.6047	0.0000	0.0000;
	501	1	14.917	4.2	0	0	1	1.0804946	18.006104	110	1	1.12	0.95	107.0775	1.4337	0.0000	0.0000;
	502	1	24.72	6.96	0	0	1	1.0745799	17.361751	110	1	1.12	0.95	107.9143	1.4963	0.0000	0.0000;
	503	1	12.254	3.45	0	0	1	1.0815684	17.703891	110	1	1.12	0.95	107.1723	1.4706	0.0000	0.0000;
	504	1	12.254	3.45	0	0	1	1.0787391	17.865154	110	1	1.12	0.95	107.2370	1.4915	0.0000	0.0000;
	505	1	14.066	3.3	0	0	1	1.0755367	17.426651	110	1	1.12	0.95	107.8116	1.4590	0.0000	0.0000;
	506	1	3.197	1	0	0	1	1.0632968	8.0156512	110	1	1.12	0.95	118.8943	-0.1026	0.0000	0.0000;
	507	1	26.639	7.5	0	0	1	1.0897515	18.271661	110	1	1.12	0.95	106.1621	1.2371	0.0000	0.0000;
	508	1	53.277	15	0	0	1	1.0941115	18.737423	110	1	1.12	0.95	105.5771	1.1058	0.0000	0.0000;
	509	1	2.131	0.501	0	0	1	1.1048925	31.417186	110	1	1.12	0.95	99.4724	-0.1583	0.0000	0.0000;
	510	1	2.131	0.5	0	0	1	1.1048598	31.407538	110	1	1.12	0.95	99.4728	-0.1594	0.0000	0.0000;
	511	1	19.925	6.79	0	0	1	1.1065766	29.412498	110	1	1.12	0.95	100.4095	0.6051	0.0000	0.0000;
	512	1	0	0	0	0	1	1.1147437	30.066452	110	1	1.12	0.95	100.2245	0.4441	0.0000	0.0000;
	513	1	2.131	1	0	0	1	1.0833247	16.481964	110	1	1.12	0.95	108.7836	1.1024	0.0000	0.0000;
	514	1	3.197	1	0	0	1	1.1022804	16.19139	110	1	1.12	0.95	108.4372	0.0614	0.0000	0.0000;
	515	1	7.459	1.75	0	0	1	1.0860503	18.536034	110	1	1.12	0.95	106.1254	1.3044	0.0000	0.0000;
	516	1	5.328	1.25	0	0	1	1.0860952	18.543056	110	1	1.12	0.95	106.1225	1.3037	0.0000	0.0000;
	517	1	2.131	0.6	0	0	1	1.0777817	17.328785	110	1	1.12	0.95	107.6763	1.6086	0.0000	0.0000;
	518	1	0	0	0	0	1	1.0897715	18.753132	110	1	1.12	0.95	106.1599	1.0324	0.0000	0.0000;
	519	1	18.115	4.25	0	0	1	1.0941641	18.647296	110	1	1.12	0.95	105.6316	1.1087	0.0000	0.0000;
	520	1	10.442	2.45	0	0	1	1.0856459	18.498992	110	1	1.12	0.95	106.1723	1.3152	0.0000	0.0000;
	521	1	10.442	2.45	0	0	1	1.0870307	18.408622	110	1	1.12	0.95	106.1889	1.3119	0.0000	0.0000;
	522	1	8.737	1.6	0	0	1	1.0773042	17.64955	110	1	1.12	0.95	107.7045	1.4054	0.0000	0.0000;
	523	1	13.853	1.4	0	0	1	1.0994272	30.576848	110	1	1.12	0.95	100.7242	-0.1628	0.0000	0.0000;
	524	1	21.843	5.13	0	0	1	1.0827819	17.92448	110	1	1.12	0.95	106.6283	1.3165	0.0000	0.0000;
	525	1	21.844	5.13	0	0	1	1.0828419	17.935462	110	1	1.12	0.95	106.6236	1.3156	0.0000	0.0000;
	526	1	14.385	3.38	0	0	1	1.0836187	18.56493	110	1	1.12	0.95	106.5432	1.1881	0.0000	0.0000;
	527	1	38.359	10.8	0	0	1	1.0818334	17.933247	110	1	1.12	0.95	106.9795	1.4825	0.0000	0.0000;
	528	1	13.319	3.749	0	0	1	1.0795905	17.469363	110	1	1.12	0.95	107.4342	1.5605	0.0000	0.0000;
	529	1	3.197	0.5	0	0	1	1.0762504	17.592484	110	1	1.12	0.95	107.8404	1.4495	0.0000	0.0000;
	530	1	5.86	1.38	0	0	1	1.0827367	17.918039	110	1	1.12	0.95	106.6347	1.3172	0.0000	0.0000;
	531	1	5.86	1.38	0	0	1	1.0778236	17.751674	110	1	1.12	0.95	107.3448	1.5116	0.0000	0.0000;
	532	1	20.458	5.76	0	0	1	1.0816953	17.879102	110	1	1.12	0.95	107.0457	1.4805	0.0000	0.0000;
	533	1	20.458	5.76	0	0	1	1.0795281	17.936626	110	1	1.12	0.95	107.0894	1.4213	0.0000	0.0000;
	534	1	33.032	9.299	0	0	1	1.0789356	17.853039	110	1	1.12	0.95	107.1909	1.4201	0.0000	0.0000;
	535	1	3.943	0.2	0	0	1	1.1009519	18.542106	110	1	1.12	0.95	105.8328	0.6128	0.0000	0.0000;
	536	2	12.786	5.677	0	0	1	1.0850146	18.057379	110	1	1.12	0.95	106.7163	1.3714	0.0000	0.0000;
	537	2	15.127	7.3	0	0	1	1.083005	17.963666	110	1	1.12	0.95	106.9421	1.1885	0.0000	0.0000;
	538	1	10.655	3	0	0	1	1.082287	17.914842	110	1	1.12	0.95	107.0296	1.2126	0.0000	0.0000;
	539	1	10.655	3	0	0	1	1.084298	18.008735	110	1	1.12	0.95	106.8037	1.3955	0.0000	0.0000;
	540	1	15.984	3.75	0	0	1	1.0817632	17.758256	110	1	1.12	0.95	107.1182	1.4639	0.0000	0.0000;
	541	1	21.844	5.13	0	0	1	1.082165	17.859352	110	1	1.12	0.95	106.7364	1.3231	0.0000	0.0000;
	542	1	21.844	5.13	0	0	1	1.082268	17.874675	110	1	1.12	0.95	106.7209	1.3221	0.0000	0.0000;
	543	1	21.311	5	0	0	1	1.0826217	17.915679	110	1	1.12	0.95	106.9733	1.4484	0.0000	0.0000;
	544	1	23.655	6.66	0	0	1	1.0835483	18.261853	110	1	1.12	0.95	106.7829	1.2910	0.0000	0.0000;
	545	1	38.359	10.8	0	0	1	1.0832006	17.979521	110	1	1.12	0.95	106.5842	1.3078	0.0000	0.0000;
	546	1	15.45	4.35	0	0	1	1.081626	18.052911	110	1	1.12	0.95	106.9500	1.4147	0.0000	0.0000;
	547	1	9.59	2.7	0	0	1	1.0877573	18.479532	110	1	1.12	0.95	106.0985	1.2940	0.0000	0.0000;
	548	1	9.59	2.7	0	0	1	1.0892241	18.337114	110	1	1.12	0.95	106.2603	1.2497	0.0000	0.0000;
	549	1	28.769	6.75	0	0	1	1.08204	17.841755	110	1	1.12	0.95	107.0386	1.4613	0.0000	0.0000;
	550	1	11.295	3.18	0	0	1	1.086603	18.354615	110	1	1.12	0.95	106.3203	1.3282	0.0000	0.0000;
	551	2	36.229	10.2	0	0	1	1.0775252	17.313486	110	1	1.12	0.95	107.6947	1.6230	0.0000	0.0000;
	552	1	0	0	0	0	1	1.0784713	17.810629	110	1	1.12	0.95	107.3665	1.4674	0.0000	0.0000;
	553	1	10.656	4	0	0	1	1.0888814	15.874388	110	1	1.12	0.95	109.6921	0.4125	0.0000	0.0000;
	554	1	4.262	0.5	0	0	1	1.0815603	10.965569	110	1	1.12	0.95	112.7480	0.4074	0.0000	0.0000;
	555	1	11.188	0.5	0	0	1	1.0986329	16.123023	110	1	1.12	0.95	108.6271	0.1311	0.0000	0.0000;
	556	1	3.729	1	0	0	1	1.088267	15.826352	110	1	1.12	0.95	109.7771	0.4196	0.0000	0.0000;
	557	1	0	0	0	0	1	1.0882696	15.82568	110	1	1.12	0.95	109.7765	0.4191	0.0000	0.0000;
	558	1	0	0	0	0	1	1.0657851	17.225662	110	1	1.12	0.95	108.9996	2.0511	0.0000	0.0000;
	559	2	6.062	3	0	0	1	1.0822821	17.653501	110	1	1.12	0.95	107.1970	1.4431	0.0000	0.0000;
	560	2	7.142	4.5	0	0	1	1.0810281	18.05027	110	1	1.12	0.95	107.0075	1.4200	0.0000	0.0000;
	561	1	0	0	0	0	1	1.0985589	36.716395	110	1	1.12	0.95	97.7197	0.0441	0.0000	0.0000;
	562	1	0	0	0	0	1	1.082856	16.861437	110	1	1.12	0.95	108.4020	0.8208	0.0000	0.0000;
	563	1	0	0	0	0	1	1.0822573	17.87193	110	1	1.12	0.95	106.8103	1.2939	0.0000	0.0000;
	564	1	0	0	0	0	1	1.100676	36.858016	110	1	1.12	0.95	97.7201	-0.0620	0.0000	0.0000;
	565	1	0	0	0	0	1	1.0859368	18.378497	110	1	1.12	0.95	106.6397	1.1384	0.0000	0.0000;
	566	1	0	0	0	0	1	1.1107038	29.321686	110	1	1.12	0.95	100.9357	0.3528	0.0000	0.0000;
	567	1	4.156	0.9	0	0	1	1.0927805	18.476594	110	1	1.12	0.95	105.8631	1.1447	0.0000	0.0000;
	568	1	2.132	1.5	0	0	1	1.077499	17.31648	110	1	1.12	0.95	107.6951	1.6212	0.0000	0.0000;
	569	1	2.131	0.5	0	0	1	1.0858447	18.369248	110	1	1.12	0.95	106.6506	1.1406	0.0000	0.0000;
	570	1	3.197	0	0	0	1	1.1014154	16.966888	110	1	1.12	0.95	108.3262	0.1034	0.0000	0.0000;
	571	1	11.721	0.5	0	0	1	1.0967959	15.741616	110	1	1.12	0.95	109.2905	0.0712	0.0000	0.0000;
	572	1	6.393	0.6	0	0	1	1.0974439	29.695995	110	1	1.12	0.95	101.4055	-0.0387	0.0000	0.0000;
	573	2	10.655	2.3	0	0	1	1.1045147	29.235955	110	1	1.12	0.95	101.2170	0.1598	0.0000	0.0000;
	574	1	8.631	3.45	0	0	1	1.1121571	29.314762	110	1	1.12	0.95	100.9659	0.2922	0.0000	0.0000;
	575	1	0	0	0	0	1	1.0943796	27.616655	110	1	1.12	0.95	102.6671	0.7276	0.0000	0.0000;
	576	1	4.795	0.9	0	0	1	1.1013174	29.08014	110	1	1.12	0.95	101.5307	0.1399	0.0000	0.0000;
	577	1	1.492	0.4	0	0	1	1.1161161	30.424791	110	1	1.12	0.95	99.8828	0.4769	0.0000	0.0000;
	578	1	1.279	0.3	0	0	1	1.0967189	34.27168	110	1	1.12	0.95	98.4728	0.2840	0.0000	0.0000;
	579	1	6.393	1.8	0	0	1	1.087391	18.441253	110	1	1.12	0.95	106.1469	1.3022	0.0000	0.0000;
	580	1	0.213	0.06	0	0	1	1.0903515	18.321288	110	1	1.12	0.95	106.0880	1.2196	0.0000	0.0000;
	581	1	5.327	2	0	0	1	1.0872088	26.6939	110	1	1.12	0.95	102.9758	0.6078	0.0000	0.0000;
	582	1	9.803	0.9	0	0	1	1.0934413	15.581613	110	1	1.12	0.95	108.8212	0.5748	0.0000	0.0000;
	583	1	3.197	0.99	0	0	1	1.1116668	29.253725	110	1	1.12	0.95	101.0213	0.2914	0.0000	0.0000;
	584	1	2.131	1	0	0	1	1.0818192	17.526172	110	1	1.12	0.95	108.4912	0.6343	0.0000	0.0000;
	585	1	5.328	0.4	0	0	1	1.0812355	16.851571	110	1	1.12	0.95	108.7117	0.8923	0.0000	0.0000;
	586	1	7.459	2	0	0	1	1.079321	17.551065	110	1	1.12	0.95	108.1155	1.5223	0.0000	0.0000;
	587	1	0	0	0	0	1	1.0983678	26.674389	110	2	1.12	0.95	101.4323	-0.3227	0.0000	0.0000;
	588	1	4.347	1.12	0	0	1	1.0984547	26.672076	110	2	1.12	0.95	101.4372	-0.3239	0.0000	0.0000;
	589	1	2.226	1	0	0	1	1.0786202	26.120566	110	2	1.12	0.95	102.4598	-0.5964	0.0000	0.0000;
	590	1	6.151	1	0	0	1	1.0892973	25.252585	110	2	1.12	0.95	102.7871	-0.2320	0.0000	0.0000;
	591	1	10.391	2.4	0	0	1	1.0535843	25.322515	110	2	1.12	0.95	103.0250	-0.1267	0.0000	0.0000;
	592	1	4.898	0.5	0	0	1	1.0897643	25.750629	110	2	1.12	0.95	102.4989	-0.2715	0.0000	0.0000;
	593	1	11.664	1.5	0	0	1	1.071153	26.48278	110	2	1.12	0.95	102.4075	-0.5515	0.0000	0.0000;
	594	1	0	0	0	0	1	1.0710879	26.481634	110	2	1.12	0.95	102.4126	-0.5485	0.0000	0.0000;
	595	1	20.036	9.512	0	0	1	1.0850909	25.056041	110	2	1.12	0.95	103.0463	-0.0697	0.0000	0.0000;
	596	1	4.771	1	0	0	1	1.0881552	25.473478	110	2	1.12	0.95	102.6837	0.1613	0.0000	0.0000;
	597	1	3.5	2	0	0	1	1.0534183	25.338363	110	2	1.12	0.95	104.2724	-0.0118	0.0000	0.0000;
	598	1	9.436	2.5	0	0	1	1.0825496	25.901067	110	2	1.12	0.95	102.6004	-0.3191	0.0000	0.0000;
	599	1	4.028	0.8	0	0	1	1.0817988	25.957205	110	2	1.12	0.95	102.5473	-0.2882	0.0000	0.0000;
	600	1	4.771	0	0	0	1	1.0706283	25.373313	110	2	1.12	0.95	103.6105	-0.8729	0.0000	0.0000;
	601	1	6.679	0.9	0	0	1	1.102666	25.784194	110	2	1.12	0.95	99.3222	0.4670	0.0000	0.0000;
	602	1	9.967	1.4	0	0	1	1.1013164	25.579734	110	2	1.12	0.95	99.6183	0.4581	0.0000	0.0000;
	603	1	2.129	1.7	0	0	1	1.0617541	25.57061	110	2	1.12	0.95	103.1167	0.0950	0.0000	0.0000;
	604	1	2.439	0.3	0	0	1	1.0773867	24.521072	110	2	1.12	0.95	104.0517	-0.3155	0.0000	0.0000;
	605	1	25.765	4.3	0	0	1	1.0840564	25.784863	110	2	1.12	0.95	102.3893	-0.1294	0.0000	0.0000;
	606	1	9.542	1.5	0	0	1	1.0731761	26.638655	110	2	1.12	0.95	102.6259	-0.9211	0.0000	0.0000;
	607	1	5.301	0	0	0	1	1.0736031	26.706465	110	2	1.12	0.95	102.5185	-0.9024	0.0000	0.0000;
	608	1	5.673	2.6	0	0	1	1.090333	26.151835	110	2	1.12	0.95	102.0066	-0.1941	0.0000	0.0000;
	609	1	6.997	1.8	0	0	1	1.0523098	25.132549	110	2	1.12	0.95	103.1534	-0.1778	0.0000	0.0000;
	610	1	14.168	1.293	0	0	1	1.0893993	24.428925	110	2	1.12	0.95	103.4549	-0.4628	0.0000	0.0000;
	611	1	14.168	1.293	0	0	1	1.088863	24.405414	110	2	1.12	0.95	103.5472	-0.4559	0.0000	0.0000;
	612	1	6.256	0.4	0	0	1	1.0909008	24.530709	110	2	1.12	0.95	103.2250	-0.4910	0.0000	0.0000;
	613	1	0	0	0	0	1	1.0839961	27.318935	110	2	1.12	0.95	101.2727	-0.8067	0.0000	0.0000;
	614	1	0	0	0	0	1	1.0809465	27.27928	110	2	1.12	0.95	101.4454	-0.7368	0.0000	0.0000;
	615	1	7.211	0.4	0	0	1	1.0908868	24.516177	110	2	1.12	0.95	103.2318	-0.4919	0.0000	0.0000;
	616	1	3.181	0.5	0	0	1	1.0769894	25.776703	110	2	1.12	0.95	102.6014	-0.4723	0.0000	0.0000;
	617	1	0	0	0	0	1	1.0916459	24.631389	110	2	1.12	0.95	103.0937	-0.4925	0.0000	0.0000;
	618	1	0	0	0	0	1	1.0916054	24.623164	110	2	1.12	0.95	103.0960	-0.4925	0.0000	0.0000;
	619	1	4.241	0	0	0	1	1.0758924	26.46192	110	2	1.12	0.95	102.4459	-1.5085	0.0000	0.0000;
	620	1	5.301	0.2	0	0	1	1.0906854	24.495615	110	2	1.12	0.95	103.2687	-0.4922	0.0000	0.0000;
	621	1	7.104	1.8	0	0	1	1.0790017	24.404956	110	2	1.12	0.95	104.0730	-0.0765	0.0000	0.0000;
	622	1	3.971	0.34	0	0	1	1.0897788	25.404314	110	2	1.12	0.95	102.3795	0.0522	0.0000	0.0000;
	623	1	2.12	0	0	0	1	1.0740161	26.380398	110	2	1.12	0.95	102.9435	-0.4548	0.0000	0.0000;
	624	1	6.892	1.947	0	0	1	1.0647216	26.075696	110	2	1.12	0.95	102.6406	-0.3096	0.0000	0.0000;
	625	1	3.181	0	0	0	1	1.0725724	26.959003	110	2	1.12	0.95	102.7016	-0.5769	0.0000	0.0000;
	626	2	0	-0.002	0	0	1	1.094158	29.158072	110	2	1.12	0.95	98.9717	-0.1920	0.0000	0.0000;
	627	1	5.386	2.581	0	0	1	1.0780318	26.664361	110	2	1.12	0.95	102.0148	-0.3452	0.0000	0.0000;
	628	1	17.535	7.911	0	0	1	1.0824934	21.041254	110	2	1.12	0.95	104.5963	1.3733	0.0000	0.0000;
	629	1	3.971	0.34	0	0	1	1.0782498	27.559143	110	2	1.12	0.95	101.3974	-0.7676	0.0000	0.0000;
	630	1	3.758	2.8	0	0	1	1.0912689	26.143017	110	2	1.12	0.95	101.9010	-0.0843	0.0000	0.0000;
	631	1	9.224	2.9	0	0	1	1.0788939	26.854245	110	2	1.12	0.95	101.7735	-0.3143	0.0000	0.0000;
	632	1	6.91	2.246	0	0	1	1.0803569	27.84814	110	2	1.12	0.95	100.9427	-0.7312	0.0000	0.0000;
	633	1	9.647	0.3	0	0	1	1.0488039	24.758645	110	2	1.12	0.95	104.7087	-0.0529	0.0000	0.0000;
	634	1	3.181	0.9	0	0	1	1.0936539	25.323769	110	2	1.12	0.95	102.5942	-0.7010	0.0000	0.0000;
	635	1	6.785	1.1	0	0	1	1.09375	25.347001	110	2	1.12	0.95	102.5693	-0.6984	0.0000	0.0000;
	636	1	8.482	2	0	0	1	1.0784985	26.815455	110	2	1.12	0.95	101.8377	-0.3993	0.0000	0.0000;
	637	1	0.119	0.08	0	0	1	1.0666752	25.923698	110	2	1.12	0.95	103.0631	-0.3905	0.0000	0.0000;
	638	1	4.559	0.2	0	0	1	1.1041513	25.781651	110	2	1.12	0.95	99.1426	0.4966	0.0000	0.0000;
	639	1	5.473	0	0	0	1	1.052175	25.017169	110	2	1.12	0.95	103.2044	-0.2640	0.0000	0.0000;
	640	1	4.241	1	0	0	1	1.074308	25.392662	110	2	1.12	0.95	103.1521	-0.5703	0.0000	0.0000;
	641	1	8.021	2.691	0	0	1	1.0889713	27.107979	110	2	1.12	0.95	100.7571	-0.2526	0.0000	0.0000;
	642	1	7.953	0	0	0	1	1.0651714	24.793207	110	2	1.12	0.95	104.0442	-0.0189	0.0000	0.0000;
	643	1	3.181	0	0	0	1	1.0789343	27.218658	110	2	1.12	0.95	102.4128	-1.4909	0.0000	0.0000;
	644	1	8.482	0	0	0	1	1.0787686	27.049303	110	2	1.12	0.95	102.4016	-1.6039	0.0000	0.0000;
	645	1	5.301	1	0	0	1	1.0827093	25.149217	110	2	1.12	0.95	102.9143	-0.0093	0.0000	0.0000;
	646	1	2.439	0.7	0	0	1	1.1062253	26.721925	110	2	1.12	0.95	98.3349	0.4139	0.0000	0.0000;
	647	1	2.544	0	0	0	1	1.0698567	25.403205	110	2	1.12	0.95	103.3505	-0.0420	0.0000	0.0000;
	648	1	3.605	0.4	0	0	1	1.0967902	25.759709	110	2	1.12	0.95	102.1136	-0.7305	0.0000	0.0000;
	649	1	0.742	0	0	0	1	1.0830169	27.086253	110	2	1.12	0.95	101.5717	-0.7868	0.0000	0.0000;
	650	1	2.544	0.6	0	0	1	1.0769417	24.366294	110	2	1.12	0.95	104.2384	-0.2590	0.0000	0.0000;
	651	1	5.665	0.34	0	0	1	1.0776664	26.052037	110	2	1.12	0.95	102.1095	-2.0924	0.0000	0.0000;
	652	1	9.861	2.4	0	0	1	1.0797642	27.285477	110	2	1.12	0.95	101.5089	-0.7902	0.0000	0.0000;
	653	1	4.061	0.3	0	0	1	1.0884174	24.895061	110	2	1.12	0.95	102.6841	-0.0464	0.0000	0.0000;
	654	1	1.255	0.91	0	0	1	1.0778131	26.068995	110	2	1.12	0.95	101.9148	-2.0757	0.0000	0.0000;
	655	1	23.327	4.5	0	0	1	1.0769716	26.062666	110	2	1.12	0.95	102.0669	-2.0506	0.0000	0.0000;
	656	1	11.664	1	0	0	1	1.0770893	26.024631	110	2	1.12	0.95	102.0345	-2.0600	0.0000	0.0000;
	657	1	5.301	0	0	0	1	1.0767677	25.884505	110	2	1.12	0.95	102.1174	-2.0777	0.0000	0.0000;
	658	1	1.13	0.068	0	0	1	1.0496165	25.139063	110	2	1.12	0.95	104.7948	0.0475	0.0000	0.0000;
	659	1	2.757	0.1	0	0	1	1.0489435	24.879432	110	2	1.12	0.95	104.7830	-0.0038	0.0000	0.0000;
	660	1	0.53	0	0	0	1	1.0732144	26.74626	110	2	1.12	0.95	102.6528	-0.7825	0.0000	0.0000;
	661	1	3.711	0.6	0	0	1	1.0824068	26.80751	110	2	1.12	0.95	101.6569	-0.8048	0.0000	0.0000;
	662	1	8.059	0.1	0	0	1	1.0782908	24.522084	110	2	1.12	0.95	104.0837	-0.2618	0.0000	0.0000;
	663	1	3.181	0	0	0	1	1.0783016	25.550423	110	2	1.12	0.95	102.8768	-0.7918	0.0000	0.0000;
	664	2	13	0	0	0	1	1.1007585	25.745321	110	2	1.12	0.95	101.2441	0.0000	0.0000	0.0000;
	665	2	0	0	0	0	1	1.1003072	25.739865	110	2	1.12	0.95	101.2543	0.0025	0.0000	0.0000;
	666	1	5.832	0.5	0	0	1	1.0763565	25.8508	110	2	1.12	0.95	102.2357	-2.0764	0.0000	0.0000;
	667	1	23.327	4.5	0	0	1	1.0784033	26.103495	110	2	1.12	0.95	101.8284	-2.0900	0.0000	0.0000;
	668	1	6.574	1.2	0	0	1	1.0503279	24.786125	110	2	1.12	0.95	104.0791	-0.1706	0.0000	0.0000;
	669	1	0	0	0	0	1	1.0527804	25.143313	110	2	1.12	0.95	103.0670	-0.2580	0.0000	0.0000;
	670	1	12.724	2.6	0	0	1	1.0502804	24.785903	110	2	1.12	0.95	104.0595	-0.1725	0.0000	0.0000;
	671	1	11.347	1.2	0	0	1	1.0505225	24.793691	110	2	1.12	0.95	104.0903	-0.1805	0.0000	0.0000;
	672	1	9.516	0.272	0	0	1	1.0515987	24.966826	110	2	1.12	0.95	103.4710	-0.2236	0.0000	0.0000;
	673	1	6.361	0.5	0	0	1	1.068274	25.681307	110	2	1.12	0.95	104.0600	-0.6660	0.0000	0.0000;
	674	1	2.12	0.5	0	0	1	1.068426	25.734414	110	2	1.12	0.95	104.0202	-0.6468	0.0000	0.0000;
	675	1	10.922	1	0	0	1	1.0896696	24.84212	110	2	1.12	0.95	103.1315	-0.4585	0.0000	0.0000;
	676	1	6.361	0	0	0	1	1.0685109	25.759695	110	2	1.12	0.95	104.0013	-0.6402	0.0000	0.0000;
	677	1	5.301	2	0	0	1	1.072587	27.451933	110	2	1.12	0.95	102.4520	-0.3153	0.0000	0.0000;
	678	1	19.086	2	0	0	1	1.0760108	25.797469	110	2	1.12	0.95	102.2475	-2.0698	0.0000	0.0000;
	679	1	7.953	1.5	0	0	1	1.0943485	25.441049	110	2	1.12	0.95	101.8213	-0.0328	0.0000	0.0000;
	680	1	17.535	6.272	0	0	1	1.0650914	25.752025	110	2	1.12	0.95	103.2691	-0.3298	0.0000	0.0000;
	681	1	7.317	3	0	0	1	1.0668265	24.49337	110	2	1.12	0.95	104.7122	0.0624	0.0000	0.0000;
	682	1	14.208	2.8	0	0	1	1.08914	25.433456	110	2	1.12	0.95	102.4283	-0.0749	0.0000	0.0000;
	683	1	8.005	2.1	0	0	1	1.0864699	25.31274	110	2	1.12	0.95	102.8087	-0.0737	0.0000	0.0000;
	684	1	7.528	0.43	0	0	1	1.096818	26.590071	110	2	1.12	0.95	101.4877	-0.2527	0.0000	0.0000;
	685	2	8.503	0.817	0	0	1	1.1007953	27.125909	110	2	1.12	0.95	100.9386	-0.3032	0.0000	0.0000;
	686	1	0	0	0	0	1	1.1007374	27.108626	110	2	1.12	0.95	100.9427	-0.3027	0.0000	0.0000;
	687	1	12.512	2.8	0	0	1	1.0873238	28.59531	110	2	1.12	0.95	100.0526	-0.2230	0.0000	0.0000;
	688	1	4.666	1.6	0	0	1	1.0632703	26.471935	110	2	1.12	0.95	101.7684	0.0220	0.0000	0.0000;
	689	1	5.089	1	0	0	1	1.0869602	28.531649	110	2	1.12	0.95	100.1240	-0.2434	0.0000	0.0000;
	690	1	4.531	0.68	0	0	1	1.0940559	26.287319	110	2	1.12	0.95	101.7496	-0.1956	0.0000	0.0000;
	691	2	6.574	2.8	0	0	1	1.0939195	26.28052	110	2	1.12	0.95	101.7600	-0.1916	0.0000	0.0000;
	692	1	6.51	1.05	0	0	1	1.0935497	26.2511	110	2	1.12	0.95	101.8010	-0.1812	0.0000	0.0000;
	693	1	12.109	0.87	0	0	1	1.0925768	26.12239	110	2	1.12	0.95	101.9416	-0.1699	0.0000	0.0000;
	694	1	6.361	1	0	0	1	1.0804221	25.331251	110	2	1.12	0.95	102.8233	-0.6670	0.0000	0.0000;
	695	1	5.513	1.5	0	0	1	1.1029893	24.689052	110	2	1.12	0.95	99.9113	0.6590	0.0000	0.0000;
	696	1	0	0	0	0	1	1.0934139	26.237996	110	2	1.12	0.95	101.7710	-0.1676	0.0000	0.0000;
	697	1	0	0	0	0	1	1.0934329	26.224012	110	2	1.12	0.95	101.7729	-0.1681	0.0000	0.0000;
	698	1	2.544	0.9	0	0	1	1.0982344	25.613107	110	2	1.12	0.95	101.0285	-0.1503	0.0000	0.0000;
	699	1	9.362	1.24	0	0	1	1.0924968	26.094894	110	2	1.12	0.95	101.9817	-0.1742	0.0000	0.0000;
	700	1	10.052	1.72	0	0	1	1.096195	26.513545	110	2	1.12	0.95	101.7844	-0.2862	0.0000	0.0000;
	701	1	13.106	0.97	0	0	1	1.0936889	26.201831	110	2	1.12	0.95	101.8888	-0.2057	0.0000	0.0000;
	702	1	0	0	0	0	1	1.0945913	26.326274	110	2	1.12	0.95	101.6992	-0.2088	0.0000	0.0000;
	703	1	11.112	1.26	0	0	1	1.0959714	26.487286	110	2	1.12	0.95	101.8175	-0.2844	0.0000	0.0000;
	704	1	5.587	0.21	0	0	1	1.0970639	26.572514	110	2	1.12	0.95	101.6539	-0.3022	0.0000	0.0000;
	705	1	12.311	3.95	0	0	1	1.0939438	26.279614	110	2	1.12	0.95	101.7632	-0.1939	0.0000	0.0000;
	706	1	5.301	0	0	0	1	1.0812058	27.271418	110	2	1.12	0.95	101.4545	-0.7370	0.0000	0.0000;
	707	1	2.502	1.8	0	0	1	1.0818185	27.299575	110	2	1.12	0.95	101.3896	-0.7475	0.0000	0.0000;
	708	1	2.757	0	0	0	1	1.0942235	24.866366	110	2	1.12	0.95	102.3781	-0.3786	0.0000	0.0000;
	709	1	12.724	2	0	0	1	1.0792834	29.19317	110	2	1.12	0.95	101.0771	0.2561	0.0000	0.0000;
	710	1	8.377	1.1	0	0	1	1.0941163	24.945901	110	2	1.12	0.95	101.3299	0.2489	0.0000	0.0000;
	711	1	0.25	0.18	0	0	1	1.0572655	24.449125	110	2	1.12	0.95	104.7324	0.0650	0.0000	0.0000;
	712	1	4.241	1	0	0	1	1.0871718	25.714591	110	2	1.12	0.95	102.8993	0.2921	0.0000	0.0000;
	713	1	1.704	0	0	0	1	1.0888235	22.063305	110	2	1.12	0.95	103.2165	1.0735	0.0000	0.0000;
	714	1	0	0	0	0	1	1.0951011	26.037803	110	2	1.12	0.95	101.9185	-0.6134	0.0000	0.0000;
	715	1	0	0	0	0	1	1.0951283	26.043489	110	2	1.12	0.95	101.9164	-0.6114	0.0000	0.0000;
	716	2	36.581	12.8	0	0	1	1.0745186	27.437685	110	2	1.12	0.95	101.3106	-0.3272	0.0000	0.0000;
	717	1	30.065	11.166	0	0	1	1.0718069	25.866263	110	2	1.12	0.95	102.6728	-1.7244	0.0000	0.0000;
	718	1	5.301	1	0	0	1	1.0798094	26.560462	110	2	1.12	0.95	101.8524	-1.9755	0.0000	0.0000;
	719	1	16.541	3.6	0	0	1	1.0635204	24.64592	110	2	1.12	0.95	104.2921	-0.0035	0.0000	0.0000;
	720	1	3.074	0.7	0	0	1	1.0800658	24.747884	110	2	1.12	0.95	103.8215	-0.2511	0.0000	0.0000;
	721	1	4.028	0.7	0	0	1	1.0798903	27.222793	110	2	1.12	0.95	101.5838	-0.7565	0.0000	0.0000;
	722	1	14.102	3.3	0	0	1	1.0490971	24.999368	110	2	1.12	0.95	104.8214	0.0390	0.0000	0.0000;
	723	1	4.992	1	0	0	1	1.0828127	26.159251	110	2	1.12	0.95	102.1815	-0.5908	0.0000	0.0000;
	724	1	2.12	1	0	0	1	1.0855382	25.011157	110	2	1.12	0.95	103.0622	-0.1027	0.0000	0.0000;
	725	1	2.12	0.5	0	0	1	1.0726886	25.257427	110	2	1.12	0.95	103.5111	-0.6621	0.0000	0.0000;
	726	1	5.727	0	0	0	1	1.0849572	25.383081	110	2	1.12	0.95	102.8271	-0.2283	0.0000	0.0000;
	727	1	0.212	0	0	0	1	1.0825499	26.742317	110	2	1.12	0.95	101.7928	-0.7145	0.0000	0.0000;
	728	1	2.12	0.5	0	0	1	1.0714496	25.778783	110	2	1.12	0.95	102.9083	-1.5095	0.0000	0.0000;
	729	1	4.771	0	0	0	1	1.0829792	26.310413	110	2	1.12	0.95	101.9940	-0.8424	0.0000	0.0000;
	730	1	36.326	16.476	0	0	1	1.0837796	25.964865	110	2	1.12	0.95	102.1733	-0.8577	0.0000	0.0000;
	731	1	0	0	0	0	1	1.0839521	25.98934	110	2	1.12	0.95	102.1656	-0.8606	0.0000	0.0000;
	732	1	1.255	1.1	0	0	1	1.082491	27.520218	110	2	1.12	0.95	101.1251	-0.7640	0.0000	0.0000;
	733	1	42.413	10	0	0	1	1.0149549	27.094341	110	2	1.12	0.95	101.7808	-0.7429	0.0000	0.0000;
	734	1	0	0	0	0	1	1.015143	27.106377	110	2	1.12	0.95	101.7535	-0.7486	0.0000	0.0000;
	735	1	9.637	0.953	0	0	1	1.0802374	25.65648	110	2	1.12	0.95	102.6335	-0.8245	0.0000	0.0000;
	736	1	3.181	0	0	0	1	1.0838441	25.916181	110	2	1.12	0.95	102.2314	-0.8783	0.0000	0.0000;
	737	1	5.089	0	0	0	1	1.0792731	26.170765	110	2	1.12	0.95	102.3995	-0.6152	0.0000	0.0000;
	738	1	6.256	0.9	0	0	1	1.0983618	26.237923	110	2	1.12	0.95	100.6989	-0.1080	0.0000	0.0000;
	739	1	5.016	4.03	0	0	1	1.0693535	25.313311	110	2	1.12	0.95	103.6350	-0.6565	0.0000	0.0000;
	740	2	13	0	0	0	1	1.0856708	28.500201	110	2	1.12	0.95	99.9664	-0.7237	0.0000	0.0000;
	741	1	0	0	0	0	1	1.0857149	28.489905	110	2	1.12	0.95	99.9848	-0.7273	0.0000	0.0000;
	742	1	4.241	0.5	0	0	1	1.0731576	26.761368	110	2	1.12	0.95	102.6388	-0.7747	0.0000	0.0000;
	743	1	5.665	0	0	0	1	1.0881508	25.255236	110	2	1.12	0.95	102.3430	-0.1139	0.0000	0.0000;
	744	1	4.241	1	0	0	1	1.0822647	25.238771	110	2	1.12	0.95	102.7038	-0.1763	0.0000	0.0000;
	745	1	4.559	0	0	0	1	1.0774029	24.461707	110	2	1.12	0.95	104.1252	-0.2856	0.0000	0.0000;
	746	1	6.892	0.3	0	0	1	1.0775292	24.441951	110	2	1.12	0.95	104.1515	-0.2670	0.0000	0.0000;
	747	1	0.848	0.5	0	0	1	1.0856141	25.340752	110	2	1.12	0.95	102.8765	-0.2499	0.0000	0.0000;
	748	1	3.393	0.1	0	0	1	1.0859948	25.327294	110	2	1.12	0.95	102.8921	-0.2616	0.0000	0.0000;
	749	1	2.332	0.7	0	0	1	1.0943232	25.392216	110	2	1.12	0.95	102.5156	-0.7148	0.0000	0.0000;
	750	1	7.104	2	0	0	1	1.0549316	24.247422	110	2	1.12	0.95	105.1214	0.1044	0.0000	0.0000;
	751	1	12.831	2.1	0	0	1	1.0602903	25.029866	110	2	1.12	0.95	104.0834	-0.1586	0.0000	0.0000;
	752	1	7.422	0	0	0	1	1.0749082	25.947605	110	2	1.12	0.95	102.9375	-0.4836	0.0000	0.0000;
	753	1	1.908	1.2	0	0	1	1.081861	27.354775	110	2	1.12	0.95	101.3197	-0.7393	0.0000	0.0000;
	754	1	14.168	0.545	0	0	1	1.0545023	24.176875	110	2	1.12	0.95	105.2307	0.0907	0.0000	0.0000;
	755	1	7.953	1	0	0	1	1.0572697	24.451325	110	2	1.12	0.95	104.7287	0.0666	0.0000	0.0000;
	756	1	7.422	0.3	0	0	1	1.0551566	24.276886	110	2	1.12	0.95	105.0909	0.1000	0.0000	0.0000;
	757	1	15.031	9.1	0	0	1	1.0731718	25.429694	110	2	1.12	0.95	103.0683	-0.2083	0.0000	0.0000;
	758	1	29.689	5	0	0	1	1.0814618	26.67294	110	2	1.12	0.95	101.6303	-2.1209	0.0000	0.0000;
	759	1	0	0	0	0	1	1.0815069	26.684667	110	2	1.12	0.95	101.6324	-2.1190	0.0000	0.0000;
	760	1	10.709	1.1	0	0	1	1.0882824	24.624524	110	2	1.12	0.95	102.7285	-0.0005	0.0000	0.0000;
	761	1	8.482	2	0	0	1	1.0739829	25.386236	110	2	1.12	0.95	103.0597	-0.2310	0.0000	0.0000;
	762	1	1.255	0.71	0	0	1	1.0740789	26.392703	110	2	1.12	0.95	102.9303	-0.4544	0.0000	0.0000;
	763	2	4.754	0.4	0	0	1	1.082436	27.989223	110	2	1.12	0.95	100.7861	-0.7184	0.0000	0.0000;
	764	1	25.388	1.701	0	0	1	1.0893353	24.627494	110	2	1.12	0.95	103.2884	-0.4052	0.0000	0.0000;
	765	1	9.542	3	0	0	1	1.0755497	25.017767	110	2	1.12	0.95	103.3577	-0.0964	0.0000	0.0000;
	766	1	10.604	0	0	0	1	1.0744393	26.890704	110	2	1.12	0.95	101.9732	-0.6101	0.0000	0.0000;
	767	1	6.151	1.2	0	0	1	1.0571246	25.973781	110	2	1.12	0.95	104.0614	-0.0835	0.0000	0.0000;
	768	1	5.301	1	0	0	1	1.077993	25.762356	110	2	1.12	0.95	102.4268	-0.4654	0.0000	0.0000;
	769	1	0	0	0	0	1	1.0779628	25.757593	110	2	1.12	0.95	102.4244	-0.4651	0.0000	0.0000;
	770	1	7.422	3	0	0	1	1.0751753	25.396966	110	2	1.12	0.95	103.0136	-0.2687	0.0000	0.0000;
	771	1	13.153	6.618	0	0	1	1.0749549	25.484073	110	2	1.12	0.95	102.9288	-0.2767	0.0000	0.0000;
	772	1	6.361	1	0	0	1	1.0750796	25.050502	110	2	1.12	0.95	103.3436	-0.1025	0.0000	0.0000;
	773	1	9.065	0.34	0	0	1	1.0909702	28.32602	110	2	1.12	0.95	99.6545	-0.2068	0.0000	0.0000;
	774	1	9.224	1.8	0	0	1	1.0832133	24.586814	110	2	1.12	0.95	103.5371	0.0045	0.0000	0.0000;
	775	1	4.877	0.6	0	0	1	1.0736927	26.69491	110	2	1.12	0.95	102.1804	-0.6471	0.0000	0.0000;
	776	1	8.8	0	0	0	1	1.0733052	26.743918	110	2	1.12	0.95	102.1315	-0.5926	0.0000	0.0000;
	777	1	3.287	0.3	0	0	1	1.0716603	26.513142	110	2	1.12	0.95	102.3797	-0.5781	0.0000	0.0000;
	778	1	0	0	0	0	1	1.081065	27.458992	110	2	1.12	0.95	101.3380	-0.8388	0.0000	0.0000;
	779	1	0	0	0	0	1	1.0810357	27.450701	110	2	1.12	0.95	101.3407	-0.8386	0.0000	0.0000;
	780	1	3.181	1	0	0	1	1.0738908	25.479506	110	2	1.12	0.95	102.9721	-0.2499	0.0000	0.0000;
	781	1	18.026	1.9	0	0	1	1.0820114	27.911842	110	2	1.12	0.95	100.8692	-0.7217	0.0000	0.0000;
	782	1	15.905	3	0	0	1	1.0712731	26.512877	110	2	1.12	0.95	102.3840	-0.5512	0.0000	0.0000;
	783	1	4.241	0.2	0	0	1	1.0830892	25.962862	110	2	1.12	0.95	102.3212	-0.8038	0.0000	0.0000;
	784	1	0.954	0.2	0	0	1	1.0940977	29.150204	110	2	1.12	0.95	98.9805	-0.1926	0.0000	0.0000;
	785	1	2.12	0.5	0	0	1	1.0745076	26.51498	110	2	1.12	0.95	102.5693	-1.2432	0.0000	0.0000;
	786	1	0	0	0	0	1	1.0929237	26.035771	110	2	1.12	0.95	102.0093	-0.1953	0.0000	0.0000;
	787	1	8.503	1.293	0	0	1	1.0927761	26.004661	110	2	1.12	0.95	102.0555	-0.2004	0.0000	0.0000;
	788	1	4.771	1	0	0	1	1.0711179	25.414719	110	2	1.12	0.95	103.3950	-0.5595	0.0000	0.0000;
	789	1	11.875	3.6	0	0	1	1.0929293	26.002852	110	2	1.12	0.95	102.0700	-0.2126	0.0000	0.0000;
	790	1	6.361	1.5	0	0	1	1.0808349	27.883398	110	2	1.12	0.95	102.1743	-1.0988	0.0000	0.0000;
	791	1	9.118	2.1	0	0	1	1.0593702	26.011131	110	2	1.12	0.95	103.8077	-0.1660	0.0000	0.0000;
	792	2	7.135	6.125	0	0	1	1.05974	26.085207	110	2	1.12	0.95	102.2924	-0.0000	0.0000	0.0000;
	793	1	6.361	0.5	0	0	1	1.0603115	26.005488	110	2	1.12	0.95	102.4427	-0.0631	0.0000	0.0000;
	794	1	2.968	0.1	0	0	1	1.0804174	26.724848	110	2	1.12	0.95	101.7511	-0.1216	0.0000	0.0000;
	795	1	7.482	0	0	0	1	1.0828682	27.715711	110	2	1.12	0.95	101.0311	-0.6219	0.0000	0.0000;
	796	2	0	0	0	0	1	1.0695421	27.10239	110	2	1.12	0.95	100.8996	0.0000	0.0000	0.0000;
	797	1	3.711	0.5	0	0	1	1.0696198	25.317145	110	2	1.12	0.95	103.6623	-0.7269	0.0000	0.0000;
	798	1	4.771	0	0	0	1	1.0688854	25.470271	110	2	1.12	0.95	104.0070	-0.7936	0.0000	0.0000;
	799	1	3.758	1.447	0	0	1	1.0696292	25.327795	110	2	1.12	0.95	103.5909	-0.6271	0.0000	0.0000;
	800	1	10.391	1.9	0	0	1	1.0726827	26.598374	110	2	1.12	0.95	102.2889	-0.6179	0.0000	0.0000;
	801	1	4.134	0.3	0	0	1	1.0816001	27.980402	110	2	1.12	0.95	100.7271	-0.7311	0.0000	0.0000;
	802	1	14.844	3.5	0	0	1	1.0731987	25.333319	110	2	1.12	0.95	103.4182	-0.6629	0.0000	0.0000;
	803	1	0	0	0	0	1	1.0857411	25.082668	110	2	1.12	0.95	103.0094	-0.0961	0.0000	0.0000;
	804	1	0.25	0.1	0	0	1	1.0599007	26.061673	110	2	1.12	0.95	102.3362	-0.0183	0.0000	0.0000;
	805	1	4.241	0.5	0	0	1	1.0755943	27.072449	110	2	1.12	0.95	102.0219	-0.8337	0.0000	0.0000;
	806	1	11.664	3.5	0	0	1	1.072819	25.301589	110	2	1.12	0.95	103.4477	-0.6405	0.0000	0.0000;
	807	2	26.507	7	0	0	1	1.0834189	26.245299	110	2	1.12	0.95	102.0196	-0.6297	0.0000	0.0000;
	808	2	24.744	7	0	0	1	1.0898163	27.919861	110	2	1.12	0.95	99.9284	-0.2155	0.0000	0.0000;
	809	1	8.059	2.2	0	0	1	1.0590846	25.47907	110	2	1.12	0.95	103.4302	-0.3217	0.0000	0.0000;
	810	1	1.13	0	0	0	1	1.0716373	25.458422	110	2	1.12	0.95	103.3822	-1.0702	0.0000	0.0000;
	811	1	9.397	4.058	0	0	1	1.0816135	26.316242	110	2	1.12	0.95	102.0689	-0.6000	0.0000	0.0000;
	812	1	4.973	1.82	0	0	1	1.082865	26.252778	110	2	1.12	0.95	102.0464	-0.6045	0.0000	0.0000;
	813	1	5.938	0.7	0	0	1	1.0903613	25.903353	110	2	1.12	0.95	102.2964	-0.5354	0.0000	0.0000;
	814	1	4.241	0.2	0	0	1	1.0809984	26.196001	110	2	1.12	0.95	102.3006	-0.2296	0.0000	0.0000;
	815	1	7.953	1.3	0	0	1	1.0804195	26.965652	110	2	1.12	0.95	101.6665	-0.5861	0.0000	0.0000;
	816	1	8.8	1.4	0	0	1	1.0774291	24.771464	110	2	1.12	0.95	104.2080	-0.3253	0.0000	0.0000;
	817	1	4.559	1	0	0	1	1.0805074	24.95825	110	2	1.12	0.95	103.8756	-0.3769	0.0000	0.0000;
	818	1	2.65	1	0	0	1	1.0785352	26.826416	110	2	1.12	0.95	101.8254	-0.3532	0.0000	0.0000;
	819	1	3.816	0.4	0	0	1	1.0950494	25.502105	110	2	1.12	0.95	102.3957	-0.7184	0.0000	0.0000;
	820	1	1.166	0.2	0	0	1	1.0774053	24.71525	110	2	1.12	0.95	104.2654	-0.3419	0.0000	0.0000;
	821	1	4.984	1.1	0	0	1	1.0653912	26.779491	110	2	1.12	0.95	101.5347	0.0323	0.0000	0.0000;
	822	1	9.542	1.5	0	0	1	1.0907349	23.06489	110	2	1.12	0.95	102.7978	0.7769	0.0000	0.0000;
	823	1	3.923	0.7	0	0	1	1.1022332	26.622392	110	2	1.12	0.95	99.6704	-0.0082	0.0000	0.0000;
	824	1	7.528	1	0	0	1	1.1106405	28.326117	110	2	1.12	0.95	96.9342	0.2386	0.0000	0.0000;
	825	1	4.241	1	0	0	1	1.0800959	26.754962	110	2	1.12	0.95	101.9473	-1.9539	0.0000	0.0000;
	826	1	5.832	0.2	0	0	1	1.0965498	25.161536	110	2	1.12	0.95	101.6588	-0.2330	0.0000	0.0000;
	827	1	5.301	0	0	0	1	1.0748577	25.753713	110	2	1.12	0.95	102.6308	-1.6520	0.0000	0.0000;
	828	1	9.542	1	0	0	1	1.0845146	28.611845	110	2	1.12	0.95	101.8291	-0.6681	0.0000	0.0000;
	829	1	11.441	0.88	0	0	1	1.096523	26.528878	110	2	1.12	0.95	101.7333	-0.2975	0.0000	0.0000;
	830	1	0	0	0	0	1	1.0700368	25.372453	110	2	1.12	0.95	103.5428	-0.5892	0.0000	0.0000;
	831	1	0	0	0	0	1	1.0729476	27.056724	110	2	1.12	0.95	102.5947	-0.5651	0.0000	0.0000;
	832	1	8.588	1.7	0	0	1	1.0971845	25.969768	110	2	1.12	0.95	101.9015	-0.6858	0.0000	0.0000;
	833	1	1.908	0.6	0	0	1	1.060846	26.171902	110	2	1.12	0.95	102.1293	-0.0028	0.0000	0.0000;
	834	1	3.181	0.3	0	0	1	1.0937528	26.3436	110	2	1.12	0.95	101.4645	-0.4376	0.0000	0.0000;
	835	1	2.332	1.6	0	0	1	1.0859119	26.684311	110	2	1.12	0.95	101.3522	-0.1317	0.0000	0.0000;
	836	1	6.574	0.5	0	0	1	1.095747	25.942274	110	2	1.12	0.95	101.9802	-0.6461	0.0000	0.0000;
	837	1	5.301	0.6	0	0	1	1.0966155	25.94701	110	2	1.12	0.95	101.9472	-0.6698	0.0000	0.0000;
	838	1	2.12	0	0	0	1	1.070046	25.343223	110	2	1.12	0.95	103.6639	-0.7959	0.0000	0.0000;
	839	1	5.301	1	0	0	1	1.0779453	25.060203	110	2	1.12	0.95	103.3547	-0.5047	0.0000	0.0000;
	840	1	0	0	0	0	1	1.0957747	29.832149	110	3	1.12	0.95	99.8910	0.0814	0.0000	0.0000;
	841	1	0.115	0	0	0	1	1.0911985	31.2338	110	3	1.12	0.95	99.4919	-0.0067	0.0000	0.0000;
	842	1	0	0.074	0	0	1	1.0706592	27.430926	110	3	1.12	0.95	101.5413	-0.3420	0.0000	0.0000;
	843	1	0	0	0	0	1	1.0712301	27.155603	110	3	1.12	0.95	101.7804	-0.4162	0.0000	0.0000;
	844	1	39.012	18.316	0	0	1	1.0703805	27.42414	110	3	1.12	0.95	101.5755	-0.3261	0.0000	0.0000;
	845	2	0	0	0	0	1	1.0709617	27.450701	110	3	1.12	0.95	101.4845	-0.3422	0.0000	0.0000;
	846	1	8.043	2.644	0	0	1	1.0767869	27.693272	110	3	1.12	0.95	102.3640	0.7482	0.0000	0.0000;
	847	1	0	0	0	0	1	1.07681	27.705417	110	3	1.12	0.95	102.3622	0.7482	0.0000	0.0000;
	848	1	1.838	0.43	0	0	1	1.1056474	30.926655	110	3	1.12	0.95	98.4611	0.0609	0.0000	0.0000;
	849	1	0	0	0	0	1	1.0827551	30.062319	110	3	1.12	0.95	100.4047	-0.0352	0.0000	0.0000;
	850	1	8.735	1.913	0	0	1	1.0827571	30.076708	110	3	1.12	0.95	100.4023	-0.0348	0.0000	0.0000;
	851	1	21.246	5.731	0	0	1	1.0793596	28.257116	110	3	1.12	0.95	101.6963	0.6794	0.0000	0.0000;
	852	1	0	0	0	0	1	1.0793926	28.265468	110	3	1.12	0.95	101.6945	0.6786	0.0000	0.0000;
	853	1	0	0	0	0	1	1.0794257	28.273819	110	3	1.12	0.95	101.6928	0.6777	0.0000	0.0000;
	854	1	8.5	0.968	0	0	1	1.0959128	30.225556	110	3	1.12	0.95	100.3412	-0.2057	0.0000	0.0000;
	855	1	8.17	2.206	0	0	1	1.0958832	30.214106	110	3	1.12	0.95	100.3449	-0.2053	0.0000	0.0000;
	856	1	0	0	0	0	1	1.0955471	29.324151	110	3	1.12	0.95	100.3734	0.3369	0.0000	0.0000;
	857	1	0	0	0	0	1	1.0955457	29.326897	110	3	1.12	0.95	100.3724	0.3370	0.0000	0.0000;
	858	1	5.165	3.067	0	0	1	1.0899372	28.940142	110	3	1.12	0.95	100.7395	0.5994	0.0000	0.0000;
	859	1	3.442	1.486	0	0	1	1.0900364	28.94952	110	3	1.12	0.95	100.7353	0.5962	0.0000	0.0000;
	860	1	2.412	0.68	0	0	1	1.0917781	30.451126	110	3	1.12	0.95	100.0124	-0.5410	0.0000	0.0000;
	861	1	0	0	0	0	1	1.0917791	30.448478	110	3	1.12	0.95	100.0121	-0.5406	0.0000	0.0000;
	862	1	12.622	2.971	0	0	1	1.0701918	27.063495	110	3	1.12	0.95	101.8958	-0.3897	0.0000	0.0000;
	863	1	0	0.083	0	0	1	1.0788628	28.025456	110	3	1.12	0.95	101.6201	0.1592	0.0000	0.0000;
	864	1	29.209	5.988	0	0	1	1.078789	28.009596	110	3	1.12	0.95	101.6274	0.1597	0.0000	0.0000;
	865	1	10.347	2.597	0	0	1	1.0873618	28.637966	110	3	1.12	0.95	101.2239	0.5673	0.0000	0.0000;
	866	1	0	0	0	0	1	1.0843737	28.335516	110	3	1.12	0.95	101.3962	0.6564	0.0000	0.0000;
	867	1	0	0	0	0	1	1.0843736	28.335517	110	3	1.12	0.95	101.3962	0.6564	0.0000	0.0000;
	868	1	5.75	1.846	0	0	1	1.0818057	29.226028	110	3	1.12	0.95	101.0482	-0.2009	0.0000	0.0000;
	869	1	2.987	0.842	0	0	1	1.08177	29.221206	110	3	1.12	0.95	101.0498	-0.1999	0.0000	0.0000;
	870	1	5.985	-1.614	0	0	1	1.0799302	28.253142	110	3	1.12	0.95	101.6291	0.0353	0.0000	0.0000;
	871	1	4.598	-1.286	0	0	1	1.0799615	28.255179	110	3	1.12	0.95	101.6272	0.0351	0.0000	0.0000;
	872	1	2.181	0.517	0	0	1	1.064334	26.483359	110	3	1.12	0.95	103.1689	0.0266	0.0000	0.0000;
	873	1	2.295	0	0	0	1	1.0740212	27.045117	110	3	1.12	0.95	101.8754	-0.6081	0.0000	0.0000;
	874	1	0	0	0	0	1	1.0643481	26.484142	110	3	1.12	0.95	103.1670	0.0262	0.0000	0.0000;
	875	1	2.18	2.006	0	0	1	1.0849135	29.013099	110	3	1.12	0.95	100.7434	0.4903	0.0000	0.0000;
	876	1	1.377	0.446	0	0	1	1.0848423	29.000916	110	3	1.12	0.95	100.7478	0.4909	0.0000	0.0000;
	877	2	3.902	2.918	0	0	1	1.0901923	31.055925	110	3	1.12	0.95	99.6941	-0.0000	0.0000	0.0000;
	878	1	9.412	2.109	0	0	1	1.0865275	30.726142	110	3	1.12	0.95	100.0785	0.0947	0.0000	0.0000;
	879	1	8.194	2.991	0	0	1	1.0659455	27.571671	110	3	1.12	0.95	103.2698	0.9034	0.0000	0.0000;
	880	1	4.256	1.337	0	0	1	1.0762017	31.466876	110	3	1.12	0.95	103.1112	-0.1224	0.0000	0.0000;
	881	1	0	0	0	0	1	1.0771513	31.514717	110	3	1.12	0.95	102.9863	-0.1567	0.0000	0.0000;
	882	1	4.019	0.985	0	0	1	1.0682389	26.420684	110	3	1.12	0.95	102.8679	-0.2894	0.0000	0.0000;
	883	1	5.394	1.367	0	0	1	1.0682312	26.412403	110	3	1.12	0.95	102.8703	-0.2887	0.0000	0.0000;
	884	1	10.327	2.155	0	0	1	1.0990898	30.242636	110	3	1.12	0.95	99.2188	0.2013	0.0000	0.0000;
	885	1	0	0	0	0	1	1.0991174	30.245069	110	3	1.12	0.95	99.2153	0.2015	0.0000	0.0000;
	886	1	2.529	0.904	0	0	1	1.0824721	29.423957	110	3	1.12	0.95	100.8933	-0.1930	0.0000	0.0000;
	887	1	1.263	0.513	0	0	1	1.0819442	29.442823	110	3	1.12	0.95	100.8971	-0.1598	0.0000	0.0000;
	888	1	0	0	0	0	1	1.0825121	29.425736	110	3	1.12	0.95	100.8886	-0.1946	0.0000	0.0000;
	889	1	0	0	0	0	1	1.0819652	29.443683	110	3	1.12	0.95	100.8948	-0.1608	0.0000	0.0000;
	890	1	0	0	0	0	1	1.1015237	35.34969	110	3	1.12	0.95	98.3206	0.0273	0.0000	0.0000;
	891	1	1.492	0.223	0	0	1	1.1015092	35.364126	110	3	1.12	0.95	98.3257	0.0264	0.0000	0.0000;
	892	1	3.104	0.777	0	0	1	1.0767091	27.785456	110	3	1.12	0.95	101.8700	0.1594	0.0000	0.0000;
	893	1	0	0	0	0	1	1.0771577	27.829159	110	3	1.12	0.95	101.8152	0.1493	0.0000	0.0000;
	894	1	8.039	2.711	0	0	1	1.0815776	29.775285	110	3	1.12	0.95	100.6645	-0.0540	0.0000	0.0000;
	895	1	0	0	0	0	1	1.0816057	29.764437	110	3	1.12	0.95	100.6656	-0.0550	0.0000	0.0000;
	896	1	5.858	1.111	0	0	1	1.086169	29.603428	110	3	1.12	0.95	100.6691	-0.3108	0.0000	0.0000;
	897	1	3.674	0.22	0	0	1	1.0788624	29.039606	110	3	1.12	0.95	102.0346	-0.2384	0.0000	0.0000;
	898	1	0	0	0	0	1	1.0870708	29.648441	110	3	1.12	0.95	100.5310	-0.3326	0.0000	0.0000;
	899	1	10.9	2.971	0	0	1	1.0856554	32.797936	110	3	1.12	0.95	100.8616	0.0286	0.0000	0.0000;
	900	2	3	5	0	0	1	1.0829685	29.80837	110	3	1.12	0.95	100.4491	0.0000	0.0000	0.0000;
	901	1	7.458	1.486	0	0	1	1.0896019	30.57478	110	3	1.12	0.95	99.5426	0.0425	0.0000	0.0000;
	902	1	0	0	0	0	1	1.0950704	30.035018	110	3	1.12	0.95	100.4871	-0.2516	0.0000	0.0000;
	903	1	5.978	1.715	0	0	1	1.0950316	30.031737	110	3	1.12	0.95	100.4909	-0.2501	0.0000	0.0000;
	904	1	7.238	1.611	0	0	1	1.067955	26.319609	110	3	1.12	0.95	102.9678	-0.2911	0.0000	0.0000;
	905	1	7.924	1.82	0	0	1	1.0679791	26.316453	110	3	1.12	0.95	102.9683	-0.2909	0.0000	0.0000;
	906	1	12.424	0.975	0	0	1	1.0487023	27.267633	110	3	1.12	0.95	106.1753	0.8104	0.0000	0.0000;
	907	1	0	0	0	0	1	1.0487023	27.267633	110	3	1.12	0.95	106.1754	0.8104	0.0000	0.0000;
	908	1	8.611	1.597	0	0	1	1.0938089	29.782394	110	3	1.12	0.95	99.9996	0.1457	0.0000	0.0000;
	909	1	4.591	0.854	0	0	1	1.0862299	30.577226	110	3	1.12	0.95	100.2148	0.0781	0.0000	0.0000;
	910	1	1.606	0.149	0	0	1	1.0989595	30.218207	110	3	1.12	0.95	99.2464	0.2000	0.0000	0.0000;
	911	1	0	0	0	0	1	1.0991783	30.244023	110	3	1.12	0.95	99.2153	0.1979	0.0000	0.0000;
	912	1	0	0	0	0	1	1.0965612	31.478473	110	3	1.12	0.95	98.7866	-0.0833	0.0000	0.0000;
	913	1	9.753	1.486	0	0	1	1.0920096	31.527736	110	3	1.12	0.95	99.1827	0.0926	0.0000	0.0000;
	914	1	16.064	4.457	0	0	1	1.0919258	31.524906	110	3	1.12	0.95	99.1914	0.0967	0.0000	0.0000;
	915	1	14.957	3.863	0	0	1	1.0964189	31.471596	110	3	1.12	0.95	98.8049	-0.0786	0.0000	0.0000;
	916	1	12.744	-0.208	0	0	1	1.0804356	28.243594	110	3	1.12	0.95	101.5390	0.1129	0.0000	0.0000;
	917	1	7.002	1.97	0	0	1	1.080394	28.229833	110	3	1.12	0.95	101.5409	0.1130	0.0000	0.0000;
	918	1	0.574	0.209	0	0	1	1.0917513	30.462304	110	3	1.12	0.95	100.0060	-0.5394	0.0000	0.0000;
	919	1	2.874	0.839	0	0	1	1.091741	30.459689	110	3	1.12	0.95	100.0065	-0.5390	0.0000	0.0000;
	920	1	17.899	5.571	0	0	1	1.0830622	28.505915	110	3	1.12	0.95	101.5034	0.8065	0.0000	0.0000;
	921	1	5.049	1.783	0	0	1	1.0853326	28.594422	110	3	1.12	0.95	101.3953	0.6811	0.0000	0.0000;
	922	1	3.789	0.814	0	0	1	1.0857831	30.007053	110	3	1.12	0.95	100.1460	0.0042	0.0000	0.0000;
	923	1	0	0	0	0	1	1.0862074	30.054625	110	3	1.12	0.95	100.0937	0.0011	0.0000	0.0000;
	924	1	0	0	0	0	1	1.0858202	30.010296	110	3	1.12	0.95	100.1417	0.0033	0.0000	0.0000;
	925	1	0	0	0	0	1	1.0862064	30.054641	110	3	1.12	0.95	100.0937	0.0011	0.0000	0.0000;
	926	1	0	0	0	0	1	1.0866022	32.489508	110	3	1.12	0.95	101.0694	0.0382	0.0000	0.0000;
	927	1	3.334	0.484	0	0	1	1.0866077	32.479357	110	3	1.12	0.95	101.0695	0.0392	0.0000	0.0000;
	928	1	6.893	1.951	0	0	1	1.0828883	28.482076	110	3	1.12	0.95	101.2545	0.3950	0.0000	0.0000;
	929	1	7.467	2.322	0	0	1	1.091553	29.603347	110	3	1.12	0.95	100.2041	0.2270	0.0000	0.0000;
	930	1	7.7	2.327	0	0	1	1.0610632	26.398313	110	3	1.12	0.95	103.7517	0.2383	0.0000	0.0000;
	931	1	7.477	-1.212	0	0	1	1.0611153	26.399193	110	3	1.12	0.95	103.7476	0.2344	0.0000	0.0000;
	932	1	6.884	-0.9	0	0	1	1.0814795	28.495814	110	3	1.12	0.95	101.5889	0.5469	0.0000	0.0000;
	933	1	6.081	1.411	0	0	1	1.0814628	28.490078	110	3	1.12	0.95	101.5880	0.5477	0.0000	0.0000;
	934	1	7.463	1.653	0	0	1	1.0744291	27.434651	110	3	1.12	0.95	102.5688	0.8506	0.0000	0.0000;
	935	1	8.17	2.321	0	0	1	1.0744912	27.438805	110	3	1.12	0.95	102.5660	0.8484	0.0000	0.0000;
	936	1	0	0	0	0	1	1.0857599	30.017628	110	3	1.12	0.95	100.1437	0.0128	0.0000	0.0000;
	937	1	0	0	0	0	1	1.0857531	30.017734	110	3	1.12	0.95	100.1437	0.0132	0.0000	0.0000;
	938	1	0.654	0.224	0	0	1	1.0885452	29.122198	110	3	1.12	0.95	100.3087	0.0482	0.0000	0.0000;
	939	1	2.743	0.898	0	0	1	1.0885388	29.120466	110	3	1.12	0.95	100.3095	0.0504	0.0000	0.0000;
	940	1	4.133	1.334	0	0	1	1.0886139	29.078179	110	3	1.12	0.95	100.7102	0.2552	0.0000	0.0000;
	941	1	0	0	0	0	1	1.0885829	29.077278	110	3	1.12	0.95	100.7113	0.2557	0.0000	0.0000;
	942	1	5.737	1.114	0	0	1	1.0981519	29.556868	110	3	1.12	0.95	100.1102	0.2793	0.0000	0.0000;
	943	1	4.59	0.743	0	0	1	1.0973939	29.161517	110	3	1.12	0.95	100.4683	0.1809	0.0000	0.0000;
	944	1	0	0	0	0	1	1.0985243	29.593148	110	3	1.12	0.95	100.0657	0.2714	0.0000	0.0000;
	945	1	6.547	1.928	0	0	1	1.0965611	31.478477	110	3	1.12	0.95	98.7867	-0.0833	0.0000	0.0000;
	946	1	4.478	0.963	0	0	1	1.0921013	31.533346	110	3	1.12	0.95	99.1693	0.0906	0.0000	0.0000;
	947	1	0	0	0	0	1	1.0812433	29.175805	110	3	1.12	0.95	101.1106	-0.1621	0.0000	0.0000;
	948	1	3.562	0.857	0	0	1	1.0812765	29.181159	110	3	1.12	0.95	101.1087	-0.1628	0.0000	0.0000;
	949	1	4.367	1.563	0	0	1	1.0934181	29.948612	110	3	1.12	0.95	100.6833	-0.1817	0.0000	0.0000;
	950	1	0	0	0	0	1	1.0942049	30.00974	110	3	1.12	0.95	100.6139	-0.2037	0.0000	0.0000;
	951	1	4.602	0.919	0	0	1	1.0765984	30.001405	110	3	1.12	0.95	100.8558	0.7240	0.0000	0.0000;
	952	1	0	0	0	0	1	1.0767454	30.008463	110	3	1.12	0.95	100.8338	0.7197	0.0000	0.0000;
	953	1	6.319	1.823	0	0	1	1.0833865	28.847944	110	3	1.12	0.95	100.9047	0.5191	0.0000	0.0000;
	954	1	8.609	1.441	0	0	1	1.0834362	28.856196	110	3	1.12	0.95	100.9018	0.5188	0.0000	0.0000;
	955	1	9.963	1.909	0	0	1	1.0768456	27.769765	110	3	1.12	0.95	102.0196	0.1573	0.0000	0.0000;
	956	1	5.672	-2.004	0	0	1	1.076914	27.782717	110	3	1.12	0.95	102.0161	0.1577	0.0000	0.0000;
	957	1	3.442	0	0	0	1	1.0957591	30.196494	110	3	1.12	0.95	100.3724	-0.2067	0.0000	0.0000;
	958	1	0	0	0	0	1	1.095901	30.213844	110	3	1.12	0.95	100.3449	-0.2062	0.0000	0.0000;
	959	1	3.104	0.772	0	0	1	1.0635957	26.138599	110	3	1.12	0.95	103.0716	-0.2819	0.0000	0.0000;
	960	1	0	0	0	0	1	1.0635538	26.132088	110	3	1.12	0.95	103.0746	-0.2809	0.0000	0.0000;
	961	1	2.413	0.222	0	0	1	1.0775806	29.716888	110	3	1.12	0.95	101.0169	0.4552	0.0000	0.0000;
	962	1	0	0	0	0	1	1.0775552	29.711815	110	3	1.12	0.95	101.0160	0.4555	0.0000	0.0000;
	963	1	0	0	0	0	1	1.0857793	33.07943	110	3	1.12	0.95	100.6781	0.1225	0.0000	0.0000;
	964	1	1.836	0.297	0	0	1	1.0857635	33.083014	110	3	1.12	0.95	100.6786	0.1231	0.0000	0.0000;
	965	1	4.712	1.282	0	0	1	1.0683856	28.594746	110	3	1.12	0.95	102.8596	0.3421	0.0000	0.0000;
	966	1	0	0	0	0	1	1.0684284	28.60316	110	3	1.12	0.95	102.8543	0.3408	0.0000	0.0000;
	967	1	4.59	3.714	0	0	1	1.0985046	29.591068	110	3	1.12	0.95	100.0681	0.2717	0.0000	0.0000;
	968	1	0	0	0	0	1	1.0985027	29.585553	110	3	1.12	0.95	100.0695	0.2713	0.0000	0.0000;
	969	1	6.838	1.258	0	0	1	1.0957583	29.882521	110	3	1.12	0.95	99.6120	0.2670	0.0000	0.0000;
	970	1	0	0	0	0	1	1.0957975	29.890185	110	3	1.12	0.95	99.6094	0.2665	0.0000	0.0000;
	971	1	3.675	0.314	0	0	1	1.0872462	30.330175	110	3	1.12	0.95	99.8168	0.1001	0.0000	0.0000;
	972	1	4.94	0.619	0	0	1	1.0872154	30.3222	110	3	1.12	0.95	99.8169	0.1005	0.0000	0.0000;
	973	1	4.821	1.077	0	0	1	1.089415	31.066378	110	3	1.12	0.95	99.7005	0.0442	0.0000	0.0000;
	974	1	4.361	1.226	0	0	1	1.0894222	31.068455	110	3	1.12	0.95	99.6994	0.0439	0.0000	0.0000;
	975	2	18.366	8.204	0	0	1	1.0881579	29.14287	110	3	1.12	0.95	100.6838	0.2888	0.0000	0.0000;
	976	2	0	4	0	0	1	1.0977934	29.809318	110	3	1.12	0.95	99.8359	0.0000	0.0000	0.0000;
	977	1	3.329	1.003	0	0	1	1.1035023	30.686303	110	3	1.12	0.95	98.6611	0.1064	0.0000	0.0000;
	978	1	6.774	1.894	0	0	1	1.1034279	30.672115	110	3	1.12	0.95	98.6659	0.1068	0.0000	0.0000;
	979	1	12.277	6.261	0	0	1	1.1051877	30.305528	110	3	1.12	0.95	99.2936	0.1630	0.0000	0.0000;
	980	2	0	0	0	0	1	1.1053226	30.321701	110	3	1.12	0.95	99.2887	0.1610	0.0000	0.0000;
	981	1	8.498	2.266	0	0	1	1.089731	31.154366	110	3	1.12	0.95	99.6083	0.0755	0.0000	0.0000;
	982	1	0	0	0	0	1	1.0897426	31.161702	110	3	1.12	0.95	99.6062	0.0757	0.0000	0.0000;
	983	1	1.377	0.446	0	0	1	1.07507	31.184493	110	3	1.12	0.95	103.4939	-0.2029	0.0000	0.0000;
	984	1	0	0	0	0	1	1.0750704	31.184549	110	3	1.12	0.95	103.4939	-0.2029	0.0000	0.0000;
	985	1	4.597	1.271	0	0	1	1.0987225	30.603409	110	3	1.12	0.95	100.0809	-0.1759	0.0000	0.0000;
	986	1	0	0	0	0	1	1.0987493	30.611629	110	3	1.12	0.95	100.0811	-0.1747	0.0000	0.0000;
	987	1	7.229	0.966	0	0	1	1.0836994	29.403855	110	3	1.12	0.95	100.8626	-0.2485	0.0000	0.0000;
	988	1	4.016	1.337	0	0	1	1.0836948	29.406541	110	3	1.12	0.95	100.8630	-0.2482	0.0000	0.0000;
	989	1	9.306	3.064	0	0	1	1.0818634	27.971458	110	3	1.12	0.95	101.9408	0.5969	0.0000	0.0000;
	990	1	4.707	1.653	0	0	1	1.0818999	27.977481	110	3	1.12	0.95	101.9414	0.5973	0.0000	0.0000;
	991	1	5.864	1.698	0	0	1	1.0945562	29.777311	110	3	1.12	0.95	99.9730	0.1207	0.0000	0.0000;
	992	1	0	0	0	0	1	1.0946905	29.788838	110	3	1.12	0.95	99.9608	0.1173	0.0000	0.0000;
	993	1	9.528	1.521	0	0	1	1.0809635	28.351349	110	3	1.12	0.95	101.4896	0.0239	0.0000	0.0000;
	994	1	13.436	1.099	0	0	1	1.0809216	28.341989	110	3	1.12	0.95	101.4941	0.0241	0.0000	0.0000;
	995	1	6.774	2.266	0	0	1	1.084739	28.668339	110	3	1.12	0.95	101.0762	0.3501	0.0000	0.0000;
	996	1	4.252	1.491	0	0	1	1.0928435	29.709553	110	3	1.12	0.95	100.0837	0.1795	0.0000	0.0000;
	997	1	13.208	3.313	0	0	1	1.0819826	28.452208	110	3	1.12	0.95	101.3009	0.0120	0.0000	0.0000;
	998	1	12.633	2.918	0	0	1	1.0761829	27.43457	110	3	1.12	0.95	102.1341	0.1655	0.0000	0.0000;
	999	1	12.865	4.795	0	0	1	1.0850597	30.56964	110	3	1.12	0.95	100.2513	0.1291	0.0000	0.0000;
	1000	1	7.458	1.486	0	0	1	1.0850857	30.570805	110	3	1.12	0.95	100.2506	0.1288	0.0000	0.0000;
	1001	2	24.884	53.714	0	0	1	1.102298	35.641565	110	3	1.12	0.95	98.2333	0.0000	0.0000	0.0000;
	1002	2	24.884	52.972	0	0	1	1.1005301	35.949744	110	3	1.12	0.95	98.3150	0.0000	0.0000	0.0000;
	1003	1	3.791	0.562	0	0	1	1.0843326	32.387191	110	3	1.12	0.95	101.2734	0.1182	0.0000	0.0000;
	1004	1	2.986	0.169	0	0	1	1.0843168	32.39388	110	3	1.12	0.95	101.2741	0.1177	0.0000	0.0000;
	1005	2	17.548	6.78	0	0	1	1.102805	30.067675	110	3	1.12	0.95	99.5534	0.2022	0.0000	0.0000;
	1006	2	0	0	0	0	1	1.1027837	30.062156	110	3	1.12	0.95	99.5548	0.2022	0.0000	0.0000;
	1007	2	0	0	0	0	1	1.0942396	29.785602	110	3	1.12	0.95	99.9809	0.1321	0.0000	0.0000;
	1008	1	0	0	0	0	1	1.0942408	29.785856	110	3	1.12	0.95	99.9808	0.1321	0.0000	0.0000;
	1009	1	2.295	0.607	0	0	1	1.0741288	27.8668	110	3	1.12	0.95	101.9757	0.3146	0.0000	0.0000;
	1010	1	10.616	3.662	0	0	1	1.0740451	27.85263	110	3	1.12	0.95	101.9818	0.3150	0.0000	0.0000;
	1011	1	2.877	1.762	0	0	1	1.069171	26.803874	110	3	1.12	0.95	102.4422	-0.2956	0.0000	0.0000;
	1012	1	0	0	0	0	1	1.0692317	26.809958	110	3	1.12	0.95	102.4363	-0.2995	0.0000	0.0000;
	1013	2	9.169	2.961	0	0	1	1.0980995	30.088246	110	3	1.12	0.95	99.3353	0.1660	0.0000	0.0000;
	1014	1	30.999	7.137	0	0	1	1.0893353	29.178757	110	3	1.12	0.95	100.3615	0.3749	0.0000	0.0000;
	1015	2	0	0	0	0	1	1.0936423	29.656387	110	3	1.12	0.95	99.8594	0.3090	0.0000	0.0000;
	1016	1	1.725	0.732	0	0	1	1.1023904	31.093826	110	3	1.12	0.95	99.7220	-0.1613	0.0000	0.0000;
	1017	1	0	0	0	0	1	1.1023946	31.093971	110	3	1.12	0.95	99.7215	-0.1615	0.0000	0.0000;
	1018	1	4.59	1.114	0	0	1	1.0812473	29.524889	110	3	1.12	0.95	100.8620	-0.1039	0.0000	0.0000;
	1019	1	5.737	1.114	0	0	1	1.0812865	29.515867	110	3	1.12	0.95	100.8625	-0.1050	0.0000	0.0000;
	1020	1	3.681	0.863	0	0	1	1.0512239	25.584586	110	3	1.12	0.95	104.6600	0.0841	0.0000	0.0000;
	1021	1	0	0	0	0	1	1.0512534	25.587206	110	3	1.12	0.95	104.6565	0.0833	0.0000	0.0000;
	1022	1	0	0.149	0	0	1	1.0863303	30.698447	110	3	1.12	0.95	100.1077	0.0978	0.0000	0.0000;
	1023	1	0	0	0	0	1	1.0863339	30.698386	110	3	1.12	0.95	100.1077	0.0976	0.0000	0.0000;
	1024	2	35.022	15.01	0	0	1	1.0765009	27.442381	110	3	1.12	0.95	102.5270	0.6994	0.0000	0.0000;
	1025	2	0	0	0	0	1	1.0765369	27.459	110	3	1.12	0.95	102.5212	0.6992	0.0000	0.0000;
	1026	2	0	0	0	0	1	1.0764979	27.462936	110	3	1.12	0.95	102.5226	0.7002	0.0000	0.0000;
	1027	1	0	0	0	0	1	1.0852664	28.575428	110	3	1.12	0.95	101.2179	0.5689	0.0000	0.0000;
	1028	1	0	0	0	0	1	1.0840441	29.90463	110	3	1.12	0.95	100.2804	0.0680	0.0000	0.0000;
	1029	1	0	0	0	0	1	1.0840439	29.904633	110	3	1.12	0.95	100.2804	0.0680	0.0000	0.0000;
	1030	1	0	0	0	0	1	1.0942399	29.785598	110	3	1.12	0.95	99.9809	0.1321	0.0000	0.0000;
	1031	1	0	0	0	0	1	1.094241	29.785852	110	3	1.12	0.95	99.9808	0.1321	0.0000	0.0000;
	1032	1	0	0	0	0	1	1.0826059	29.431293	110	3	1.12	0.95	100.8779	-0.1962	0.0000	0.0000;
	1033	1	0	0	0	0	1	1.0826056	29.431297	110	3	1.12	0.95	100.8779	-0.1962	0.0000	0.0000;
	1034	1	0	0	0	0	1	1.0938606	29.787172	110	3	1.12	0.95	99.9936	0.1445	0.0000	0.0000;
	1035	1	0	0	0	0	1	1.1018972	30.547364	110	3	1.12	0.95	98.8347	0.1577	0.0000	0.0000;
	1036	1	0.688	0.136	0	0	1	1.1017714	30.523966	110	3	1.12	0.95	98.8430	0.1590	0.0000	0.0000;
	1037	1	0	0	0	0	1	1.1096904	30.563373	110	3	1.12	0.95	98.9855	0.0012	0.0000	0.0000;
	1038	1	0.229	0	0	0	1	1.1096857	30.562353	110	3	1.12	0.95	98.9859	0.0012	0.0000	0.0000;
	1039	1	2.524	0.966	0	0	1	1.0858134	30.552012	110	3	1.12	0.95	100.2471	0.0922	0.0000	0.0000;
	1040	1	0	0	0	0	1	1.0858306	30.553175	110	3	1.12	0.95	100.2456	0.0917	0.0000	0.0000;
	1041	1	2.869	0.371	0	0	1	1.0919079	29.274095	110	3	1.12	0.95	100.4603	0.1454	0.0000	0.0000;
	1042	1	0.574	0.223	0	0	1	1.0919104	29.274055	110	3	1.12	0.95	100.4603	0.1454	0.0000	0.0000;
	1043	1	0	0	0	0	1	1.1096904	30.563373	110	3	1.12	0.95	98.9855	0.0012	0.0000	0.0000;
	1044	1	0	0	0	0	1	1.109686	30.562415	110	3	1.12	0.95	98.9858	0.0012	0.0000	0.0000;
	1045	1	15.163	1.82	0	0	1	1.0822216	28.402952	110	3	1.12	0.95	101.3467	0.4058	0.0000	0.0000;
	1046	1	0	0	0	0	1	1.0915599	29.603235	110	3	1.12	0.95	100.2041	0.2266	0.0000	0.0000;
	1047	1	8.376	1.411	0	0	1	1.0756156	27.496317	110	3	1.12	0.95	102.4590	0.7944	0.0000	0.0000;
	1048	1	6.77	1.56	0	0	1	1.0757186	27.507087	110	3	1.12	0.95	102.4536	0.7916	0.0000	0.0000;
	1049	1	10.346	0.987	0	0	1	1.1024194	30.558031	110	3	1.12	0.95	98.8204	0.1819	0.0000	0.0000;
	1050	1	8.505	1.209	0	0	1	1.1024928	30.571944	110	3	1.12	0.95	98.8142	0.1824	0.0000	0.0000;
	1051	1	0.459	0.134	0	0	1	1.0914496	30.561519	110	3	1.12	0.95	99.9259	-0.4947	0.0000	0.0000;
	1052	1	0	0.059	0	0	1	1.0913996	30.564318	110	3	1.12	0.95	99.9254	-0.4931	0.0000	0.0000;
	1053	1	3.442	0.446	0	0	1	1.0917674	33.422367	110	3	1.12	0.95	99.8974	-0.1436	0.0000	0.0000;
	1054	1	0	0.111	0	0	1	1.092301	33.3098	110	3	1.12	0.95	99.9733	-0.1346	0.0000	0.0000;
	1055	1	2.527	0.761	0	0	1	1.0871151	30.887666	110	3	1.12	0.95	99.6566	-0.0449	0.0000	0.0000;
	1056	1	0	0	0	0	1	1.0871883	30.890392	110	3	1.12	0.95	99.6467	-0.0477	0.0000	0.0000;
	1057	1	7.014	0.424	0	0	1	1.0791822	31.934186	110	3	1.12	0.95	102.4985	-0.1167	0.0000	0.0000;
	1058	1	0	0	0	0	1	1.0791804	31.928022	110	3	1.12	0.95	102.5008	-0.1170	0.0000	0.0000;
	1059	1	5.163	1.56	0	0	1	1.0858143	30.022308	110	3	1.12	0.95	100.1296	0.0117	0.0000	0.0000;
	1060	1	3.901	0.52	0	0	1	1.0862208	30.054483	110	3	1.12	0.95	100.0932	0.0003	0.0000	0.0000;
	1061	1	3.442	3.64	0	0	1	1.0845276	30.474503	110	3	1.12	0.95	100.3481	0.1363	0.0000	0.0000;
	1062	1	6.77	1.263	0	0	1	1.0845097	30.471238	110	3	1.12	0.95	100.3493	0.1365	0.0000	0.0000;
	1063	1	2.068	0.513	0	0	1	1.058321	25.680783	110	3	1.12	0.95	103.6921	-0.1184	0.0000	0.0000;
	1064	1	8.517	2.718	0	0	1	1.0502012	27.868335	110	3	1.12	0.95	105.4496	1.0632	0.0000	0.0000;
	1065	1	0	0	0	0	1	1.0502178	27.876761	110	3	1.12	0.95	105.4483	1.0633	0.0000	0.0000;
	1066	1	1.377	0.223	0	0	1	1.084912	28.182146	110	3	1.12	0.95	101.6614	0.5065	0.0000	0.0000;
	1067	1	3.099	0.761	0	0	1	1.084998	28.194211	110	3	1.12	0.95	101.6566	0.5061	0.0000	0.0000;
	1068	1	0.459	0.113	0	0	1	1.0849444	28.185639	110	3	1.12	0.95	101.6571	0.5059	0.0000	0.0000;
	1069	1	3.213	0.446	0	0	1	1.0889829	32.939025	110	3	1.12	0.95	100.4616	-0.0830	0.0000	0.0000;
	1070	1	11.474	1.189	0	0	1	1.0890065	32.943151	110	3	1.12	0.95	100.4586	-0.0834	0.0000	0.0000;
	1071	1	2.755	0.854	0	0	1	1.0873249	30.892815	110	3	1.12	0.95	99.8784	0.1153	0.0000	0.0000;
	1072	1	3.214	0.929	0	0	1	1.0873801	30.902318	110	3	1.12	0.95	99.8759	0.1140	0.0000	0.0000;
	1073	1	7.583	1.504	0	0	1	1.078161	27.94549	110	3	1.12	0.95	101.8500	0.1027	0.0000	0.0000;
	1074	1	6.893	1.385	0	0	1	1.0781509	27.939745	110	3	1.12	0.95	101.8499	0.1032	0.0000	0.0000;
	1075	1	2.987	0.767	0	0	1	1.0954989	34.524474	110	3	1.12	0.95	99.0792	-0.0272	0.0000	0.0000;
	1076	1	5.403	1.618	0	0	1	1.0955113	34.550066	110	3	1.12	0.95	99.0766	-0.0260	0.0000	0.0000;
	1077	1	0	0	0	0	1	1.0684258	26.311916	110	3	1.12	0.95	102.9614	-0.3081	0.0000	0.0000;
	1078	1	0	0	0	0	1	1.0684391	26.316982	110	3	1.12	0.95	102.9563	-0.3088	0.0000	0.0000;
	1079	1	3.909	2.082	0	0	1	1.0817236	32.419039	110	3	1.12	0.95	101.9290	-0.0858	0.0000	0.0000;
	1080	1	1.837	0.147	0	0	1	1.0817234	32.417256	110	3	1.12	0.95	101.9296	-0.0858	0.0000	0.0000;
	1081	1	5.852	0.371	0	0	1	1.0843304	29.428946	110	3	1.12	0.95	100.8069	-0.2898	0.0000	0.0000;
	1082	1	0	0	0	0	1	1.0844007	29.448275	110	3	1.12	0.95	100.7837	-0.2911	0.0000	0.0000;
	1083	1	0	0	0	0	1	1.084346	29.430787	110	3	1.12	0.95	100.8044	-0.2899	0.0000	0.0000;
	1084	1	0	0	0	0	1	1.0844001	29.448283	110	3	1.12	0.95	100.7837	-0.2911	0.0000	0.0000;
	1085	1	2.756	0.311	0	0	1	1.0930255	33.925411	110	3	1.12	0.95	99.5611	-0.0713	0.0000	0.0000;
	1086	1	2.181	0.375	0	0	1	1.0930393	33.905214	110	3	1.12	0.95	99.5618	-0.0730	0.0000	0.0000;
	1087	1	1.722	0.828	0	0	1	1.072021	27.36148	110	3	1.12	0.95	101.5931	-0.4450	0.0000	0.0000;
	1088	1	1.606	0.744	0	0	1	1.0720538	27.354595	110	3	1.12	0.95	101.5954	-0.4452	0.0000	0.0000;
	1089	1	5.737	0.743	0	0	1	1.0945156	31.197417	110	3	1.12	0.95	98.6853	0.0855	0.0000	0.0000;
	1090	1	0	0	0	0	1	1.0945988	31.218098	110	3	1.12	0.95	98.6749	0.0858	0.0000	0.0000;
	1091	1	7.343	0.297	0	0	1	1.092303	33.309739	110	3	1.12	0.95	99.9733	-0.1348	0.0000	0.0000;
	1092	1	2.295	0.817	0	0	1	1.0918182	33.425921	110	3	1.12	0.95	99.8898	-0.1445	0.0000	0.0000;
	1093	1	5.168	1.78	0	0	1	1.073171	27.618767	110	3	1.12	0.95	101.2521	-0.4170	0.0000	0.0000;
	1094	1	0	0	0	0	1	1.0733851	27.626038	110	3	1.12	0.95	101.2237	-0.4265	0.0000	0.0000;
	1095	1	5.512	1.26	0	0	1	1.0612793	25.854038	110	3	1.12	0.95	103.6339	-0.1621	0.0000	0.0000;
	1096	1	2.644	0.681	0	0	1	1.0612588	25.850792	110	3	1.12	0.95	103.6323	-0.1635	0.0000	0.0000;
	1097	1	3.786	0.817	0	0	1	1.1019551	29.987195	110	3	1.12	0.95	99.6737	0.2387	0.0000	0.0000;
	1098	1	0	0	0	0	1	1.1060698	30.373728	110	3	1.12	0.95	99.2224	0.1374	0.0000	0.0000;
	1099	1	0	0	0	0	1	1.1020717	29.995029	110	3	1.12	0.95	99.6587	0.2356	0.0000	0.0000;
	1100	1	0	0	0	0	1	1.1060688	30.373745	110	3	1.12	0.95	99.2224	0.1374	0.0000	0.0000;
	1101	1	0	0	0	0	1	1.095574	30.109054	110	3	1.12	0.95	100.4180	-0.2482	0.0000	0.0000;
	1102	1	5.163	0.669	0	0	1	1.0955865	30.105637	110	3	1.12	0.95	100.4165	-0.2493	0.0000	0.0000;
	1103	1	0	0	0	0	1	1.0978057	29.427779	110	3	1.12	0.95	100.2285	0.2515	0.0000	0.0000;
	1104	1	7.233	1.597	0	0	1	1.0847016	29.926799	110	3	1.12	0.95	100.2517	0.0403	0.0000	0.0000;
	1105	1	0	0	0	0	1	1.0978022	29.427837	110	3	1.12	0.95	100.2285	0.2517	0.0000	0.0000;
	1106	1	0	0	0	0	1	1.0849497	29.949561	110	3	1.12	0.95	100.2242	0.0343	0.0000	0.0000;
	1107	1	1.034	0.493	0	0	1	1.0889681	33.061872	110	3	1.12	0.95	100.4147	-0.0878	0.0000	0.0000;
	1108	1	1.608	-0.327	0	0	1	1.0889573	33.058942	110	3	1.12	0.95	100.4167	-0.0873	0.0000	0.0000;
	1109	1	2.295	0.594	0	0	1	1.09015	31.147673	110	3	1.12	0.95	99.6053	0.0243	0.0000	0.0000;
	1110	1	0	0	0	0	1	1.0901256	31.143101	110	3	1.12	0.95	99.6073	0.0249	0.0000	0.0000;
	1111	1	4.362	-0.721	0	0	1	1.0763991	31.306805	110	3	1.12	0.95	103.2275	-0.1955	0.0000	0.0000;
	1112	1	4.134	-0.807	0	0	1	1.0520826	27.500389	110	3	1.12	0.95	105.7450	0.6997	0.0000	0.0000;
	1113	2	4.303	8.12	0	0	1	1.0948005	29.516867	110	3	1.12	0.95	100.1524	0.0695	0.0000	0.0000;
	1114	2	0	0	0	0	1	1.0862757	30.060646	110	3	1.12	0.95	100.0861	-0.0006	0.0000	0.0000;
	1115	2	0	0	0	0	1	1.0977473	29.428772	110	3	1.12	0.95	100.2284	0.2550	0.0000	0.0000;
	1116	1	3.675	1.652	0	0	1	1.0978891	34.553359	110	3	1.12	0.95	98.8464	-0.0109	0.0000	0.0000;
	1117	1	4.134	0.842	0	0	1	1.0978675	34.532715	110	3	1.12	0.95	98.8510	-0.0121	0.0000	0.0000;
	1118	1	7.455	1.843	0	0	1	1.0597211	26.767043	110	3	1.12	0.95	103.7166	1.6592	0.0000	0.0000;
	1119	1	7.711	1.097	0	0	1	1.0598991	26.784427	110	3	1.12	0.95	103.7061	1.6554	0.0000	0.0000;
	1120	1	8.835	5.571	0	0	1	1.0608271	26.51753	110	3	1.12	0.95	103.7557	0.4502	0.0000	0.0000;
	1121	1	0.688	0	0	0	1	1.0609893	26.530922	110	3	1.12	0.95	103.7488	0.4474	0.0000	0.0000;
	1122	1	0	0	0	0	1	1.095589	30.112526	110	3	1.12	0.95	100.4151	-0.2469	0.0000	0.0000;
	1123	1	2.066	0.233	0	0	1	1.0955718	30.101482	110	3	1.12	0.95	100.4197	-0.2510	0.0000	0.0000;
	1124	1	0	0	0	0	1	1.0955888	30.112533	110	3	1.12	0.95	100.4151	-0.2469	0.0000	0.0000;
	1125	1	0	0	0	0	1	1.0955979	30.103479	110	3	1.12	0.95	100.4157	-0.2515	0.0000	0.0000;
	1126	1	2.641	0.759	0	0	1	1.0952762	30.045325	110	3	1.12	0.95	100.4641	-0.2688	0.0000	0.0000;
	1127	1	0	0	0	0	1	1.0957688	30.092914	110	3	1.12	0.95	100.3965	-0.2700	0.0000	0.0000;
	1128	1	0	0	0	0	1	1.0953099	30.04798	110	3	1.12	0.95	100.4608	-0.2697	0.0000	0.0000;
	1129	1	0	0	0	0	1	1.0957688	30.092914	110	3	1.12	0.95	100.3965	-0.2700	0.0000	0.0000;
	1130	1	13.111	4.08	0	0	1	1.0917587	30.076236	110	3	1.12	0.95	99.9979	-0.4079	0.0000	0.0000;
	1131	1	9.653	2.022	0	0	1	1.0950041	30.030223	110	3	1.12	0.95	100.5021	-0.2611	0.0000	0.0000;
	1132	1	5.625	2.729	0	0	1	1.0950784	30.089551	110	3	1.12	0.95	100.4309	-0.2225	0.0000	0.0000;
	1133	1	4.592	2.644	0	0	1	1.0950955	30.088244	110	3	1.12	0.95	100.4298	-0.2235	0.0000	0.0000;
	1134	1	2.871	0.464	0	0	1	1.0833324	29.544983	110	3	1.12	0.95	101.3211	-0.2583	0.0000	0.0000;
	1135	1	4.6	2.57	0	0	1	1.0833107	29.53705	110	3	1.12	0.95	101.3206	-0.2585	0.0000	0.0000;
	1136	1	2.639	0.669	0	0	1	1.0880851	29.136646	110	3	1.12	0.95	100.6917	0.2907	0.0000	0.0000;
	1137	1	63.567	21.246	0	0	1	1.0976528	29.234231	110	3	1.12	0.95	100.3981	0.1904	0.0000	0.0000;
	1138	1	0	0	0	0	1	1.0921876	29.190846	110	3	1.12	0.95	100.5403	0.1318	0.0000	0.0000;
	1139	1	48.535	13.743	0	0	1	1.0905621	29.045354	110	3	1.12	0.95	100.7050	0.1756	0.0000	0.0000;
	1140	1	0	0	0	0	1	1.0921875	29.190847	110	3	1.12	0.95	100.5403	0.1318	0.0000	0.0000;
	1141	1	0	0	0	0	1	1.0981481	29.270014	110	3	1.12	0.95	100.3541	0.1756	0.0000	0.0000;
	1142	1	0	0	0	0	1	1.0913627	29.112724	110	3	1.12	0.95	100.6299	0.1543	0.0000	0.0000;
	1143	1	6.884	1.857	0	0	1	1.0803395	29.093927	110	3	1.12	0.95	101.2095	-0.1366	0.0000	0.0000;
	1144	1	36.717	1.114	0	0	1	1.0803247	29.09129	110	3	1.12	0.95	101.2105	-0.1363	0.0000	0.0000;
	1145	1	0	0	0	0	1	1.0803505	29.097864	110	3	1.12	0.95	101.2069	-0.1364	0.0000	0.0000;
	1146	1	0.574	0.223	0	0	1	1.0837543	29.41848	110	3	1.12	0.95	100.8555	-0.2481	0.0000	0.0000;
	1147	1	1.492	0.297	0	0	1	1.0845667	29.463668	110	3	1.12	0.95	100.7976	-0.2796	0.0000	0.0000;
	1148	1	2.869	0	0	0	1	1.087034	33.070049	110	3	1.12	0.95	100.9327	-0.0093	0.0000	0.0000;
	1149	1	6.77	0.446	0	0	1	1.0870072	33.063455	110	3	1.12	0.95	100.9344	-0.0087	0.0000	0.0000;
	1150	1	1.836	0.594	0	0	1	1.0928729	29.362468	110	3	1.12	0.95	100.3436	0.1244	0.0000	0.0000;
	1151	1	2.869	0.669	0	0	1	1.0929039	29.367553	110	3	1.12	0.95	100.3422	0.1241	0.0000	0.0000;
	1152	2	22.277	4.929	0	0	1	1.0776482	28.29696	110	3	1.12	0.95	101.6968	0.1697	0.0000	0.0000;
	1153	2	19.878	4.431	0	0	1	1.0777506	28.303884	110	3	1.12	0.95	101.6830	0.1664	0.0000	0.0000;
	1154	2	21.336	4.716	0	0	1	1.0806526	28.765049	110	3	1.12	0.95	101.0285	0.0813	0.0000	0.0000;
	1155	1	5.738	1.546	0	0	1	1.0775424	28.282304	110	3	1.12	0.95	101.6847	0.1812	0.0000	0.0000;
	1156	1	2.869	0.773	0	0	1	1.077546	28.285056	110	3	1.12	0.95	101.6863	0.1811	0.0000	0.0000;
	1157	1	23.446	8.978	0	0	1	1.0768279	28.215726	110	3	1.12	0.95	101.7285	0.2102	0.0000	0.0000;
	1158	1	2.18	1.43	0	0	1	1.0807879	28.549431	110	3	1.12	0.95	101.2602	0.0280	0.0000	0.0000;
	1159	1	11.486	2.592	0	0	1	1.0806311	28.771717	110	3	1.12	0.95	101.0163	0.0897	0.0000	0.0000;
	1160	1	1.033	0.363	0	0	1	1.0777791	28.313707	110	3	1.12	0.95	101.6668	0.1725	0.0000	0.0000;
	1161	1	15.857	3.558	0	0	1	1.0805904	28.763799	110	3	1.12	0.95	101.0177	0.0900	0.0000	0.0000;
	1162	1	10.453	2.714	0	0	1	1.0807599	28.543036	110	3	1.12	0.95	101.2680	0.0273	0.0000	0.0000;
	1163	1	7.349	1.951	0	0	1	1.0775747	28.263075	110	3	1.12	0.95	101.6651	0.1845	0.0000	0.0000;
	1164	1	11.027	2.518	0	0	1	1.0772535	28.248266	110	3	1.12	0.95	101.7138	0.1908	0.0000	0.0000;
	1165	1	11.027	2.518	0	0	1	1.077271	28.248175	110	3	1.12	0.95	101.7103	0.1906	0.0000	0.0000;
	1166	2	0	0	0	0	1	1.0815746	28.802646	110	3	1.12	0.95	100.9451	0.0658	0.0000	0.0000;
	1167	1	3.104	0.769	0	0	1	1.0806451	28.687438	110	3	1.12	0.95	101.1186	0.0606	0.0000	0.0000;
	1168	1	0	0	0	0	1	1.0815723	28.802494	110	3	1.12	0.95	100.9454	0.0659	0.0000	0.0000;
	1169	1	0	0	0	0	1	1.0806587	28.688195	110	3	1.12	0.95	101.1168	0.0601	0.0000	0.0000;
	1170	1	4.245	0.891	0	0	1	1.1052172	30.208918	110	3	1.12	0.95	99.3171	0.1368	0.0000	0.0000;
	1171	1	0.803	0.149	0	0	1	1.1054381	30.243989	110	3	1.12	0.95	99.3094	0.1342	0.0000	0.0000;
	1172	1	0	0	0	0	1	1.08203	28.706885	110	3	1.12	0.95	101.0640	0.5403	0.0000	0.0000;
	1173	1	0	0	0	0	1	1.08203	28.706885	110	3	1.12	0.95	101.0640	0.5403	0.0000	0.0000;
	1174	1	1.836	0.371	0	0	1	1.0915826	29.560343	110	3	1.12	0.95	100.0522	0.3265	0.0000	0.0000;
	1175	1	0	0	0	0	1	1.0916094	29.562949	110	3	1.12	0.95	100.0492	0.3260	0.0000	0.0000;
	1176	1	0	0	0	0	1	1.0819854	28.707639	110	3	1.12	0.95	101.0639	0.5430	0.0000	0.0000;
	1177	1	7.692	2.043	0	0	1	1.1029405	30.635904	110	3	1.12	0.95	98.7462	0.1334	0.0000	0.0000;
	1178	1	5.166	1.449	0	0	1	1.0905176	29.528099	110	3	1.12	0.95	100.1527	0.3768	0.0000	0.0000;
	1179	2	7.721	8.817	0	0	1	1.0896108	30.919025	110	3	1.12	0.95	99.8463	-0.0000	0.0000	0.0000;
	1180	2	1.377	0.668	0	0	1	1.0883058	29.31838	110	3	1.12	0.95	100.4042	0.4092	0.0000	0.0000;
	1181	1	4.369	1.969	0	0	1	1.0680551	27.420358	110	3	1.12	0.95	103.0511	0.6268	0.0000	0.0000;
	1182	1	0	0.037	0	0	1	1.0680336	27.420019	110	3	1.12	0.95	103.0537	0.6281	0.0000	0.0000;
	1183	1	0	0	0	0	1	1.0894546	31.063561	110	3	1.12	0.95	99.7075	0.0440	0.0000	0.0000;
	1184	1	0	0	0	0	1	1.0894546	31.063561	110	3	1.12	0.95	99.7075	0.0440	0.0000	0.0000;
	1185	1	12.622	4.457	0	0	1	1.0966839	29.685155	110	3	1.12	0.95	100.2857	0.4200	0.0000	0.0000;
	1186	1	10.327	2.229	0	0	1	1.0965522	29.66292	110	3	1.12	0.95	100.2889	0.4211	0.0000	0.0000;
	1187	1	76.303	14.856	0	0	1	1.0249955	29.312736	110	3	1.12	0.95	100.0830	0.1500	0.0000	0.0000;
	1188	2	99.816	40.475	0	0	1	1.0858186	30.759893	110	3	1.12	0.95	100.0495	0.1646	0.0000	0.0000;
	1189	1	0	0	0	0	1	1.0844283	30.464067	110	3	1.12	0.95	100.3581	0.1386	0.0000	0.0000;
	1190	1	7.477	1.401	0	0	1	1.0934605	29.746929	110	3	1.12	0.95	100.0403	0.1529	0.0000	0.0000;
	1191	1	0	0	0	0	1	1.0844283	30.464067	110	3	1.12	0.95	100.3581	0.1386	0.0000	0.0000;
	1192	1	0.918	0.266	0	0	1	1.0910421	30.659367	110	3	1.12	0.95	99.1459	0.1723	0.0000	0.0000;
	1193	1	0	0	0	0	1	1.0910907	30.663825	110	3	1.12	0.95	99.1405	0.1712	0.0000	0.0000;
	1194	1	19.62	7.057	0	0	1	1.0844278	28.59425	110	3	1.12	0.95	101.4554	0.7366	0.0000	0.0000;
	1195	1	0	0.223	0	0	1	1.0844659	28.594701	110	3	1.12	0.95	101.4534	0.7352	0.0000	0.0000;
	1196	1	0	0	0	0	1	1.0825485	28.480719	110	3	1.12	0.95	101.5754	0.8229	0.0000	0.0000;
	1197	1	2.295	0.557	0	0	1	1.089509	28.876998	110	3	1.12	0.95	100.8415	0.5990	0.0000	0.0000;
	1198	1	0.688	0.111	0	0	1	1.0894498	28.872958	110	3	1.12	0.95	100.8034	0.6111	0.0000	0.0000;
	1199	1	0	0	0	0	1	1.0895385	28.879048	110	3	1.12	0.95	100.8379	0.5981	0.0000	0.0000;
	1200	1	0	0	0	0	1	1.0894574	28.873602	110	3	1.12	0.95	100.8023	0.6109	0.0000	0.0000;
	1201	1	0.229	0.059	0	0	1	1.1015394	30.482991	110	3	1.12	0.95	98.9276	0.1556	0.0000	0.0000;
	1202	1	0.803	0.062	0	0	1	1.1015612	30.487271	110	3	1.12	0.95	98.9259	0.1554	0.0000	0.0000;
	1203	1	0	0	0	0	1	1.09424	29.785597	110	3	1.12	0.95	99.9809	0.1321	0.0000	0.0000;
	1204	1	3.334	0.706	0	0	1	1.0900422	29.334813	110	3	1.12	0.95	101.1482	-0.4796	0.0000	0.0000;
	1205	1	0.229	0.037	0	0	1	1.0900428	29.326431	110	3	1.12	0.95	101.1456	-0.4831	0.0000	0.0000;
	1206	1	2.869	0.223	0	0	1	1.0838353	30.181178	110	3	1.12	0.95	100.2986	-0.0657	0.0000	0.0000;
	1207	1	3.442	0.223	0	0	1	1.0838329	30.166883	110	3	1.12	0.95	100.3010	-0.0661	0.0000	0.0000;
	1208	1	0	0	0	0	1	1.0972532	30.042503	110	3	1.12	0.95	99.4375	0.2372	0.0000	0.0000;
	1209	1	0	0	0	0	1	1.0972911	30.05016	110	3	1.12	0.95	99.4350	0.2367	0.0000	0.0000;
	1210	1	4.594	1.324	0	0	1	1.1003508	30.351444	110	3	1.12	0.95	99.0420	0.1488	0.0000	0.0000;
	1211	1	2.296	0.683	0	0	1	1.1003078	30.341525	110	3	1.12	0.95	99.0453	0.1487	0.0000	0.0000;
	1212	1	1.378	0.498	0	0	1	1.0979915	30.429764	110	3	1.12	0.95	100.7329	-0.1711	0.0000	0.0000;
	1213	1	1.723	0.655	0	0	1	1.097993	30.430157	110	3	1.12	0.95	100.7343	-0.1705	0.0000	0.0000;
	1214	1	6.111	2.723	0	0	1	1.0644485	27.434899	110	3	1.12	0.95	103.4780	0.9004	0.0000	0.0000;
	1215	1	2.529	0.903	0	0	1	1.0644434	27.437051	110	3	1.12	0.95	103.4796	0.9014	0.0000	0.0000;
	1216	1	1.147	0.26	0	0	1	1.0862902	30.745218	110	3	1.12	0.95	99.7877	-0.0399	0.0000	0.0000;
	1217	1	0	0	0	0	1	1.0862946	30.745408	110	3	1.12	0.95	99.7871	-0.0400	0.0000	0.0000;
	1218	1	4.247	1.226	0	0	1	1.0864163	30.715057	110	3	1.12	0.95	100.0840	0.1060	0.0000	0.0000;
	1219	1	1.721	0.557	0	0	1	1.0894836	31.060835	110	3	1.12	0.95	99.7146	0.0445	0.0000	0.0000;
	1220	1	0.574	-0.1	0	0	1	1.0882162	28.999546	110	3	1.12	0.95	100.6612	0.4465	0.0000	0.0000;
	1221	1	0.459	0.149	0	0	1	1.0881952	28.99266	110	3	1.12	0.95	100.6650	0.4483	0.0000	0.0000;
	1222	1	1.378	0.958	0	0	1	1.0921548	30.508458	110	3	1.12	0.95	99.9568	-0.5528	0.0000	0.0000;
	1223	1	10.57	3.063	0	0	1	1.0923381	30.573815	110	3	1.12	0.95	99.9494	-0.5332	0.0000	0.0000;
	1224	1	4.142	1.128	0	0	1	1.0836502	28.556142	110	3	1.12	0.95	100.9839	0.2445	0.0000	0.0000;
	1225	1	3.568	1.716	0	0	1	1.0836044	28.55048	110	3	1.12	0.95	100.9852	0.2466	0.0000	0.0000;
	1226	1	5.057	0.978	0	0	1	1.0722129	27.424452	110	3	1.12	0.95	102.7169	0.2144	0.0000	0.0000;
	1227	1	4.711	0.665	0	0	1	1.0726559	27.461933	110	3	1.12	0.95	102.6580	0.1989	0.0000	0.0000;
	1228	1	0	0	0	0	1	1.0726632	27.446516	110	3	1.12	0.95	102.6473	0.2017	0.0000	0.0000;
	1229	1	0	0	0	0	1	1.072879	27.478147	110	3	1.12	0.95	102.6232	0.1945	0.0000	0.0000;
	1230	1	5.511	2.266	0	0	1	1.0891423	29.163481	110	3	1.12	0.95	100.6332	0.2488	0.0000	0.0000;
	1231	1	0	0	0	0	1	1.0891955	29.167799	110	3	1.12	0.95	100.6312	0.2481	0.0000	0.0000;
	1232	1	0	0	0	0	1	1.0938594	29.787191	110	3	1.12	0.95	99.9936	0.1446	0.0000	0.0000;
	1233	1	0	0	0	0	1	1.0862577	30.580004	110	3	1.12	0.95	100.2116	0.0775	0.0000	0.0000;
	1234	1	8.727	1.894	0	0	1	1.0941891	30.01066	110	3	1.12	0.95	100.6197	-0.2015	0.0000	0.0000;
	1235	1	10.91	2.414	0	0	1	1.0941804	30.008925	110	3	1.12	0.95	100.6171	-0.2022	0.0000	0.0000;
	1236	1	1.606	0.557	0	0	1	1.0860776	30.719918	110	3	1.12	0.95	100.0884	0.1265	0.0000	0.0000;
	1237	1	2.525	0.78	0	0	1	1.0861066	30.718983	110	3	1.12	0.95	100.0884	0.1260	0.0000	0.0000;
	1238	1	0	0	0	0	1	1.0827632	29.617743	110	3	1.12	0.95	100.7343	-0.1532	0.0000	0.0000;
	1239	1	0	0	0	0	1	1.0827632	29.617743	110	3	1.12	0.95	100.7343	-0.1532	0.0000	0.0000;
	1240	1	2.296	0.404	0	0	1	1.0876629	29.03925	110	3	1.12	0.95	100.6160	0.4129	0.0000	0.0000;
	1241	1	2.64	0.706	0	0	1	1.0876249	29.025963	110	3	1.12	0.95	100.6179	0.4140	0.0000	0.0000;
	1242	1	0	0	0	0	1	1.0959115	30.237542	110	3	1.12	0.95	100.4033	-0.1932	0.0000	0.0000;
	1243	1	4.948	0.939	0	0	1	1.0959071	30.238522	110	3	1.12	0.95	100.4089	-0.1911	0.0000	0.0000;
	1244	1	4.476	1.218	0	0	1	1.0555892	26.345247	110	3	1.12	0.95	104.1500	0.0758	0.0000	0.0000;
	1245	1	8.966	2.303	0	0	1	1.0555697	26.32914	110	3	1.12	0.95	104.1437	0.0745	0.0000	0.0000;
	1246	2	9.939	7.19	0	0	1	1.0889161	30.591134	110	3	1.12	0.95	99.5205	0.0913	0.0000	0.0000;
	1247	2	83.654	21.275	0	0	1	1.0793722	29.784076	110	3	1.12	0.95	100.5066	0.1655	0.0000	0.0000;
	1248	2	29.193	8.769	0	0	1	1.0801915	28.245705	110	3	1.12	0.95	101.6449	0.6313	0.0000	0.0000;
	1249	1	0	0	0	0	1	1.0801988	28.239552	110	3	1.12	0.95	101.6460	0.6323	0.0000	0.0000;
	1250	1	2.295	0.52	0	0	1	1.0860748	30.032425	110	3	1.12	0.95	100.1181	-0.0026	0.0000	0.0000;
	1251	1	4.016	1.263	0	0	1	1.0939598	29.461562	110	3	1.12	0.95	100.2290	0.0957	0.0000	0.0000;
	1252	1	0	0	0	0	1	1.0861062	30.033801	110	3	1.12	0.95	100.1135	-0.0035	0.0000	0.0000;
	1253	1	0	0	0	0	1	1.0940031	29.463819	110	3	1.12	0.95	100.2240	0.0942	0.0000	0.0000;
	1254	1	0	0	0	0	1	1.0725077	27.676727	110	3	1.12	0.95	101.2559	-0.3920	0.0000	0.0000;
	1255	1	0	0	0	0	1	1.0707949	27.31192	110	3	1.12	0.95	101.5846	-0.3358	0.0000	0.0000;
	1256	1	2.983	0.446	0	0	1	1.0930815	31.399951	110	3	1.12	0.95	99.1207	0.0312	0.0000	0.0000;
	1257	1	3.213	0.446	0	0	1	1.0930871	31.401116	110	3	1.12	0.95	99.1203	0.0311	0.0000	0.0000;
	1258	1	4.021	0.122	0	0	1	1.1098337	30.580625	110	3	1.12	0.95	98.9649	-0.0004	0.0000	0.0000;
	1259	1	0	0	0	0	1	1.1098404	30.583133	110	3	1.12	0.95	98.9640	-0.0005	0.0000	0.0000;
	1260	1	0.803	0.264	0	0	1	1.08636	30.711195	110	3	1.12	0.95	100.0912	0.1076	0.0000	0.0000;
	1261	1	0	0	0	0	1	1.08641	30.714052	110	3	1.12	0.95	100.0850	0.1060	0.0000	0.0000;
	1262	1	0	0	0	0	1	1.09767	30.449712	110	3	1.12	0.95	100.4819	-0.1997	0.0000	0.0000;
	1263	1	0	0	0	0	1	1.0977568	30.455725	110	3	1.12	0.95	100.4759	-0.1977	0.0000	0.0000;
	1264	1	1.147	0.443	0	0	1	1.0872655	29.661394	110	3	1.12	0.95	100.5211	-0.3432	0.0000	0.0000;
	1265	1	0	0	0	0	1	1.0872945	29.665458	110	3	1.12	0.95	100.5196	-0.3434	0.0000	0.0000;
	1266	1	3.332	1.082	0	0	1	1.083355	31.552195	110	3	1.12	0.95	101.8805	0.0946	0.0000	0.0000;
	1267	1	2.872	0.917	0	0	1	1.0834473	31.541384	110	3	1.12	0.95	101.8704	0.0955	0.0000	0.0000;
	1268	1	12.851	2.377	0	0	1	1.0839232	29.923015	110	3	1.12	0.95	100.3248	0.0785	0.0000	0.0000;
	1269	1	0	0	0	0	1	1.0978023	29.427836	110	3	1.12	0.95	100.2285	0.2517	0.0000	0.0000;
	1270	1	3.557	1.411	0	0	1	1.084925	29.947927	110	3	1.12	0.95	100.2262	0.0351	0.0000	0.0000;
	1271	1	0	0	0	0	1	1.08478	29.975236	110	3	1.12	0.95	100.2033	0.0565	0.0000	0.0000;
	1272	1	7.019	2.524	0	0	1	1.0930606	29.787672	110	3	1.12	0.95	100.7201	-0.2304	0.0000	0.0000;
	1273	1	0	0	0	0	1	1.0934698	29.816693	110	3	1.12	0.95	100.6852	-0.2426	0.0000	0.0000;
	1274	1	3.213	0.059	0	0	1	1.0754852	27.314483	110	3	1.12	0.95	102.3421	0.1227	0.0000	0.0000;
	1275	1	0	0.059	0	0	1	1.0889349	29.188327	110	3	1.12	0.95	100.2553	0.0048	0.0000	0.0000;
	1276	1	6.199	2.043	0	0	1	1.09212	29.316802	110	3	1.12	0.95	100.3974	0.1494	0.0000	0.0000;
	1277	1	0	0	0	0	1	1.092306	29.344045	110	3	1.12	0.95	100.3879	0.1469	0.0000	0.0000;
	1278	1	5.742	1.037	0	0	1	1.0868497	28.909241	110	3	1.12	0.95	101.5195	-0.6048	0.0000	0.0000;
	1279	1	2.984	0.591	0	0	1	1.086853	28.913375	110	3	1.12	0.95	101.5214	-0.6024	0.0000	0.0000;
	1280	1	7.343	1.917	0	0	1	1.0955076	29.320976	110	3	1.12	0.95	100.3775	0.3379	0.0000	0.0000;
	1281	1	1.378	0.29	0	0	1	1.0955371	29.326083	110	3	1.12	0.95	100.3734	0.3371	0.0000	0.0000;
	1282	1	7.808	2.414	0	0	1	1.0802594	29.224212	110	3	1.12	0.95	101.0505	-0.0465	0.0000	0.0000;
	1283	1	0	0	0	0	1	1.0802685	29.217783	110	3	1.12	0.95	101.0539	-0.0484	0.0000	0.0000;
	1284	1	4.016	1.114	0	0	1	1.0926222	30.898954	110	3	1.12	0.95	98.9198	0.1506	0.0000	0.0000;
	1285	1	0	0.059	0	0	1	1.0852623	28.5755	110	3	1.12	0.95	101.2179	0.5691	0.0000	0.0000;
	1286	2	10.24	3.146	0	0	1	1.080677	27.845958	110	3	1.12	0.95	101.9531	0.6062	0.0000	0.0000;
	1287	2	18	42	0	0	1	1.1175518	32.082218	110	3	1.12	0.95	96.9633	0.0000	0.0000	0.0000;
	1288	2	0	0	0	0	1	1.0921304	29.171327	110	3	1.12	0.95	100.5559	0.1326	0.0000	0.0000;
	1289	1	7.584	-2.561	0	0	1	1.087509	28.965057	110	3	1.12	0.95	100.5563	-0.0463	0.0000	0.0000;
	1290	1	9.082	-2.679	0	0	1	1.0874852	28.959262	110	3	1.12	0.95	100.5591	-0.0475	0.0000	0.0000;
	1291	1	0	0	0	0	1	1.0833552	30.927101	110	3	1.12	0.95	102.3516	0.0283	0.0000	0.0000;
	1292	1	5.065	1.262	0	0	1	1.0832928	30.930976	110	3	1.12	0.95	102.3574	0.0269	0.0000	0.0000;
	1293	1	1.722	0.443	0	0	1	1.0899205	29.933445	110	3	1.12	0.95	100.4423	-0.5896	0.0000	0.0000;
	1294	1	1.493	0.441	0	0	1	1.0899291	29.921601	110	3	1.12	0.95	100.4434	-0.5905	0.0000	0.0000;
	1295	1	4.934	1.04	0	0	1	1.0921736	29.296007	110	3	1.12	0.95	100.4305	0.1382	0.0000	0.0000;
	1296	1	7.114	2.971	0	0	1	1.0921958	29.300469	110	3	1.12	0.95	100.4288	0.1380	0.0000	0.0000;
	1297	1	3.904	0.646	0	0	1	1.0871585	32.786736	110	3	1.12	0.95	100.7288	-0.0499	0.0000	0.0000;
	1298	1	7.008	1.187	0	0	1	1.0871677	32.789255	110	3	1.12	0.95	100.7280	-0.0501	0.0000	0.0000;
	1299	1	0.804	1.187	0	0	1	1.0814596	28.655421	110	3	1.12	0.95	101.1235	0.5532	0.0000	0.0000;
	1300	1	6.118	6.132	0	0	1	1.0814441	28.658956	110	3	1.12	0.95	101.1224	0.5540	0.0000	0.0000;
	1301	1	4.022	0.949	0	0	1	1.0826679	29.226759	110	3	1.12	0.95	101.2700	-0.3130	0.0000	0.0000;
	1302	1	0.574	0.176	0	0	1	1.0826672	29.226529	110	3	1.12	0.95	101.2715	-0.3129	0.0000	0.0000;
	1303	1	0	0.074	0	0	1	1.0799356	28.129395	110	3	1.12	0.95	101.2944	-0.0389	0.0000	0.0000;
	1304	1	0	0	0	0	1	1.0799168	28.120308	110	3	1.12	0.95	101.2966	-0.0406	0.0000	0.0000;
	1305	1	6.44	1.66	0	0	1	1.0657014	25.886903	110	3	1.12	0.95	103.3529	-0.3189	0.0000	0.0000;
	1306	1	3.33	0.865	0	0	1	1.0657117	25.889333	110	3	1.12	0.95	103.3531	-0.3186	0.0000	0.0000;
	1307	1	5.054	1.256	0	0	1	1.0877267	30.522662	110	3	1.12	0.95	99.8411	0.1630	0.0000	0.0000;
	1308	1	7.606	2.077	0	0	1	1.0877131	30.504545	110	3	1.12	0.95	99.8405	0.1634	0.0000	0.0000;
	1309	1	0	0	0	0	1	1.0815465	29.46798	110	3	1.12	0.95	100.8927	-0.1323	0.0000	0.0000;
	1310	1	0	0	0	0	1	1.0815438	29.468061	110	3	1.12	0.95	100.8927	-0.1320	0.0000	0.0000;
	1311	1	1.264	0.414	0	0	1	1.0791797	29.090141	110	3	1.12	0.95	101.9773	-0.2390	0.0000	0.0000;
	1312	1	1.954	0.511	0	0	1	1.0791726	29.087867	110	3	1.12	0.95	101.9781	-0.2390	0.0000	0.0000;
	1313	1	3.677	1.313	0	0	1	1.0919787	29.574108	110	3	1.12	0.95	100.2195	0.5289	0.0000	0.0000;
	1314	1	4.136	0.874	0	0	1	1.0919033	29.550958	110	3	1.12	0.95	100.2251	0.5292	0.0000	0.0000;
	1315	1	0	0	0	0	1	1.0859169	30.660319	110	3	1.12	0.95	100.1523	0.1087	0.0000	0.0000;
	1316	1	0.115	0.059	0	0	1	1.0858977	30.656455	110	3	1.12	0.95	100.1535	0.1090	0.0000	0.0000;
	1317	1	4.475	1.189	0	0	1	1.0900616	30.590796	110	3	1.12	0.95	99.3902	0.0699	0.0000	0.0000;
	1318	1	0	0	0	0	1	1.0900728	30.591593	110	3	1.12	0.95	99.3890	0.0696	0.0000	0.0000;
	1319	1	0	0	0	0	1	1.0895097	29.420881	110	3	1.12	0.95	100.3534	0.3244	0.0000	0.0000;
	1320	1	0	0	0	0	1	1.0823288	28.515052	110	3	1.12	0.95	101.2376	0.4441	0.0000	0.0000;
	1321	1	0	0	0	0	1	1.0895056	29.420991	110	3	1.12	0.95	100.3534	0.3248	0.0000	0.0000;
	1322	1	0	0	0	0	1	1.0823248	28.515163	110	3	1.12	0.95	101.2376	0.4445	0.0000	0.0000;
	1323	1	6.999	1.486	0	0	1	1.0969236	29.562391	110	3	1.12	0.95	100.1147	0.3352	0.0000	0.0000;
	1324	1	6.77	1.486	0	0	1	1.0969003	29.55503	110	3	1.12	0.95	100.1174	0.3354	0.0000	0.0000;
	1325	1	2.295	0.371	0	0	1	1.0810577	29.821376	110	3	1.12	0.95	100.4310	0.1275	0.0000	0.0000;
	1326	1	0	0	0	0	1	1.0895259	30.588605	110	3	1.12	0.95	99.4752	0.0707	0.0000	0.0000;
	1327	1	0	0	0	0	1	1.0810721	29.82259	110	3	1.12	0.95	100.4290	0.1272	0.0000	0.0000;
	1328	1	0	0	0	0	1	1.0895259	30.588607	110	3	1.12	0.95	99.4752	0.0707	0.0000	0.0000;
	1329	1	2.871	0.313	0	0	1	1.0762562	27.508079	110	3	1.12	0.95	102.0951	0.1690	0.0000	0.0000;
	1330	1	1.952	0.296	0	0	1	1.0762622	27.524809	110	3	1.12	0.95	102.0891	0.1694	0.0000	0.0000;
	1331	1	5.294	0.579	0	0	1	1.0601475	28.639838	110	3	1.12	0.95	103.6437	0.9614	0.0000	0.0000;
	1332	1	0	0	0	0	1	1.0601689	28.650412	110	3	1.12	0.95	103.6416	0.9613	0.0000	0.0000;
	1333	1	2.989	0.692	0	0	1	1.0837654	31.741657	110	3	1.12	0.95	101.7423	0.0851	0.0000	0.0000;
	1334	1	2.068	0.065	0	0	1	1.0837554	31.749644	110	3	1.12	0.95	101.7429	0.0842	0.0000	0.0000;
	1335	1	4.026	1.27	0	0	1	1.082554	30.226957	110	3	1.12	0.95	100.0148	0.2911	0.0000	0.0000;
	1336	1	4.597	0.889	0	0	1	1.082552	30.218542	110	3	1.12	0.95	100.0138	0.2890	0.0000	0.0000;
	1337	1	9.538	2.3	0	0	1	1.0610472	26.540651	110	3	1.12	0.95	103.8372	0.4647	0.0000	0.0000;
	1338	1	0	0	0	0	1	1.0610471	26.54019	110	3	1.12	0.95	103.8328	0.4629	0.0000	0.0000;
	1339	1	0	0.118	0	0	1	1.0919865	29.285161	110	3	1.12	0.95	100.4455	0.1458	0.0000	0.0000;
	1340	1	6.196	1.411	0	0	1	1.0827785	28.474972	110	3	1.12	0.95	101.2688	0.3983	0.0000	0.0000;
	1341	1	0	0	0	0	1	1.0915533	29.603338	110	3	1.12	0.95	100.2041	0.2269	0.0000	0.0000;
	1342	2	22.02	6.967	0	0	1	1.0857386	32.725501	110	3	1.12	0.95	100.8780	0.0000	0.0000	0.0000;
	1343	2	22.02	6.967	0	0	1	1.0857221	32.727946	110	3	1.12	0.95	100.8781	0.0006	0.0000	0.0000;
	1344	1	5.173	0.989	0	0	1	1.0778591	29.317944	110	3	1.12	0.95	101.2551	0.1250	0.0000	0.0000;
	1345	1	5.057	-0.083	0	0	1	1.0853569	32.633449	110	3	1.12	0.95	101.0236	-0.0291	0.0000	0.0000;
	1346	1	0	0	0	0	1	1.0778959	29.320193	110	3	1.12	0.95	101.2499	0.1240	0.0000	0.0000;
	1347	1	1.606	0.475	0	0	1	1.0816999	29.220102	110	3	1.12	0.95	101.0545	-0.1731	0.0000	0.0000;
	1348	1	7.812	1.505	0	0	1	1.0819931	29.889153	110	3	1.12	0.95	100.5677	0.2008	0.0000	0.0000;
	1349	1	2.297	0.903	0	0	1	1.0623641	26.702106	110	3	1.12	0.95	102.9414	-0.1178	0.0000	0.0000;
	1350	1	0	0	0	0	1	1.0623076	26.690337	110	3	1.12	0.95	102.9477	-0.1161	0.0000	0.0000;
	1351	2	12.509	17.589	0	0	1	1.0895449	31.288928	110	3	1.12	0.95	99.2499	-0.0584	0.0000	0.0000;
	1352	2	8.918	16.707	0	0	1	1.0910792	31.238222	110	3	1.12	0.95	99.4895	-0.0000	0.0000	0.0000;
	1353	2	0	0	0	0	1	1.0956417	29.834069	110	3	1.12	0.95	99.8910	0.0881	0.0000	0.0000;
	1354	1	4.257	1.054	0	0	1	1.074706	27.662689	110	3	1.12	0.95	102.2073	0.2521	0.0000	0.0000;
	1355	1	2.874	0.68	0	0	1	1.074688	27.663612	110	3	1.12	0.95	102.2101	0.2526	0.0000	0.0000;
	1356	1	5.742	1.284	0	0	1	1.1155039	31.893258	110	3	1.12	0.95	97.2096	0.0337	0.0000	0.0000;
	1357	1	13.452	3.289	0	0	1	1.0902783	29.015994	110	3	1.12	0.95	100.7161	0.1803	0.0000	0.0000;
	1358	1	0	0	0	0	1	1.1157374	31.907353	110	3	1.12	0.95	97.1806	0.0274	0.0000	0.0000;
	1359	1	0	0	0	0	1	1.0908411	29.049095	110	3	1.12	0.95	100.6443	0.1628	0.0000	0.0000;
	1360	1	11.504	3.043	0	0	1	1.0533975	26.065817	110	3	1.12	0.95	104.4172	0.1061	0.0000	0.0000;
	1361	1	9.416	4.346	0	0	1	1.0533993	26.058358	110	3	1.12	0.95	104.4147	0.1060	0.0000	0.0000;
	1362	1	0	0	0	0	1	1.0919812	29.161898	110	3	1.12	0.95	100.5686	0.1370	0.0000	0.0000;
	1363	2	25.212	32.143	0	0	1	1.0991515	29.329405	110	3	1.12	0.95	100.2736	0.1410	0.0000	0.0000;
	1364	1	4.478	0.496	0	0	1	1.0801196	29.209407	110	3	1.12	0.95	101.8346	-0.2502	0.0000	0.0000;
	1365	1	5.743	1.052	0	0	1	1.0801108	29.213288	110	3	1.12	0.95	101.8366	-0.2496	0.0000	0.0000;
	1366	1	1.149	0.344	0	0	1	1.0918046	31.203526	110	3	1.12	0.95	99.5165	-0.0699	0.0000	0.0000;
	1367	1	1.147	0.363	0	0	1	1.091899	31.201208	110	3	1.12	0.95	99.5180	-0.0736	0.0000	0.0000;
	1368	1	15.045	3.568	0	0	1	1.090055	29.135032	110	3	1.12	0.95	100.6100	0.2023	0.0000	0.0000;
	1369	1	24.784	3.269	0	0	1	1.0900508	29.133608	110	3	1.12	0.95	100.6129	0.2025	0.0000	0.0000;
	1370	1	0	0	0	0	1	1.1003732	30.363179	110	3	1.12	0.95	99.0674	0.1932	0.0000	0.0000;
	1371	1	8.497	2.414	0	0	1	1.0994727	30.31581	110	3	1.12	0.95	99.1528	0.2476	0.0000	0.0000;
	1372	1	0	0	0	0	1	1.1003687	30.363319	110	3	1.12	0.95	99.0674	0.1937	0.0000	0.0000;
	1373	1	0	0	0	0	1	1.100073	30.345829	110	3	1.12	0.95	99.0789	0.2270	0.0000	0.0000;
	1374	2	8.627	14.288	0	0	1	1.0826835	28.543862	110	3	1.12	0.95	101.2518	0.0000	0.0000	0.0000;
	1375	2	0	0	0	0	1	1.0825766	28.531712	110	3	1.12	0.95	101.2543	0.0011	0.0000	0.0000;
	1376	2	3.675	1.685	0	0	1	1.0766098	27.762039	110	3	1.12	0.95	101.9636	0.1772	0.0000	0.0000;
	1377	1	4.022	1.021	0	0	1	1.1051037	30.254949	110	3	1.12	0.95	99.3450	0.1423	0.0000	0.0000;
	1378	1	2.527	0.607	0	0	1	1.1050193	30.243472	110	3	1.12	0.95	99.3486	0.1433	0.0000	0.0000;
	1379	1	5.979	1.475	0	0	1	1.0842323	28.529732	110	3	1.12	0.95	101.1234	0.3384	0.0000	0.0000;
	1380	1	0	0.059	0	0	1	1.0841805	28.527114	110	3	1.12	0.95	101.1275	0.3400	0.0000	0.0000;
	1381	1	6.889	2.266	0	0	1	1.0882911	29.126275	110	3	1.12	0.95	100.6924	0.2786	0.0000	0.0000;
	1382	1	0	0	0	0	1	1.088324	29.128111	110	3	1.12	0.95	100.6913	0.2782	0.0000	0.0000;
	1383	1	1.033	0.3	0	0	1	1.0948916	29.790467	110	3	1.12	0.95	99.7123	0.2845	0.0000	0.0000;
	1384	1	1.378	0.44	0	0	1	1.0949131	29.794955	110	3	1.12	0.95	99.7110	0.2843	0.0000	0.0000;
	1385	1	5.739	-1.412	0	0	1	1.0775805	27.77066	110	3	1.12	0.95	101.9566	0.1200	0.0000	0.0000;
	1386	1	12.632	-2.896	0	0	1	1.0836704	28.666174	110	3	1.12	0.95	101.1440	0.0045	0.0000	0.0000;
	1387	1	0	0	0	0	1	1.091823	30.429496	110	3	1.12	0.95	100.0135	-0.5374	0.0000	0.0000;
	1388	1	0	0	0	0	1	1.0918365	30.443778	110	3	1.12	0.95	100.0103	-0.5363	0.0000	0.0000;
	1389	1	3.907	1.093	0	0	1	1.0989479	31.224977	110	3	1.12	0.95	99.2530	-0.5326	0.0000	0.0000;
	1390	1	1.262	0.363	0	0	1	1.0988711	31.228735	110	3	1.12	0.95	99.2466	-0.5290	0.0000	0.0000;
	1391	1	9.787	-3.403	0	0	1	1.0728748	26.675225	110	3	1.12	0.95	103.1396	-0.2750	0.0000	0.0000;
	1392	1	8.643	-0.004	0	0	1	1.0728548	26.66901	110	3	1.12	0.95	103.1380	-0.2768	0.0000	0.0000;
	1393	1	6.434	1.505	0	0	1	1.0777966	28.314567	110	3	1.12	0.95	101.6647	0.1718	0.0000	0.0000;
	1394	1	8.39	1.876	0	0	1	1.0807983	28.782937	110	3	1.12	0.95	100.9949	0.0849	0.0000	0.0000;
	1395	1	2.413	0.748	0	0	1	1.0948312	30.636542	110	3	1.12	0.95	99.8479	-0.7062	0.0000	0.0000;
	1396	1	0	0	0	0	1	1.0949197	30.642738	110	3	1.12	0.95	99.8391	-0.7088	0.0000	0.0000;
	1397	1	11.264	2.992	0	0	1	1.0857346	30.605483	110	3	1.12	0.95	100.1998	0.1065	0.0000	0.0000;
	1398	1	8.272	2.175	0	0	1	1.0857372	30.610768	110	3	1.12	0.95	100.1983	0.1063	0.0000	0.0000;
	1399	1	2.065	0.669	0	0	1	1.0900249	33.186539	110	3	1.12	0.95	100.3174	-0.0016	0.0000	0.0000;
	1400	1	16.982	8.023	0	0	1	1.0861771	33.445554	110	3	1.12	0.95	100.3777	0.2420	0.0000	0.0000;
	1401	1	0	0	0	0	1	1.0900507	33.187918	110	3	1.12	0.95	100.3145	-0.0025	0.0000	0.0000;
	1402	1	3.557	3.194	0	0	1	1.0867866	30.746036	110	3	1.12	0.95	100.0637	0.0938	0.0000	0.0000;
	1403	1	11.933	6.76	0	0	1	1.0867103	30.737664	110	3	1.12	0.95	100.0669	0.0949	0.0000	0.0000;
	1404	1	3.676	0.634	0	0	1	1.0816724	29.212712	110	3	1.12	0.95	101.0667	-0.1946	0.0000	0.0000;
	1405	1	1.377	0.294	0	0	1	1.080989	29.159116	110	3	1.12	0.95	101.1261	-0.1677	0.0000	0.0000;
	1406	1	0	0	0	0	1	1.0817725	29.218864	110	3	1.12	0.95	101.0521	-0.1970	0.0000	0.0000;
	1407	1	0	0	0	0	1	1.081028	29.161375	110	3	1.12	0.95	101.1206	-0.1688	0.0000	0.0000;
	1408	1	5.163	1.337	0	0	1	1.0900215	29.347747	110	3	1.12	0.95	100.5020	0.5527	0.0000	0.0000;
	1409	1	0	0	0	0	1	1.0899707	29.328162	110	3	1.12	0.95	100.5063	0.5526	0.0000	0.0000;
	1410	1	11.262	4.03	0	0	1	1.0774596	27.607785	110	3	1.12	0.95	102.2579	0.7189	0.0000	0.0000;
	1411	1	8.73	2.396	0	0	1	1.077619	27.625659	110	3	1.12	0.95	102.2497	0.7151	0.0000	0.0000;
	1412	1	0	0	0	0	1	1.0837769	29.419275	110	3	1.12	0.95	100.8525	-0.2490	0.0000	0.0000;
	1413	1	0	0	0	0	1	1.084619	29.466103	110	3	1.12	0.95	100.7896	-0.2810	0.0000	0.0000;
	1414	2	0	0	0	0	1	1.0826167	29.429821	110	3	1.12	0.95	100.8822	-0.1992	0.0000	0.0000;
	1415	2	0	0	0	0	1	1.0826793	29.527871	110	3	1.12	0.95	100.8015	-0.1721	0.0000	0.0000;
	1416	1	0	0.111	0	0	1	1.0918566	30.194691	110	3	1.12	0.95	100.0633	-0.5089	0.0000	0.0000;
	1417	1	0	0.111	0	0	1	1.0918514	30.195948	110	3	1.12	0.95	100.0651	-0.5093	0.0000	0.0000;
	1418	1	3.675	3.083	0	0	1	1.0829836	29.427418	110	3	1.12	0.95	100.8618	-0.2169	0.0000	0.0000;
	1419	1	0.229	0.111	0	0	1	1.0829618	29.427272	110	3	1.12	0.95	100.8626	-0.2165	0.0000	0.0000;
	1420	1	2.066	0.383	0	0	1	1.0944697	29.782926	110	3	1.12	0.95	99.9743	0.1237	0.0000	0.0000;
	1421	1	2.984	0.469	0	0	1	1.0944439	29.781945	110	3	1.12	0.95	99.9753	0.1241	0.0000	0.0000;
	1422	1	0.344	0.099	0	0	1	1.0859088	30.746081	110	3	1.12	0.95	100.0611	0.1552	0.0000	0.0000;
	1423	1	0.688	0.103	0	0	1	1.0859327	30.744242	110	3	1.12	0.95	100.0615	0.1547	0.0000	0.0000;
	1424	1	0	0	0	0	1	1.0850509	29.845577	110	3	1.12	0.95	100.3006	-0.0392	0.0000	0.0000;
	1425	1	0	0	0	0	1	1.0850507	29.845584	110	3	1.12	0.95	100.3006	-0.0392	0.0000	0.0000;
	1426	1	2.984	0.687	0	0	1	1.0761731	27.534901	110	3	1.12	0.95	102.4981	0.7364	0.0000	0.0000;
	1427	1	9.659	2.957	0	0	1	1.076183	27.527128	110	3	1.12	0.95	102.4982	0.7358	0.0000	0.0000;
	1428	1	0	0	0	0	1	1.0566584	26.554535	110	3	1.12	0.95	103.9748	1.7596	0.0000	0.0000;
	1429	1	7.125	0.264	0	0	1	1.0566523	26.556036	110	3	1.12	0.95	103.9747	1.7599	0.0000	0.0000;
	1430	1	2.297	0.828	0	0	1	1.0862927	30.654676	110	3	1.12	0.95	100.1447	0.0926	0.0000	0.0000;
	1431	1	0	0	0	0	1	1.0862933	30.654768	110	3	1.12	0.95	100.1447	0.0926	0.0000	0.0000;
	1432	2	1.701	0.351	0	0	1	1.0873686	28.657981	110	3	1.12	0.95	101.0455	0.6750	0.0000	0.0000;
	1433	2	0	0	0	0	1	1.0854614	28.711986	110	3	1.12	0.95	101.3451	0.7230	0.0000	0.0000;
	1434	2	30.057	12.143	0	0	1	1.0972679	29.605851	110	3	1.12	0.95	100.0221	0.3794	0.0000	0.0000;
	1435	2	3.662	1.476	0	0	1	1.098889	29.740093	110	3	1.12	0.95	99.8661	0.3313	0.0000	0.0000;
	1436	1	0	0	0	0	1	1.0975138	29.623187	110	3	1.12	0.95	99.9985	0.3720	0.0000	0.0000;
	1437	1	9.537	2.406	0	0	1	1.0794131	27.875232	110	3	1.12	0.95	101.8893	0.0169	0.0000	0.0000;
	1438	1	11.502	2.89	0	0	1	1.0793936	27.860262	110	3	1.12	0.95	101.8909	0.0150	0.0000	0.0000;
	1439	2	3.91	0.505	0	0	1	1.0856725	30.611323	110	3	1.12	0.95	100.2033	0.1112	0.0000	0.0000;
	1440	1	13.239	4.598	0	0	1	1.0856451	30.605834	110	3	1.12	0.95	100.2051	0.1115	0.0000	0.0000;
	1441	1	0	0	0	0	1	1.1065452	30.978863	110	3	1.12	0.95	98.3147	0.0511	0.0000	0.0000;
	1442	1	0	0	0	0	1	1.106543	30.978906	110	3	1.12	0.95	98.3147	0.0513	0.0000	0.0000;
	1443	1	6.439	1.119	0	0	1	1.1077622	31.096056	110	3	1.12	0.95	98.1509	0.1292	0.0000	0.0000;
	1444	1	4.715	2.42	0	0	1	1.1097065	31.318076	110	3	1.12	0.95	97.8509	0.1285	0.0000	0.0000;
	1445	1	0	0	0	0	1	1.1079229	31.1281	110	3	1.12	0.95	98.1399	0.1275	0.0000	0.0000;
	1446	1	0	0	0	0	1	1.1099813	31.341028	110	3	1.12	0.95	97.8427	0.1245	0.0000	0.0000;
	1447	1	0	0.044	0	0	1	1.0658999	25.89095	110	3	1.12	0.95	103.3162	-0.3357	0.0000	0.0000;
	1448	1	1.952	0.258	0	0	1	1.0658907	25.889951	110	3	1.12	0.95	103.3176	-0.3351	0.0000	0.0000;
	1449	1	0	0	0	0	1	1.092055	30.236384	110	3	1.12	0.95	100.0436	-0.5322	0.0000	0.0000;
	1450	1	0.803	0.062	0	0	1	1.0920611	30.2348	110	3	1.12	0.95	100.0419	-0.5318	0.0000	0.0000;
	1451	1	3.558	1.077	0	0	1	1.0804851	29.118741	110	3	1.12	0.95	101.1736	-0.1457	0.0000	0.0000;
	1452	1	1.721	0.334	0	0	1	1.0804514	29.114551	110	3	1.12	0.95	101.1749	-0.1445	0.0000	0.0000;
	1453	1	8.045	1.465	0	0	1	1.0848975	33.034242	110	3	1.12	0.95	101.1240	0.2727	0.0000	0.0000;
	1454	1	4.251	0.95	0	0	1	1.0849381	33.024111	110	3	1.12	0.95	101.1173	0.2730	0.0000	0.0000;
	1455	1	0	0.071	0	0	1	1.0680207	26.131931	110	3	1.12	0.95	103.1379	-0.3467	0.0000	0.0000;
	1456	1	5.399	-1.609	0	0	1	1.0680258	26.127873	110	3	1.12	0.95	103.1390	-0.3471	0.0000	0.0000;
	1457	1	6.657	1.887	0	0	1	1.0888939	30.869904	110	3	1.12	0.95	99.9079	0.0227	0.0000	0.0000;
	1458	1	6.887	1.961	0	0	1	1.0888213	30.862183	110	3	1.12	0.95	99.9103	0.0238	0.0000	0.0000;
	1459	1	6.672	2.274	0	0	1	1.0722186	27.608943	110	3	1.12	0.95	101.3059	-0.3872	0.0000	0.0000;
	1460	1	0	0	0	0	1	1.0722202	27.61113	110	3	1.12	0.95	101.3060	-0.3873	0.0000	0.0000;
	1461	2	2.965	4.08	0	0	1	1.0813539	28.370116	110	3	1.12	0.95	101.0704	0.0000	0.0000	0.0000;
	1462	1	1.127	-1.439	0	0	1	1.081346	28.360523	110	3	1.12	0.95	101.0728	-0.0019	0.0000	0.0000;
	1463	1	6.095	1.805	0	0	1	1.0661562	26.833829	110	3	1.12	0.95	103.4485	0.2863	0.0000	0.0000;
	1464	1	8.515	-2.662	0	0	1	1.0661918	26.840692	110	3	1.12	0.95	103.4504	0.2876	0.0000	0.0000;
	1465	1	0	0.059	0	0	1	1.0858941	30.642117	110	3	1.12	0.95	100.1688	0.1093	0.0000	0.0000;
	1466	1	0	0	0	0	1	1.0858947	30.642104	110	3	1.12	0.95	100.1688	0.1092	0.0000	0.0000;
	1467	1	5.978	0.495	0	0	1	1.0919886	29.275343	110	3	1.12	0.95	100.4563	0.1412	0.0000	0.0000;
	1468	1	6.67	1.281	0	0	1	1.0907135	29.251787	110	3	1.12	0.95	100.5175	0.1977	0.0000	0.0000;
	1469	1	0	0	0	0	1	1.0920044	29.276709	110	3	1.12	0.95	100.4538	0.1410	0.0000	0.0000;
	1470	1	0	0	0	0	1	1.0907345	29.253227	110	3	1.12	0.95	100.5147	0.1972	0.0000	0.0000;
	1471	1	0	0.071	0	0	1	1.100264	29.95736	110	3	1.12	0.95	99.6554	0.2932	0.0000	0.0000;
	1472	1	0	0.071	0	0	1	1.1002463	29.950633	110	3	1.12	0.95	99.6572	0.2942	0.0000	0.0000;
	1473	1	0	0	0	0	1	1.070772	27.143849	110	3	1.12	0.95	101.8338	-0.4384	0.0000	0.0000;
	1474	1	10.796	2.637	0	0	1	1.0708201	27.139312	110	3	1.12	0.95	101.8350	-0.4390	0.0000	0.0000;
	1475	1	2.64	0.838	0	0	1	1.0881721	28.971064	110	3	1.12	0.95	100.7730	0.2544	0.0000	0.0000;
	1476	1	9.424	2.769	0	0	1	1.088266	28.985111	110	3	1.12	0.95	100.7706	0.2534	0.0000	0.0000;
	1477	1	0	0	0	0	1	1.1039971	30.164908	110	3	1.12	0.95	99.4457	0.1712	0.0000	0.0000;
	1478	1	0	0	0	0	1	1.1039187	30.154375	110	3	1.12	0.95	99.4489	0.1721	0.0000	0.0000;
	1479	1	0.688	0.22	0	0	1	1.0917669	30.42324	110	3	1.12	0.95	100.0206	-0.5364	0.0000	0.0000;
	1480	1	0.803	0.334	0	0	1	1.0917538	30.436833	110	3	1.12	0.95	100.0185	-0.5343	0.0000	0.0000;
	1481	1	5.513	1.186	0	0	1	1.0859002	28.279339	110	3	1.12	0.95	101.5863	0.4873	0.0000	0.0000;
	1482	1	2.87	0.631	0	0	1	1.0858319	28.268432	110	3	1.12	0.95	101.5876	0.4873	0.0000	0.0000;
	1483	1	4.021	0.42	0	0	1	1.0826809	31.762761	110	3	1.12	0.95	101.8720	0.0814	0.0000	0.0000;
	1484	1	2.528	0.002	0	0	1	1.0826638	31.766874	110	3	1.12	0.95	101.8736	0.0809	0.0000	0.0000;
	1485	1	2.525	0.74	0	0	1	1.0926854	30.90421	110	3	1.12	0.95	98.9137	0.1490	0.0000	0.0000;
	1486	1	2.989	0.843	0	0	1	1.0937335	31.474812	110	3	1.12	0.95	99.0335	0.0211	0.0000	0.0000;
	1487	1	6.094	1.329	0	0	1	1.0744293	27.21979	110	3	1.12	0.95	101.6761	-0.4842	0.0000	0.0000;
	1488	1	0	0	0	0	1	1.0744338	27.218621	110	3	1.12	0.95	101.6770	-0.4854	0.0000	0.0000;
	1489	1	8.072	2.346	0	0	1	1.0976641	29.191419	110	3	1.12	0.95	100.4325	0.1760	0.0000	0.0000;
	1490	1	0	0.059	0	0	1	1.0913781	29.11247	110	3	1.12	0.95	100.6299	0.1534	0.0000	0.0000;
	1491	1	0	0	0	0	1	1.0976879	29.194499	110	3	1.12	0.95	100.4314	0.1757	0.0000	0.0000;
	1492	1	3.101	0.397	0	0	1	1.0755171	31.219561	110	3	1.12	0.95	103.4042	-0.1999	0.0000	0.0000;
	1493	1	2.296	0.16	0	0	1	1.0755196	31.221399	110	3	1.12	0.95	103.4035	-0.1999	0.0000	0.0000;
	1494	1	5.854	1.597	0	0	1	1.0852291	30.557635	110	3	1.12	0.95	100.2630	0.1199	0.0000	0.0000;
	1495	1	12.63	3.251	0	0	1	1.0852248	30.559836	110	3	1.12	0.95	100.2625	0.1199	0.0000	0.0000;
	1496	1	13.425	3.417	0	0	1	1.0705818	27.428385	110	3	1.12	0.95	102.7718	1.1494	0.0000	0.0000;
	1497	1	5.163	2.897	0	0	1	1.0706444	27.438237	110	3	1.12	0.95	102.7688	1.1493	0.0000	0.0000;
	1498	1	0	0	0	0	1	1.0732095	27.619554	110	3	1.12	0.95	101.2391	-0.4221	0.0000	0.0000;
	1499	1	1.722	0.071	0	0	1	1.0732275	27.620037	110	3	1.12	0.95	101.2381	-0.4222	0.0000	0.0000;
	1500	1	3.904	0.13	0	0	1	1.0900507	33.187918	110	3	1.12	0.95	100.3145	-0.0025	0.0000	0.0000;
	1501	1	2.986	0.501	0	0	1	1.0864284	33.455963	110	3	1.12	0.95	100.3537	0.2307	0.0000	0.0000;
	1502	1	10.389	2.252	0	0	1	1.0764898	27.848849	110	3	1.12	0.95	102.1234	0.9598	0.0000	0.0000;
	1503	1	0	0	0	0	1	1.0765499	27.861074	110	3	1.12	0.95	102.1218	0.9599	0.0000	0.0000;
	1504	1	2.87	0.839	0	0	1	1.0923298	30.889441	110	3	1.12	0.95	98.9630	0.1609	0.0000	0.0000;
	1505	1	6.658	1.805	0	0	1	1.0940939	31.590221	110	3	1.12	0.95	98.9443	0.0350	0.0000	0.0000;
	1506	1	0	0	0	0	1	1.09456	31.628295	110	3	1.12	0.95	98.8970	0.0228	0.0000	0.0000;
	1507	1	5.737	1.114	0	0	1	1.0954773	29.31734	110	3	1.12	0.95	100.3814	0.3384	0.0000	0.0000;
	1508	1	3.786	0.817	0	0	1	1.0954979	29.322432	110	3	1.12	0.95	100.3777	0.3381	0.0000	0.0000;
	1509	1	2.298	0.218	0	0	1	1.0933773	30.492	110	3	1.12	0.95	101.0121	-0.1562	0.0000	0.0000;
	1510	1	3.334	0.479	0	0	1	1.0934518	30.49076	110	3	1.12	0.95	101.0028	-0.1561	0.0000	0.0000;
	1511	1	3.217	1.149	0	0	1	1.0914531	29.116776	110	3	1.12	0.95	100.6217	0.1512	0.0000	0.0000;
	1512	1	1.608	0.592	0	0	1	1.1087687	31.164707	110	3	1.12	0.95	98.0333	0.1236	0.0000	0.0000;
	1513	1	13.803	2.044	0	0	1	1.1041086	30.108323	110	3	1.12	0.95	99.4212	0.1659	0.0000	0.0000;
	1514	1	0	0	0	0	1	1.1072008	30.454257	110	3	1.12	0.95	99.1233	0.1022	0.0000	0.0000;
	1515	1	0	0	0	0	1	1.1041239	30.113685	110	3	1.12	0.95	99.4212	0.1659	0.0000	0.0000;
	1516	1	0	0	0	0	1	1.1072008	30.454257	110	3	1.12	0.95	99.1233	0.1022	0.0000	0.0000;
	1517	1	5.858	-0.765	0	0	1	1.0886253	33.402646	110	3	1.12	0.95	100.6421	-0.0098	0.0000	0.0000;
	1518	1	4.478	0.432	0	0	1	1.0886277	33.41368	110	3	1.12	0.95	100.6405	-0.0097	0.0000	0.0000;
	1519	1	0	0	0	0	1	1.0751742	30.972706	110	3	1.12	0.95	103.5888	-0.2343	0.0000	0.0000;
	1520	1	6.784	-0.173	0	0	1	1.0751742	30.972706	110	3	1.12	0.95	103.5888	-0.2343	0.0000	0.0000;
	1521	1	5.754	1.557	0	0	1	1.0873316	30.78236	110	3	1.12	0.95	100.0013	0.0718	0.0000	0.0000;
	1522	1	2.755	0.814	0	0	1	1.0873853	30.791908	110	3	1.12	0.95	99.9977	0.0709	0.0000	0.0000;
	1523	1	0	0	0	0	1	1.0693983	27.394315	110	3	1.12	0.95	102.7194	1.2566	0.0000	0.0000;
	1524	1	0	0	0	0	1	1.0694583	27.401093	110	3	1.12	0.95	102.7157	1.2558	0.0000	0.0000;
	1525	1	0	0	0	0	1	1.0957536	29.632763	110	3	1.12	0.95	100.0412	0.0537	0.0000	0.0000;
	1526	1	9.646	3.157	0	0	1	1.0957886	29.638953	110	3	1.12	0.95	100.0395	0.0533	0.0000	0.0000;
	1527	1	2.76	1.072	0	0	1	1.0661496	25.912417	110	3	1.12	0.95	103.3460	-0.3260	0.0000	0.0000;
	1528	1	0.688	0.181	0	0	1	1.0661471	25.911821	110	3	1.12	0.95	103.3460	-0.3261	0.0000	0.0000;
	1529	1	1.263	0.798	0	0	1	1.0877348	30.870022	110	3	1.12	0.95	99.9161	0.0726	0.0000	0.0000;
	1530	1	0	0	0	0	1	1.087785	30.871595	110	3	1.12	0.95	99.9117	0.0699	0.0000	0.0000;
	1531	1	0	0	0	0	1	1.0879637	32.848514	110	3	1.12	0.95	100.6103	-0.0663	0.0000	0.0000;
	1532	1	5.622	0.074	0	0	1	1.0885782	32.944523	110	3	1.12	0.95	100.4920	-0.1050	0.0000	0.0000;
	1533	1	0	0	0	0	1	1.087962	32.848569	110	3	1.12	0.95	100.6103	-0.0661	0.0000	0.0000;
	1534	1	0	0	0	0	1	1.0887509	32.959284	110	3	1.12	0.95	100.4606	-0.1052	0.0000	0.0000;
	1535	1	5.056	-1.372	0	0	1	1.0781192	27.914385	110	3	1.12	0.95	101.8721	0.1325	0.0000	0.0000;
	1536	1	4.372	0.826	0	0	1	1.0780898	27.905485	110	3	1.12	0.95	101.8723	0.1325	0.0000	0.0000;
	1537	1	14.733	4.716	0	0	1	1.0717072	29.529484	110	3	1.12	0.95	101.5395	0.8374	0.0000	0.0000;
	1538	1	3.328	1.411	0	0	1	1.0685806	29.279762	110	3	1.12	0.95	102.0675	0.8855	0.0000	0.0000;
	1539	1	0	0	0	0	1	1.0717518	29.53274	110	3	1.12	0.95	101.5351	0.8360	0.0000	0.0000;
	1540	1	4.361	1.085	0	0	1	1.0678977	26.283588	110	3	1.12	0.95	103.0294	-0.2922	0.0000	0.0000;
	1541	1	6.414	1.582	0	0	1	1.0762204	27.728399	110	3	1.12	0.95	102.0191	0.1862	0.0000	0.0000;
	1542	1	8.713	2.443	0	0	1	1.0762066	27.726389	110	3	1.12	0.95	102.0215	0.1866	0.0000	0.0000;
	1543	1	19.506	9.657	0	0	1	1.0778525	27.99517	110	3	1.12	0.95	101.9888	0.9336	0.0000	0.0000;
	1544	1	11.474	6.685	0	0	1	1.0770727	28.312439	110	3	1.12	0.95	101.7084	1.1207	0.0000	0.0000;
	1545	1	10.346	1.838	0	0	1	1.0825266	28.491803	110	3	1.12	0.95	101.6122	0.8215	0.0000	0.0000;
	1546	1	0	0	0	0	1	1.0824709	28.484522	110	3	1.12	0.95	101.6117	0.8221	0.0000	0.0000;
	1547	1	2.068	0.588	0	0	1	1.0862079	30.797943	110	3	1.12	0.95	100.0075	0.1520	0.0000	0.0000;
	1548	1	0	0.037	0	0	1	1.0862553	30.806385	110	3	1.12	0.95	100.0053	0.1508	0.0000	0.0000;
	1549	1	1.033	0.436	0	0	1	1.0818653	29.856673	110	3	1.12	0.95	100.5920	-0.0461	0.0000	0.0000;
	1550	1	6.435	2.206	0	0	1	1.082932	29.980429	110	3	1.12	0.95	100.4692	-0.0692	0.0000	0.0000;
	1551	1	0	0	0	0	1	1.0819127	29.859738	110	3	1.12	0.95	100.5879	-0.0476	0.0000	0.0000;
	1552	1	0	0	0	0	1	1.083218	30.000497	110	3	1.12	0.95	100.4428	-0.0780	0.0000	0.0000;
	1553	1	2.872	-0.87	0	0	1	1.0920629	30.248873	110	3	1.12	0.95	100.0455	-0.5361	0.0000	0.0000;
	1554	1	0	0	0	0	1	1.0920517	30.251634	110	3	1.12	0.95	100.0468	-0.5363	0.0000	0.0000;
	1555	1	1.263	0.42	0	0	1	1.0934613	34.282499	110	3	1.12	0.95	99.6220	0.1704	0.0000	0.0000;
	1556	1	1.953	0.662	0	0	1	1.0934795	34.268484	110	3	1.12	0.95	99.6168	0.1711	0.0000	0.0000;
	1557	1	5.518	-1.023	0	0	1	1.0812826	28.335915	110	3	1.12	0.95	101.4393	0.0245	0.0000	0.0000;
	1558	1	4.942	1.113	0	0	1	1.0812452	28.325202	110	3	1.12	0.95	101.4410	0.0253	0.0000	0.0000;
	1559	1	5.622	1.783	0	0	1	1.0850385	30.557513	110	3	1.12	0.95	99.9810	-0.0298	0.0000	0.0000;
	1560	1	0	0	0	0	1	1.0856325	30.603055	110	3	1.12	0.95	99.9235	-0.0468	0.0000	0.0000;
	1561	1	0.918	0.191	0	0	1	1.0718545	27.124443	110	3	1.12	0.95	101.8289	-0.4938	0.0000	0.0000;
	1562	1	0.688	0.189	0	0	1	1.0719324	27.124634	110	3	1.12	0.95	101.8284	-0.4947	0.0000	0.0000;
	1563	1	8.045	2.112	0	0	1	1.0798722	29.077285	110	3	1.12	0.95	101.2273	-0.1186	0.0000	0.0000;
	1564	1	8.039	1.597	0	0	1	1.0799792	29.0792	110	3	1.12	0.95	101.2227	-0.1255	0.0000	0.0000;
	1565	1	0	0	0	0	1	1.0800082	29.086219	110	3	1.12	0.95	101.2111	-0.1228	0.0000	0.0000;
	1566	1	0	0	0	0	1	1.0801248	29.090902	110	3	1.12	0.95	101.2043	-0.1291	0.0000	0.0000;
	1567	1	8.284	1.83	0	0	1	1.0848643	30.87288	110	3	1.12	0.95	101.9521	-0.0314	0.0000	0.0000;
	1568	1	1.608	0.053	0	0	1	1.0848039	30.878376	110	3	1.12	0.95	101.9601	-0.0316	0.0000	0.0000;
	1569	1	0	0	0	0	1	1.0901436	29.27527	110	3	1.12	0.95	100.2792	0.3751	0.0000	0.0000;
	1570	1	0	0	0	0	1	1.0900852	29.261892	110	3	1.12	0.95	100.2823	0.3759	0.0000	0.0000;
	1571	1	8.841	-2.292	0	0	1	1.0775927	27.788217	110	3	1.12	0.95	101.9399	0.1241	0.0000	0.0000;
	1572	1	11.023	0.452	0	0	1	1.0837084	28.704214	110	3	1.12	0.95	101.1080	0.0127	0.0000	0.0000;
	1573	1	9.211	3.205	0	0	1	1.0912571	30.083026	110	3	1.12	0.95	100.0828	-0.4244	0.0000	0.0000;
	1574	1	0	0	0	0	1	1.0912885	30.085332	110	3	1.12	0.95	100.0798	-0.4243	0.0000	0.0000;
	1575	1	0	0.059	0	0	1	1.0770712	28.056148	110	3	1.12	0.95	101.5788	-0.0528	0.0000	0.0000;
	1576	1	7.94	2.407	0	0	1	1.0770586	28.063742	110	3	1.12	0.95	101.5793	-0.0501	0.0000	0.0000;
	1577	1	5.737	2.526	0	0	1	1.0465736	27.333454	110	3	1.12	0.95	106.3045	0.9403	0.0000	0.0000;
	1578	1	4.475	0.149	0	0	1	1.0466027	27.330969	110	3	1.12	0.95	106.3032	0.9393	0.0000	0.0000;
	1579	1	1.147	0.371	0	0	1	1.0861979	30.206779	110	3	1.12	0.95	99.9329	0.0809	0.0000	0.0000;
	1580	1	1.836	1.04	0	0	1	1.0861256	30.186242	110	3	1.12	0.95	99.9420	0.0796	0.0000	0.0000;
	1581	1	4.018	1.151	0	0	1	1.0721213	27.543365	110	3	1.12	0.95	101.4037	-0.4068	0.0000	0.0000;
	1582	1	1.033	0.334	0	0	1	1.0721444	27.535379	110	3	1.12	0.95	101.4064	-0.4068	0.0000	0.0000;
	1583	1	4.016	0.669	0	0	1	1.0993135	30.274358	110	3	1.12	0.95	99.1753	0.2224	0.0000	0.0000;
	1584	1	8.032	2.749	0	0	1	1.0992812	30.268978	110	3	1.12	0.95	99.1785	0.2211	0.0000	0.0000;
	1585	1	3.676	0.866	0	0	1	1.0900373	28.944812	110	3	1.12	0.95	100.7329	0.5954	0.0000	0.0000;
	1586	1	0	0	0	0	1	1.0900863	28.952617	110	3	1.12	0.95	100.7314	0.5946	0.0000	0.0000;
	1587	1	5.979	1.783	0	0	1	1.0974798	30.015571	110	3	1.12	0.95	99.4097	0.4313	0.0000	0.0000;
	1588	1	3.215	0.771	0	0	1	1.0973826	29.989923	110	3	1.12	0.95	99.4162	0.4322	0.0000	0.0000;
	1589	1	2.066	0.756	0	0	1	1.0899601	29.47169	110	3	1.12	0.95	100.3314	0.2930	0.0000	0.0000;
	1590	1	7.7	2.708	0	0	1	1.0899254	29.466747	110	3	1.12	0.95	100.3318	0.2942	0.0000	0.0000;
	1591	1	0	0	0	0	1	1.0649277	27.050495	110	3	1.12	0.95	102.8504	-0.1693	0.0000	0.0000;
	1592	1	3.1	0.362	0	0	1	1.0649601	27.068297	110	3	1.12	0.95	102.8560	-0.1684	0.0000	0.0000;
	1593	1	7.363	2.004	0	0	1	1.0714165	29.49603	110	3	1.12	0.95	101.5904	0.8415	0.0000	0.0000;
	1594	1	2.871	0.611	0	0	1	1.0714681	29.511063	110	3	1.12	0.95	101.5837	0.8405	0.0000	0.0000;
	1595	1	1.721	0.297	0	0	1	1.0918599	29.626953	110	3	1.12	0.95	100.1770	0.2143	0.0000	0.0000;
	1596	1	0	0	0	0	1	1.0918889	29.629936	110	3	1.12	0.95	100.1734	0.2137	0.0000	0.0000;
	1597	1	6.888	0.706	0	0	1	1.0826362	29.367578	110	3	1.12	0.95	100.9551	-0.2181	0.0000	0.0000;
	1598	1	0	0	0	0	1	1.082655	29.368539	110	3	1.12	0.95	100.9548	-0.2181	0.0000	0.0000;
	1599	1	6.439	1.345	0	0	1	1.0825957	29.950439	110	3	1.12	0.95	100.4961	0.1879	0.0000	0.0000;
	1600	1	0	0	0	0	1	1.0826037	29.951165	110	3	1.12	0.95	100.4952	0.1877	0.0000	0.0000;
	1601	1	3.445	0.814	0	0	1	1.0725323	27.175142	110	3	1.12	0.95	101.7675	-0.5042	0.0000	0.0000;
	1602	1	9.073	3.231	0	0	1	1.0724623	27.177774	110	3	1.12	0.95	101.7668	-0.5034	0.0000	0.0000;
	1603	1	5.401	1.448	0	0	1	1.0751823	27.780653	110	3	1.12	0.95	102.1222	0.2799	0.0000	0.0000;
	1604	1	6.089	2.017	0	0	1	1.0751782	27.776138	110	3	1.12	0.95	102.1208	0.2796	0.0000	0.0000;
	1605	1	9.886	1.9	0	0	1	1.0874038	28.954499	110	3	1.12	0.95	100.8809	0.5717	0.0000	0.0000;
	1606	1	3.215	0.192	0	0	1	1.0873758	28.93874	110	3	1.12	0.95	100.8837	0.5712	0.0000	0.0000;
	1607	1	2.76	1.214	0	0	1	1.0665976	26.987868	110	3	1.12	0.95	103.6410	1.0957	0.0000	0.0000;
	1608	1	0	0	0	0	1	1.066594	26.98908	110	3	1.12	0.95	103.6400	1.0958	0.0000	0.0000;
	1609	1	3.099	0.81	0	0	1	1.091793	30.080977	110	3	1.12	0.95	99.9970	-0.4083	0.0000	0.0000;
	1610	1	0	0	0	0	1	1.0917995	30.081282	110	3	1.12	0.95	99.9961	-0.4085	0.0000	0.0000;
	1611	1	4.704	1.783	0	0	1	1.0842248	28.614219	110	3	1.12	0.95	101.1201	0.3624	0.0000	0.0000;
	1612	1	0	0	0	0	1	1.0842745	28.623575	110	3	1.12	0.95	101.1194	0.3621	0.0000	0.0000;
	1613	1	0	0.024	0	0	1	1.0813912	28.458344	110	3	1.12	0.95	101.3592	0.0405	0.0000	0.0000;
	1614	1	4.384	1.125	0	0	1	1.0813415	28.453287	110	3	1.12	0.95	101.3612	0.0412	0.0000	0.0000;
	1615	1	1.726	-0.932	0	0	1	1.0969156	34.489682	110	3	1.12	0.95	99.3859	-0.0492	0.0000	0.0000;
	1616	1	0	0	0	0	1	1.0965909	34.524434	110	3	1.12	0.95	99.3642	-0.0324	0.0000	0.0000;
	1617	1	1.377	0.334	0	0	1	1.0829444	29.845975	110	3	1.12	0.95	100.5665	-0.1052	0.0000	0.0000;
	1618	1	0.918	0.316	0	0	1	1.0829702	29.836118	110	3	1.12	0.95	100.5673	-0.1060	0.0000	0.0000;
	1619	1	5.513	1.203	0	0	1	1.0987061	29.727802	110	3	1.12	0.95	99.8819	0.3371	0.0000	0.0000;
	1620	1	0	0	0	0	1	1.0988294	29.749003	110	3	1.12	0.95	99.8766	0.3348	0.0000	0.0000;
	1621	1	0	0	0	0	1	1.0936513	29.430655	110	3	1.12	0.95	100.2832	0.1021	0.0000	0.0000;
	1622	1	0	0	0	0	1	1.093647	29.430752	110	3	1.12	0.95	100.2832	0.1024	0.0000	0.0000;
	1623	1	3.22	0.852	0	0	1	1.0938398	29.972819	110	3	1.12	0.95	100.6072	-0.1846	0.0000	0.0000;
	1624	1	3.796	1.259	0	0	1	1.0938175	29.966217	110	3	1.12	0.95	100.6088	-0.1849	0.0000	0.0000;
	1625	1	15.082	5.523	0	0	1	1.0860781	28.654711	110	3	1.12	0.95	100.9720	0.2831	0.0000	0.0000;
	1626	1	0	0	0	0	1	1.0861972	28.665506	110	3	1.12	0.95	100.9649	0.2805	0.0000	0.0000;
	1627	1	5.749	1.313	0	0	1	1.0835307	29.828859	110	3	1.12	0.95	100.3634	0.0650	0.0000	0.0000;
	1628	1	4.597	0.588	0	0	1	1.0835724	29.843059	110	3	1.12	0.95	100.3572	0.0662	0.0000	0.0000;
	1629	1	0	0	0	0	1	1.0846559	29.458425	110	3	1.12	0.95	100.7709	-0.2995	0.0000	0.0000;
	1630	1	0	0	0	0	1	1.0844961	29.450073	110	3	1.12	0.95	100.7787	-0.2955	0.0000	0.0000;
	1631	1	0	0	0	0	1	1.08752	29.696744	110	3	1.12	0.95	100.3486	-0.3371	0.0000	0.0000;
	1632	1	2.295	0.483	0	0	1	1.0851882	30.542861	110	3	1.12	0.95	99.9737	-0.0360	0.0000	0.0000;
	1633	1	0	0	0	0	1	1.0851641	30.52506	110	3	1.12	0.95	99.9773	-0.0361	0.0000	0.0000;
	1634	1	10.694	-2.575	0	0	1	1.0755648	27.327627	110	3	1.12	0.95	102.3270	0.1227	0.0000	0.0000;
	1635	1	11.154	-2.072	0	0	1	1.0755553	27.333427	110	3	1.12	0.95	102.3250	0.1231	0.0000	0.0000;
	1636	1	9.668	1.093	0	0	1	1.0934433	29.900234	110	3	1.12	0.95	100.6673	-0.1886	0.0000	0.0000;
	1637	1	8.86	1.336	0	0	1	1.0934373	29.901925	110	3	1.12	0.95	100.6674	-0.1880	0.0000	0.0000;
	1638	1	0	0	0	0	1	1.0934383	29.907077	110	3	1.12	0.95	100.6681	-0.1875	0.0000	0.0000;
	1639	1	0	0	0	0	1	1.0934383	29.907077	110	3	1.12	0.95	100.6681	-0.1875	0.0000	0.0000;
	1640	1	9.771	3.808	0	0	1	1.0912486	31.089657	110	3	1.12	0.95	98.7539	0.3357	0.0000	0.0000;
	1641	1	10.331	2.035	0	0	1	1.0922936	29.123161	110	3	1.12	0.95	100.5151	0.5201	0.0000	0.0000;
	1642	1	0.803	0.223	0	0	1	1.0989802	29.771275	110	3	1.12	0.95	99.8525	0.3303	0.0000	0.0000;
	1643	1	0	0	0	0	1	1.0989958	29.772545	110	3	1.12	0.95	99.8508	0.3299	0.0000	0.0000;
	1644	2	12.067	6.644	0	0	1	1.0761758	27.520727	110	3	1.12	0.95	101.3408	-0.3906	0.0000	0.0000;
	1645	1	0	0	0	0	1	1.0761708	27.517089	110	3	1.12	0.95	101.3426	-0.3916	0.0000	0.0000;
	1646	1	0	0	0	0	1	1.092092	29.171862	110	3	1.12	0.95	100.5564	0.1331	0.0000	0.0000;
	1647	1	0.229	0	0	0	1	1.1175501	32.081622	110	3	1.12	0.95	96.9639	-0.0001	0.0000	0.0000;
	1648	1	0	0	0	0	1	1.0920918	29.171866	110	3	1.12	0.95	100.5564	0.1332	0.0000	0.0000;
	1649	1	3.213	0.446	0	0	1	1.0970823	30.077045	110	3	1.12	0.95	99.3572	0.3472	0.0000	0.0000;
	1650	1	3.328	0.594	0	0	1	1.0971191	30.082103	110	3	1.12	0.95	99.3553	0.3467	0.0000	0.0000;
	1651	1	0.918	0.297	0	0	1	1.0979685	29.31272	110	3	1.12	0.95	100.3235	0.2004	0.0000	0.0000;
	1652	1	0	0	0	0	1	1.0980003	29.31525	110	3	1.12	0.95	100.3203	0.1995	0.0000	0.0000;
	1653	1	0	0	0	0	1	1.0771297	27.839038	110	3	1.12	0.95	100.8553	-0.5331	0.0000	0.0000;
	1654	1	2.182	0.78	0	0	1	1.077162	27.842288	110	3	1.12	0.95	100.8533	-0.5334	0.0000	0.0000;
	1655	1	2.18	0.78	0	0	1	1.0918857	29.278757	110	3	1.12	0.95	100.4561	0.1491	0.0000	0.0000;
	1656	1	5.741	1.969	0	0	1	1.0917573	29.273839	110	3	1.12	0.95	100.4725	0.1545	0.0000	0.0000;
	1657	1	4.131	1.693	0	0	1	1.0774982	31.527839	110	3	1.12	0.95	102.8569	-0.1237	0.0000	0.0000;
	1658	1	0	0	0	0	1	1.0776255	31.532941	110	3	1.12	0.95	102.8425	-0.1296	0.0000	0.0000;
	1659	1	5.737	1.486	0	0	1	1.0937176	31.43587	110	3	1.12	0.95	99.0444	0.0163	0.0000	0.0000;
	1660	1	9.179	1.486	0	0	1	1.0936817	31.43863	110	3	1.12	0.95	99.0479	0.0170	0.0000	0.0000;
	1661	1	3.451	1.552	0	0	1	1.0690065	27.167227	110	3	1.12	0.95	101.7506	-0.2852	0.0000	0.0000;
	1662	1	4.021	1.092	0	0	1	1.0707858	27.12067	110	3	1.12	0.95	103.3116	0.8948	0.0000	0.0000;
	1663	1	2.066	0.373	0	0	1	1.0707512	27.115174	110	3	1.12	0.95	103.3133	0.8953	0.0000	0.0000;
	1664	1	4.704	1.263	0	0	1	1.0943437	31.421084	110	3	1.12	0.95	98.9923	-0.0098	0.0000	0.0000;
	1665	1	4.934	1.189	0	0	1	1.0944072	31.422353	110	3	1.12	0.95	98.9874	-0.0109	0.0000	0.0000;
	1666	1	0	0	0	0	1	1.0666805	27.090434	110	3	1.12	0.95	102.9936	0.3862	0.0000	0.0000;
	1667	1	0	0	0	0	1	1.0666772	27.090493	110	3	1.12	0.95	102.9936	0.3865	0.0000	0.0000;
	1668	1	1.493	0.441	0	0	1	1.0852778	28.651606	110	3	1.12	0.95	101.6498	-0.7174	0.0000	0.0000;
	1669	1	0.229	0.037	0	0	1	1.0852907	28.653072	110	3	1.12	0.95	101.6471	-0.7184	0.0000	0.0000;
	1670	1	0	0	0	0	1	1.0945396	31.200022	110	3	1.12	0.95	98.6821	0.0851	0.0000	0.0000;
	1671	1	9.187	1.894	0	0	1	1.0945988	31.218099	110	3	1.12	0.95	98.6749	0.0858	0.0000	0.0000;
	1672	2	16.951	21.006	0	0	1	1.1096068	31.292947	110	3	1.12	0.95	97.9479	0.0000	0.0000	0.0000;
	1673	2	15	19	0	0	1	1.100492	31.965808	110	3	1.12	0.95	97.9268	0.0000	0.0000	0.0000;
	1674	2	14.819	15.817	0	0	1	1.0973965	32.118945	110	3	1.12	0.95	98.4995	0.0000	0.0000	0.0000;
	1675	1	6.434	1.449	0	0	1	1.0948216	30.096192	110	3	1.12	0.95	100.5029	-0.1971	0.0000	0.0000;
	1676	1	4.366	0.581	0	0	1	1.0948452	30.103828	110	3	1.12	0.95	100.5005	-0.1970	0.0000	0.0000;
	1677	1	0	0	0	0	1	1.0965518	35.137153	110	3	1.12	0.95	99.0683	0.0097	0.0000	0.0000;
	1678	1	3.91	0.504	0	0	1	1.0965395	35.122874	110	3	1.12	0.95	99.0711	0.0099	0.0000	0.0000;
	1679	1	4.488	1.371	0	0	1	1.0898418	30.699802	110	3	1.12	0.95	99.8364	-0.3455	0.0000	0.0000;
	1680	1	3.445	1	0	0	1	1.0898844	30.695644	110	3	1.12	0.95	99.8373	-0.3470	0.0000	0.0000;
	1681	1	0	0	0	0	1	1.0895843	30.993242	110	3	1.12	0.95	99.5628	-0.2079	0.0000	0.0000;
	1682	1	0	0	0	0	1	1.1019676	30.020319	110	3	1.12	0.95	99.5902	0.2491	0.0000	0.0000;
	1683	1	4.59	1.486	0	0	1	1.1018879	30.008616	110	3	1.12	0.95	99.5935	0.2502	0.0000	0.0000;
	1684	2	11.51	11.972	0	0	1	1.0888958	29.189249	110	3	1.12	0.95	100.2553	0.0081	0.0000	0.0000;
	1685	2	4.574	11.049	0	0	1	1.0884811	28.921568	110	3	1.12	0.95	100.5335	0.0000	0.0000	0.0000;
	1686	1	2.184	-0.306	0	0	1	1.0725217	27.406627	110	3	1.12	0.95	102.6966	0.1940	0.0000	0.0000;
	1687	1	5.287	0.163	0	0	1	1.0725199	27.406464	110	3	1.12	0.95	102.6969	0.1940	0.0000	0.0000;
	1688	1	2.298	0.218	0	0	1	1.0863213	28.738153	110	3	1.12	0.95	101.4023	-0.7688	0.0000	0.0000;
	1689	1	0	0	0	0	1	1.0863096	28.750542	110	3	1.12	0.95	101.4044	-0.7654	0.0000	0.0000;
	1690	1	0	0	0	0	1	1.0880413	28.891877	110	3	1.12	0.95	100.5779	0.0334	0.0000	0.0000;
	1691	1	0	0	0	0	1	1.0887711	29.143469	110	3	1.12	0.95	100.2654	0.0202	0.0000	0.0000;
	1692	1	1.836	-0.2	0	0	1	1.0824507	29.227169	110	3	1.12	0.95	101.3953	-0.3215	0.0000	0.0000;
	1693	1	2.524	1.04	0	0	1	1.0859768	32.906639	110	3	1.12	0.95	100.7936	0.1310	0.0000	0.0000;
	1694	1	5.634	1.77	0	0	1	1.0702267	27.400299	110	3	1.12	0.95	102.8105	1.1520	0.0000	0.0000;
	1695	1	10.361	2.903	0	0	1	1.0700988	27.382115	110	3	1.12	0.95	102.8157	1.1546	0.0000	0.0000;
	1696	1	2.295	0.594	0	0	1	1.0899872	29.478568	110	3	1.12	0.95	100.2131	0.3852	0.0000	0.0000;
	1697	1	0	0	0	0	1	1.0899353	29.469658	110	3	1.12	0.95	100.2166	0.3851	0.0000	0.0000;
	1698	1	1.492	0.483	0	0	1	1.0918135	29.635042	110	3	1.12	0.95	100.0019	0.3518	0.0000	0.0000;
	1699	1	3.443	1.032	0	0	1	1.1035159	30.705068	110	3	1.12	0.95	98.6777	0.1275	0.0000	0.0000;
	1700	1	0	0	0	0	1	1.0920304	29.644575	110	3	1.12	0.95	99.9701	0.3453	0.0000	0.0000;
	1701	1	0	0	0	0	1	1.1040387	30.725926	110	3	1.12	0.95	98.6061	0.1099	0.0000	0.0000;
	1702	1	9.294	2.006	0	0	1	1.0910588	29.150304	110	3	1.12	0.95	100.5988	0.1555	0.0000	0.0000;
	1703	1	3.442	0.966	0	0	1	1.0918534	29.273984	110	3	1.12	0.95	100.4594	0.1492	0.0000	0.0000;
	1704	1	0	0	0	0	1	1.0913828	29.181459	110	3	1.12	0.95	100.5635	0.1480	0.0000	0.0000;
	1705	1	5.744	1.365	0	0	1	1.0789189	28.920511	110	3	1.12	0.95	101.2237	0.1865	0.0000	0.0000;
	1706	1	4.136	-0.131	0	0	1	1.0788841	28.924254	110	3	1.12	0.95	101.2289	0.1871	0.0000	0.0000;
	1707	1	4.36	0.594	0	0	1	1.1003826	29.866345	110	3	1.12	0.95	99.7291	0.2887	0.0000	0.0000;
	1708	1	0	0	0	0	1	1.1004482	29.876334	110	3	1.12	0.95	99.7265	0.2878	0.0000	0.0000;
	1709	1	5.4	1.802	0	0	1	1.0899154	29.328324	110	3	1.12	0.95	100.4987	0.2476	0.0000	0.0000;
	1710	1	4.82	1.738	0	0	1	1.0964587	29.780454	110	3	1.12	0.95	99.9221	0.0507	0.0000	0.0000;
	1711	1	0	0	0	0	1	1.0903071	29.346383	110	3	1.12	0.95	100.4517	0.2324	0.0000	0.0000;
	1712	1	0	0	0	0	1	1.0968147	29.795891	110	3	1.12	0.95	99.8811	0.0364	0.0000	0.0000;
	1713	1	9.203	2.688	0	0	1	1.0889777	29.362631	110	3	1.12	0.95	100.3260	0.3932	0.0000	0.0000;
	1714	1	1.033	0.374	0	0	1	1.0890286	29.368782	110	3	1.12	0.95	100.3226	0.3926	0.0000	0.0000;
	1715	1	0	0.059	0	0	1	1.0802479	28.154246	110	3	1.12	0.95	101.7140	0.6289	0.0000	0.0000;
	1716	1	1.837	0.37	0	0	1	1.0802122	28.159598	110	3	1.12	0.95	101.7148	0.6279	0.0000	0.0000;
	1717	1	0	0	0	0	1	1.0848444	30.01201	110	3	1.12	0.95	100.1502	0.0713	0.0000	0.0000;
	1718	1	7.688	1.411	0	0	1	1.0900995	30.595398	110	3	1.12	0.95	99.3845	0.0699	0.0000	0.0000;
	1719	1	0	0.024	0	0	1	1.0835227	31.953389	110	3	1.12	0.95	101.6408	0.0907	0.0000	0.0000;
	1720	1	0	0	0	0	1	1.0835401	31.948242	110	3	1.12	0.95	101.6397	0.0912	0.0000	0.0000;
	1721	1	2.066	0.599	0	0	1	1.0900118	31.132227	110	3	1.12	0.95	99.6219	0.0280	0.0000	0.0000;
	1722	1	4.827	1.427	0	0	1	1.089181	31.067607	110	3	1.12	0.95	99.6842	0.0573	0.0000	0.0000;
	1723	1	0	0	0	0	1	1.0900172	31.132591	110	3	1.12	0.95	99.6213	0.0278	0.0000	0.0000;
	1724	1	0	0	0	0	1	1.0893195	31.07907	110	3	1.12	0.95	99.6714	0.0536	0.0000	0.0000;
	1725	1	8.285	2.293	0	0	1	1.0715711	27.567668	110	3	1.12	0.95	102.8665	1.0047	0.0000	0.0000;
	1726	1	7.355	2.628	0	0	1	1.0715104	27.5583	110	3	1.12	0.95	102.8709	1.0058	0.0000	0.0000;
	1727	1	7.924	2.117	0	0	1	1.0880604	30.860777	110	3	1.12	0.95	99.9241	0.0547	0.0000	0.0000;
	1728	1	3.902	1.151	0	0	1	1.0879869	30.848651	110	3	1.12	0.95	99.9286	0.0559	0.0000	0.0000;
	1729	1	0	0.037	0	0	1	1.089483	31.158918	110	3	1.12	0.95	99.3927	-0.1212	0.0000	0.0000;
	1730	1	1.263	0.42	0	0	1	1.0894495	31.164856	110	3	1.12	0.95	99.3911	-0.1199	0.0000	0.0000;
	1731	1	1.492	0.557	0	0	1	1.0843182	30.455195	110	3	1.12	0.95	100.3674	0.1416	0.0000	0.0000;
	1732	1	9.994	3.38	0	0	1	1.0957789	29.97336	110	3	1.12	0.95	99.4666	0.3829	0.0000	0.0000;
	1733	1	1.147	0.371	0	0	1	1.0844032	29.398032	110	3	1.12	0.95	100.7872	-0.2786	0.0000	0.0000;
	1734	1	0	0	0	0	1	1.0865371	32.828899	110	3	1.12	0.95	100.8257	0.0164	0.0000	0.0000;
	1735	1	11.016	0.88	0	0	1	1.0865165	32.824026	110	3	1.12	0.95	100.8273	0.0161	0.0000	0.0000;
	1736	1	16.665	2.448	0	0	1	1.079911	29.089067	110	3	1.12	0.95	101.2094	-0.1075	0.0000	0.0000;
	1737	1	1.721	0.227	0	0	1	1.0799276	29.088579	110	3	1.12	0.95	101.2098	-0.1091	0.0000	0.0000;
	1738	1	5.217	2.081	0	0	1	1.0584295	25.687464	110	3	1.12	0.95	103.6769	-0.1218	0.0000	0.0000;
	1739	1	9.59	3.223	0	0	1	1.0584515	25.690674	110	3	1.12	0.95	103.6776	-0.1208	0.0000	0.0000;
	1740	1	4.597	0.964	0	0	1	1.0938124	29.988821	110	3	1.12	0.95	100.6719	-0.1913	0.0000	0.0000;
	1741	1	8.611	1.671	0	0	1	1.093482	29.967769	110	3	1.12	0.95	100.7151	-0.1839	0.0000	0.0000;
	1742	1	10.327	2.229	0	0	1	1.0530244	26.037409	110	3	1.12	0.95	104.4672	0.1166	0.0000	0.0000;
	1743	1	8.032	1.486	0	0	1	1.0531785	26.038931	110	3	1.12	0.95	104.4447	0.1115	0.0000	0.0000;
	1744	1	1.149	0.046	0	0	1	1.0857402	33.012597	110	3	1.12	0.95	100.7244	0.1022	0.0000	0.0000;
	1745	1	0.803	0.042	0	0	1	1.0857559	33.009481	110	3	1.12	0.95	100.7237	0.1016	0.0000	0.0000;
	1746	1	2.64	0.836	0	0	1	1.0743219	27.61261	110	3	1.12	0.95	102.3212	0.9977	0.0000	0.0000;
	1747	1	3.443	0.093	0	0	1	1.0742935	27.605576	110	3	1.12	0.95	102.3208	0.9972	0.0000	0.0000;
	1748	1	5.859	2.18	0	0	1	1.0670038	26.016503	110	3	1.12	0.95	103.0254	-0.3901	0.0000	0.0000;
	1749	1	1.493	0.368	0	0	1	1.067025	26.019896	110	3	1.12	0.95	103.0232	-0.3908	0.0000	0.0000;
	1750	1	6.901	1.434	0	0	1	1.069295	29.310901	110	3	1.12	0.95	101.9963	0.8572	0.0000	0.0000;
	1751	1	6.325	1.346	0	0	1	1.0692999	29.319104	110	3	1.12	0.95	101.9923	0.8569	0.0000	0.0000;
	1752	1	0	0	0	0	1	1.0687454	27.727479	110	3	1.12	0.95	102.8760	0.8284	0.0000	0.0000;
	1753	1	8.627	3.23	0	0	1	1.0687706	27.733962	110	3	1.12	0.95	102.8758	0.8288	0.0000	0.0000;
	1754	1	5.975	1.001	0	0	1	1.0953501	34.426601	110	3	1.12	0.95	99.2689	-0.0519	0.0000	0.0000;
	1755	1	2.525	0.269	0	0	1	1.0952895	34.397354	110	3	1.12	0.95	99.2828	-0.0535	0.0000	0.0000;
	1756	1	7.114	1.857	0	0	1	1.0886097	28.611264	110	3	1.12	0.95	101.0830	0.5052	0.0000	0.0000;
	1757	1	0	0	0	0	1	1.0884862	28.599677	110	3	1.12	0.95	101.0874	0.5078	0.0000	0.0000;
	1758	1	3.1	0.564	0	0	1	1.0929442	33.895059	110	3	1.12	0.95	99.5728	-0.0712	0.0000	0.0000;
	1759	1	8.163	0.678	0	0	1	1.0928228	33.897587	110	3	1.12	0.95	99.5903	-0.0691	0.0000	0.0000;
	1760	1	12.44	1.102	0	0	1	1.0844834	29.404875	110	3	1.12	0.95	100.7788	-0.2807	0.0000	0.0000;
	1761	1	0	0	0	0	1	1.084517	29.410505	110	3	1.12	0.95	100.7755	-0.2812	0.0000	0.0000;
	1762	1	3.222	1.552	0	0	1	1.0809407	28.497249	110	3	1.12	0.95	101.1591	0.1848	0.0000	0.0000;
	1763	1	0	0.036	0	0	1	1.080851	28.48229	110	3	1.12	0.95	101.1655	0.1855	0.0000	0.0000;
	1764	1	2.87	0.443	0	0	1	1.0712297	27.155619	110	3	1.12	0.95	101.7804	-0.4161	0.0000	0.0000;
	1765	1	0	0	0	0	1	1.0706601	27.430884	110	3	1.12	0.95	101.5413	-0.3421	0.0000	0.0000;
	1766	1	2.068	0.064	0	0	1	1.0818317	28.54236	110	3	1.12	0.95	101.2239	0.4870	0.0000	0.0000;
	1767	1	3.334	0.479	0	0	1	1.0818027	28.544271	110	3	1.12	0.95	101.2235	0.4880	0.0000	0.0000;
	1768	1	3.447	1.231	0	0	1	1.0826362	29.750733	110	3	1.12	0.95	100.4469	0.2860	0.0000	0.0000;
	1769	1	0	0.059	0	0	1	1.0826297	29.762651	110	3	1.12	0.95	100.4491	0.2863	0.0000	0.0000;
	1770	1	7.917	2.303	0	0	1	1.0856205	30.578129	110	3	1.12	0.95	100.2298	0.1067	0.0000	0.0000;
	1771	1	0	0	0	0	1	1.0856133	30.580792	110	3	1.12	0.95	100.2292	0.1068	0.0000	0.0000;
	1772	1	4.017	1.003	0	0	1	1.0903216	31.112476	110	3	1.12	0.95	99.6347	0.0050	0.0000	0.0000;
	1773	1	5.167	0.49	0	0	1	1.0903196	31.107251	110	3	1.12	0.95	99.6366	0.0052	0.0000	0.0000;
	1774	1	9.198	2.756	0	0	1	1.0758115	27.664315	110	3	1.12	0.95	102.0453	0.2019	0.0000	0.0000;
	1775	1	7.011	2.537	0	0	1	1.0758989	27.67402	110	3	1.12	0.95	102.0361	0.1996	0.0000	0.0000;
	1776	2	21.8	8.172	0	0	1	1.0814384	29.46356	110	3	1.12	0.95	100.8978	-0.1295	0.0000	0.0000;
	1777	1	0	0	0	0	1	1.0815078	29.466251	110	3	1.12	0.95	100.8956	-0.1307	0.0000	0.0000;
	1778	1	7.458	1.411	0	0	1	1.0982061	31.705929	110	3	1.12	0.95	98.1434	0.0679	0.0000	0.0000;
	1779	1	0	0	0	0	1	1.0983879	31.724461	110	3	1.12	0.95	98.1233	0.0642	0.0000	0.0000;
	1780	1	4.823	1.631	0	0	1	1.0855561	30.555534	110	3	1.12	0.95	100.2558	0.1050	0.0000	0.0000;
	1781	1	0	0	0	0	1	1.0855364	30.555438	110	3	1.12	0.95	100.2561	0.1052	0.0000	0.0000;
	1782	1	4.593	0.985	0	0	1	1.0826989	29.415745	110	3	1.12	0.95	100.9185	-0.2013	0.0000	0.0000;
	1783	1	5.166	1.151	0	0	1	1.0829994	29.375799	110	3	1.12	0.95	100.9574	-0.2320	0.0000	0.0000;
	1784	1	0	0	0	0	1	1.0829378	29.42746	110	3	1.12	0.95	100.8839	-0.2084	0.0000	0.0000;
	1785	1	0	0	0	0	1	1.0832516	29.387112	110	3	1.12	0.95	100.9207	-0.2399	0.0000	0.0000;
	1786	1	5.747	1.086	0	0	1	1.0703741	27.208641	110	3	1.12	0.95	101.7783	-0.4043	0.0000	0.0000;
	1787	1	0	0	0	0	1	1.0704231	27.204094	110	3	1.12	0.95	101.7795	-0.4048	0.0000	0.0000;
	1788	1	0.803	0.21	0	0	1	1.0907003	33.271081	110	3	1.12	0.95	100.1075	-0.1254	0.0000	0.0000;
	1789	1	0	0	0	0	1	1.0907128	33.274736	110	3	1.12	0.95	100.1054	-0.1259	0.0000	0.0000;
	1790	1	0	0	0	0	1	1.074211	27.127546	110	3	1.12	0.95	101.7907	-0.5925	0.0000	0.0000;
	1791	1	0	0	0	0	1	1.0739147	27.116208	110	3	1.12	0.95	101.8011	-0.5848	0.0000	0.0000;
	1792	1	7.458	3.343	0	0	1	1.101254	31.129311	110	3	1.12	0.95	99.4549	-0.7791	0.0000	0.0000;
	1793	2	9.169	8.162	0	0	1	1.0992973	30.792316	110	3	1.12	0.95	99.6290	-0.9710	0.0000	0.0000;
	1794	2	13.404	10.008	0	0	1	1.1058562	30.829654	110	3	1.12	0.95	98.4302	0.1463	0.0000	0.0000;
	1795	1	5.404	1.92	0	0	1	1.1057215	30.81528	110	3	1.12	0.95	98.4344	0.1477	0.0000	0.0000;
	1796	1	7.931	2.793	0	0	1	1.1064335	30.953246	110	3	1.12	0.95	98.2913	0.1646	0.0000	0.0000;
	1797	1	7.941	2.888	0	0	1	1.1063963	30.942442	110	3	1.12	0.95	98.2954	0.1643	0.0000	0.0000;
	1798	1	3.217	1.149	0	0	1	1.0934002	29.748641	110	3	1.12	0.95	100.0330	0.1599	0.0000	0.0000;
	1799	1	4.252	1.483	0	0	1	1.0861223	30.571767	110	3	1.12	0.95	100.2253	0.0821	0.0000	0.0000;
	1800	1	0	0	0	0	1	1.0934277	29.750282	110	3	1.12	0.95	100.0303	0.1589	0.0000	0.0000;
	1801	1	4.361	0.929	0	0	1	1.0827604	29.71483	110	3	1.12	0.95	100.5058	0.0516	0.0000	0.0000;
	1802	1	1.836	0.334	0	0	1	1.0827431	29.704613	110	3	1.12	0.95	100.5105	0.0502	0.0000	0.0000;
	1803	1	5.057	1.189	0	0	1	1.0994852	30.299269	110	3	1.12	0.95	99.1116	0.2030	0.0000	0.0000;
	1804	1	4.707	1.478	0	0	1	1.1064988	30.976002	110	3	1.12	0.95	98.3202	0.0524	0.0000	0.0000;
	1805	1	0	0	0	0	1	1.0692367	26.708347	110	3	1.12	0.95	102.3336	-0.4356	0.0000	0.0000;
	1806	1	5.749	3.17	0	0	1	1.0692773	26.71573	110	3	1.12	0.95	102.3303	-0.4367	0.0000	0.0000;
	1807	1	2.527	0.009	0	0	1	1.0815136	32.365469	110	3	1.12	0.95	101.9882	-0.0922	0.0000	0.0000;
	1808	1	0	0	0	0	1	1.0815136	32.365469	110	3	1.12	0.95	101.9882	-0.0922	0.0000	0.0000;
	1809	1	8.614	2.86	0	0	1	1.1026594	30.594226	110	3	1.12	0.95	98.7864	0.2152	0.0000	0.0000;
	1810	1	11.028	3.677	0	0	1	1.1025017	30.570377	110	3	1.12	0.95	98.7963	0.2158	0.0000	0.0000;
	1811	1	6.559	2.288	0	0	1	1.0622225	26.834918	110	3	1.12	0.95	103.5086	1.4634	0.0000	0.0000;
	1812	1	8.959	2.024	0	0	1	1.0620722	26.817749	110	3	1.12	0.95	103.5137	1.4666	0.0000	0.0000;
	1813	1	5.747	2.154	0	0	1	1.0828273	28.482662	110	3	1.12	0.95	101.1376	0.5934	0.0000	0.0000;
	1814	1	0	0	0	0	1	1.0833415	28.499354	110	3	1.12	0.95	101.0707	0.5694	0.0000	0.0000;
	1815	1	0	0	0	0	1	1.0811465	29.170915	110	3	1.12	0.95	101.1181	-0.1578	0.0000	0.0000;
	1816	1	0	0	0	0	1	1.0811465	29.170915	110	3	1.12	0.95	101.1181	-0.1578	0.0000	0.0000;
	1817	1	0	0	0	0	1	1.0808996	28.554231	110	3	1.12	0.95	101.2530	0.0234	0.0000	0.0000;
	1818	1	0	0	0	0	1	1.077684	28.271799	110	3	1.12	0.95	101.6533	0.1814	0.0000	0.0000;
	1819	1	11.409	4.144	0	0	1	1.0779933	27.903464	110	3	1.12	0.95	102.1820	0.7391	0.0000	0.0000;
	1820	1	6.554	1.812	0	0	1	1.0779518	27.888732	110	3	1.12	0.95	102.1848	0.7393	0.0000	0.0000;
	1821	1	6.431	2.077	0	0	1	1.0825599	29.502026	110	3	1.12	0.95	100.8282	-0.1716	0.0000	0.0000;
	1822	1	0	0	0	0	1	1.0825802	29.500335	110	3	1.12	0.95	100.8280	-0.1717	0.0000	0.0000;
	1823	1	10.233	2.277	0	0	1	1.0823332	28.543072	110	3	1.12	0.95	101.2721	0.0261	0.0000	0.0000;
	1824	1	13.346	3.657	0	0	1	1.0823354	28.546827	110	3	1.12	0.95	101.2716	0.0269	0.0000	0.0000;
	1825	1	4.022	1.171	0	0	1	1.0821081	32.006328	110	3	1.12	0.95	101.8432	0.2171	0.0000	0.0000;
	1826	1	3.676	1.158	0	0	1	1.0820505	32.013282	110	3	1.12	0.95	101.8512	0.2169	0.0000	0.0000;
	1827	1	3.677	1.313	0	0	1	1.0936257	29.770245	110	3	1.12	0.95	100.0140	0.1515	0.0000	0.0000;
	1828	1	8.957	2.934	0	0	1	1.0878792	29.058773	110	3	1.12	0.95	100.7528	0.2836	0.0000	0.0000;
	1829	1	0	0	0	0	1	1.0880047	29.068114	110	3	1.12	0.95	100.7414	0.2799	0.0000	0.0000;
	1830	1	0	0.059	0	0	1	1.0665163	27.069161	110	3	1.12	0.95	103.5216	1.1292	0.0000	0.0000;
	1831	1	13.03	4.841	0	0	1	1.0665085	27.070397	110	3	1.12	0.95	103.5206	1.1294	0.0000	0.0000;
	1832	1	4.821	1.403	0	0	1	1.0954808	31.080763	110	3	1.12	0.95	99.5966	-0.3932	0.0000	0.0000;
	1833	1	7.242	1.975	0	0	1	1.0955896	31.080768	110	3	1.12	0.95	99.5973	-0.3970	0.0000	0.0000;
	1834	1	0	0	0	0	1	1.0855353	29.938411	110	3	1.12	0.95	100.2122	-0.0185	0.0000	0.0000;
	1835	1	3.098	0.446	0	0	1	1.0855251	29.932749	110	3	1.12	0.95	100.2137	-0.0194	0.0000	0.0000;
	1836	2	13	29	0	0	1	1.106275	32.649836	110	3	1.12	0.95	97.0378	0.0000	0.0000	0.0000;
	1837	1	0	0	0	0	1	1.1009261	30.050715	110	3	1.12	0.95	99.5519	0.2745	0.0000	0.0000;
	1838	2	13	29	0	0	1	1.1105307	30.696127	110	3	1.12	0.95	98.8395	0.0000	0.0000	0.0000;
	1839	1	0	0	0	0	1	1.0919906	29.285097	110	3	1.12	0.95	100.4455	0.1455	0.0000	0.0000;
	1840	1	2.527	0.908	0	0	1	1.0920332	29.290548	110	3	1.12	0.95	100.4444	0.1451	0.0000	0.0000;
	1841	1	6.903	2.279	0	0	1	1.0602586	26.670159	110	3	1.12	0.95	103.7052	1.5231	0.0000	0.0000;
	1842	1	6.552	3.127	0	0	1	1.0987239	30.758403	110	3	1.12	0.95	99.6679	-0.9528	0.0000	0.0000;
	1843	1	14.367	4.95	0	0	1	1.0704637	27.2878	110	3	1.12	0.95	102.8523	0.2859	0.0000	0.0000;
	1844	1	0	0	0	0	1	1.070445	27.277307	110	3	1.12	0.95	102.8518	0.2842	0.0000	0.0000;
	1845	2	0	0	0	0	1	1.1082967	31.131514	110	3	1.12	0.95	98.1195	0.0143	0.0000	0.0000;
	1846	1	0	0.111	0	0	1	1.1082498	31.123598	110	3	1.12	0.95	98.1221	0.0147	0.0000	0.0000;
	1847	1	0	0	0	0	1	1.0903186	29.227652	110	3	1.12	0.95	100.5446	0.2097	0.0000	0.0000;
	1848	1	4.138	1.632	0	0	1	1.0903706	29.231969	110	3	1.12	0.95	100.5426	0.2090	0.0000	0.0000;
	1849	1	9.195	1.782	0	0	1	1.0880932	28.749861	110	3	1.12	0.95	101.0061	0.6394	0.0000	0.0000;
	1850	1	9.771	2.036	0	0	1	1.088067	28.743921	110	3	1.12	0.95	101.0062	0.6398	0.0000	0.0000;
	1851	1	3.676	0.793	0	0	1	1.0933371	30.708303	110	3	1.12	0.95	99.1407	0.0625	0.0000	0.0000;
	1852	1	2.644	0.758	0	0	1	1.0933254	30.691066	110	3	1.12	0.95	99.1430	0.0629	0.0000	0.0000;
	1853	1	7.233	1.969	0	0	1	1.0828418	29.80593	110	3	1.12	0.95	100.4137	0.2864	0.0000	0.0000;
	1854	1	2.986	0.712	0	0	1	1.0828562	29.820687	110	3	1.12	0.95	100.4148	0.2864	0.0000	0.0000;
	1855	1	0	0	0	0	1	1.0974078	32.118753	110	3	1.12	0.95	98.4995	-0.0007	0.0000	0.0000;
	1856	1	7.471	3.065	0	0	1	1.1089652	31.253177	110	3	1.12	0.95	97.9991	0.0204	0.0000	0.0000;
	1857	1	0	0	0	0	1	1.0942413	29.785847	110	3	1.12	0.95	99.9808	0.1321	0.0000	0.0000;
	1858	1	10.22	-31.369	0	0	1	1.095929	30.08262	110	3	1.12	0.95	100.3779	-0.2877	0.0000	0.0000;
	1859	1	1.147	0.186	0	0	1	1.093255	30.151703	110	3	1.12	0.95	99.8198	-0.4608	0.0000	0.0000;
	1860	1	2.066	0.523	0	0	1	1.0580837	25.672834	110	3	1.12	0.95	103.7221	-0.1061	0.0000	0.0000;
	1861	1	4.828	1.96	0	0	1	1.058077	25.67241	110	3	1.12	0.95	103.7225	-0.1059	0.0000	0.0000;
	1862	1	6.435	2.523	0	0	1	1.0609507	26.523188	110	3	1.12	0.95	103.7475	0.4451	0.0000	0.0000;
	1863	1	4.592	1.449	0	0	1	1.0609929	26.531563	110	3	1.12	0.95	103.7480	0.4474	0.0000	0.0000;
	1864	1	0.115	0.024	0	0	1	1.0959507	30.652749	110	3	1.12	0.95	99.7765	-0.7801	0.0000	0.0000;
	1865	1	0	0	0	0	1	1.0958792	30.648435	110	3	1.12	0.95	99.7768	-0.7776	0.0000	0.0000;
	1866	1	0.688	0.149	0	0	1	1.0990452	30.235516	110	3	1.12	0.95	99.2266	0.2014	0.0000	0.0000;
	1867	1	1.147	0.371	0	0	1	1.099	30.233901	110	3	1.12	0.95	99.2283	0.2041	0.0000	0.0000;
	1868	1	0	0	0	0	1	1.087435	28.644358	110	3	1.12	0.95	101.2162	0.5654	0.0000	0.0000;
	1869	1	0	0	0	0	1	1.0919706	30.219867	110	3	1.12	0.95	100.0547	-0.5240	0.0000	0.0000;
	1870	1	0	0	0	0	1	1.0919598	30.216799	110	3	1.12	0.95	100.0554	-0.5224	0.0000	0.0000;
	1871	1	0	0	0	0	1	1.0554008	26.470395	110	3	1.12	0.95	104.1036	1.8042	0.0000	0.0000;
	1872	2	11.528	6.649	0	0	1	1.0848239	29.806439	110	3	1.12	0.95	100.3400	-0.0475	0.0000	0.0000;
	1873	2	0	0	0	0	1	1.0824689	29.432429	110	3	1.12	0.95	100.8832	-0.1896	0.0000	0.0000;
	1874	1	2.877	1.607	0	0	1	1.0856274	28.752821	110	3	1.12	0.95	100.9976	0.3272	0.0000	0.0000;
	1875	1	2.297	1.357	0	0	1	1.0924449	29.678493	110	3	1.12	0.95	100.1187	0.1940	0.0000	0.0000;
	1876	1	0	0	0	0	1	1.0856321	28.752988	110	3	1.12	0.95	100.9972	0.3270	0.0000	0.0000;
	1877	1	0	0	0	0	1	1.0924487	29.678622	110	3	1.12	0.95	100.1184	0.1938	0.0000	0.0000;
	1878	1	2.065	0.52	0	0	1	1.0972883	30.389339	110	3	1.12	0.95	100.4845	-0.2032	0.0000	0.0000;
	1879	1	6.319	0.784	0	0	1	1.0972925	30.393061	110	3	1.12	0.95	100.4891	-0.2012	0.0000	0.0000;
	1880	1	10.462	1.893	0	0	1	1.0996046	34.854148	110	3	1.12	0.95	98.5641	-0.0034	0.0000	0.0000;
	1881	1	7.814	0.542	0	0	1	1.0995568	34.829124	110	3	1.12	0.95	98.5702	-0.0042	0.0000	0.0000;
	1882	1	13.884	3.566	0	0	1	1.0843941	29.84697	110	3	1.12	0.95	100.3202	0.0115	0.0000	0.0000;
	1883	1	10.671	4.234	0	0	1	1.0844037	29.85404	110	3	1.12	0.95	100.3182	0.0127	0.0000	0.0000;
	1884	1	4.483	1.579	0	0	1	1.0803653	28.299065	110	3	1.12	0.95	101.2723	0.4451	0.0000	0.0000;
	1885	1	9.21	3.179	0	0	1	1.0803956	28.306372	110	3	1.12	0.95	101.2709	0.4466	0.0000	0.0000;
	1886	1	6.671	1.747	0	0	1	1.0880037	29.059006	110	3	1.12	0.95	100.4857	0.2638	0.0000	0.0000;
	1887	1	0	0	0	0	1	1.0880161	29.060976	110	3	1.12	0.95	100.4852	0.2658	0.0000	0.0000;
	1888	1	0	0	0	0	1	1.0824716	29.230465	110	3	1.12	0.95	101.3901	-0.3208	0.0000	0.0000;
	1889	1	4.711	0.973	0	0	1	1.0860344	32.910363	110	3	1.12	0.95	100.7889	0.1291	0.0000	0.0000;
	1890	1	1.147	0.743	0	0	1	1.0903183	28.818714	110	3	1.12	0.95	100.9690	0.4609	0.0000	0.0000;
	1891	1	6.655	3.714	0	0	1	1.0902023	28.809054	110	3	1.12	0.95	100.9746	0.4635	0.0000	0.0000;
	1892	1	0	0	0	0	1	1.0877756	29.554613	110	3	1.12	0.95	100.2530	0.0477	0.0000	0.0000;
	1893	1	0	0.321	0	0	1	1.0877729	29.538333	110	3	1.12	0.95	100.2550	0.0477	0.0000	0.0000;
	1894	1	2.873	0.536	0	0	1	1.0860445	32.705447	110	3	1.12	0.95	100.8840	-0.0225	0.0000	0.0000;
	1895	1	1.377	0.111	0	0	1	1.0860809	32.704001	110	3	1.12	0.95	100.8829	-0.0230	0.0000	0.0000;
	1896	1	5.508	0.966	0	0	1	1.09173	30.42555	110	3	1.12	0.95	100.0234	-0.5372	0.0000	0.0000;
	1897	1	3.672	0	0	0	1	1.091746	30.425586	110	3	1.12	0.95	100.0222	-0.5370	0.0000	0.0000;
	1898	1	1.377	0.891	0	0	1	1.0925188	29.333038	110	3	1.12	0.95	100.3812	0.1340	0.0000	0.0000;
	1899	1	0	0	0	0	1	1.0925457	29.334289	110	3	1.12	0.95	100.3797	0.1330	0.0000	0.0000;
	1900	1	5.967	1.189	0	0	1	1.0993466	30.28198	110	3	1.12	0.95	99.1316	0.2915	0.0000	0.0000;
	1901	1	2.524	0.52	0	0	1	1.0992989	30.274676	110	3	1.12	0.95	99.1343	0.2922	0.0000	0.0000;
	1902	1	9.437	1.574	0	0	1	1.0824329	28.654526	110	3	1.12	0.95	101.4559	0.5244	0.0000	0.0000;
	1903	1	0	0	0	0	1	1.082466	28.666833	110	3	1.12	0.95	101.4544	0.5236	0.0000	0.0000;
	1904	1	1.378	0.365	0	0	1	1.0917523	30.437962	110	3	1.12	0.95	100.0167	-0.5388	0.0000	0.0000;
	1905	1	0	0.059	0	0	1	1.0917511	30.440612	110	3	1.12	0.95	100.0170	-0.5393	0.0000	0.0000;
	1906	2	6.885	1.229	0	0	1	1.082079	28.456902	110	3	1.12	0.95	101.6393	0.8377	0.0000	0.0000;
	1907	2	19.22	8.593	0	0	1	1.0820547	28.45676	110	3	1.12	0.95	101.6428	0.8385	0.0000	0.0000;
	1908	1	0	0	0	0	1	1.0820914	28.457337	110	3	1.12	0.95	101.6375	0.8373	0.0000	0.0000;
	1909	1	0	0	0	0	1	1.0820914	28.457337	110	3	1.12	0.95	101.6375	0.8373	0.0000	0.0000;
	1910	1	1.837	0.53	0	0	1	1.087287	28.631323	110	3	1.12	0.95	101.2323	0.5692	0.0000	0.0000;
	1911	1	2.296	0.534	0	0	1	1.1095501	30.549755	110	3	1.12	0.95	99.0011	0.0041	0.0000	0.0000;
	1912	1	0	0	0	0	1	1.0874169	28.642523	110	3	1.12	0.95	101.2180	0.5658	0.0000	0.0000;
	1913	1	2.41	0.52	0	0	1	1.0918049	30.455078	110	3	1.12	0.95	100.0159	-0.5339	0.0000	0.0000;
	1914	1	6.087	0.711	0	0	1	1.0917946	30.458235	110	3	1.12	0.95	100.0184	-0.5334	0.0000	0.0000;
	1915	1	4.025	1.099	0	0	1	1.0915521	30.427629	110	3	1.12	0.95	100.0368	-0.5292	0.0000	0.0000;
	1916	1	7.249	2.115	0	0	1	1.0915344	30.426329	110	3	1.12	0.95	100.0376	-0.5293	0.0000	0.0000;
	1917	1	1.722	0.22	0	0	1	1.087354	29.095621	110	3	1.12	0.95	101.1236	-0.7109	0.0000	0.0000;
	1918	1	0	0	0	0	1	1.0873439	29.106873	110	3	1.12	0.95	101.1227	-0.7099	0.0000	0.0000;
	1919	1	2.411	0.78	0	0	1	1.09576	30.218013	110	3	1.12	0.95	100.3595	-0.2002	0.0000	0.0000;
	1920	1	8.956	0.984	0	0	1	1.0954438	30.182219	110	3	1.12	0.95	100.4127	-0.1982	0.0000	0.0000;
	1921	1	3.905	1.385	0	0	1	1.1107527	31.388264	110	3	1.12	0.95	97.7710	0.1043	0.0000	0.0000;
	1922	1	3.559	1.227	0	0	1	1.1108221	31.402124	110	3	1.12	0.95	97.7651	0.1040	0.0000	0.0000;
	1923	1	0.918	0	0	0	1	1.0884422	29.132299	110	3	1.12	0.95	100.6843	0.2738	0.0000	0.0000;
	1924	1	0	0	0	0	1	1.0884422	29.132299	110	3	1.12	0.95	100.6843	0.2738	0.0000	0.0000;
	1925	1	0	0	0	0	1	1.0884449	29.132703	110	3	1.12	0.95	100.6838	0.2738	0.0000	0.0000;
	1926	2	11.933	3.639	0	0	1	1.0753182	27.768977	110	3	1.12	0.95	102.3390	0.8780	0.0000	0.0000;
	1927	1	11.605	2.47	0	0	1	1.0677545	26.964173	110	3	1.12	0.95	103.7068	1.0137	0.0000	0.0000;
	1928	2	4.125	5	0	0	1	1.12	29.102163	110	4	1.12	0.95	100.2264	0.0000	117.3558	0.0000;
	1929	2	7.53	5.9	0	0	1	1.12	29.094278	110	4	1.12	0.95	100.2363	0.0000	118.2403	0.0000;
	1930	1	15.357	6.21	0	0	1	1.1130731	28.798417	110	4	1.12	0.95	100.9989	0.2846	0.0000	0.0000;
	1931	1	16.246	5.5	0	0	1	1.1137221	28.824788	110	4	1.12	0.95	100.9295	0.2567	0.0000	0.0000;
	1932	1	12.954	2.239	0	0	1	1.10406	15.783266	110	4	1.12	0.95	108.3976	0.3119	0.0000	0.0000;
	1933	1	7.229	2.249	0	0	1	1.0892634	20.288727	110	4	1.12	0.95	106.4446	0.6848	0.0000	0.0000;
	1934	1	5.451	-0.734	0	0	1	1.0870684	15.066091	110	4	1.12	0.95	109.7003	0.4479	0.0000	0.0000;
	1935	1	0	0	0	0	1	1.1044062	27.68215	110	4	1.12	0.95	102.3049	0.3284	0.0000	0.0000;
	1936	1	7.363	0.974	0	0	1	1.119273	23.651302	110	4	1.12	0.95	100.4806	-3.5483	0.0000	0.0000;
	1937	1	0	0	0	0	1	1.119273	23.651302	110	4	1.12	0.95	100.4806	-3.5483	0.0000	0.0000;
	1938	1	4.864	0.044	0	0	1	1.0944584	13.129318	110	4	1.12	0.95	111.5281	0.4250	0.0000	0.0000;
	1939	1	20.943	4.136	0	0	1	1.0965023	21.8467	110	4	1.12	0.95	102.3212	-1.1040	0.0000	0.0000;
	1940	1	13.706	2.223	0	0	1	1.1020563	11.437127	110	4	1.12	0.95	111.4783	0.3182	0.0000	0.0000;
	1941	1	6.33	-0.987	0	0	1	1.0958187	14.88287	110	4	1.12	0.95	109.2919	0.3554	0.0000	0.0000;
	1942	1	0	0	0	0	1	1.0957928	14.87465	110	4	1.12	0.95	109.2920	0.3534	0.0000	0.0000;
	1943	1	5.599	0.581	0	0	1	1.0952728	12.726595	110	4	1.12	0.95	111.4110	0.2755	0.0000	0.0000;
	1944	2	5.703	-0.241	0	0	1	1.1068136	26.776558	110	4	1.12	0.95	100.4230	-0.0805	0.0000	0.0000;
	1945	1	5.161	0.644	0	0	1	1.106843	26.76861	110	4	1.12	0.95	100.4189	-0.0801	0.0000	0.0000;
	1946	1	5.449	1.279	0	0	1	1.1066686	26.539757	110	4	1.12	0.95	100.4235	-0.0629	0.0000	0.0000;
	1947	2	11.301	2.343	0	0	1	1.1163112	23.277468	110	4	1.12	0.95	100.4392	-4.4066	0.0000	0.0000;
	1948	1	3.684	0.527	0	0	1	1.1163046	23.276089	110	4	1.12	0.95	100.4395	-4.4066	0.0000	0.0000;
	1949	1	11.188	2.652	0	0	1	1.0929697	14.635585	110	4	1.12	0.95	109.6574	0.4941	0.0000	0.0000;
	1950	1	4.42	0.335	0	0	1	1.1193987	23.763904	110	4	1.12	0.95	100.5558	-3.1532	0.0000	0.0000;
	1951	1	3.684	0.425	0	0	1	1.1197042	23.672301	110	4	1.12	0.95	100.7030	-2.6164	0.0000	0.0000;
	1952	1	7.36	1.477	0	0	1	1.0674001	14.760287	110	4	1.12	0.95	110.9147	1.7514	0.0000	0.0000;
	1953	1	4.715	0.15	0	0	1	1.0739663	17.244272	110	4	1.12	0.95	107.4716	0.8651	0.0000	0.0000;
	1954	1	1.035	-1.132	0	0	1	1.0751689	13.890585	110	4	1.12	0.95	111.3493	0.4072	0.0000	0.0000;
	1955	1	7.222	0.806	0	0	1	1.0819996	17.589697	110	4	1.12	0.95	107.0641	0.8677	0.0000	0.0000;
	1956	1	0.705	-0.023	0	0	1	1.1059027	16.534363	110	4	1.12	0.95	106.9922	0.3630	0.0000	0.0000;
	1957	2	4.706	0.006	0	0	1	1.1094673	28.331896	110	4	1.12	0.95	99.5758	-0.0267	0.0000	0.0000;
	1958	1	4.42	0.121	0	0	1	1.1168377	23.791729	110	4	1.12	0.95	101.0298	-1.9749	0.0000	0.0000;
	1959	1	0	0	0	0	1	1.1195112	15.07051	110	4	1.12	0.95	108.5129	0.0037	0.0000	0.0000;
	1960	1	7.95	0.7	0	0	1	1.0968612	14.28691	110	4	1.12	0.95	109.8675	0.1877	0.0000	0.0000;
	1961	1	4.021	-1.258	0	0	1	1.0726807	16.491854	110	4	1.12	0.95	108.7186	0.5260	0.0000	0.0000;
	1962	2	6.039	0.894	0	0	1	1.1138587	22.952471	110	4	1.12	0.95	101.2909	-4.1844	0.0000	0.0000;
	1963	1	0	0	0	0	1	1.1138587	22.952471	110	4	1.12	0.95	101.2909	-4.1844	0.0000	0.0000;
	1964	2	5.743	3	0	0	1	1.0939653	21.96921	110	4	1.12	0.95	102.3845	-0.5331	0.0000	0.0000;
	1965	2	0	0	0	0	1	1.094299	22.293979	110	4	1.12	0.95	102.0915	-0.3480	0.0000	0.0000;
	1966	1	2.934	0.107	0	0	1	1.1061418	27.090266	110	4	1.12	0.95	102.4462	0.2588	0.0000	0.0000;
	1967	1	14.281	-0.092	0	0	1	1.0735345	12.867623	110	4	1.12	0.95	111.3057	0.3232	0.0000	0.0000;
	1968	1	5.161	-0.032	0	0	1	1.1052742	13.807692	110	4	1.12	0.95	110.2515	0.1935	0.0000	0.0000;
	1969	1	4.431	2.199	0	0	1	1.097622	20.908865	110	4	1.12	0.95	103.5421	0.0795	0.0000	0.0000;
	1970	1	6.194	-0.116	0	0	1	1.107217	11.137006	110	4	1.12	0.95	111.4671	-0.0191	0.0000	0.0000;
	1971	1	2.653	0.607	0	0	1	1.0795311	19.012547	110	4	1.12	0.95	115.6084	6.2309	0.0000	0.0000;
	1972	1	6.336	0.645	0	0	1	1.1010086	24.228931	110	4	1.12	0.95	101.2275	0.0502	0.0000	0.0000;
	1973	1	1.178	-2.1	0	0	1	1.0955758	15.026959	110	4	1.12	0.95	109.2909	0.4808	0.0000	0.0000;
	1974	1	0	0	0	0	1	1.1179142	23.985467	110	4	1.12	0.95	100.7808	-1.9478	0.0000	0.0000;
	1975	1	0	0	0	0	1	1.1179142	23.985467	110	4	1.12	0.95	100.7808	-1.9478	0.0000	0.0000;
	1976	1	0	0	0	0	1	1.1016272	21.106309	110	4	1.12	0.95	103.0377	-0.0680	0.0000	0.0000;
	1977	1	0	0	0	0	1	1.0874814	21.536782	110	4	1.12	0.95	103.7085	0.1653	0.0000	0.0000;
	1978	1	2.503	0.088	0	0	1	1.1095058	27.109056	110	4	1.12	0.95	100.0722	-0.1105	0.0000	0.0000;
	1979	1	5.307	0.248	0	0	1	1.0902668	10.733394	110	4	1.12	0.95	113.4150	0.1273	0.0000	0.0000;
	1980	1	13.544	1.781	0	0	1	1.0989082	15.154329	110	4	1.12	0.95	109.1941	0.3621	0.0000	0.0000;
	1981	1	1.653	0.65	0	0	1	1.0952488	14.941181	110	4	1.12	0.95	109.9875	0.4104	0.0000	0.0000;
	1982	1	7.656	-1.155	0	0	1	1.0986718	15.332122	110	4	1.12	0.95	108.8590	0.4123	0.0000	0.0000;
	1983	1	2.295	0.576	0	0	1	1.0988019	15.332048	110	4	1.12	0.95	108.8645	0.4103	0.0000	0.0000;
	1984	1	10.6	0.984	0	0	1	1.0712597	11.644733	110	4	1.12	0.95	113.1446	0.4151	0.0000	0.0000;
	1985	1	10.911	1.755	0	0	1	1.1020984	11.948613	110	4	1.12	0.95	111.4934	0.4089	0.0000	0.0000;
	1986	1	3.449	0.356	0	0	1	1.1046546	15.904791	110	4	1.12	0.95	107.5025	0.3664	0.0000	0.0000;
	1987	1	4.954	1.194	0	0	1	1.0881417	24.125526	110	4	1.12	0.95	105.5811	0.4779	0.0000	0.0000;
	1988	1	3.243	0.057	0	0	1	1.0872848	11.134315	110	4	1.12	0.95	113.2401	0.0360	0.0000	0.0000;
	1989	1	5.893	-0.154	0	0	1	1.0871772	12.69473	110	4	1.12	0.95	112.1805	0.5598	0.0000	0.0000;
	1990	1	7.235	2.312	0	0	1	1.0924635	10.815324	110	4	1.12	0.95	113.1150	0.2009	0.0000	0.0000;
	1991	2	17.022	7.9	0	0	1	1.1196024	15.097943	110	4	1.12	0.95	108.5046	0.0000	0.0000	0.0000;
	1992	1	0	0	0	0	1	1.1196024	15.097943	110	4	1.12	0.95	108.5046	-0.0000	0.0000	0.0000;
	1993	1	2.574	0.076	0	0	1	1.0895616	12.143589	110	4	1.12	0.95	111.8699	0.1988	0.0000	0.0000;
	1994	1	2.141	0.07	0	0	1	1.0895595	12.142737	110	4	1.12	0.95	111.8702	0.1988	0.0000	0.0000;
	1995	1	9.568	-0.514	0	0	1	1.0868706	11.697115	110	4	1.12	0.95	112.5392	0.1318	0.0000	0.0000;
	1996	1	2.949	-0.02	0	0	1	1.11141	22.573395	110	4	1.12	0.95	101.9791	-4.0248	0.0000	0.0000;
	1997	2	0.265	0.162	0	0	1	1.10639	16.481032	110	4	1.12	0.95	107.8709	0.1322	0.0000	0.0000;
	1998	1	0	0	0	0	1	1.10639	16.481032	110	4	1.12	0.95	107.8709	0.1322	0.0000	0.0000;
	1999	1	6.339	1.307	0	0	1	1.1156011	22.894734	110	4	1.12	0.95	101.4423	-2.6797	0.0000	0.0000;
	2000	1	5.601	0.979	0	0	1	1.1165152	23.310399	110	4	1.12	0.95	100.4084	-4.4196	0.0000	0.0000;
	2001	2	5.16	4.081	0	0	1	1.105135	15.611217	110	4	1.12	0.95	108.6511	0.1971	0.0000	0.0000;
	2002	2	13.25	8	0	0	1	1.0950981	14.98196	110	4	1.12	0.95	109.3493	0.4930	0.0000	0.0000;
	2003	1	6.19	1.405	0	0	1	1.0878103	15.002956	110	4	1.12	0.95	109.1917	0.6139	0.0000	0.0000;
	2004	1	0	0	0	0	1	1.0956564	9.4355303	110	4	1.12	0.95	113.2427	0.5219	0.0000	0.0000;
	2005	1	5.157	0.9	0	0	1	1.0985659	15.140623	110	4	1.12	0.95	108.9819	0.3316	0.0000	0.0000;
	2006	1	4.419	1.2	0	0	1	1.0854818	14.860996	110	4	1.12	0.95	110.3243	0.9224	0.0000	0.0000;
	2007	2	4.917	1.668	0	0	1	1.0498274	6.1681069	110	4	1.12	0.95	121.3498	2.1519	0.0000	0.0000;
	2008	1	5.153	1.2	0	0	1	1.1024586	11.509871	110	4	1.12	0.95	111.2400	0.3327	0.0000	0.0000;
	2009	1	0	0	0	0	1	1.1024247	11.491284	110	4	1.12	0.95	111.2494	0.3332	0.0000	0.0000;
	2010	1	8.097	1.412	0	0	1	1.0860897	15.628786	110	4	1.12	0.95	108.4295	0.7099	0.0000	0.0000;
	2011	1	11.05	2.511	0	0	1	1.0845893	15.106818	110	4	1.12	0.95	109.0607	0.6939	0.0000	0.0000;
	2012	1	10.167	1.832	0	0	1	1.08463	15.09311	110	4	1.12	0.95	109.0676	0.6949	0.0000	0.0000;
	2013	1	6.477	-0.9	0	0	1	1.074935	15.79027	110	4	1.12	0.95	109.7412	1.2024	0.0000	0.0000;
	2014	2	33.273	8	0	0	1	1.1008841	14.06984	110	4	1.12	0.95	109.2413	0.3357	0.0000	0.0000;
	2015	2	2.355	0	0	0	1	1.1009452	14.020301	110	4	1.12	0.95	109.1896	0.3436	0.0000	0.0000;
	2016	1	6.931	0.161	0	0	1	1.0750276	9.7616837	110	4	1.12	0.95	116.6522	1.1152	0.0000	0.0000;
	2017	1	4.127	0.585	0	0	1	1.0992336	13.907497	110	4	1.12	0.95	109.4504	0.3854	0.0000	0.0000;
	2018	1	4.422	1.404	0	0	1	1.0992169	13.904143	110	4	1.12	0.95	109.4514	0.3855	0.0000	0.0000;
	2019	1	6.941	1.068	0	0	1	1.0946615	20.276505	110	4	1.12	0.95	103.6430	0.0777	0.0000	0.0000;
	2020	1	11.337	-1.154	0	0	1	1.0965792	13.742767	110	4	1.12	0.95	110.4324	0.0502	0.0000	0.0000;
	2021	1	4.426	1.166	0	0	1	1.0967856	20.82756	110	4	1.12	0.95	103.6349	0.0990	0.0000	0.0000;
	2022	1	11.799	3.39	0	0	1	1.1146966	14.345112	110	4	1.12	0.95	109.2259	0.1381	0.0000	0.0000;
	2023	1	3.389	0.271	0	0	1	1.1171205	23.317253	110	4	1.12	0.95	100.9571	-3.4519	0.0000	0.0000;
	2024	1	0	0	0	0	1	1.1171205	23.317253	110	4	1.12	0.95	100.9571	-3.4519	0.0000	0.0000;
	2025	1	8.843	1.23	0	0	1	1.098939	13.879002	110	4	1.12	0.95	109.4997	0.3863	0.0000	0.0000;
	2026	1	6.19	1.177	0	0	1	1.0991612	13.891269	110	4	1.12	0.95	109.4647	0.3790	0.0000	0.0000;
	2027	1	25.912	6.029	0	0	1	1.0696302	15.948845	110	4	1.12	0.95	109.5540	1.3580	0.0000	0.0000;
	2028	1	4.407	-1.342	0	0	1	1.0958252	15.663698	110	4	1.12	0.95	109.2286	0.2794	0.0000	0.0000;
	2029	1	16.23	2.02	0	0	1	1.0999064	11.248753	110	4	1.12	0.95	111.8014	0.3642	0.0000	0.0000;
	2030	1	2.949	0.67	0	0	1	1.1001885	13.970946	110	4	1.12	0.95	109.3045	0.3626	0.0000	0.0000;
	2031	1	3.243	0.977	0	0	1	1.0792868	12.535318	110	4	1.12	0.95	113.0132	0.8914	0.0000	0.0000;
	2032	1	0.3	0.139	0	0	1	1.0937964	19.289429	110	4	1.12	0.95	104.6722	0.3835	0.0000	0.0000;
	2033	1	0	0	0	0	1	1.0937916	19.276039	110	4	1.12	0.95	104.6744	0.3871	0.0000	0.0000;
	2034	1	4.565	0.172	0	0	1	1.032759	15.401447	110	4	1.12	0.95	114.4080	6.0188	0.0000	0.0000;
	2035	2	22.929	0.449	0	0	1	1.0828206	17.532844	110	4	1.12	0.95	107.1041	0.7838	0.0000	0.0000;
	2036	1	0.042	0.22	0	0	1	1.0746027	17.318343	110	4	1.12	0.95	107.3379	0.8664	0.0000	0.0000;
	2037	1	36.941	12.339	0	0	1	1.071197	17.075002	110	4	1.12	0.95	107.6893	0.9839	0.0000	0.0000;
	2038	1	36.806	17	0	0	1	1.0790559	17.203999	110	4	1.12	0.95	107.5412	0.9880	0.0000	0.0000;
	2039	2	28.988	7.935	0	0	1	1.0901159	21.068076	110	4	1.12	0.95	104.4830	-1.1320	0.0000	0.0000;
	2040	1	0.65	0.14	0	0	1	1.0914616	21.130745	110	4	1.12	0.95	104.3367	-1.1967	0.0000	0.0000;
	2041	2	147.162	55.7	0	0	1	1.1083651	24.348542	110	4	1.12	0.95	103.5161	0.0000	0.0000	0.0000;
	2042	1	0	0	0	0	1	1.1083651	24.348542	110	4	1.12	0.95	103.5161	-0.0000	0.0000	0.0000;
	2043	1	0.737	0.251	0	0	1	1.0957732	23.259543	110	4	1.12	0.95	100.7888	-0.2701	0.0000	0.0000;
	2044	1	3.243	0.77	0	0	1	1.0958614	21.829107	110	4	1.12	0.95	102.4642	-0.7875	0.0000	0.0000;
	2045	1	9.568	3.382	0	0	1	1.0920683	16.156145	110	4	1.12	0.95	108.4268	1.0969	0.0000	0.0000;
	2046	2	6.327	0.3	0	0	1	1.1178978	23.196096	110	4	1.12	0.95	100.8925	-3.2816	0.0000	0.0000;
	2047	1	2.211	0.301	0	0	1	1.117894	23.19527	110	4	1.12	0.95	100.8927	-3.2816	0.0000	0.0000;
	2048	1	9.005	0.511	0	0	1	1.0735331	14.241193	110	4	1.12	0.95	111.0583	0.5107	0.0000	0.0000;
	2049	1	10.319	1.536	0	0	1	1.100707	14.00489	110	4	1.12	0.95	109.3004	0.3434	0.0000	0.0000;
	2050	1	6.63	1.443	0	0	1	1.0736697	32.042448	110	4	1.12	0.95	102.9102	0.2894	0.0000	0.0000;
	2051	1	3.828	0.756	0	0	1	1.1171428	23.83211	110	4	1.12	0.95	100.8999	-2.1060	0.0000	0.0000;
	2052	1	12.073	1.954	0	0	1	1.0956104	14.846658	110	4	1.12	0.95	109.3342	0.4113	0.0000	0.0000;
	2053	1	30.391	8.953	0	0	1	1.109506	20.959861	110	4	1.12	0.95	102.4283	0.2030	0.0000	0.0000;
	2054	1	11.249	2.878	0	0	1	1.0840549	19.135177	110	4	1.12	0.95	105.7906	0.4890	0.0000	0.0000;
	2055	1	7.964	0.241	0	0	1	1.0848358	19.145794	110	4	1.12	0.95	105.7053	0.4721	0.0000	0.0000;
	2056	2	3.488	1.226	0	0	1	1.0636159	11.950398	110	4	1.12	0.95	112.9582	0.3611	0.0000	0.0000;
	2057	1	0	0	0	0	1	1.1143484	28.652333	110	4	1.12	0.95	100.9046	0.1373	0.0000	0.0000;
	2058	1	5.455	3.321	0	0	1	1.0979343	21.831816	110	4	1.12	0.95	103.5178	-1.5998	0.0000	0.0000;
	2059	1	4.422	1.463	0	0	1	1.1173411	23.882352	110	4	1.12	0.95	100.8597	-2.0332	0.0000	0.0000;
	2060	1	4.13	0.137	0	0	1	1.1173904	23.927996	110	4	1.12	0.95	100.8525	-1.9424	0.0000	0.0000;
	2061	1	8.835	-0.758	0	0	1	1.0924755	24.888453	110	4	1.12	0.95	104.8434	0.4195	0.0000	0.0000;
	2062	1	5.304	2.599	0	0	1	1.1171181	23.646887	110	4	1.12	0.95	100.9617	-2.5008	0.0000	0.0000;
	2063	2	10.315	3	0	0	1	1.0939518	25.189073	110	4	1.12	0.95	104.5612	0.4104	0.0000	0.0000;
	2064	1	10.676	3.342	0	0	1	1.0991066	20.665664	110	4	1.12	0.95	103.1452	0.1413	0.0000	0.0000;
	2065	1	14.593	1.291	0	0	1	1.0885672	24.163898	110	4	1.12	0.95	105.5340	0.4667	0.0000	0.0000;
	2066	1	0	0	0	0	1	1.1151573	21.238824	110	4	1.12	0.95	101.7407	-0.0013	0.0000	0.0000;
	2067	1	13.84	4.33	0	0	1	1.0830516	15.572729	110	4	1.12	0.95	109.6170	1.2558	0.0000	0.0000;
	2068	1	11.79	3.7	0	0	1	1.1000282	19.258839	110	4	1.12	0.95	104.2938	0.5142	0.0000	0.0000;
	2069	1	11.496	4.714	0	0	1	1.1133069	26.747853	110	4	1.12	0.95	101.7025	0.2765	0.0000	0.0000;
	2070	2	4.706	-0.077	0	0	1	1.1130824	22.80476	110	4	1.12	0.95	101.5869	-3.9567	0.0000	0.0000;
	2071	1	6.193	1.002	0	0	1	1.1130737	22.8015	110	4	1.12	0.95	101.5884	-3.9599	0.0000	0.0000;
	2072	1	15.753	3.447	0	0	1	1.0887497	14.222256	110	4	1.12	0.95	110.3105	0.5448	0.0000	0.0000;
	2073	1	7.081	0.549	0	0	1	1.0908138	20.121639	110	4	1.12	0.95	104.0407	-0.0341	0.0000	0.0000;
	2074	1	7.067	0.6	0	0	1	1.0841411	30.542764	110	4	1.12	0.95	102.6201	-0.1139	0.0000	0.0000;
	2075	1	5.424	-0.362	0	0	1	1.0717763	15.053219	110	4	1.12	0.95	110.6208	0.2131	0.0000	0.0000;
	2076	1	0	0	0	0	1	1.0942196	23.143443	110	4	1.12	0.95	101.0336	-0.3047	0.0000	0.0000;
	2077	1	0	0	0	0	1	1.0968324	21.871848	110	4	1.12	0.95	102.2725	-0.9635	0.0000	0.0000;
	2078	1	0	0	0	0	1	1.0665734	18.561476	110	4	1.12	0.95	106.8266	0.9895	0.0000	0.0000;
	2079	1	22.589	5.834	0	0	1	1.0683629	17.424344	110	4	1.12	0.95	107.4561	1.1824	0.0000	0.0000;
	2080	1	23.633	9.158	0	0	1	1.0705187	19.543723	110	4	1.12	0.95	105.8915	0.8146	0.0000	0.0000;
	2081	1	10.166	2.45	0	0	1	1.0846961	19.218388	110	4	1.12	0.95	105.2650	0.5975	0.0000	0.0000;
	2082	1	6.924	0.905	0	0	1	1.1000543	27.215395	110	4	1.12	0.95	102.9149	0.3951	0.0000	0.0000;
	2083	1	12.388	2.054	0	0	1	1.0678367	19.064575	110	4	1.12	0.95	106.5142	0.9093	0.0000	0.0000;
	2084	1	5.428	1.245	0	0	1	1.0665648	18.561642	110	4	1.12	0.95	106.8266	0.9901	0.0000	0.0000;
	2085	1	5.899	1.355	0	0	1	1.082775	19.077362	110	4	1.12	0.95	105.9599	0.5222	0.0000	0.0000;
	2086	1	10.778	1.282	0	0	1	1.0731343	7.6884464	110	4	1.12	0.95	117.1772	1.3200	0.0000	0.0000;
	2087	1	13.899	3.765	0	0	1	1.1069329	16.666763	110	4	1.12	0.95	107.6103	0.2072	0.0000	0.0000;
	2088	1	0	0	0	0	1	1.1134768	26.758835	110	4	1.12	0.95	101.6894	0.2711	0.0000	0.0000;
	2089	1	9.726	3.412	0	0	1	1.1080851	28.099478	110	4	1.12	0.95	101.7493	0.2815	0.0000	0.0000;
	2090	2	0	0	0	0	1	1.1079355	24.360184	110	4	1.12	0.95	103.5340	0.0101	0.0000	0.0000;
	2091	2	4.029	0	0	0	1	1.1127503	20.847659	110	4	1.12	0.95	101.7193	0.0000	0.0000	0.0000;
	2092	1	0	0	0	0	1	1.1079274	24.408921	110	4	1.12	0.95	103.4681	0.0143	0.0000	0.0000;
	2093	2	2.241	0	0	0	1	1.038916	27.546797	15	4	1.12	0.95	102.2450	0.0000	0.0000	0.0000;
	2094	1	2.508	0.555	0	0	1	1.0860092	19.427741	110	4	1.12	0.95	105.4060	0.4553	0.0000	0.0000;
	2095	1	7.073	1.371	0	0	1	1.11629	23.742393	110	4	1.12	0.95	101.0281	-2.2006	0.0000	0.0000;
	2096	2	27.916	8.223	0	0	1	1.0720509	17.724308	110	4	1.12	0.95	106.9975	1.0738	0.0000	0.0000;
	2097	1	22.147	9.028	0	0	1	1.0720837	17.731529	110	4	1.12	0.95	106.9840	1.0777	0.0000	0.0000;
	2098	1	22.145	3.835	0	0	1	1.068667	19.121143	110	4	1.12	0.95	106.3807	0.8894	0.0000	0.0000;
	2099	1	14.723	2	0	0	1	1.0688602	19.06886	110	4	1.12	0.95	106.3631	0.8892	0.0000	0.0000;
	2100	1	0.737	0.002	0	0	1	1.1016161	27.372332	110	4	1.12	0.95	102.7056	0.3680	0.0000	0.0000;
	2101	1	4.424	7.133	0	0	1	1.067847	18.68832	110	4	1.12	0.95	106.6532	0.9689	0.0000	0.0000;
	2102	1	3.608	1.072	0	0	1	1.0678145	18.707046	110	4	1.12	0.95	106.6541	0.9642	0.0000	0.0000;
	2103	1	0	0	0	0	1	1.12	15.190534	110	4	1.12	0.95	108.4912	-0.0210	349.9496	0.0000;
	2104	1	1.326	0.81	0	0	1	1.0786866	18.432799	110	4	1.12	0.95	106.1268	0.8297	0.0000	0.0000;
	2105	1	0	0	0	0	1	1.1057264	25.888562	110	4	1.12	0.95	100.5329	-0.0368	0.0000	0.0000;
	2106	1	0	0	0	0	1	1.1056923	25.903042	110	4	1.12	0.95	100.5405	-0.0371	0.0000	0.0000;
	2107	1	14.005	7.101	0	0	1	1.0732439	17.80581	110	4	1.12	0.95	106.8293	1.0279	0.0000	0.0000;
	2108	1	8.845	16.992	0	0	1	1.0681052	19.157808	110	4	1.12	0.95	106.3149	0.9509	0.0000	0.0000;
	2109	1	5.161	0.081	0	0	1	1.0749403	17.919143	110	4	1.12	0.95	106.6610	0.9616	0.0000	0.0000;
	2110	1	0.294	1.841	0	0	1	1.0731632	19.688681	110	4	1.12	0.95	105.6641	0.7396	0.0000	0.0000;
	2111	1	0.294	0	0	0	1	1.0732526	19.712757	110	4	1.12	0.95	105.6567	0.7350	0.0000	0.0000;
	2112	1	17.711	5.131	0	0	1	1.0756104	18.007759	110	4	1.12	0.95	106.5940	0.9432	0.0000	0.0000;
	2113	1	3.279	1.164	0	0	1	1.0756395	17.996149	110	4	1.12	0.95	106.5970	0.9457	0.0000	0.0000;
	2114	1	2.503	4.356	0	0	1	1.0731084	17.813936	110	4	1.12	0.95	106.8546	1.0405	0.0000	0.0000;
	2115	1	0	2.547	0	0	1	1.0691413	19.169518	110	4	1.12	0.95	106.2732	0.8840	0.0000	0.0000;
	2116	1	16.207	2.015	0	0	1	1.0708757	17.621593	110	4	1.12	0.95	107.2983	0.9405	0.0000	0.0000;
	2117	1	7.97	1.941	0	0	1	1.1044923	27.883398	110	4	1.12	0.95	102.0805	0.3775	0.0000	0.0000;
	2118	2	40.491	10.185	0	0	1	1.0751754	12.203609	110	4	1.12	0.95	113.7556	1.0447	0.0000	0.0000;
	2119	1	1.62	0.279	0	0	1	1.0727129	17.523905	110	4	1.12	0.95	107.1428	1.0032	0.0000	0.0000;
	2120	1	5.412	3.596	0	0	1	1.0727321	17.518501	110	4	1.12	0.95	107.1450	1.0034	0.0000	0.0000;
	2121	1	7.664	2.163	0	0	1	1.068687	18.200667	110	4	1.12	0.95	106.9534	0.9820	0.0000	0.0000;
	2122	1	7.888	1.925	0	0	1	1.0717767	17.65219	110	4	1.12	0.95	107.0192	1.0658	0.0000	0.0000;
	2123	1	5.899	2.206	0	0	1	1.0806152	18.752994	110	4	1.12	0.95	106.4164	0.6505	0.0000	0.0000;
	2124	1	5.602	0.095	0	0	1	1.0826709	19.165314	110	4	1.12	0.95	105.9601	0.5363	0.0000	0.0000;
	2125	1	11.483	2.542	0	0	1	1.0939208	14.698687	110	4	1.12	0.95	109.5419	0.4598	0.0000	0.0000;
	2126	1	9.584	3.353	0	0	1	1.0828062	19.184213	110	4	1.12	0.95	105.9301	0.5389	0.0000	0.0000;
	2127	1	0	0	0	0	1	1.1107254	22.491227	110	4	1.12	0.95	102.1213	-4.0398	0.0000	0.0000;
	2128	1	3.687	-0.1	0	0	1	1.1107234	22.489808	110	4	1.12	0.95	102.1216	-4.0398	0.0000	0.0000;
	2129	1	10.92	5.227	0	0	1	1.0829595	21.259225	110	4	1.12	0.95	104.0554	0.3223	0.0000	0.0000;
	2130	1	7.233	2.847	0	0	1	1.072918	19.715484	110	4	1.12	0.95	105.5202	0.7199	0.0000	0.0000;
	2131	1	2.062	0.164	0	0	1	1.0910089	20.917385	110	4	1.12	0.95	104.6994	-1.3734	0.0000	0.0000;
	2132	1	8.264	1.805	0	0	1	1.0913813	22.977342	110	4	1.12	0.95	101.4380	-0.2307	0.0000	0.0000;
	2133	1	4.718	1.226	0	0	1	1.1065659	27.937592	110	4	1.12	0.95	101.9695	0.3047	0.0000	0.0000;
	2134	1	0	0	0	0	1	1.119124	23.567501	110	4	1.12	0.95	100.0263	-4.5038	0.0000	0.0000;
	2135	1	5.159	0.849	0	0	1	1.1191139	23.565582	110	4	1.12	0.95	100.0267	-4.5037	0.0000	0.0000;
	2136	1	4.418	0.268	0	0	1	1.0884936	10.809942	110	4	1.12	0.95	113.5026	0.0679	0.0000	0.0000;
	2137	1	11.206	2.771	0	0	1	1.0875812	24.075231	110	4	1.12	0.95	105.6424	0.4928	0.0000	0.0000;
	2138	1	0	0	0	0	1	1.0999083	20.736918	110	4	1.12	0.95	103.0355	0.1246	0.0000	0.0000;
	2139	1	2.503	-0.192	0	0	1	1.1022996	11.464358	110	4	1.12	0.95	111.3261	0.3266	0.0000	0.0000;
	2140	2	2.792	1.222	0	0	1	1.1090701	27.205067	110	4	1.12	0.95	100.0278	-0.0426	0.0000	0.0000;
	2141	1	2.212	0.145	0	0	1	1.1169516	23.615749	110	4	1.12	0.95	100.9911	-2.5016	0.0000	0.0000;
	2142	1	11.795	4.197	0	0	1	1.0939072	22.035465	110	4	1.12	0.95	105.4450	0.5136	0.0000	0.0000;
	2143	1	4.419	-0.011	0	0	1	1.1147818	23.169198	110	4	1.12	0.95	101.0964	-4.3447	0.0000	0.0000;
	2144	1	0	0	0	0	1	1.1147818	23.169198	110	4	1.12	0.95	101.0964	-4.3447	0.0000	0.0000;
	2145	1	16.635	-0.688	0	0	1	1.0773691	15.778195	110	4	1.12	0.95	109.6189	1.4643	0.0000	0.0000;
	2146	1	0	0	0	0	1	1.0773691	15.778195	110	4	1.12	0.95	109.6189	1.4643	0.0000	0.0000;
	2147	1	14.593	0.408	0	0	1	1.0871874	20.910166	110	4	1.12	0.95	104.6289	-0.5334	0.0000	0.0000;
	2148	1	13.644	3.988	0	0	1	1.0854348	20.795895	110	4	1.12	0.95	104.7808	-0.9321	0.0000	0.0000;
	2149	2	0	0	0	0	1	1.0886143	21.059607	110	4	1.12	0.95	104.5122	-0.6545	0.0000	0.0000;
	2150	1	10.904	0.254	0	0	1	1.089034	21.038785	110	4	1.12	0.95	104.5481	-0.8373	0.0000	0.0000;
	2151	1	12.375	0.755	0	0	1	1.0754484	15.558576	110	4	1.12	0.95	109.8920	1.5117	0.0000	0.0000;
	2152	1	2.608	0.289	0	0	1	1.1065824	12.213048	110	4	1.12	0.95	111.0702	0.2139	0.0000	0.0000;
	2153	1	0	0	0	0	1	1.1154361	17.668161	110	4	1.12	0.95	105.8243	0.2254	0.0000	0.0000;
	2154	1	0	0	0	0	1	1.1072515	17.346884	110	4	1.12	0.95	106.3450	0.3684	0.0000	0.0000;
	2155	1	1.03	0	0	0	1	1.0876738	14.960946	110	4	1.12	0.95	109.9589	0.7939	0.0000	0.0000;
	2156	1	1.473	0.362	0	0	1	1.0896085	19.368416	110	4	1.12	0.95	105.0403	0.3801	0.0000	0.0000;
	2157	1	5.744	-0.2	0	0	1	1.0957847	13.393681	110	4	1.12	0.95	110.3912	0.3839	0.0000	0.0000;
	2158	1	4.566	0.752	0	0	1	1.1008298	14.32083	110	4	1.12	0.95	109.0512	0.3457	0.0000	0.0000;
	2159	1	8.424	-2.509	0	0	1	1.1116799	17.110386	110	4	1.12	0.95	106.6889	0.0146	0.0000	0.0000;
	2160	1	4.127	0.126	0	0	1	1.1066809	26.379159	110	4	1.12	0.95	100.4243	-0.0466	0.0000	0.0000;
	2161	1	3.682	0.167	0	0	1	1.1173742	23.676906	110	4	1.12	0.95	100.9076	-2.5948	0.0000	0.0000;
	2162	1	5.758	-0.143	0	0	1	1.1046956	10.506467	110	4	1.12	0.95	111.5572	0.2601	0.0000	0.0000;
	2163	1	6.335	0.858	0	0	1	1.1178898	23.541724	110	4	1.12	0.95	100.8003	-3.2673	0.0000	0.0000;
	2164	1	6.33	74.351	0	0	1	0.9994085	16.969898	110	4	1.12	0.95	115.7045	12.0228	0.0000	0.0000;
	2165	1	3.831	1.005	0	0	1	1.1015936	11.289404	110	4	1.12	0.95	111.5256	0.2953	0.0000	0.0000;
	2166	1	1.032	0.361	0	0	1	1.0547882	8.1658159	110	4	1.12	0.95	120.7690	1.6019	0.0000	0.0000;
	2167	1	3.986	0.158	0	0	1	1.0845201	12.22689	110	4	1.12	0.95	112.6606	0.1092	0.0000	0.0000;
	2168	1	9.138	-0.873	0	0	1	1.0905854	12.491132	110	4	1.12	0.95	111.6040	0.1381	0.0000	0.0000;
	2169	1	1.767	0.658	0	0	1	1.1171042	23.717537	110	4	1.12	0.95	100.9328	-2.4214	0.0000	0.0000;
	2170	1	1.915	0.166	0	0	1	1.1138323	28.086134	110	4	1.12	0.95	99.3078	-0.0824	0.0000	0.0000;
	2171	1	4.42	0.672	0	0	1	1.110329	28.480798	110	4	1.12	0.95	99.3772	-0.0094	0.0000	0.0000;
	2172	1	6.626	0.537	0	0	1	1.0540432	11.032706	110	4	1.12	0.95	114.7274	0.4865	0.0000	0.0000;
	2173	1	1.178	0.207	0	0	1	1.1132895	13.842185	110	4	1.12	0.95	109.4819	-0.1537	0.0000	0.0000;
	2174	1	9.284	1.586	0	0	1	1.0872553	20.216965	110	4	1.12	0.95	104.6285	0.2943	0.0000	0.0000;
	2175	2	3.426	0.047	0	0	1	1.0937702	22.016544	110	4	1.12	0.95	102.4341	-0.3368	0.0000	0.0000;
	2176	1	2.141	0.046	0	0	1	1.073523	32.02897	110	4	1.12	0.95	102.9391	0.2890	0.0000	0.0000;
	2177	1	9.733	1.792	0	0	1	1.1069993	12.304651	110	4	1.12	0.95	110.9624	0.2210	0.0000	0.0000;
	2178	1	4.274	0.998	0	0	1	1.1094523	11.767662	110	4	1.12	0.95	110.6034	0.1312	0.0000	0.0000;
	2179	1	10.748	3.02	0	0	1	1.0995364	16.595728	110	4	1.12	0.95	107.4654	0.9035	0.0000	0.0000;
	2180	1	3.094	0.829	0	0	1	1.0954211	12.613791	110	4	1.12	0.95	111.5396	0.2719	0.0000	0.0000;
	2181	1	5.159	0.435	0	0	1	1.0951175	12.788993	110	4	1.12	0.95	111.2434	0.2709	0.0000	0.0000;
	2182	1	8.991	-1.028	0	0	1	1.0872432	8.3998881	110	4	1.12	0.95	114.9177	0.7321	0.0000	0.0000;
	2183	1	5.888	2.426	0	0	1	1.0947275	14.957469	110	4	1.12	0.95	109.3811	0.5058	0.0000	0.0000;
	2184	1	2.502	0.1	0	0	1	1.10015	15.253144	110	4	1.12	0.95	109.1069	0.3347	0.0000	0.0000;
	2185	1	8.097	3.378	0	0	1	1.0855536	15.044259	110	4	1.12	0.95	110.3418	1.1554	0.0000	0.0000;
	2186	1	10.893	2.376	0	0	1	1.0951482	14.945513	110	4	1.12	0.95	109.3957	0.4794	0.0000	0.0000;
	2187	1	6.784	2.364	0	0	1	1.1086403	20.530917	110	4	1.12	0.95	102.2551	0.0765	0.0000	0.0000;
	2188	1	7.214	1.4	0	0	1	1.0596797	16.010428	110	4	1.12	0.95	113.0492	4.5595	0.0000	0.0000;
	2189	1	2.933	-0.339	0	0	1	1.1154247	17.542637	110	4	1.12	0.95	105.9548	0.1866	0.0000	0.0000;
	2190	1	15.897	3.99	0	0	1	1.0385877	4.9924638	110	4	1.12	0.95	123.0688	2.4991	0.0000	0.0000;
	2191	1	3.389	-0.268	0	0	1	1.1015388	11.38571	110	4	1.12	0.95	111.4691	0.3373	0.0000	0.0000;
	2192	1	5.011	-0.568	0	0	1	1.071059	15.716786	110	4	1.12	0.95	109.9901	0.2168	0.0000	0.0000;
	2193	1	8.401	-1.337	0	0	1	1.0978879	13.808071	110	4	1.12	0.95	110.2753	0.0075	0.0000	0.0000;
	2194	1	7.428	-4.388	0	0	1	1.07115	15.485599	110	4	1.12	0.95	110.2923	0.1382	0.0000	0.0000;
	2195	1	12.692	3.558	0	0	1	1.1075454	24.969825	110	4	1.12	0.95	103.2043	0.1014	0.0000	0.0000;
	2196	1	5.307	-0.156	0	0	1	1.1011632	10.077855	110	4	1.12	0.95	112.2490	0.3340	0.0000	0.0000;
	2197	1	0	0	0	0	1	1.1175726	23.214456	110	4	1.12	0.95	100.7930	-3.7519	0.0000	0.0000;
	2198	1	5.898	0.762	0	0	1	1.1175626	23.212249	110	4	1.12	0.95	100.7934	-3.7519	0.0000	0.0000;
	2199	1	3.532	-0.456	0	0	1	1.0875953	14.224159	110	4	1.12	0.95	110.3946	0.3930	0.0000	0.0000;
	2200	1	6.04	0.562	0	0	1	1.0961606	22.639489	110	4	1.12	0.95	101.8856	-0.2676	0.0000	0.0000;
	2201	1	10.462	1.294	0	0	1	1.0981668	20.772454	110	4	1.12	0.95	103.1124	0.0254	0.0000	0.0000;
	2202	2	2.319	-0.878	0	0	1	1.0640212	11.895651	110	4	1.12	0.95	113.0107	0.3199	0.0000	0.0000;
	2203	2	19.021	3.489	0	0	1	1.0754116	32.235698	110	4	1.12	0.95	102.6627	0.2587	0.0000	0.0000;
	2204	1	16.943	2.804	0	0	1	1.093865	21.46593	110	4	1.12	0.95	102.9948	-0.2603	0.0000	0.0000;
	2205	1	5.598	-0.948	0	0	1	1.0966286	13.90964	110	4	1.12	0.95	110.2633	0.0920	0.0000	0.0000;
	2206	1	4.715	0.912	0	0	1	1.1020252	20.976172	110	4	1.12	0.95	102.7125	0.0943	0.0000	0.0000;
	2207	1	7.958	2.216	0	0	1	1.0990217	20.700457	110	4	1.12	0.95	103.2233	0.1363	0.0000	0.0000;
	2208	2	22.344	-2.715	0	0	1	1.1007697	20.794298	110	4	1.12	0.95	102.9973	0.0777	0.0000	0.0000;
	2209	1	0	0	0	0	1	1.102409	21.017194	110	4	1.12	0.95	102.6634	0.0881	0.0000	0.0000;
	2210	1	0	0	0	0	1	1.102244	20.989444	110	4	1.12	0.95	102.6815	0.0885	0.0000	0.0000;
	2211	1	13.715	2.715	0	0	1	1.0911147	20.012121	110	4	1.12	0.95	104.0481	0.0554	0.0000	0.0000;
	2212	1	0	0	0	0	1	1.0984246	22.969224	110	4	1.12	0.95	101.4320	-0.2554	0.0000	0.0000;
	2213	1	0	0	0	0	1	1.1018471	22.464229	110	4	1.12	0.95	101.7092	-0.2915	0.0000	0.0000;
	2214	2	4.642	2.8	0	0	1	1.12	27.035979	110	4	1.12	0.95	100.9687	0.0000	362.0717	0.0000;
	2215	2	19.025	12.5	0	0	1	1.1151451	21.239185	110	4	1.12	0.95	101.7407	-0.0000	0.0000	0.0000;
	2216	1	5.894	-2.724	0	0	1	1.0914839	21.126568	110	4	1.12	0.95	104.3296	-1.1912	0.0000	0.0000;
	2217	1	2.458	0.138	0	0	1	1.0914942	21.132919	110	4	1.12	0.95	104.3319	-1.1974	0.0000	0.0000;
	2218	1	1.326	0.06	0	0	1	1.1174631	23.936394	110	4	1.12	0.95	100.8714	-1.9549	0.0000	0.0000;
	2219	1	4.722	0.162	0	0	1	1.1174027	23.931983	110	4	1.12	0.95	100.8690	-1.9476	0.0000	0.0000;
	2220	1	8.254	2.378	0	0	1	1.1029815	24.157327	110	4	1.12	0.95	104.0550	0.1275	0.0000	0.0000;
	2221	1	4.124	0.544	0	0	1	1.1188012	23.408942	110	4	1.12	0.95	100.9367	-2.6728	0.0000	0.0000;
	2222	1	5.307	0.371	0	0	1	1.1187945	23.406948	110	4	1.12	0.95	100.9372	-2.6728	0.0000	0.0000;
	2223	1	6.626	-1.162	0	0	1	1.0753028	17.315075	110	4	1.12	0.95	108.0248	0.9522	0.0000	0.0000;
	2224	1	3.827	1.252	0	0	1	1.0950846	23.259335	110	4	1.12	0.95	100.8920	-0.2515	0.0000	0.0000;
	2225	1	4.592	0.519	0	0	1	1.0950746	23.253334	110	4	1.12	0.95	100.8929	-0.2531	0.0000	0.0000;
	2226	1	2.946	1.015	0	0	1	1.0945934	14.913027	110	4	1.12	0.95	109.4177	0.4987	0.0000	0.0000;
	2227	1	6.927	0.889	0	0	1	1.0935378	14.670496	110	4	1.12	0.95	109.5930	0.4722	0.0000	0.0000;
	2228	2	14.411	1.88	0	0	1	1.0677907	12.305055	110	4	1.12	0.95	111.8907	0.3690	0.0000	0.0000;
	2229	1	6.038	0.406	0	0	1	1.1189923	23.445678	110	4	1.12	0.95	100.8639	-2.6445	0.0000	0.0000;
	2230	1	0	0	0	0	1	1.1189923	23.445678	110	4	1.12	0.95	100.8639	-2.6445	0.0000	0.0000;
	2231	1	10.023	0.602	0	0	1	1.0690438	12.417136	110	4	1.12	0.95	111.6871	0.3423	0.0000	0.0000;
	2232	1	11.924	2.053	0	0	1	1.0954563	14.937992	110	4	1.12	0.95	109.3974	0.4566	0.0000	0.0000;
	2233	1	0	0	0	0	1	1.0713169	12.763658	110	4	1.12	0.95	111.2470	0.3283	0.0000	0.0000;
	2234	1	0	0	0	0	1	1.0727256	12.874402	110	4	1.12	0.95	111.1506	0.2689	0.0000	0.0000;
	2235	2	41.397	5.143	0	0	1	1.0169453	12.604889	110	4	1.12	0.95	110.7010	0.2171	0.0000	0.0000;
	2236	1	19.737	4.557	0	0	1	1.0177809	12.966878	110	4	1.12	0.95	110.6612	0.2121	0.0000	0.0000;
	2237	1	0	0	0	0	1	1.0897194	15.035256	110	4	1.12	0.95	109.5632	0.6298	0.0000	0.0000;
	2238	1	0	0	0	0	1	1.0990056	15.169064	110	4	1.12	0.95	108.9135	0.3206	0.0000	0.0000;
	2239	1	11.814	-3.533	0	0	1	1.0693593	19.16349	110	4	1.12	0.95	106.2760	0.8699	0.0000	0.0000;
	2240	1	2.906	0.23	0	0	1	1.0729884	17.769063	110	4	1.12	0.95	106.8768	1.0338	0.0000	0.0000;
	2241	1	4.718	-1.56	0	0	1	1.1083764	17.096653	110	4	1.12	0.95	106.7469	0.1379	0.0000	0.0000;
	2242	1	9.128	-0.4	0	0	1	1.0728551	17.705395	110	4	1.12	0.95	106.9465	1.0271	0.0000	0.0000;
	2243	1	1.915	0.318	0	0	1	1.0789632	16.356479	110	4	1.12	0.95	108.5767	0.6686	0.0000	0.0000;
	2244	1	12.385	1.671	0	0	1	1.097702	11.102825	110	4	1.12	0.95	112.0818	0.4274	0.0000	0.0000;
	2245	1	12.367	0.534	0	0	1	1.0963369	11.467718	110	4	1.12	0.95	112.5171	0.5695	0.0000	0.0000;
	2246	1	8.981	0.663	0	0	1	1.0830651	12.616283	110	4	1.12	0.95	112.5289	0.1775	0.0000	0.0000;
	2247	1	0	0	0	0	1	1.0830651	12.616283	110	4	1.12	0.95	112.5289	0.1775	0.0000	0.0000;
	2248	1	3.682	0.164	0	0	1	1.1103025	27.320139	110	4	1.12	0.95	99.9358	-0.1011	0.0000	0.0000;
	2249	1	5.743	-0.6	0	0	1	1.0916087	15.042538	110	4	1.12	0.95	109.1582	0.5231	0.0000	0.0000;
	2250	1	11.779	4.085	0	0	1	1.1001944	15.258475	110	4	1.12	0.95	109.0986	0.3345	0.0000	0.0000;
	2251	1	0	0	0	0	1	1.0729918	17.769506	110	4	1.12	0.95	106.8763	1.0338	0.0000	0.0000;
	2252	1	0	0	0	0	1	1.0693599	19.166058	110	4	1.12	0.95	106.2732	0.8708	0.0000	0.0000;
	2253	2	5.255	1.7	0	0	1	1.1024235	11.478764	110	4	1.12	0.95	111.4547	0.3080	0.0000	0.0000;
	2254	2	6.036	4.1	0	0	1	1.1023327	11.462697	110	4	1.12	0.95	111.4578	0.3094	0.0000	0.0000;
	2255	1	9.422	1.406	0	0	1	1.0932065	14.697229	110	4	1.12	0.95	109.6210	0.5050	0.0000	0.0000;
	2256	1	11.487	1.49	0	0	1	1.0957727	14.955008	110	4	1.12	0.95	109.3834	0.4488	0.0000	0.0000;
	2257	1	3.975	1.039	0	0	1	1.1130124	17.347468	110	4	1.12	0.95	105.7459	0.5036	0.0000	0.0000;
	2258	1	7.214	0.569	0	0	1	1.0866386	14.927486	110	4	1.12	0.95	110.1536	0.8835	0.0000	0.0000;
	2259	1	15.753	2.548	0	0	1	1.0679881	12.310566	110	4	1.12	0.95	111.8434	0.3657	0.0000	0.0000;
	2260	1	6.626	0.6	0	0	1	1.0890326	14.958188	110	4	1.12	0.95	109.6824	0.6381	0.0000	0.0000;
	2261	1	7.067	1.3	0	0	1	1.0979231	15.081271	110	4	1.12	0.95	109.1790	0.3670	0.0000	0.0000;
	2262	1	10.317	-0.487	0	0	1	1.0809555	20.700676	110	4	1.12	0.95	104.5481	0.4002	0.0000	0.0000;
	2263	1	0	0	0	0	1	1.080855	20.677289	110	4	1.12	0.95	104.5533	0.4048	0.0000	0.0000;
	2264	1	1.769	2.431	0	0	1	1.087912	21.33912	110	4	1.12	0.95	103.7195	-0.0892	0.0000	0.0000;
	2265	2	18.622	2.48	0	0	1	1.0959101	22.515359	110	4	1.12	0.95	101.8781	-0.3259	0.0000	0.0000;
	2266	1	8.981	1.2	0	0	1	1.1070542	16.657466	110	4	1.12	0.95	107.0940	0.4718	0.0000	0.0000;
	2267	1	2.652	0.149	0	0	1	1.1040736	22.169929	110	4	1.12	0.95	102.4133	-2.6496	0.0000	0.0000;
	2268	1	9.579	2.65	0	0	1	1.0886396	19.782802	110	4	1.12	0.95	104.8951	0.4181	0.0000	0.0000;
	2269	1	6.33	1.052	0	0	1	1.0937099	22.352565	110	4	1.12	0.95	102.0339	-0.3284	0.0000	0.0000;
	2270	1	5.449	0.144	0	0	1	1.0924466	21.842481	110	4	1.12	0.95	102.6463	-0.5196	0.0000	0.0000;
	2271	1	1.326	0.34	0	0	1	1.119697	23.649736	110	4	1.12	0.95	99.9713	-4.5103	0.0000	0.0000;
	2272	1	6.64	2.716	0	0	1	1.0980001	12.314179	110	4	1.12	0.95	111.6407	0.3174	0.0000	0.0000;
	2273	1	7.518	1.924	0	0	1	1.0586475	14.402012	110	4	1.12	0.95	112.3584	2.1127	0.0000	0.0000;
	2274	1	7.664	2.032	0	0	1	1.0586256	14.39886	110	4	1.12	0.95	112.3599	2.1131	0.0000	0.0000;
	2275	1	2.357	0.455	0	0	1	1.1059353	26.028743	110	4	1.12	0.95	100.5119	-0.0392	0.0000	0.0000;
	2276	1	4.577	2.082	0	0	1	1.0979134	24.043863	110	4	1.12	0.95	104.5900	0.2444	0.0000	0.0000;
	2277	2	14.267	2.345	0	0	1	1.0434979	7.2752337	110	4	1.12	0.95	123.1361	1.8340	0.0000	0.0000;
	2278	1	0	0	0	0	1	1.0884039	8.6894673	110	4	1.12	0.95	114.4744	0.8083	0.0000	0.0000;
	2279	1	9.863	0.201	0	0	1	1.0835706	13.782342	110	4	1.12	0.95	110.7003	0.3636	0.0000	0.0000;
	2280	1	60.656	14.94	0	0	1	1.0788752	20.498401	110	4	1.12	0.95	104.1063	0.3600	0.0000	0.0000;
	2281	1	2.948	-0.91	0	0	1	1.1190068	23.462516	110	4	1.12	0.95	100.7950	-3.0510	0.0000	0.0000;
	2282	1	2.652	0.797	0	0	1	1.090121	13.971098	110	4	1.12	0.95	110.9710	0.5549	0.0000	0.0000;
	2283	1	6.483	-1.215	0	0	1	1.0848348	12.960046	110	4	1.12	0.95	112.0344	0.6937	0.0000	0.0000;
	2284	1	6.931	-0.464	0	0	1	1.1050577	15.455358	110	4	1.12	0.95	108.3531	0.1563	0.0000	0.0000;
	2285	1	6.103	0.213	0	0	1	1.1037482	15.189678	110	4	1.12	0.95	108.6653	0.1440	0.0000	0.0000;
	2286	1	4.574	0.552	0	0	1	1.1171128	23.079649	110	4	1.12	0.95	101.0016	-3.2775	0.0000	0.0000;
	2287	1	2.796	0.123	0	0	1	1.1005367	20.762644	110	4	1.12	0.95	103.1605	0.0013	0.0000	0.0000;
	2288	1	0	0	0	0	1	1.1005563	20.758352	110	4	1.12	0.95	103.1604	0.0034	0.0000	0.0000;
	2289	1	4.127	0.186	0	0	1	1.1183564	23.165223	110	4	1.12	0.95	101.0819	-2.7185	0.0000	0.0000;
	2290	1	0	0	0	0	1	1.1183564	23.165223	110	4	1.12	0.95	101.0819	-2.7185	0.0000	0.0000;
	2291	1	0	0	0	0	1	1.0869723	13.734012	110	4	1.12	0.95	110.8126	0.5051	0.0000	0.0000;
	2292	1	7.36	2.863	0	0	1	1.0858133	15.134547	110	4	1.12	0.95	109.8026	0.9066	0.0000	0.0000;
	2293	2	14.843	-3.17	0	0	1	1.1012341	11.134733	110	4	1.12	0.95	111.7314	0.2467	0.0000	0.0000;
	2294	1	12.846	-3	0	0	1	1.1020199	11.436705	110	4	1.12	0.95	111.3886	0.2974	0.0000	0.0000;
	2295	2	3.383	-0.002	0	0	1	1.1173076	23.904517	110	4	1.12	0.95	100.9020	-1.9563	0.0000	0.0000;
	2296	2	5.461	1.071	0	0	1	1.0944504	13.095885	110	4	1.12	0.95	110.6666	0.2450	0.0000	0.0000;
	2297	1	4.42	-0.084	0	0	1	1.1159938	23.014218	110	4	1.12	0.95	101.1313	-3.7953	0.0000	0.0000;
	2298	1	5.752	1.747	0	0	1	1.099366	23.11727	110	4	1.12	0.95	104.6782	0.3131	0.0000	0.0000;
	2299	1	20.348	0.639	0	0	1	1.0907901	15.924824	110	4	1.12	0.95	108.2275	0.5634	0.0000	0.0000;
	2300	1	9.287	1.87	0	0	1	1.107704	22.481931	110	4	1.12	0.95	100.8362	-2.8940	0.0000	0.0000;
	2301	1	4.42	0.945	0	0	1	1.1185063	23.236544	110	4	1.12	0.95	100.9050	-3.0666	0.0000	0.0000;
	2302	1	13.86	0.318	0	0	1	1.0742941	15.973959	110	4	1.12	0.95	108.6594	0.8101	0.0000	0.0000;
	2303	1	8.981	2.2	0	0	1	1.0796685	15.567292	110	4	1.12	0.95	109.8202	1.3710	0.0000	0.0000;
	2304	1	15.178	-1.114	0	0	1	1.0830868	12.393496	110	4	1.12	0.95	112.1554	0.3145	0.0000	0.0000;
	2305	1	11.81	2.127	0	0	1	1.0662879	18.066743	110	4	1.12	0.95	115.4093	6.3930	0.0000	0.0000;
	2306	1	14.281	2.6	0	0	1	1.0294638	15.376899	110	4	1.12	0.95	114.7068	6.3531	0.0000	0.0000;
	2307	1	10.6	0.121	0	0	1	1.0827651	12.276239	110	4	1.12	0.95	112.8328	0.1446	0.0000	0.0000;
	2308	1	16.194	3.863	0	0	1	1.0064805	16.041496	110	4	1.12	0.95	116.2409	9.9527	0.0000	0.0000;
	2309	1	12.683	-2.337	0	0	1	1.0897615	21.174915	110	4	1.12	0.95	103.6615	-0.4155	0.0000	0.0000;
	2310	1	1.473	0.461	0	0	1	1.096551	20.825343	110	4	1.12	0.95	103.2013	-0.0422	0.0000	0.0000;
	2311	1	4.716	-0.989	0	0	1	1.0743829	19.867672	110	4	1.12	0.95	105.3982	0.6327	0.0000	0.0000;
	2312	1	0	0	0	0	1	1.0822718	20.880579	110	4	1.12	0.95	104.4041	0.3799	0.0000	0.0000;
	2313	1	10.321	2.037	0	0	1	1.1096065	22.726459	110	4	1.12	0.95	102.1569	-2.2640	0.0000	0.0000;
	2314	1	0	0	0	0	1	1.1096065	22.726459	110	4	1.12	0.95	102.1569	-2.2640	0.0000	0.0000;
	2315	1	6.784	1.521	0	0	1	1.0939115	12.918143	110	4	1.12	0.95	110.7399	0.3018	0.0000	0.0000;
	2316	1	1.473	0.067	0	0	1	1.1067673	26.731095	110	4	1.12	0.95	100.4788	-0.1066	0.0000	0.0000;
	2317	1	6.044	0.5	0	0	1	1.1034972	15.107163	110	4	1.12	0.95	108.0987	0.3759	0.0000	0.0000;
	2318	1	17.373	3.742	0	0	1	1.0865794	15.267954	110	4	1.12	0.95	110.3081	1.3005	0.0000	0.0000;
	2319	1	0	0	0	0	1	1.1197028	23.359542	110	4	1.12	0.95	100.8527	-2.7150	0.0000	0.0000;
	2320	1	1.923	-0.19	0	0	1	1.12	23.545662	110	4	1.12	0.95	100.1259	-4.3932	8719.1282	0.0000;
	2321	1	13.857	2.278	0	0	1	1.0377378	6.4320374	110	4	1.12	0.95	124.3967	1.9092	0.0000	0.0000;
	2322	1	0	0	0	0	1	1.0872371	8.3886141	110	4	1.12	0.95	114.9338	0.7263	0.0000	0.0000;
	2323	1	3.682	0.615	0	0	1	1.0969449	22.252435	110	4	1.12	0.95	102.0406	-0.3082	0.0000	0.0000;
	2324	1	0.737	0.202	0	0	1	1.0872176	8.3890364	110	4	1.12	0.95	114.9338	0.7280	0.0000	0.0000;
	2325	1	11.206	1.532	0	0	1	1.1009882	11.257421	110	4	1.12	0.95	111.9223	0.1991	0.0000	0.0000;
	2326	1	6.204	0.867	0	0	1	1.09213	24.016329	110	4	1.12	0.95	105.2220	0.3688	0.0000	0.0000;
	2327	1	5.011	0.278	0	0	1	1.0919085	20.623409	110	4	1.12	0.95	103.6787	-0.1581	0.0000	0.0000;
	2328	2	9.422	0	0	0	1	1.102127	11.570662	110	4	1.12	0.95	111.5607	0.3225	0.0000	0.0000;
	2329	1	5.751	-0.303	0	0	1	1.0766313	15.606499	110	4	1.12	0.95	109.5060	0.5762	0.0000	0.0000;
	2330	1	4.565	1.311	0	0	1	1.1018002	11.46184	110	4	1.12	0.95	111.3210	0.3533	0.0000	0.0000;
	2331	2	6.631	0.3	0	0	1	1.0439205	5.5090828	110	4	1.12	0.95	122.3190	2.3194	0.0000	0.0000;
	2332	1	20.17	0.016	0	0	1	1.0848235	13.130658	110	4	1.12	0.95	111.4334	0.4481	0.0000	0.0000;
	2333	1	8.409	2.594	0	0	1	1.0982896	21.702217	110	4	1.12	0.95	102.2614	-0.0703	0.0000	0.0000;
	2334	1	11.369	5.075	0	0	1	1.1178944	28.702535	110	4	1.12	0.95	100.5343	0.0565	0.0000	0.0000;
	2335	1	6.036	0.241	0	0	1	1.0708473	11.98119	110	4	1.12	0.95	112.5235	0.3801	0.0000	0.0000;
	2336	1	16.217	8.211	0	0	1	1.1119533	29.228914	110	4	1.12	0.95	98.9507	0.0557	0.0000	0.0000;
	2337	1	2.946	0	0	0	1	1.1124454	29.228955	110	4	1.12	0.95	98.9360	0.0263	0.0000	0.0000;
	2338	1	0.883	0.104	0	0	1	1.1126144	29.250285	110	4	1.12	0.95	98.9036	0.0245	0.0000	0.0000;
	2339	1	3.24	0.007	0	0	1	1.1125277	29.242575	110	4	1.12	0.95	98.9204	0.0266	0.0000	0.0000;
	2340	1	2.355	0.61	0	0	1	1.1126513	29.254937	110	4	1.12	0.95	98.8978	0.0242	0.0000	0.0000;
	2341	1	3.532	1.017	0	0	1	1.1108147	29.173066	110	4	1.12	0.95	99.0075	0.0909	0.0000	0.0000;
	2342	1	7.95	7.195	0	0	1	1.1107868	29.172244	110	4	1.12	0.95	99.0078	0.0914	0.0000	0.0000;
	2343	2	20.447	32.2	0	0	1	1.1133338	29.29106	110	4	1.12	0.95	98.8400	0.0000	0.0000	0.0000;
	2344	1	9.873	4.2	0	0	1	1.113223	29.281559	110	4	1.12	0.95	98.8434	0.0016	0.0000	0.0000;
	2345	1	21.822	4.492	0	0	1	1.1012158	11.353137	110	4	1.12	0.95	111.5424	0.3418	0.0000	0.0000;
	2346	1	8.843	1.053	0	0	1	1.094361	20.951034	110	4	1.12	0.95	103.2775	-0.1307	0.0000	0.0000;
	2347	1	2.061	0.237	0	0	1	1.1187083	23.343444	110	4	1.12	0.95	100.9482	-2.6722	0.0000	0.0000;
	2348	1	8.108	1.075	0	0	1	1.1186944	23.340416	110	4	1.12	0.95	100.9490	-2.6721	0.0000	0.0000;
	2349	1	13.985	1.282	0	0	1	1.0788238	13.579707	110	4	1.12	0.95	110.8691	0.5073	0.0000	0.0000;
	2350	1	8.097	2.749	0	0	1	1.1080991	24.319823	110	4	1.12	0.95	103.5297	0.0045	0.0000	0.0000;
	2351	1	0	0	0	0	1	1.1080991	24.319823	110	4	1.12	0.95	103.5297	0.0045	0.0000	0.0000;
	2352	1	10.307	1.453	0	0	1	1.0978085	15.075442	110	4	1.12	0.95	109.2542	0.3864	0.0000	0.0000;
	2353	1	1.471	0.051	0	0	1	1.1142685	14.602216	110	4	1.12	0.95	109.1682	0.0708	0.0000	0.0000;
	2354	2	4.27	1.488	0	0	1	1.0969629	23.412176	110	4	1.12	0.95	100.6177	-0.2455	0.0000	0.0000;
	2355	2	6.33	2.108	0	0	1	1.0954691	21.815961	110	4	1.12	0.95	102.5527	-0.6582	0.0000	0.0000;
	2356	1	1.03	0.4	0	0	1	1.1136226	27.210096	110	4	1.12	0.95	101.5500	0.1047	0.0000	0.0000;
	2357	1	3.243	0.187	0	0	1	1.1066991	10.982928	110	4	1.12	0.95	111.6354	-0.0374	0.0000	0.0000;
	2358	1	0	0	0	0	1	1.1193557	23.572066	110	4	1.12	0.95	100.7505	-2.8257	0.0000	0.0000;
	2359	1	0	0	0	0	1	1.1193557	23.572066	110	4	1.12	0.95	100.7505	-2.8257	0.0000	0.0000;
	2360	2	12.769	2.253	0	0	1	1.1176397	23.957646	110	4	1.12	0.95	100.8105	-1.9427	0.0000	0.0000;
	2361	1	8.853	2.062	0	0	1	1.1177034	23.966862	110	4	1.12	0.95	100.8013	-1.9431	0.0000	0.0000;
	2362	1	4.573	1.065	0	0	1	1.0911289	16.90425	110	4	1.12	0.95	106.8928	0.6700	0.0000	0.0000;
	2363	1	0	0	0	0	1	1.1066814	26.539562	110	4	1.12	0.95	100.4235	-0.0635	0.0000	0.0000;
	2364	1	1.178	0	0	0	1	1.1067571	26.760117	110	4	1.12	0.95	100.4412	-0.0831	0.0000	0.0000;
	2365	1	10.307	2.141	0	0	1	1.0582098	11.437463	110	4	1.12	0.95	113.8009	0.4917	0.0000	0.0000;
	2366	2	5.235	0.365	0	0	1	1.1007776	21.297534	110	4	1.12	0.95	102.6864	-0.1049	0.0000	0.0000;
	2367	1	1.427	0.36	0	0	1	1.1007738	21.29699	110	4	1.12	0.95	102.6866	-0.1049	0.0000	0.0000;
	2368	1	5.898	1.334	0	0	1	1.0959571	22.962821	110	4	1.12	0.95	101.4171	-0.2465	0.0000	0.0000;
	2369	1	6.331	1.72	0	0	1	1.0981692	22.090695	110	4	1.12	0.95	102.1818	-0.4679	0.0000	0.0000;
	2370	2	4.853	1.012	0	0	1	1.0924764	21.523873	110	4	1.12	0.95	103.0367	-0.6647	0.0000	0.0000;
	2371	1	6.043	1.334	0	0	1	1.0924923	21.524854	110	4	1.12	0.95	103.0349	-0.6617	0.0000	0.0000;
	2372	1	11.778	-0.844	0	0	1	1.0811205	12.00324	110	4	1.12	0.95	112.7746	0.1534	0.0000	0.0000;
	2373	1	8.689	1.072	0	0	1	1.0917082	21.427058	110	4	1.12	0.95	103.1406	-0.6535	0.0000	0.0000;
	2374	1	8.837	1.722	0	0	1	1.0950926	23.218626	110	4	1.12	0.95	100.8420	-0.2083	0.0000	0.0000;
	2375	1	4.718	1.476	0	0	1	1.094293	23.162808	110	4	1.12	0.95	101.0147	-0.2862	0.0000	0.0000;
	2376	1	4.422	1.058	0	0	1	1.0963824	21.838865	110	4	1.12	0.95	102.3428	-0.9564	0.0000	0.0000;
	2377	1	9.725	-0.347	0	0	1	1.088015	30.377053	110	4	1.12	0.95	102.2984	-0.1699	0.0000	0.0000;
	2378	1	4.418	0	0	0	1	1.0939464	22.378624	110	4	1.12	0.95	102.0055	-0.3329	0.0000	0.0000;
	2379	1	6.779	0.779	0	0	1	1.092587	21.865949	110	4	1.12	0.95	102.6218	-0.5200	0.0000	0.0000;
	2380	1	6.036	1.264	0	0	1	1.0761188	16.020376	110	4	1.12	0.95	109.3202	1.2679	0.0000	0.0000;
	2381	1	12.662	0.698	0	0	1	1.0450795	16.639747	110	4	1.12	0.95	114.3754	6.6582	0.0000	0.0000;
	2382	1	17.208	3.596	0	0	1	1.0774576	15.462268	110	4	1.12	0.95	109.0532	0.7812	0.0000	0.0000;
	2383	1	3.094	-1.341	0	0	1	1.0391287	6.5584399	110	4	1.12	0.95	124.1473	1.8695	0.0000	0.0000;
	2384	1	8.247	2.388	0	0	1	1.096136	22.949611	110	4	1.12	0.95	101.4378	-0.2484	0.0000	0.0000;
	2385	1	13.258	1.768	0	0	1	1.0972574	22.160688	110	4	1.12	0.95	102.1049	-0.2815	0.0000	0.0000;
	2386	1	8.244	0.104	0	0	1	1.0886611	21.509465	110	4	1.12	0.95	103.2893	-0.4844	0.0000	0.0000;
	2387	1	8.244	0.52	0	0	1	1.0955586	21.75289	110	4	1.12	0.95	102.4794	-0.9501	0.0000	0.0000;
	2388	1	7.508	-2.2	0	0	1	1.1133733	13.881267	110	4	1.12	0.95	109.4404	-0.1462	0.0000	0.0000;
	2389	1	9.568	2.4	0	0	1	1.0943549	21.699082	110	4	1.12	0.95	102.6722	-0.8288	0.0000	0.0000;
	2390	1	6.626	0.72	0	0	1	1.0957841	23.260323	110	4	1.12	0.95	100.7878	-0.2704	0.0000	0.0000;
	2391	1	13.11	4.34	0	0	1	1.0885485	21.498676	110	4	1.12	0.95	103.3017	-0.4818	0.0000	0.0000;
	2392	1	9.422	0.432	0	0	1	1.0954413	23.120355	110	4	1.12	0.95	101.2106	-0.2759	0.0000	0.0000;
	2393	1	0	0	0	0	1	1.1166458	23.321518	110	4	1.12	0.95	100.3938	-4.4221	0.0000	0.0000;
	2394	1	0	0	0	0	1	1.088996	21.07387	110	4	1.12	0.95	104.4115	-1.0337	0.0000	0.0000;
	2395	1	0	0	0	0	1	1.1068501	26.728644	110	4	1.12	0.95	100.4788	-0.1152	0.0000	0.0000;
	2396	1	0	0	0	0	1	1.1033692	19.426419	110	4	1.12	0.95	103.8767	0.3893	0.0000	0.0000;
	2397	1	0	0	0	0	1	1.1134768	26.758835	110	4	1.12	0.95	101.6894	0.2711	0.0000	0.0000;
	2398	1	0	0	0	0	1	1.0999041	20.737	110	4	1.12	0.95	103.0355	0.1249	0.0000	0.0000;
	2399	1	0	0	0	0	1	1.0690647	19.093475	110	4	1.12	0.95	106.3344	0.8853	0.0000	0.0000;
	2400	1	0	0	0	0	1	1.0729629	19.717392	110	4	1.12	0.95	105.5149	0.7178	0.0000	0.0000;
	2401	1	0	0	0	0	1	1.0880711	21.056518	110	4	1.12	0.95	104.4729	-0.5368	0.0000	0.0000;
	2402	1	0	0	0	0	1	1.0958813	13.403356	110	4	1.12	0.95	110.3702	0.3847	0.0000	0.0000;
	2403	1	0	0	0	0	1	1.1009661	14.329635	110	4	1.12	0.95	109.0300	0.3423	0.0000	0.0000;
	2404	1	0	0	0	0	1	1.0762154	15.998964	110	4	1.12	0.95	109.3350	1.2780	0.0000	0.0000;
	2405	1	0	0	0	0	1	1.0940335	22.043725	110	4	1.12	0.95	102.3820	-0.3351	0.0000	0.0000;
	2406	1	0	0	0	0	1	1.0961238	12.964964	110	4	1.12	0.95	111.0399	0.2697	0.0000	0.0000;
	2407	1	0	0	0	0	1	1.0707402	19.553167	110	4	1.12	0.95	105.8649	0.8042	0.0000	0.0000;
	2408	1	0	0	0	0	1	1.0689196	12.408609	110	4	1.12	0.95	111.7024	0.3464	0.0000	0.0000;
	2409	1	0	0	0	0	1	1.0746084	19.90695	110	4	1.12	0.95	105.3242	0.6495	0.0000	0.0000;
	2410	1	0	0	0	0	1	1.0685464	12.463617	110	4	1.12	0.95	111.8145	0.3528	0.0000	0.0000;
	2411	1	0	0	0	0	1	1.093144	14.674237	110	4	1.12	0.95	109.6315	0.5002	0.0000	0.0000;
	2412	1	0	0	0	0	1	1.082267	20.880725	110	4	1.12	0.95	104.4041	0.3804	0.0000	0.0000;
	2413	1	0	0	0	0	1	1.1019389	11.832065	110	4	1.12	0.95	111.5428	0.3874	0.0000	0.0000;
	2414	1	0	0	0	0	1	1.098115	22.262831	110	4	1.12	0.95	101.9944	-0.2956	0.0000	0.0000;
	2415	1	0	0	0	0	1	1.101316	21.707061	110	4	1.12	0.95	102.3398	-0.1780	0.0000	0.0000;
	2416	1	5.165	0.682	0	0	1	1.0837548	32.764364	110	4	1.12	0.95	101.5581	-0.0152	0.0000	0.0000;
	2417	1	2.756	0.583	0	0	1	1.0996678	16.685528	110	4	1.12	0.95	107.2125	0.4650	0.0000	0.0000;
	2418	1	7.461	-0.788	0	0	1	1.073874	14.657312	110	4	1.12	0.95	110.6745	0.4486	0.0000	0.0000;
	2419	1	8.106	2.419	0	0	1	1.0898461	10.950961	110	4	1.12	0.95	113.6808	0.7674	0.0000	0.0000;
	2420	1	52.502	7.875	0	0	1	1.0742805	13.980079	110	4	1.12	0.95	111.2438	0.5730	0.0000	0.0000;
	2421	1	7.375	1.249	0	0	1	1.1179602	23.423563	110	4	1.12	0.95	100.1560	-4.4913	0.0000	0.0000;
	2422	1	0	0	0	0	1	1.1179602	23.423563	110	4	1.12	0.95	100.1560	-4.4913	0.0000	0.0000;
	2423	1	7.371	1.109	0	0	1	1.12	23.680771	110	4	1.12	0.95	99.9312	-4.5140	6388.3841	0.0000;
	2424	1	0	0	0	0	1	1.119971	23.67062	110	4	1.12	0.95	99.9332	-4.5132	0.0000	0.0000;
	2425	1	12.373	1.097	0	0	1	1.0990748	14.214004	110	4	1.12	0.95	109.8096	0.0836	0.0000	0.0000;
	2426	1	5.898	0.377	0	0	1	1.1017135	11.814065	110	4	1.12	0.95	111.5845	0.3899	0.0000	0.0000;
	2427	1	27.384	6.806	0	0	1	1.1038663	16.113633	110	4	1.12	0.95	107.9446	0.4266	0.0000	0.0000;
	2428	1	23.568	4.844	0	0	1	1.0974889	11.130918	110	4	1.12	0.95	112.0698	0.4465	0.0000	0.0000;
	2429	1	6.353	-0.622	0	0	1	1.1089452	17.035924	110	4	1.12	0.95	106.8406	0.0728	0.0000	0.0000;
	2430	1	11.943	-1.5	0	0	1	1.1103038	17.000438	110	4	1.12	0.95	106.8942	-0.0105	0.0000	0.0000;
	2431	2	0.863	0.272	0	0	1	1.1099869	17.019126	110	4	1.12	0.95	106.8471	0.0000	0.0000	0.0000;
	2432	1	9.873	0.887	0	0	1	1.1113604	27.59644	110	4	1.12	0.95	99.7306	-0.0860	0.0000	0.0000;
	2433	1	3.386	1	0	0	1	1.098803	19.878836	110	4	1.12	0.95	103.7032	0.2303	0.0000	0.0000;
	2434	1	3.978	0.014	0	0	1	1.0869956	12.296412	110	4	1.12	0.95	112.2744	0.1071	0.0000	0.0000;
	2435	1	10.174	3.359	0	0	1	1.1191667	28.983367	110	4	1.12	0.95	100.3484	0.0207	0.0000	0.0000;
	2436	1	10.025	2.22	0	0	1	1.0638727	12.062561	110	4	1.12	0.95	112.8403	0.3777	0.0000	0.0000;
	2437	1	5.601	0.164	0	0	1	1.094273	22.449311	110	4	1.12	0.95	102.2626	-0.2823	0.0000	0.0000;
	2438	2	11.462	-0.5	0	0	1	1.0719992	11.608884	110	4	1.12	0.95	113.2771	0.3541	0.0000	0.0000;
	2439	1	3.243	0.136	0	0	1	1.0801171	17.676689	110	4	1.12	0.95	106.9609	0.8917	0.0000	0.0000;
	2440	1	5.157	1.247	0	0	1	1.1183775	23.389676	110	4	1.12	0.95	100.5813	-4.0235	0.0000	0.0000;
	2441	1	0	0	0	0	1	1.1183775	23.389676	110	4	1.12	0.95	100.5813	-4.0235	0.0000	0.0000;
	2442	1	5.898	0.756	0	0	1	1.0900618	20.967031	110	4	1.12	0.95	104.5517	-1.1752	0.0000	0.0000;
	2443	1	0	0	0	0	1	1.0916901	21.128211	110	4	1.12	0.95	104.3317	-1.2146	0.0000	0.0000;
	2444	1	0	0	0	0	1	1.0830533	17.568706	110	4	1.12	0.95	107.0632	0.7819	0.0000	0.0000;
	2445	1	0	0	0	0	1	1.074617	17.318308	110	4	1.12	0.95	107.3377	0.8656	0.0000	0.0000;
	2446	1	4.865	1.375	0	0	1	1.1008042	22.090244	110	4	1.12	0.95	101.7452	-1.8953	0.0000	0.0000;
	2447	1	0.737	0.2	0	0	1	1.1040193	11.522408	110	4	1.12	0.95	111.2752	0.2599	0.0000	0.0000;
	2448	2	10.207	2.3	0	0	1	1.093949	14.356682	110	5	1.12	0.95	108.6210	0.5985	0.0000	0.0000;
	2449	1	8.007	1.3	0	0	1	1.0759156	11.223517	110	5	1.12	0.95	112.7979	0.7447	0.0000	0.0000;
	2450	1	6.625	2	0	0	1	1.1154416	15.228034	110	5	1.12	0.95	107.8808	0.1034	0.0000	0.0000;
	2451	2	8.124	3.5	0	0	1	1.1174886	15.477333	110	5	1.12	0.95	107.4897	0.0000	0.0000	0.0000;
	2452	1	8.007	1.9	0	0	1	1.079157	11.675932	110	5	1.12	0.95	111.9865	0.7731	0.0000	0.0000;
	2453	2	9.007	2	0	0	1	1.110436	13.678671	110	5	1.12	0.95	110.1101	-0.7033	0.0000	0.0000;
	2454	1	0	0	0	0	1	1.1104181	13.674868	110	5	1.12	0.95	110.1115	-0.7030	0.0000	0.0000;
	2455	1	7.177	1.6	0	0	1	1.1162827	15.372973	110	5	1.12	0.95	107.6348	0.0434	0.0000	0.0000;
	2456	1	10.063	13.3	0	0	1	1.0799778	13.390891	110	5	1.12	0.95	111.1606	1.4201	0.0000	0.0000;
	2457	1	6.314	3	0	0	1	1.1106487	16.439691	110	5	1.12	0.95	107.4506	-0.0314	0.0000	0.0000;
	2458	1	14.906	4	0	0	1	1.1173244	15.35888	110	5	1.12	0.95	107.6658	-0.0186	0.0000	0.0000;
	2459	2	5.304	0.3	0	0	1	1.069256	12.177278	110	5	1.12	0.95	112.7517	1.3854	0.0000	0.0000;
	2460	1	4.504	2	0	0	1	1.0843917	12.572103	110	5	1.12	0.95	110.8446	0.7497	0.0000	0.0000;
	2461	1	7.811	1.3	0	0	1	1.0839363	13.431371	110	5	1.12	0.95	110.7705	1.1732	0.0000	0.0000;
	2462	1	3.864	1.2	0	0	1	1.0783881	12.352554	110	5	1.12	0.95	114.4788	0.9769	0.0000	0.0000;
	2463	1	16.563	6	0	0	1	1.1143455	15.198493	110	5	1.12	0.95	107.8896	0.1215	0.0000	0.0000;
	2464	1	8.281	2.5	0	0	1	1.1182582	15.453327	110	5	1.12	0.95	107.5305	-0.0581	0.0000	0.0000;
	2465	1	0	0	0	0	1	1.1191856	15.403467	110	5	1.12	0.95	107.7057	0.0254	0.0000	0.0000;
	2466	1	0	0	0	0	1	1.1192275	15.415271	110	5	1.12	0.95	107.7011	0.0248	0.0000	0.0000;
	2467	2	8.507	1	0	0	1	1.1111559	13.655661	110	5	1.12	0.95	110.6900	-1.2017	0.0000	0.0000;
	2468	1	2.946	1.5	0	0	1	1.082282	13.553136	110	5	1.12	0.95	110.4232	1.0675	0.0000	0.0000;
	2469	1	7.177	2.5	0	0	1	1.0802512	12.573398	110	5	1.12	0.95	114.1867	0.9395	0.0000	0.0000;
	2470	2	9.471	2.4	0	0	1	1.0923159	14.690495	110	5	1.12	0.95	108.9828	0.6192	0.0000	0.0000;
	2471	2	4.6	1.4	0	0	1	1.0922376	14.690008	110	5	1.12	0.95	108.9947	0.6210	0.0000	0.0000;
	2472	1	15.321	3.9	0	0	1	1.0850912	14.226164	110	5	1.12	0.95	109.6479	0.8207	0.0000	0.0000;
	2473	1	18.325	3.6	0	0	1	1.08295	14.595639	110	5	1.12	0.95	109.6718	0.8470	0.0000	0.0000;
	2474	1	6.625	2	0	0	1	1.081185	12.626782	110	5	1.12	0.95	114.0064	0.9207	0.0000	0.0000;
	2475	1	6.76	1	0	0	1	1.1139651	14.391764	110	5	1.12	0.95	108.7088	0.1719	0.0000	0.0000;
	2476	1	6.625	2.5	0	0	1	1.0540782	10.630648	110	5	1.12	0.95	114.4243	1.8509	0.0000	0.0000;
	2477	1	3.683	0.9	0	0	1	1.0556793	10.748055	110	5	1.12	0.95	114.2492	1.7904	0.0000	0.0000;
	2478	1	9.508	2	0	0	1	1.0751069	12.108369	110	5	1.12	0.95	115.2756	0.9615	0.0000	0.0000;
	2479	1	10.734	1.5	0	0	1	1.0928974	14.280039	110	5	1.12	0.95	108.8328	0.5883	0.0000	0.0000;
	2480	2	3.803	0	0	0	1	1.0755215	8.028341	110	5	1.12	0.95	118.7231	-0.7603	0.0000	0.0000;
	2481	2	3.002	0.4	0	0	1	1.0751236	11.84516	110	5	1.12	0.95	115.5815	0.8679	0.0000	0.0000;
	2482	2	3.503	0.5	0	0	1	1.1112427	15.301499	110	5	1.12	0.95	108.5845	-0.6708	0.0000	0.0000;
	2483	2	0.5	0.1	0	0	1	1.1144725	14.413222	110	5	1.12	0.95	109.4566	-1.3399	0.0000	0.0000;
	2484	1	5.505	2	0	0	1	1.0827745	12.729524	110	5	1.12	0.95	110.9180	0.8534	0.0000	0.0000;
	2485	2	3.303	0	0	0	1	1.074669	7.9243305	110	5	1.12	0.95	118.9544	-0.7860	0.0000	0.0000;
	2486	1	0.601	0.2	0	0	1	1.0872538	14.755687	110	5	1.12	0.95	109.1944	0.7823	0.0000	0.0000;
	2487	1	11.717	6	0	0	1	1.0874022	16.25097	110	5	1.12	0.95	108.1094	0.8960	0.0000	0.0000;
	2488	2	4.003	2	0	0	1	1.115889	15.053356	110	5	1.12	0.95	108.3934	-1.1658	0.0000	0.0000;
	2489	1	0	0	0	0	1	1.1149108	14.541223	110	5	1.12	0.95	108.9936	-0.7259	0.0000	0.0000;
	2490	1	0	0	0	0	1	1.1148837	14.52492	110	5	1.12	0.95	108.9995	-0.7257	0.0000	0.0000;
	2491	2	8.207	3.2	0	0	1	1.0668047	12.298081	110	5	1.12	0.95	112.9051	1.6178	0.0000	0.0000;
	2492	1	7.006	3	0	0	1	1.066807	12.289733	110	5	1.12	0.95	112.9025	1.6170	0.0000	0.0000;
	2493	1	9.208	2.1	0	0	1	1.0660233	12.137622	110	5	1.12	0.95	112.9780	1.6217	0.0000	0.0000;
	2494	1	6.405	1.7	0	0	1	1.0655664	12.153309	110	5	1.12	0.95	113.0563	1.6879	0.0000	0.0000;
	2495	1	9.386	3.5	0	0	1	1.1188711	15.514512	110	5	1.12	0.95	107.3798	-0.0812	0.0000	0.0000;
	2496	1	0	0	0	0	1	1.12	15.587406	110	5	1.12	0.95	107.1749	-0.5088	2275.1757	0.0000;
	2497	2	2.002	0.4	0	0	1	1.1132703	14.039947	110	5	1.12	0.95	110.0081	-1.2688	0.0000	0.0000;
	2498	1	0	0	0	0	1	1.0948943	14.341096	110	5	1.12	0.95	108.5164	0.5610	0.0000	0.0000;
	2499	1	0	0	0	0	1	1.0963328	14.534821	110	5	1.12	0.95	108.2627	0.5538	0.0000	0.0000;
	2500	2	7.198	1.5	0	0	1	1.0930075	14.276827	110	5	1.12	0.95	108.7672	0.6098	0.0000	0.0000;
	2501	1	7.051	1.1	0	0	1	1.0917714	13.988206	110	5	1.12	0.95	108.9984	0.6119	0.0000	0.0000;
	2502	1	0	0	0	0	1	1.0926948	14.326608	110	5	1.12	0.95	108.8565	0.5841	0.0000	0.0000;
	2503	1	0	0	0	0	1	1.0894222	13.650877	110	5	1.12	0.95	109.5360	0.5755	0.0000	0.0000;
	2504	1	10.313	2	0	0	1	1.0933659	14.291076	110	5	1.12	0.95	108.6805	0.6238	0.0000	0.0000;
	2505	1	4.525	0.9	0	0	1	1.0870024	14.198232	110	5	1.12	0.95	109.7533	0.7499	0.0000	0.0000;
	2506	1	3.999	0.8	0	0	1	1.087015	14.208978	110	5	1.12	0.95	109.7567	0.7503	0.0000	0.0000;
	2507	1	4.504	0.8	0	0	1	1.0869357	12.981178	110	5	1.12	0.95	110.1505	0.8895	0.0000	0.0000;
	2508	1	7.51	1	0	0	1	1.1151919	14.905209	110	5	1.12	0.95	108.2125	0.3848	0.0000	0.0000;
	2509	2	7.729	3.3	0	0	1	1.0666779	20.615348	110	5	1.12	0.95	107.4214	1.6338	0.0000	0.0000;
	2510	1	5.407	1.2	0	0	1	1.090829	14.665921	110	5	1.12	0.95	109.5598	0.8504	0.0000	0.0000;
	2511	2	3.503	0.5	0	0	1	1.1048974	13.245539	110	5	1.12	0.95	110.8242	-0.5806	0.0000	0.0000;
	2512	1	11.576	2.6	0	0	1	1.0863721	14.101403	110	5	1.12	0.95	109.8498	0.7590	0.0000	0.0000;
	2513	1	14.312	4.2	0	0	1	1.0867565	14.181093	110	5	1.12	0.95	109.7811	0.7576	0.0000	0.0000;
	2514	1	0	0	0	0	1	1.089867	14.675341	110	5	1.12	0.95	109.0364	0.7149	0.0000	0.0000;
	2515	1	0.3	0.1	0	0	1	1.0899595	14.685238	110	5	1.12	0.95	109.0316	0.7141	0.0000	0.0000;
	2516	1	2.002	0.5	0	0	1	1.0816054	11.816792	110	5	1.12	0.95	111.4873	0.7877	0.0000	0.0000;
	2517	1	0.421	0.1	0	0	1	1.0941605	14.289986	110	5	1.12	0.95	108.6314	0.5741	0.0000	0.0000;
	2518	1	8.711	1.5	0	0	1	1.1149494	14.891026	110	5	1.12	0.95	108.2362	0.3894	0.0000	0.0000;
	2519	1	0	0	0	0	1	1.1192584	15.232798	110	5	1.12	0.95	107.7161	0.3095	0.0000	0.0000;
	2520	1	0	0	0	0	1	1.1195763	15.257429	110	5	1.12	0.95	107.7020	0.3043	0.0000	0.0000;
	2521	1	0	0	0	0	1	1.1195353	15.249225	110	5	1.12	0.95	107.7089	0.2999	0.0000	0.0000;
	2522	1	3.503	0.8	0	0	1	1.0748035	11.950858	110	5	1.12	0.95	115.4642	0.9254	0.0000	0.0000;
	2523	2	5.505	1.5	0	0	1	1.1151552	12.991467	110	5	1.12	0.95	111.0404	-0.9855	0.0000	0.0000;
	2524	1	14.512	3	0	0	1	1.0806017	12.48976	110	5	1.12	0.95	111.6651	1.2652	0.0000	0.0000;
	2525	1	7.36	1.7	0	0	1	1.0976979	14.064073	110	5	1.12	0.95	109.6461	0.8388	0.0000	0.0000;
	2526	2	15.459	4.5	0	0	1	1.1171286	15.323823	110	5	1.12	0.95	107.7277	0.0022	0.0000	0.0000;
	2527	1	6.073	2	0	0	1	1.1199157	15.587083	110	5	1.12	0.95	107.2897	-0.1138	0.0000	0.0000;
	2528	1	6.625	2	0	0	1	1.11998	15.58771	110	5	1.12	0.95	107.2891	-0.1230	0.0000	0.0000;
	2529	2	33.125	20	0	0	1	1.0765621	21.445766	110	5	1.12	0.95	106.2248	1.2994	0.0000	0.0000;
	2530	1	5.505	2.3	0	0	1	1.0863428	13.118902	110	5	1.12	0.95	110.2757	0.7976	0.0000	0.0000;
	2531	1	3.503	0.5	0	0	1	1.107686	13.453001	110	5	1.12	0.95	110.5038	-0.6567	0.0000	0.0000;
	2532	1	6.608	1	0	0	1	1.0869092	15.029838	110	5	1.12	0.95	109.0623	0.7949	0.0000	0.0000;
	2533	1	1.104	0.5	0	0	1	1.0601393	20.126472	110	5	1.12	0.95	108.7434	1.7957	0.0000	0.0000;
	2534	1	1.546	0.7	0	0	1	1.060144	20.126916	110	5	1.12	0.95	108.7431	1.7956	0.0000	0.0000;
	2535	1	18.205	4.7	0	0	1	1.0543151	11.321517	110	5	1.12	0.95	114.5481	1.9519	0.0000	0.0000;
	2536	2	0	0	0	0	1	1.1128364	14.995388	110	5	1.12	0.95	108.4524	0.1149	0.0000	0.0000;
	2537	1	9.997	3.4	0	0	1	1.0711695	12.505728	110	5	1.12	0.95	112.0716	1.3169	0.0000	0.0000;
	2538	1	8.629	2	0	0	1	1.0868726	13.677008	110	5	1.12	0.95	109.8294	0.6818	0.0000	0.0000;
	2539	2	10.008	1	0	0	1	1.1030198	13.110463	110	5	1.12	0.95	110.9648	-0.5053	0.0000	0.0000;
	2540	1	9.997	1.7	0	0	1	1.0877289	14.261014	110	5	1.12	0.95	109.6434	0.7310	0.0000	0.0000;
	2541	1	4.104	2.2	0	0	1	1.0917648	14.106225	110	5	1.12	0.95	108.8747	0.6522	0.0000	0.0000;
	2542	2	9.208	2.5	0	0	1	1.1036101	13.174791	110	5	1.12	0.95	110.8710	-0.5139	0.0000	0.0000;
	2543	1	7.729	2.5	0	0	1	1.11053	14.817837	110	5	1.12	0.95	108.8259	0.1799	0.0000	0.0000;
	2544	2	10.008	2.5	0	0	1	1.1112795	14.250017	110	5	1.12	0.95	109.4061	-0.7167	0.0000	0.0000;
	2545	1	5.079	2	0	0	1	1.1126236	14.951061	110	5	1.12	0.95	108.3074	0.1855	0.0000	0.0000;
	2546	2	11.51	0	0	0	1	1.1130463	14.339235	110	5	1.12	0.95	109.2565	-0.7459	0.0000	0.0000;
	2547	2	15.513	2.5	0	0	1	1.1115009	14.262172	110	5	1.12	0.95	109.3836	-0.7132	0.0000	0.0000;
	2548	1	3.313	1.3	0	0	1	1.0749448	21.727316	110	5	1.12	0.95	106.2172	1.4469	0.0000	0.0000;
	2549	1	3.002	1	0	0	1	1.0738733	10.574647	110	5	1.12	0.95	113.4803	0.6843	0.0000	0.0000;
	2550	1	7.729	2.5	0	0	1	1.0724941	21.418146	110	5	1.12	0.95	106.5870	1.5072	0.0000	0.0000;
	2551	1	11.51	1.5	0	0	1	1.0733564	10.333067	110	5	1.12	0.95	113.7149	0.6510	0.0000	0.0000;
	2552	1	7.106	1.2	0	0	1	1.0701039	12.57047	110	5	1.12	0.95	112.4188	1.4380	0.0000	0.0000;
	2553	1	9.937	2.6	0	0	1	1.1182622	15.505664	110	5	1.12	0.95	107.4376	-0.0420	0.0000	0.0000;
	2554	2	132.71	73.4	0	0	1	1.0692394	12.187693	110	5	1.12	0.95	112.2684	2.1387	0.0000	0.0000;
	2555	1	5.407	1.3	0	0	1	1.0927341	14.526386	110	5	1.12	0.95	109.2813	0.7052	0.0000	0.0000;
	2556	2	6.405	1.8	0	0	1	1.0694398	12.123819	110	5	1.12	0.95	112.3365	2.0900	0.0000	0.0000;
	2557	2	7.506	2.5	0	0	1	1.1111952	14.283876	110	5	1.12	0.95	109.4041	-0.7669	0.0000	0.0000;
	2558	1	3.455	0.7	0	0	1	1.1062882	14.292711	110	5	1.12	0.95	109.0508	0.6406	0.0000	0.0000;
	2559	1	8.411	0.8	0	0	1	1.087193	18.178652	110	5	1.12	0.95	107.4922	0.7588	0.0000	0.0000;
	2560	1	0	0	0	0	1	1.0908731	14.626137	110	5	1.12	0.95	109.1149	0.7065	0.0000	0.0000;
	2561	1	9.763	3.7	0	0	1	1.0932055	17.845908	110	5	1.12	0.95	106.2907	0.6957	0.0000	0.0000;
	2562	1	10.008	2.7	0	0	1	1.0796825	12.442255	110	5	1.12	0.95	111.7526	1.2720	0.0000	0.0000;
	2563	2	10.008	1	0	0	1	1.1098894	15.808737	110	5	1.12	0.95	108.0509	-0.1904	0.0000	0.0000;
	2564	2	7.006	1	0	0	1	1.1095372	15.828563	110	5	1.12	0.95	108.0614	-0.1734	0.0000	0.0000;
	2565	1	0.315	0	0	0	1	1.0899004	13.555479	110	5	1.12	0.95	109.9450	0.9138	0.0000	0.0000;
	2566	1	14.42	3.9	0	0	1	1.0847638	15.121053	110	5	1.12	0.95	109.3905	1.1050	0.0000	0.0000;
	2567	1	4.946	1.2	0	0	1	1.0943601	14.305899	110	5	1.12	0.95	108.5894	0.5684	0.0000	0.0000;
	2568	2	6.505	1.5	0	0	1	1.0822908	11.874671	110	5	1.12	0.95	111.3591	0.7791	0.0000	0.0000;
	2569	1	4.056	1.1	0	0	1	1.1029861	14.717717	110	5	1.12	0.95	108.8134	0.5306	0.0000	0.0000;
	2570	1	10.524	4.6	0	0	1	1.0931632	13.713299	110	5	1.12	0.95	109.8438	0.9049	0.0000	0.0000;
	2571	2	15.459	17.5	0	0	1	1.0706936	21.038933	110	5	1.12	0.95	106.8679	1.5391	0.0000	0.0000;
	2572	1	7.806	2.1	0	0	1	1.0636131	11.760713	110	5	1.12	0.95	113.2447	1.9847	0.0000	0.0000;
	2573	2	8.007	1	0	0	1	1.1144627	13.414801	110	5	1.12	0.95	110.7556	-1.0242	0.0000	0.0000;
	2574	2	6.405	1.6	0	0	1	1.0718387	12.014267	110	5	1.12	0.95	112.4068	1.8276	0.0000	0.0000;
	2575	1	10.839	4	0	0	1	1.0859936	13.402669	110	5	1.12	0.95	109.9436	0.8780	0.0000	0.0000;
	2576	1	3.002	2	0	0	1	1.0705966	12.250237	110	5	1.12	0.95	112.1748	1.4287	0.0000	0.0000;
	2577	1	0.902	0.1	0	0	1	1.1156848	14.956375	110	5	1.12	0.95	108.1428	0.3746	0.0000	0.0000;
	2578	2	6.294	2.5	0	0	1	1.0835467	20.361533	110	5	1.12	0.95	105.4644	0.9885	0.0000	0.0000;
	2579	1	7.998	2	0	0	1	1.0942779	14.298572	110	5	1.12	0.95	108.5986	0.5706	0.0000	0.0000;
	2580	1	11.51	1.5	0	0	1	1.0733645	10.482666	110	5	1.12	0.95	113.5106	0.7113	0.0000	0.0000;
	2581	1	13.011	4	0	0	1	1.0755154	12.516299	110	5	1.12	0.95	111.4898	1.2403	0.0000	0.0000;
	2582	2	9.386	3	0	0	1	1.0689302	20.820901	110	5	1.12	0.95	107.1452	1.5698	0.0000	0.0000;
	2583	1	9.386	3.5	0	0	1	1.1127234	14.328875	110	5	1.12	0.95	108.9692	0.0376	0.0000	0.0000;
	2584	1	7.006	0.8	0	0	1	1.0840273	13.639562	110	5	1.12	0.95	110.8507	0.6315	0.0000	0.0000;
	2585	1	12.017	3.1	0	0	1	1.0778545	12.605267	110	5	1.12	0.95	111.7919	1.4563	0.0000	0.0000;
	2586	1	4.504	1.3	0	0	1	1.0728592	12.787633	110	5	1.12	0.95	111.9414	1.3778	0.0000	0.0000;
	2587	1	1.988	0.7	0	0	1	1.1148799	15.226346	110	5	1.12	0.95	107.8251	0.0557	0.0000	0.0000;
	2588	1	3.754	1.2	0	0	1	1.0720855	20.85804	110	5	1.12	0.95	106.8010	1.4318	0.0000	0.0000;
	2589	2	2.002	0.4	0	0	1	1.1169334	14.247723	110	5	1.12	0.95	109.4989	-1.2169	0.0000	0.0000;
	2590	1	5.366	0.2	0	0	1	1.0889187	14.366706	110	5	1.12	0.95	109.4762	0.7002	0.0000	0.0000;
	2591	1	13.89	1.3	0	0	1	1.0888093	13.800532	110	5	1.12	0.95	109.3668	0.6873	0.0000	0.0000;
	2592	1	0	0	0	0	1	1.0906511	13.566722	110	5	1.12	0.95	109.5834	0.7070	0.0000	0.0000;
	2593	1	0	0	0	0	1	1.0907356	13.596108	110	5	1.12	0.95	109.5652	0.7043	0.0000	0.0000;
	2594	1	11.009	2.5	0	0	1	1.0887212	13.161693	110	5	1.12	0.95	110.0927	0.6758	0.0000	0.0000;
	2595	1	5.77	1.2	0	0	1	1.0887223	13.158255	110	5	1.12	0.95	110.0908	0.6752	0.0000	0.0000;
	2596	1	7.006	1.5	0	0	1	1.0858146	13.435773	110	5	1.12	0.95	110.5017	0.6728	0.0000	0.0000;
	2597	1	14.417	2.9	0	0	1	1.0919866	14.021489	110	5	1.12	0.95	108.9598	0.6108	0.0000	0.0000;
	2598	1	12.01	3	0	0	1	1.0843936	12.871717	110	5	1.12	0.95	110.6222	0.8290	0.0000	0.0000;
	2599	1	5.893	1.2	0	0	1	1.1139386	17.22177	110	5	1.12	0.95	106.6597	0.0289	0.0000	0.0000;
	2600	1	8.007	2	0	0	1	1.0879931	13.111266	110	5	1.12	0.95	110.1906	0.6993	0.0000	0.0000;
	2601	1	16.514	3	0	0	1	1.0814544	12.589854	110	5	1.12	0.95	111.1860	1.0886	0.0000	0.0000;
	2602	1	1.801	0.4	0	0	1	1.0776319	12.426716	110	5	1.12	0.95	111.6746	1.0130	0.0000	0.0000;
	2603	1	2.002	1	0	0	1	1.1122919	13.540826	110	5	1.12	0.95	110.7147	-1.1028	0.0000	0.0000;
	2604	1	13.25	4	0	0	1	1.1160915	15.008515	110	5	1.12	0.95	108.1798	0.0703	0.0000	0.0000;
	2605	1	5.004	1.7	0	0	1	1.0847456	12.912789	110	5	1.12	0.95	110.5796	0.8249	0.0000	0.0000;
	2606	2	9.508	3	0	0	1	1.0851626	12.914141	110	5	1.12	0.95	110.5195	0.7991	0.0000	0.0000;
	2607	1	18.015	5	0	0	1	1.0855989	12.982251	110	5	1.12	0.95	110.4740	0.8012	0.0000	0.0000;
	2608	1	5.852	2	0	0	1	1.0733987	20.9406	110	5	1.12	0.95	106.6281	1.3930	0.0000	0.0000;
	2609	1	4.417	1.8	0	0	1	1.0733305	20.954959	110	5	1.12	0.95	106.6400	1.3939	0.0000	0.0000;
	2610	1	11.892	2	0	0	1	1.0903537	13.827338	110	5	1.12	0.95	109.2692	0.6152	0.0000	0.0000;
	2611	1	0.149	0.1	0	0	1	1.0866325	12.920508	110	5	1.12	0.95	111.0556	1.1260	0.0000	0.0000;
	2612	1	3.002	0.5	0	0	1	1.1165374	15.260821	110	5	1.12	0.95	108.1700	-1.3717	0.0000	0.0000;
	2613	1	12.768	3.6	0	0	1	1.09028	23.786905	110	5	1.12	0.95	104.2313	1.0001	0.0000	0.0000;
	2614	1	7.606	2.4	0	0	1	1.0670112	12.07072	110	5	1.12	0.95	112.7448	1.5626	0.0000	0.0000;
	2615	1	0	0	0	0	1	1.0670473	12.07314	110	5	1.12	0.95	112.7401	1.5615	0.0000	0.0000;
	2616	1	2.105	0.6	0	0	1	1.0871308	13.453112	110	5	1.12	0.95	109.9559	0.9147	0.0000	0.0000;
	2617	1	3.473	0.8	0	0	1	1.0913549	14.192959	110	5	1.12	0.95	109.0195	0.7359	0.0000	0.0000;
	2618	1	5.261	1.8	0	0	1	1.0881253	13.723618	110	5	1.12	0.95	109.4708	0.6979	0.0000	0.0000;
	2619	1	2.302	0.8	0	0	1	1.0677859	12.217175	110	5	1.12	0.95	112.8659	1.5088	0.0000	0.0000;
	2620	1	4.704	1.5	0	0	1	1.1140379	12.731156	110	5	1.12	0.95	111.3397	-1.0149	0.0000	0.0000;
	2621	1	1.683	0.5	0	0	1	1.0933584	14.27361	110	5	1.12	0.95	108.7277	0.5983	0.0000	0.0000;
	2622	1	9.05	2.8	0	0	1	1.0901757	13.967931	110	5	1.12	0.95	109.1587	0.6668	0.0000	0.0000;
	2623	1	3.604	0.2	0	0	1	1.0846658	14.244098	110	5	1.12	0.95	109.7546	0.7934	0.0000	0.0000;
	2624	1	4.195	1.9	0	0	1	1.0711635	20.366023	110	5	1.12	0.95	106.8983	1.4256	0.0000	0.0000;
	2625	2	1.201	0.4	0	0	1	1.0735394	12.257046	110	5	1.12	0.95	112.1992	1.1618	0.0000	0.0000;
	2626	1	2.209	0.5	0	0	1	1.1098142	14.489614	110	5	1.12	0.95	109.3304	0.1854	0.0000	0.0000;
	2627	1	0.149	0.1	0	0	1	1.0797285	14.156443	110	5	1.12	0.95	110.7013	1.2677	0.0000	0.0000;
	2628	2	10.839	4.2	0	0	1	1.0893984	13.817003	110	5	1.12	0.95	109.2484	0.6792	0.0000	0.0000;
	2629	1	4.858	2	0	0	1	1.1116085	14.022577	110	5	1.12	0.95	109.1359	0.0758	0.0000	0.0000;
	2630	1	6.073	1.8	0	0	1	1.1105156	14.678328	110	5	1.12	0.95	108.6197	0.2776	0.0000	0.0000;
	2631	1	12.146	3.5	0	0	1	1.0710103	20.930955	110	5	1.12	0.95	106.8744	1.5007	0.0000	0.0000;
	2632	2	27.361	6.5	0	0	1	1.0946343	14.303778	110	5	1.12	0.95	108.5694	0.5613	0.0000	0.0000;
	2633	1	0	0	0	0	1	1.0963337	14.534806	110	5	1.12	0.95	108.2627	0.5538	0.0000	0.0000;
	2634	2	7.506	1.7	0	0	1	1.0634727	11.76844	110	5	1.12	0.95	113.2844	1.9502	0.0000	0.0000;
	2635	1	13.049	1.4	0	0	1	1.086498	14.070405	110	5	1.12	0.95	109.8392	0.7480	0.0000	0.0000;
	2636	1	16.943	6.1	0	0	1	1.0954974	15.273611	110	5	1.12	0.95	108.6502	0.5516	0.0000	0.0000;
	2637	1	4.003	1	0	0	1	1.0707727	10.158379	110	5	1.12	0.95	114.1825	0.7067	0.0000	0.0000;
	2638	1	0	0	0	0	1	1.1199805	15.587702	110	5	1.12	0.95	107.2891	-0.1231	0.0000	0.0000;
	2639	1	18.025	4.2	0	0	1	1.087473	14.594465	110	5	1.12	0.95	109.2699	0.7755	0.0000	0.0000;
	2640	1	7.998	3	0	0	1	1.0929894	14.865885	110	5	1.12	0.95	108.9107	0.6097	0.0000	0.0000;
	2641	1	2.981	1.3	0	0	1	1.1021624	13.931782	110	5	1.12	0.95	110.4912	0.3574	0.0000	0.0000;
	2642	1	13.25	5	0	0	1	1.1146416	15.232469	110	5	1.12	0.95	107.8352	0.1072	0.0000	0.0000;
	2643	2	5.788	1.4	0	0	1	1.0893076	13.640752	110	5	1.12	0.95	109.5488	0.5787	0.0000	0.0000;
	2644	1	10.514	3	0	0	1	1.0778096	13.700098	110	5	1.12	0.95	111.1706	1.3710	0.0000	0.0000;
	2645	1	4.205	0.6	0	0	1	1.1172351	15.048472	110	5	1.12	0.95	107.9466	0.3390	0.0000	0.0000;
	2646	1	19.875	7	0	0	1	1.0729643	20.542451	110	5	1.12	0.95	106.6713	1.3771	0.0000	0.0000;
	2647	1	8.061	2.5	0	0	1	1.1155767	15.295817	110	5	1.12	0.95	107.7181	0.0447	0.0000	0.0000;
	2648	2	33.027	6	0	0	1	1.0873466	9.6084395	110	5	1.12	0.95	115.1303	-0.2673	0.0000	0.0000;
	2649	2	15.012	1.5	0	0	1	1.0890961	9.8004025	110	5	1.12	0.95	114.9094	-0.3077	0.0000	0.0000;
	2650	1	0	0	0	0	1	1.1144813	12.725947	110	5	1.12	0.95	111.3395	-1.0351	0.0000	0.0000;
	2651	2	10.008	2.5	0	0	1	1.1054032	13.279779	110	5	1.12	0.95	110.7812	-0.5710	0.0000	0.0000;
	2652	1	6.514	2.6	0	0	1	1.0986338	13.740737	110	5	1.12	0.95	110.9610	0.4538	0.0000	0.0000;
	2653	2	14.012	1	0	0	1	1.1179943	15.219359	110	5	1.12	0.95	108.0124	-1.4899	0.0000	0.0000;
	2654	2	5.505	1.5	0	0	1	1.1117826	14.532775	110	5	1.12	0.95	109.1148	-0.9772	0.0000	0.0000;
	2655	2	2.002	0	0	0	1	1.0838097	9.0411107	110	5	1.12	0.95	116.5104	-0.5411	0.0000	0.0000;
	2656	1	7.893	4	0	0	1	1.0464854	11.004241	110	5	1.12	0.95	115.5422	2.3994	0.0000	0.0000;
	2657	1	5.683	3.1	0	0	1	1.0572721	11.225244	110	5	1.12	0.95	114.0455	1.8018	0.0000	0.0000;
	2658	2	5.505	1	0	0	1	1.1145157	14.935256	110	5	1.12	0.95	108.5106	-1.2361	0.0000	0.0000;
	2659	1	5.505	0.5	0	0	1	1.1132016	14.887322	110	5	1.12	0.95	108.9577	-1.1924	0.0000	0.0000;
	2660	1	0	0	0	0	1	1.1199814	15.783835	110	5	1.12	0.95	107.4328	-1.6425	0.0000	0.0000;
	2661	1	0	0	0	0	1	1.12	15.758321	110	5	1.12	0.95	107.4345	-1.6699	5200.7685	0.0000;
	2662	2	7.506	0.5	0	0	1	1.1152421	14.798582	110	5	1.12	0.95	108.9092	-1.3764	0.0000	0.0000;
	2663	1	7.006	0.5	0	0	1	1.1152913	14.796984	110	5	1.12	0.95	108.9074	-1.3753	0.0000	0.0000;
	2664	1	5.407	0.7	0	0	1	1.1148477	14.899153	110	5	1.12	0.95	108.2369	0.3913	0.0000	0.0000;
	2665	1	15.154	3.6	0	0	1	1.0874717	13.636837	110	5	1.12	0.95	109.5874	0.7015	0.0000	0.0000;
	2666	1	0.105	0	0	0	1	1.08948	13.755453	110	5	1.12	0.95	109.3498	0.6398	0.0000	0.0000;
	2667	2	21.889	2.8	0	0	1	1.0623056	11.358061	110	5	1.12	0.95	113.3784	1.5813	0.0000	0.0000;
	2668	2	7.006	1	0	0	1	1.1156769	14.891058	110	5	1.12	0.95	108.7188	-1.4003	0.0000	0.0000;
	2669	1	0.105	0	0	0	1	1.0907621	13.961842	110	5	1.12	0.95	109.0314	0.6618	0.0000	0.0000;
	2670	1	18.015	4	0	0	1	1.0719282	12.158229	110	5	1.12	0.95	113.6553	0.7116	0.0000	0.0000;
	2671	1	5.261	1.3	0	0	1	1.0868318	14.190142	110	5	1.12	0.95	109.7751	0.7554	0.0000	0.0000;
	2672	1	5.521	2	0	0	1	1.0965683	24.176147	110	5	1.12	0.95	103.5276	0.7661	0.0000	0.0000;
	2673	1	5.051	2	0	0	1	1.0878321	13.466756	110	5	1.12	0.95	109.9973	0.9280	0.0000	0.0000;
	2674	2	4.604	1.1	0	0	1	1.0763292	12.166462	110	5	1.12	0.95	112.1295	1.5033	0.0000	0.0000;
	2675	2	91.646	33	0	0	1	1.1115402	13.99222	110	5	1.12	0.95	109.1660	0.0580	0.0000	0.0000;
	2676	1	3.305	1	0	0	1	1.1168981	15.038162	110	5	1.12	0.95	108.0139	0.3528	0.0000	0.0000;
	2677	1	3.644	1.2	0	0	1	1.1138717	14.878014	110	5	1.12	0.95	108.6045	0.1213	0.0000	0.0000;
	2678	1	16.1	5	0	0	1	1.0866609	13.459983	110	5	1.12	0.95	109.8808	0.8957	0.0000	0.0000;
	2679	1	10.514	2	0	0	1	1.089864	14.675445	110	5	1.12	0.95	109.0364	0.7153	0.0000	0.0000;
	2680	1	0	0	0	0	1	1.089977	14.686179	110	5	1.12	0.95	109.0288	0.7136	0.0000	0.0000;
	2681	2	8.419	2.4	0	0	1	1.0871547	14.213337	110	5	1.12	0.95	109.7249	0.7467	0.0000	0.0000;
	2682	1	10.365	1.9	0	0	1	1.0881231	14.536239	110	5	1.12	0.95	109.2533	0.7500	0.0000	0.0000;
	2683	1	7.811	2.7	0	0	1	1.0882637	14.598042	110	5	1.12	0.95	109.2007	0.7516	0.0000	0.0000;
	2684	2	5.858	1.4	0	0	1	1.0852076	14.271428	110	5	1.12	0.95	109.6769	0.7821	0.0000	0.0000;
	2685	1	11.115	1.2	0	0	1	1.082817	14.233901	110	5	1.12	0.95	109.9171	0.8237	0.0000	0.0000;
	2686	1	8.281	2.5	0	0	1	1.0801006	20.17674	110	5	1.12	0.95	105.9310	1.1145	0.0000	0.0000;
	2687	1	9.463	2.3	0	0	1	1.0876911	14.511173	110	5	1.12	0.95	109.3176	0.7637	0.0000	0.0000;
	2688	1	9.386	3	0	0	1	1.0871076	13.085108	110	5	1.12	0.95	112.7937	0.9141	0.0000	0.0000;
	2689	1	3.305	1.1	0	0	1	1.084539	14.182741	110	5	1.12	0.95	109.7526	0.8157	0.0000	0.0000;
	2690	2	11.51	2	0	0	1	1.1173899	15.502753	110	5	1.12	0.95	107.9095	-1.5268	0.0000	0.0000;
	2691	2	6.505	1.5	0	0	1	1.1073271	13.62891	110	5	1.12	0.95	110.2219	-0.5794	0.0000	0.0000;
	2692	1	10.814	3.7	0	0	1	1.0963337	14.581823	110	5	1.12	0.95	109.2652	0.6940	0.0000	0.0000;
	2693	1	21.046	5.1	0	0	1	1.102644	15.933234	110	5	1.12	0.95	107.7343	0.3328	0.0000	0.0000;
	2694	1	13.26	1.5	0	0	1	1.1016521	15.922372	110	5	1.12	0.95	107.9920	0.3735	0.0000	0.0000;
	2695	2	8.507	1.2	0	0	1	1.1107661	16.132077	110	5	1.12	0.95	107.6276	-0.0666	0.0000	0.0000;
	2696	1	14.417	3.1	0	0	1	1.0858468	13.808703	110	5	1.12	0.95	109.9356	0.7368	0.0000	0.0000;
	2697	1	6.308	2.6	0	0	1	1.0902891	15.819508	110	5	1.12	0.95	108.3900	0.7072	0.0000	0.0000;
	2698	1	16.372	6.2	0	0	1	1.0901834	15.823487	110	5	1.12	0.95	108.3919	0.7078	0.0000	0.0000;
	2699	1	6.073	2.4	0	0	1	1.105911	14.393789	110	5	1.12	0.95	108.9385	0.6125	0.0000	0.0000;
	2700	1	13.969	2.4	0	0	1	1.0871795	16.16118	110	5	1.12	0.95	108.1882	0.8987	0.0000	0.0000;
	2701	2	9.798	3.1	0	0	1	1.0895713	16.623235	110	5	1.12	0.95	107.7556	0.8253	0.0000	0.0000;
	2702	2	0	0	0	0	1	1.0894997	16.602348	110	5	1.12	0.95	107.7661	0.8303	0.0000	0.0000;
	2703	1	14.87	3.1	0	0	1	1.0867667	15.974899	110	5	1.12	0.95	108.4528	0.8438	0.0000	0.0000;
	2704	1	4.315	0.8	0	0	1	1.087761	13.614456	110	5	1.12	0.95	109.6078	0.6724	0.0000	0.0000;
	2705	1	0	0	0	0	1	1.084673	12.589568	110	5	1.12	0.95	110.8202	0.7391	0.0000	0.0000;
	2706	1	0	0	0	0	1	1.1165472	15.261675	110	5	1.12	0.95	108.1687	-1.3719	0.0000	0.0000;
	2707	1	0	0	0	0	1	1.087776	13.615739	110	5	1.12	0.95	109.6057	0.6720	0.0000	0.0000;
	2708	1	36.437	11	0	0	1	1.1172708	15.453628	110	5	1.12	0.95	107.5149	0.0023	0.0000	0.0000;
	2709	1	3.313	1	0	0	1	1.1173635	15.467344	110	5	1.12	0.95	107.5019	0.0035	0.0000	0.0000;
	2710	1	5.473	1.1	0	0	1	1.0914015	13.951303	110	5	1.12	0.95	109.0456	0.6207	0.0000	0.0000;
	2711	1	6.314	1.2	0	0	1	1.0925887	14.234226	110	5	1.12	0.95	108.8214	0.6193	0.0000	0.0000;
	2712	2	70.058	18.8	0	0	1	1.0876769	15.651012	110	5	1.12	0.95	108.8503	0.7523	0.0000	0.0000;
	2713	1	50.041	4.3	0	0	1	1.0877119	15.64988	110	5	1.12	0.95	108.8501	0.7478	0.0000	0.0000;
	2714	2	6.005	0	0	0	1	1.0755853	8.035656	110	5	1.12	0.95	118.7091	-0.7602	0.0000	0.0000;
	2715	1	13.611	4.4	0	0	1	1.0661083	12.228064	110	5	1.12	0.95	112.9866	1.6512	0.0000	0.0000;
	2716	2	12.698	4	0	0	1	1.0618729	20.214959	110	5	1.12	0.95	108.4949	1.7248	0.0000	0.0000;
	2717	1	0	0	0	0	1	1.1141351	17.265452	110	5	1.12	0.95	106.6048	0.0324	0.0000	0.0000;
	2718	1	0	0	0	0	1	1.1141923	17.277183	110	5	1.12	0.95	106.6017	0.0312	0.0000	0.0000;
	2719	2	12.698	4	0	0	1	1.1054888	14.139996	110	5	1.12	0.95	109.5362	0.4930	0.0000	0.0000;
	2720	2	0	0	0	0	1	1.1191315	13.582314	110	5	1.12	0.95	110.2007	-0.9581	0.0000	0.0000;
	2721	1	0	0	0	0	1	1.1191697	13.590983	110	5	1.12	0.95	110.1984	-0.9600	0.0000	0.0000;
	2722	1	1.501	0.5	0	0	1	1.1180009	13.383708	110	5	1.12	0.95	110.4534	-0.9699	0.0000	0.0000;
	2723	1	177.604	31.638	0	0	0	1.0311195	29.195602	400	0	1.05	0.95	100.3525	-0.0841	0.0000	0.0000;
	2724	1	431.5	10.504	0	0	0	1.0302489	27.798762	400	0	1.05	0.95	100.9982	-0.2578	0.0000	0.0000;
	2725	1	371.2	-75.565	0	0	0	1.100405	24.665174	220	0	1.11	0.95	104.2247	-0.3895	0.0000	0.0000;
	2726	1	136.331	-31.538	0	0	0	1.0048345	27.430044	400	0	1.05	0.95	100.5977	-0.0128	0.0000	0.0000;
	2727	2	0	0	0	0	3	1.0930186	32.852592	220	0	1.11	0.95	98.7722	-0.3868	0.0000	0.0000;
	2728	2	0	0	0	0	0	1.1083136	17.075284	220	0	1.11	0.95	108.5648	0.0627	0.0000	0.0000;
	2729	1	307.582	188.523	0	0	0	1.0208681	24.006596	400	0	1.05	0.95	102.7443	-0.6219	0.0000	0.0000;
	2730	2	0	0	0	0	3	1.12	30.720897	110	0	1.12	0.95	94.4316	0.0000	1357.2561	0.0000;
	2731	1	17	6	0	0	2	1.0673669	27.25041	110	0	1.12	0.95	102.9083	1.3252	0.0000	0.0000;
	2732	1	0	0	0	0	2	1.0674574	27.257434	110	0	1.12	0.95	102.9003	1.3224	0.0000	0.0000;
	2733	1	33	12	0	0	2	1.0661509	27.165882	110	0	1.12	0.95	103.0203	1.3669	0.0000	0.0000;
	2734	1	16	6	0	0	2	1.0661668	27.167551	110	0	1.12	0.95	103.0194	1.3666	0.0000	0.0000;
	2735	1	25	10	0	0	2	1.0510221	26.175934	110	0	1.12	0.95	104.4931	1.9674	0.0000	0.0000;
	2736	1	65	26	0	0	2	1.0416225	25.568521	110	0	1.12	0.95	105.3953	2.3414	0.0000	0.0000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf	mu_Pmax	mu_Pmin	mu_Qmax	mu_Qmin
mpc.gen = [
	17	0	0	120	-22	1.07106	241.9	0	210	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	17	0	0	120	-22	1.07106	233.2	0	200	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	26	370	-19	190	-19	1.09091	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	21.6882	0.0000	0.0000	0.0000;
	27	360	174.108	190	-19	1.09091	407.1	1	360	290	0	0	0	0	0	0	0	0	0	0	0	21.3519	0.0000	0.0000	0.0000;
	27	360	-19	190	-19	1.09091	407.1	1	360	290	0	0	0	0	0	0	0	0	0	0	0	21.3519	0.0000	0.0000	0.0000;
	27	370	-17.3049	190	-19	1.09091	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	21.3519	0.0000	0.0000	0.0000;
	26	370	144.893	190	-19	1.09091	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	21.6882	0.0000	0.0000	0.0000;
	28	370	-19	190	-19	1.02665	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.5073	0.0000	0.0000	0.0008;
	28	0	0	190	-19	1.02665	415.9	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	28	370	-19	190	-19	1.02665	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.5073	0.0000	0.0000	0.0008;
	29	0	0	190	-19	1.02665	415.9	0	370	290	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	29	370	8.93896	190	-19	1.02665	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.5040	0.0000	0.0000	0.0000;
	29	370	-19	190	-19	1.02665	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	22.5040	0.0000	0.0000	0.0000;
	42	130	-34	135	-34	1.09091	253.9	1	215	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.2073	0.0000	0.1316;
	42	0	0	130	-34	1.09091	242.7	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	42	110	-34	145	-34	1.09091	267.7	1	225	110	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.2073	0.0000	0.1316;
	43	120	-34	145	-34	1.09091	267.7	1	225	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.2132	0.0000	0.1325;
	43	130	-34	145	-34	1.09091	267.7	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.2132	0.0000	0.1325;
	43	0	0	130	-34	1.09091	242.7	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	44	433.768	-47	363	-47	1.01857	646.5	1	535	255	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0378;
	44	0	0	348	-100	1.01857	659.3	0	560	250	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	54	129	-1	104	-1	1.09116	247.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.4234	0.0000	1.0086;
	55	129	-16	130	-16	1.09114	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.4250	0.0000	1.0101;
	54	0	0	130	-16	1.09116	259.9	0	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	56	129	-16	130	-16	1.04039	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.1759	0.0000	1.1458;
	57	129	-16	130	-16	1.04036	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.1741	0.0000	1.1461;
	57	0	0	104	-1	1.04036	247.9	0	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	57	129	-16	130	-16	1.04036	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.1741	0.0000	1.1461;
	58	48.1	0	30	0	1.08754	66.5	1	48.1	48.1	0	0	0	0	0	0	0	0	0	0	0	102.0281	0.0000	0.0000	0.2262;
	77	225	56.4466	123	-15	1.09091	256.4	1	225	140	0	0	0	0	0	0	0	0	0	0	0	3.9088	0.0000	0.0000	0.0000;
	77	225	56.4466	123	-15	1.09091	256.4	1	225	140	0	0	0	0	0	0	0	0	0	0	0	3.9088	0.0000	0.0000	0.0000;
	78	0	0	123	-15	1.09091	252	0	220	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	78	225	0.0284002	123	-15	1.09091	256.4	1	225	140	0	0	0	0	0	0	0	0	0	0	0	3.9765	0.0000	0.0000	0.0000;
	78	225	0.0284002	123	-15	1.09091	256.4	1	225	140	0	0	0	0	0	0	0	0	0	0	0	3.9765	0.0000	0.0000	0.0000;
	81	380	-31	232	-31	1.02168	445.2	1	380	220	0	0	0	0	0	0	0	0	0	0	0	9.4011	0.0000	0.0000	0.0467;
	81	0	0	228	-30	1.02168	434.6	0	370	220	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	97	9	0	1	0	1.08955	12	1	9	9	0	0	0	0	0	0	0	0	0	0	0	99.6560	0.0000	0.0000	0.2413;
	97	6	0	1	0	1.08955	6.1	1	6	6	0	0	0	0	0	0	0	0	0	0	0	99.6560	0.0000	0.0000	0.2413;
	103	225	111.228	123	-15	1.08905	256.4	1	225	134	0	0	0	0	0	0	0	0	0	0	0	7.3283	0.0000	0.0000	0.0000;
	104	0	0	123	-15	1.08898	256.4	0	225	134	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	105	120	44.1891	80	-2	1.0875	144.2	1	120	79	0	0	0	0	0	0	0	0	0	0	0	5.7194	0.0000	0.0000	0.0000;
	106	0	0	80	-2	1.0874	144.2	0	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	115	0	0	90	-20	1.08993	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	116	120	-2	82	-2	1.08992	145.3	1	120	70	0	0	0	0	0	0	0	0	0	0	0	2.2769	0.0000	0.0000	0.0498;
	117	110	0	40	0	1.08788	117	1	110	80	0	0	0	0	0	0	0	0	0	0	0	0.5349	0.0000	0.0000	0.0505;
	124	215	-35	135	-35	1.09093	253.9	1	215	160	0	0	0	0	0	0	0	0	0	0	0	8.2193	0.0000	0.0000	0.0039;
	125	225	76.0784	140	-35	1.09091	265	1	225	140	0	0	0	0	0	0	0	0	0	0	0	8.2138	0.0000	0.0000	0.0000;
	125	215	-35	135	-35	1.09091	253.9	1	215	160	0	0	0	0	0	0	0	0	0	0	0	8.2138	0.0000	0.0000	0.0000;
	126	225	-40	140	-40	1.02511	265	1	225	140	0	0	0	0	0	0	0	0	0	0	0	8.6281	0.0000	0.0000	0.2925;
	126	0	0	137	-40	1.02511	259.2	0	220	160	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	131	125	40	40	-38	1.08591	131.2	1	125	0	0	0	0	0	0	0	0	0	0	0	0	100.4980	0.0000	0.1314	0.0000;
	131	0	0	40	-38	1.08591	131.2	0	125	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	132	0	0	40	-38	1.08371	131.2	0	125	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	132	0	0	40	-38	1.08371	131.2	0	125	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	133	0	0	90	0	1.09091	150	0	120	100	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	133	120	49.9848	90	0	1.09091	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	8.7867	0.0000	0.0000	0.0000;
	134	120	0	90	0	1.09091	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	8.7875	0.0000	0.0022	0.0000;
	145	0	0	12	0	1.08954	51.4	0	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	145	0	0	12	0	1.08954	51.4	0	50	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	146	0	0	90	0	1.08953	150	0	120	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	147	0	0	149	-48	1.08582	267.4	0	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	147	0	0	149	-48	1.08582	253.4	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	147	0	0	149	-48	1.08582	253.4	0	205	135	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	147	90	94.0447	149	-48	1.08582	267.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.1863	0.0000	0.0000;
	149	90	-23	123	-23	1.02501	253.8	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.4559	0.0000	0.1626;
	150	90	-48	149	-48	1.025	267.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.4562	0.0000	0.1620;
	150	0	0	123	-23	1.025	253.8	0	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	154	235	-53	149	-53	1.09091	278.3	1	235	94	0	0	0	0	0	0	0	0	0	0	0	1.3980	0.0000	0.0000	0.0784;
	154	0	0	149	-53	1.09091	278.3	0	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	154	261	0	120	0	1.09091	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0	1.3980	0.0000	0.0000	0.0784;
	154	0	0	132	-40	1.09091	292.5	0	261	104	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	0	0	120	0	1.09091	287.3	0	261	104	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	155	205	-22	117	-22	1.09091	236	1	205	130	0	0	0	0	0	0	0	0	0	0	0	1.4039	0.0000	0.0000	0.0748;
	155	206	-20	109	-20	1.09091	233.1	1	206	120	0	0	0	0	0	0	0	0	0	0	0	1.4039	0.0000	0.0000	0.0748;
	155	0	0	109	-20	1.09091	233.1	0	206	120	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	157	206	28.5083	109	-20	1.00076	233.1	1	206	120	0	0	0	0	0	0	0	0	0	0	0	1.7142	0.0000	0.0000	0.0000;
	163	0	0	104	-23	1.09091	225.4	0	200	150	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	163	200	64.6061	104	-23	1.09091	225.4	1	200	150	0	0	0	0	0	0	0	0	0	0	0	13.8449	0.0000	0.0000	0.0000;
	164	200	10.9272	104	-23	1.09091	225.4	1	200	150	0	0	0	0	0	0	0	0	0	0	0	13.8513	0.0000	0.0000	0.0000;
	164	200	104	104	-23	1.09091	225.4	1	200	150	0	0	0	0	0	0	0	0	0	0	0	13.8513	0.0000	0.0000	0.0000;
	179	170	65.6015	110	0	1.09091	219.5	1	170	170	0	0	0	0	0	0	0	0	0	0	0	105.1553	0.0000	0.0000	0.0000;
	204	179	-60	110	-60	1.025	210.1	1	179	0	0	0	0	0	0	0	0	0	0	0	0	107.0236	0.0000	0.0000	0.0006;
	204	179	110	110	-60	1.025	210.1	1	179	0	0	0	0	0	0	0	0	0	0	0	0	107.0236	0.0000	0.0000	0.0006;
	204	179	-60	110	-60	1.025	210.1	1	179	0	0	0	0	0	0	0	0	0	0	0	0	107.0236	0.0000	0.0000	0.0006;
	205	179	-14.8355	110	-60	1.025	210.1	1	179	0	0	0	0	0	0	0	0	0	0	0	0	107.0237	0.0000	0.0000	0.0000;
	214	35	0	20	0	1.09209	58.5	1	35	35	0	0	0	0	0	0	0	0	0	0	0	106.3528	0.0000	0.0000	0.0000;
	214	0	0	20	0	1.09209	53.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	214	0	0	20	0	1.09209	53.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	214	10	11.2737	20	0	1.09209	30.5	1	10	10	0	0	0	0	0	0	0	0	0	0	0	106.3528	0.0000	0.0000	0.0000;
	220	1.55	0.72928	1	0	1.08853	2.3	1	1.55	1.55	0	0	0	0	0	0	0	0	0	0	0	102.9820	0.0000	0.0000	0.0000;
	221	1.55	1	1	0	1.07119	2.3	1	1.55	1.55	0	0	0	0	0	0	0	0	0	0	0	102.1784	0.0000	0.1191	0.0000;
	239	7	6	6	0	1.05821	9.8	1	7	7	0	0	0	0	0	0	0	0	0	0	0	108.7679	0.0000	1.0653	0.0000;
	246	370	61.8297	190	-19	1.03937	415.9	1	370	290	0	0	0	0	0	0	0	0	0	0	0	21.8055	0.0000	0.0000	0.0000;
	309	0	0	7	0	1.08081	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	309	0	0	7	0	1.08081	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	309	11	7	7	4	1.08081	30.8	1	11	11	0	0	0	0	0	0	0	0	0	0	0	100.5960	0.0000	0.4579	0.0000;
	309	0	0	7	0	1.08081	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	309	0	0	6	0	1.08081	27.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	309	0	0	7	0	1.08081	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	309	0	0	7	0	1.08081	27.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	310	15	15	15	0	1.08142	36.7	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.0131	0.0000	0.2846	0.0000;
	310	0	0	15	0	1.08142	57	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	311	15	15	15	0	1.0633	36.7	1	15	15	0	0	0	0	0	0	0	0	0	0	0	102.2436	0.0000	0.6692	0.0000;
	311	0	0	15	0	1.0633	57	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	313	30	20	20	0	1.08629	53.9	1	30	30	0	0	0	0	0	0	0	0	0	0	0	100.1466	0.0000	0.4246	0.0000;
	313	0	0	20	0	1.08629	53.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	314	0	0	40	0	1.07946	107.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	322	2.5	3	3	0	1.08468	4.1	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	100.3025	0.0000	0.4638	0.0000;
	365	43.25	12	12	0	1.08196	47.8	1	43.25	43.25	0	0	0	0	0	0	0	0	0	0	0	105.1480	0.0000	0.1215	0.0000;
	366	43.25	12	12	0	1.06579	47.8	1	43.25	43.25	0	0	0	0	0	0	0	0	0	0	0	106.9522	0.0000	0.5644	0.0000;
	367	43.25	8.7805	12	0	1.08899	47.8	1	43.25	43.25	0	0	0	0	0	0	0	0	0	0	0	104.2165	0.0000	0.0000	0.0000;
	368	43.25	12	12	0	1.08537	47.8	1	43.25	43.25	0	0	0	0	0	0	0	0	0	0	0	106.1289	0.0000	0.5321	0.0000;
	385	140	40.9072	138	-47	1.09091	251.3	1	210	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	5.1947	0.0000	0.0000;
	385	0	0	10	0	1.09091	26.9	0	25	12	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	386	10	7.0916	10	0	1.0782	19.7	1	17	10	0	0	0	0	0	0	0	0	0	0	0	0.0000	4.0011	0.0000	0.0000;
	443	1.5	2	2	0	1.04966	3.6	1	1.5	1.5	0	0	0	0	0	0	0	0	0	0	0	100.0280	0.0000	0.3760	0.0000;
	452	5.21	2	2	0	1.07378	6.1	1	5.21	5.21	0	0	0	0	0	0	0	0	0	0	0	103.9109	0.0000	0.5886	0.0000;
	452	0	0	2	0	1.07378	6.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	485	1.4	0.7	0.7	0	1.05018	1.7	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	100.1099	0.0000	0.4896	0.0000;
	536	40	14	14	0	1.06099	53.9	1	40	40	0	0	0	0	0	0	0	0	0	0	0	106.7163	0.0000	1.3714	0.0000;
	536	0	0	14	0	1.06099	34.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	536	0	0	14	0	1.06099	34	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	536	0	0	14	0	1.06099	105.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	536	0	0	14	0	1.06099	105.9	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	537	25	17.5	17.5	0	1.05485	36.5	1	25	25	0	0	0	0	0	0	0	0	0	0	0	106.9421	0.0000	1.1885	0.0000;
	537	25	17.5	17.5	0	1.05485	35.6	1	25	25	0	0	0	0	0	0	0	0	0	0	0	106.9421	0.0000	1.1885	0.0000;
	537	0	0	17.5	0	1.05485	126.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	537	0	0	17.5	0	1.05485	106.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	551	1.4	0.7	0.7	0	1.05264	1.7	1	1.4	1.4	0	0	0	0	0	0	0	0	0	0	0	107.6947	0.0000	1.6230	0.0000;
	559	30	5	5	0	1.05731	34.4	1	30	30	0	0	0	0	0	0	0	0	0	0	0	107.1970	0.0000	1.4431	0.0000;
	559	0	0	5	0	1.05731	28.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	559	0	0	5	0	1.05731	26.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	559	0	0	5	0	1.05731	30.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	559	0	0	5	0	1.05731	34.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	560	30	5	5	0	1.05563	34.4	1	30	30	0	0	0	0	0	0	0	0	0	0	0	107.0075	0.0000	1.4200	0.0000;
	560	0	0	5	0	1.05563	34.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	560	0	0	5	0	1.05563	26.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	560	0	0	5	0	1.05563	34.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	573	1	4	4	0	1.07878	8.9	1	1	1	0	0	0	0	0	0	0	0	0	0	0	101.2170	0.0000	0.1598	0.0000;
	626	78	0	30	0	1.09062	97.7	1	78	78	0	0	0	0	0	0	0	0	0	0	0	98.9717	0.0000	0.0000	0.1920;
	626	30	0	30	0	1.09062	46.8	1	30	30	0	0	0	0	0	0	0	0	0	0	0	98.9717	0.0000	0.0000	0.1920;
	664	130	57.2913	145	-34	1.09109	267.7	1	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.8059	0.0000	0.0000;
	665	0	0	145	-34	1.09081	267.7	0	225	130	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	685	150	0	30	0	1.0956	182.5	1	150	150	0	0	0	0	0	0	0	0	0	0	0	100.9386	0.0000	0.0000	0.3032;
	685	50	0	30	0	1.0956	77.5	1	50	50	0	0	0	0	0	0	0	0	0	0	0	100.9386	0.0000	0.0000	0.3032;
	691	2.43	0	1.8	0	1.08826	3.1	1	2.43	2.43	0	0	0	0	0	0	0	0	0	0	0	101.7600	0.0000	0.0000	0.1916;
	716	1.47	0	1.3	0	1.0787	10.1	1	1.47	1.47	0	0	0	0	0	0	0	0	0	0	0	101.3106	0.0000	0.0000	0.3272;
	740	129	-16	130	-16	1.09091	259.9	1	225	129	0	0	0	0	0	0	0	0	0	0	0	0.0000	5.3836	0.0000	0.7237;
	763	86	0	30	0	1.07793	105.4	1	86	86	0	0	0	0	0	0	0	0	0	0	0	100.7861	0.0000	0.0000	0.7184;
	792	1	0.315172	1	0	1.05313	8.4	1	1	1	0	0	0	0	0	0	0	0	0	0	0	102.2924	0.0000	0.0000	0.0000;
	796	68.1	1.91188	23	0	1.06122	71.9	1	68.1	5	0	0	0	0	0	0	0	0	0	0	0	100.8896	0.0000	0.0000	0.0000;
	796	0	0	23	0	1.06122	71.9	0	68.1	5	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	796	0	0	11	0	1.06122	32.9	0	31	16	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	796	0	0	10	0	1.06122	32.6	0	31	16	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	807	0	0	10	0	1.08198	125.4	0	125	84	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	808	92	0	10	0	1.08715	125.4	1	125	92	0	0	0	0	0	0	0	0	0	0	0	0.0000	11.7016	0.0000	0.2155;
	845	15	0	8.1	0	1.07142	33	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.4845	0.0000	0.0000	0.3422;
	845	15	0	8.1	0	1.07142	33	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.4845	0.0000	0.0000	0.3422;
	845	0	0	0	0	1.07142	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	845	0	0	0	0	1.07142	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	877	35	12.9886	41.2	0	1.08527	87.7	1	35	35	0	0	0	0	0	0	0	0	0	0	0	99.6941	0.0000	0.0000	0.0000;
	900	0	0	45	-10	1.07146	65.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	900	50	20.7457	45	-10	1.07146	71.1	1	50	50	0	0	0	0	0	0	0	0	0	0	0	100.4491	0.0000	0.0000	0.0000;
	900	0	0	45	-10	1.07146	71.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	975	0	0	110	-40	1.07686	162.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	976	100	33.7466	110	-40	1.08609	162.2	1	100	100	0	0	0	0	0	0	0	0	0	0	0	99.8359	0.0000	0.0000	0.0000;
	980	0	0	0	0	1.08643	16.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1001	386	19.2843	240	-32	1.10276	454.5	1	386	220	0	0	0	0	0	0	0	0	0	0	0	8.2033	0.0000	0.0000	0.0000;
	1002	370	51.821	227	-30	1.09091	434.1	1	370	220	0	0	0	0	0	0	0	0	0	0	0	8.2850	0.0000	0.0000	0.0000;
	1006	6	1.447	1.447	0	1.08426	7.1	1	6	6	0	0	0	0	0	0	0	0	0	0	0	99.5548	0.0000	0.2022	0.0000;
	1005	4	0.447	0.447	0	1.08426	4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	99.5534	0.0000	0.2022	0.0000;
	1006	4	0.447	0.447	0	1.08426	5	1	4	4	0	0	0	0	0	0	0	0	0	0	0	99.5548	0.0000	0.2022	0.0000;
	1006	0	0	0	0	1.08426	6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1007	0	0	110	-40	1.08332	174.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1013	15	4.8	4.8	0	1.07931	20.6	1	15	15	0	0	0	0	0	0	0	0	0	0	0	99.3353	0.0000	0.1660	0.0000;
	1013	0	0	0	0	1.07931	12.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1013	0	0	0	0	1.07931	12.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1015	0	0	0	0	1.07594	20	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1015	0	0	0	0	1.07594	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1024	12	18	18	9	1.05936	30	1	12	12	0	0	0	0	0	0	0	0	0	0	0	102.5270	0.0000	0.6994	0.0000;
	1025	0	0	18	9	1.05941	30	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1026	0	0	14	10.5	1.05936	32.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1113	0	0	37.5	16.8	1.08345	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1114	0	0	37.5	7.5	1.07469	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1113	50	37.5	37.5	7.5	1.08345	62.5	1	50	50	0	0	0	0	0	0	0	0	0	0	0	100.1524	0.0000	0.0695	0.0000;
	1115	0	0	37.5	16.8	1.08094	62.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1152	17	5.251	5.251	0	1.06515	30.5	1	17	17	0	0	0	0	0	0	0	0	0	0	0	101.6968	0.0000	0.1697	0.0000;
	1152	0	0	0	0	1.06515	6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1153	17	5.251	5.251	0	1.06525	30.5	1	17	17	0	0	0	0	0	0	0	0	0	0	0	101.6830	0.0000	0.1664	0.0000;
	1153	0	0	0	0	1.06525	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1154	16	5.25	5.25	0	1.06879	30.5	1	16	16	0	0	0	0	0	0	0	0	0	0	0	101.0285	0.0000	0.0813	0.0000;
	1154	0	0	0	0	1.06879	6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1179	70	37.7826	52.5	0	1.08436	87.5	1	70	70	0	0	0	0	0	0	0	0	0	0	0	99.8463	0.0000	0.0000	0.0000;
	1180	0	0	52.5	0	1.07255	87.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1180	0	0	42	16.8	1.07255	65.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1188	50	0	0	0	1.0801	50	1	50	50	0	0	0	0	0	0	0	0	0	0	0	100.0495	0.0000	0.1646	0.0000;
	1246	10	2	2	0	1.07803	16.7	1	10	10	0	0	0	0	0	0	0	0	0	0	0	99.5205	0.0000	0.0913	0.0000;
	1246	0	0	0	0	1.07803	24	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1247	0	0	0	0	1.06772	14.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1247	0	0	0	0	1.06772	14.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1247	0	0	0	0	1.06772	14.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1248	0	0	0	0	1.0632	5.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1248	0	0	0	0	1.0632	5.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1286	0	0	41	-6.5	1.06402	68.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1287	230	75.6751	123	-15	1.09091	260.8	1	230	134	0	0	0	0	0	0	0	0	0	0	0	4.1833	0.0000	0.0000	0.0000;
	1288	0	0	123	-15	1.0806	256.4	0	225	134	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1342	20	4.019	5	0	1.08043	22.6	1	20	20	0	0	0	0	0	0	0	0	0	0	0	100.8780	0.0000	0.0000	0.0000;
	1343	0	0	0	0	1.08041	12	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1343	25	5	5	0	1.08041	32.4	1	25	25	0	0	0	0	0	0	0	0	0	0	0	100.8781	0.0000	0.0006	0.0000;
	1351	0	0	90	-5	1.08618	142.1	0	110	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1352	120	18.1025	80	-2	1.08646	144.2	1	120	79	0	0	0	0	0	0	0	0	0	0	0	5.3995	0.0000	0.0000	0.0000;
	1351	120	-2	80	-2	1.08618	144.2	1	120	79	0	0	0	0	0	0	0	0	0	0	0	5.1599	0.0000	0.0000	0.0584;
	1353	0	0	80	-2	1.08485	144.2	0	120	79	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1363	0	0	89	-6	1.08282	153.4	0	125	84	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1363	125	89	89	-6	1.08282	153.4	1	125	84	0	0	0	0	0	0	0	0	0	0	0	7.4936	0.0000	0.1410	0.0000;
	1374	100	40.7604	80	-25	1.06882	141.7	1	100	100	0	0	0	0	0	0	0	0	0	0	0	101.2518	0.0000	0.0000	0.0000;
	1374	0	0	80	-25	1.06882	128.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1375	0	0	80	-25	1.06874	143.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1376	0	0	80	-25	1.06338	136	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1414	0	0	33.5	12	1.07406	36.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1415	0	0	41.2	-13.7	1.07445	68.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1415	0	0	41.2	-13.7	1.07445	68.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1432	10	2	2	0	1.07168	12.2	1	10	10	0	0	0	0	0	0	0	0	0	0	0	101.0455	0.0000	0.6750	0.0000;
	1432	10	2	2	0	1.07168	12.2	1	10	10	0	0	0	0	0	0	0	0	0	0	0	101.0455	0.0000	0.6750	0.0000;
	1433	0	0	0	0	1.06697	4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1433	0	0	0	0	1.06697	4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1435	10	3.75	3.75	0	1.08184	15.5	1	10	10	0	0	0	0	0	0	0	0	0	0	0	99.8661	0.0000	0.3313	0.0000;
	1434	13	6.75	6.75	0	1.08027	23.5	1	13	13	0	0	0	0	0	0	0	0	0	0	0	100.0221	0.0000	0.3794	0.0000;
	1439	0	0	123	-15	1.08021	256.4	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1461	46	3.85745	35	-6	1.06082	57.8	1	46	3	0	0	0	0	0	0	0	0	0	0	0	101.0604	0.0000	0.0000	0.0000;
	1461	0	0	35	-6	1.06082	57.8	0	46	3	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1644	15	1.9	9.3	1.9	1.07026	17.6	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.3408	0.0000	0.0000	0.3906;
	1644	0	0	9.3	1.9	1.07026	17.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1644	15	1.9	9.3	1.9	1.07026	17.6	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.3408	0.0000	0.0000	0.3906;
	1644	15	1.934	9.3	1.934	1.07026	17.6	1	15	15	0	0	0	0	0	0	0	0	0	0	0	101.3408	0.0000	0.0000	0.3906;
	1644	0	0	0	0	1.07026	3.8	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1644	0	0	0	0	1.07026	4.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1672	153	44.3213	117	-29	1.08827	192.6	1	153	55	0	0	0	0	0	0	0	0	0	0	0	0.8279	0.0000	0.0000	0.0000;
	1673	0	0	82	-2	1.09018	152	0	128	70	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1673	153	22.129	117	-29	1.09018	192.6	1	153	55	0	0	0	0	0	0	0	0	0	0	0	0.8068	0.0000	0.0000	0.0000;
	1674	123	5.0062	82	-2	1.09091	147.8	1	123	70	0	0	0	0	0	0	0	0	0	0	0	1.3795	0.0000	0.0000	0.0000;
	1684	110	40.001	40.001	0	1.07552	117	1	110	80	0	0	0	0	0	0	0	0	0	0	0	0.7353	0.0000	0.0081	0.0000;
	1685	0	0	42	16.8	1.07191	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1685	0	0	40	0	1.07191	117	0	110	80	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1685	0	0	42	16.8	1.07191	61.6	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1685	110	26.2063	40	0	1.07191	117	1	110	80	0	0	0	0	0	0	0	0	0	0	0	1.0135	0.0000	0.0000	0.0000;
	1684	0	0	40	16	1.07552	60.2	0	45	30	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1776	0	0	6.6	0.7	1.07334	8.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1793	0	0	0	0	1.09269	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1793	20	0	4	0	1.09269	25.3	1	20	20	0	0	0	0	0	0	0	0	0	0	0	99.6290	0.0000	0.0000	0.9710;
	1793	0	0	0	0	1.09269	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1793	0	0	0	0	1.09269	25	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1794	39	26	26	13	1.08257	47.7	1	39	39	0	0	0	0	0	0	0	0	0	0	0	98.4302	0.0000	0.1463	0.0000;
	1836	225	57.6425	140	-35	1.09091	265	1	225	160	0	0	0	0	0	0	0	0	0	0	0	5.8778	0.0000	0.0000	0.0000;
	1836	0	0	140	-35	1.09091	265	0	225	140	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1838	225	126.785	140	-35	1.09091	265	1	225	160	0	0	0	0	0	0	0	0	0	0	0	7.6795	0.0000	0.0000	0.0000;
	1872	0	0	26	13	1.07359	43.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1872	0	0	8.3	1.5	1.07359	11.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1873	0	0	12	5.8	1.07393	27.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1873	0	0	26	13	1.07393	39.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1906	0	0	0	0	1.06366	32	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1907	0	0	0	0	1.06364	32	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1926	10	2.4	2.4	0	1.05755	10.8	1	10	10	0	0	0	0	0	0	0	0	0	0	0	102.3390	0.0000	0.8780	0.0000;
	1926	10	2.4	2.4	0	1.05755	10.8	1	10	10	0	0	0	0	0	0	0	0	0	0	0	102.3390	0.0000	0.8780	0.0000;
	1928	120	11.2483	90	0	1.09091	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	7.7964	0.0000	0.0000	0.0000;
	1929	120	44.6899	90	0	1.09091	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0	7.8063	0.0000	0.0000	0.0000;
	1944	1	0	0	0	1.09288	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	100.4230	0.0000	0.0000	0.0805;
	1947	1.2	0	0	0	1.11404	1.3	1	1.2	1.2	0	0	0	0	0	0	0	0	0	0	0	100.4392	0.0000	0.0000	4.4066;
	1957	0.2	0	0	0	1.09564	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	99.5758	0.0000	0.0000	0.0267;
	1962	0.1	0	0	0	1.11168	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	101.2909	0.0000	0.0000	4.1844;
	1964	17	0	15	0	1.08728	52.2	1	17	17	0	0	0	0	0	0	0	0	0	0	0	102.3845	0.0000	0.0000	0.5331;
	1964	0	0	15	0	1.08728	52.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1965	0	0	10	0	1.0868	33.5	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1991	90	13.15	149	-48	1.09091	267.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0	0.0000	7.5054	0.0000	0.0000;
	1997	0	0	8	0	1.08624	27.3	0	26.1	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	1997	27.3	8.001	8.001	0	1.08624	28.4	1	27.3	0	0	0	0	0	0	0	0	0	0	0	0	107.8609	0.0000	0.1322	0.0000;
	1997	0	0	8	0	1.08624	27.3	0	26.1	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2001	40	22.582	22.582	0	1.07864	59.5	1	40	40	0	0	0	0	0	0	0	0	0	0	0	108.6511	0.0000	0.1971	0.0000;
	2001	80	80	80	0	1.07864	128.1	1	80	80	0	0	0	0	0	0	0	0	0	0	0	108.6511	0.0000	0.1971	0.0000;
	2002	0	0	90	0	1.07069	150.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2007	0.4	0	0	0	1.0212	0.4	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	121.3498	0.0000	2.1519	0.0000;
	2014	0	0	10	0	1.07946	30.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2014	0	0	10	0	1.07946	30.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2014	25	12	12	0	1.07946	55.8	1	25	25	0	0	0	0	0	0	0	0	0	0	0	109.2413	0.0000	0.3357	0.0000;
	2015	0	0	2	0	1.07915	5.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2015	0	0	2	0	1.07915	6.3	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2035	14	0	0	0	1.07094	15.4	1	14	14	0	0	0	0	0	0	0	0	0	0	0	107.1041	0.0000	0.7838	0.0000;
	2039	8.5	0	0	0	1.08395	9.4	1	8.5	8.5	0	0	0	0	0	0	0	0	0	0	0	104.4830	0.0000	0.0000	1.1320;
	2041	120	87.021	90	0	1.08391	150	1	120	90	0	0	0	0	0	0	0	0	0	0	0	7.0961	0.0000	0.0000	0.0000;
	2046	0.1	0	0	0	1.11625	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	100.8925	0.0000	0.0000	3.2816;
	2056	1	0	0	0	1.04402	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	112.9582	0.0000	0.3611	0.0000;
	2063	0	0	1	0	1.06536	3.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2063	2	2	2	0	1.06536	4.5	1	2	2	0	0	0	0	0	0	0	0	0	0	0	104.5612	0.0000	0.4104	0.0000;
	2070	0.2	0	0	0	1.11114	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	101.5869	0.0000	0.0000	3.9567;
	2090	0	0	12	0	1.08324	51.4	0	50	25	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2090	50	12	12	0	1.08324	51.4	1	50	30	0	0	0	0	0	0	0	0	0	0	0	7.1140	0.0000	0.0101	0.0000;
	2091	28	2.65509	10	0	1.09027	29.7	1	28	20	0	0	0	0	0	0	0	0	0	0	0	5.2993	0.0000	0.0000	0.0000;
	2093	55	2.21011	12	0	1.03272	56.3	1	55	30	0	0	0	0	0	0	0	0	0	0	0	5.8250	0.0000	0.0000	0.0000;
	2096	3	0	0	0	1.06174	3.3	1	3	3	0	0	0	0	0	0	0	0	0	0	0	106.9975	0.0000	1.0738	0.0000;
	2118	4.5	0	0	0	1.05095	5	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	113.7556	0.0000	1.0447	0.0000;
	2140	1	0	0	0	1.09455	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	100.0278	0.0000	0.0000	0.0426;
	2175	0.8	0	0	0	1.08589	0.9	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	102.4341	0.0000	0.0000	0.3368;
	2202	0.8	0	0	0	1.04443	0.9	1	0.8	0.8	0	0	0	0	0	0	0	0	0	0	0	113.0107	0.0000	0.3199	0.0000;
	2203	0.2	0	0	0	1.07052	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	102.6627	0.0000	0.2587	0.0000;
	2208	4.5	0	0	0	1.08892	5	1	4.5	4.5	0	0	0	0	0	0	0	0	0	0	0	102.9973	0.0000	0.0777	0.0000;
	2214	200	30.758	104	-23	1.09091	225.4	1	200	150	0	0	0	0	0	0	0	0	0	0	0	11.7487	0.0000	0.0000	0.0000;
	2215	200	54.0848	111	-18	1.09091	228.7	1	200	150	0	0	0	0	0	0	0	0	0	0	0	12.5207	0.0000	0.0000	0.0000;
	2228	0.4	0	0	0	1.04849	0.4	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	111.8907	0.0000	0.3690	0.0000;
	2235	14.5	0	0	0	0.99336	16	1	14.5	14.5	0	0	0	0	0	0	0	0	0	0	0	110.7010	0.0000	0.2171	0.0000;
	2253	50	15	15	0	1.07591	66.7	1	50	50	0	0	0	0	0	0	0	0	0	0	0	111.4547	0.0000	0.3080	0.0000;
	2254	0	0	15	0	1.07582	66.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2265	2	0	0	0	1.08858	2.2	1	2	2	0	0	0	0	0	0	0	0	0	0	0	101.8781	0.0000	0.0000	0.3259;
	2277	4	0	0	0	1.01388	4.4	1	4	4	0	0	0	0	0	0	0	0	0	0	0	123.1361	0.0000	1.8340	0.0000;
	2293	1	0	0	0	1.07489	1.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	111.7314	0.0000	0.2467	0.0000;
	2295	0.2	0	0	0	1.11741	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	100.9020	0.0000	0.0000	1.9563;
	2296	0.2	0	0	0	1.07279	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	110.6666	0.0000	0.2450	0.0000;
	2328	0	0	15	0	1.07527	58	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2328	0	0	6	0	1.07527	19	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2328	2	2	2	0	1.07527	4.5	1	2	2	0	0	0	0	0	0	0	0	0	0	0	111.5607	0.0000	0.3225	0.0000;
	2331	0.1	0	0	0	1.01509	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	122.3190	0.0000	2.3194	0.0000;
	2343	190.183	42.2312	149	-53	1.09091	278.3	1	235	94	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2354	0	0	15	0	1.09091	52.2	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2354	72.5	0	80	0	1.09091	128.1	1	72.5	72.5	0	0	0	0	0	0	0	0	0	0	0	100.6177	0.0000	0.0000	0.2455;
	2355	0	0	80	0	1.08838	128.1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2360	4.4	0	0	0	1.11774	4.8	1	4.4	4.4	0	0	0	0	0	0	0	0	0	0	0	100.8105	0.0000	0.0000	1.9427;
	2366	2.5	0	0	0	1.09178	2.8	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	102.6864	0.0000	0.0000	0.1049;
	2370	0.2	0	0	0	1.08549	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	103.0367	0.0000	0.0000	0.6647;
	2431	3	3.62207	10	-0.001	1.09117	14.5	1	3	3	0	0	0	0	0	0	0	0	0	0	0	106.8471	0.0000	0.0000	0.0000;
	2431	0	0	10	0	1.09117	15.6	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2438	0.5	0	0	0	1.0503	0.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	113.2771	0.0000	0.3541	0.0000;
	2448	0.6	0.2	0.2	0	1.07557	0.7	1	0.6	0.6	0	0	0	0	0	0	0	0	0	0	0	108.6210	0.0000	0.5985	0.0000;
	2451	65	9.09955	15	0	1.09508	71.6	1	65	65	0	0	0	0	0	0	0	0	0	0	0	107.4897	0.0000	0.0000	0.0000;
	2453	0.1	0	1.6	0	1.11497	1.6	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	110.1101	0.0000	0.0000	0.7033;
	2459	0.6	0.2	0.2	0	1.04966	0.7	1	0.6	0.6	0	0	0	0	0	0	0	0	0	0	0	112.7517	0.0000	1.3854	0.0000;
	2467	0.3	0	2.4	0	1.11498	2.4	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	110.6900	0.0000	0.0000	1.2017;
	2470	29	5	5	0	1.07693	32.3	1	29	29	0	0	0	0	0	0	0	0	0	0	0	108.9828	0.0000	0.6192	0.0000;
	2471	0	0	0	0	1.0769	22	1	0	0	0	0	0	0	0	0	0	0	0	0	0	108.9947	0.0000	0.6210	0.0000;
	2480	0	0	1.1	0	1.09547	1.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	118.7231	0.0000	0.0000	0.7603;
	2481	0.2	1.4	1.4	0	1.04968	1.4	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	115.5815	0.0000	0.8679	0.0000;
	2482	0.3	0	0.1	0	1.10628	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	108.5845	0.0000	0.0000	0.6708;
	2483	0.5	0	0.1	0	1.11616	0.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	109.4566	0.0000	0.0000	1.3399;
	2485	0	0	2.1	0	1.09583	2.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	118.9544	0.0000	0.0000	0.7860;
	2488	4	0	3.3	0	1.11879	5.5	1	4	4	0	0	0	0	0	0	0	0	0	0	0	108.3934	0.0000	0.0000	1.1658;
	2491	12	3	3	0	1.04774	13.5	1	12	12	0	0	0	0	0	0	0	0	0	0	0	112.9051	0.0000	1.6178	0.0000;
	2497	3.5	0	1	0	1.11633	4	1	3.5	3.5	0	0	0	0	0	0	0	0	0	0	0	110.0081	0.0000	0.0000	1.2688;
	2500	40	5	5	0	1.07499	40.3	1	40	40	0	0	0	0	0	0	0	0	0	0	0	108.7672	0.0000	0.6098	0.0000;
	2509	0	1.2	1.2	0	1.03757	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	107.4214	0.0000	1.6338	0.0000;
	2511	0	0	2	0	1.11276	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.8242	0.0000	0.0000	0.5806;
	2523	0	0	1.4	0	1.11627	1.4	1	0	0	0	0	0	0	0	0	0	0	0	0	0	111.0404	0.0000	0.0000	0.9855;
	2526	4	1.5	1.5	0	1.09412	4.6	1	4	4	0	0	0	0	0	0	0	0	0	0	0	107.7277	0.0000	0.0022	0.0000;
	2529	23	20	20	0	1.04771	32.3	1	23	23	0	0	0	0	0	0	0	0	0	0	0	106.2248	0.0000	1.2994	0.0000;
	2536	10	1	1	0	1.08949	11	1	10	10	0	0	0	0	0	0	0	0	0	0	0	108.4524	0.0000	0.1149	0.0000;
	2539	0	0	3.1	0	1.11183	3.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.9648	0.0000	0.0000	0.5053;
	2542	0	0	1.2	0	1.11202	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.8710	0.0000	0.0000	0.5139;
	2544	0	0	3.6	0	1.11573	3.6	1	0	0	0	0	0	0	0	0	0	0	0	0	0	109.4061	0.0000	0.0000	0.7167;
	2546	0.5	0	3.6	0	1.11714	3.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	109.2565	0.0000	0.0000	0.7459;
	2547	1	0	1.8	0	1.11582	2.1	1	1	1	0	0	0	0	0	0	0	0	0	0	0	109.3836	0.0000	0.0000	0.7132;
	2554	36	24	24	0	1.04292	46.3	1	36	36	0	0	0	0	0	0	0	0	0	0	0	112.2684	0.0000	2.1387	0.0000;
	2556	0	1	1	0	1.04308	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.3365	0.0000	2.0900	0.0000;
	2557	0	0	1.1	0	1.11561	1.1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	109.4041	0.0000	0.0000	0.7669;
	2563	0.1	0	1.7	0	1.1015	1.7	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	108.0509	0.0000	0.0000	0.1904;
	2564	0	0	0.9	0	1.1011	0.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	108.0614	0.0000	0.0000	0.1734;
	2568	0.2	0	0	0	1.05599	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	111.3591	0.0000	0.7791	0.0000;
	2571	5	10	10	0	1.04172	11.4	1	5	5	0	0	0	0	0	0	0	0	0	0	0	106.8679	0.0000	1.5391	0.0000;
	2573	0.4	0	1.9	0	1.11618	2	1	0.4	0.4	0	0	0	0	0	0	0	0	0	0	0	110.7556	0.0000	0.0000	1.0242;
	2574	0	1.3	1.3	0	1.04534	1.3	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.4068	0.0000	1.8276	0.0000;
	2578	0	0.8	0.8	0	1.05638	0.8	1	0	0	0	0	0	0	0	0	0	0	0	0	0	105.4644	0.0000	0.9885	0.0000;
	2582	0	2.5	2.5	0	1.03989	2.5	1	0	0	0	0	0	0	0	0	0	0	0	0	0	107.1452	0.0000	1.5698	0.0000;
	2589	0.5	0	0.1	0	1.117	0.6	1	0.5	0.5	0	0	0	0	0	0	0	0	0	0	0	109.4989	0.0000	0.0000	1.2169;
	2606	0.2	0.1	0.1	0	1.06004	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	110.5195	0.0000	0.7991	0.0000;
	2625	0.1	0.1	0.1	0	1.05348	0.1	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	112.1992	0.0000	1.1618	0.0000;
	2628	2.1	0	0	0	1.07122	2.3	1	2.1	2.1	0	0	0	0	0	0	0	0	0	0	0	109.2484	0.0000	0.6792	0.0000;
	2632	10.5	7.5	7.5	0	1.07606	13.8	1	10.5	10.5	0	0	0	0	0	0	0	0	0	0	0	108.5694	0.0000	0.5613	0.0000;
	2634	0.2	0.1	0.1	0	1.04103	0.2	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0	113.2844	0.0000	1.9502	0.0000;
	2643	0.3	0	0	0	1.07187	0.3	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0	109.5488	0.0000	0.5787	0.0000;
	2648	0	0	1.9	0	1.09755	1.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	115.1303	0.0000	0.0000	0.2673;
	2649	0	0	2	0	1.09906	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	114.9094	0.0000	0.0000	0.3077;
	2651	0	0	1.2	0	1.11097	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.7812	0.0000	0.0000	0.5710;
	2653	0.7	0	4.8	0	1.11762	4.9	1	0.7	0.7	0	0	0	0	0	0	0	0	0	0	0	108.0124	0.0000	0.0000	1.4899;
	2654	0	0	1.2	0	1.11517	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	109.1148	0.0000	0.0000	0.9772;
	2655	0	0	0.6	0	1.09794	0.6	1	0	0	0	0	0	0	0	0	0	0	0	0	0	116.5104	0.0000	0.0000	0.5411;
	2658	0	0	1.5	0	1.11614	1.5	1	0	0	0	0	0	0	0	0	0	0	0	0	0	108.5106	0.0000	0.0000	1.2361;
	2662	0	0	3.9	0	1.1155	3.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0	108.9092	0.0000	0.0000	1.3764;
	2667	1.3	0.5	0.5	0	1.04312	1.5	1	1.3	1.3	0	0	0	0	0	0	0	0	0	0	0	113.3784	0.0000	1.5813	0.0000;
	2668	0	0	2.3	0	1.1159	2.3	1	0	0	0	0	0	0	0	0	0	0	0	0	0	108.7188	0.0000	0.0000	1.4003;
	2674	0	1	1	0	1.0497	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	112.1295	0.0000	1.5033	0.0000;
	2675	55	35	35	0	1.08711	69.9	1	55	55	0	0	0	0	0	0	0	0	0	0	0	109.1660	0.0000	0.0580	0.0000;
	2681	2.5	0	0	0	1.07162	2.8	1	2.5	2.5	0	0	0	0	0	0	0	0	0	0	0	109.7249	0.0000	0.7467	0.0000;
	2684	2	1	1	0	1.061	2.4	1	2	2	0	0	0	0	0	0	0	0	0	0	0	109.6769	0.0000	0.7821	0.0000;
	2690	0	0	1.2	0	1.11672	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	107.9095	0.0000	0.0000	1.5268;
	2691	0	0	1.2	0	1.11388	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	110.2219	0.0000	0.0000	0.5794;
	2695	0.1	0	1.2	0	1.10096	1.2	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0	107.6276	0.0000	0.0000	0.0666;
	2701	25	2.5	2.5	0	1.06571	26.8	1	25	25	0	0	0	0	0	0	0	0	0	0	0	107.7556	0.0000	0.8253	0.0000;
	2701	25	2.5	2.5	0	1.06571	26.8	1	25	25	0	0	0	0	0	0	0	0	0	0	0	107.7556	0.0000	0.8253	0.0000;
	2701	0	0	0	0	1.06571	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2701	0	0	0	0	1.06571	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2702	0	0	0	0	1.06562	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2702	0	0	0	0	1.06562	26.7	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2712	20	14	14	0	1.06385	26.1	1	20	20	0	0	0	0	0	0	0	0	0	0	0	108.8503	0.0000	0.7523	0.0000;
	2714	0	0	1	0	1.09549	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	118.7091	0.0000	0.0000	0.7602;
	2716	0	1.2	1.2	0	1.03277	1.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0	108.4949	0.0000	1.7248	0.0000;
	2719	5.8	1.3	1.3	0	1.07988	6.5	1	5.8	5.8	0	0	0	0	0	0	0	0	0	0	0	109.5362	0.0000	0.4930	0.0000;
	2720	0	0	26	-18	1.11875	56.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2720	0	0	26	-18	1.11875	56.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	2720	0	0	26	-18	1.11875	56.4	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.0000	0.0000	0.0000	0.0000;
	450	6.8	0	0	0	1.07058	6.8	1	6.8	6.8	0	0	0	0	0	0	0	0	0	0	0	104.9704	0.0000	0.7549	0.0000;
	1166	0.7	0.144	0.144	0.144	1.06958	0.7	1	0.7	0.7	0	0	0	0	0	0	0	0	0	0	0	100.9451	0.0000	0.0658	0.0000;
	1845	3.1	2.35	2.35	2.35	1.08722	3.9	1	3.1	3.1	0	0	0	0	0	0	0	0	0	0	0	98.1195	0.0000	0.0143	0.0000;
	2149	2.567	0.16	0.16	0.16	1.08151	2.6	1	2.567	2.567	0	0	0	0	0	0	0	0	0	0	0	104.5122	0.0000	0.0000	0.6545;
	17	0.69	0.001	0.001	0.001	1.07106	0.7	1	0.69	0.69	0	0	0	0	0	0	0	0	0	0	0	108.4499	0.0000	0.1084	0.0000;
	845	0.02	0.02	0.02	0.02	1.07142	0	1	0.02	0.02	0	0	0	0	0	0	0	0	0	0	0	101.4845	0.0000	0.0000	0.3422;
	1006	0.02	-0.158	-0.158	-0.158	1.08426	0.2	1	0.02	0.02	0	0	0	0	0	0	0	0	0	0	0	99.5548	0.0000	0.2022	0.0000;
	2723	0	0	0	0	1.02	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	100.3525	0.0000	0.0000	0.0841;
	2724	0	0	0	0	1.01875	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	100.9982	0.0000	0.0000	0.2578;
	2725	0	0	0	0	1.08773	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	104.2247	0.0000	0.0000	0.3895;
	2726	0	0	0	0	1.00125	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	100.5977	0.0000	0.0000	0.0128;
	2727	125	0	120	0	1.09091	173.3	1	125	125	0	0	0	0	0	0	0	0	0	0	0	98.7722	0.0000	0.0000	0.3868;
	2728	176.691	-46.105	-46.105	-46.105	1.08409	182.6	1	176.691	176.691	0	0	0	0	0	0	0	0	0	0	0	108.5648	0.0000	0.0627	0.0000;
	2729	0	0	0	0	1.015	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	102.7443	0.0000	0.0000	0.6219;
	2730	120	-10.0419	0	-15.33	1.1	120	1	120	120	0	0	0	0	0	0	0	0	0	0	0	94.4316	0.0000	0.0000	0.0000;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax	Pf	Qf	Pt	Qt	mu_Sf	mu_St	mu_angmin	mu_angmax
mpc.branch = [
	7	8	0.00064	0.0305	0	400	400	400	1.0435	-0.6	1	-360	360	-224.8802	-3.3165	225.1908	18.1148	0.0000	0.0000	0.0000	0.0000;
	26	28	0.00036	0.02519	0	500	500	500	1.067	0	1	-360	360	80.8393	-24.7042	-80.8156	26.3674	0.0000	0.0000	0.0000	0.0000;
	27	29	0.00036	0.02519	0	500	500	500	1.0671	0	1	-360	360	207.6635	-22.8750	-207.5183	33.0370	0.0000	0.0000	0.0000	0.0000;
	39	41	0.00034	0.02097	0	500	500	500	1.1102	0	1	-360	360	-19.3662	-114.0225	19.4117	116.8286	0.0000	0.0000	0.0000	0.0000;
	42	45	0.00034	0.02097	0	500	500	500	1.0917	0	1	-360	360	-38.2008	-132.5267	38.2656	136.5202	0.0000	0.0000	0.0000	0.0000;
	54	56	0.00081	0.03	0	400	400	400	1.0466	0	1	-360	360	18.2506	-3.9997	-18.2480	4.0958	0.0000	0.0000	0.0000	0.0000;
	89	91	0.00075	0.02444	-0.00832	330	330	330	1.0553	0	1	-360	360	-92.0549	-4.6479	92.1132	7.4597	0.0000	0.0000	0.0000	0.0000;
	90	92	0.00075	0.02469	-0.008	330	330	330	1.0552	0	1	-360	360	-91.3257	-4.2434	91.3830	7.0082	0.0000	0.0000	0.0000	0.0000;
	124	127	0.0005	0.02875	-0.016	400	400	400	1.087	0	1	-360	360	80.8750	-87.4852	-80.8049	93.1926	0.0000	0.0000	0.0000	0.0000;
	148	149	0.00064	0.0305	0	400	400	400	1.0636	0	1	-360	360	-77.7942	14.2513	77.8309	-12.4996	0.0000	0.0000	0.0000	0.0000;
	154	156	0.000232	0.023	0	500	500	500	1.0953	0	1	-360	360	32.9758	-53.7433	-32.9665	54.6727	0.0000	0.0000	0.0000	0.0000;
	155	157	0.000232	0.023	0	500	500	500	1.0953	0	1	-360	360	31.9151	-53.5819	-31.9060	54.4911	0.0000	0.0000	0.0000	0.0000;
	168	170	0.00035	0.02375	0	500	500	500	1.0767	0	1	-360	360	37.1256	-54.1436	-37.1109	55.1362	0.0000	0.0000	0.0000	0.0000;
	182	183	0.00059	0.03093	0	400	400	400	1.0504	0	1	-360	360	-68.5007	5.0459	68.5265	-3.6935	0.0000	0.0000	0.0000	0.0000;
	189	191	0.0004	0.03	0	500	500	500	1.0695	3.6	1	-360	360	-27.5825	-40.8752	27.5921	41.5961	0.0000	0.0000	0.0000	0.0000;
	2726	156	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	-66.6991	15.5446	66.7141	-25.3929	0.0000	0.0000	0.0000	0.0000;
	2726	157	0.00031	0.00338	0.0992	1386	1386	1386	0	0	1	-360	360	-69.6319	15.9934	69.6481	-25.8276	0.0000	0.0000	0.0000	0.0000;
	2727	67	0.014341	0.083531	0.126034	385	385	385	0	0	1	-360	360	125.0000	-0.0000	-123.1176	-3.8470	0.0000	0.0000	0.0000	0.0000;
	2725	75	0.01219	0.070659	0.117418	412	412	412	0	0	1	-360	360	-174.6808	36.2790	177.9421	-31.5639	0.0000	0.0000	0.0000	0.0000;
	2725	104	0.011781	0.07087	0.116838	412	412	412	0	0	1	-360	360	-196.5192	39.2860	200.4857	-29.5610	0.0000	0.0000	0.0000	0.0000;
	126	2724	0.001525	0.016837	0.50576	1386	1386	1386	0	0	1	-360	360	434.1790	-13.9201	-431.5000	-10.5040	0.0000	0.0000	0.0000	0.0000;
	2728	147	0.001651	0.015909	0.046948	316	316	316	0	0	1	-360	360	88.6360	-23.2964	-88.5248	18.5922	0.0000	0.0000	0.0000	0.0000;
	2728	148	0.001651	0.015909	0.046948	316	316	316	0	0	1	-360	360	88.0550	-22.8086	-87.9455	18.0888	0.0000	0.0000	0.0000	0.0000;
	2729	47	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-154.0283	-94.3021	154.5229	32.1618	0.0000	0.0000	0.0000	0.0000;
	2729	48	0.00188	0.02287	0.6432	831	831	831	0	0	1	-360	360	-153.5537	-94.2209	154.0455	32.0484	0.0000	0.0000	0.0000	0.0000;
	81	2723	0.002769	0.031162	0.89824	1386	1386	1386	0	0	1	-360	360	178.4322	-54.6643	-177.6040	-31.6380	0.0000	0.0000	0.0000	0.0000;
	42	23	0.01345	0.081141	0.141134	339	339	339	0	0	1	-360	360	155.2160	20.6740	-152.3987	-19.9539	0.0000	0.0000	0.0000	0.0000;
	26	89	0.009091	0.062401	0.111417	453	453	453	0	0	1	-360	360	138.9068	-10.1651	-137.4824	6.2982	0.0000	0.0000	0.0000	0.0000;
	27	90	0.00868	0.06405	0.096994	427	427	427	0	0	1	-360	360	191.4558	-10.5725	-188.8721	17.7602	0.0000	0.0000	0.0000	0.0000;
	145	30	0.016961	0.123659	0.196988	316	316	316	0	0	1	-360	360	71.5931	18.7391	-70.7548	-35.9338	0.0000	0.0000	0.0000	0.0000;
	134	33	0.00512	0.02618	0.029621	301	301	301	0	0	1	-360	360	-85.4743	61.1827	85.9429	-62.4007	0.0000	0.0000	0.0000	0.0000;
	133	20	0.01068	0.061961	0.094961	385	385	385	0	0	1	-360	360	-148.6613	49.6423	150.8439	-48.5425	0.0000	0.0000	0.0000	0.0000;
	163	21	0.014651	0.105891	0.170852	316	316	316	0	0	1	-360	360	93.7140	13.8608	-92.5990	-26.2510	0.0000	0.0000	0.0000	0.0000;
	40	108	0.01488	0.08161	0.114805	314	314	314	0	0	1	-360	360	-70.3578	21.9651	71.0576	-32.1360	0.0000	0.0000	0.0000	0.0000;
	39	90	0.011159	0.07231	0.103673	324	324	324	0	0	1	-360	360	-114.4902	25.8422	115.7715	-30.2360	0.0000	0.0000	0.0000	0.0000;
	177	82	0.005517	0.059484	0.170775	316	316	316	0	0	1	-360	360	-158.8483	-0.5024	160.0421	-6.7260	0.0000	0.0000	0.0000	0.0000;
	202	164	0.01176	0.068289	0.102802	324	324	324	0	0	1	-360	360	-223.3056	-13.4825	228.4182	30.9345	0.0000	0.0000	0.0000	0.0000;
	193	164	0.016818	0.089091	0.129935	358	358	358	0	0	1	-360	360	-162.9642	-6.7048	166.8149	11.5625	0.0000	0.0000	0.0000	0.0000;
	192	163	0.013843	0.087025	0.134842	383	383	383	0	0	1	-360	360	-167.8825	-11.6994	171.2478	16.7275	0.0000	0.0000	0.0000	0.0000;
	206	166	0.01676	0.097169	0.148685	269	269	269	0	0	1	-360	360	10.0166	-14.5258	-9.9977	-2.9841	0.0000	0.0000	0.0000	0.0000;
	42	10	0.01269	0.074979	0.130196	351	351	351	0	0	1	-360	360	167.5053	19.7633	-164.4340	-16.6628	0.0000	0.0000	0.0000	0.0000;
	197	18	0.014091	0.10413	0.15972	316	316	316	0	0	1	-360	360	-39.9795	-22.1922	40.1950	5.0134	0.0000	0.0000	0.0000	0.0000;
	99	54	0.003719	0.0438	0.100962	457	457	457	0	0	1	-360	360	-13.4273	4.2363	13.4362	-16.2210	0.0000	0.0000	0.0000	0.0000;
	161	81	0.00194	0.02056	0.51584	1178	1178	1178	0	0	1	-360	360	-486.5179	-41.8671	490.9763	35.0341	0.0000	0.0000	0.0000	0.0000;
	44	9	0.0015	0.01506	0.4032	1386	1386	1386	0	0	1	-360	360	345.9515	-34.8221	-344.2483	9.4323	0.0000	0.0000	0.0000	0.0000;
	184	149	0.00294	0.03463	0.9216	693	693	693	0	0	1	-360	360	-29.4342	-53.9740	29.4584	-45.2311	0.0000	0.0000	0.0000	0.0000;
	120	56	0.00169	0.01994	0.50624	831	831	831	0	0	1	-360	360	-23.1687	-0.5070	23.1884	-54.7805	0.0000	0.0000	0.0000	0.0000;
	29	92	0.00137	0.01625	0.41184	1386	1386	1386	0	0	1	-360	360	213.2100	-45.8519	-212.6342	7.5458	0.0000	0.0000	0.0000	0.0000;
	28	122	0.00231	0.02769	0.70144	1386	1386	1386	0	0	1	-360	360	311.7907	-66.3483	-309.7224	14.0867	0.0000	0.0000	0.0000	0.0000;
	25	191	0.00207	0.02474	0.664	1386	1386	1386	0	0	1	-360	360	342.9760	9.1461	-340.6538	-51.2171	0.0000	0.0000	0.0000	0.0000;
	119	63	0.0015	0.01788	0.4512	831	831	831	0	0	1	-360	360	88.0272	-25.0182	-87.9217	-23.3795	0.0000	0.0000	0.0000	0.0000;
	121	63	0.00469	0.05544	1.4048	831	831	831	0	0	1	-360	360	110.5946	-80.8785	-110.0738	-67.6188	0.0000	0.0000	0.0000	0.0000;
	81	31	0.00331	0.03425	0.85888	977	977	977	0	0	1	-360	360	-133.3389	-64.6540	133.9020	-22.0900	0.0000	0.0000	0.0000	0.0000;
	91	28	0.00219	0.02369	0.59584	1178	1178	1178	0	0	1	-360	360	-144.9917	-10.8580	145.4208	-49.8019	0.0000	0.0000	0.0000	0.0000;
	12	4	0.01674	0.09711	0.144232	427	427	427	0	0	1	-360	360	-218.4933	13.6798	225.6960	11.4182	0.0000	0.0000	0.0000	0.0000;
	30	11	0.0057	0.0407	0.06021	316	316	316	0	0	1	-360	360	-16.5402	18.7927	16.5786	-25.3137	0.0000	0.0000	0.0000	0.0000;
	24	4	0.004419	0.032229	0.049852	383	383	383	0	0	1	-360	360	179.3599	-3.4884	-178.1809	6.1063	0.0000	0.0000	0.0000	0.0000;
	17	7	0.014591	0.11219	0.165528	383	383	383	0	0	1	-360	360	-98.9520	35.3403	100.3973	-43.5144	0.0000	0.0000	0.0000	0.0000;
	21	10	0.01211	0.087419	0.140166	316	316	316	0	0	1	-360	360	-21.9883	18.7573	22.1141	-33.8453	0.0000	0.0000	0.0000	0.0000;
	26	5	0.009773	0.050516	0.088959	377	377	377	0	0	1	-360	360	193.7494	3.4841	-190.7656	1.1520	0.0000	0.0000	0.0000	0.0000;
	17	3	0.01068	0.07895	0.245194	274	274	274	0	0	1	-360	360	76.4924	-11.4999	-75.9686	-13.7085	0.0000	0.0000	0.0000	0.0000;
	26	19	0.0057	0.039521	0.075533	440	440	440	0	0	1	-360	360	194.8266	10.2136	-193.0602	-7.1643	0.0000	0.0000	0.0000	0.0000;
	27	20	0.0057	0.039521	0.075533	440	440	440	0	0	1	-360	360	284.3493	4.1896	-280.6049	12.5731	0.0000	0.0000	0.0000	0.0000;
	13	6	0.00525	0.03988	0.061952	316	316	316	0	0	1	-360	360	-25.6351	-18.1012	25.6759	11.4251	0.0000	0.0000	0.0000	0.0000;
	13	12	2.1e-05	0.000207	0	316	316	316	0	0	1	-360	360	-71.0366	-11.8113	71.0376	11.8209	0.0000	0.0000	0.0000	0.0000;
	32	13	0.00093	0.00651	0.011132	316	316	316	0	0	1	-360	360	-96.5865	-30.5595	96.6717	29.9126	0.0000	0.0000	0.0000	0.0000;
	23	11	0.00205	0.01326	0.022429	385	385	385	0	0	1	-360	360	-3.4773	-18.8666	3.4832	16.3969	0.0000	0.0000	0.0000	0.0000;
	33	5	0.007831	0.043	0.04962	301	301	301	0	0	1	-360	360	-110.2977	37.1841	111.1907	-38.2388	0.0000	0.0000	0.0000	0.0000;
	19	4	0.00293	0.01599	0.024781	324	324	324	0	0	1	-360	360	132.3574	6.3870	-131.9292	-7.0195	0.0000	0.0000	0.0000	0.0000;
	26	1	0.00155	0.01169	0.018198	633	633	633	0	0	1	-360	360	70.3198	75.0110	-70.1848	-76.2160	0.0000	0.0000	0.0000	0.0000;
	27	2	0.00155	0.01169	0.018198	633	633	633	0	0	1	-360	360	57.4406	29.2275	-57.3876	-31.0613	0.0000	0.0000	0.0000	0.0000;
	27	24	0.003841	0.028531	0.045883	392	392	392	0	0	1	-360	360	264.2298	15.7735	-262.0425	-5.1194	0.0000	0.0000	0.0000	0.0000;
	25	9	0.00298	0.03418	0.93504	831	831	831	0	0	1	-360	360	-15.7261	-27.4588	15.7471	-71.3320	0.0000	0.0000	0.0000	0.0000;
	28	25	0.00358	0.04262	1.0944	1386	1386	1386	0	0	1	-360	360	484.6787	-21.0991	-476.9458	-5.0764	0.0000	0.0000	0.0000	0.0000;
	14	29	0.00336	0.03977	1.02163	1316	1316	1316	0	0	1	-360	360	-430.5905	-52.9804	436.5973	15.1910	0.0000	0.0000	0.0000	0.0000;
	8	15	0.00299	0.03675	0.9184	1150	1150	1150	0	0	1	-360	360	133.9245	-72.4148	-133.3982	-18.2822	0.0000	0.0000	0.0000	0.0000;
	8	14	0.00112	0.01329	0.341248	1150	1150	1150	0	0	1	-360	360	-183.6500	55.8015	184.0670	-86.4975	0.0000	0.0000	0.0000	0.0000;
	31	29	0.00075	0.009	0.22848	1150	1150	1150	0	0	1	-360	360	-304.6537	-10.0257	305.2925	-7.2608	0.0000	0.0000	0.0000	0.0000;
	62	58	0.010479	0.060969	0.092047	269	269	269	0	0	1	-360	360	1.2921	7.7641	-1.2766	-18.5843	0.0000	0.0000	0.0000	0.0000;
	60	55	0.00882	0.065641	0.100662	274	274	274	0	0	1	-360	360	-36.6914	15.0515	36.8218	-26.1976	0.0000	0.0000	0.0000	0.0000;
	66	34	0.011219	0.065581	0.098349	274	274	274	0	0	1	-360	360	15.8734	1.1956	-15.8446	-12.4903	0.0000	0.0000	0.0000	0.0000;
	50	34	0.01163	0.07031	0.105802	341	341	341	0	0	1	-360	360	-5.6760	-8.5733	5.6798	-3.6430	0.0000	0.0000	0.0000	0.0000;
	58	42	0.00545	0.040211	0.066986	404	404	404	0	0	1	-360	360	-23.6573	-17.2753	23.6915	9.5969	0.0000	0.0000	0.0000	0.0000;
	59	43	0.00545	0.040211	0.066986	404	404	404	0	0	1	-360	360	-24.4693	-16.8810	24.5048	9.2130	0.0000	0.0000	0.0000	0.0000;
	59	34	0.00837	0.04868	0.073481	379	379	379	0	0	1	-360	360	8.4362	12.7401	-8.4104	-21.1744	0.0000	0.0000	0.0000	0.0000;
	67	51	0.003159	0.02076	0.03146	385	385	385	0	0	1	-360	360	68.4296	-8.6885	-68.3003	5.9044	0.0000	0.0000	0.0000	0.0000;
	51	38	0.006979	0.051961	0.079666	316	316	316	0	0	1	-360	360	42.1599	5.8209	-42.0458	-14.1039	0.0000	0.0000	0.0000	0.0000;
	36	55	0.00374	0.027831	0.042689	274	274	274	0	0	1	-360	360	-76.1942	-10.3121	76.3797	6.6203	0.0000	0.0000	0.0000	0.0000;
	37	35	0.00769	0.057271	0.087894	316	316	316	0	0	1	-360	360	36.1984	5.0127	-36.1064	-14.6505	0.0000	0.0000	0.0000	0.0000;
	54	37	0.00556	0.04145	0.063598	383	383	383	0	0	1	-360	360	51.5491	2.4715	-51.4235	-9.0912	0.0000	0.0000	0.0000	0.0000;
	66	36	0.004521	0.03368	0.051691	392	392	392	0	0	1	-360	360	-56.2178	-11.4668	56.3425	6.3097	0.0000	0.0000	0.0000	0.0000;
	66	65	0.00151	0.008781	0.013165	341	341	341	0	0	1	-360	360	40.3444	10.2712	-40.3219	-11.6807	0.0000	0.0000	0.0000	0.0000;
	61	42	0.00574	0.042831	0.065727	404	404	404	0	0	1	-360	360	-21.0651	2.5552	21.0885	-10.2163	0.0000	0.0000	0.0000	0.0000;
	62	43	0.00707	0.045409	0.069309	314	314	314	0	0	1	-360	360	-20.6001	2.6602	20.6279	-10.7426	0.0000	0.0000	0.0000	0.0000;
	61	39	0.01213	0.062151	0.093712	314	314	314	0	0	1	-360	360	-58.3591	-24.1397	58.7402	14.7262	0.0000	0.0000	0.0000	0.0000;
	60	40	0.002479	0.017979	0.027588	316	316	316	0	0	1	-360	360	-72.1253	-40.8994	72.2630	38.5239	0.0000	0.0000	0.0000	0.0000;
	46	39	0.002401	0.01494	0.022525	341	341	341	0	0	1	-360	360	-73.1020	-15.0508	73.2104	12.9590	0.0000	0.0000	0.0000	0.0000;
	49	45	0.00167	0.0189	0.54176	1150	1150	1150	0	0	1	-360	360	-46.3527	12.2558	46.4128	-69.1389	0.0000	0.0000	0.0000	0.0000;
	57	53	0.00109	0.01277	0.34176	1150	1150	1150	0	0	1	-360	360	138.3897	25.1025	-138.1793	-59.7081	0.0000	0.0000	0.0000	0.0000;
	41	57	0.002259	0.026439	0.70784	1150	1150	1150	0	0	1	-360	360	-19.4117	-116.8286	19.5569	42.7975	0.0000	0.0000	0.0000	0.0000;
	63	57	0.00094	0.01097	0.29376	1393	1393	1393	0	0	1	-360	360	-184.7964	36.7290	185.1123	-65.2230	0.0000	0.0000	0.0000	0.0000;
	47	64	0.00113	0.01406	0.37488	1386	1386	1386	0	0	1	-360	360	-330.3465	-64.8644	331.5123	38.5753	0.0000	0.0000	0.0000	0.0000;
	52	44	0.00176	0.02144	0.57344	1150	1150	1150	0	0	1	-360	360	21.9111	18.9890	-21.8627	-79.5661	0.0000	0.0000	0.0000	0.0000;
	95	124	0.004876	0.033616	0.059609	404	404	404	0	0	1	-360	360	-83.8084	-11.9228	84.0980	6.7586	0.0000	0.0000	0.0000	0.0000;
	74	105	0.01093	0.059194	0.08439	246	246	246	0	0	1	-360	360	3.8530	-4.5476	-3.8517	-5.5731	0.0000	0.0000	0.0000	0.0000;
	105	93	0.001942	0.013926	0.022845	404	404	404	0	0	1	-360	360	72.8844	1.9947	-72.7982	-4.1125	0.0000	0.0000	0.0000	0.0000;
	78	84	0.004318	0.029752	0.05264	316	316	316	0	0	1	-360	360	113.5480	-9.7510	-113.0865	6.5720	0.0000	0.0000	0.0000	0.0000;
	130	129	0.000661	0.004959	0.007579	379	379	379	0	0	1	-360	360	95.4841	-1.7086	-95.4345	1.1612	0.0000	0.0000	0.0000	0.0000;
	106	130	0.005372	0.040393	0.060055	379	379	379	0	0	1	-360	360	-39.9680	-16.3078	40.0468	9.6532	0.0000	0.0000	0.0000	0.0000;
	90	130	0.000826	0.005248	0.008683	301	301	301	0	0	1	-360	360	135.6563	7.6854	-135.5309	-7.9446	0.0000	0.0000	0.0000	0.0000;
	99	118	0.015888	0.087603	0.116818	314	314	314	0	0	1	-360	360	-60.3859	2.8395	60.8810	-14.1697	0.0000	0.0000	0.0000	0.0000;
	80	112	0.002169	0.014587	0.025749	269	269	269	0	0	1	-360	360	-11.8896	-8.2199	11.8930	5.1701	0.0000	0.0000	0.0000	0.0000;
	115	100	0.017727	0.116777	0.163611	246	246	246	0	0	1	-360	360	62.0606	-14.0455	-61.4934	-1.9388	0.0000	0.0000	0.0000	0.0000;
	125	73	0.00593	0.04093	0.072145	404	404	404	0	0	1	-360	360	49.2132	-1.9881	-49.0940	-5.8806	0.0000	0.0000	0.0000	0.0000;
	107	89	0.003905	0.028471	0.044983	383	383	383	0	0	1	-360	360	-85.0463	-5.2777	85.2802	1.5271	0.0000	0.0000	0.0000	0.0000;
	117	78	0.008161	0.042417	0.061197	356	356	356	0	0	1	-360	360	-60.4961	3.0771	60.7469	-9.1666	0.0000	0.0000	0.0000	0.0000;
	118	77	0.008161	0.042417	0.061197	356	356	356	0	0	1	-360	360	-59.6729	-0.9506	59.9144	-5.1975	0.0000	0.0000	0.0000	0.0000;
	78	75	0.005186	0.038388	0.058748	453	453	453	0	0	1	-360	360	132.0352	-12.6806	-131.2847	11.1381	0.0000	0.0000	0.0000	0.0000;
	77	72	0.002128	0.014029	0.022603	301	301	301	0	0	1	-360	360	122.9101	3.2908	-122.6448	-4.2784	0.0000	0.0000	0.0000	0.0000;
	113	77	0.004628	0.027748	0.046115	324	324	324	0	0	1	-360	360	-94.0780	-20.3926	94.4330	16.9674	0.0000	0.0000	0.0000	0.0000;
	102	71	0.011219	0.070744	0.115705	246	246	246	0	0	1	-360	360	-57.4221	-8.1903	57.7328	-3.7272	0.0000	0.0000	0.0000	0.0000;
	109	116	0.006012	0.041467	0.073636	383	383	383	0	0	1	-360	360	-86.0819	-6.7777	86.4548	0.4940	0.0000	0.0000	0.0000	0.0000;
	90	68	0.002066	0.012789	0.020551	269	269	269	0	0	1	-360	360	73.7982	5.9702	-73.7049	-7.8890	0.0000	0.0000	0.0000	0.0000;
	85	89	0.001364	0.009731	0.016243	453	453	453	0	0	1	-360	360	-99.1181	-1.0702	99.2284	-0.1173	0.0000	0.0000	0.0000	0.0000;
	128	86	0.000579	0.004112	0.007008	404	404	404	0	0	1	-360	360	-54.2393	-8.2139	54.2536	7.4651	0.0000	0.0000	0.0000	0.0000;
	131	75	0.000847	0.00624	0.009544	457	457	457	0	0	1	-360	360	123.5000	31.0000	-123.3864	-31.3172	0.0000	0.0000	0.0000	0.0000;
	132	76	0.000847	0.00626	0.009477	457	457	457	0	0	1	-360	360	-0.0000	0.0000	0.0000	-1.1426	0.0000	0.0000	0.0000	0.0000;
	101	76	0.001591	0.011116	0.019128	453	453	453	0	0	1	-360	360	-76.6114	-54.3515	76.7275	52.8709	0.0000	0.0000	0.0000	0.0000;
	124	103	0.003141	0.021591	0.038391	404	404	404	0	0	1	-360	360	138.5546	-21.5877	-138.0461	20.4429	0.0000	0.0000	0.0000	0.0000;
	125	110	0.004545	0.03157	0.055312	316	316	316	0	0	1	-360	360	87.0298	27.6075	-86.7089	-31.9881	0.0000	0.0000	0.0000	0.0000;
	103	83	0.001446	0.009917	0.017598	316	316	316	0	0	1	-360	360	-2.2346	16.8029	2.2385	-18.9008	0.0000	0.0000	0.0000	0.0000;
	104	94	0.003822	0.026674	0.046154	316	316	316	0	0	1	-360	360	7.9263	20.6124	-7.9070	-26.0270	0.0000	0.0000	0.0000	0.0000;
	111	79	0.007769	0.041281	0.063907	269	269	269	0	0	1	-360	360	-6.9442	-14.9271	6.9556	7.4025	0.0000	0.0000	0.0000	0.0000;
	88	77	0.004463	0.030413	0.048671	246	246	246	0	0	1	-360	360	-90.4849	-22.9583	90.8063	19.2920	0.0000	0.0000	0.0000	0.0000;
	116	107	0.005888	0.035062	0.052349	246	246	246	0	0	1	-360	360	55.9097	-11.1250	-55.7544	5.7210	0.0000	0.0000	0.0000	0.0000;
	108	98	0.003161	0.023409	0.036165	316	316	316	0	0	1	-360	360	-49.5633	7.0715	49.6298	-10.9481	0.0000	0.0000	0.0000	0.0000;
	115	78	0.001839	0.012603	0.022399	316	316	316	0	0	1	-360	360	-60.3491	2.9085	60.4048	-5.2370	0.0000	0.0000	0.0000	0.0000;
	106	87	0.001715	0.009607	0.014239	301	301	301	0	0	1	-360	360	20.9603	29.3360	-20.9410	-30.9310	0.0000	0.0000	0.0000	0.0000;
	97	78	0.003409	0.024421	0.039969	246	246	246	0	0	1	-360	360	-64.4475	1.1184	64.5651	-5.1081	0.0000	0.0000	0.0000	0.0000;
	116	77	0.001839	0.012603	0.02239	316	316	316	0	0	1	-360	360	-54.8891	-10.9293	54.9363	8.5403	0.0000	0.0000	0.0000	0.0000;
	82	96	0.005702	0.041488	0.066172	404	404	404	0	0	1	-360	360	-25.9396	-12.2955	25.9754	4.6875	0.0000	0.0000	0.0000	0.0000;
	123	117	0.004587	0.024628	0.036165	314	314	314	0	0	1	-360	360	-76.2380	-10.4465	76.4638	7.3193	0.0000	0.0000	0.0000	0.0000;
	123	109	0.002149	0.013327	0.022109	246	246	246	0	0	1	-360	360	-10.9518	-5.2404	10.9542	2.6132	0.0000	0.0000	0.0000	0.0000;
	99	70	0.000785	0.004876	0.00726	269	269	269	0	0	1	-360	360	8.0325	2.8450	-8.0320	-3.7140	0.0000	0.0000	0.0000	0.0000;
	100	69	0.000785	0.004876	0.007241	269	269	269	0	0	1	-360	360	10.3277	-0.8655	-10.3270	-0.0000	0.0000	0.0000	0.0000	0.0000;
	92	126	0.002413	0.027544	0.767968	831	831	831	0	0	1	-360	360	174.1295	-11.1573	-173.4419	-64.3726	0.0000	0.0000	0.0000	0.0000;
	81	126	0.002131	0.024319	0.67744	1386	1386	1386	0	0	1	-360	360	35.5839	-55.8220	-35.5509	-16.2872	0.0000	0.0000	0.0000	0.0000;
	121	114	0.000913	0.0104	0.289888	1150	1150	1150	0	0	1	-360	360	37.8992	66.5939	-37.8309	-97.5163	0.0000	0.0000	0.0000	0.0000;
	122	120	0.003119	0.035631	0.991072	831	831	831	0	0	1	-360	360	127.8970	-62.1227	-127.4326	-41.8018	0.0000	0.0000	0.0000	0.0000;
	114	127	0.000919	0.010512	0.292928	1150	1150	1150	0	0	1	-360	360	-66.5539	40.7353	66.6186	-71.6130	0.0000	0.0000	0.0000	0.0000;
	172	155	0.01545	0.073349	0.126614	427	427	427	0	0	1	-360	360	-197.7612	20.4845	203.1641	-9.5273	0.0000	0.0000	0.0000	0.0000;
	173	154	0.01545	0.073349	0.126614	427	427	427	0	0	1	-360	360	-197.8012	20.5297	203.2067	-9.5595	0.0000	0.0000	0.0000	0.0000;
	175	154	0.01457	0.07955	0.14007	324	324	324	0	0	1	-360	360	-69.6290	-2.1392	70.2389	-10.9707	0.0000	0.0000	0.0000	0.0000;
	176	155	0.01457	0.07955	0.14007	324	324	324	0	0	1	-360	360	-69.2102	-2.2778	69.8126	-10.8735	0.0000	0.0000	0.0000	0.0000;
	175	143	0.006031	0.04401	0.069793	316	316	316	0	0	1	-360	360	71.2397	-6.5350	-70.9771	0.3261	0.0000	0.0000	0.0000	0.0000;
	164	139	0.011031	0.08057	0.124127	404	404	404	0	0	1	-360	360	184.9232	-1.6003	-181.8583	8.8922	0.0000	0.0000	0.0000	0.0000;
	136	154	0.005831	0.04231	0.070664	383	383	383	0	0	1	-360	360	-103.8216	2.8526	104.3600	-7.2587	0.0000	0.0000	0.0000	0.0000;
	169	172	0.01849	0.095599	0.159139	305	305	305	0	0	1	-360	360	-67.0841	34.9864	68.0864	-48.3903	0.0000	0.0000	0.0000	0.0000;
	151	173	0.010581	0.053	0.088475	385	385	385	0	0	1	-360	360	-96.0391	20.2154	96.9511	-25.7538	0.0000	0.0000	0.0000	0.0000;
	153	155	0.012521	0.091359	0.145394	453	453	453	0	0	1	-360	360	-169.4702	38.8636	172.6950	-32.6616	0.0000	0.0000	0.0000	0.0000;
	135	136	0.00506	0.036539	0.063598	305	305	305	0	0	1	-360	360	-46.8579	-2.0796	46.9531	-4.6779	0.0000	0.0000	0.0000	0.0000;
	147	142	0.01043	0.077891	0.122065	383	383	383	0	0	1	-360	360	12.3835	5.4868	-12.3562	-20.1841	0.0000	0.0000	0.0000	0.0000;
	152	180	0.007702	0.056917	0.086733	316	316	316	0	0	1	-360	360	28.3649	48.0286	-28.1319	-56.4653	0.0000	0.0000	0.0000	0.0000;
	152	179	0.002256	0.016674	0.02541	333	333	333	0	0	1	-360	360	-166.2810	-62.8429	166.8700	64.1015	0.0000	0.0000	0.0000	0.0000;
	174	146	0.009147	0.089554	0.215196	246	246	246	0	0	1	-360	360	-119.0051	-17.0108	120.0944	1.6360	0.0000	0.0000	0.0000	0.0000;
	174	168	0.00244	0.01318	0.021296	341	341	341	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	168	139	0.00355	0.02593	0.041237	404	404	404	0	0	1	-360	360	-91.6810	2.5221	91.9313	-5.6328	0.0000	0.0000	0.0000	0.0000;
	169	166	0.01312	0.076219	0.116644	324	324	324	0	0	1	-360	360	79.5090	-14.3023	-78.8094	4.4603	0.0000	0.0000	0.0000	0.0000;
	168	151	0.009341	0.05225	0.087701	305	305	305	0	0	1	-360	360	-24.0489	48.8961	24.3231	-57.6225	0.0000	0.0000	0.0000	0.0000;
	145	134	0.006141	0.032521	0.052456	356	356	356	0	0	1	-360	360	-223.2077	42.4028	225.7997	-35.1313	0.0000	0.0000	0.0000	0.0000;
	146	133	0.00438	0.03188	0.050723	453	453	453	0	0	1	-360	360	-231.9105	32.0131	233.8705	-23.9914	0.0000	0.0000	0.0000	0.0000;
	163	146	0.000479	0.00331	0.005711	404	404	404	0	0	1	-360	360	-103.1422	53.2868	103.1948	-53.6266	0.0000	0.0000	0.0000	0.0000;
	164	145	0.000479	0.00331	0.005711	404	404	404	0	0	1	-360	360	-109.3758	53.6206	109.4336	-53.9239	0.0000	0.0000	0.0000	0.0000;
	153	142	0.010539	0.076859	0.122355	316	316	316	0	0	1	-360	360	113.6228	-22.7576	-112.4711	16.3972	0.0000	0.0000	0.0000	0.0000;
	158	147	0.00469	0.034651	0.053821	383	383	383	0	0	1	-360	360	-141.8218	-15.7951	142.6088	15.0428	0.0000	0.0000	0.0000	0.0000;
	148	140	0.006469	0.0413	0.069212	383	383	383	0	0	1	-360	360	121.2264	5.6491	-120.4495	-9.1409	0.0000	0.0000	0.0000	0.0000;
	167	140	0.00105	0.007211	0.01028	316	316	316	0	0	1	-360	360	-39.1104	-7.7865	39.1242	6.6377	0.0000	0.0000	0.0000	0.0000;
	167	158	0.006099	0.044831	0.070954	316	316	316	0	0	1	-360	360	-7.5508	-2.9419	7.5538	-5.6089	0.0000	0.0000	0.0000	0.0000;
	175	135	0.002211	0.01655	0.024781	316	316	316	0	0	1	-360	360	30.0264	-10.6875	-30.0077	7.9335	0.0000	0.0000	0.0000	0.0000;
	177	176	0.005169	0.036979	0.058951	316	316	316	0	0	1	-360	360	70.5311	-8.2812	-70.3103	2.9721	0.0000	0.0000	0.0000	0.0000;
	180	172	0.002401	0.017789	0.027588	381	381	381	0	0	1	-360	360	-103.9401	10.2077	104.1707	-11.6435	0.0000	0.0000	0.0000	0.0000;
	156	137	0.00274	0.02696	0.70592	977	977	977	0	0	1	-360	360	124.5086	-54.4509	-124.0779	-12.6772	0.0000	0.0000	0.0000	0.0000;
	162	138	0.0017	0.01733	0.45632	915	915	915	0	0	1	-360	360	117.9316	17.2400	-117.6749	-61.2628	0.0000	0.0000	0.0000	0.0000;
	160	161	0.00136	0.01574	0.433664	1469	1469	1469	0	0	1	-360	360	-130.8963	-26.9678	131.1238	-14.9898	0.0000	0.0000	0.0000	0.0000;
	170	150	0.00371	0.04326	1.18688	693	693	693	0	0	1	-360	360	-49.6817	-86.7130	49.7886	-38.9700	0.0000	0.0000	0.0000	0.0000;
	187	192	0.01882	0.137581	0.25381	299	299	299	0	0	1	-360	360	-47.7542	-4.5206	48.1393	-22.1874	0.0000	0.0000	0.0000	0.0000;
	196	202	0.02756	0.16014	0.242871	269	269	269	0	0	1	-360	360	-40.5724	-3.6460	40.9908	-21.8963	0.0000	0.0000	0.0000	0.0000;
	188	207	0.01905	0.11132	0.167851	269	269	269	0	0	1	-360	360	3.9047	-17.0054	-3.8937	-2.6320	0.0000	0.0000	0.0000	0.0000;
	190	193	0.00795	0.05919	0.090798	316	316	316	0	0	1	-360	360	-59.7323	1.5949	59.9806	-10.2671	0.0000	0.0000	0.0000	0.0000;
	192	181	0.0018	0.021141	0.051498	633	633	633	0	0	1	-360	360	65.1157	11.0615	-65.0468	-16.2056	0.0000	0.0000	0.0000	0.0000;
	201	203	0.00731	0.055789	0.083635	274	274	274	0	0	1	-360	360	-59.4108	-1.2697	59.6374	-6.5801	0.0000	0.0000	0.0000	0.0000;
	189	200	0.00564	0.041961	0.064372	274	274	274	0	0	1	-360	360	14.0556	12.3291	-14.0334	-19.5670	0.0000	0.0000	0.0000	0.0000;
	207	182	0.0057	0.04236	0.129712	366	366	366	0	0	1	-360	360	-68.2756	-8.6626	68.5007	-5.0459	0.0000	0.0000	0.0000	0.0000;
	199	183	0.00131	0.01548	0.41152	1150	1150	1150	0	0	1	-360	360	120.5912	-87.2936	-120.3584	46.0825	0.0000	0.0000	0.0000	0.0000;
	185	191	0.00224	0.02583	0.72352	831	831	831	0	0	1	-360	360	-95.2145	26.0221	95.4927	-98.8586	0.0000	0.0000	0.0000	0.0000;
	194	186	0.0021	0.02475	0.65792	1150	1150	1150	0	0	1	-360	360	-128.2109	-19.8768	128.5392	-46.3752	0.0000	0.0000	0.0000	0.0000;
	204	198	0.0015	0.01768	0.46944	831	831	831	0	0	1	-360	360	227.0111	-11.2272	-226.2857	-30.1959	0.0000	0.0000	0.0000	0.0000;
	185	204	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	-148.5658	-22.2215	148.8414	-19.1668	0.0000	0.0000	0.0000	0.0000;
	186	205	0.00133	0.01569	0.418208	831	831	831	0	0	1	-360	360	-149.1225	-22.0864	149.4002	-19.2785	0.0000	0.0000	0.0000	0.0000;
	393	1	0.00157	0.06612	0	160	160	160	1.041	0	1	-360	360	-70.0457	-70.3609	70.1848	76.2160	0.0000	0.0000	0.0000	0.0000;
	394	2	0.00157	0.06612	0	160	160	160	1.0105	0	1	-360	360	-57.3329	-28.7597	57.3876	31.0613	0.0000	0.0000	0.0000	0.0000;
	246	245	0.001008	0.047273	0	300	300	300	1	0	1	-360	360	142.9248	-42.9120	-142.7319	51.9533	0.0000	0.0000	0.0000	0.0000;
	246	29	0.00079	0.03678	0	426	426	426	1	0	1	-360	360	227.0752	99.7417	-226.6579	-80.3109	0.0000	0.0000	0.0000	0.0000;
	248	3	0.001651	0.06736	0	160	160	160	1.0066	0	1	-360	360	-52.6166	-2.9956	52.6558	4.5945	0.0000	0.0000	0.0000	0.0000;
	249	3	0.001651	0.06736	0	160	160	160	1.0154	0	1	-360	360	-23.3040	-8.7553	23.3128	9.1139	0.0000	0.0000	0.0000	0.0000;
	276	4	0.001651	0.06901	0	160	160	160	1.0252	0	1	-360	360	-71.7050	-4.1755	71.7770	7.1851	0.0000	0.0000	0.0000	0.0000;
	277	5	0.001651	0.06901	0	160	160	160	1.026	0	1	-360	360	-92.0890	-14.2607	92.2119	19.3959	0.0000	0.0000	0.0000	0.0000;
	342	6	0.001651	0.068599	0	160	160	160	1.0512	0	1	-360	360	-98.6436	-28.7167	98.8038	35.3737	0.0000	0.0000	0.0000	0.0000;
	342	6	0.001651	0.068599	0	160	160	160	1.0248	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	343	9	0.0015	0.06188	0	250	250	250	1.1116	0	1	-360	360	-152.6483	-44.4593	153.0342	60.3800	0.0000	0.0000	0.0000	0.0000;
	354	10	0.001651	0.06775	0	160	160	160	1.0368	0	1	-360	360	-91.5558	-8.3357	91.6823	13.5274	0.0000	0.0000	0.0000	0.0000;
	355	11	0.001651	0.06775	0	160	160	160	1.0365	0	1	-360	360	-89.0646	-10.1690	89.1852	15.1160	0.0000	0.0000	0.0000	0.0000;
	356	12	0.001651	0.06775	0	160	160	160	1.0306	0	1	-360	360	-88.7280	-0.4763	88.8447	5.2656	0.0000	0.0000	0.0000	0.0000;
	361	14	0.00087	0.05244	-0.02144	330	330	330	1.1545	0	1	-360	360	-245.8531	-96.9821	246.5235	139.4780	0.0000	0.0000	0.0000	0.0000;
	369	15	0.00087	0.05244	-0.02144	330	330	330	1.0938	0	1	-360	360	-133.2503	-7.1028	133.3982	18.2822	0.0000	0.0000	0.0000	0.0000;
	386	17	0.00124	0.068391	0	160	160	160	1.011	0	1	-360	360	-20.4450	-3.7661	20.4495	4.0147	0.0000	0.0000	0.0000	0.0000;
	385	18	0.00124	0.068391	0	160	160	160	0.9936	0	1	-360	360	37.5207	34.2914	-37.4949	-32.8688	0.0000	0.0000	0.0000	0.0000;
	391	19	0.001651	0.06901	0	160	160	160	1.031	0	1	-360	360	-86.2685	-14.9316	86.3760	19.4278	0.0000	0.0000	0.0000	0.0000;
	392	20	0.001651	0.06901	0	160	160	160	1.0239	0	1	-360	360	-103.9349	-10.9310	104.0876	17.3172	0.0000	0.0000	0.0000	0.0000;
	398	21	0.00155	0.06612	0	160	160	160	1.0173	0	1	-360	360	-71.7485	-1.6227	71.8176	4.5702	0.0000	0.0000	0.0000	0.0000;
	399	21	0.00157	0.06612	0	160	160	160	1.0331	0	1	-360	360	-42.7449	-1.8776	42.7697	2.9236	0.0000	0.0000	0.0000	0.0000;
	404	23	0.001651	0.06901	0	160	160	160	1.0494	0	1	-360	360	-87.7287	-18.8259	87.8514	23.9542	0.0000	0.0000	0.0000	0.0000;
	405	23	0.001651	0.06901	0	160	160	160	1.0394	0	1	-360	360	-67.9529	-11.8677	68.0246	14.8663	0.0000	0.0000	0.0000	0.0000;
	406	24	0.00157	0.067979	0	160	160	160	1.0093	0	1	-360	360	-71.1752	-7.3120	71.2427	10.2322	0.0000	0.0000	0.0000	0.0000;
	407	24	0.001651	0.06901	0	160	160	160	0.9825	0	1	-360	360	-11.4382	1.7008	11.4400	-1.6244	0.0000	0.0000	0.0000	0.0000;
	413	25	0.0015	0.06188	0	250	250	250	1.0977	0	1	-360	360	-149.3730	-10.0667	149.6959	23.3892	0.0000	0.0000	0.0000	0.0000;
	465	30	0.001651	0.06818	0	160	160	160	1.038	0	1	-360	360	-87.1801	-12.3941	87.2950	17.1411	0.0000	0.0000	0.0000	0.0000;
	489	31	0.00137	0.06119	-0.01504	250	250	250	1.0798	0	1	-360	360	-88.4673	-12.4335	88.5699	18.6396	0.0000	0.0000	0.0000	0.0000;
	490	31	0.00137	0.06119	-0.01504	250	250	250	1.0699	0	1	-360	360	-82.0949	-7.9663	82.1818	13.4761	0.0000	0.0000	0.0000	0.0000;
	545	32	0.001651	0.06901	0	160	160	160	1.0454	0	1	-360	360	-96.4345	-24.2059	96.5865	30.5595	0.0000	0.0000	0.0000	0.0000;
	574	33	0.001651	0.06901	0	160	160	160	1.0268	0	1	-360	360	-24.3380	-24.5147	24.3548	25.2166	0.0000	0.0000	0.0000	0.0000;
	575	33	0.001651	0.06901	0	160	160	160	1.0067	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	588	34	0.001401	0.0668	0	160	160	160	1.0428	0	1	-360	360	-18.5542	-36.3068	18.5752	37.3076	0.0000	0.0000	0.0000	0.0000;
	588	34	0.001401	0.0668	0	160	160	160	1.0417	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	593	35	0.00151	0.067151	0	160	160	160	1.0007	0	1	-360	360	-36.0867	-13.7761	36.1064	14.6505	0.0000	0.0000	0.0000	0.0000;
	613	37	0.00157	0.078081	0	160	160	160	1.0022	0	1	-360	360	-35.0596	-7.2249	35.0768	8.0801	0.0000	0.0000	0.0000	0.0000;
	617	38	0.00149	0.066159	0	160	160	160	1.032	0	1	-360	360	-42.0201	-12.9606	42.0458	14.1039	0.0000	0.0000	0.0000	0.0000;
	665	42	0.00157	0.06775	0	160	160	160	0.9851	0	1	-360	360	-64.4825	45.1921	64.5606	-41.8248	0.0000	0.0000	0.0000	0.0000;
	667	46	0.00163	0.069461	0	160	160	160	0.9831	0	1	-360	360	-73.0278	-11.8907	73.1020	15.0508	0.0000	0.0000	0.0000	0.0000;
	669	48	0.00135	0.06052	0	250	250	250	1.015	0	1	-360	360	-21.7703	-0.3690	21.7762	0.6357	0.0000	0.0000	0.0000	0.0000;
	696	49	0.00135	0.06052	0	250	250	250	1.0503	0	1	-360	360	-46.3236	13.5566	46.3527	-12.2558	0.0000	0.0000	0.0000	0.0000;
	697	49	0.00153	0.06156	0	250	250	250	1.0535	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	715	50	0.00157	0.066159	0	160	160	160	1.0177	0	1	-360	360	-31.8024	3.7393	31.8163	-3.1535	0.0000	0.0000	0.0000	0.0000;
	731	53	0.0014	0.06235	0	250	250	250	1.064	0	1	-360	360	-73.7405	-28.4070	73.8247	32.1582	0.0000	0.0000	0.0000	0.0000;
	734	52	0.00139	0.05984	0	250	250	250	0.9828	0	1	-360	360	-42.4190	-7.5171	42.4432	8.5581	0.0000	0.0000	0.0000	0.0000;
	741	55	0.00145	0.068391	0	160	160	160	1.0058	0	1	-360	360	-35.5420	-19.3627	35.5624	20.3242	0.0000	0.0000	0.0000	0.0000;
	759	60	0.001651	0.06775	0	160	160	160	0.9893	0	1	-360	360	-54.1865	-11.8017	54.2290	13.5453	0.0000	0.0000	0.0000	0.0000;
	758	60	0.00157	0.06775	0	160	160	160	0.9886	0	1	-360	360	-54.5473	-10.5552	54.5878	12.3026	0.0000	0.0000	0.0000	0.0000;
	769	61	0.00163	0.067831	0	160	160	160	0.9899	0	1	-360	360	-49.6309	-3.8590	49.6649	5.2765	0.0000	0.0000	0.0000	0.0000;
	768	62	0.00143	0.06831	0	160	160	160	0.9902	0	1	-360	360	-49.0378	-4.4839	49.0671	5.8816	0.0000	0.0000	0.0000	0.0000;
	778	63	0.00139	0.0608	0	250	250	250	1.035	0	1	-360	360	-25.9892	-6.0154	25.9983	6.4120	0.0000	0.0000	0.0000	0.0000;
	779	64	0.0014	0.06235	0	250	250	250	1.0367	0	1	-360	360	-25.2647	-8.7979	25.2739	9.2083	0.0000	0.0000	0.0000	0.0000;
	807	65	0.00163	0.067539	0	160	160	160	1.0093	0	1	-360	360	-40.2973	-10.6623	40.3219	11.6807	0.0000	0.0000	0.0000	0.0000;
	832	67	0.00161	0.06762	0	160	160	160	1.0284	0	1	-360	360	-54.6441	-10.6936	54.6880	12.5355	0.0000	0.0000	0.0000	0.0000;
	854	68	0.00207	0.067771	-0.003001	160	160	160	1	0	1	-360	360	-73.6111	-4.4570	73.7049	7.8890	0.0000	0.0000	0.0000	0.0000;
	884	71	0.001651	0.067979	-0.003194	160	160	160	1.0049	0	1	-360	360	-64.8509	-5.1897	64.9094	7.9799	0.0000	0.0000	0.0000	0.0000;
	901	74	0.00145	0.069211	-0.005324	160	160	160	1.0003	0	1	-360	360	-45.2146	-8.5501	45.2406	10.4240	0.0000	0.0000	0.0000	0.0000;
	1001	81	0.00156	0.06269	-0.00992	250	250	250	1.092	0	1	-360	360	98.9003	-35.9450	-98.7302	43.8139	0.0000	0.0000	0.0000	0.0000;
	1002	81	0.00156	0.06269	-0.00992	250	250	250	1.0668	0	1	-360	360	111.1044	0.0360	-110.9234	8.2923	0.0000	0.0000	0.0000	0.0000;
	1091	82	0.001651	0.06694	-0.003098	160	160	160	1.0097	0	1	-360	360	64.8672	-10.4663	-64.8062	13.3026	0.0000	0.0000	0.0000	0.0000;
	1092	82	0.00145	0.066531	-0.003194	160	160	160	1.0049	0	1	-360	360	69.3555	-2.6258	-69.2963	5.7188	0.0000	0.0000	0.0000	0.0000;
	1114	83	0.00145	0.0655	-0.002517	160	160	160	0.9971	0	1	-360	360	-48.8745	-12.2172	48.9055	13.9208	0.0000	0.0000	0.0000	0.0000;
	1113	84	0.00145	0.07045	-0.002517	160	160	160	0.9962	0	1	-360	360	-61.8958	4.1442	61.9420	-1.5965	0.0000	0.0000	0.0000	0.0000;
	1187	87	0.00145	0.069831	-0.002323	160	160	160	0.9488	0	1	-360	360	-76.3030	-14.8560	76.3781	18.7480	0.0000	0.0000	0.0000	0.0000;
	1188	88	0.001651	0.067771	-0.002807	160	160	160	1.0147	0	1	-360	360	-35.0133	-33.4148	35.0472	35.1356	0.0000	0.0000	0.0000	0.0000;
	1233	93	0.00145	0.06736	-0.006582	160	160	160	1.0052	0	1	-360	360	-28.0511	-19.4901	28.0658	20.9497	0.0000	0.0000	0.0000	0.0000;
	1232	94	0.001651	0.06694	-0.002904	160	160	160	1.0057	0	1	-360	360	-52.5996	-7.2439	52.6390	9.1858	0.0000	0.0000	0.0000	0.0000;
	1247	95	0.00145	0.068391	-0.003194	160	160	160	0.9919	0	1	-360	360	-57.7916	-4.9103	57.8328	7.2341	0.0000	0.0000	0.0000	0.0000;
	1255	99	0.001651	0.06694	-0.002323	160	160	160	0.9738	0	1	-360	360	-64.1608	8.6857	64.2180	-6.0863	0.0000	0.0000	0.0000	0.0000;
	1254	100	0.001651	0.06694	-0.003194	160	160	160	0.9781	0	1	-360	360	-52.6902	2.9641	52.7284	-1.0302	0.0000	0.0000	0.0000	0.0000;
	1286	101	0.00145	0.06756	-0.002226	160	160	160	1.0116	0	1	-360	360	-77.8070	-33.1622	77.8981	37.6618	0.0000	0.0000	0.0000	0.0000;
	1285	102	0.001651	0.06756	-0.003194	160	160	160	1.0087	0	1	-360	360	-56.0833	-22.3716	56.1354	24.8795	0.0000	0.0000	0.0000	0.0000;
	1288	103	0.00145	0.066531	-0.002904	160	160	160	1.0119	0	1	-360	360	-75.0742	-29.5390	75.1554	33.6071	0.0000	0.0000	0.0000	0.0000;
	1363	104	0.001651	0.068599	-0.002904	160	160	160	1.005	0	1	-360	360	-67.6366	-6.1972	67.7003	9.1935	0.0000	0.0000	0.0000	0.0000;
	1351	105	0.00207	0.093599	-0.003388	160	160	160	0.9991	0	1	-360	360	-15.1598	-4.7556	15.1642	5.3605	0.0000	0.0000	0.0000	0.0000;
	1353	106	0.00186	0.092771	-0.003001	160	160	160	1.0093	0	1	-360	360	-47.7731	-9.1545	47.8104	11.3764	0.0000	0.0000	0.0000	0.0000;
	1388	107	0.00145	0.067151	-0.002226	160	160	160	0.9948	0	1	-360	360	-45.5009	-1.1926	45.5258	2.6163	0.0000	0.0000	0.0000	0.0000;
	1394	109	0.00145	0.0657	-0.005227	160	160	160	0.9905	0	1	-360	360	-75.0591	-0.4317	75.1277	4.1645	0.0000	0.0000	0.0000	0.0000;
	1432	110	0.00145	0.06756	-0.003485	160	160	160	1.0275	0	1	-360	360	-93.5186	-40.2515	93.6531	46.9147	0.0000	0.0000	0.0000	0.0000;
	1569	112	0.00145	0.06756	-0.002904	160	160	160	1.0059	0	1	-360	360	-82.0987	-10.9147	82.1835	15.2065	0.0000	0.0000	0.0000	0.0000;
	1629	114	0.00156	0.06269	-0.00864	250	250	250	1.0625	0	1	-360	360	-55.7361	-30.7936	55.7972	34.1682	0.0000	0.0000	0.0000	0.0000;
	1631	114	0.00156	0.06294	-0.00864	250	250	250	1.0581	0	1	-360	360	-48.5466	-20.0335	48.5877	22.6128	0.0000	0.0000	0.0000	0.0000;
	1674	115	0.00145	0.06736	-0.002226	160	160	160	1.0069	0	1	-360	360	-22.8038	-15.0047	22.8130	15.6963	0.0000	0.0000	0.0000	0.0000;
	1684	118	0.00145	0.06674	-0.006582	160	160	160	0.9884	0	1	-360	360	-87.2307	10.3250	87.3228	-5.2903	0.0000	0.0000	0.0000	0.0000;
	1790	119	0.00137	0.05988	-0.01504	250	250	250	1.062	0	1	-360	360	-62.4691	-61.1847	62.5727	67.3131	0.0000	0.0000	0.0000	0.0000;
	1792	121	0.00137	0.06119	-0.00992	250	250	250	1.0681	0	1	-360	360	-11.6126	-31.1553	11.6272	32.8848	0.0000	0.0000	0.0000	0.0000;
	1793	122	0.00156	0.06269	-0.00992	250	250	250	1.0647	0	1	-360	360	-21.6845	-27.6036	21.7029	29.4211	0.0000	0.0000	0.0000	0.0000;
	1818	123	0.001651	0.06694	-0.003001	160	160	160	0.9948	0	1	-360	360	-87.0814	-10.9360	87.1898	15.6869	0.0000	0.0000	0.0000	0.0000;
	1838	124	0.00145	0.068599	-0.002323	160	160	160	0.9984	0	1	-360	360	-71.4506	24.1266	71.5171	-20.6931	0.0000	0.0000	0.0000	0.0000;
	1837	125	0.001651	0.06818	-0.002904	160	160	160	1.0155	0	1	-360	360	-91.2312	-19.3134	91.3534	24.7078	0.0000	0.0000	0.0000	0.0000;
	1858	128	0.00145	0.06756	-0.003775	160	160	160	0.9898	0	1	-360	360	-74.9231	13.0492	74.9914	-9.4051	0.0000	0.0000	0.0000	0.0000;
	1859	129	0.00145	0.0655	-0.002904	160	160	160	1.0015	0	1	-360	360	-74.6123	-12.9526	74.6822	16.4565	0.0000	0.0000	0.0000	0.0000;
	1929	133	0.001651	0.0625	0	160	160	160	0.9999	0	1	-360	360	7.0877	17.9058	-7.0829	-17.7211	0.0000	0.0000	0.0000	0.0000;
	1950	135	0.00145	0.06818	0	160	160	160	1.0346	0	1	-360	360	-37.0497	2.6013	37.0668	-1.7979	0.0000	0.0000	0.0000	0.0000;
	1951	135	0.001651	0.06818	0	160	160	160	1.0336	0	1	-360	360	-39.7762	4.9895	39.7988	-4.0559	0.0000	0.0000	0.0000	0.0000;
	1974	136	0.00151	0.06688	0	160	160	160	1.0337	0	1	-360	360	-56.8268	0.0212	56.8685	1.8254	0.0000	0.0000	0.0000	0.0000;
	1976	137	0.00153	0.06206	0	250	250	250	1.1215	0	1	-360	360	-126.3950	-30.4337	126.6630	41.3055	0.0000	0.0000	0.0000	0.0000;
	1977	138	0.00152	0.06206	0	250	250	250	1.1015	0	1	-360	360	-114.8751	-23.8690	115.0898	32.6340	0.0000	0.0000	0.0000	0.0000;
	1982	139	0.00151	0.06688	0	160	160	160	1.001	0	1	-360	360	-89.8251	7.7728	89.9271	-3.2595	0.0000	0.0000	0.0000	0.0000;
	2008	140	0.00151	0.06688	0	160	160	160	1.0035	0	1	-360	360	-81.2427	1.1554	81.3253	2.5031	0.0000	0.0000	0.0000	0.0000;
	2014	142	0.00161	0.066531	0	160	160	160	1.0011	0	1	-360	360	-61.6008	2.4002	61.6514	-0.3092	0.0000	0.0000	0.0000	0.0000;
	2015	142	0.00161	0.066531	0	160	160	160	1.0036	0	1	-360	360	-63.1225	-1.8914	63.1759	4.0962	0.0000	0.0000	0.0000	0.0000;
	2076	143	0.00145	0.06818	0	160	160	160	1.0078	0	1	-360	360	-16.5819	13.2851	16.5875	-13.0240	0.0000	0.0000	0.0000	0.0000;
	2077	143	0.00145	0.06818	0	160	160	160	1.0256	0	1	-360	360	-54.3507	-10.8666	54.3897	12.6979	0.0000	0.0000	0.0000	0.0000;
	2092	145	0.001651	0.06851	0	160	160	160	0.9909	0	1	-360	360	-30.5760	16.1270	30.5918	-15.4722	0.0000	0.0000	0.0000	0.0000;
	2091	146	0.003409	0.231401	0	80	80	80	1.0513	0	1	-360	360	-40.4588	-20.8828	40.5219	25.1649	0.0000	0.0000	0.0000	0.0000;
	2093	2091	0.01124	0.452479	0	80	80	80	0.9223	0	1	-360	360	32.4282	4.5002	-32.3333	-0.6782	0.0000	0.0000	0.0000	0.0000;
	2093	146	0.00562	0.22624	0	80	80	80	0.9407	0	1	-360	360	20.3308	-2.2901	-20.3115	3.0665	0.0000	0.0000	0.0000	0.0000;
	2103	147	0.00163	0.061359	0.004162	160	160	160	1.0115	0	1	-360	360	-42.4681	-3.6311	42.4923	4.0279	0.0000	0.0000	0.0000	0.0000;
	2145	151	0.001651	0.0593	0	160	160	160	1.0274	0	1	-360	360	-71.6217	-34.0166	71.7161	37.4071	0.0000	0.0000	0.0000	0.0000;
	2153	152	0.001651	0.0593	0	160	160	160	1.0143	0	1	-360	360	-91.2598	9.7822	91.3748	-5.6516	0.0000	0.0000	0.0000	0.0000;
	2154	153	0.001651	0.0593	0	160	160	160	1.0118	0	1	-360	360	-102.2442	0.8209	102.3883	4.3555	0.0000	0.0000	0.0000	0.0000;
	2170	155	0.001651	0.092771	0	160	160	160	1.0296	0	1	-360	360	1.8815	-5.4557	-1.8811	5.4821	0.0000	0.0000	0.0000	0.0000;
	2171	154	0.001651	0.06694	0	160	160	160	1.0162	0	1	-360	360	14.9678	9.7976	-14.9634	-9.6181	0.0000	0.0000	0.0000	0.0000;
	2177	158	0.000289	0.061359	0.004162	160	160	160	1.0147	0	1	-360	360	-62.0342	-13.5424	62.0440	15.1186	0.0000	0.0000	0.0000	0.0000;
	2178	158	0.001651	0.068599	0	160	160	160	1.0132	0	1	-360	360	-72.1522	-3.3009	72.2240	6.2854	0.0000	0.0000	0.0000	0.0000;
	2209	160	0.00101	0.06188	-0.01984	330	330	330	1.1039	0	1	-360	360	-130.7209	-14.2159	130.8963	26.9678	0.0000	0.0000	0.0000	0.0000;
	2212	161	0.00101	0.06188	0	330	330	330	1.0942	0	1	-360	360	-108.5625	-13.3105	108.6824	20.6562	0.0000	0.0000	0.0000	0.0000;
	2213	161	0.00138	0.05931	0	250	250	250	1.096	0	1	-360	360	-128.5524	-9.2049	128.7792	18.9521	0.0000	0.0000	0.0000	0.0000;
	2214	163	0.00163	0.070331	0	160	160	160	1.0002	0	1	-360	360	56.4410	15.2190	-56.3965	-13.3024	0.0000	0.0000	0.0000	0.0000;
	2233	166	0.001651	0.0593	0	160	160	160	0.9811	0	1	-360	360	-46.2942	4.6983	46.3242	-3.6215	0.0000	0.0000	0.0000	0.0000;
	2234	166	0.001651	0.0593	0	160	160	160	0.9852	0	1	-360	360	-42.4578	-1.2429	42.4829	2.1453	0.0000	0.0000	0.0000	0.0000;
	2235	167	0.00281	0.10601	0	100	100	100	0.9302	0	1	-360	360	-26.8970	-5.1430	26.9146	5.8081	0.0000	0.0000	0.0000	0.0000;
	2236	167	0.00281	0.10601	0	100	100	100	0.9302	0	1	-360	360	-19.7370	-4.5570	19.7466	4.9203	0.0000	0.0000	0.0000	0.0000;
	2238	169	0.001651	0.0593	0	160	160	160	0.9966	0	1	-360	360	-66.1133	20.3021	66.1783	-17.9695	0.0000	0.0000	0.0000	0.0000;
	2237	170	0.00101	0.06188	-0.01984	330	330	330	1.0659	0	1	-360	360	-45.3820	-7.1324	45.4026	10.4766	0.0000	0.0000	0.0000	0.0000;
	2238	170	0.00153	0.06206	0	250	250	250	1.0827	0	1	-360	360	-41.3588	-19.8329	41.3901	21.1002	0.0000	0.0000	0.0000	0.0000;
	2251	172	0.001651	0.066531	0	160	160	160	1.0205	0	1	-360	360	-83.9238	-21.7810	84.0360	26.3048	0.0000	0.0000	0.0000	0.0000;
	2252	173	0.001651	0.06775	0	160	160	160	1.0128	0	1	-360	360	-42.2867	-17.1956	42.3176	18.4621	0.0000	0.0000	0.0000	0.0000;
	2257	174	0.001651	0.052289	0	160	160	160	1.028	0	1	-360	360	-118.8047	-10.6639	119.0051	17.0108	0.0000	0.0000	0.0000	0.0000;
	2319	175	0.001651	0.06818	0	160	160	160	1.0447	0	1	-360	360	-56.4962	-10.9641	56.5438	12.9297	0.0000	0.0000	0.0000	0.0000;
	2320	176	0.001651	0.06818	0	160	160	160	1.0406	0	1	-360	360	-51.3004	-4.1649	51.3382	5.7239	0.0000	0.0000	0.0000	0.0000;
	2423	177	0.001651	0.06632	0	160	160	160	1.0406	0	1	-360	360	-88.2060	-4.3190	88.3171	8.7836	0.0000	0.0000	0.0000	0.0000;
	2445	180	0.001651	0.06632	0	160	160	160	1.0207	0	1	-360	360	-69.6595	-19.9663	69.7377	23.1084	0.0000	0.0000	0.0000	0.0000;
	2444	180	0.001651	0.06632	0	160	160	160	1.0288	0	1	-360	360	-62.2702	-20.5753	62.3343	23.1492	0.0000	0.0000	0.0000	0.0000;
	2466	181	0.00155	0.065847	0	160	160	160	1.0528	0	1	-360	360	-64.9864	-13.6368	65.0468	16.2056	0.0000	0.0000	0.0000	0.0000;
	2489	184	0.00137	0.059687	0	250	250	250	1.0812	0	1	-360	360	-81.1802	-7.8484	81.2659	11.5823	0.0000	0.0000	0.0000	0.0000;
	2498	185	0.00129	0.064369	0	250	250	250	1.081	0	1	-360	360	-134.6691	-21.9862	134.9032	33.6689	0.0000	0.0000	0.0000	0.0000;
	2499	186	0.00129	0.064369	0	250	250	250	1.0808	0	1	-360	360	-129.2451	-20.2765	129.4596	30.9843	0.0000	0.0000	0.0000	0.0000;
	2502	188	0.0037	0.18657	0	120	120	120	1.01	0	1	-360	360	-6.1236	1.2367	6.1248	-1.1745	0.0000	0.0000	0.0000	0.0000;
	2503	187	0.001591	0.066942	0	160	160	160	1.0224	0	1	-360	360	-37.6982	-21.5872	37.7246	22.6997	0.0000	0.0000	0.0000	0.0000;
	2519	189	0.00163	0.066715	0	160	160	160	1.046	0	1	-360	360	-36.8028	-8.0160	36.8230	8.8426	0.0000	0.0000	0.0000	0.0000;
	2521	190	0.00163	0.066715	0	160	160	160	1.0519	0	1	-360	360	-36.4127	-17.1527	36.4360	18.1069	0.0000	0.0000	0.0000	0.0000;
	2520	191	0.00059	0.042063	0	330	330	330	1.1467	0	1	-360	360	-217.2326	-84.5042	217.5689	108.4796	0.0000	0.0000	0.0000	0.0000;
	2527	192	0.001591	0.067355	0	160	160	160	1.0452	0	1	-360	360	-78.9385	-5.1749	79.0252	8.8465	0.0000	0.0000	0.0000	0.0000;
	2528	193	0.001591	0.067355	0	160	160	160	1.059	0	1	-360	360	-78.4880	-26.8068	78.5859	30.9491	0.0000	0.0000	0.0000	0.0000;
	2593	195	0.00089	0.054113	0	330	330	330	1.0659	0	1	-360	360	-128.0694	-11.3251	128.2099	19.8669	0.0000	0.0000	0.0000	0.0000;
	2594	196	0.00161	0.067562	0	160	160	160	1.0205	0	1	-360	360	-40.2015	-11.1183	40.2261	12.1510	0.0000	0.0000	0.0000	0.0000;
	2595	197	0.00161	0.067562	0	160	160	160	1.0214	0	1	-360	360	-40.3006	-12.6265	40.3258	13.6871	0.0000	0.0000	0.0000	0.0000;
	2660	198	0.00059	0.042063	0	330	330	330	1.085	0	1	-360	360	-105.6307	10.9285	105.6932	-6.4766	0.0000	0.0000	0.0000	0.0000;
	2680	201	0.002771	0.106198	0	100	100	100	1.0326	0	1	-360	360	-28.4372	-12.1028	28.4610	13.0132	0.0000	0.0000	0.0000	0.0000;
	2679	200	0.00157	0.0675	0	160	160	160	1.0246	0	1	-360	360	-44.9543	-6.5899	44.9830	7.8215	0.0000	0.0000	0.0000	0.0000;
	2697	202	0.00161	0.067355	0	160	160	160	1.0306	0	1	-360	360	-61.1554	-19.0000	61.2144	21.4682	0.0000	0.0000	0.0000	0.0000;
	2697	203	0.001651	0.066715	0	160	160	160	1.03	0	1	-360	360	-61.4000	-18.0259	61.4604	20.4639	0.0000	0.0000	0.0000	0.0000;
	2717	204	0.00137	0.059687	0	250	250	250	1.0846	0	1	-360	360	-95.4346	-7.3118	95.5536	12.4940	0.0000	0.0000	0.0000	0.0000;
	2718	204	0.00137	0.059687	0	250	250	250	1.0846	0	1	-360	360	-95.0757	-7.2007	95.1937	12.3424	0.0000	0.0000	0.0000	0.0000;
	2720	206	0.00155	0.067975	0	160	160	160	1.0389	0	1	-360	360	-31.0812	-14.0729	31.0968	14.7547	0.0000	0.0000	0.0000	0.0000;
	2721	207	0.00161	0.067748	0	160	160	160	1.0367	0	1	-360	360	-31.0409	-10.4393	31.0557	11.0628	0.0000	0.0000	0.0000	0.0000;
	2584	349	0.054463	0.101322	0.00968	76	76	76	0	0	1	-360	360	-0.9633	1.3502	0.9654	-2.4824	0.0000	0.0000	0.0000	0.0000;
	2082	292	0.023719	0.06124	0.006241	51	51	51	0	0	1	-360	360	6.2926	1.1938	-6.2843	-1.9262	0.0000	0.0000	0.0000	0.0000;
	2117	315	0.024711	0.06281	0.006411	62	62	62	0	0	1	-360	360	20.2750	4.3184	-20.1872	-4.8724	0.0000	0.0000	0.0000	0.0000;
	1928	419	0.042066	0.108603	0.011069	62	62	62	0	0	1	-360	360	6.5118	7.3885	-6.4757	-8.6711	0.0000	0.0000	0.0000	0.0000;
	2064	220	0.061818	0.105041	0.01014	59	59	59	0	0	1	-360	360	-1.5479	-1.9530	1.5500	0.7293	0.0000	0.0000	0.0000	0.0000;
	2377	523	0.059256	0.103967	0.010481	59	59	59	0	0	1	-360	360	-8.1632	-7.9036	8.2231	6.7549	0.0000	0.0000	0.0000	0.0000;
	1263	242	0.033058	0.080992	0.01007	120	120	120	0	0	1	-360	360	-32.4107	-9.0858	32.7185	8.6086	0.0000	0.0000	0.0000	0.0000;
	1273	439	0.021488	0.071066	0.007241	90	90	90	0	0	1	-360	360	0.0000	-0.8659	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	676	380	0.047273	0.083876	0.00786	78	78	78	0	0	1	-360	360	-20.6044	4.3599	20.7898	-4.9331	0.0000	0.0000	0.0000	0.0000;
	628	405	0.074628	0.130248	0.012439	78	78	78	0	0	1	-360	360	18.6378	-15.3536	-18.2804	14.5128	0.0000	0.0000	0.0000	0.0000;
	774	463	0.052231	0.090083	0.008661	78	78	78	0	0	1	-360	360	-16.4913	-4.2341	16.6185	3.4268	0.0000	0.0000	0.0000	0.0000;
	828	1279	0.045446	0.079339	0.008521	90	90	90	0	0	1	-360	360	-7.2567	0.4798	7.2774	-1.4479	0.0000	0.0000	0.0000	0.0000;
	677	1575	0.03719	0.060331	0.006561	58	58	58	0	0	1	-360	360	-18.1462	2.9429	18.2562	-3.5223	0.0000	0.0000	0.0000	0.0000;
	741	1654	0.041322	0.139669	0.01241	90	90	90	0	0	1	-360	360	10.5257	2.8565	-10.4823	-4.1613	0.0000	0.0000	0.0000	0.0000;
	767	1361	0.023967	0.053719	0.008809	51	51	51	0	0	1	-360	360	0.1766	6.7623	-0.1653	-7.7179	0.0000	0.0000	0.0000	0.0000;
	1738	597	0.02438	0.049091	0.004709	76	76	76	0	0	1	-360	360	15.4216	2.9239	-15.3676	-3.3403	0.0000	0.0000	0.0000	0.0000;
	2203	1149	0.035537	0.066124	0.00765	90	90	90	0	0	1	-360	360	-27.6029	-4.2816	27.8416	3.8314	0.0000	0.0000	0.0000	0.0000;
	2416	1148	0.070248	0.120661	0.012901	67	67	67	0	0	1	-360	360	-5.1650	-0.6820	5.1810	-0.8104	0.0000	0.0000	0.0000	0.0000;
	2422	984	0.021488	0.027273	0.005111	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2651	2152	0.068256	0.184298	0.017981	50	50	50	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2485	2357	0.034628	0.060744	0.005711	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2686	2011	0.029174	0.051157	0.004859	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2672	2214	0.03719	0.096686	0.010159	102	102	102	0	0	1	-360	360	-63.5826	-1.1470	64.8331	3.1499	0.0000	0.0000	0.0000	0.0000;
	2608	2215	0.082066	0.200083	0.02217	102	102	102	0	0	1	-360	360	-10.5289	-19.3465	10.8405	17.4504	0.0000	0.0000	0.0000	0.0000;
	2613	2214	0.044628	0.115207	0.012049	102	102	102	0	0	1	-360	360	-61.1348	-3.4564	62.5408	5.6141	0.0000	0.0000	0.0000	0.0000;
	2561	2091	0.041322	0.087603	0.012199	87	87	87	0	0	1	-360	360	-68.1575	8.9360	69.7960	-6.9465	0.0000	0.0000	0.0000	0.0000;
	2559	1933	0.039256	0.107438	0.011081	87	87	87	0	0	1	-360	360	-36.2387	11.2385	36.7218	-11.2285	0.0000	0.0000	0.0000	0.0000;
	2578	2215	0.056281	0.183223	0.01876	123	123	123	0	0	1	-360	360	-14.4539	-15.2708	14.6503	13.6424	0.0000	0.0000	0.0000	0.0000;
	1688	790	0.038843	0.064463	0.00695	58	58	58	0	0	1	-360	360	24.1104	-5.4900	-23.9106	5.0055	0.0000	0.0000	0.0000	0.0000;
	2648	2202	0.023058	0.07438	0.007841	123	123	123	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	664	452	0.046777	0.323967	0.031511	123	123	123	0	0	1	-360	360	25.5045	-2.0353	-25.2534	-0.0162	0.0000	0.0000	0.0000	0.0000;
	1291	2074	0.040496	0.050413	0.00719	57	57	57	0	0	1	-360	360	8.6998	-9.0467	-8.6480	8.2667	0.0000	0.0000	0.0000	0.0000;
	523	1213	0.057016	0.113223	0.01232	90	90	90	0	0	1	-360	360	2.7383	-0.7274	-2.7348	-0.7528	0.0000	0.0000	0.0000	0.0000;
	664	463	0.016364	0.053141	0.00619	120	120	120	0	0	1	-360	360	23.0889	5.9324	-23.0115	-6.4268	0.0000	0.0000	0.0000	0.0000;
	665	252	0.056612	0.130504	0.013	78	78	78	0	0	1	-360	360	43.6745	-8.5778	-42.7542	9.1422	0.0000	0.0000	0.0000	0.0000;
	510	1017	0.009917	0.029752	0.00356	137	137	137	0	0	1	-360	360	22.9287	1.3558	-22.8858	-1.6607	0.0000	0.0000	0.0000	0.0000;
	2533	2388	0.053331	0.089256	0.009169	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	762	380	0.013967	0.045041	0.00462	123	123	123	0	0	1	-360	360	-13.9418	4.2720	13.9678	-4.7210	0.0000	0.0000	0.0000	0.0000;
	710	333	0.059917	0.101488	0.01089	78	78	78	0	0	1	-360	360	5.0884	-0.5190	-5.0755	-0.7592	0.0000	0.0000	0.0000	0.0000;
	695	452	0.07438	0.130248	0.012359	84	84	84	0	0	1	-360	360	39.3184	-13.4684	-38.2744	13.8067	0.0000	0.0000	0.0000	0.0000;
	2551	254	0.038843	0.126446	0.013	76	76	76	0	0	1	-360	360	-4.5916	-3.1056	4.6006	1.6309	0.0000	0.0000	0.0000	0.0000;
	2584	240	0.037017	0.06719	0.006389	76	76	76	0	0	1	-360	360	-9.6372	1.6272	9.6678	-2.3240	0.0000	0.0000	0.0000	0.0000;
	728	479	0.01719	0.055703	0.005689	123	123	123	0	0	1	-360	360	0.3812	-0.0248	-0.3812	-0.6281	0.0000	0.0000	0.0000	0.0000;
	828	1668	0.01405	0.042984	0.00513	114	114	114	0	0	1	-360	360	-2.2853	-1.4798	2.2861	0.8783	0.0000	0.0000	0.0000	0.0000;
	1768	709	0.021488	0.040496	0.007991	120	120	120	0	0	1	-360	360	25.6775	-4.9930	-25.5528	4.2942	0.0000	0.0000	0.0000	0.0000;
	1706	709	0.019008	0.033876	0.00697	57	57	57	0	0	1	-360	360	-12.7963	5.5406	12.8288	-6.2942	0.0000	0.0000	0.0000	0.0000;
	1592	740	0.047934	0.06281	0.01111	58	58	58	0	0	1	-360	360	-45.7272	-0.2737	46.6110	0.1470	0.0000	0.0000	0.0000	0.0000;
	760	333	0.042314	0.075289	0.007059	78	78	78	0	0	1	-360	360	-3.4295	-2.7303	3.4356	1.9028	0.0000	0.0000	0.0000	0.0000;
	2670	372	0.037273	0.130413	0.010919	69	69	69	0	0	1	-360	360	-6.7900	-3.0099	6.8068	1.8078	0.0000	0.0000	0.0000	0.0000;
	2456	336	0.076859	0.095041	0.010159	69	69	69	0	0	1	-360	360	-1.7135	-1.8925	1.7165	0.7088	0.0000	0.0000	0.0000	0.0000;
	665	470	0.056529	0.185868	0.019079	123	123	123	0	0	1	-360	360	8.8501	-0.3305	-8.8132	-1.8459	0.0000	0.0000	0.0000	0.0000;
	712	448	0.028256	0.096686	0.009361	34	34	34	0	0	1	-360	360	-10.5556	2.9274	10.5852	-3.9324	0.0000	0.0000	0.0000	0.0000;
	2539	2331	0.04314	0.071901	0.00741	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	658	1021	0.019008	0.058678	0.00682	90	90	90	0	0	1	-360	360	-14.1527	1.3385	14.1878	-1.9827	0.0000	0.0000	0.0000	0.0000;
	2583	2388	0.030744	0.099173	0.01021	69	69	69	0	0	1	-360	360	8.7079	-4.0226	-8.6862	2.8276	0.0000	0.0000	0.0000	0.0000;
	2580	347	0.021397	0.067603	0.006921	19	19	19	0	0	1	-360	360	3.7316	-0.2886	-3.7290	-0.5000	0.0000	0.0000	0.0000	0.0000;
	1519	2134	0.012397	0.03719	0.004361	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	428	356	0.012231	0.028678	0.00295	133	133	133	0	0	1	-360	360	-26.4226	-1.2615	26.4954	1.0842	0.0000	0.0000	0.0000	0.0000;
	317	219	0.019587	0.063554	0.00659	133	133	133	0	0	1	-360	360	-17.4192	5.3497	17.4755	-5.9370	0.0000	0.0000	0.0000	0.0000;
	565	518	0.00686	0.022066	0.002321	133	133	133	0	0	1	-360	360	-37.2938	-7.3005	37.3777	7.2957	0.0000	0.0000	0.0000	0.0000;
	427	565	0.005537	0.018017	0.001839	133	133	133	0	0	1	-360	360	-35.1023	-6.9378	35.1627	6.9180	0.0000	0.0000	0.0000	0.0000;
	565	569	0.002727	0.009496	0.000999	133	133	133	0	0	1	-360	360	2.1311	0.3825	-2.1310	-0.5000	0.0000	0.0000	0.0000	0.0000;
	346	342	0.023554	0.061066	0.00629	120	120	120	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.7560	0.0000	0.0000	0.0000	0.0000;
	345	343	0.023388	0.061901	0.00629	120	120	120	0	0	1	-360	360	-1.3467	-22.0547	1.4397	21.5460	0.0000	0.0000	0.0000	0.0000;
	388	342	0.015446	0.044876	0.004339	120	120	120	0	0	1	-360	360	-13.1084	-3.5739	13.1320	3.1226	0.0000	0.0000	0.0000	0.0000;
	476	343	0.019669	0.059587	0.005871	120	120	120	0	0	1	-360	360	-17.8219	-4.9451	17.8773	4.4040	0.0000	0.0000	0.0000	0.0000;
	261	404	0.031818	0.058512	0.00559	90	90	90	0	0	1	-360	360	-8.0980	-1.5000	8.1160	0.8679	0.0000	0.0000	0.0000	0.0000;
	262	405	0.032562	0.06124	0.005491	90	90	90	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.6497	0.0000	0.0000	0.0000	0.0000;
	459	343	0.002479	0.007769	0.000871	137	137	137	0	0	1	-360	360	-66.1087	-9.1093	66.1999	9.2897	0.0000	0.0000	0.0000	0.0000;
	480	404	0.040579	0.076124	0.006781	90	90	90	0	0	1	-360	360	-18.5702	-4.3762	18.6951	3.8088	0.0000	0.0000	0.0000	0.0000;
	518	459	0.013967	0.043967	0.00485	137	137	137	0	0	1	-360	360	-55.7226	-6.7257	56.0927	7.3093	0.0000	0.0000	0.0000	0.0000;
	426	348	0.043058	0.07157	0.007541	90	90	90	0	0	1	-360	360	-9.2239	-3.1177	9.2574	2.2776	0.0000	0.0000	0.0000	0.0000;
	370	239	0.027364	0.059917	0.00581	90	90	90	0	0	1	-360	360	-17.5919	7.0681	17.6768	-7.5647	0.0000	0.0000	0.0000	0.0000;
	425	237	0.024554	0.079669	0.00818	133	133	133	0	0	1	-360	360	2.5532	3.3821	-2.5487	-4.3359	0.0000	0.0000	0.0000	0.0000;
	480	273	0.055537	0.121653	0.01065	90	90	90	0	0	1	-360	360	6.3162	-0.6238	-6.2973	-0.5789	0.0000	0.0000	0.0000	0.0000;
	462	450	0.111818	0.190744	0.019089	90	90	90	0	0	1	-360	360	-18.5644	7.0229	18.9547	-8.6167	0.0000	0.0000	0.0000	0.0000;
	465	253	0.030826	0.100083	0.010341	133	133	133	0	0	1	-360	360	11.1653	7.3595	-11.1169	-8.4315	0.0000	0.0000	0.0000	0.0000;
	288	276	0.019669	0.064554	0.00652	133	133	133	0	0	1	-360	360	-19.7495	-3.4096	19.8132	2.8121	0.0000	0.0000	0.0000	0.0000;
	303	277	0.020909	0.06876	0.006941	133	133	133	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.8528	0.0000	0.0000	0.0000	0.0000;
	330	392	0.023636	0.077364	0.007889	120	120	120	0	0	1	-360	360	-17.7136	-3.4900	17.7759	2.7230	0.0000	0.0000	0.0000	0.0000;
	331	330	0.002479	0.008017	0.00082	120	120	120	0	0	1	-360	360	-12.3824	-1.5801	12.3856	1.4900	0.0000	0.0000	0.0000	0.0000;
	334	259	0.04314	0.08281	0.0075	90	90	90	0	0	1	-360	360	-2.6640	-0.8000	2.6666	-0.1080	0.0000	0.0000	0.0000	0.0000;
	376	277	0.02281	0.074463	0.007589	133	133	133	0	0	1	-360	360	-28.4645	-0.0231	28.6166	-0.4081	0.0000	0.0000	0.0000	0.0000;
	577	430	0.029339	0.095124	0.00992	133	133	133	0	0	1	-360	360	-1.4920	-0.4000	1.4925	-0.8342	0.0000	0.0000	0.0000	0.0000;
	389	315	0.013719	0.044554	0.00461	133	133	133	0	0	1	-360	360	-3.6441	-6.1072	3.6496	5.5711	0.0000	0.0000	0.0000	0.0000;
	338	238	0.029752	0.076859	0.00795	120	120	120	0	0	1	-360	360	-1.0891	-5.8650	1.0967	4.9375	0.0000	0.0000	0.0000	0.0000;
	385	327	0.031488	0.103471	0.01045	133	133	133	0	0	1	-360	360	37.5882	-2.4966	-37.2245	2.4200	0.0000	0.0000	0.0000	0.0000;
	386	373	0.047364	0.083141	0.007889	90	90	90	0	0	1	-360	360	15.7953	0.0016	-15.6979	-0.7835	0.0000	0.0000	0.0000	0.0000;
	373	289	0.024298	0.079752	0.008049	133	133	133	0	0	1	-360	360	36.9320	-4.6473	-36.6523	4.6039	0.0000	0.0000	0.0000	0.0000;
	390	354	0.006446	0.020248	0.002229	90	90	90	0	0	1	-360	360	-10.0534	2.3999	10.0593	-2.6457	0.0000	0.0000	0.0000	0.0000;
	418	374	0.037017	0.121322	0.0121	133	133	133	0	0	1	-360	360	10.0597	2.8493	-10.0242	-4.1596	0.0000	0.0000	0.0000	0.0000;
	535	465	0.022562	0.073223	0.0075	133	133	133	0	0	1	-360	360	7.8750	5.4207	-7.8570	-6.2669	0.0000	0.0000	0.0000	0.0000;
	585	328	0.059256	0.104554	0.00969	90	90	90	0	0	1	-360	360	-5.2611	1.4517	5.2772	-2.5571	0.0000	0.0000	0.0000	0.0000;
	465	222	0.027438	0.082636	0.009951	133	133	133	0	0	1	-360	360	4.4560	3.4535	-4.4478	-4.6181	0.0000	0.0000	0.0000	0.0000;
	464	478	0.048934	0.155041	0.01573	133	133	133	0	0	1	-360	360	-5.7138	-5.4629	5.7354	3.6285	0.0000	0.0000	0.0000	0.0000;
	454	426	0.023802	0.078099	0.007889	133	133	133	0	0	1	-360	360	-1.7623	-3.5408	1.7649	2.6187	0.0000	0.0000	0.0000	0.0000;
	291	402	0.007107	0.02281	0.00242	133	133	133	0	0	1	-360	360	-30.0893	4.5726	30.1454	-4.6776	0.0000	0.0000	0.0000	0.0000;
	491	455	0.013719	0.04438	0.0046	137	137	137	0	0	1	-360	360	-10.7368	7.8722	10.7578	-8.3483	0.0000	0.0000	0.0000	0.0000;
	536	294	0.020909	0.052727	0.005801	120	120	120	0	0	1	-360	360	-15.7505	-4.3733	15.7974	3.8057	0.0000	0.0000	0.0000	0.0000;
	272	320	0.011157	0.030413	0.003291	133	133	133	0	0	1	-360	360	-25.9025	-11.6386	25.9787	11.4580	0.0000	0.0000	0.0000	0.0000;
	320	352	0.006686	0.019339	0.002069	137	137	137	0	0	1	-360	360	-32.9047	-13.9580	32.9765	13.9192	0.0000	0.0000	0.0000	0.0000;
	568	517	0.004554	0.014711	0.001539	133	133	133	0	0	1	-360	360	-2.1320	-1.5000	2.1323	1.3221	0.0000	0.0000	0.0000	0.0000;
	210	354	0.006281	0.019339	0.00221	137	137	137	0	0	1	-360	360	38.1193	19.0314	-38.0239	-19.0008	0.0000	0.0000	0.0000	0.0000;
	210	361	0.006198	0.019917	0.002096	137	137	137	0	0	1	-360	360	-42.3813	-21.0314	42.4969	21.1503	0.0000	0.0000	0.0000	0.0000;
	550	354	0.00438	0.010826	0.001191	133	133	133	0	0	1	-360	360	-42.9208	-5.1416	42.9901	5.1720	0.0000	0.0000	0.0000	0.0000;
	559	503	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	-3.2617	4.7705	3.2639	-5.0010	0.0000	0.0000	0.0000	0.0000;
	560	504	0.007273	0.020661	0.002021	120	120	120	0	0	1	-360	360	19.9853	4.8528	-19.9589	-5.0135	0.0000	0.0000	0.0000	0.0000;
	504	494	0.00562	0.017769	0.001951	133	133	133	0	0	1	-360	360	-28.0074	-3.2720	28.0458	3.1660	0.0000	0.0000	0.0000	0.0000;
	495	355	0.007438	0.019008	0.002081	133	133	133	0	0	1	-360	360	-62.1453	-12.7808	62.4014	13.1907	0.0000	0.0000	0.0000	0.0000;
	545	357	0.004298	0.026942	0.002887	120	120	120	0	0	1	-360	360	-52.2133	-8.2759	52.3155	8.5769	0.0000	0.0000	0.0000	0.0000;
	533	355	0.013636	0.033967	0.003751	120	120	120	0	0	1	-360	360	-45.5282	-6.6051	45.7755	6.7808	0.0000	0.0000	0.0000	0.0000;
	527	354	0.010826	0.02719	0.003001	120	120	120	0	0	1	-360	360	-50.9821	-7.5106	51.2275	7.7735	0.0000	0.0000	0.0000	0.0000;
	543	532	0.003876	0.009421	0.00105	120	120	120	0	0	1	-360	360	10.5328	6.2530	-10.5278	-6.3639	0.0000	0.0000	0.0000	0.0000;
	537	563	0.010165	0.025289	0.002708	120	120	120	0	0	1	-360	360	7.4986	0.0350	-7.4937	-0.3403	0.0000	0.0000	0.0000	0.0000;
	491	354	0.00157	0.005124	0.00053	133	133	133	0	0	1	-360	360	7.5398	-8.7722	-7.5380	8.7152	0.0000	0.0000	0.0000	0.0000;
	492	354	0.002066	0.006686	0.000709	133	133	133	0	0	1	-360	360	-15.9856	-4.3877	15.9904	4.3192	0.0000	0.0000	0.0000	0.0000;
	537	526	0.017934	0.048016	0.00522	120	120	120	0	0	1	-360	360	-22.9177	7.0037	23.0061	-7.3794	0.0000	0.0000	0.0000	0.0000;
	540	550	0.01405	0.039669	0.00432	133	133	133	0	0	1	-360	360	-31.5062	-2.1316	31.6258	1.9616	0.0000	0.0000	0.0000	0.0000;
	538	537	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-10.6550	-3.0000	10.6596	2.8703	0.0000	0.0000	0.0000	0.0000;
	539	536	0.00438	0.010578	0.0012	120	120	120	0	0	1	-360	360	-10.6550	-3.0000	10.6595	2.8698	0.0000	0.0000	0.0000	0.0000;
	560	544	0.007273	0.017603	0.00196	120	120	120	0	0	1	-360	360	-26.4356	-4.6241	26.4803	4.5028	0.0000	0.0000	0.0000	0.0000;
	560	501	0.00124	0.003058	0.000351	120	120	120	0	0	1	-360	360	31.8595	5.9365	-31.8484	-5.9500	0.0000	0.0000	0.0000	0.0000;
	540	503	0.002066	0.006942	0.000699	133	133	133	0	0	1	-360	360	15.5222	-1.6184	-15.5179	1.5510	0.0000	0.0000	0.0000	0.0000;
	518	343	0.01405	0.044463	0.00484	133	133	133	0	0	1	-360	360	-66.5993	-8.1173	67.1313	9.2196	0.0000	0.0000	0.0000	0.0000;
	567	275	0.004876	0.015793	0.00166	120	120	120	0	0	1	-360	360	45.5786	12.3259	-45.4874	-12.2283	0.0000	0.0000	0.0000	0.0000;
	528	275	0.01314	0.034711	0.00364	120	120	120	0	0	1	-360	360	-45.2410	-12.0052	45.4874	12.2283	0.0000	0.0000	0.0000	0.0000;
	342	274	0.008678	0.028256	0.00287	120	120	120	0	0	1	-360	360	35.6854	12.9970	-35.5809	-12.9998	0.0000	0.0000	0.0000	0.0000;
	339	274	0.002066	0.005289	0.00054	120	120	120	0	0	1	-360	360	-35.3433	-12.9407	35.3679	12.9398	0.0000	0.0000	0.0000	0.0000;
	536	339	0.008099	0.019587	0.00219	120	120	120	0	0	1	-360	360	-25.7006	-10.3721	25.7533	10.2407	0.0000	0.0000	0.0000	0.0000;
	552	340	0.012479	0.032149	0.00319	120	120	120	0	0	1	-360	360	16.9061	2.0080	-16.8749	-2.2977	0.0000	0.0000	0.0000	0.0000;
	541	496	0.000413	0.001653	0.008661	109	109	109	0	0	1	-360	360	17.0156	4.4681	-17.0145	-5.4778	0.0000	0.0000	0.0000	0.0000;
	496	563	0.002521	0.007207	0.009269	120	120	120	0	0	1	-360	360	-7.4925	-1.4222	7.4937	0.3403	0.0000	0.0000	0.0000	0.0000;
	533	563	0.001372	0.003545	0.000361	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	356	362	0.012397	0.039174	0.004291	133	133	133	0	0	1	-360	360	-33.5160	-24.5910	33.6958	24.6458	0.0000	0.0000	0.0000	0.0000;
	519	362	0.00438	0.014132	0.001498	133	133	133	0	0	1	-360	360	-82.8498	-20.7662	83.1166	21.4466	0.0000	0.0000	0.0000	0.0000;
	351	507	0.012727	0.03562	0.003531	133	133	133	0	0	1	-360	360	-37.5678	-8.5959	37.7288	8.6297	0.0000	0.0000	0.0000	0.0000;
	559	351	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-29.8918	-6.8015	29.8958	6.7959	0.0000	0.0000	0.0000	0.0000;
	546	272	0.004207	0.011653	0.001261	133	133	133	0	0	1	-360	360	-18.0024	-9.8945	18.0175	9.7886	0.0000	0.0000	0.0000	0.0000;
	504	421	0.001397	0.005868	0.031039	95	95	95	0	0	1	-360	360	35.7123	4.8355	-35.6965	-8.3782	0.0000	0.0000	0.0000	0.0000;
	354	579	0.005289	0.016942	0.001781	133	133	133	0	0	1	-360	360	16.8505	4.0025	-16.8371	-4.1704	0.0000	0.0000	0.0000	0.0000;
	356	516	0.003967	0.01281	0.00135	133	133	133	0	0	1	-360	360	23.2507	5.2654	-23.2316	-5.3633	0.0000	0.0000	0.0000	0.0000;
	525	545	0.000413	0.001901	0.009929	98	98	98	0	0	1	-360	360	-49.5477	-10.2277	49.5567	9.1044	0.0000	0.0000	0.0000	0.0000;
	532	527	0.003223	0.007934	0.000881	120	120	120	0	0	1	-360	360	-12.6184	3.1978	12.6231	-3.2894	0.0000	0.0000	0.0000	0.0000;
	547	492	0.003141	0.009917	0.001019	133	133	133	0	0	1	-360	360	-9.5900	-2.7000	9.5926	2.5877	0.0000	0.0000	0.0000	0.0000;
	507	580	0.000579	0.001744	0.000179	133	133	133	0	0	1	-360	360	-64.3678	-16.1297	64.3892	16.1731	0.0000	0.0000	0.0000	0.0000;
	543	536	0.00438	0.010661	0.001191	120	120	120	0	0	1	-360	360	-31.8438	-11.2530	31.8864	11.2168	0.0000	0.0000	0.0000	0.0000;
	552	501	0.010174	0.024628	0.002739	120	120	120	0	0	1	-360	360	-16.9061	-2.0080	16.9314	1.7500	0.0000	0.0000	0.0000	0.0000;
	549	532	0.006612	0.022314	0.00218	133	133	133	0	0	1	-360	360	-2.6875	2.3413	2.6882	-2.5939	0.0000	0.0000	0.0000	0.0000;
	549	536	0.005793	0.018934	0.00198	133	133	133	0	0	1	-360	360	-26.0815	-9.0913	26.1191	8.9819	0.0000	0.0000	0.0000	0.0000;
	534	533	0.002314	0.00686	0.000699	133	133	133	0	0	1	-360	360	-25.0577	-0.8895	25.0702	0.8451	0.0000	0.0000	0.0000	0.0000;
	537	534	0.012727	0.041322	0.004221	133	133	133	0	0	1	-360	360	7.9885	7.9626	-7.9743	-8.4095	0.0000	0.0000	0.0000	0.0000;
	519	580	0.003554	0.011397	0.001191	133	133	133	0	0	1	-360	360	64.7348	16.5162	-64.6022	-16.2331	0.0000	0.0000	0.0000	0.0000;
	352	508	0.000504	0.001488	0.00015	133	133	133	0	0	1	-360	360	-32.9765	-13.9192	32.9819	13.9172	0.0000	0.0000	0.0000	0.0000;
	521	579	0.002149	0.006942	0.000731	133	133	133	0	0	1	-360	360	-10.4420	-2.4500	10.4441	2.3704	0.0000	0.0000	0.0000	0.0000;
	520	515	0.002397	0.007851	0.00082	133	133	133	0	0	1	-360	360	-10.4420	-2.4500	10.4443	2.3609	0.0000	0.0000	0.0000	0.0000;
	560	546	0.003554	0.009917	0.00106	133	133	133	0	0	1	-360	360	-2.5512	-5.6652	2.5524	5.5445	0.0000	0.0000	0.0000	0.0000;
	559	219	0.009917	0.029752	0.003161	120	120	120	0	0	1	-360	360	26.0583	-4.1303	-25.9995	3.9370	0.0000	0.0000	0.0000	0.0000;
	537	505	0.013388	0.03876	0.004099	120	120	120	0	0	1	-360	360	31.6440	9.8284	-31.5181	-9.9415	0.0000	0.0000	0.0000	0.0000;
	502	340	0.019669	0.053554	0.005779	120	120	120	0	0	1	-360	360	-7.2759	-0.2413	7.2849	-0.4023	0.0000	0.0000	0.0000	0.0000;
	505	502	0.002636	0.008512	0.000891	120	120	120	0	0	1	-360	360	17.4521	6.6415	-17.4441	-6.7187	0.0000	0.0000	0.0000	0.0000;
	544	518	0.008512	0.022066	0.00241	120	120	120	0	0	1	-360	360	-50.1353	-11.1628	50.3264	11.3735	0.0000	0.0000	0.0000	0.0000;
	551	517	0.004628	0.012314	0.001261	120	120	120	0	0	1	-360	360	-2.9456	-1.2104	2.9460	1.0651	0.0000	0.0000	0.0000	0.0000;
	548	404	0.018934	0.063554	0.00649	133	133	133	0	0	1	-360	360	-9.5900	-2.7000	9.6055	1.9800	0.0000	0.0000	0.0000	0.0000;
	526	405	0.016198	0.040174	0.004361	120	120	120	0	0	1	-360	360	-37.3911	3.9994	37.5865	-4.0289	0.0000	0.0000	0.0000	0.0000;
	517	497	0.008678	0.027851	0.002931	133	133	133	0	0	1	-360	360	-7.2092	-2.9872	7.2137	2.6607	0.0000	0.0000	0.0000	0.0000;
	518	402	0.020661	0.066446	0.006979	133	133	133	0	0	1	-360	360	34.6179	-3.8262	-34.4074	3.6776	0.0000	0.0000	0.0000	0.0000;
	545	542	0.000826	0.003719	0.019491	109	109	109	0	0	1	-360	360	60.7320	12.5774	-60.7047	-14.7394	0.0000	0.0000	0.0000	0.0000;
	342	567	0.004132	0.013314	0.001401	120	120	120	0	0	1	-360	360	49.8261	13.3531	-49.7346	-13.2259	0.0000	0.0000	0.0000	0.0000;
	530	524	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	-5.8600	-1.3800	5.8602	-0.0379	0.0000	0.0000	0.0000	0.0000;
	422	531	0.00057	0.002314	0.0121	98	98	98	0	0	1	-360	360	5.8602	-0.0250	-5.8600	-1.3800	0.0000	0.0000	0.0000	0.0000;
	551	528	0.004132	0.010992	0.001169	120	120	120	0	0	1	-360	360	-31.8834	-8.2896	31.9220	8.2562	0.0000	0.0000	0.0000	0.0000;
	508	361	0.003967	0.012727	0.00137	133	133	133	0	0	1	-360	360	-86.2589	-28.9172	86.5331	29.6317	0.0000	0.0000	0.0000	0.0000;
	470	333	0.033223	0.107851	0.011139	133	133	133	0	0	1	-360	360	5.8292	0.8459	-5.8191	-2.1436	0.0000	0.0000	0.0000	0.0000;
	358	296	0.02124	0.069752	0.00704	133	133	133	0	0	1	-360	360	-4.8067	-0.7984	4.8109	-0.0229	0.0000	0.0000	0.0000	0.0000;
	411	344	0.068603	0.12	0.01149	90	90	90	0	0	1	-360	360	24.1448	-15.2990	-23.6828	14.7461	0.0000	0.0000	0.0000	0.0000;
	584	466	0.041744	0.076281	0.00695	90	90	90	0	0	1	-360	360	-25.0215	10.4148	25.2866	-10.7455	0.0000	0.0000	0.0000	0.0000;
	522	427	0.013719	0.03719	0.00363	120	120	120	0	0	1	-360	360	-26.4902	-6.8225	26.5783	6.6378	0.0000	0.0000	0.0000	0.0000;
	411	252	0.017769	0.03124	0.002969	90	90	90	0	0	1	-360	360	-30.8578	14.4990	31.0332	-14.5422	0.0000	0.0000	0.0000	0.0000;
	466	450	0.032397	0.095868	0.00967	90	90	90	0	0	1	-360	360	-37.9666	5.3455	38.3736	-5.2846	0.0000	0.0000	0.0000	0.0000;
	381	239	0.015041	0.030752	0.002979	90	90	90	0	0	1	-360	360	-7.4509	-1.1296	7.4581	0.7947	0.0000	0.0000	0.0000	0.0000;
	416	381	0.011818	0.019669	0.002069	90	90	90	0	0	1	-360	360	-5.3170	-0.3672	5.3199	0.1296	0.0000	0.0000	0.0000	0.0000;
	253	231	0.009174	0.029826	0.003071	133	133	133	0	0	1	-360	360	-0.6041	4.4315	0.6058	-4.7872	0.0000	0.0000	0.0000	0.0000;
	423	231	0.007851	0.025446	0.002621	133	133	133	0	0	1	-360	360	5.9362	-4.0839	-5.9328	3.7872	0.0000	0.0000	0.0000	0.0000;
	451	450	0.006364	0.020909	0.00212	133	133	133	0	0	1	-360	360	57.2307	-12.6264	-57.0475	12.9761	0.0000	0.0000	0.0000	0.0000;
	522	436	0.022397	0.039256	0.00372	90	90	90	0	0	1	-360	360	5.8673	1.5818	-5.8600	-2.0000	0.0000	0.0000	0.0000	0.0000;
	557	437	0.078678	0.139339	0.01292	90	90	90	0	0	1	-360	360	4.2748	0.1984	-4.2620	-1.7000	0.0000	0.0000	0.0000	0.0000;
	529	522	0.00595	0.01157	0.001101	90	90	90	0	0	1	-360	360	-11.8780	-3.7529	11.8859	3.6407	0.0000	0.0000	0.0000	0.0000;
	484	211	0.04719	0.082727	0.00785	90	90	90	0	0	1	-360	360	6.5250	3.8102	-6.5000	-4.6630	0.0000	0.0000	0.0000	0.0000;
	428	424	0.004959	0.014207	0.00145	120	120	120	0	0	1	-360	360	21.0946	-0.7385	-21.0758	0.6220	0.0000	0.0000	0.0000	0.0000;
	425	386	0.059256	0.191983	0.01974	133	133	133	0	0	1	-360	360	-10.6512	-5.0821	10.7154	2.9186	0.0000	0.0000	0.0000	0.0000;
	513	239	0.002893	0.009256	0.000961	133	133	133	0	0	1	-360	360	-3.4860	-7.6357	3.4877	7.5284	0.0000	0.0000	0.0000	0.0000;
	385	383	0.003967	0.012984	0.001319	133	133	133	0	0	1	-360	360	27.9464	4.0983	-27.9206	-4.1753	0.0000	0.0000	0.0000	0.0000;
	570	383	0.017017	0.055124	0.005421	133	133	133	0	0	1	-360	360	-20.4023	-2.8435	20.4616	2.3753	0.0000	0.0000	0.0000	0.0000;
	556	553	0.011066	0.019339	0.001839	90	90	90	0	0	1	-360	360	-5.3595	-0.4972	5.3622	0.2840	0.0000	0.0000	0.0000	0.0000;
	476	293	0.009421	0.030413	0.003151	133	133	133	0	0	1	-360	360	16.7559	4.4451	-16.7322	-4.7462	0.0000	0.0000	0.0000	0.0000;
	420	348	0.060909	0.10124	0.01098	90	90	90	0	0	1	-360	360	14.6975	2.1400	-14.5854	-3.2776	0.0000	0.0000	0.0000	0.0000;
	382	385	0.006777	0.014463	0.001319	133	133	133	0	0	1	-360	360	-30.5952	-4.9229	30.6485	4.8753	0.0000	0.0000	0.0000	0.0000;
	420	382	0.006529	0.012066	0.00129	90	90	90	0	0	1	-360	360	-19.9185	-2.9400	19.9402	2.8229	0.0000	0.0000	0.0000	0.0000;
	386	384	0.039669	0.128603	0.01323	133	133	133	0	0	1	-360	360	3.9343	7.9376	-3.9043	-9.4316	0.0000	0.0000	0.0000	0.0000;
	384	338	0.023141	0.055868	0.00629	120	120	120	0	0	1	-360	360	-8.3497	5.9316	8.3710	-6.6276	0.0000	0.0000	0.0000	0.0000;
	557	338	0.053223	0.135124	0.013741	120	120	120	0	0	1	-360	360	-2.6443	-0.7013	2.6474	-0.9198	0.0000	0.0000	0.0000	0.0000;
	500	338	0.039421	0.127686	0.01323	133	133	133	0	0	1	-360	360	17.5326	-11.8052	-17.3883	10.7124	0.0000	0.0000	0.0000	0.0000;
	318	374	0.020174	0.06405	0.006749	133	133	133	0	0	1	-360	360	3.8421	-2.2207	-3.8390	1.4404	0.0000	0.0000	0.0000	0.0000;
	390	222	0.035289	0.108182	0.010999	90	90	90	0	0	1	-360	360	3.6594	-4.3999	-3.6512	3.1181	0.0000	0.0000	0.0000	0.0000;
	267	424	0.003314	0.010909	0.001101	133	133	133	0	0	1	-360	360	-12.3342	3.2079	12.3388	-3.3220	0.0000	0.0000	0.0000	0.0000;
	267	423	0.003471	0.011322	0.001169	133	133	133	0	0	1	-360	360	11.2682	-3.2079	-11.2642	3.0839	0.0000	0.0000	0.0000	0.0000;
	558	211	0.039091	0.06843	0.00649	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.7370	0.0000	0.0000	0.0000	0.0000;
	559	497	0.006529	0.017364	0.001989	120	120	120	0	0	1	-360	360	31.0332	8.1613	-30.9757	-8.2407	0.0000	0.0000	0.0000	0.0000;
	529	484	0.032893	0.057438	0.00521	90	90	90	0	0	1	-360	360	8.6810	3.2529	-8.6560	-3.8102	0.0000	0.0000	0.0000	0.0000;
	454	239	0.011653	0.042984	0.003901	90	90	90	0	0	1	-360	360	-2.4997	2.0408	2.5008	-2.4954	0.0000	0.0000	0.0000	0.0000;
	293	282	0.009008	0.029174	0.00302	133	133	133	0	0	1	-360	360	5.3302	0.6462	-5.3280	-1.0000	0.0000	0.0000	0.0000	0.0000;
	358	345	0.023141	0.075207	0.007739	133	133	133	0	0	1	-360	360	-1.5863	-1.1016	1.5869	0.1859	0.0000	0.0000	0.0000	0.0000;
	450	296	0.011744	0.037934	0.00392	133	133	133	0	0	1	-360	360	6.5192	0.9251	-6.5149	-1.3771	0.0000	0.0000	0.0000	0.0000;
	513	318	0.006942	0.022562	0.00234	90	90	90	0	0	1	-360	360	1.3550	6.6357	-1.3521	-6.9008	0.0000	0.0000	0.0000	0.0000;
	498	239	0.003554	0.011397	0.001181	133	133	133	0	0	1	-360	360	24.1428	-7.8135	-24.1234	7.7371	0.0000	0.0000	0.0000	0.0000;
	452	451	0.006364	0.020744	0.002139	133	133	133	0	0	1	-360	360	61.9188	-12.1905	-61.7067	12.6264	0.0000	0.0000	0.0000	0.0000;
	319	317	0.006942	0.02281	0.002299	133	133	133	0	0	1	-360	360	-12.6130	6.6207	12.6252	-6.8497	0.0000	0.0000	0.0000	0.0000;
	570	396	0.019752	0.064793	0.006551	133	133	133	0	0	1	-360	360	17.2053	2.8435	-17.1554	-3.4710	0.0000	0.0000	0.0000	0.0000;
	553	396	0.031157	0.084628	0.008429	90	90	90	0	0	1	-360	360	-16.0182	-4.2840	16.0894	3.4710	0.0000	0.0000	0.0000	0.0000;
	584	500	0.005372	0.017521	0.001769	133	133	133	0	0	1	-360	360	22.8905	-11.4148	-22.8606	11.3052	0.0000	0.0000	0.0000	0.0000;
	244	385	0.016777	0.056612	0.00575	133	133	133	0	0	1	-360	360	-6.2908	-0.8246	6.2963	0.1387	0.0000	0.0000	0.0000	0.0000;
	364	244	0.02686	0.088099	0.008901	133	133	133	0	0	1	-360	360	-4.1560	-0.8000	4.1598	-0.2754	0.0000	0.0000	0.0000	0.0000;
	344	475	0.027273	0.07157	0.007432	133	133	133	0	0	1	-360	360	1.0663	-0.3806	-1.0660	-0.5000	0.0000	0.0000	0.0000	0.0000;
	498	291	0.013719	0.044711	0.0046	133	133	133	0	0	1	-360	360	-26.2738	6.8135	26.3603	-7.0726	0.0000	0.0000	0.0000	0.0000;
	416	374	0.005446	0.017521	0.00183	133	133	133	0	0	1	-360	360	-2.1420	0.1672	2.1422	-0.3808	0.0000	0.0000	0.0000	0.0000;
	294	404	0.006198	0.017769	0.001909	120	120	120	0	0	1	-360	360	-24.1084	-5.3057	24.1401	5.1693	0.0000	0.0000	0.0000	0.0000;
	455	405	0.010744	0.034207	0.003521	137	137	137	0	0	1	-360	360	-25.6758	4.3483	25.7377	-4.5675	0.0000	0.0000	0.0000	0.0000;
	281	388	0.005702	0.018512	0.001931	133	133	133	0	0	1	-360	360	-5.3280	-1.0000	5.3294	0.7739	0.0000	0.0000	0.0000	0.0000;
	324	314	0.002231	0.007273	0.000731	120	120	120	0	0	1	-360	360	6.2919	-0.8297	-6.2912	0.7426	0.0000	0.0000	0.0000	0.0000;
	313	276	0.003058	0.009587	0.000999	120	120	120	0	0	1	-360	360	0.9277	4.8748	-0.9271	-4.9972	0.0000	0.0000	0.0000	0.0000;
	321	307	0.005793	0.016612	0.001791	120	120	120	0	0	1	-360	360	13.7352	-1.3165	-13.7264	1.1192	0.0000	0.0000	0.0000	0.0000;
	435	276	0.018017	0.046364	0.0047	120	120	120	0	0	1	-360	360	-28.4141	4.4459	28.5350	-4.7179	0.0000	0.0000	0.0000	0.0000;
	511	277	0.004628	0.014876	0.00145	120	120	120	0	0	1	-360	360	-7.7123	-11.3504	7.7193	11.1953	0.0000	0.0000	0.0000	0.0000;
	332	276	0.007107	0.022727	0.00242	133	133	133	0	0	1	-360	360	-20.2713	-4.8566	20.2961	4.6358	0.0000	0.0000	0.0000	0.0000;
	306	241	0.001066	0.00281	0.000329	120	120	120	0	0	1	-360	360	40.2880	-0.7510	-40.2737	0.7489	0.0000	0.0000	0.0000	0.0000;
	311	241	0.009917	0.026364	0.002991	120	120	120	0	0	1	-360	360	-36.3286	1.8578	36.4377	-1.9289	0.0000	0.0000	0.0000	0.0000;
	481	311	0.004628	0.013876	0.00167	120	120	120	0	0	1	-360	360	-35.7055	-4.8926	35.7556	4.8422	0.0000	0.0000	0.0000	0.0000;
	308	312	0.003719	0.011901	0.001251	120	120	120	0	0	1	-360	360	-5.2367	3.2479	5.2379	-3.3986	0.0000	0.0000	0.0000	0.0000;
	583	310	0.000579	0.001983	0.00021	120	120	120	0	0	1	-360	360	-10.2167	-7.8973	10.2175	7.8740	0.0000	0.0000	0.0000	0.0000;
	308	583	0.003058	0.009917	0.001041	120	120	120	0	0	1	-360	360	-7.0173	-7.0279	7.0197	6.9073	0.0000	0.0000	0.0000	0.0000;
	574	310	0.005289	0.016446	0.00189	123	123	123	0	0	1	-360	360	6.9785	-0.3533	-6.9765	0.1260	0.0000	0.0000	0.0000	0.0000;
	566	329	0.007364	0.023876	0.002481	120	120	120	0	0	1	-360	360	-9.6656	9.9294	9.6772	-10.1972	0.0000	0.0000	0.0000	0.0000;
	300	566	0.002149	0.006446	0.000779	120	120	120	0	0	1	-360	360	-11.4186	1.3876	11.4209	-1.4768	0.0000	0.0000	0.0000	0.0000;
	574	566	0.00562	0.018182	0.0019	120	120	120	0	0	1	-360	360	1.7587	8.2286	-1.7554	-8.4526	0.0000	0.0000	0.0000	0.0000;
	445	309	0.004876	0.012397	0.00121	120	120	120	0	0	1	-360	360	33.8763	-1.9783	-33.8308	1.9450	0.0000	0.0000	0.0000	0.0000;
	445	392	0.00595	0.017934	0.002161	120	120	120	0	0	1	-360	360	-36.6463	1.0383	36.7112	-1.1099	0.0000	0.0000	0.0000	0.0000;
	575	481	0.00405	0.012984	0.001341	120	120	120	0	0	1	-360	360	-18.9644	0.1557	18.9765	-0.2774	0.0000	0.0000	0.0000	0.0000;
	574	446	0.007521	0.022636	0.002701	120	120	120	0	0	1	-360	360	27.3694	6.2600	-27.3213	-6.4485	0.0000	0.0000	0.0000	0.0000;
	392	236	0.013876	0.036281	0.003959	120	120	120	0	0	1	-360	360	20.8078	3.2074	-20.7579	-3.5652	0.0000	0.0000	0.0000	0.0000;
	314	236	0.016612	0.047017	0.005051	120	120	120	0	0	1	-360	360	-12.1069	-1.1882	12.1269	0.6252	0.0000	0.0000	0.0000	0.0000;
	325	309	0.005041	0.016124	0.001699	120	120	120	0	0	1	-360	360	-5.9670	-1.8400	5.9686	1.6361	0.0000	0.0000	0.0000	0.0000;
	337	277	0.010578	0.028017	0.003161	120	120	120	0	0	1	-360	360	-55.4837	-3.9990	55.7531	4.3264	0.0000	0.0000	0.0000	0.0000;
	326	309	0.002636	0.008603	0.0009	120	120	120	0	0	1	-360	360	-24.7015	5.5612	24.7152	-5.6271	0.0000	0.0000	0.0000	0.0000;
	329	326	8.3e-05	0.000331	4.1e-05	120	120	120	0	0	1	-360	360	-18.7342	7.3972	18.7345	-7.4012	0.0000	0.0000	0.0000	0.0000;
	337	306	0.003388	0.01124	0.001111	120	120	120	0	0	1	-360	360	48.1317	1.7290	-48.0670	-1.6490	0.0000	0.0000	0.0000	0.0000;
	312	300	0.002231	0.006777	0.00082	120	120	120	0	0	1	-360	360	-5.2379	3.3986	5.2386	-3.4976	0.0000	0.0000	0.0000	0.0000;
	471	259	0.010661	0.032314	0.003831	120	120	120	0	0	1	-360	360	10.6689	1.9257	-10.6586	-2.3620	0.0000	0.0000	0.0000	0.0000;
	446	471	0.015793	0.047851	0.00568	120	120	120	0	0	1	-360	360	14.8543	2.5985	-14.8249	-3.2057	0.0000	0.0000	0.0000	0.0000;
	313	307	0.005702	0.013719	0.001549	120	120	120	0	0	1	-360	360	0.0209	5.1696	-0.0196	-5.3592	0.0000	0.0000	0.0000	0.0000;
	229	574	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	-2.4510	-0.9800	2.4511	0.9246	0.0000	0.0000	0.0000	0.0000;
	287	276	0.01876	0.051984	0.005711	120	120	120	0	0	1	-360	360	7.4218	-1.9491	-7.4131	1.2628	0.0000	0.0000	0.0000	0.0000;
	391	287	0.017107	0.046686	0.005089	120	120	120	0	0	1	-360	360	15.9818	0.4115	-15.9468	-0.9509	0.0000	0.0000	0.0000	0.0000;
	391	350	0.003388	0.010174	0.001229	120	120	120	0	0	1	-360	360	23.0369	5.5054	-23.0217	-5.6132	0.0000	0.0000	0.0000	0.0000;
	230	575	0.001322	0.004298	0.00045	11	11	11	0	0	1	-360	360	-2.4510	-0.9800	2.4511	0.9263	0.0000	0.0000	0.0000	0.0000;
	512	313	0.002562	0.008256	0.00084	120	120	120	0	0	1	-360	360	-18.6897	-4.5554	18.6973	4.4755	0.0000	0.0000	0.0000	0.0000;
	332	322	0.007686	0.024711	0.002611	120	120	120	0	0	1	-360	360	-6.5807	-3.4334	6.5841	3.1205	0.0000	0.0000	0.0000	0.0000;
	512	322	0.002562	0.008182	0.000801	120	120	120	0	0	1	-360	360	18.6897	4.5554	-18.6821	-4.6305	0.0000	0.0000	0.0000	0.0000;
	429	350	0.004793	0.014463	0.00175	120	120	120	0	0	1	-360	360	-11.4025	-2.2258	11.4077	2.0232	0.0000	0.0000	0.0000	0.0000;
	469	392	0.007851	0.025372	0.002669	120	120	120	0	0	1	-360	360	-26.4624	-5.5595	26.5089	5.3805	0.0000	0.0000	0.0000	0.0000;
	469	324	0.009091	0.030579	0.003151	120	120	120	0	0	1	-360	360	20.2824	3.6495	-20.2509	-3.9303	0.0000	0.0000	0.0000	0.0000;
	391	321	0.01281	0.041157	0.004339	120	120	120	0	0	1	-360	360	21.9899	0.8318	-21.9402	-1.2135	0.0000	0.0000	0.0000	0.0000;
	305	391	0.006124	0.019752	0.002081	120	120	120	0	0	1	-360	360	-8.4024	-2.5377	8.4061	2.2897	0.0000	0.0000	0.0000	0.0000;
	295	391	0.011983	0.038603	0.004061	120	120	120	0	0	1	-360	360	-4.4916	-1.4540	4.4937	0.9532	0.0000	0.0000	0.0000	0.0000;
	295	305	0.00562	0.018099	0.001909	120	120	120	0	0	1	-360	360	-0.4104	-0.0560	0.4104	-0.1823	0.0000	0.0000	0.0000	0.0000;
	575	389	0.023802	0.072149	0.00855	120	120	120	0	0	1	-360	360	8.3052	-3.4047	-8.2899	2.4272	0.0000	0.0000	0.0000	0.0000;
	511	314	0.003876	0.012562	0.001319	120	120	120	0	0	1	-360	360	-12.2127	4.5604	12.2181	-4.7044	0.0000	0.0000	0.0000	0.0000;
	574	435	0.004959	0.014959	0.001769	120	120	120	0	0	1	-360	360	-22.8507	6.0048	22.8731	-6.1559	0.0000	0.0000	0.0000	0.0000;
	301	575	0.005041	0.015207	0.00181	120	120	120	0	0	1	-360	360	-8.2050	-2.5300	8.2081	2.3226	0.0000	0.0000	0.0000	0.0000;
	486	406	0.03	0.088678	0.00884	120	120	120	0	0	1	-360	360	-76.6559	5.3407	78.1664	-1.9312	0.0000	0.0000	0.0000	0.0000;
	431	258	0.025207	0.082231	0.00841	120	120	120	0	0	1	-360	360	-26.9624	-3.5849	27.1212	3.1119	0.0000	0.0000	0.0000	0.0000;
	443	431	0.001488	0.004711	0.000489	120	120	120	0	0	1	-360	360	-19.2856	-2.4268	19.2904	2.3849	0.0000	0.0000	0.0000	0.0000;
	415	407	0.00843	0.021397	0.00218	120	120	120	0	0	1	-360	360	14.4503	3.8275	-14.4341	-4.0411	0.0000	0.0000	0.0000	0.0000;
	482	465	0.019504	0.035446	0.003531	90	90	90	0	0	1	-360	360	-22.1446	-6.4315	22.2316	6.1682	0.0000	0.0000	0.0000	0.0000;
	586	218	0.014876	0.026124	0.002461	90	90	90	0	0	1	-360	360	-8.5169	-3.2367	8.5274	2.9679	0.0000	0.0000	0.0000	0.0000;
	586	359	0.022636	0.037686	0.003969	90	90	90	0	0	1	-360	360	1.0579	1.2367	-1.0573	-1.6976	0.0000	0.0000	0.0000	0.0000;
	573	331	0.014132	0.046529	0.0047	120	120	120	0	0	1	-360	360	-9.1756	-1.1219	9.1854	0.5801	0.0000	0.0000	0.0000	0.0000;
	284	234	0.004405	0.030388	0.003417	183	183	183	0	0	1	-360	360	-45.5290	2.6750	45.6078	-2.5292	0.0000	0.0000	0.0000	0.0000;
	576	467	0.016529	0.053876	0.005501	91	91	91	0	0	1	-360	360	5.4023	5.1362	-5.3943	-5.7750	0.0000	0.0000	0.0000	0.0000;
	573	449	0.017851	0.032727	0.003461	90	90	90	0	0	1	-360	360	7.4046	-6.3936	-7.3909	5.9961	0.0000	0.0000	0.0000	0.0000;
	449	419	0.030331	0.073314	0.00825	120	120	120	0	0	1	-360	360	0.9979	-7.7961	-0.9845	6.8169	0.0000	0.0000	0.0000	0.0000;
	397	419	0.00719	0.012562	0.0012	90	90	90	0	0	1	-360	360	-4.2620	-1.2000	4.2631	1.0542	0.0000	0.0000	0.0000	0.0000;
	573	299	0.017107	0.043636	0.004441	120	120	120	0	0	1	-360	360	-18.0950	3.6275	18.1431	-4.0473	0.0000	0.0000	0.0000	0.0000;
	447	299	0.03124	0.079422	0.00808	120	120	120	0	0	1	-360	360	22.5371	-4.0031	-22.4051	3.3473	0.0000	0.0000	0.0000	0.0000;
	489	456	0.01	0.026281	0.002669	120	120	120	0	0	1	-360	360	29.0667	-3.9942	-28.9977	3.8437	0.0000	0.0000	0.0000	0.0000;
	456	447	0.028017	0.061818	0.00747	120	120	120	0	0	1	-360	360	27.5057	-4.0437	-27.3321	3.5031	0.0000	0.0000	0.0000	0.0000;
	375	288	0.004132	0.013471	0.001389	133	133	133	0	0	1	-360	360	-12.2853	-1.5638	12.2905	1.4096	0.0000	0.0000	0.0000	0.0000;
	379	486	0.02595	0.085124	0.008601	133	133	133	0	0	1	-360	360	-65.5431	9.2328	66.5309	-6.9933	0.0000	0.0000	0.0000	0.0000;
	457	375	0.040413	0.132636	0.01339	133	133	133	0	0	1	-360	360	-9.5900	-2.4000	9.6213	0.8638	0.0000	0.0000	0.0000	0.0000;
	499	458	0.002562	0.00843	0.000871	133	133	133	0	0	1	-360	360	7.4603	1.6017	-7.4590	-1.7000	0.0000	0.0000	0.0000	0.0000;
	278	467	0.014132	0.037273	0.004	90	90	90	0	0	1	-360	360	5.2677	-5.0410	-5.2617	4.5750	0.0000	0.0000	0.0000	0.0000;
	444	485	0.007107	0.012479	0.001191	90	90	90	0	0	1	-360	360	-12.0493	-1.9562	12.0585	1.8354	0.0000	0.0000	0.0000	0.0000;
	487	444	0.005793	0.011744	0.00114	90	90	90	0	0	1	-360	360	-9.3807	-1.7778	9.3853	1.6562	0.0000	0.0000	0.0000	0.0000;
	488	486	0.010496	0.024471	0.002168	69	69	69	0	0	1	-360	360	-5.6470	-1.3000	5.6500	1.0526	0.0000	0.0000	0.0000	0.0000;
	464	328	0.054554	0.094711	0.00914	90	90	90	0	0	1	-360	360	25.2835	0.4164	-24.9924	-0.9947	0.0000	0.0000	0.0000	0.0000;
	433	376	0.060579	0.106033	0.01006	90	90	90	0	0	1	-360	360	-25.4689	0.0496	25.8005	-0.6769	0.0000	0.0000	0.0000	0.0000;
	443	438	0.002727	0.007851	0.000789	120	120	120	0	0	1	-360	360	16.5226	2.9268	-16.5160	-3.0000	0.0000	0.0000	0.0000	0.0000;
	485	223	0.011983	0.038934	0.00402	120	120	120	0	0	1	-360	360	-15.4535	-1.7354	15.4786	1.3530	0.0000	0.0000	0.0000	0.0000;
	473	407	0.010744	0.034793	0.003589	114	114	114	0	0	1	-360	360	-19.4441	-1.6438	19.4793	1.3403	0.0000	0.0000	0.0000	0.0000;
	473	223	0.009826	0.031983	0.003301	114	114	114	0	0	1	-360	360	16.2471	1.1438	-16.2246	-1.4530	0.0000	0.0000	0.0000	0.0000;
	509	490	0.012984	0.042149	0.004361	133	133	133	0	0	1	-360	360	-27.1912	-2.3611	27.2703	2.0836	0.0000	0.0000	0.0000	0.0000;
	489	243	0.003141	0.009421	0.000961	120	120	120	0	0	1	-360	360	40.2205	9.4277	-40.1775	-9.4180	0.0000	0.0000	0.0000	0.0000;
	441	394	0.003554	0.024207	0.00271	183	183	183	0	0	1	-360	360	8.8958	-4.8733	-8.8928	4.5668	0.0000	0.0000	0.0000	0.0000;
	393	232	0.013719	0.044463	0.00461	120	120	120	0	0	1	-360	360	8.7481	-0.0293	-8.7394	-0.4980	0.0000	0.0000	0.0000	0.0000;
	442	264	0.001636	0.011116	0.001341	183	183	183	0	0	1	-360	360	21.8473	6.6092	-21.8402	-6.7224	0.0000	0.0000	0.0000	0.0000;
	394	212	0.019669	0.063802	0.006599	120	120	120	0	0	1	-360	360	28.7852	5.1288	-28.6452	-5.4650	0.0000	0.0000	0.0000	0.0000;
	233	379	0.003554	0.01157	0.00121	133	133	133	0	0	1	-360	360	-20.1168	1.4919	20.1294	-1.5905	0.0000	0.0000	0.0000	0.0000;
	403	363	0.028678	0.093141	0.009619	120	120	120	0	0	1	-360	360	-5.1605	0.5890	5.1675	-1.6707	0.0000	0.0000	0.0000	0.0000;
	232	213	0.00686	0.022149	0.002289	120	120	120	0	0	1	-360	360	4.4774	-0.5020	-4.4763	0.2302	0.0000	0.0000	0.0000	0.0000;
	415	212	0.022314	0.072479	0.0075	120	120	120	0	0	1	-360	360	-25.6383	-5.3275	25.7682	4.8650	0.0000	0.0000	0.0000	0.0000;
	581	433	0.014711	0.047686	0.004929	120	120	120	0	0	1	-360	360	-18.4997	1.8059	18.5429	-2.2496	0.0000	0.0000	0.0000	0.0000;
	581	448	0.019504	0.063314	0.006539	120	120	120	0	0	1	-360	360	13.1727	-3.8059	-13.1422	3.1324	0.0000	0.0000	0.0000	0.0000;
	578	213	0.020579	0.066942	0.006909	120	120	120	0	0	1	-360	360	-1.2790	-0.3000	1.2793	-0.5302	0.0000	0.0000	0.0000	0.0000;
	359	273	0.008512	0.027934	0.002851	120	120	120	0	0	1	-360	360	-5.8687	-0.8024	5.8713	0.4789	0.0000	0.0000	0.0000	0.0000;
	409	406	0.004876	0.015868	0.001641	120	120	120	0	0	1	-360	360	14.4614	-8.4060	-14.4502	8.2433	0.0000	0.0000	0.0000	0.0000;
	464	228	0.00843	0.027686	0.00279	120	120	120	0	0	1	-360	360	23.2278	3.6093	-23.1889	-3.8155	0.0000	0.0000	0.0000	0.0000;
	409	393	0.035289	0.137017	0.013741	120	120	120	0	0	1	-360	360	-20.2154	7.0060	20.3522	-8.1366	0.0000	0.0000	0.0000	0.0000;
	304	487	0.024298	0.078934	0.008151	120	120	120	0	0	1	-360	360	-4.0490	-1.5000	4.0527	0.5778	0.0000	0.0000	0.0000	0.0000;
	394	264	0.001818	0.012727	0.001421	183	183	183	0	0	1	-360	360	3.7375	15.1323	-3.7338	-15.2776	0.0000	0.0000	0.0000	0.0000;
	393	265	0.001744	0.012066	0.001341	183	183	183	0	0	1	-360	360	40.9454	78.5268	-40.8318	-77.9014	0.0000	0.0000	0.0000	0.0000;
	234	245	0.007884	0.053149	0.005885	183	183	183	0	0	1	-360	360	-77.5738	-25.4718	78.0235	27.8053	0.0000	0.0000	0.0000	0.0000;
	441	245	0.001074	0.00719	0.000944	229	229	229	0	0	1	-360	360	-35.5385	-2.4403	35.5498	2.4022	0.0000	0.0000	0.0000	0.0000;
	283	265	0.002562	0.022727	0.001989	183	183	183	0	0	1	-360	360	-6.6840	-47.6845	6.7348	47.9014	0.0000	0.0000	0.0000	0.0000;
	394	561	8e-06	8.3e-05	0	137	137	137	0	0	1	-360	360	33.7030	3.9318	-33.7029	-3.9310	0.0000	0.0000	0.0000	0.0000;
	561	257	0.019504	0.063141	0.006539	120	120	120	0	0	1	-360	360	33.7029	4.2409	-33.5159	-4.4184	0.0000	0.0000	0.0000	0.0000;
	227	499	0.035702	0.11719	0.011841	120	120	120	0	0	1	-360	360	14.4516	2.4129	-14.3863	-3.6017	0.0000	0.0000	0.0000	0.0000;
	221	278	0.044297	0.093471	0.00876	90	90	90	0	0	1	-360	360	-5.0560	-1.1000	5.0656	0.0687	0.0000	0.0000	0.0000	0.0000;
	523	490	0.018934	0.062479	0.019319	133	133	133	0	0	1	-360	360	-47.0187	-3.0935	47.3656	1.8827	0.0000	0.0000	0.0000	0.0000;
	335	328	0.010992	0.023223	0.00218	90	90	90	0	0	1	-360	360	-5.8600	-0.8000	5.8633	0.5517	0.0000	0.0000	0.0000	0.0000;
	573	576	0.012149	0.039339	0.004051	120	120	120	0	0	1	-360	360	10.2111	5.5880	-10.1973	-6.0362	0.0000	0.0000	0.0000	0.0000;
	233	363	0.029091	0.09438	0.00976	120	120	120	0	0	1	-360	360	11.0598	-1.8919	-11.0285	0.8707	0.0000	0.0000	0.0000	0.0000;
	218	482	0.033876	0.059339	0.00582	90	90	90	0	0	1	-360	360	-16.1994	-5.9679	16.2846	5.4315	0.0000	0.0000	0.0000	0.0000;
	479	403	0.019826	0.06438	0.00665	120	120	120	0	0	1	-360	360	-1.9628	0.1281	1.9635	-0.8890	0.0000	0.0000	0.0000	0.0000;
	572	523	0.024215	0.079339	0.008027	133	133	133	0	0	1	-360	360	-22.1026	3.6988	22.2043	-4.3340	0.0000	0.0000	0.0000	0.0000;
	572	278	0.022231	0.07281	0.00735	133	133	133	0	0	1	-360	360	15.7096	-4.2988	-15.6613	3.5723	0.0000	0.0000	0.0000	0.0000;
	401	412	0.008347	0.026198	0.002921	90	90	90	0	0	1	-360	360	-2.0650	-0.9200	2.0653	0.5741	0.0000	0.0000	0.0000	0.0000;
	399	395	0.007603	0.025446	0.00249	133	133	133	0	0	1	-360	360	32.7097	4.2462	-32.6426	-4.3285	0.0000	0.0000	0.0000	0.0000;
	400	365	0.011818	0.03	0.003049	120	120	120	0	0	1	-360	360	10.0371	-2.3516	-10.0270	2.0000	0.0000	0.0000	0.0000	0.0000;
	414	366	0.016198	0.05405	0.005271	133	133	133	0	0	1	-360	360	10.0414	-2.5810	-10.0270	2.0000	0.0000	0.0000	0.0000	0.0000;
	412	268	0.019917	0.06438	0.00667	133	133	133	0	0	1	-360	360	21.8060	1.1162	-21.7259	-1.6462	0.0000	0.0000	0.0000	0.0000;
	562	297	0.010661	0.018678	0.001861	133	133	133	0	0	1	-360	360	4.6518	1.4098	-4.6496	-1.6241	0.0000	0.0000	0.0000	0.0000;
	562	268	0.015868	0.053876	0.005329	133	133	133	0	0	1	-360	360	-12.1159	-1.4044	12.1359	0.8462	0.0000	0.0000	0.0000	0.0000;
	562	460	0.010744	0.034959	0.003611	133	133	133	0	0	1	-360	360	7.4641	-0.0054	-7.4590	-0.4010	0.0000	0.0000	0.0000	0.0000;
	315	298	0.027016	0.087438	0.009051	133	133	133	0	0	1	-360	360	8.0127	-1.8987	-7.9979	0.8577	0.0000	0.0000	0.0000	0.0000;
	263	237	0.019091	0.062727	0.00634	133	133	133	0	0	1	-360	360	-15.8243	1.6757	15.8656	-2.2870	0.0000	0.0000	0.0000	0.0000;
	378	263	0.019752	0.064959	0.006561	133	133	133	0	0	1	-360	360	-14.5089	2.0245	14.5453	-2.6757	0.0000	0.0000	0.0000	0.0000;
	468	413	0.025041	0.082231	0.00831	133	133	133	0	0	1	-360	360	-52.0111	0.1994	52.5629	0.5811	0.0000	0.0000	0.0000	0.0000;
	224	468	0.007603	0.022984	0.00272	133	133	133	0	0	1	-360	360	-45.4883	0.7559	45.6171	-0.6994	0.0000	0.0000	0.0000	0.0000;
	400	251	0.023141	0.074132	0.00785	133	133	133	0	0	1	-360	360	12.2798	2.2669	-12.2502	-3.1397	0.0000	0.0000	0.0000	0.0000;
	434	371	0.038843	0.127603	0.012879	133	133	133	0	0	1	-360	360	33.6145	0.5824	-33.2518	-0.9341	0.0000	0.0000	0.0000	0.0000;
	472	395	0.018347	0.060248	0.006079	133	133	133	0	0	1	-360	360	-28.7858	-4.3505	28.9136	4.0285	0.0000	0.0000	0.0000	0.0000;
	472	418	0.030331	0.099669	0.01006	133	133	133	0	0	1	-360	360	26.7608	4.2505	-26.5757	-4.8493	0.0000	0.0000	0.0000	0.0000;
	461	298	0.009752	0.029504	0.00355	133	133	133	0	0	1	-360	360	-4.2620	-1.0000	4.2635	0.5780	0.0000	0.0000	0.0000	0.0000;
	585	297	0.036777	0.063802	0.006229	90	90	90	0	0	1	-360	360	-0.0669	-1.8517	0.0676	1.1241	0.0000	0.0000	0.0000	0.0000;
	483	240	0.021397	0.07157	0.006989	133	133	133	0	0	1	-360	360	-9.2910	-0.6122	9.3067	-0.1581	0.0000	0.0000	0.0000	0.0000;
	417	398	0.001983	0.006198	0.00069	133	133	133	0	0	1	-360	360	-28.4601	-0.0689	28.4736	0.0285	0.0000	0.0000	0.0000	0.0000;
	432	398	0.00562	0.017107	0.001801	90	90	90	0	0	1	-360	360	-31.1447	-2.3995	31.1907	2.3246	0.0000	0.0000	0.0000	0.0000;
	269	400	0.003058	0.01	0.001031	133	133	133	0	0	1	-360	360	-17.8436	-5.8591	17.8523	5.7602	0.0000	0.0000	0.0000	0.0000;
	399	368	0.009587	0.030992	0.003199	133	133	133	0	0	1	-360	360	10.0352	-2.3686	-10.0270	2.0000	0.0000	0.0000	0.0000	0.0000;
	413	367	0.010661	0.034628	0.003579	133	133	133	0	0	1	-360	360	10.0356	0.7991	-10.0270	-1.2195	0.0000	0.0000	0.0000	0.0000;
	410	360	0.004298	0.012984	0.001571	133	133	133	0	0	1	-360	360	11.2945	-1.1447	-11.2899	0.9713	0.0000	0.0000	0.0000	0.0000;
	370	237	0.091653	0.159008	0.01657	90	90	90	0	0	1	-360	360	9.0679	-7.8681	-8.9666	6.0933	0.0000	0.0000	0.0000	0.0000;
	582	240	0.03124	0.104207	0.010181	133	133	133	0	0	1	-360	360	31.2704	-1.8376	-31.0145	1.4821	0.0000	0.0000	0.0000	0.0000;
	432	412	0.004793	0.016033	0.001561	133	133	133	0	0	1	-360	360	26.4567	2.0995	-26.4284	-2.1903	0.0000	0.0000	0.0000	0.0000;
	371	235	0.009174	0.03	0.00303	133	133	133	0	0	1	-360	360	16.2038	-0.0659	-16.1834	-0.2259	0.0000	0.0000	0.0000	0.0000;
	235	237	0.006777	0.022149	0.002241	133	133	133	0	0	1	-360	360	10.3234	-0.5741	-10.3173	0.3295	0.0000	0.0000	0.0000	0.0000;
	298	292	0.016612	0.042984	0.004291	120	120	120	0	0	1	-360	360	-3.9377	-2.2357	3.9403	1.7262	0.0000	0.0000	0.0000	0.0000;
	414	360	0.011322	0.037769	0.003691	133	133	133	0	0	1	-360	360	-2.2321	1.7337	2.2329	-2.1713	0.0000	0.0000	0.0000	0.0000;
	413	400	0.012893	0.041157	0.004431	133	133	133	0	0	1	-360	360	44.2112	6.7810	-44.0052	-6.6754	0.0000	0.0000	0.0000	0.0000;
	434	413	0.043967	0.145289	0.014469	133	133	133	0	0	1	-360	360	-41.9255	-1.5824	42.5632	1.9054	0.0000	0.0000	0.0000	0.0000;
	414	398	0.024554	0.074298	0.00772	120	120	120	0	0	1	-360	360	-7.8093	0.8473	7.8222	-1.7305	0.0000	0.0000	0.0000	0.0000;
	483	336	0.021653	0.072397	0.007059	133	133	133	0	0	1	-360	360	7.1600	0.1122	-7.1505	-0.9088	0.0000	0.0000	0.0000	0.0000;
	535	269	0.04405	0.133719	0.015851	133	133	133	0	0	1	-360	360	-11.8180	-5.6207	11.8766	3.8591	0.0000	0.0000	0.0000	0.0000;
	349	378	0.018256	0.03157	0.003071	90	90	90	0	0	1	-360	360	-7.8914	2.0824	7.9019	-2.4245	0.0000	0.0000	0.0000	0.0000;
	478	251	0.020496	0.066942	0.006839	133	133	133	0	0	1	-360	360	-8.7194	-3.8285	8.7342	3.0397	0.0000	0.0000	0.0000	0.0000;
	582	224	0.033388	0.10124	0.011991	133	133	133	0	0	1	-360	360	-41.0734	0.9376	41.5453	-0.9559	0.0000	0.0000	0.0000	0.0000;
	417	410	0.002727	0.008182	0.00099	133	133	133	0	0	1	-360	360	21.5341	-0.7311	-21.5235	0.6447	0.0000	0.0000	0.0000	0.0000;
	216	214	0.006942	0.022562	0.002311	133	133	133	0	0	1	-360	360	15.7099	-1.6074	-15.6960	1.3669	0.0000	0.0000	0.0000	0.0000;
	226	369	0.059917	0.116281	0.012981	90	90	90	0	0	1	-360	360	-23.2336	-4.2335	23.5051	3.1557	0.0000	0.0000	0.0000	0.0000;
	226	208	0.100413	0.177364	0.01665	90	90	90	0	0	1	-360	360	2.3081	6.8365	-2.2529	-8.7397	0.0000	0.0000	0.0000	0.0000;
	270	226	0.051984	0.09	0.008891	90	90	90	0	0	1	-360	360	-8.1063	2.5774	8.1385	-3.6030	0.0000	0.0000	0.0000	0.0000;
	279	217	0.028934	0.08719	0.0105	133	133	133	0	0	1	-360	360	-16.8667	-0.6445	16.9339	-0.4449	0.0000	0.0000	0.0000	0.0000;
	514	279	0.030331	0.09124	0.010989	133	133	133	0	0	1	-360	360	-14.6818	-1.3231	14.7357	0.1445	0.0000	0.0000	0.0000	0.0000;
	256	255	0.006612	0.019917	0.002401	133	133	133	0	0	1	-360	360	-14.6877	6.3093	14.7019	-6.5546	0.0000	0.0000	0.0000	0.0000;
	571	327	0.026942	0.081901	0.009699	133	133	133	0	0	1	-360	360	-1.7317	-2.9394	1.7336	1.7760	0.0000	0.0000	0.0000	0.0000;
	373	323	0.02	0.033802	0.003681	90	90	90	0	0	1	-360	360	-21.2341	5.4309	21.3146	-5.7374	0.0000	0.0000	0.0000	0.0000;
	225	289	0.027016	0.082149	0.009731	133	133	133	0	0	1	-360	360	-11.0225	6.1040	11.0601	-7.1494	0.0000	0.0000	0.0000	0.0000;
	377	247	0.049917	0.089669	0.008981	90	90	90	0	0	1	-360	360	-30.6809	2.9943	31.0913	-3.3100	0.0000	0.0000	0.0000	0.0000;
	477	248	0.007851	0.023876	0.002841	133	133	133	0	0	1	-360	360	-31.3013	-1.7325	31.3667	1.5953	0.0000	0.0000	0.0000	0.0000;
	474	209	0.040174	0.117107	0.01446	133	133	133	0	0	1	-360	360	-18.2058	-2.2128	18.3232	0.8933	0.0000	0.0000	0.0000	0.0000;
	280	327	0.003967	0.012149	0.001379	133	133	133	0	0	1	-360	360	6.1310	0.7764	-6.1297	-0.9392	0.0000	0.0000	0.0000	0.0000;
	249	247	0.022066	0.042727	0.00416	90	90	90	0	0	1	-360	360	38.8272	-2.2680	-38.5493	2.3100	0.0000	0.0000	0.0000	0.0000;
	256	249	0.037364	0.063141	0.00687	90	90	90	0	0	1	-360	360	9.8927	-6.3093	-9.8514	5.5546	0.0000	0.0000	0.0000	0.0000;
	217	214	0.002636	0.008512	0.000881	133	133	133	0	0	1	-360	360	-29.4699	3.6398	29.4887	-3.6879	0.0000	0.0000	0.0000	0.0000;
	571	555	0.039504	0.069091	0.006561	90	90	90	0	0	1	-360	360	-9.9893	2.4394	10.0247	-3.1680	0.0000	0.0000	0.0000	0.0000;
	555	302	0.035372	0.103314	0.009169	120	120	120	0	0	1	-360	360	-27.6536	-1.8808	27.8782	1.4196	0.0000	0.0000	0.0000	0.0000;
	474	440	0.019752	0.037364	0.00401	90	90	90	0	0	1	-360	360	4.8868	1.2128	-4.8823	-1.6609	0.0000	0.0000	0.0000	0.0000;
	554	248	0.031653	0.095372	0.01148	133	133	133	0	0	1	-360	360	-19.0202	-2.4547	19.1190	1.4003	0.0000	0.0000	0.0000	0.0000;
	408	372	0.040661	0.070661	0.00682	90	90	90	0	0	1	-360	360	11.1137	2.0903	-11.0688	-2.8078	0.0000	0.0000	0.0000	0.0000;
	477	209	0.041397	0.125702	0.01489	133	133	133	0	0	1	-360	360	23.3093	0.2325	-23.1182	-1.3933	0.0000	0.0000	0.0000	0.0000;
	387	353	0.015703	0.047364	0.005699	133	133	133	0	0	1	-360	360	-29.7957	5.1920	29.9153	-5.5195	0.0000	0.0000	0.0000	0.0000;
	290	217	0.028017	0.084463	0.010159	133	133	133	0	0	1	-360	360	-39.1854	4.5942	39.5439	-4.7610	0.0000	0.0000	0.0000	0.0000;
	260	250	0.026777	0.080496	0.009699	133	133	133	0	0	1	-360	360	-7.9966	1.0612	8.0123	-2.1145	0.0000	0.0000	0.0000	0.0000;
	462	208	0.038603	0.083636	0.00735	90	90	90	0	0	1	-360	360	7.3764	-8.5229	-7.3371	7.7397	0.0000	0.0000	0.0000	0.0000;
	271	250	0.019091	0.061983	0.00644	133	133	133	0	0	1	-360	360	10.6961	-2.2819	-10.6763	1.6145	0.0000	0.0000	0.0000	0.0000;
	377	271	0.067686	0.119008	0.01104	90	90	90	0	0	1	-360	360	24.2879	-4.4943	-23.9349	3.8468	0.0000	0.0000	0.0000	0.0000;
	453	271	0.061066	0.101653	0.011021	90	90	90	0	0	1	-360	360	-3.1970	-0.5000	3.2025	-0.7420	0.0000	0.0000	0.0000	0.0000;
	327	323	0.006124	0.012397	0.001169	90	90	90	0	0	1	-360	360	34.1616	-4.2568	-34.1016	4.2374	0.0000	0.0000	0.0000	0.0000;
	506	260	0.050992	0.154793	0.018329	133	133	133	0	0	1	-360	360	-3.1970	-1.0000	3.2016	-1.0612	0.0000	0.0000	0.0000	0.0000;
	408	289	0.03124	0.094959	0.011251	133	133	133	0	0	1	-360	360	-18.5727	-3.0903	18.6662	2.0456	0.0000	0.0000	0.0000	0.0000;
	555	238	0.029174	0.07438	0.007739	120	120	120	0	0	1	-360	360	6.4408	4.5488	-6.4247	-5.4375	0.0000	0.0000	0.0000	0.0000;
	353	290	0.021653	0.040083	0.00386	90	90	90	0	0	1	-360	360	-34.1773	4.5195	34.3904	-4.5942	0.0000	0.0000	0.0000	0.0000;
	254	554	0.018678	0.056777	0.00673	133	133	133	0	0	1	-360	360	-14.7226	-2.6309	14.7582	1.9547	0.0000	0.0000	0.0000	0.0000;
	255	387	0.026777	0.080578	0.009699	133	133	133	0	0	1	-360	360	-27.4889	5.0546	27.6647	-5.6920	0.0000	0.0000	0.0000	0.0000;
	271	440	0.004298	0.013876	0.00144	133	133	133	0	0	1	-360	360	3.6433	-1.3228	-3.6427	1.1609	0.0000	0.0000	0.0000	0.0000;
	341	214	0.039421	0.120331	0.01413	133	133	133	0	0	1	-360	360	-5.7537	-3.3497	5.7663	1.6489	0.0000	0.0000	0.0000	0.0000;
	493	214	0.008182	0.025446	0.00289	133	133	133	0	0	1	-360	360	-3.7290	0.0000	3.7299	-0.3542	0.0000	0.0000	0.0000	0.0000;
	316	270	0.043388	0.07157	0.007739	90	90	90	0	0	1	-360	360	0.9557	3.1431	-0.9507	-4.0774	0.0000	0.0000	0.0000	0.0000;
	316	341	0.018256	0.055372	0.006561	133	133	133	0	0	1	-360	360	-3.0867	-3.6431	3.0897	2.8497	0.0000	0.0000	0.0000	0.0000;
	369	302	0.028678	0.088182	0.007831	120	120	120	0	0	1	-360	360	36.7116	1.8982	-36.4022	-1.9196	0.0000	0.0000	0.0000	0.0000;
	369	217	0.025446	0.080992	0.00735	120	120	120	0	0	1	-360	360	37.9552	-0.0508	-37.6629	0.0661	0.0000	0.0000	0.0000	0.0000;
	215	369	0.018182	0.06595	0.007066	133	133	133	0	0	1	-360	360	-34.8992	-2.3302	35.0785	2.0997	0.0000	0.0000	0.0000	0.0000;
	249	225	0.027934	0.084959	0.01006	133	133	133	0	0	1	-360	360	-7.8028	5.4687	7.8255	-6.6040	0.0000	0.0000	0.0000	0.0000;
	514	280	0.023636	0.071488	0.008511	133	133	133	0	0	1	-360	360	11.4848	0.3231	-11.4590	-1.2764	0.0000	0.0000	0.0000	0.0000;
	215	216	0.002231	0.007521	0.000755	133	133	133	0	0	1	-360	360	22.6452	0.3302	-22.6359	-0.3926	0.0000	0.0000	0.0000	0.0000;
	564	245	0.000983	0.004231	0.235708	95	95	95	0	0	1	-360	360	-29.1141	53.8580	29.1586	-82.1608	0.0000	0.0000	0.0000	0.0000;
	564	285	0.016388	0.034405	0.218478	77	77	77	0	0	1	-360	360	1.4087	-26.1127	-1.3860	-0.4000	0.0000	0.0000	0.0000	0.0000;
	564	266	0.000174	0.000744	0.23566	95	95	95	0	0	1	-360	360	27.7054	-27.7453	-27.7040	-0.8000	0.0000	0.0000	0.0000	0.0000;
	286	561	0.015454	0.030083	0.002568	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.3099	0.0000	0.0000	0.0000	0.0000;
	357	355	8e-06	8.3e-05	2.4e-05	137	137	137	0	0	1	-360	360	-52.3155	-8.5769	52.3157	8.5760	0.0000	0.0000	0.0000	0.0000;
	604	839	0.036281	0.094207	0.00974	76	76	76	0	0	1	-360	360	-10.2976	2.8162	10.3343	-3.8521	0.0000	0.0000	0.0000	0.0000;
	794	626	0.030413	0.098934	0.01014	90	90	90	0	0	1	-360	360	-50.2609	0.9306	50.9197	0.0136	0.0000	0.0000	0.0000	0.0000;
	764	590	0.026777	0.086529	0.00885	90	90	90	0	0	1	-360	360	-13.6169	3.8181	13.6630	-4.7193	0.0000	0.0000	0.0000	0.0000;
	835	605	0.022562	0.072893	0.007461	77	77	77	0	0	1	-360	360	23.9718	-4.8965	-23.8580	4.3857	0.0000	0.0000	0.0000	0.0000;
	723	598	0.086777	0.149752	0.01423	58	58	58	0	0	1	-360	360	2.7266	-2.2159	-2.7196	0.5599	0.0000	0.0000	0.0000	0.0000;
	783	730	0.072066	0.138099	0.013211	58	58	58	0	0	1	-360	360	-0.2454	-1.1882	0.2456	-0.3622	0.0000	0.0000	0.0000	0.0000;
	737	731	0.05	0.109091	0.010699	58	58	58	0	0	1	-360	360	1.0549	-5.7303	-1.0432	4.5042	0.0000	0.0000	0.0000	0.0000;
	632	629	0.01124	0.027769	0.002759	58	58	58	0	0	1	-360	360	21.0504	-0.4302	-21.0077	0.2143	0.0000	0.0000	0.0000	0.0000;
	731	729	0.016364	0.053058	0.005421	90	90	90	0	0	1	-360	360	-10.7518	5.0200	10.7719	-5.5912	0.0000	0.0000	0.0000	0.0000;
	724	617	0.041157	0.132893	0.013591	90	90	90	0	0	1	-360	360	3.9888	-7.0056	-3.9698	5.4564	0.0000	0.0000	0.0000	0.0000;
	736	730	0.023058	0.07157	0.00818	90	90	90	0	0	1	-360	360	-1.2347	0.0156	1.2351	-0.9754	0.0000	0.0000	0.0000	0.0000;
	736	731	0.023058	0.07157	0.00818	90	90	90	0	0	1	-360	360	-1.9463	-0.0156	1.9470	-0.9429	0.0000	0.0000	0.0000	0.0000;
	751	680	0.020174	0.065289	0.006701	90	90	90	0	0	1	-360	360	-22.0611	-1.2197	22.1486	0.7460	0.0000	0.0000	0.0000	0.0000;
	796	603	0.048934	0.127769	0.013211	76	76	76	0	0	1	-360	360	23.0029	-2.7285	-22.7748	1.8236	0.0000	0.0000	0.0000	0.0000;
	624	594	0.031983	0.103471	0.01058	90	90	90	0	0	1	-360	360	-8.9682	-4.3509	8.9948	3.2306	0.0000	0.0000	0.0000	0.0000;
	698	823	0.039174	0.126686	0.012959	90	90	90	0	0	1	-360	360	-16.2986	0.9400	16.3859	-2.2266	0.0000	0.0000	0.0000	0.0000;
	793	624	0.038512	0.124628	0.012751	90	90	90	0	0	1	-360	360	-2.0714	-3.8279	2.0762	2.4039	0.0000	0.0000	0.0000	0.0000;
	834	641	0.061397	0.198603	0.020321	90	90	90	0	0	1	-360	360	-6.5446	3.4944	6.5779	-5.8068	0.0000	0.0000	0.0000	0.0000;
	746	745	0.003719	0.008843	0.00067	76	76	76	0	0	1	-360	360	-3.2959	2.8879	3.2965	-2.9643	0.0000	0.0000	0.0000	0.0000;
	746	621	0.04843	0.08438	0.00809	58	58	58	0	0	1	-360	360	-0.1425	-2.2680	0.1438	1.3297	0.0000	0.0000	0.0000	0.0000;
	789	587	0.012066	0.038934	0.00402	90	90	90	0	0	1	-360	360	-37.2270	-3.7580	37.3683	3.7312	0.0000	0.0000	0.0000	0.0000;
	774	621	0.037603	0.065537	0.006241	58	58	58	0	0	1	-360	360	7.2673	2.4341	-7.2478	-3.1297	0.0000	0.0000	0.0000	0.0000;
	746	662	0.010752	0.028198	0.002909	58	58	58	0	0	1	-360	360	-5.9987	-0.7877	6.0021	0.4586	0.0000	0.0000	0.0000	0.0000;
	720	662	0.012703	0.032967	0.00341	58	58	58	0	0	1	-360	360	14.0827	0.2176	-14.0611	-0.5586	0.0000	0.0000	0.0000	0.0000;
	748	720	0.034851	0.07019	0.006829	58	58	58	0	0	1	-360	360	17.2447	0.2938	-17.1567	-0.9176	0.0000	0.0000	0.0000	0.0000;
	592	748	0.014207	0.046033	0.004709	90	90	90	0	0	1	-360	360	19.8778	2.5796	-19.8295	-2.9807	0.0000	0.0000	0.0000	0.0000;
	704	588	0.00562	0.009917	0.00092	58	58	58	0	0	1	-360	360	-22.5744	-2.6309	22.5985	2.5626	0.0000	0.0000	0.0000	0.0000;
	704	700	0.004463	0.007934	0.00075	58	58	58	0	0	1	-360	360	16.9874	2.4209	-16.9765	-2.4917	0.0000	0.0000	0.0000	0.0000;
	703	700	0.002562	0.008256	0.000849	90	90	90	0	0	1	-360	360	-6.9235	-0.8704	6.9245	0.7717	0.0000	0.0000	0.0000	0.0000;
	829	703	0.013058	0.021653	0.002081	58	58	58	0	0	1	-360	360	4.1905	0.1427	-4.1885	-0.3896	0.0000	0.0000	0.0000	0.0000;
	829	587	0.011744	0.020248	0.001951	58	58	58	0	0	1	-360	360	-15.6315	-1.0227	15.6554	0.8291	0.0000	0.0000	0.0000	0.0000;
	608	587	0.02562	0.08281	0.00847	90	90	90	0	0	1	-360	360	-15.0074	-6.3795	15.0634	5.5461	0.0000	0.0000	0.0000	0.0000;
	608	605	0.029339	0.094793	0.009699	90	90	90	0	0	1	-360	360	9.3344	3.7795	-9.3082	-4.8414	0.0000	0.0000	0.0000	0.0000;
	786	696	0.011322	0.049256	0.004891	90	90	90	0	0	1	-360	360	-8.3674	0.5588	8.3741	-1.1140	0.0000	0.0000	0.0000	0.0000;
	787	786	0.002397	0.007603	0.000779	90	90	90	0	0	1	-360	360	-8.3660	0.4702	8.3674	-0.5588	0.0000	0.0000	0.0000	0.0000;
	789	787	0.002983	0.009587	0.00099	90	90	90	0	0	1	-360	360	0.1371	1.6452	-0.1370	-1.7632	0.0000	0.0000	0.0000	0.0000;
	789	590	0.018843	0.060992	0.006241	90	90	90	0	0	1	-360	360	25.2150	-1.4872	-25.1145	1.0694	0.0000	0.0000	0.0000	0.0000;
	803	590	0.025124	0.081066	0.008301	90	90	90	0	0	1	-360	360	-5.2924	-3.6056	5.3005	2.6499	0.0000	0.0000	0.0000	0.0000;
	803	595	0.004132	0.013223	0.00136	90	90	90	0	0	1	-360	360	5.2924	3.6056	-5.2910	-3.7612	0.0000	0.0000	0.0000	0.0000;
	697	683	0.023141	0.066281	0.006781	90	90	90	0	0	1	-360	360	29.0536	1.1648	-28.8898	-1.5010	0.0000	0.0000	0.0000	0.0000;
	683	595	0.007769	0.025124	0.00257	90	90	90	0	0	1	-360	360	20.8848	-0.5990	-20.8560	0.3889	0.0000	0.0000	0.0000	0.0000;
	724	595	0.003554	0.01157	0.0012	90	90	90	0	0	1	-360	360	-6.1088	6.0056	6.1110	-6.1397	0.0000	0.0000	0.0000	0.0000;
	692	696	0.010826	0.019174	0.001801	90	90	90	0	0	1	-360	360	1.4131	-0.1310	-1.4129	-0.0839	0.0000	0.0000	0.0000	0.0000;
	705	692	0.004554	0.008017	0.00075	58	58	58	0	0	1	-360	360	7.9255	0.8335	-7.9231	-0.9190	0.0000	0.0000	0.0000	0.0000;
	691	690	0.00124	0.003967	0.00044	69	69	69	0	0	1	-360	360	-4.3323	-2.4323	4.3326	2.3804	0.0000	0.0000	0.0000	0.0000;
	702	690	0.003141	0.010248	0.00105	69	69	69	0	0	1	-360	360	8.8659	2.9421	-8.8636	-3.0604	0.0000	0.0000	0.0000	0.0000;
	697	686	0.033223	0.107521	0.010999	90	90	90	0	0	1	-360	360	-17.8335	-2.4420	17.9227	1.4070	0.0000	0.0000	0.0000	0.0000;
	701	684	0.013636	0.044132	0.004521	90	90	90	0	0	1	-360	360	-18.9826	-2.0970	19.0241	1.6889	0.0000	0.0000	0.0000	0.0000;
	696	693	0.013388	0.02686	0.00257	90	90	90	0	0	1	-360	360	8.5524	-0.9998	-8.5441	0.7094	0.0000	0.0000	0.0000	0.0000;
	699	693	0.004628	0.015793	0.001609	90	90	90	0	0	1	-360	360	-3.4893	0.3739	3.4897	-0.5644	0.0000	0.0000	0.0000	0.0000;
	701	699	0.012636	0.040909	0.004179	58	58	58	0	0	1	-360	360	5.8766	1.1270	-5.8727	-1.6139	0.0000	0.0000	0.0000	0.0000;
	697	682	0.019669	0.063636	0.00651	90	90	90	0	0	1	-360	360	25.7003	-0.7786	-25.5916	0.3549	0.0000	0.0000	0.0000	0.0000;
	682	653	0.028256	0.091397	0.009341	90	90	90	0	0	1	-360	360	11.3836	-3.1549	-11.3511	2.1526	0.0000	0.0000	0.0000	0.0000;
	760	653	0.021818	0.070661	0.007231	90	90	90	0	0	1	-360	360	-7.2795	1.6303	7.2901	-2.4526	0.0000	0.0000	0.0000	0.0000;
	710	602	0.058347	0.09876	0.0106	58	58	58	0	0	1	-360	360	-13.4654	-0.5810	13.5538	-0.5466	0.0000	0.0000	0.0000	0.0000;
	602	601	0.005702	0.018603	0.00189	90	90	90	0	0	1	-360	360	-23.5208	-0.8534	23.5468	0.7088	0.0000	0.0000	0.0000	0.0000;
	695	601	0.033223	0.107364	0.010989	90	90	90	0	0	1	-360	360	-19.6067	5.9378	19.7236	-6.8965	0.0000	0.0000	0.0000	0.0000;
	738	696	0.063719	0.206124	0.021081	90	90	90	0	0	1	-360	360	0.7433	1.1352	-0.7399	-3.6561	0.0000	0.0000	0.0000	0.0000;
	705	588	0.013719	0.04438	0.00454	90	90	90	0	0	1	-360	360	-20.0482	-5.1298	20.0969	4.7421	0.0000	0.0000	0.0000	0.0000;
	702	696	0.003802	0.028603	0.00273	183	183	183	0	0	1	-360	360	6.9241	3.4268	-6.9221	-3.7390	0.0000	0.0000	0.0000	0.0000;
	702	697	0.002314	0.024132	0.003729	183	183	183	0	0	1	-360	360	9.2713	4.1499	-9.2693	-4.5751	0.0000	0.0000	0.0000	0.0000;
	702	588	0.004132	0.030661	0.002931	137	137	137	0	0	1	-360	360	-25.0612	-10.5188	25.0866	10.3546	0.0000	0.0000	0.0000	0.0000;
	685	587	0.003967	0.012984	0.001331	90	90	90	0	0	1	-360	360	72.9522	-1.5002	-72.7779	1.9097	0.0000	0.0000	0.0000	0.0000;
	824	601	0.032314	0.10438	0.01068	90	90	90	0	0	1	-360	360	50.2076	-6.5624	-49.5381	7.4170	0.0000	0.0000	0.0000	0.0000;
	824	823	0.040413	0.130579	0.013361	90	90	90	0	0	1	-360	360	27.5735	-1.7925	-27.3241	0.9627	0.0000	0.0000	0.0000	0.0000;
	685	588	0.003967	0.01281	0.001309	90	90	90	0	0	1	-360	360	73.9918	-2.5837	-73.8123	3.0048	0.0000	0.0000	0.0000	0.0000;
	686	684	0.013058	0.042066	0.00431	90	90	90	0	0	1	-360	360	26.6290	1.8463	-26.5521	-2.1189	0.0000	0.0000	0.0000	0.0000;
	726	605	0.030331	0.098099	0.010041	90	90	90	0	0	1	-360	360	-7.3844	2.7180	7.4012	-3.8443	0.0000	0.0000	0.0000	0.0000;
	823	738	0.037934	0.122983	0.012579	90	90	90	0	0	1	-360	360	7.0152	0.5639	-6.9993	-2.0352	0.0000	0.0000	0.0000	0.0000;
	697	693	0.009587	0.031157	0.00318	58	58	58	0	0	1	-360	360	7.0587	0.6483	-7.0546	-1.0151	0.0000	0.0000	0.0000	0.0000;
	702	691	0.005446	0.009587	0.0009	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	695	638	0.026364	0.085207	0.00871	90	90	90	0	0	1	-360	360	-25.2247	6.0306	25.3719	-6.6156	0.0000	0.0000	0.0000	0.0000;
	646	638	0.019174	0.062314	0.006369	90	90	90	0	0	1	-360	360	30.4932	-5.8265	-30.3429	5.5371	0.0000	0.0000	0.0000	0.0000;
	824	646	0.030661	0.099091	0.01014	90	90	90	0	0	1	-360	360	33.2122	-5.4674	-32.9322	5.1265	0.0000	0.0000	0.0000	0.0000;
	638	601	0.031066	0.100413	0.01029	90	90	90	0	0	1	-360	360	0.4120	0.8785	-0.4114	-2.1293	0.0000	0.0000	0.0000	0.0000;
	746	650	0.019174	0.061983	0.00634	90	90	90	0	0	1	-360	360	2.5451	-0.1323	-2.5440	-0.6000	0.0000	0.0000	0.0000	0.0000;
	592	588	0.029174	0.080744	0.00832	76	76	76	0	0	1	-360	360	-24.7758	-3.0796	24.9282	2.5056	0.0000	0.0000	0.0000	0.0000;
	747	748	0.005207	0.016942	0.00173	90	90	90	0	0	1	-360	360	0.8085	-2.7897	-0.8082	2.5869	0.0000	0.0000	0.0000	0.0000;
	726	747	0.011066	0.035793	0.003659	90	90	90	0	0	1	-360	360	1.6574	-2.7180	-1.6565	2.2897	0.0000	0.0000	0.0000	0.0000;
	630	696	0.020331	0.06562	0.006711	90	90	90	0	0	1	-360	360	-3.7580	-2.8000	3.7614	2.0102	0.0000	0.0000	0.0000	0.0000;
	604	745	0.004959	0.013388	0.001379	76	76	76	0	0	1	-360	360	7.8586	-3.1162	-7.8555	2.9643	0.0000	0.0000	0.0000	0.0000;
	691	705	0.001066	0.008017	0.000179	90	90	90	0	0	1	-360	360	0.1883	-0.3677	-0.1883	0.3463	0.0000	0.0000	0.0000	0.0000;
	764	617	0.031157	0.055041	0.00515	58	58	58	0	0	1	-360	360	-2.0717	-3.7059	2.0758	3.1008	0.0000	0.0000	0.0000	0.0000;
	719	642	0.005124	0.012397	0.001229	58	58	58	0	0	1	-360	360	-25.0530	-3.8484	25.0821	3.7795	0.0000	0.0000	0.0000	0.0000;
	764	618	0.032149	0.055041	0.00515	58	58	58	0	0	1	-360	360	-1.8349	-3.7266	1.8390	3.1212	0.0000	0.0000	0.0000	0.0000;
	764	675	0.019008	0.051157	0.00528	76	76	76	0	0	1	-360	360	-7.8645	1.9133	7.8752	-2.5113	0.0000	0.0000	0.0000	0.0000;
	715	675	0.045793	0.127521	0.013141	76	76	76	0	0	1	-360	360	18.9355	-2.6943	-18.7972	1.5113	0.0000	0.0000	0.0000	0.0000;
	813	714	0.024628	0.044876	0.00423	58	58	58	0	0	1	-360	360	-9.6527	-6.4630	9.6800	6.0077	0.0000	0.0000	0.0000	0.0000;
	813	598	0.058182	0.100413	0.00954	58	58	58	0	0	1	-360	360	3.7147	5.7630	-3.6884	-6.8436	0.0000	0.0000	0.0000	0.0000;
	836	714	0.010174	0.032983	0.003359	90	90	90	0	0	1	-360	360	-4.9329	3.4708	4.9361	-3.8634	0.0000	0.0000	0.0000	0.0000;
	837	832	0.003471	0.009008	0.000939	76	76	76	0	0	1	-360	360	-6.9430	-4.3073	6.9450	4.1993	0.0000	0.0000	0.0000	0.0000;
	837	836	0.006777	0.021901	0.002219	76	76	76	0	0	1	-360	360	1.6420	3.7073	-1.6411	-3.9708	0.0000	0.0000	0.0000	0.0000;
	832	715	0.014959	0.046612	0.004751	58	58	58	0	0	1	-360	360	-1.5982	5.0693	1.6021	-5.6280	0.0000	0.0000	0.0000	0.0000;
	832	817	0.063471	0.113802	0.010699	58	58	58	0	0	1	-360	360	20.9359	3.9204	-20.6938	-4.7549	0.0000	0.0000	0.0000	0.0000;
	719	681	0.044554	0.144132	0.01475	76	76	76	0	0	1	-360	360	1.2256	-3.6497	-1.2218	1.9882	0.0000	0.0000	0.0000	0.0000;
	834	715	0.069091	0.122727	0.01151	58	58	58	0	0	1	-360	360	3.3636	-3.7944	-3.3515	2.4373	0.0000	0.0000	0.0000	0.0000;
	617	610	0.014793	0.030826	0.002979	58	58	58	0	0	1	-360	360	14.1932	0.9912	-14.1680	-1.2930	0.0000	0.0000	0.0000	0.0000;
	618	611	0.01843	0.033314	0.00326	58	58	58	0	0	1	-360	360	14.1994	0.9623	-14.1680	-1.2930	0.0000	0.0000	0.0000	0.0000;
	755	719	0.044628	0.078843	0.007381	58	58	58	0	0	1	-360	360	-7.2581	-4.6780	7.2864	3.8981	0.0000	0.0000	0.0000	0.0000;
	755	603	0.03843	0.100744	0.010411	76	76	76	0	0	1	-360	360	-20.4976	2.7436	20.6458	-3.5236	0.0000	0.0000	0.0000	0.0000;
	751	755	0.037686	0.121901	0.01247	90	90	90	0	0	1	-360	360	9.2301	-0.8803	-9.2015	-0.4253	0.0000	0.0000	0.0000	0.0000;
	708	618	0.055703	0.099504	0.009341	58	58	58	0	0	1	-360	360	5.1114	-0.5306	-5.0992	-0.5635	0.0000	0.0000	0.0000	0.0000;
	826	708	0.040992	0.073636	0.006921	58	58	58	0	0	1	-360	360	7.8899	-1.3224	-7.8684	0.5306	0.0000	0.0000	0.0000	0.0000;
	618	612	0.007934	0.018934	0.001871	58	58	58	0	0	1	-360	360	10.0839	-0.2667	-10.0771	0.0601	0.0000	0.0000	0.0000	0.0000;
	617	615	0.008512	0.027851	0.002851	90	90	90	0	0	1	-360	360	8.6975	0.1558	-8.6921	-0.4776	0.0000	0.0000	0.0000	0.0000;
	620	615	0.009421	0.030504	0.003119	90	90	90	0	0	1	-360	360	-1.4809	-0.4482	1.4811	0.0776	0.0000	0.0000	0.0000	0.0000;
	620	612	0.007851	0.018347	0.001801	58	58	58	0	0	1	-360	360	-3.8201	0.2482	3.8211	-0.4601	0.0000	0.0000	0.0000	0.0000;
	820	816	0.027769	0.089752	0.009179	90	90	90	0	0	1	-360	360	-1.1660	-0.2000	1.1664	-0.8644	0.0000	0.0000	0.0000	0.0000;
	642	647	0.010826	0.037893	0.003845	58	58	58	0	0	1	-360	360	-33.0351	-3.7795	33.1404	3.7100	0.0000	0.0000	0.0000	0.0000;
	647	794	0.023777	0.076884	0.007865	90	90	90	0	0	1	-360	360	-35.6844	-3.7100	35.9511	3.6633	0.0000	0.0000	0.0000	0.0000;
	599	598	0.008347	0.027016	0.002771	90	90	90	0	0	1	-360	360	3.0298	-4.1025	-3.0280	3.7837	0.0000	0.0000	0.0000	0.0000;
	814	599	0.01843	0.059504	0.006079	90	90	90	0	0	1	-360	360	7.0677	-3.9813	-7.0578	3.3025	0.0000	0.0000	0.0000	0.0000;
	826	698	0.020661	0.06686	0.006839	90	90	90	0	0	1	-360	360	-13.7219	1.1224	13.7546	-1.8400	0.0000	0.0000	0.0000	0.0000;
	635	832	0.04876	0.157686	0.016129	90	90	90	0	0	1	-360	360	-8.2096	-0.7635	8.2370	-1.0832	0.0000	0.0000	0.0000	0.0000;
	634	635	0.010496	0.033058	0.003381	90	90	90	0	0	1	-360	360	-1.4244	-0.0673	1.4246	-0.3365	0.0000	0.0000	0.0000	0.0000;
	749	634	0.026612	0.086033	0.008799	90	90	90	0	0	1	-360	360	1.7573	-0.2181	-1.7566	-0.8327	0.0000	0.0000	0.0000	0.0000;
	819	749	0.017521	0.056777	0.00581	90	90	90	0	0	1	-360	360	4.0918	-0.2065	-4.0893	-0.4819	0.0000	0.0000	0.0000	0.0000;
	832	819	0.037521	0.121397	0.012419	90	90	90	0	0	1	-360	360	7.9274	-1.2350	-7.9078	-0.1935	0.0000	0.0000	0.0000	0.0000;
	648	832	0.035537	0.115041	0.019031	58	58	58	0	0	1	-360	360	-3.6050	-0.4000	3.6090	-1.8772	0.0000	0.0000	0.0000	0.0000;
	754	755	0.023802	0.053802	0.005501	58	58	58	0	0	1	-360	360	-10.2994	-1.1497	10.3222	0.5881	0.0000	0.0000	0.0000	0.0000;
	750	754	0.018017	0.031818	0.002979	58	58	58	0	0	1	-360	360	3.8711	-0.9316	-3.8686	0.6047	0.0000	0.0000	0.0000	0.0000;
	756	750	0.001653	0.005372	0.000549	58	58	58	0	0	1	-360	360	10.9769	1.0131	-10.9751	-1.0684	0.0000	0.0000	0.0000	0.0000;
	755	756	0.010826	0.019174	0.001801	58	58	58	0	0	1	-360	360	18.4320	1.1708	-18.3989	-1.3131	0.0000	0.0000	0.0000	0.0000;
	711	755	0.016777	0.029587	0.002771	58	58	58	0	0	1	-360	360	-0.1162	-0.1039	0.1162	-0.2058	0.0000	0.0000	0.0000	0.0000;
	711	755	0.014554	0.025703	0.00241	58	58	58	0	0	1	-360	360	-0.1338	-0.0761	0.1338	-0.1933	0.0000	0.0000	0.0000	0.0000;
	816	681	0.083058	0.148678	0.013961	58	58	58	0	0	1	-360	360	6.1351	3.4549	-6.0952	-4.9882	0.0000	0.0000	0.0000	0.0000;
	817	816	0.014132	0.026942	0.00257	58	58	58	0	0	1	-360	360	16.1348	3.7549	-16.1015	-3.9905	0.0000	0.0000	0.0000	0.0000;
	794	814	0.02638	0.085314	0.008729	58	58	58	0	0	1	-360	360	11.3418	-4.6939	-11.3087	3.7813	0.0000	0.0000	0.0000	0.0000;
	637	593	0.03124	0.101066	0.010341	90	90	90	0	0	1	-360	360	-11.3874	-1.7405	11.4234	0.6754	0.0000	0.0000	0.0000	0.0000;
	795	689	0.034876	0.11281	0.011541	90	90	90	0	0	1	-360	360	-14.6404	0.0274	14.7043	-1.1791	0.0000	0.0000	0.0000	0.0000;
	689	687	0.002066	0.006612	0.00068	90	90	90	0	0	1	-360	360	-19.7933	0.1791	19.8001	-0.2376	0.0000	0.0000	0.0000	0.0000;
	784	687	0.019917	0.037107	0.003509	58	58	58	0	0	1	-360	360	32.4890	2.4744	-32.3121	-2.5624	0.0000	0.0000	0.0000	0.0000;
	808	773	0.01719	0.055703	0.005699	90	90	90	0	0	1	-360	360	-14.4361	1.9125	14.4670	-2.4900	0.0000	0.0000	0.0000	0.0000;
	807	723	0.012066	0.020744	0.00198	58	58	58	0	0	1	-360	360	7.7249	-1.4373	-7.7186	1.2159	0.0000	0.0000	0.0000	0.0000;
	807	783	0.05876	0.120248	0.01158	58	58	58	0	0	1	-360	360	4.0050	-2.3278	-3.9956	0.9882	0.0000	0.0000	0.0000	0.0000;
	808	631	0.045207	0.079256	0.006401	58	58	58	0	0	1	-360	360	27.3914	-0.7283	-27.1057	0.4764	0.0000	0.0000	0.0000	0.0000;
	631	627	0.013058	0.024554	0.00198	58	58	58	0	0	1	-360	360	13.8188	-3.6498	-13.7960	3.4625	0.0000	0.0000	0.0000	0.0000;
	737	627	0.044554	0.089256	0.00679	58	58	58	0	0	1	-360	360	-8.3706	5.3322	8.4100	-6.0435	0.0000	0.0000	0.0000	0.0000;
	626	773	0.022066	0.07124	0.007289	90	90	90	0	0	1	-360	360	23.6359	-2.6847	-23.5320	2.1500	0.0000	0.0000	0.0000	0.0000;
	707	706	0.00876	0.014554	0.00152	58	58	58	0	0	1	-360	360	4.9119	1.5099	-4.9099	-1.6843	0.0000	0.0000	0.0000	0.0000;
	812	807	0.003967	0.006942	0.000661	58	58	58	0	0	1	-360	360	-2.0585	-7.5014	2.0605	7.4274	0.0000	0.0000	0.0000	0.0000;
	727	649	0.016198	0.052231	0.005351	76	76	76	0	0	1	-360	360	-12.5544	2.6524	12.5774	-3.2056	0.0000	0.0000	0.0000	0.0000;
	649	613	0.01595	0.031744	0.00302	58	58	58	0	0	1	-360	360	-13.3194	3.2056	13.3451	-3.5090	0.0000	0.0000	0.0000	0.0000;
	707	613	0.01124	0.019752	0.00173	58	58	58	0	0	1	-360	360	-6.6419	-8.2480	6.6525	8.0637	0.0000	0.0000	0.0000	0.0000;
	707	614	0.010826	0.019091	0.00166	58	58	58	0	0	1	-360	360	3.7621	2.7109	-3.7601	-2.9015	0.0000	0.0000	0.0000	0.0000;
	800	775	0.003719	0.011901	0.00121	90	90	90	0	0	1	-360	360	-17.4427	-3.7081	17.4530	3.6016	0.0000	0.0000	0.0000	0.0000;
	778	775	0.022636	0.07314	0.00748	90	90	90	0	0	1	-360	360	22.4307	3.6587	-22.3300	-4.2016	0.0000	0.0000	0.0000	0.0000;
	808	594	0.136198	0.235124	0.022351	90	90	90	0	0	1	-360	360	13.1629	-0.1149	-12.9626	-2.1486	0.0000	0.0000	0.0000	0.0000;
	777	594	0.006124	0.019917	0.00204	90	90	90	0	0	1	-360	360	3.7609	1.8073	-3.7599	-2.0384	0.0000	0.0000	0.0000	0.0000;
	782	594	0.004628	0.014793	0.0016	90	90	90	0	0	1	-360	360	4.2349	-0.0742	-4.2342	-0.1071	0.0000	0.0000	0.0000	0.0000;
	782	776	0.007438	0.02405	0.002471	90	90	90	0	0	1	-360	360	-20.1399	-2.9258	20.1667	2.7284	0.0000	0.0000	0.0000	0.0000;
	776	766	0.003223	0.010496	0.001089	90	90	90	0	0	1	-360	360	-28.9667	-2.7284	28.9904	2.6799	0.0000	0.0000	0.0000	0.0000;
	781	778	0.027107	0.087769	0.008981	90	90	90	0	0	1	-360	360	9.9569	-2.3925	-9.9331	1.4190	0.0000	0.0000	0.0000	0.0000;
	779	652	0.009669	0.031488	0.003221	90	90	90	0	0	1	-360	360	10.9981	0.8151	-10.9880	-1.1582	0.0000	0.0000	0.0000	0.0000;
	721	652	0.045446	0.080909	0.00757	58	58	58	0	0	1	-360	360	-1.1263	0.3605	1.1270	-1.2418	0.0000	0.0000	0.0000	0.0000;
	721	614	0.026281	0.046942	0.0044	58	58	58	0	0	1	-360	360	-2.9017	-1.0605	2.9037	0.5506	0.0000	0.0000	0.0000	0.0000;
	753	707	0.010909	0.019256	0.001801	58	58	58	0	0	1	-360	360	4.5366	-2.4336	-4.5342	2.2272	0.0000	0.0000	0.0000	0.0000;
	740	632	0.035207	0.076446	0.007429	90	90	90	0	0	1	-360	360	17.3106	-0.7640	-17.2211	0.0870	0.0000	0.0000	0.0000	0.0000;
	801	741	0.022397	0.072397	0.00741	90	90	90	0	0	1	-360	360	-14.8816	-1.9129	14.9244	1.1811	0.0000	0.0000	0.0000	0.0000;
	741	716	0.021322	0.06595	0.006711	58	58	58	0	0	1	-360	360	34.8926	7.0536	-34.6623	-7.1244	0.0000	0.0000	0.0000	0.0000;
	716	614	0.076942	0.132562	0.01263	58	58	58	0	0	1	-360	360	-0.4487	-5.6756	0.4651	4.2370	0.0000	0.0000	0.0000	0.0000;
	791	594	0.031818	0.079587	0.008061	76	76	76	0	0	1	-360	360	-15.4540	-9.8232	15.5466	9.1401	0.0000	0.0000	0.0000	0.0000;
	791	767	0.009174	0.022893	0.002321	76	76	76	0	0	1	-360	360	6.3360	7.7232	-6.3276	-7.9623	0.0000	0.0000	0.0000	0.0000;
	809	593	0.023554	0.07562	0.007819	90	90	90	0	0	1	-360	360	-28.6887	-8.1747	28.8741	7.8829	0.0000	0.0000	0.0000	0.0000;
	809	671	0.022231	0.071397	0.007381	90	90	90	0	0	1	-360	360	20.6297	5.9747	-20.5373	-6.4991	0.0000	0.0000	0.0000	0.0000;
	669	591	0.022066	0.059173	0.00611	90	90	90	0	0	1	-360	360	-5.6122	0.3331	5.6186	-0.9938	0.0000	0.0000	0.0000	0.0000;
	792	591	0.025372	0.067364	0.00695	76	76	76	0	0	1	-360	360	22.5644	0.9419	-22.4489	-1.4114	0.0000	0.0000	0.0000	0.0000;
	688	792	0.01405	0.036446	0.00377	76	76	76	0	0	1	-360	360	21.6479	1.8114	-21.5891	-2.0839	0.0000	0.0000	0.0000	0.0000;
	671	633	0.020744	0.067017	0.006861	90	90	90	0	0	1	-360	360	1.6788	1.7961	-1.6773	-2.5474	0.0000	0.0000	0.0000	0.0000;
	659	633	0.009669	0.026198	0.002631	58	58	58	0	0	1	-360	360	7.9758	-2.5203	-7.9697	2.2474	0.0000	0.0000	0.0000	0.0000;
	722	659	0.006198	0.02	0.00204	58	58	58	0	0	1	-360	360	10.7396	-2.6227	-10.7328	2.4203	0.0000	0.0000	0.0000	0.0000;
	815	613	0.015793	0.051066	0.00523	90	90	90	0	0	1	-360	360	-15.0303	-3.1802	15.0620	2.6702	0.0000	0.0000	0.0000	0.0000;
	781	763	0.001744	0.00562	0.000581	90	90	90	0	0	1	-360	360	-27.9829	0.4925	27.9946	-0.5230	0.0000	0.0000	0.0000	0.0000;
	821	796	0.020579	0.036281	0.00339	58	58	58	0	0	1	-360	360	-18.6010	-1.7812	18.6642	1.5063	0.0000	0.0000	0.0000	0.0000;
	833	821	0.028017	0.090496	0.00924	90	90	90	0	0	1	-360	360	-13.5709	-1.5765	13.6170	0.6812	0.0000	0.0000	0.0000	0.0000;
	833	792	0.008678	0.015372	0.00143	90	90	90	0	0	1	-360	360	11.6629	0.9765	-11.6523	-1.1185	0.0000	0.0000	0.0000	0.0000;
	779	593	0.033058	0.10686	0.010941	90	90	90	0	0	1	-360	360	19.5727	3.4581	-19.4596	-4.3594	0.0000	0.0000	0.0000	0.0000;
	808	641	0.032983	0.106686	0.010909	90	90	90	0	0	1	-360	360	14.6622	-4.2061	-14.5989	3.1158	0.0000	0.0000	0.0000	0.0000;
	727	811	0.020661	0.066777	0.006829	58	58	58	0	0	1	-360	360	12.3424	-2.6524	-12.3146	1.9425	0.0000	0.0000	0.0000	0.0000;
	815	636	0.014793	0.047686	0.004881	90	90	90	0	0	1	-360	360	7.0773	1.8802	-7.0704	-2.4266	0.0000	0.0000	0.0000	0.0000;
	818	636	0.007438	0.01314	0.001229	58	58	58	0	0	1	-360	360	1.4118	-0.5693	-1.4116	0.4266	0.0000	0.0000	0.0000	0.0000;
	818	631	0.008256	0.014628	0.00137	58	58	58	0	0	1	-360	360	-4.0618	-0.4307	4.0630	0.2734	0.0000	0.0000	0.0000	0.0000;
	804	792	0.002562	0.008182	0.00083	90	90	90	0	0	1	-360	360	-4.5413	3.4585	4.5421	-3.5493	0.0000	0.0000	0.0000	0.0000;
	706	614	0.005289	0.016859	0.00173	90	90	90	0	0	1	-360	360	-0.3911	1.6843	0.3912	-1.8860	0.0000	0.0000	0.0000	0.0000;
	779	680	0.038934	0.12595	0.012879	90	90	90	0	0	1	-360	360	28.7101	4.4593	-28.4264	-5.0247	0.0000	0.0000	0.0000	0.0000;
	732	753	0.02157	0.047438	0.00462	58	58	58	0	0	1	-360	360	6.4526	-1.7569	-6.4446	1.2336	0.0000	0.0000	0.0000	0.0000;
	732	740	0.029669	0.066364	0.00649	90	90	90	0	0	1	-360	360	-27.0785	6.7981	27.2772	-7.1164	0.0000	0.0000	0.0000	0.0000;
	680	637	0.009826	0.031818	0.00325	90	90	90	0	0	1	-360	360	-11.2572	-1.9933	11.2684	1.6605	0.0000	0.0000	0.0000	0.0000;
	779	763	0.02438	0.078017	0.008071	90	90	90	0	0	1	-360	360	-13.3765	1.8344	13.4149	-2.6558	0.0000	0.0000	0.0000	0.0000;
	766	763	0.017769	0.057364	0.005871	90	90	90	0	0	1	-360	360	-39.5944	-2.6799	39.8365	2.7788	0.0000	0.0000	0.0000	0.0000;
	801	632	0.008182	0.026446	0.00271	90	90	90	0	0	1	-360	360	10.7476	1.6129	-10.7393	-1.9028	0.0000	0.0000	0.0000	0.0000;
	669	609	0.012397	0.054132	0.006749	90	90	90	0	0	1	-360	360	0.5645	0.4118	-0.5644	-1.1591	0.0000	0.0000	0.0000	0.0000;
	811	812	0.008512	0.027438	0.00281	58	58	58	0	0	1	-360	360	2.9176	-6.0005	-2.9145	5.6814	0.0000	0.0000	0.0000	0.0000;
	804	793	0.006364	0.020579	0.002101	90	90	90	0	0	1	-360	360	4.2913	-3.5585	-4.2896	3.3279	0.0000	0.0000	0.0000	0.0000;
	609	591	0.017934	0.058016	0.005929	90	90	90	0	0	1	-360	360	-6.4326	-0.6409	6.4393	0.0053	0.0000	0.0000	0.0000	0.0000;
	668	671	0.001488	0.002636	0.000249	58	58	58	0	0	1	-360	360	-7.5106	-3.5289	7.5115	3.5030	0.0000	0.0000	0.0000	0.0000;
	670	668	0.000579	0.001901	0.000191	90	90	90	0	0	1	-360	360	-0.9366	-2.3498	0.9366	2.3289	0.0000	0.0000	0.0000	0.0000;
	835	808	0.028678	0.09281	0.009489	58	58	58	0	0	1	-360	360	-26.3038	3.2965	26.4757	-3.8632	0.0000	0.0000	0.0000	0.0000;
	589	737	0.015703	0.050744	0.005191	90	90	90	0	0	1	-360	360	-2.2260	-1.0000	2.2267	0.3981	0.0000	0.0000	0.0000	0.0000;
	661	732	0.021322	0.068934	0.00705	90	90	90	0	0	1	-360	360	-19.2966	5.5552	19.3709	-6.1411	0.0000	0.0000	0.0000	0.0000;
	800	777	0.008182	0.026529	0.00271	90	90	90	0	0	1	-360	360	7.0517	1.8081	-7.0479	-2.1073	0.0000	0.0000	0.0000	0.0000;
	672	670	0.011488	0.029669	0.003011	58	58	58	0	0	1	-360	360	11.8019	-0.0450	-11.7874	-0.2502	0.0000	0.0000	0.0000	0.0000;
	658	722	0.006198	0.02	0.00204	90	90	90	0	0	1	-360	360	13.0227	-1.4065	-13.0131	1.2129	0.0000	0.0000	0.0000	0.0000;
	729	661	0.018099	0.058512	0.00599	90	90	90	0	0	1	-360	360	-15.5429	5.5912	15.5856	-6.1552	0.0000	0.0000	0.0000	0.0000;
	669	672	0.005702	0.016033	0.00165	90	90	90	0	0	1	-360	360	21.3413	0.1102	-21.3179	-0.2270	0.0000	0.0000	0.0000	0.0000;
	796	688	0.019174	0.049826	0.005159	76	76	76	0	0	1	-360	360	26.4330	3.1341	-26.3139	-3.4114	0.0000	0.0000	0.0000	0.0000;
	795	778	0.023058	0.074628	0.00764	90	90	90	0	0	1	-360	360	7.1584	-0.0274	-7.1483	-0.8343	0.0000	0.0000	0.0000	0.0000;
	784	626	0.000157	0.000504	5.1e-05	90	90	90	0	0	1	-360	360	-33.4430	-2.6744	33.4444	2.6731	0.0000	0.0000	0.0000	0.0000;
	597	722	0.030248	0.059314	0.00567	90	90	90	0	0	1	-360	360	11.8676	1.3403	-11.8285	-1.8902	0.0000	0.0000	0.0000	0.0000;
	669	639	0.013587	0.043942	0.004496	137	137	137	0	0	1	-360	360	5.4767	-0.4862	-5.4730	-0.0000	0.0000	0.0000	0.0000	0.0000;
	839	768	0.051901	0.131397	0.013119	76	76	76	0	0	1	-360	360	-9.3655	2.9643	9.4108	-4.3739	0.0000	0.0000	0.0000	0.0000;
	771	769	0.015207	0.02562	0.002449	58	58	58	0	0	1	-360	360	-21.4833	0.0408	21.5440	-0.2222	0.0000	0.0000	0.0000	0.0000;
	771	770	0.008512	0.01438	0.001549	58	58	58	0	0	1	-360	360	8.3303	-6.6588	-8.3220	6.4938	0.0000	0.0000	0.0000	0.0000;
	770	744	0.027016	0.087603	0.009	90	90	90	0	0	1	-360	360	0.9000	-9.4938	-0.8810	8.5081	0.0000	0.0000	0.0000	0.0000;
	743	679	0.018512	0.06	0.00614	90	90	90	0	0	1	-360	360	-9.0406	-8.8038	9.0645	8.1502	0.0000	0.0000	0.0000	0.0000;
	679	665	0.013719	0.044463	0.00454	90	90	90	0	0	1	-360	360	-17.0175	-9.6502	17.0608	9.2437	0.0000	0.0000	0.0000	0.0000;
	768	761	0.022893	0.051901	0.00506	58	58	58	0	0	1	-360	360	15.3516	1.3118	-15.3047	-1.7912	0.0000	0.0000	0.0000	0.0000;
	772	761	0.025207	0.057438	0.00561	58	58	58	0	0	1	-360	360	-9.1089	5.7603	9.1350	-6.3483	0.0000	0.0000	0.0000	0.0000;
	772	765	0.005793	0.009917	0.00105	90	90	90	0	0	1	-360	360	2.7479	-6.7603	-2.7452	6.6433	0.0000	0.0000	0.0000	0.0000;
	645	622	0.017769	0.057364	0.005871	90	90	90	0	0	1	-360	360	-12.1217	-9.9123	12.1578	9.3362	0.0000	0.0000	0.0000	0.0000;
	665	622	0.020579	0.066124	0.006861	90	90	90	0	0	1	-360	360	14.6619	12.5722	-14.5967	-13.1854	0.0000	0.0000	0.0000	0.0000;
	768	616	0.009008	0.031066	0.002979	90	90	90	0	0	1	-360	360	0.0684	3.2900	-0.0674	-3.6327	0.0000	0.0000	0.0000	0.0000;
	752	616	0.023967	0.083223	0.007991	90	90	90	0	0	1	-360	360	3.1182	-4.0415	-3.1136	3.1327	0.0000	0.0000	0.0000	0.0000;
	762	752	0.023223	0.075207	0.0077	90	90	90	0	0	1	-360	360	10.5666	-4.8451	-10.5402	4.0415	0.0000	0.0000	0.0000	0.0000;
	830	788	0.008843	0.014876	0.0015	58	58	58	0	0	1	-360	360	-7.6142	-3.3337	7.6195	3.1707	0.0000	0.0000	0.0000	0.0000;
	830	600	0.014628	0.025793	0.00242	58	58	58	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	802	768	0.053314	0.133388	0.010641	76	76	76	0	0	1	-360	360	-6.9209	-1.6796	6.9436	0.5054	0.0000	0.0000	0.0000	0.0000;
	769	640	0.040661	0.111157	0.011471	76	76	76	0	0	1	-360	360	7.0028	0.3373	-6.9853	-1.6178	0.0000	0.0000	0.0000	0.0000;
	806	640	0.027769	0.077686	0.00801	76	76	76	0	0	1	-360	360	-2.7422	-1.5352	2.7443	0.6178	0.0000	0.0000	0.0000	0.0000;
	806	802	0.002893	0.007769	0.000801	76	76	76	0	0	1	-360	360	-8.9218	-1.9648	8.9239	1.8782	0.0000	0.0000	0.0000	0.0000;
	600	802	0.04	0.061818	0.006759	58	58	58	0	0	1	-360	360	-1.1157	-4.1167	1.1210	3.3482	0.0000	0.0000	0.0000	0.0000;
	798	600	0.038256	0.06562	0.01263	58	58	58	0	0	1	-360	360	0.9684	-4.1226	-0.9642	2.6844	0.0000	0.0000	0.0000	0.0000;
	798	673	0.028934	0.049752	0.00953	58	58	58	0	0	1	-360	360	-5.7394	4.1226	5.7532	-5.1869	0.0000	0.0000	0.0000	0.0000;
	674	673	0.004132	0.007107	0.00137	58	58	58	0	0	1	-360	360	12.1204	-4.8327	-12.1142	4.6869	0.0000	0.0000	0.0000	0.0000;
	802	730	0.069091	0.123802	0.010079	58	58	58	0	0	1	-360	360	-11.7750	-3.1243	11.8621	2.1079	0.0000	0.0000	0.0000	0.0000;
	802	663	0.039917	0.067934	0.005431	58	58	58	0	0	1	-360	360	-8.3139	-3.4768	8.3413	2.8950	0.0000	0.0000	0.0000	0.0000;
	735	663	0.01281	0.021818	0.00175	58	58	58	0	0	1	-360	360	11.5378	2.7176	-11.5223	-2.8950	0.0000	0.0000	0.0000	0.0000;
	735	731	0.013223	0.034298	0.003291	58	58	58	0	0	1	-360	360	-21.1748	-3.6706	21.2270	3.4205	0.0000	0.0000	0.0000	0.0000;
	730	694	0.031322	0.101397	0.010379	90	90	90	0	0	1	-360	360	12.6898	-0.8703	-12.6468	-0.2060	0.0000	0.0000	0.0000	0.0000;
	733	730	0.002479	0.007934	0.00082	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	733	730	0.002479	0.007934	0.00082	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	734	733	0.000331	0.000579	0.0242	274	274	274	0	0	1	-360	360	42.4190	7.5171	-42.4130	-10.0000	0.0000	0.0000	0.0000	0.0000;
	622	596	0.016281	0.052727	0.005411	90	90	90	0	0	1	-360	360	-1.5321	3.5091	1.5344	-4.1432	0.0000	0.0000	0.0000	0.0000;
	822	664	0.034711	0.112562	0.01158	90	90	90	0	0	1	-360	360	-47.9569	5.5537	48.6393	-4.7312	0.0000	0.0000	0.0000	0.0000;
	822	713	0.015124	0.051322	0.00251	90	90	90	0	0	1	-360	360	38.4149	-7.0537	-38.2212	7.4129	0.0000	0.0000	0.0000	0.0000;
	713	628	0.029496	0.051818	0.004881	90	90	90	0	0	1	-360	360	36.5172	-7.4129	-36.1728	7.4426	0.0000	0.0000	0.0000	0.0000;
	810	600	0.010248	0.018099	0.001699	58	58	58	0	0	1	-360	360	9.6949	0.3945	-9.6865	-0.5745	0.0000	0.0000	0.0000	0.0000;
	827	810	0.03124	0.055124	0.005159	58	58	58	0	0	1	-360	360	10.8568	-0.1436	-10.8249	-0.3945	0.0000	0.0000	0.0000	0.0000;
	827	667	0.024463	0.043223	0.004051	58	58	58	0	0	1	-360	360	-16.1578	0.1436	16.2131	-0.5154	0.0000	0.0000	0.0000	0.0000;
	717	667	0.057364	0.100826	0.009489	58	58	58	0	0	1	-360	360	-6.5955	-3.7949	6.6225	2.7456	0.0000	0.0000	0.0000	0.0000;
	728	717	0.013636	0.070413	0.007279	90	90	90	0	0	1	-360	360	-2.5012	-0.4752	2.5020	-0.3569	0.0000	0.0000	0.0000	0.0000;
	654	667	0.003058	0.009826	0.001009	90	90	90	0	0	1	-360	360	-8.3297	-3.9383	8.3319	3.8281	0.0000	0.0000	0.0000	0.0000;
	656	655	0.004463	0.014554	0.001481	90	90	90	0	0	1	-360	360	-4.5916	2.1949	4.5926	-2.3634	0.0000	0.0000	0.0000	0.0000;
	758	655	0.01405	0.045372	0.004649	90	90	90	0	0	1	-360	360	28.0145	1.9015	-27.9196	-2.1366	0.0000	0.0000	0.0000	0.0000;
	657	667	0.007603	0.024554	0.002519	90	90	90	0	0	1	-360	360	-18.5107	-1.5519	18.5333	1.3324	0.0000	0.0000	0.0000	0.0000;
	678	657	0.004463	0.013876	0.00143	90	90	90	0	0	1	-360	360	-13.2029	-1.6964	13.2097	1.5519	0.0000	0.0000	0.0000	0.0000;
	666	678	0.005702	0.018512	0.00189	90	90	90	0	0	1	-360	360	5.8848	0.0902	-5.8831	-0.3036	0.0000	0.0000	0.0000	0.0000;
	758	717	0.021984	0.06843	0.00702	90	90	90	0	0	1	-360	360	26.1089	6.6282	-25.9715	-7.0142	0.0000	0.0000	0.0000	0.0000;
	825	759	0.016198	0.02843	0.002691	58	58	58	0	0	1	-360	360	1.5011	-6.3698	-1.4955	6.0654	0.0000	0.0000	0.0000	0.0000;
	825	644	0.039174	0.066033	0.003959	58	58	58	0	0	1	-360	360	-5.7421	5.3698	5.7637	-5.7947	0.0000	0.0000	0.0000	0.0000;
	643	644	0.009587	0.020174	0.00196	58	58	58	0	0	1	-360	360	14.2653	-5.9816	-14.2457	5.7947	0.0000	0.0000	0.0000	0.0000;
	759	718	0.009669	0.03157	0.003221	90	90	90	0	0	1	-360	360	8.9619	2.8904	-8.9545	-3.2423	0.0000	0.0000	0.0000	0.0000;
	718	619	0.047769	0.090579	0.00862	58	58	58	0	0	1	-360	360	3.6535	2.2423	-3.6449	-3.2275	0.0000	0.0000	0.0000	0.0000;
	785	619	0.022727	0.046612	0.004501	58	58	58	0	0	1	-360	360	0.5986	-3.7428	-0.5961	3.2275	0.0000	0.0000	0.0000	0.0000;
	785	606	0.024628	0.059587	0.004961	58	58	58	0	0	1	-360	360	-2.7186	3.2428	2.7228	-3.8046	0.0000	0.0000	0.0000	0.0000;
	607	606	0.005702	0.018512	0.00189	58	58	58	0	0	1	-360	360	7.4253	0.0842	-7.4226	-0.2931	0.0000	0.0000	0.0000	0.0000;
	839	694	0.04719	0.085207	0.00803	76	76	76	0	0	1	-360	360	-6.2698	-0.1122	6.2858	-0.7940	0.0000	0.0000	0.0000	0.0000;
	761	757	0.007769	0.016859	0.00165	90	90	90	0	0	1	-360	360	-2.3124	6.1396	2.3153	-6.3233	0.0000	0.0000	0.0000	0.0000;
	780	769	0.016859	0.029826	0.00281	58	58	58	0	0	1	-360	360	-20.5368	-3.1687	20.5998	2.9549	0.0000	0.0000	0.0000	0.0000;
	780	757	0.003554	0.006281	0.005421	58	58	58	0	0	1	-360	360	17.3558	2.1687	-17.3463	-2.7767	0.0000	0.0000	0.0000	0.0000;
	838	600	0.005868	0.010331	0.00097	58	58	58	0	0	1	-360	360	-6.9926	-2.1132	6.9953	2.0068	0.0000	0.0000	0.0000	0.0000;
	838	797	0.003802	0.012397	0.00127	58	58	58	0	0	1	-360	360	4.8726	2.1132	-4.8717	-2.2555	0.0000	0.0000	0.0000	0.0000;
	797	739	0.00405	0.012984	0.001331	90	90	90	0	0	1	-360	360	1.1607	1.7555	-1.1605	-1.9072	0.0000	0.0000	0.0000	0.0000;
	762	623	0.003554	0.01157	0.001191	90	90	90	0	0	1	-360	360	2.1201	-0.1369	-2.1200	-0.0000	0.0000	0.0000	0.0000	0.0000;
	805	607	0.017769	0.057603	0.00589	58	58	58	0	0	1	-360	360	12.7513	-0.5150	-12.7263	-0.0842	0.0000	0.0000	0.0000	0.0000;
	629	805	0.017769	0.057603	0.00589	58	58	58	0	0	1	-360	360	17.0367	-0.5543	-16.9923	0.0150	0.0000	0.0000	0.0000	0.0000;
	742	606	0.021744	0.038347	0.003589	58	58	58	0	0	1	-360	360	4.8481	-3.0007	-4.8422	2.5977	0.0000	0.0000	0.0000	0.0000;
	742	831	0.01719	0.05562	0.00568	90	90	90	0	0	1	-360	360	-9.6191	3.0786	9.6347	-3.6823	0.0000	0.0000	0.0000	0.0000;
	831	677	0.01719	0.05562	0.00568	90	90	90	0	0	1	-360	360	-12.8174	4.3793	12.8452	-4.9429	0.0000	0.0000	0.0000	0.0000;
	712	596	0.020744	0.067273	0.00688	90	90	90	0	0	1	-360	360	6.3146	-3.9274	-6.3054	3.1432	0.0000	0.0000	0.0000	0.0000;
	676	674	0.00157	0.003058	0.00029	58	58	58	0	0	1	-360	360	14.2434	-4.3599	-14.2404	4.3327	0.0000	0.0000	0.0000	0.0000;
	788	769	0.038256	0.067521	0.006331	58	58	58	0	0	1	-360	360	-12.3905	-4.1707	12.4465	3.5386	0.0000	0.0000	0.0000	0.0000;
	802	725	0.024876	0.072231	0.00824	90	90	90	0	0	1	-360	360	2.1210	-0.4458	-2.1200	-0.5000	0.0000	0.0000	0.0000	0.0000;
	742	660	0.015207	0.049008	0.005019	20	20	20	0	0	1	-360	360	0.5300	-0.5779	-0.5300	0.0000	0.0000	0.0000	0.0000	0.0000;
	830	799	0.000413	0.011901	0.00122	69	69	69	0	0	1	-360	360	7.6142	3.3337	-7.6140	-3.4661	0.0000	0.0000	0.0000	0.0000;
	739	799	0.00281	0.009008	0.00092	69	69	69	0	0	1	-360	360	-3.8555	-2.1228	3.8560	2.0191	0.0000	0.0000	0.0000	0.0000;
	759	651	0.022893	0.074132	0.007579	90	90	90	0	0	1	-360	360	17.4543	-0.1347	-17.3947	-0.5556	0.0000	0.0000	0.0000	0.0000;
	743	744	0.019339	0.062636	0.006411	90	90	90	0	0	1	-360	360	3.3756	8.8038	-3.3600	-9.5081	0.0000	0.0000	0.0000	0.0000;
	656	654	0.004554	0.014711	0.0015	90	90	90	0	0	1	-360	360	-7.0724	-3.1949	7.0747	3.0283	0.0000	0.0000	0.0000	0.0000;
	643	790	0.034876	0.064876	0.00614	58	58	58	0	0	1	-360	360	-17.4463	5.9816	17.5496	-6.5055	0.0000	0.0000	0.0000	0.0000;
	765	645	0.020992	0.067851	0.006941	90	90	90	0	0	1	-360	360	-6.7968	-9.6433	6.8207	8.9123	0.0000	0.0000	0.0000	0.0000;
	651	666	0.010826	0.035124	0.003589	69	69	69	0	0	1	-360	360	11.7297	0.2156	-11.7168	-0.5902	0.0000	0.0000	0.0000	0.0000;
	625	831	0.019174	0.059587	0.006103	69	69	69	0	0	1	-360	360	-3.1810	0.0000	3.1827	-0.6971	0.0000	0.0000	0.0000	0.0000;
	1858	1273	0.026281	0.082975	0.009048	114	114	114	0	0	1	-360	360	7.0315	0.4932	-7.0204	-1.5426	0.0000	0.0000	0.0000	0.0000;
	1272	1273	0.002975	0.009669	0.001004	140	140	140	0	0	1	-360	360	-7.0190	-2.5240	7.0204	2.4084	0.0000	0.0000	0.0000	0.0000;
	984	1492	0.036116	0.050413	0.008291	57	57	57	0	0	1	-360	360	-1.3770	-0.4449	1.3776	-0.5129	0.0000	0.0000	0.0000	0.0000;
	983	984	0	8.3e-05	1e-05	29	29	29	0	0	1	-360	360	-1.3770	-0.4460	1.3770	0.4449	0.0000	0.0000	0.0000	0.0000;
	1017	986	0.016198	0.049174	0.00584	114	114	114	0	0	1	-360	360	21.1608	0.9340	-21.1009	-1.4594	0.0000	0.0000	0.0000	0.0000;
	1016	1017	0.000165	0.000248	4.4e-05	90	90	90	0	0	1	-360	360	-1.7250	-0.7320	1.7250	0.7267	0.0000	0.0000	0.0000	0.0000;
	1021	1360	0.016529	0.050413	0.005893	114	114	114	0	0	1	-360	360	-17.8689	1.1385	17.9169	-1.6444	0.0000	0.0000	0.0000	0.0000;
	1020	1021	0.000496	0.001488	0.000172	114	114	114	0	0	1	-360	360	-3.6810	-0.8630	3.6811	0.8442	0.0000	0.0000	0.0000	0.0000;
	1144	900	0.038678	0.099587	0.011081	114	114	114	0	0	1	-360	360	-13.7126	1.9030	13.7771	-3.0335	0.0000	0.0000	0.0000	0.0000;
	1600	1348	0.005372	0.01719	0.001832	114	114	114	0	0	1	-360	360	7.8149	1.2997	-7.8120	-1.5050	0.0000	0.0000	0.0000	0.0000;
	901	1600	0.039091	0.09562	0.010571	114	114	114	0	0	1	-360	360	14.3231	1.5646	-14.2539	-2.6425	0.0000	0.0000	0.0000	0.0000;
	1599	1600	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	-6.4390	-1.3450	6.4390	1.3428	0.0000	0.0000	0.0000	0.0000;
	1327	1247	0.01595	0.046694	0.004131	114	114	114	0	0	1	-360	360	2.7083	2.7697	-2.7061	-3.2452	0.0000	0.0000	0.0000	0.0000;
	1717	1327	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	5.0121	2.1701	-5.0034	-3.1249	0.0000	0.0000	0.0000	0.0000;
	1325	1327	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	-2.2950	-0.3710	2.2950	0.3552	0.0000	0.0000	0.0000	0.0000;
	1328	1246	0.01595	0.046694	0.004136	114	114	114	0	0	1	-360	360	0.3349	1.0629	-0.3346	-1.5529	0.0000	0.0000	0.0000	0.0000;
	1718	1328	0.031736	0.094215	0.008361	120	120	120	0	0	1	-360	360	0.3350	0.0541	-0.3349	-1.0468	0.0000	0.0000	0.0000	0.0000;
	1326	1328	0.000496	0.001157	0.000135	29	29	29	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0161	0.0000	0.0000	0.0000	0.0000;
	1888	1630	0.048182	0.119835	0.013225	114	114	114	0	0	1	-360	360	-3.8627	-1.0433	3.8689	-0.4939	0.0000	0.0000	0.0000	0.0000;
	1629	1301	0.040165	0.105785	0.01189	114	114	114	0	0	1	-360	360	4.6024	-0.3994	-4.5951	-0.9776	0.0000	0.0000	0.0000	0.0000;
	1014	884	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	-64.4574	-8.3339	64.8718	9.1202	0.0000	0.0000	0.0000	0.0000;
	1013	885	0.011653	0.03595	0.004112	114	114	114	0	0	1	-360	360	-9.2236	-0.3549	9.2319	-0.1160	0.0000	0.0000	0.0000	0.0000;
	1217	1632	0.002727	0.008926	0.000886	140	140	140	0	0	1	-360	360	46.4887	-0.7084	-46.4387	0.7675	0.0000	0.0000	0.0000	0.0000;
	1351	1217	0.007603	0.023471	0.002664	114	114	114	0	0	1	-360	360	47.7819	-0.3220	-47.6357	0.4581	0.0000	0.0000	0.0000	0.0000;
	1216	1217	0.000331	0.000413	8.2e-05	90	90	90	0	0	1	-360	360	-1.1470	-0.2600	1.1470	0.2503	0.0000	0.0000	0.0000	0.0000;
	898	1412	0.018182	0.044628	0.004898	120	120	120	0	0	1	-360	360	11.8667	2.9208	-11.8434	-3.4408	0.0000	0.0000	0.0000	0.0000;
	1859	898	0.026033	0.063636	0.007047	120	120	120	0	0	1	-360	360	17.8004	2.9931	-17.7288	-3.6557	0.0000	0.0000	0.0000	0.0000;
	898	896	0.013884	0.018017	0.003231	90	90	90	0	0	1	-360	360	5.8621	0.7349	-5.8580	-1.1110	0.0000	0.0000	0.0000	0.0000;
	1264	1413	0.017355	0.048265	0.005145	120	120	120	0	0	1	-360	360	9.2774	2.3358	-9.2637	-2.9046	0.0000	0.0000	0.0000	0.0000;
	1560	1206	0.00686	0.022231	0.002331	140	140	140	0	0	1	-360	360	38.0961	-2.9722	-38.0112	2.9732	0.0000	0.0000	0.0000	0.0000;
	1056	1560	0.004298	0.013388	0.001488	140	140	140	0	0	1	-360	360	43.7897	-1.3992	-43.7199	1.4409	0.0000	0.0000	0.0000	0.0000;
	1351	1056	0.005785	0.017686	0.002079	140	140	140	0	0	1	-360	360	46.4218	-0.6281	-46.3168	0.7029	0.0000	0.0000	0.0000	0.0000;
	1559	1560	0.006033	0.01843	0.002183	140	140	140	0	0	1	-360	360	-5.6220	-1.7830	5.6238	1.5313	0.0000	0.0000	0.0000	0.0000;
	1056	1055	0.002314	0.002893	0.000549	90	90	90	0	0	1	-360	360	2.5271	0.6962	-2.5270	-0.7610	0.0000	0.0000	0.0000	0.0000;
	1711	975	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	29.2807	5.5846	-29.2430	-5.6800	0.0000	0.0000	0.0000	0.0000;
	1353	1711	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	34.7901	7.1786	-34.6821	-7.2810	0.0000	0.0000	0.0000	0.0000;
	1711	1709	0.005124	0.008595	0.000908	90	90	90	0	0	1	-360	360	5.4014	1.6965	-5.4000	-1.8020	0.0000	0.0000	0.0000	0.0000;
	1712	976	0.005041	0.015372	0.001774	140	140	140	0	0	1	-360	360	-3.7251	-5.8684	3.7271	5.6608	0.0000	0.0000	0.0000	0.0000;
	1353	1712	0.010248	0.031405	0.003628	140	140	140	0	0	1	-360	360	1.0978	-4.6672	-1.0960	4.2368	0.0000	0.0000	0.0000	0.0000;
	1712	1710	0.005124	0.008512	0.0009	90	90	90	0	0	1	-360	360	4.8211	1.6316	-4.8200	-1.7380	0.0000	0.0000	0.0000	0.0000;
	1888	1364	0.040165	0.070165	0.007071	90	90	90	0	0	1	-360	360	2.0258	2.0547	-2.0223	-2.8753	0.0000	0.0000	0.0000	0.0000;
	1674	1307	0.022479	0.06562	0.006333	120	120	120	0	0	1	-360	360	50.5256	-0.8125	-50.0491	1.4477	0.0000	0.0000	0.0000	0.0000;
	1673	1851	0.01876	0.055372	0.005322	120	120	120	0	0	1	-360	360	47.2578	-1.5902	-46.9116	1.9717	0.0000	0.0000	0.0000	0.0000;
	1321	1180	0.014628	0.045868	0.005084	140	140	140	0	0	1	-360	360	5.0284	0.9487	-5.0251	-1.5412	0.0000	0.0000	0.0000	0.0000;
	1590	1321	0.006281	0.019752	0.002183	140	140	140	0	0	1	-360	360	5.0298	0.5895	-5.0284	-0.8444	0.0000	0.0000	0.0000	0.0000;
	1321	1319	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1043	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1322	928	0.006281	0.019504	0.002217	140	140	140	0	0	1	-360	360	2.2321	-3.9744	-2.2310	3.7179	0.0000	0.0000	0.0000	0.0000;
	1766	1322	0.005041	0.015454	0.001793	140	140	140	0	0	1	-360	360	2.2330	-4.2843	-2.2321	4.0773	0.0000	0.0000	0.0000	0.0000;
	1322	1320	0.00438	0.00843	0.000879	90	90	90	0	0	1	-360	360	0.0000	-0.1029	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1353	840	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	0.0000	-0.6447	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1352	841	0.012479	0.045207	0.00537	114	114	114	0	0	1	-360	360	0.1150	-0.6393	-0.1150	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1421	1007	0.002231	0.008347	0.000983	162	162	162	0	0	1	-360	360	-0.1866	2.6694	0.1867	-2.7865	0.0000	0.0000	0.0000	0.0000;
	992	1008	0.004132	0.01562	0.001878	162	162	162	0	0	1	-360	360	1.1524	2.7346	-1.1521	-2.9583	0.0000	0.0000	0.0000	0.0000;
	1353	992	0.004876	0.016446	0.00198	140	140	140	0	0	1	-360	360	7.0195	4.1394	-7.0168	-4.3676	0.0000	0.0000	0.0000	0.0000;
	992	991	0.00124	0.004463	0.000554	162	162	162	0	0	1	-360	360	5.8644	1.6330	-5.8640	-1.6980	0.0000	0.0000	0.0000	0.0000;
	1397	1233	0.005537	0.017355	0.001919	140	140	140	0	0	1	-360	360	1.7954	-3.9574	-1.7946	3.7337	0.0000	0.0000	0.0000	0.0000;
	1463	1337	0.04157	0.060826	0.010346	57	57	57	0	0	1	-360	360	10.6696	1.0995	-10.6269	-2.2074	0.0000	0.0000	0.0000	0.0000;
	1494	1781	0.003967	0.011983	0.001421	140	140	140	0	0	1	-360	360	-0.4907	-2.7044	0.4909	2.5378	0.0000	0.0000	0.0000	0.0000;
	1667	1863	0.015868	0.048016	0.005704	114	114	114	0	0	1	-360	360	24.5242	4.3109	-24.4373	-4.6935	0.0000	0.0000	0.0000	0.0000;
	1010	1667	0.02157	0.065454	0.007771	114	114	114	0	0	1	-360	360	24.6409	3.6765	-24.5242	-4.2126	0.0000	0.0000	0.0000	0.0000;
	1666	1667	0.002397	0.007273	0.000864	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0983	0.0000	0.0000	0.0000	0.0000;
	1440	1771	0.002397	0.007355	0.000852	140	140	140	0	0	1	-360	360	6.4701	-1.6866	-6.4692	1.5890	0.0000	0.0000	0.0000	0.0000;
	1387	1293	0.010496	0.031901	0.003782	114	114	114	0	0	1	-360	360	31.1157	-3.8118	-31.0293	3.6242	0.0000	0.0000	0.0000	0.0000;
	1222	1449	0.024793	0.041322	0.004259	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1068	990	0.010826	0.023967	0.003364	114	114	114	0	0	1	-360	360	19.9604	4.5997	-19.9216	-4.9088	0.0000	0.0000	0.0000	0.0000;
	1746	1502	0.008347	0.024959	0.003015	114	114	114	0	0	1	-360	360	-19.9783	-2.7850	20.0077	2.5240	0.0000	0.0000	0.0000	0.0000;
	1119	1432	0.024793	0.083471	0.010285	114	114	114	0	0	1	-360	360	-50.8003	-19.6306	51.4500	20.6321	0.0000	0.0000	0.0000	0.0000;
	1497	1432	0.034876	0.093058	0.01232	120	120	120	0	0	1	-360	360	-29.5808	-8.5778	29.8659	7.9040	0.0000	0.0000	0.0000	0.0000;
	1588	1313	0.008182	0.014628	0.00304	120	120	120	0	0	1	-360	360	62.6475	5.5320	-62.3786	-5.4155	0.0000	0.0000	0.0000	0.0000;
	1750	962	0.056033	0.074711	0.007168	75	75	75	0	0	1	-360	360	-12.5631	-2.7720	12.6432	2.0528	0.0000	0.0000	0.0000	0.0000;
	1750	1332	0.038265	0.051984	0.004753	57	57	57	0	0	1	-360	360	25.3357	-0.0039	-25.1209	-0.2431	0.0000	0.0000	0.0000	0.0000;
	1336	1247	0.029256	0.050826	0.004973	90	90	90	0	0	1	-360	360	16.0508	-2.6917	-15.9851	2.2248	0.0000	0.0000	0.0000	0.0000;
	1889	1004	0.019752	0.05124	0.005878	90	90	90	0	0	1	-360	360	19.2896	-4.0487	-19.2250	3.5241	0.0000	0.0000	0.0000	0.0000;
	1483	1267	0.021818	0.065702	0.007795	90	90	90	0	0	1	-360	360	5.8393	-3.6456	-5.8311	2.7560	0.0000	0.0000	0.0000	0.0000;
	1568	1267	0.036281	0.070579	0.007366	90	90	90	0	0	1	-360	360	-14.3488	9.1392	14.4405	-9.8266	0.0000	0.0000	0.0000	0.0000;
	1803	1015	0.019917	0.060579	0.007124	114	114	114	0	0	1	-360	360	23.2822	2.6441	-23.1914	-3.2245	0.0000	0.0000	0.0000	0.0000;
	1211	1013	0.007769	0.023719	0.002798	140	140	140	0	0	1	-360	360	23.3815	2.4666	-23.3460	-2.6961	0.0000	0.0000	0.0000	0.0000;
	848	1804	0.047603	0.060165	0.005242	60	60	60	0	0	1	-360	360	-1.8380	-0.4300	1.8393	-0.2096	0.0000	0.0000	0.0000	0.0000;
	1013	1690	0.052479	0.129917	0.014394	114	114	114	0	0	1	-360	360	19.5298	-0.0548	-19.3635	-1.2534	0.0000	0.0000	0.0000	0.0000;
	1886	939	0.032645	0.079091	0.009402	114	114	114	0	0	1	-360	360	-1.6318	-0.6182	1.6325	-0.4935	0.0000	0.0000	0.0000	0.0000;
	879	1215	0.023719	0.033388	0.00589	90	90	90	0	0	1	-360	360	7.5750	-0.9111	-7.5630	0.2597	0.0000	0.0000	0.0000	0.0000;
	1175	1714	0.008264	0.026364	0.002848	140	140	140	0	0	1	-360	360	16.9713	5.2220	-16.9493	-5.4904	0.0000	0.0000	0.0000	0.0000;
	1013	1175	0.019917	0.063884	0.00674	114	114	114	0	0	1	-360	360	18.8709	4.9449	-18.8073	-5.5489	0.0000	0.0000	0.0000	0.0000;
	1174	1175	0.000992	0.003141	0.00037	114	114	114	0	0	1	-360	360	-1.8360	-0.3710	1.8360	0.3270	0.0000	0.0000	0.0000	0.0000;
	1690	1224	0.013554	0.040992	0.004864	114	114	114	0	0	1	-360	360	18.6819	5.2395	-18.6384	-5.6816	0.0000	0.0000	0.0000	0.0000;
	1208	970	0.005372	0.017025	0.001861	114	114	114	0	0	1	-360	360	19.7744	3.0552	-19.7565	-3.2223	0.0000	0.0000	0.0000	0.0000;
	1487	1645	0.020248	0.067934	0.006556	114	114	114	0	0	1	-360	360	-8.8588	-0.4694	8.8725	-0.2424	0.0000	0.0000	0.0000	0.0000;
	1738	1805	0.037273	0.119504	0.012681	114	114	114	0	0	1	-360	360	-18.0548	-4.5006	18.1681	3.4285	0.0000	0.0000	0.0000	0.0000;
	1739	960	0.01876	0.059339	0.006437	114	114	114	0	0	1	-360	360	-15.8870	-4.3827	15.9320	3.8003	0.0000	0.0000	0.0000	0.0000;
	1554	1388	0.015868	0.053554	0.005135	114	114	114	0	0	1	-360	360	-6.7409	2.1425	6.7477	-2.7317	0.0000	0.0000	0.0000	0.0000;
	1209	884	0.006777	0.021488	0.002343	114	114	114	0	0	1	-360	360	-19.7747	-3.0580	19.7972	2.8468	0.0000	0.0000	0.0000	0.0000;
	1201	885	0.015372	0.048926	0.005234	114	114	114	0	0	1	-360	360	10.9181	1.7264	-10.9025	-2.3104	0.0000	0.0000	0.0000	0.0000;
	1866	884	0.00686	0.021901	0.002331	114	114	114	0	0	1	-360	360	-0.6880	-0.1490	0.6880	-0.1324	0.0000	0.0000	0.0000	0.0000;
	1867	885	0.00686	0.021901	0.002335	114	114	114	0	0	1	-360	360	-1.1470	-0.3710	1.1471	0.0892	0.0000	0.0000	0.0000	0.0000;
	1749	1791	0.053058	0.227273	0.025112	114	114	114	0	0	1	-360	360	-9.8439	-2.2738	9.8893	-0.4090	0.0000	0.0000	0.0000	0.0000;
	1078	1790	0.049174	0.21124	0.023334	114	114	114	0	0	1	-360	360	-7.9238	-2.3523	7.9513	-0.2077	0.0000	0.0000	0.0000	0.0000;
	1544	1429	0.034298	0.10595	0.011374	114	114	114	0	0	1	-360	360	36.0314	8.9402	-35.6203	-8.9650	0.0000	0.0000	0.0000	0.0000;
	1125	1102	0.000496	0.000909	7.7e-05	90	90	90	0	0	1	-360	360	-3.2498	3.1527	3.2499	-3.1618	0.0000	0.0000	0.0000	0.0000;
	1129	1125	0.004132	0.007107	0.000692	90	90	90	0	0	1	-360	360	-1.1833	3.2802	1.1838	-3.3625	0.0000	0.0000	0.0000	0.0000;
	1858	1129	0.004132	0.006942	0.000721	90	90	90	0	0	1	-360	360	-1.1829	3.1908	1.1833	-3.2767	0.0000	0.0000	0.0000	0.0000;
	1123	1125	0.001157	0.002149	0.000194	90	90	90	0	0	1	-360	360	-2.0660	-0.2330	2.0660	0.2098	0.0000	0.0000	0.0000	0.0000;
	1127	1129	8.3e-05	0.000248	2.9e-05	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0035	0.0000	0.0000	0.0000	0.0000;
	985	855	0.017355	0.050165	0.006278	114	114	114	0	0	1	-360	360	16.5036	0.1854	-16.4644	-0.8279	0.0000	0.0000	0.0000	0.0000;
	1262	1234	0.024546	0.061488	0.006486	76	76	76	0	0	1	-360	360	15.0701	-0.1352	-15.0238	-0.5279	0.0000	0.0000	0.0000	0.0000;
	1365	1135	0.026612	0.041322	0.006396	90	90	90	0	0	1	-360	360	-15.0967	1.0305	15.1492	-1.6975	0.0000	0.0000	0.0000	0.0000;
	1858	1204	0.031653	0.061735	0.011805	120	120	120	0	0	1	-360	360	24.3075	-2.5567	-24.1509	1.4519	0.0000	0.0000	0.0000	0.0000;
	1859	1134	0.045455	0.05686	0.010803	90	90	90	0	0	1	-360	360	22.8188	0.3079	-22.6204	-1.3393	0.0000	0.0000	0.0000	0.0000;
	1242	854	0.002975	0.009504	0.000997	114	114	114	0	0	1	-360	360	2.4031	-0.8273	-2.4030	0.7081	0.0000	0.0000	0.0000	0.0000;
	1510	1262	0.013471	0.043306	0.004559	114	114	114	0	0	1	-360	360	-1.2102	-10.5462	1.2223	10.0377	0.0000	0.0000	0.0000	0.0000;
	903	1234	0.008926	0.024793	0.002756	140	140	140	0	0	1	-360	360	2.7597	2.5626	-2.7586	-2.8897	0.0000	0.0000	0.0000	0.0000;
	1279	1205	0.020413	0.039752	0.007577	120	120	120	0	0	1	-360	360	-20.5142	1.4431	20.5876	-2.1980	0.0000	0.0000	0.0000	0.0000;
	1610	1130	8.3e-05	0.000826	7e-06	90	90	90	0	0	1	-360	360	13.1111	4.0804	-13.1110	-4.0800	0.0000	0.0000	0.0000	0.0000;
	1859	1610	0.006529	0.010992	0.001128	90	90	90	0	0	1	-360	360	16.2258	4.7793	-16.2101	-4.8876	0.0000	0.0000	0.0000	0.0000;
	1610	1609	0.000165	0.000248	2.4e-05	90	90	90	0	0	1	-360	360	3.0990	0.8071	-3.0990	-0.8100	0.0000	0.0000	0.0000	0.0000;
	1128	1131	0.002562	0.00438	0.000443	90	90	90	0	0	1	-360	360	9.6551	1.9724	-9.6530	-2.0220	0.0000	0.0000	0.0000	0.0000;
	1858	1128	0.00405	0.006777	0.000707	90	90	90	0	0	1	-360	360	12.3015	2.6226	-12.2961	-2.6985	0.0000	0.0000	0.0000	0.0000;
	1126	1128	0.000744	0.002314	0.000276	76	76	76	0	0	1	-360	360	-2.6410	-0.7590	2.6410	0.7260	0.0000	0.0000	0.0000	0.0000;
	1124	855	0.010826	0.021818	0.002998	90	90	90	0	0	1	-360	360	-8.4132	2.5249	8.4203	-2.8708	0.0000	0.0000	0.0000	0.0000;
	1101	1124	0.000413	0.000744	6.8e-05	90	90	90	0	0	1	-360	360	-8.4130	2.4923	8.4132	-2.5000	0.0000	0.0000	0.0000	0.0000;
	1122	1124	0.00124	0.002149	0.000208	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0250	0.0000	0.0000	0.0000	0.0000;
	1919	854	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-2.4110	-0.7800	2.4112	0.6804	0.0000	0.0000	0.0000	0.0000;
	1920	855	0.004545	0.007934	0.000833	90	90	90	0	0	1	-360	360	-8.9560	-0.9840	8.9591	0.8894	0.0000	0.0000	0.0000	0.0000;
	1676	854	0.004132	0.010992	0.001735	114	114	114	0	0	1	-360	360	-23.8147	-1.7613	23.8344	1.6053	0.0000	0.0000	0.0000	0.0000;
	1234	1740	0.006777	0.01124	0.001191	29	29	29	0	0	1	-360	360	4.5982	0.8236	-4.5970	-0.9640	0.0000	0.0000	0.0000	0.0000;
	1235	1741	0.006777	0.01124	0.001191	57	57	57	0	0	1	-360	360	8.6153	1.5358	-8.6110	-1.6710	0.0000	0.0000	0.0000	0.0000;
	1573	1416	0.037025	0.06719	0.006691	90	90	90	0	0	1	-360	360	-3.0612	0.3182	3.0642	-1.1099	0.0000	0.0000	0.0000	0.0000;
	1553	1416	0.014876	0.028099	0.002979	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1870	1417	0.007603	0.011735	0.001496	90	90	90	0	0	1	-360	360	3.0649	-1.0651	-3.0642	0.8878	0.0000	0.0000	0.0000	0.0000;
	1869	1870	0.000992	0.001736	0.000165	90	90	90	0	0	1	-360	360	3.0650	-1.0846	-3.0649	1.0651	0.0000	0.0000	0.0000	0.0000;
	1450	1869	0.006198	0.007769	0.001481	90	90	90	0	0	1	-360	360	3.0655	-1.2605	-3.0650	1.0846	0.0000	0.0000	0.0000	0.0000;
	1553	1870	0.007273	0.014545	0.001549	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1222	1869	0.019008	0.033058	0.003151	90	90	90	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1918	1294	0.019091	0.057769	0.006863	114	114	114	0	0	1	-360	360	-27.6867	4.0854	27.8137	-4.5143	0.0000	0.0000	0.0000	0.0000;
	1858	1133	0.007025	0.015703	0.001757	90	90	90	0	0	1	-360	360	1.5432	5.0211	-1.5416	-5.2282	0.0000	0.0000	0.0000	0.0000;
	1132	854	0.010826	0.032727	0.003884	114	114	114	0	0	1	-360	360	-8.6754	-0.1449	8.6822	-0.3007	0.0000	0.0000	0.0000	0.0000;
	1623	855	0.008595	0.026033	0.00309	114	114	114	0	0	1	-360	360	-20.0291	-2.1173	20.0582	1.8350	0.0000	0.0000	0.0000	0.0000;
	1689	1278	0.028347	0.06595	0.009854	120	120	120	0	0	1	-360	360	-4.5056	0.4725	4.5107	-1.6239	0.0000	0.0000	0.0000	0.0000;
	1917	1689	0.008595	0.026033	0.003095	114	114	114	0	0	1	-360	360	25.9641	-4.3108	-25.9139	4.0974	0.0000	0.0000	0.0000	0.0000;
	1688	1669	0.015703	0.047686	0.005665	114	114	114	0	0	1	-360	360	4.0104	0.6954	-4.0081	-1.3564	0.0000	0.0000	0.0000	0.0000;
	1720	1484	0.014711	0.02595	0.002841	57	57	57	0	0	1	-360	360	12.4091	-3.5196	-12.3884	3.2228	0.0000	0.0000	0.0000	0.0000;
	1879	1263	0.003058	0.00843	0.001447	114	114	114	0	0	1	-360	360	-15.7455	-0.4103	15.7518	0.2533	0.0000	0.0000	0.0000	0.0000;
	1364	1311	0.011901	0.036116	0.004264	114	114	114	0	0	1	-360	360	6.8979	0.2962	-6.8930	-0.7784	0.0000	0.0000	0.0000	0.0000;
	1312	897	0.008843	0.026777	0.003178	114	114	114	0	0	1	-360	360	3.6750	-0.1468	-3.6740	-0.2200	0.0000	0.0000	0.0000	0.0000;
	1719	1003	0.026777	0.063223	0.007267	57	57	57	0	0	1	-360	360	-12.4092	3.4944	12.4478	-4.2570	0.0000	0.0000	0.0000	0.0000;
	1567	1509	0.031983	0.102397	0.010846	114	114	114	0	0	1	-360	360	4.4566	-11.0239	-4.4219	9.8485	0.0000	0.0000	0.0000	0.0000;
	1263	1212	0.036116	0.11595	0.012221	114	114	114	0	0	1	-360	360	0.3663	-1.0726	-0.3662	-0.4002	0.0000	0.0000	0.0000	0.0000;
	1858	1636	0.023636	0.076942	0.007921	114	114	114	0	0	1	-360	360	5.5263	1.3751	-5.5196	-2.3025	0.0000	0.0000	0.0000	0.0000;
	1878	1243	0.02281	0.041818	0.008523	120	120	120	0	0	1	-360	360	7.3614	-0.8943	-7.3511	-0.1117	0.0000	0.0000	0.0000	0.0000;
	950	1235	0	0.000826	7e-06	120	120	120	0	0	1	-360	360	2.0616	3.2451	-2.0616	-3.2458	0.0000	0.0000	0.0000	0.0000;
	1858	950	0.009504	0.03	0.003308	120	120	120	0	0	1	-360	360	6.4349	4.0642	-6.4302	-4.4460	0.0000	0.0000	0.0000	0.0000;
	949	950	0.009504	0.032231	0.003073	140	140	140	0	0	1	-360	360	-4.3670	-1.5630	4.3687	1.2009	0.0000	0.0000	0.0000	0.0000;
	1858	902	0.004298	0.013471	0.001493	114	114	114	0	0	1	-360	360	8.7412	4.1096	-8.7378	-4.2782	0.0000	0.0000	0.0000	0.0000;
	1265	1859	0.040579	0.104959	0.011437	120	120	120	0	0	1	-360	360	-10.4244	-2.7796	10.4633	1.5205	0.0000	0.0000	0.0000	0.0000;
	1859	1574	0.017521	0.031983	0.00311	90	90	90	0	0	1	-360	360	6.1571	3.1657	-6.1499	-3.5235	0.0000	0.0000	0.0000	0.0000;
	1639	1624	0.003141	0.009504	0.001125	114	114	114	0	0	1	-360	360	-13.0084	-0.1255	13.0129	0.0043	0.0000	0.0000	0.0000	0.0000;
	1637	1639	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	-13.0084	-0.1266	13.0084	0.1266	0.0000	0.0000	0.0000	0.0000;
	1638	1639	0	0.000826	1e-05	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0012	0.0000	0.0000	0.0000	0.0000;
	1235	1675	0.005537	0.013967	0.002464	114	114	114	0	0	1	-360	360	-13.0066	-0.0040	13.0145	-0.2714	0.0000	0.0000	0.0000	0.0000;
	1449	1553	0.002149	0.006033	0.000632	90	90	90	0	0	1	-360	360	-3.8686	1.1984	3.8689	-1.2729	0.0000	0.0000	0.0000	0.0000;
	957	854	0.005455	0.017521	0.001847	114	114	114	0	0	1	-360	360	-3.4420	0.0000	3.4425	-0.2200	0.0000	0.0000	0.0000	0.0000;
	958	855	0.004959	0.017521	0.001847	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.2218	0.0000	0.0000	0.0000	0.0000;
	1248	933	0.019008	0.060413	0.006548	114	114	114	0	0	1	-360	360	-8.1501	-0.0732	8.1609	-0.6573	0.0000	0.0000	0.0000	0.0000;
	1902	932	0.005041	0.015289	0.001815	114	114	114	0	0	1	-360	360	21.1453	-0.2990	-21.1261	0.1449	0.0000	0.0000	0.0000	0.0000;
	1249	851	0.014215	0.025041	0.002563	90	90	90	0	0	1	-360	360	0.4749	3.2014	-0.4735	-3.4977	0.0000	0.0000	0.0000	0.0000;
	934	1695	0.02157	0.068265	0.007163	114	114	114	0	0	1	-360	360	3.3625	5.3404	-3.3542	-6.1377	0.0000	0.0000	0.0000	0.0000;
	1285	1221	0.015454	0.052066	0.004997	114	114	114	0	0	1	-360	360	-16.8284	-1.3524	16.8658	0.8879	0.0000	0.0000	0.0000	0.0000;
	1819	1285	0.012645	0.030248	0.004257	114	114	114	0	0	1	-360	360	-47.7400	-5.9300	47.9915	6.0336	0.0000	0.0000	0.0000	0.0000;
	1047	935	0.002727	0.007438	0.000806	114	114	114	0	0	1	-360	360	19.0061	9.2512	-18.9956	-9.3156	0.0000	0.0000	0.0000	0.0000;
	1662	1024	0.025372	0.042231	0.00635	90	90	90	0	0	1	-360	360	-17.6391	-4.2145	17.7112	3.6025	0.0000	0.0000	0.0000	0.0000;
	1871	1428	0.001488	0.004793	0.000494	114	114	114	0	0	1	-360	360	-38.9954	-15.5897	39.0189	15.6105	0.0000	0.0000	0.0000	0.0000;
	1812	1871	0.013223	0.031322	0.003403	90	90	90	0	0	1	-360	360	26.5424	11.2898	-26.4444	-11.4389	0.0000	0.0000	0.0000	0.0000;
	1695	1811	0.008182	0.025041	0.002943	114	114	114	0	0	1	-360	360	49.1669	17.6322	-48.9715	-17.3688	0.0000	0.0000	0.0000	0.0000;
	1926	1725	0.009008	0.015041	0.001619	90	90	90	0	0	1	-360	360	31.6392	7.7928	-31.5564	-7.8411	0.0000	0.0000	0.0000	0.0000;
	1408	1314	0.003306	0.007934	0.000903	120	120	120	0	0	1	-360	360	-54.4804	-3.1131	54.5632	3.2045	0.0000	0.0000	0.0000	0.0000;
	1426	846	0.004711	0.014215	0.001689	114	114	114	0	0	1	-360	360	-21.6815	2.4715	21.7009	-2.6087	0.0000	0.0000	0.0000	0.0000;
	1048	1410	0.002975	0.007025	0.000992	114	114	114	0	0	1	-360	360	-34.1527	-12.2284	34.1865	12.1932	0.0000	0.0000	0.0000	0.0000;
	1715	1286	0.015868	0.042645	0.004371	114	114	114	0	0	1	-360	360	12.5958	-5.9891	-12.5698	5.5489	0.0000	0.0000	0.0000	0.0000;
	1747	1694	0.026116	0.033802	0.0062	90	90	90	0	0	1	-360	360	13.8951	1.8538	-13.8503	-2.5086	0.0000	0.0000	0.0000	0.0000;
	1820	847	0.004132	0.012479	0.001484	114	114	114	0	0	1	-360	360	29.7761	-0.0354	-29.7445	-0.0416	0.0000	0.0000	0.0000	0.0000;
	1025	1286	0.008595	0.026529	0.003035	114	114	114	0	0	1	-360	360	-31.7004	-6.6057	31.7780	6.4922	0.0000	0.0000	0.0000	0.0000;
	1496	1695	0.00281	0.009008	0.000975	114	114	114	0	0	1	-360	360	10.9923	2.2593	-10.9892	-2.3611	0.0000	0.0000	0.0000	0.0000;
	1220	1569	0.010331	0.032314	0.003596	114	114	114	0	0	1	-360	360	-17.8990	-0.9390	17.9270	0.6000	0.0000	0.0000	0.0000	0.0000;
	1887	1014	0.020579	0.051488	0.006086	114	114	114	0	0	1	-360	360	-5.0393	-1.1290	5.0438	0.4189	0.0000	0.0000	0.0000	0.0000;
	1240	1014	0.004628	0.008347	0.001747	114	114	114	0	0	1	-360	360	-35.6585	-2.0815	35.7084	1.9644	0.0000	0.0000	0.0000	0.0000;
	1814	1570	0.019174	0.06157	0.00651	114	114	114	0	0	1	-360	360	-26.5896	-3.7977	26.7070	3.4059	0.0000	0.0000	0.0000	0.0000;
	853	1814	0.018017	0.023884	0.004291	90	90	90	0	0	1	-360	360	-20.7731	-2.2395	20.8404	1.8270	0.0000	0.0000	0.0000	0.0000;
	1813	1814	0.006694	0.008347	0.001585	29	29	29	0	0	1	-360	360	-5.7470	-2.1540	5.7491	1.9707	0.0000	0.0000	0.0000	0.0000;
	1884	1225	0.017025	0.051984	0.00611	114	114	114	0	0	1	-360	360	-10.9095	-3.4940	10.9283	2.8360	0.0000	0.0000	0.0000	0.0000;
	1753	1884	0.040909	0.053884	0.009864	90	90	90	0	0	1	-360	360	-24.4325	-4.9074	24.6530	4.0589	0.0000	0.0000	0.0000	0.0000;
	1606	1285	0.006612	0.020661	0.002331	114	114	114	0	0	1	-360	360	36.1086	-0.4544	-36.0356	0.4072	0.0000	0.0000	0.0000	0.0000;
	1926	1285	0.025124	0.076198	0.009039	114	114	114	0	0	1	-360	360	-23.5722	-6.6318	23.7011	5.9677	0.0000	0.0000	0.0000	0.0000;
	1841	1812	0.01438	0.046198	0.004867	114	114	114	0	0	1	-360	360	-6.9030	-2.2790	6.9096	1.7522	0.0000	0.0000	0.0000	0.0000;
	1607	1927	0.02876	0.090165	0.010016	114	114	114	0	0	1	-360	360	0.0779	-1.9630	-0.0774	0.8238	0.0000	0.0000	0.0000	0.0000;
	1285	1027	0.002645	0.008017	0.000949	114	114	114	0	0	1	-360	360	0.0000	-0.1117	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1663	1927	0.019587	0.03124	0.005114	90	90	90	0	0	1	-360	360	11.5519	2.7481	-11.5276	-3.2938	0.0000	0.0000	0.0000	0.0000;
	1249	1716	0.003719	0.009835	0.00098	114	114	114	0	0	1	-360	360	14.4406	-5.6529	-14.4330	5.5588	0.0000	0.0000	0.0000	0.0000;
	1885	1569	0.024215	0.076859	0.008327	114	114	114	0	0	1	-360	360	-27.4368	-5.3253	27.5978	4.8556	0.0000	0.0000	0.0000	0.0000;
	1015	1569	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	33.6834	4.9591	-33.6088	-5.0285	0.0000	0.0000	0.0000	0.0000;
	1014	1570	0.007686	0.024711	0.002594	114	114	114	0	0	1	-360	360	-7.2937	-1.1864	7.2973	0.8897	0.0000	0.0000	0.0000	0.0000;
	1248	1569	0.019256	0.061983	0.006515	114	114	114	0	0	1	-360	360	-35.9586	-6.2458	36.1777	6.1838	0.0000	0.0000	0.0000	0.0000;
	1428	1118	0.002975	0.013058	0.002154	114	114	114	0	0	1	-360	360	-35.5916	-16.7352	35.6327	16.6744	0.0000	0.0000	0.0000	0.0000;
	1026	1427	0.00405	0.011653	0.00129	114	114	114	0	0	1	-360	360	-9.0341	5.9805	9.0383	-6.1181	0.0000	0.0000	0.0000	0.0000;
	1831	1726	0.020331	0.065372	0.006902	114	114	114	0	0	1	-360	360	-15.8692	-3.5542	15.9160	2.9160	0.0000	0.0000	0.0000	0.0000;
	1409	1605	0.005124	0.015868	0.00181	114	114	114	0	0	1	-360	360	49.3157	1.7592	-49.2106	-1.6484	0.0000	0.0000	0.0000	0.0000;
	1830	1608	0.01562	0.050248	0.005283	114	114	114	0	0	1	-360	360	2.8392	-1.3458	-2.8379	0.7489	0.0000	0.0000	0.0000	0.0000;
	1241	1903	0.017355	0.024711	0.004378	90	90	90	0	0	1	-360	360	30.7217	0.9637	-30.5830	-1.2816	0.0000	0.0000	0.0000	0.0000;
	1411	1286	0.002893	0.009256	0.000997	114	114	114	0	0	1	-360	360	-54.1802	-18.6358	54.2619	18.7812	0.0000	0.0000	0.0000	0.0000;
	1694	1285	0.021984	0.070909	0.007446	114	114	114	0	0	1	-360	360	-36.9697	-11.3135	37.2548	11.3681	0.0000	0.0000	0.0000	0.0000;
	1752	879	0.016364	0.02157	0.003969	90	90	90	0	0	1	-360	360	15.8053	1.6756	-15.7690	-2.0799	0.0000	0.0000	0.0000	0.0000;
	1015	1383	0.008843	0.028017	0.00303	114	114	114	0	0	1	-360	360	-10.4920	-1.7346	10.5003	1.3982	0.0000	0.0000	0.0000	0.0000;
	1384	969	0.004793	0.014959	0.001658	114	114	114	0	0	1	-360	360	-12.9114	-2.1391	12.9183	1.9615	0.0000	0.0000	0.0000	0.0000;
	1286	989	0.017934	0.044876	0.005385	114	114	114	0	0	1	-360	360	-5.9030	-0.8061	5.9084	0.1900	0.0000	0.0000	0.0000	0.0000;
	944	1006	0.013471	0.042645	0.004646	140	140	140	0	0	1	-360	360	-24.2679	-3.4913	24.3347	3.1402	0.0000	0.0000	0.0000	0.0000;
	967	944	8.3e-05	0.000248	2.4e-05	114	114	114	0	0	1	-360	360	-18.5293	-2.5770	18.5296	2.5748	0.0000	0.0000	0.0000	0.0000;
	942	944	0.004628	0.014132	0.00167	114	114	114	0	0	1	-360	360	-5.7370	-1.1140	5.7383	0.9165	0.0000	0.0000	0.0000	0.0000;
	1640	1335	0.040248	0.070579	0.006735	90	90	90	0	0	1	-360	360	24.8835	-0.9581	-24.6741	0.5296	0.0000	0.0000	0.0000	0.0000;
	952	1640	0.019669	0.040579	0.003599	90	90	90	0	0	1	-360	360	-59.1457	-9.5079	59.7539	10.3396	0.0000	0.0000	0.0000	0.0000;
	1539	952	0.006942	0.018678	0.001767	90	90	90	0	0	1	-360	360	-54.3605	-8.3378	54.5432	8.6255	0.0000	0.0000	0.0000	0.0000;
	1594	1539	0.000661	0.001157	0.000169	90	90	90	0	0	1	-360	360	-39.6180	-3.6293	39.6272	3.6258	0.0000	0.0000	0.0000	0.0000;
	951	952	0.002727	0.003636	0.000322	75	75	75	0	0	1	-360	360	-4.6020	-0.9190	4.6025	0.8824	0.0000	0.0000	0.0000	0.0000;
	1537	1539	0.000165	0.000496	4.4e-05	140	140	140	0	0	1	-360	360	-14.7330	-4.7160	14.7333	4.7120	0.0000	0.0000	0.0000	0.0000;
	1482	1067	0.002149	0.006612	0.000779	114	114	114	0	0	1	-360	360	24.9076	5.5684	-24.8957	-5.6237	0.0000	0.0000	0.0000	0.0000;
	1756	1363	0.012562	0.045041	0.004371	114	114	114	0	0	1	-360	360	-37.4323	-15.0891	37.6042	15.1823	0.0000	0.0000	0.0000	0.0000;
	1868	921	0.01	0.025124	0.002819	120	120	120	0	0	1	-360	360	6.6616	6.2835	-6.6543	-6.5979	0.0000	0.0000	0.0000	0.0000;
	1891	1868	0.005868	0.020909	0.002072	140	140	140	0	0	1	-360	360	18.8678	9.0341	-18.8461	-9.2023	0.0000	0.0000	0.0000	0.0000;
	1912	1868	8.3e-05	0.000331	3.6e-05	140	140	140	0	0	1	-360	360	-12.1845	-2.9226	12.1846	2.9188	0.0000	0.0000	0.0000	0.0000;
	865	1912	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-10.3470	-2.5970	10.3473	2.5836	0.0000	0.0000	0.0000	0.0000;
	1910	1912	0.004463	0.013636	0.001619	140	140	140	0	0	1	-360	360	-1.8370	-0.5300	1.8371	0.3390	0.0000	0.0000	0.0000	0.0000;
	856	1115	0.013967	0.043388	0.004898	140	140	140	0	0	1	-360	360	-6.2051	-3.8474	6.2110	3.2768	0.0000	0.0000	0.0000	0.0000;
	1587	1287	0.02281	0.063967	0.009043	140	140	140	0	0	1	-360	360	-71.8445	-8.1160	72.8328	9.7784	0.0000	0.0000	0.0000	0.0000;
	1433	1545	0.006694	0.017273	0.002389	120	120	120	0	0	1	-360	360	28.9603	7.1291	-28.9096	-7.2790	0.0000	0.0000	0.0000	0.0000;
	1433	1194	0.004545	0.013967	0.001283	120	120	120	0	0	1	-360	360	18.0288	2.1081	-18.0160	-2.2199	0.0000	0.0000	0.0000	0.0000;
	1195	921	0.005702	0.01719	0.002118	140	140	140	0	0	1	-360	360	-1.6040	-5.0602	1.6053	4.8149	0.0000	0.0000	0.0000	0.0000;
	1850	1432	0.013636	0.033967	0.003707	120	120	120	0	0	1	-360	360	5.2742	-0.0958	-5.2710	-0.3348	0.0000	0.0000	0.0000	0.0000;
	1200	1432	0.017851	0.04405	0.004825	120	120	120	0	0	1	-360	360	10.4979	0.6443	-10.4812	-1.1748	0.0000	0.0000	0.0000	0.0000;
	1585	1200	0.004876	0.013471	0.001566	120	120	120	0	0	1	-360	360	11.1911	0.5555	-11.1859	-0.7272	0.0000	0.0000	0.0000	0.0000;
	1200	1198	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	0.6880	0.0829	-0.6880	-0.1110	0.0000	0.0000	0.0000	0.0000;
	1433	1186	0.016694	0.045207	0.005467	120	120	120	0	0	1	-360	360	-46.9890	-9.2371	47.3131	9.4641	0.0000	0.0000	0.0000	0.0000;
	1515	1170	0.000826	0.002479	0.000269	114	114	114	0	0	1	-360	360	-88.2136	-19.2334	88.2689	19.3664	0.0000	0.0000	0.0000	0.0000;
	1099	1515	0.002149	0.003884	0.000779	120	120	120	0	0	1	-360	360	-74.3078	-17.0979	74.4106	17.1889	0.0000	0.0000	0.0000	0.0000;
	1185	1099	0.00595	0.010661	0.002222	120	120	120	0	0	1	-360	360	-70.2645	-16.1739	70.5215	16.3658	0.0000	0.0000	0.0000	0.0000;
	1515	1513	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	13.8030	2.0444	-13.8030	-2.0440	0.0000	0.0000	0.0000	0.0000;
	1099	1097	0.002397	0.004876	0.000704	90	90	90	0	0	1	-360	360	3.7863	0.7321	-3.7860	-0.8170	0.0000	0.0000	0.0000	0.0000;
	1406	1630	0.008926	0.02876	0.003025	114	114	114	0	0	1	-360	360	-17.9052	-4.8312	17.9313	4.5604	0.0000	0.0000	0.0000	0.0000;
	1451	1406	0.004959	0.015868	0.001675	140	140	140	0	0	1	-360	360	-14.2196	-4.4097	14.2289	4.2440	0.0000	0.0000	0.0000	0.0000;
	1404	1406	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-3.6760	-0.6340	3.6763	0.5872	0.0000	0.0000	0.0000	0.0000;
	1083	1629	0.000826	0.002562	0.000266	114	114	114	0	0	1	-360	360	-23.8874	-5.4173	23.8916	5.3990	0.0000	0.0000	0.0000	0.0000;
	868	1083	0.007934	0.025537	0.002684	140	140	140	0	0	1	-360	360	-18.0115	-5.2932	18.0353	5.0549	0.0000	0.0000	0.0000	0.0000;
	1081	1083	0.000248	0.000661	7.5e-05	114	114	114	0	0	1	-360	360	-5.8520	-0.3710	5.8521	0.3624	0.0000	0.0000	0.0000	0.0000;
	1415	1630	0.008017	0.02438	0.002553	120	120	120	0	0	1	-360	360	3.5087	-9.3668	-3.5020	9.0873	0.0000	0.0000	0.0000	0.0000;
	1414	1629	0.008099	0.025372	0.002633	120	120	120	0	0	1	-360	360	-4.6174	-7.3809	4.6225	7.0877	0.0000	0.0000	0.0000	0.0000;
	1631	1761	0.014463	0.043967	0.005193	114	114	114	0	0	1	-360	360	14.3077	2.4477	-14.2817	-2.9813	0.0000	0.0000	0.0000	0.0000;
	1670	1718	0.010083	0.031901	0.003453	114	114	114	0	0	1	-360	360	40.3215	2.4918	-40.1840	-2.4689	0.0000	0.0000	0.0000	0.0000;
	1190	1232	0.003719	0.011901	0.001251	140	140	140	0	0	1	-360	360	-7.4770	-1.4010	7.4788	1.2571	0.0000	0.0000	0.0000	0.0000;
	1378	1477	0.002231	0.006612	0.000789	114	114	114	0	0	1	-360	360	27.8952	7.6390	-27.8799	-7.6899	0.0000	0.0000	0.0000	0.0000;
	1809	1794	0.009587	0.030744	0.003233	114	114	114	0	0	1	-360	360	-18.1020	-5.9840	18.1305	5.6811	0.0000	0.0000	0.0000	0.0000;
	1436	1619	0.000992	0.003058	0.000346	114	114	114	0	0	1	-360	360	-77.6878	-17.5514	77.7401	17.6706	0.0000	0.0000	0.0000	0.0000;
	1641	1436	0.005785	0.01843	0.001951	114	114	114	0	0	1	-360	360	-60.4448	-11.8341	60.6286	12.1858	0.0000	0.0000	0.0000	0.0000;
	1434	1436	0.000826	0.002397	0.000281	114	114	114	0	0	1	-360	360	-17.0570	-5.3930	17.0592	5.3656	0.0000	0.0000	0.0000	0.0000;
	1836	1640	0.011901	0.036446	0.004262	114	114	114	0	0	1	-360	360	95.3158	15.4541	-94.4084	-13.1895	0.0000	0.0000	0.0000	0.0000;
	1143	947	0.004215	0.013306	0.001433	114	114	114	0	0	1	-360	360	-13.5114	-3.1330	13.5183	2.9876	0.0000	0.0000	0.0000	0.0000;
	1736	1283	0.005207	0.01595	0.001873	140	140	140	0	0	1	-360	360	-15.5570	2.5673	15.5681	-2.7518	0.0000	0.0000	0.0000	0.0000;
	1876	1475	0.004793	0.014628	0.001774	114	114	114	0	0	1	-360	360	-33.3186	-7.9796	33.3662	7.9155	0.0000	0.0000	0.0000	0.0000;
	995	1876	0.001901	0.006116	0.000646	114	114	114	0	0	1	-360	360	-30.4259	-6.4004	30.4416	6.3746	0.0000	0.0000	0.0000	0.0000;
	1874	1876	8.3e-05	0.000165	1.7e-05	114	114	114	0	0	1	-360	360	-2.8770	-1.6070	2.8770	1.6050	0.0000	0.0000	0.0000	0.0000;
	995	1612	0.001405	0.004132	0.000426	114	114	114	0	0	1	-360	360	23.6519	4.1344	-23.6451	-4.1643	0.0000	0.0000	0.0000	0.0000;
	1435	1619	0.001488	0.004628	0.000549	114	114	114	0	0	1	-360	360	6.3380	2.2740	-6.3374	-2.3386	0.0000	0.0000	0.0000	0.0000;
	940	1369	0.006777	0.021984	0.002297	114	114	114	0	0	1	-360	360	-6.7712	-5.1614	6.7752	4.9021	0.0000	0.0000	0.0000	0.0000;
	1084	1418	0.008099	0.020661	0.002323	120	120	120	0	0	1	-360	360	4.3206	5.6049	-4.3170	-5.8686	0.0000	0.0000	0.0000	0.0000;
	1630	1084	0.000496	0.001488	0.000162	114	114	114	0	0	1	-360	360	4.3208	5.5466	-4.3206	-5.5650	0.0000	0.0000	0.0000	0.0000;
	1084	1082	0.000909	0.002893	0.000339	57	57	57	0	0	1	-360	360	0.0000	-0.0398	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1136	975	0.001736	0.005289	0.000617	57	57	57	0	0	1	-360	360	-2.6390	-0.6690	2.6391	0.5963	0.0000	0.0000	0.0000	0.0000;
	1837	1323	0.012975	0.041074	0.004484	140	140	140	0	0	1	-360	360	25.8963	2.3825	-25.8238	-2.6944	0.0000	0.0000	0.0000	0.0000;
	1565	1737	0.003802	0.012149	0.001275	114	114	114	0	0	1	-360	360	-0.1559	0.6911	0.1559	-0.8398	0.0000	0.0000	0.0000	0.0000;
	1407	1565	0.006694	0.021653	0.002268	140	140	140	0	0	1	-360	360	7.8938	2.5231	-7.8898	-2.7750	0.0000	0.0000	0.0000	0.0000;
	869	1407	0.004463	0.014463	0.001517	114	114	114	0	0	1	-360	360	9.2744	2.6040	-9.2708	-2.7699	0.0000	0.0000	0.0000	0.0000;
	1565	1563	0.001157	0.002562	0.000254	90	90	90	0	0	1	-360	360	8.0457	2.0839	-8.0450	-2.1120	0.0000	0.0000	0.0000	0.0000;
	1405	1407	0.002314	0.003802	0.000404	90	90	90	0	0	1	-360	360	-1.3770	-0.2940	1.3770	0.2468	0.0000	0.0000	0.0000	0.0000;
	1736	1145	0.004463	0.014297	0.001515	114	114	114	0	0	1	-360	360	-2.0857	-2.7567	2.0862	2.5814	0.0000	0.0000	0.0000	0.0000;
	1232	1827	0.003306	0.010744	0.001101	140	140	140	0	0	1	-360	360	3.6774	1.1826	-3.6770	-1.3130	0.0000	0.0000	0.0000	0.0000;
	1232	1034	0.001405	0.004463	0.000469	114	114	114	0	0	1	-360	360	0.0000	-0.0562	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1478	1005	0.002397	0.007273	0.000857	140	140	140	0	0	1	-360	360	27.8794	7.6842	-27.8629	-7.7386	0.0000	0.0000	0.0000	0.0000;
	1837	1471	0.003802	0.01157	0.00137	140	140	140	0	0	1	-360	360	17.2682	0.5571	-17.2589	-0.6945	0.0000	0.0000	0.0000	0.0000;
	1620	1838	0.018347	0.056777	0.006459	114	114	114	0	0	1	-360	360	-38.7077	-10.2341	38.9501	10.1960	0.0000	0.0000	0.0000	0.0000;
	1100	980	0.000992	0.002893	0.000349	140	140	140	0	0	1	-360	360	43.1127	13.7474	-43.0961	-13.7415	0.0000	0.0000	0.0000	0.0000;
	1516	1100	0.001488	0.004463	0.00053	140	140	140	0	0	1	-360	360	43.1376	13.7005	-43.1127	-13.6908	0.0000	0.0000	0.0000	0.0000;
	1838	1516	0.004298	0.013388	0.001474	140	140	140	0	0	1	-360	360	43.2093	13.7419	-43.1376	-13.6996	0.0000	0.0000	0.0000	0.0000;
	1100	1098	0.001322	0.003884	0.000462	140	140	140	0	0	1	-360	360	0.0000	-0.0565	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1514	1516	0	0.000826	7e-06	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0009	0.0000	0.0000	0.0000	0.0000;
	1196	920	0.002727	0.008347	0.000973	140	140	140	0	0	1	-360	360	-7.5476	-4.2521	7.5494	4.1433	0.0000	0.0000	0.0000	0.0000;
	1909	1196	0.002231	0.007603	0.000728	140	140	140	0	0	1	-360	360	-7.5462	-4.3325	7.5476	4.2521	0.0000	0.0000	0.0000	0.0000;
	1906	1909	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	-7.5462	-4.3355	7.5462	4.3336	0.0000	0.0000	0.0000	0.0000;
	1194	1196	0.003141	0.009669	0.001125	140	140	140	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1908	1909	0	0.000826	1e-05	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0011	0.0000	0.0000	0.0000	0.0000;
	1252	1114	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	-16.3878	-0.2553	16.3902	0.2173	0.0000	0.0000	0.0000	0.0000;
	1834	1252	0.004545	0.013884	0.001614	140	140	140	0	0	1	-360	360	-14.0851	0.0648	14.0927	-0.2317	0.0000	0.0000	0.0000	0.0000;
	1252	1250	0.001157	0.001488	0.000281	90	90	90	0	0	1	-360	360	2.2951	0.4870	-2.2950	-0.5200	0.0000	0.0000	0.0000	0.0000;
	924	1114	0.001074	0.003388	0.000387	140	140	140	0	0	1	-360	360	-31.9969	-4.4602	32.0064	4.4446	0.0000	0.0000	0.0000	0.0000;
	1883	924	0.003884	0.011901	0.001375	114	114	114	0	0	1	-360	360	-28.1811	-3.7526	28.2078	3.6725	0.0000	0.0000	0.0000	0.0000;
	922	924	0.000661	0.001901	0.000225	114	114	114	0	0	1	-360	360	-3.7890	-0.8140	3.7891	0.7877	0.0000	0.0000	0.0000	0.0000;
	1271	1114	0.009339	0.025289	0.002592	120	120	120	0	0	1	-360	360	-8.1956	-3.5364	8.2018	3.2479	0.0000	0.0000	0.0000	0.0000;
	1717	1271	0.005702	0.014545	0.001534	120	120	120	0	0	1	-360	360	4.6646	-1.4376	-4.6635	1.2599	0.0000	0.0000	0.0000	0.0000;
	1271	1268	0.005537	0.009339	0.00097	90	90	90	0	0	1	-360	360	12.8590	2.2765	-12.8510	-2.3770	0.0000	0.0000	0.0000	0.0000;
	1318	1114	0.015041	0.039669	0.004104	120	120	120	0	0	1	-360	360	27.6853	-0.1788	-27.5883	-0.0513	0.0000	0.0000	0.0000	0.0000;
	1718	1318	8.3e-05	0.000248	1.9e-05	140	140	140	0	0	1	-360	360	32.1611	1.0038	-32.1603	-1.0040	0.0000	0.0000	0.0000	0.0000;
	1317	1318	0.000165	0.000413	5.3e-05	140	140	140	0	0	1	-360	360	-4.4750	-1.1890	4.4750	1.1828	0.0000	0.0000	0.0000	0.0000;
	1362	1288	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-15.1589	-5.9059	15.1600	5.8881	0.0000	0.0000	0.0000	0.0000;
	1362	1288	0.000496	0.001488	0.000177	140	140	140	0	0	1	-360	360	-15.1589	-5.9059	15.1600	5.8881	0.0000	0.0000	0.0000	0.0000;
	1140	1113	0.012479	0.038265	0.004414	114	114	114	0	0	1	-360	360	-18.2552	-1.7173	18.2903	1.2971	0.0000	0.0000	0.0000	0.0000;
	1362	1140	0.000909	0.003388	0.00039	114	114	114	0	0	1	-360	360	-18.2526	-1.7695	18.2552	1.7326	0.0000	0.0000	0.0000	0.0000;
	1138	1140	0.000413	0.001322	0.000128	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0153	0.0000	0.0000	0.0000	0.0000;
	1652	1115	0.00876	0.026942	0.003112	114	114	114	0	0	1	-360	360	-7.7106	3.3596	7.7158	-3.7187	0.0000	0.0000	0.0000	0.0000;
	1141	1652	0.003802	0.012066	0.001396	140	140	140	0	0	1	-360	360	-6.7907	3.4034	6.7926	-3.5660	0.0000	0.0000	0.0000	0.0000;
	1363	1141	0.000826	0.002562	0.000293	114	114	114	0	0	1	-360	360	56.8179	24.7256	-56.7917	-24.6795	0.0000	0.0000	0.0000	0.0000;
	1651	1652	0.002066	0.006364	0.000753	140	140	140	0	0	1	-360	360	-0.9180	-0.2970	0.9180	0.2063	0.0000	0.0000	0.0000	0.0000;
	1137	1141	0.000413	0.001322	0.00016	114	114	114	0	0	1	-360	360	-63.5670	-21.2460	63.5824	21.2760	0.0000	0.0000	0.0000	0.0000;
	1033	1873	0.001488	0.004876	0.000511	84	84	84	0	0	1	-360	360	0.4127	2.8791	-0.4125	-2.9386	0.0000	0.0000	0.0000	0.0000;
	1419	1033	0.004959	0.013223	0.0015	120	120	120	0	0	1	-360	360	0.4130	2.6746	-0.4127	-2.8496	0.0000	0.0000	0.0000	0.0000;
	1032	1033	0.000661	0.002149	0.000252	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0295	0.0000	0.0000	0.0000	0.0000;
	1151	1525	0.011983	0.037107	0.004211	140	140	140	0	0	1	-360	360	-15.9719	-3.4521	15.9985	3.0303	0.0000	0.0000	0.0000	0.0000;
	1381	975	0.004545	0.013967	0.001619	140	140	140	0	0	1	-360	360	-1.9150	1.5656	1.9152	-1.7566	0.0000	0.0000	0.0000	0.0000;
	1809	1795	0.004215	0.009752	0.002043	140	140	140	0	0	1	-360	360	-53.2182	-11.6531	53.3209	11.6419	0.0000	0.0000	0.0000	0.0000;
	1611	928	0.005702	0.015041	0.001646	120	120	120	0	0	1	-360	360	18.9407	2.3772	-18.9230	-2.5237	0.0000	0.0000	0.0000	0.0000;
	1340	928	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	-6.1960	-1.4110	6.1965	1.3841	0.0000	0.0000	0.0000	0.0000;
	1341	929	0.001322	0.002645	0.000237	57	57	57	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0283	0.0000	0.0000	0.0000	0.0000;
	1839	1655	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	2.1801	0.6874	-2.1800	-0.7800	0.0000	0.0000	0.0000	0.0000;
	1840	1656	0.002893	0.007025	0.000779	120	120	120	0	0	1	-360	360	5.7419	1.8783	-5.7410	-1.9690	0.0000	0.0000	0.0000	0.0000;
	1622	1113	0.003719	0.009008	0.000999	120	120	120	0	0	1	-360	360	-22.0020	-4.9656	22.0178	4.8842	0.0000	0.0000	0.0000	0.0000;
	1840	1622	0.004628	0.01438	0.001626	140	140	140	0	0	1	-360	360	-21.9823	-5.2526	22.0020	5.1198	0.0000	0.0000	0.0000	0.0000;
	1621	1622	0.002645	0.006116	0.00129	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.1543	0.0000	0.0000	0.0000	0.0000;
	1839	1113	0.008347	0.023471	0.002628	120	120	120	0	0	1	-360	360	-22.4048	-5.2200	22.4417	5.0097	0.0000	0.0000	0.0000	0.0000;
	1253	1113	0.00157	0.004793	0.000566	140	140	140	0	0	1	-360	360	-26.2730	-9.6161	26.2833	9.5796	0.0000	0.0000	0.0000	0.0000;
	1470	1253	0.007438	0.022562	0.00266	140	140	140	0	0	1	-360	360	-22.2216	-8.5981	22.2569	8.3879	0.0000	0.0000	0.0000	0.0000;
	1848	1470	0.000992	0.003306	0.000351	140	140	140	0	0	1	-360	360	-15.5490	-7.3559	15.5515	7.3224	0.0000	0.0000	0.0000	0.0000;
	1253	1251	0.000744	0.001405	0.000293	120	120	120	0	0	1	-360	360	4.0161	1.2282	-4.0160	-1.2630	0.0000	0.0000	0.0000	0.0000;
	1468	1470	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-6.6700	-1.2810	6.6701	1.2757	0.0000	0.0000	0.0000	0.0000;
	1296	1113	0.00876	0.026529	0.003124	140	140	140	0	0	1	-360	360	-18.5329	-4.7578	18.5597	4.4652	0.0000	0.0000	0.0000	0.0000;
	1784	1412	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	-0.7166	-3.5666	0.7176	3.2505	0.0000	0.0000	0.0000	0.0000;
	1822	1784	0.011901	0.029669	0.003277	120	120	120	0	0	1	-360	360	3.8796	-3.0498	-3.8772	2.6715	0.0000	0.0000	0.0000	0.0000;
	1782	1784	0.00438	0.006116	0.000777	75	75	75	0	0	1	-360	360	-4.5930	-0.9850	4.5938	0.8951	0.0000	0.0000	0.0000	0.0000;
	1785	1413	0.010083	0.024546	0.002715	120	120	120	0	0	1	-360	360	-7.7658	-2.9993	7.7716	2.6946	0.0000	0.0000	0.0000	0.0000;
	1598	1785	0.008099	0.021074	0.002386	120	120	120	0	0	1	-360	360	-2.5980	-2.2061	2.5988	1.9282	0.0000	0.0000	0.0000	0.0000;
	1783	1785	0.004132	0.005372	0.000692	75	75	75	0	0	1	-360	360	-5.1660	-1.1510	5.1670	1.0711	0.0000	0.0000	0.0000	0.0000;
	1839	1703	0.002397	0.007355	0.000857	140	140	140	0	0	1	-360	360	3.4423	0.8646	-3.4420	-0.9660	0.0000	0.0000	0.0000	0.0000;
	1232	1007	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-0.4625	-3.0991	0.4628	2.9350	0.0000	0.0000	0.0000	0.0000;
	1412	1146	0.003058	0.003802	0.000721	90	90	90	0	0	1	-360	360	0.5740	0.1383	-0.5740	-0.2230	0.0000	0.0000	0.0000	0.0000;
	1413	1147	0.003141	0.003884	0.00074	90	90	90	0	0	1	-360	360	1.4921	0.2100	-1.4920	-0.2970	0.0000	0.0000	0.0000	0.0000;
	1029	1628	0.001074	0.003223	0.000378	140	140	140	0	0	1	-360	360	40.0128	2.5202	-39.9981	-2.5204	0.0000	0.0000	0.0000	0.0000;
	1717	1029	0.001818	0.00562	0.000665	140	140	140	0	0	1	-360	360	40.0377	2.4960	-40.0128	-2.4974	0.0000	0.0000	0.0000	0.0000;
	1029	1028	0.000579	0.001653	0.000194	140	140	140	0	0	1	-360	360	0.0000	-0.0228	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1379	1625	0.003141	0.021405	0.002413	114	114	114	0	0	1	-360	360	-13.0881	-7.5579	13.0942	7.3150	0.0000	0.0000	0.0000	0.0000;
	976	1277	0.004736	0.015008	0.001718	114	114	114	0	0	1	-360	360	70.5995	18.0220	-70.3907	-17.5664	0.0000	0.0000	0.0000	0.0000;
	1839	1369	0.00405	0.012397	0.00143	114	114	114	0	0	1	-360	360	27.9931	7.8914	-27.9643	-7.9735	0.0000	0.0000	0.0000	0.0000;
	888	1414	0.001983	0.006033	0.000697	140	140	140	0	0	1	-360	360	-1.8062	-1.3223	1.8062	1.2408	0.0000	0.0000	0.0000	0.0000;
	1873	888	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	0.7229	-0.6460	-0.7229	0.4408	0.0000	0.0000	0.0000	0.0000;
	888	886	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	2.5291	0.8814	-2.5290	-0.9040	0.0000	0.0000	0.0000	0.0000;
	1239	1415	0.002314	0.007438	0.000811	140	140	140	0	0	1	-360	360	22.8917	-5.9295	-22.8806	5.8699	0.0000	0.0000	0.0000	0.0000;
	1618	1239	0.005702	0.018017	0.001994	140	140	140	0	0	1	-360	360	22.9189	-6.0795	-22.8917	5.9318	0.0000	0.0000	0.0000	0.0000;
	1238	1239	8.3e-05	0.000248	1.9e-05	120	120	120	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0023	0.0000	0.0000	0.0000	0.0000;
	1233	1799	0.001901	0.004628	0.000895	140	140	140	0	0	1	-360	360	4.2523	1.3781	-4.2520	-1.4830	0.0000	0.0000	0.0000	0.0000;
	1800	1232	0.001405	0.004628	0.000489	140	140	140	0	0	1	-360	360	-18.0768	-4.7355	18.0809	4.6905	0.0000	0.0000	0.0000	0.0000;
	929	1800	0.008099	0.022645	0.002439	120	120	120	0	0	1	-360	360	-14.8438	-3.8559	14.8597	3.6092	0.0000	0.0000	0.0000	0.0000;
	1798	1800	0.000496	0.00124	0.000191	140	140	140	0	0	1	-360	360	-3.2170	-1.1490	3.2170	1.1263	0.0000	0.0000	0.0000	0.0000;
	1105	1115	0.007521	0.023058	0.002413	120	120	120	0	0	1	-360	360	-0.0000	0.1161	0.0000	-0.4068	0.0000	0.0000	0.0000	0.0000;
	1269	1105	0.000331	0.001157	0.000116	114	114	114	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0140	0.0000	0.0000	0.0000	0.0000;
	1103	1105	0.002397	0.007521	0.000847	114	114	114	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1021	0.0000	0.0000	0.0000	0.0000;
	1810	1900	0.008099	0.026116	0.002725	140	140	140	0	0	1	-360	360	25.0957	5.4302	-25.0517	-5.6185	0.0000	0.0000	0.0000	0.0000;
	1551	849	0.003636	0.011405	0.001242	140	140	140	0	0	1	-360	360	-35.2594	3.2425	35.2984	-3.2657	0.0000	0.0000	0.0000	0.0000;
	894	1551	0.00157	0.004876	0.000542	140	140	140	0	0	1	-360	360	-34.2105	3.5792	34.2264	-3.5933	0.0000	0.0000	0.0000	0.0000;
	1551	1549	0.002314	0.006942	0.000728	120	120	120	0	0	1	-360	360	1.0330	0.3508	-1.0330	-0.4360	0.0000	0.0000	0.0000	0.0000;
	1776	1019	0.001983	0.005702	0.000617	120	120	120	0	0	1	-360	360	-15.8035	8.3504	15.8089	-8.4070	0.0000	0.0000	0.0000	0.0000;
	889	1777	0.00562	0.017107	0.001919	120	120	120	0	0	1	-360	360	-1.5740	3.2977	1.5747	-3.5202	0.0000	0.0000	0.0000	0.0000;
	1873	889	0.004959	0.015207	0.001752	140	140	140	0	0	1	-360	360	-0.3104	3.5846	0.3110	-3.7880	0.0000	0.0000	0.0000	0.0000;
	889	887	0.001074	0.001818	0.000194	90	90	90	0	0	1	-360	360	1.2630	0.4904	-1.2630	-0.5130	0.0000	0.0000	0.0000	0.0000;
	1233	1770	0.005207	0.016281	0.001805	140	140	140	0	0	1	-360	360	1.4485	3.6817	-1.4478	-3.8923	0.0000	0.0000	0.0000	0.0000;
	1446	1287	0.013388	0.041488	0.004726	140	140	140	0	0	1	-360	360	-40.8763	-7.1044	41.0629	7.0964	0.0000	0.0000	0.0000	0.0000;
	1796	1446	0.007603	0.02405	0.002618	140	140	140	0	0	1	-360	360	-36.0788	-4.9591	36.1611	4.8978	0.0000	0.0000	0.0000	0.0000;
	1446	1444	0.001074	0.010992	0.001752	75	75	75	0	0	1	-360	360	4.7152	2.2066	-4.7150	-2.4200	0.0000	0.0000	0.0000	0.0000;
	1445	1050	0.00876	0.027851	0.00303	140	140	140	0	0	1	-360	360	44.9797	7.4734	-44.8311	-7.3712	0.0000	0.0000	0.0000	0.0000;
	1358	1445	0.011157	0.034463	0.003913	140	140	140	0	0	1	-360	360	51.6654	8.6616	-51.4191	-8.3844	0.0000	0.0000	0.0000	0.0000;
	1287	1358	0.002314	0.007025	0.000816	140	140	140	0	0	1	-360	360	57.4713	9.9650	-57.4083	-9.8753	0.0000	0.0000	0.0000	0.0000;
	1445	1443	0.001058	0.010826	0.001726	75	75	75	0	0	1	-360	360	6.4394	0.9110	-6.4390	-1.1190	0.0000	0.0000	0.0000	0.0000;
	1358	1356	0.003223	0.006033	0.000578	90	90	90	0	0	1	-360	360	5.7429	1.2137	-5.7420	-1.2840	0.0000	0.0000	0.0000	0.0000;
	1776	1414	0.005455	0.016777	0.001914	114	114	114	0	0	1	-360	360	1.4837	-8.1879	-1.4805	7.9735	0.0000	0.0000	0.0000	0.0000;
	1899	1840	0.004215	0.009835	0.001217	120	120	120	0	0	1	-360	360	9.8875	1.3877	-9.8840	-1.5247	0.0000	0.0000	0.0000	0.0000;
	1150	1899	0.002066	0.00562	0.000593	120	120	120	0	0	1	-360	360	11.2668	2.1879	-11.2645	-2.2525	0.0000	0.0000	0.0000	0.0000;
	1898	1899	0.000661	0.002314	0.00022	120	120	120	0	0	1	-360	360	-1.3770	-0.8910	1.3770	0.8648	0.0000	0.0000	0.0000	0.0000;
	1373	1583	0.002893	0.008926	0.001004	140	140	140	0	0	1	-360	360	18.0430	3.4636	-18.0349	-3.5602	0.0000	0.0000	0.0000	0.0000;
	1810	1373	0.00595	0.019174	0.00203	140	140	140	0	0	1	-360	360	26.5796	5.6417	-26.5434	-5.7713	0.0000	0.0000	0.0000	0.0000;
	1373	1371	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	8.5004	2.3076	-8.4970	-2.4140	0.0000	0.0000	0.0000	0.0000;
	1040	1233	0.001405	0.004463	0.000467	120	120	120	0	0	1	-360	360	-14.2353	-5.9352	14.2381	5.8891	0.0000	0.0000	0.0000	0.0000;
	1061	1040	0.005124	0.016033	0.001805	140	140	140	0	0	1	-360	360	-11.7042	-5.1721	11.7113	4.9817	0.0000	0.0000	0.0000	0.0000;
	1039	1040	0.000331	0.001074	0.000107	140	140	140	0	0	1	-360	360	-2.5240	-0.9660	2.5240	0.9535	0.0000	0.0000	0.0000	0.0000;
	1732	1649	0.006529	0.023884	0.002338	105	105	105	0	0	1	-360	360	-9.9940	-3.3800	10.0000	3.1209	0.0000	0.0000	0.0000	0.0000;
	1901	1650	0.008017	0.026446	0.002645	140	140	140	0	0	1	-360	360	16.5604	3.9068	-16.5411	-4.1622	0.0000	0.0000	0.0000	0.0000;
	1751	1593	0.007273	0.012314	0.001788	90	90	90	0	0	1	-360	360	-29.3283	-1.1166	29.3831	1.0045	0.0000	0.0000	0.0000	0.0000;
	1838	920	0.02405	0.076281	0.008259	140	140	140	0	0	1	-360	360	66.6095	19.6319	-65.6652	-17.6305	0.0000	0.0000	0.0000	0.0000;
	1839	1041	0.003141	0.007769	0.000879	120	120	120	0	0	1	-360	360	2.9372	-0.0768	-2.9370	-0.0274	0.0000	0.0000	0.0000	0.0000;
	1469	1042	0.005785	0.016116	0.001876	120	120	120	0	0	1	-360	360	0.5060	0.3430	-0.5060	-0.5666	0.0000	0.0000	0.0000	0.0000;
	1295	1469	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	6.4849	0.7458	-6.4841	-0.8327	0.0000	0.0000	0.0000	0.0000;
	1467	1469	0.000248	0.000496	4.6e-05	90	90	90	0	0	1	-360	360	-5.9780	-0.4950	5.9781	0.4897	0.0000	0.0000	0.0000	0.0000;
	1794	1512	0.007438	0.023967	0.002517	140	140	140	0	0	1	-360	360	-31.0681	-3.8633	31.1276	3.7466	0.0000	0.0000	0.0000	0.0000;
	1511	1288	0.012066	0.038678	0.004075	140	140	140	0	0	1	-360	360	-3.2170	-1.1490	3.2181	0.6668	0.0000	0.0000	0.0000	0.0000;
	1648	1288	0.000496	0.003719	0.000387	152	152	152	0	0	1	-360	360	0.1477	-1.1762	-0.1477	1.1300	0.0000	0.0000	0.0000	0.0000;
	1704	1648	0.008099	0.051653	0.005365	140	140	140	0	0	1	-360	360	0.1479	-1.8406	-0.1477	1.2022	0.0000	0.0000	0.0000	0.0000;
	1840	1704	0.007686	0.023967	0.002698	114	114	114	0	0	1	-360	360	9.4493	-0.2191	-9.4436	-0.0846	0.0000	0.0000	0.0000	0.0000;
	1646	1648	0.000579	0.001818	0.000218	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0260	0.0000	0.0000	0.0000	0.0000;
	1702	1704	0.002231	0.007438	0.000726	140	140	140	0	0	1	-360	360	-9.2940	-2.0060	9.2957	1.9252	0.0000	0.0000	0.0000	0.0000;
	1584	885	0.002727	0.008512	0.000956	140	140	140	0	0	1	-360	360	5.9868	0.1408	-5.9860	-0.2537	0.0000	0.0000	0.0000	0.0000;
	1372	884	0.003223	0.010496	0.001104	140	140	140	0	0	1	-360	360	25.9486	5.3980	-25.9299	-5.4705	0.0000	0.0000	0.0000	0.0000;
	1049	1372	0.005289	0.016942	0.001796	140	140	140	0	0	1	-360	360	25.9792	5.1659	-25.9486	-5.2858	0.0000	0.0000	0.0000	0.0000;
	1372	1370	0.005289	0.008926	0.000927	90	90	90	0	0	1	-360	360	0.0000	-0.1122	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1779	1579	0.019256	0.061488	0.006558	140	140	140	0	0	1	-360	360	53.2052	5.3984	-52.7481	-4.7211	0.0000	0.0000	0.0000	0.0000;
	1836	1779	0.010413	0.033471	0.003533	140	140	140	0	0	1	-360	360	60.9854	7.3522	-60.6640	-6.7487	0.0000	0.0000	0.0000	0.0000;
	1778	1779	0.001653	0.005537	0.000525	140	140	140	0	0	1	-360	360	-7.4580	-1.4110	7.4588	1.3503	0.0000	0.0000	0.0000	0.0000;
	1707	1619	0.004711	0.014628	0.001667	114	114	114	0	0	1	-360	360	21.7939	5.5166	-21.7742	-5.6570	0.0000	0.0000	0.0000	0.0000;
	1491	943	0.004793	0.015785	0.001561	140	140	140	0	0	1	-360	360	4.5909	0.5578	-4.5900	-0.7430	0.0000	0.0000	0.0000	0.0000;
	1363	1491	0.007438	0.02405	0.002522	114	114	114	0	0	1	-360	360	12.6733	2.6312	-12.6629	-2.9019	0.0000	0.0000	0.0000	0.0000;
	1489	1491	8.3e-05	0.000826	1.9e-05	140	140	140	0	0	1	-360	360	-8.0720	-2.3460	8.0720	2.3441	0.0000	0.0000	0.0000	0.0000;
	1142	1362	0.000744	0.002314	0.00024	114	114	114	0	0	1	-360	360	-48.5544	-13.5605	48.5703	13.5813	0.0000	0.0000	0.0000	0.0000;
	1490	1142	0.006777	0.021736	0.002294	114	114	114	0	0	1	-360	360	-0.0000	-0.0590	0.0000	-0.2143	0.0000	0.0000	0.0000	0.0000;
	1139	1142	0.000909	0.003141	0.000298	114	114	114	0	0	1	-360	360	-48.5350	-13.7430	48.5544	13.7747	0.0000	0.0000	0.0000	0.0000;
	1538	1751	0.012397	0.028265	0.002664	90	90	90	0	0	1	-360	360	-3.3280	-1.4110	3.3294	1.1097	0.0000	0.0000	0.0000	0.0000;
	1793	1864	0.009421	0.031157	0.002778	120	120	120	0	0	1	-360	360	11.9046	8.0515	-11.8883	-8.3323	0.0000	0.0000	0.0000	0.0000;
	982	946	0.015124	0.04157	0.004136	120	120	120	0	0	1	-360	360	-18.3663	0.3134	18.4093	-0.6874	0.0000	0.0000	0.0000	0.0000;
	1390	945	0.015289	0.036612	0.005537	120	120	120	0	0	1	-360	360	-9.7391	10.6972	9.7665	-11.2988	0.0000	0.0000	0.0000	0.0000;
	1431	1179	0.009339	0.031901	0.003243	140	140	140	0	0	1	-360	360	-18.7973	-5.9458	18.8279	5.6664	0.0000	0.0000	0.0000	0.0000;
	1440	1431	0.002149	0.006777	0.000772	140	140	140	0	0	1	-360	360	-16.4948	-5.1928	16.5003	5.1189	0.0000	0.0000	0.0000	0.0000;
	1431	1430	0	8.3e-05	1e-05	140	140	140	0	0	1	-360	360	2.2970	0.8269	-2.2970	-0.8280	0.0000	0.0000	0.0000	0.0000;
	1402	1179	0.005041	0.016364	0.001711	140	140	140	0	0	1	-360	360	-25.2235	-11.0543	25.2557	10.9565	0.0000	0.0000	0.0000	0.0000;
	1730	1351	0.005785	0.014463	0.001636	120	120	120	0	0	1	-360	360	-15.5623	5.4286	15.5756	-5.5895	0.0000	0.0000	0.0000	0.0000;
	1223	1351	0.034132	0.094876	0.009319	120	120	120	0	0	1	-360	360	-12.8066	7.3649	12.8715	-8.2938	0.0000	0.0000	0.0000	0.0000;
	1222	1865	0.011074	0.03281	0.002829	120	120	120	0	0	1	-360	360	-11.7537	-8.5879	11.7731	8.3068	0.0000	0.0000	0.0000	0.0000;
	1223	1914	0.006198	0.016694	0.002616	140	140	140	0	0	1	-360	360	13.8303	-1.7199	-13.8202	1.4350	0.0000	0.0000	0.0000	0.0000;
	1388	1913	0.00124	0.003802	0.000423	140	140	140	0	0	1	-360	360	-5.3228	2.6171	5.3232	-2.6665	0.0000	0.0000	0.0000	0.0000;
	1681	1729	0.007686	0.020909	0.002139	120	120	120	0	0	1	-360	360	-14.2837	5.6751	14.2991	-5.8872	0.0000	0.0000	0.0000	0.0000;
	1679	1681	0.012479	0.037851	0.004477	140	140	140	0	0	1	-360	360	-14.2592	5.2179	14.2837	-5.6751	0.0000	0.0000	0.0000	0.0000;
	1222	1681	0.021901	0.060992	0.005953	120	120	120	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1222	860	0.004876	0.01314	0.001779	120	120	120	0	0	1	-360	360	9.0037	-0.3114	-9.0004	0.1083	0.0000	0.0000	0.0000	0.0000;
	999	1316	0.006198	0.019504	0.00213	140	140	140	0	0	1	-360	360	-9.6576	-1.7113	9.6626	1.4763	0.0000	0.0000	0.0000	0.0000;
	1222	1051	0.00405	0.013802	0.001314	140	140	140	0	0	1	-360	360	-5.8559	7.2236	5.8589	-7.3701	0.0000	0.0000	0.0000	0.0000;
	1052	1680	0.010248	0.031157	0.003683	140	140	140	0	0	1	-360	360	-6.3180	7.1765	6.3261	-7.5898	0.0000	0.0000	0.0000	0.0000;
	1219	1179	0.009587	0.030826	0.003265	140	140	140	0	0	1	-360	360	8.5666	-3.2958	-8.5599	2.9298	0.0000	0.0000	0.0000	0.0000;
	1457	1179	0.001405	0.004298	0.000472	140	140	140	0	0	1	-360	360	-26.7458	-9.4397	26.7553	9.4129	0.0000	0.0000	0.0000	0.0000;
	978	1210	0.007769	0.023554	0.002773	140	140	140	0	0	1	-360	360	30.3320	4.3233	-30.2720	-4.4782	0.0000	0.0000	0.0000	0.0000;
	1767	1299	0.008182	0.025537	0.002863	140	140	140	0	0	1	-360	360	-7.6351	3.7411	7.6402	-4.0599	0.0000	0.0000	0.0000	0.0000;
	1904	1896	0.001488	0.004628	0.000542	140	140	140	0	0	1	-360	360	5.2101	-1.1803	-5.2097	1.1168	0.0000	0.0000	0.0000	0.0000;
	1479	1387	0.006281	0.019752	0.002161	140	140	140	0	0	1	-360	360	-0.6880	-0.2200	0.6880	-0.0375	0.0000	0.0000	0.0000	0.0000;
	1480	1388	0.006198	0.019587	0.002139	140	140	140	0	0	1	-360	360	-0.8030	-0.3340	0.8030	0.0791	0.0000	0.0000	0.0000	0.0000;
	1387	1897	0.000826	0.002479	0.000271	140	140	140	0	0	1	-360	360	3.9704	2.0509	-3.9703	-2.0828	0.0000	0.0000	0.0000	0.0000;
	861	1905	0.000744	0.002397	0.000281	140	140	140	0	0	1	-360	360	6.5884	-0.7886	-6.5881	0.7560	0.0000	0.0000	0.0000	0.0000;
	1915	1388	0.001983	0.005289	0.000702	120	120	120	0	0	1	-360	360	-7.4968	-3.0984	7.4979	3.0177	0.0000	0.0000	0.0000	0.0000;
	1664	1659	0.003471	0.010413	0.001239	140	140	140	0	0	1	-360	360	-0.6954	6.7380	0.6967	-6.8823	0.0000	0.0000	0.0000	0.0000;
	1665	945	0.006446	0.019669	0.002335	140	140	140	0	0	1	-360	360	-8.9427	-9.1906	8.9514	8.9369	0.0000	0.0000	0.0000	0.0000;
	1697	1180	0.004793	0.014711	0.001706	140	140	140	0	0	1	-360	360	22.8110	4.5671	-22.7892	-4.7023	0.0000	0.0000	0.0000	0.0000;
	1202	1177	0.008843	0.027603	0.003083	140	140	140	0	0	1	-360	360	-11.9502	-1.8483	11.9608	1.5068	0.0000	0.0000	0.0000	0.0000;
	1713	1180	0.005041	0.015537	0.001801	140	140	140	0	0	1	-360	360	6.7131	2.4265	-6.7109	-2.6331	0.0000	0.0000	0.0000	0.0000;
	1700	1178	0.003554	0.00876	0.000963	120	120	120	0	0	1	-360	360	30.3088	6.5339	-30.2802	-6.5779	0.0000	0.0000	0.0000	0.0000;
	1803	1700	0.016033	0.046364	0.004455	120	120	120	0	0	1	-360	360	31.9425	6.5321	-31.8011	-6.6580	0.0000	0.0000	0.0000	0.0000;
	1700	1698	0.012645	0.015868	0.003013	90	90	90	0	0	1	-360	360	1.4922	0.1241	-1.4920	-0.4830	0.0000	0.0000	0.0000	0.0000;
	1701	1177	0.004298	0.010496	0.001159	120	120	120	0	0	1	-360	360	19.6669	3.4430	-19.6528	-3.5498	0.0000	0.0000	0.0000	0.0000;
	1672	1701	0.017273	0.055289	0.005189	120	120	120	0	0	1	-360	360	23.1889	3.7195	-23.1112	-4.1064	0.0000	0.0000	0.0000	0.0000;
	1701	1699	0.01281	0.016033	0.00304	90	90	90	0	0	1	-360	360	3.4443	0.6633	-3.4430	-1.0320	0.0000	0.0000	0.0000	0.0000;
	1804	1672	0.008926	0.027355	0.003165	140	140	140	0	0	1	-360	360	-26.1258	-4.1722	26.1767	3.9396	0.0000	0.0000	0.0000	0.0000;
	1035	1672	0.009008	0.027603	0.003202	140	140	140	0	0	1	-360	360	-61.0568	-10.6698	61.3415	11.1508	0.0000	0.0000	0.0000	0.0000;
	1673	945	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	40.3386	3.3897	-40.2234	-3.3977	0.0000	0.0000	0.0000	0.0000;
	1674	946	0.008512	0.026198	0.003006	120	120	120	0	0	1	-360	360	48.8788	6.3569	-48.7069	-6.1881	0.0000	0.0000	0.0000	0.0000;
	1855	1674	0.004298	0.01314	0.001559	140	140	140	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.1877	0.0000	0.0000	0.0000	0.0000;
	1856	1672	0.004298	0.01314	0.001556	140	140	140	0	0	1	-360	360	-7.4710	-3.0650	7.4733	2.8804	0.0000	0.0000	0.0000	0.0000;
	1506	1486	0.004959	0.012397	0.001375	120	120	120	0	0	1	-360	360	24.8295	-2.6815	-24.8037	2.5814	0.0000	0.0000	0.0000	0.0000;
	1674	1506	0.010992	0.032231	0.003112	120	120	120	0	0	1	-360	360	31.5803	-1.1629	-31.4892	1.0562	0.0000	0.0000	0.0000	0.0000;
	1505	1506	0.004298	0.013058	0.001544	140	140	140	0	0	1	-360	360	-6.6580	-1.8050	6.6597	1.6253	0.0000	0.0000	0.0000	0.0000;
	1673	1485	0.016033	0.044711	0.004499	120	120	120	0	0	1	-360	360	50.4035	1.3295	-50.0669	-0.9316	0.0000	0.0000	0.0000	0.0000;
	1672	1845	0.006198	0.02	0.00212	140	140	140	0	0	1	-360	360	17.8687	1.6250	-17.8524	-1.8333	0.0000	0.0000	0.0000	0.0000;
	1222	918	0.004545	0.013802	0.001638	140	140	140	0	0	1	-360	360	7.2279	0.7178	-7.2259	-0.9070	0.0000	0.0000	0.0000	0.0000;
	1773	877	0.004132	0.01281	0.00144	140	140	140	0	0	1	-360	360	7.8467	-1.5290	-7.8445	1.3647	0.0000	0.0000	0.0000	0.0000;
	1727	877	0.003471	0.011157	0.001198	140	140	140	0	0	1	-360	360	-38.8960	-8.6983	38.9425	8.7058	0.0000	0.0000	0.0000	0.0000;
	1352	1109	0.004628	0.014297	0.001619	140	140	140	0	0	1	-360	360	13.9811	2.4788	-13.9732	-2.6471	0.0000	0.0000	0.0000	0.0000;
	1724	1072	0.004711	0.014297	0.001699	140	140	140	0	0	1	-360	360	27.4581	5.6677	-27.4268	-5.7740	0.0000	0.0000	0.0000	0.0000;
	1352	1724	0.003554	0.010992	0.001261	140	140	140	0	0	1	-360	360	32.3181	6.9853	-32.2854	-7.0341	0.0000	0.0000	0.0000	0.0000;
	1724	1722	0.00157	0.005372	0.00052	140	140	140	0	0	1	-360	360	4.8273	1.3664	-4.8270	-1.4270	0.0000	0.0000	0.0000	0.0000;
	1530	878	0.002479	0.007686	0.000883	140	140	140	0	0	1	-360	360	40.5732	4.7075	-40.5382	-4.7035	0.0000	0.0000	0.0000	0.0000;
	1352	1530	0.006116	0.018926	0.002142	140	140	140	0	0	1	-360	360	41.9281	5.4430	-41.8362	-5.4128	0.0000	0.0000	0.0000	0.0000;
	1530	1529	0.002066	0.003802	0.000784	120	120	120	0	0	1	-360	360	1.2630	0.7053	-1.2630	-0.7980	0.0000	0.0000	0.0000	0.0000;
	1366	1352	0.002397	0.007355	0.000828	140	140	140	0	0	1	-360	360	-5.6929	12.5775	5.6967	-12.6643	0.0000	0.0000	0.0000	0.0000;
	1000	1440	0.002397	0.007769	0.000823	140	140	140	0	0	1	-360	360	-10.6654	-4.5698	10.6682	4.4817	0.0000	0.0000	0.0000	0.0000;
	1071	1548	0.003719	0.009008	0.001363	120	120	120	0	0	1	-360	360	21.4574	3.9868	-21.4424	-4.1113	0.0000	0.0000	0.0000	0.0000;
	1521	1439	0.006281	0.020083	0.002139	140	140	140	0	0	1	-360	360	18.5503	3.0809	-18.5314	-3.2733	0.0000	0.0000	0.0000	0.0000;
	1261	1218	8.3e-05	0.000248	2.2e-05	140	140	140	0	0	1	-360	360	-8.3417	0.0321	8.3417	-0.0345	0.0000	0.0000	0.0000	0.0000;
	1466	1261	0.007603	0.019587	0.002091	120	120	120	0	0	1	-360	360	-7.5350	-0.0505	7.5387	-0.1868	0.0000	0.0000	0.0000	0.0000;
	1439	1466	0.003141	0.00843	0.000857	120	120	120	0	0	1	-360	360	-7.5335	-0.1041	7.5350	0.0072	0.0000	0.0000	0.0000	0.0000;
	1260	1261	0.004545	0.008512	0.000927	90	90	90	0	0	1	-360	360	-0.8030	-0.2640	0.8030	0.1547	0.0000	0.0000	0.0000	0.0000;
	1465	1466	0.000496	0.001322	0.000133	120	120	120	0	0	1	-360	360	-0.0000	-0.0590	0.0000	0.0433	0.0000	0.0000	0.0000	0.0000;
	1237	1218	0.002562	0.006777	0.000944	120	120	120	0	0	1	-360	360	-0.5978	-4.7926	0.5983	4.6826	0.0000	0.0000	0.0000	0.0000;
	1422	1188	0.001653	0.004959	0.00059	140	140	140	0	0	1	-360	360	-4.5663	3.4637	4.5668	-3.5319	0.0000	0.0000	0.0000	0.0000;
	1184	1219	0.003223	0.009752	0.001159	140	140	140	0	0	1	-360	360	0.4258	-0.5325	-0.4258	0.3949	0.0000	0.0000	0.0000	0.0000;
	973	1184	0.003058	0.009421	0.001058	140	140	140	0	0	1	-360	360	0.4258	-0.6594	-0.4258	0.5339	0.0000	0.0000	0.0000	0.0000;
	1183	1184	0	8.3e-05	1.2e-05	140	140	140	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0014	0.0000	0.0000	0.0000	0.0000;
	1188	1547	0.001405	0.004298	0.000503	140	140	140	0	0	1	-360	360	-19.3695	-3.5283	19.3741	3.4830	0.0000	0.0000	0.0000	0.0000;
	1832	1367	0.010744	0.032727	0.003836	140	140	140	0	0	1	-360	360	-3.3803	12.8770	3.3967	-13.2858	0.0000	0.0000	0.0000	0.0000;
	1218	1458	0.008264	0.026612	0.002807	140	140	140	0	0	1	-360	360	-13.1870	-5.8741	13.2015	5.5885	0.0000	0.0000	0.0000	0.0000;
	1396	1793	0.014711	0.031488	0.005377	120	120	120	0	0	1	-360	360	-14.0240	-8.9796	14.0573	8.4037	0.0000	0.0000	0.0000	0.0000;
	1223	1396	0.009917	0.019669	0.003705	120	120	120	0	0	1	-360	360	-11.5937	-8.7080	11.6108	8.2989	0.0000	0.0000	0.0000	0.0000;
	1396	1395	0.002231	0.006033	0.000564	120	120	120	0	0	1	-360	360	2.4131	0.6807	-2.4130	-0.7480	0.0000	0.0000	0.0000	0.0000;
	875	1180	0.006033	0.020496	0.002176	140	140	140	0	0	1	-360	360	-33.0886	-8.2633	33.1481	8.2086	0.0000	0.0000	0.0000	0.0000;
	876	954	0.003058	0.010661	0.001171	140	140	140	0	0	1	-360	360	29.5309	5.8043	-29.5074	-5.8598	0.0000	0.0000	0.0000	0.0000;
	1176	953	0.006529	0.020909	0.002243	140	140	140	0	0	1	-360	360	-14.5668	-2.8164	14.5790	2.5926	0.0000	0.0000	0.0000	0.0000;
	1300	1176	0.002397	0.007355	0.000876	140	140	140	0	0	1	-360	360	-14.5623	-3.2596	14.5668	3.1711	0.0000	0.0000	0.0000	0.0000;
	1172	1176	0.008678	0.02719	0.00303	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.3547	0.0000	0.0000	0.0000	0.0000;
	1173	1176	0.008347	0.026116	0.002904	140	140	140	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1193	1485	0.004711	0.012149	0.001696	120	120	120	0	0	1	-360	360	-40.5897	1.4019	40.6550	-1.4358	0.0000	0.0000	0.0000	0.0000;
	1854	1193	0.02405	0.043223	0.008981	120	120	120	0	0	1	-360	360	-39.3535	1.0364	39.6717	-1.5257	0.0000	0.0000	0.0000	0.0000;
	1192	1193	0.003471	0.010826	0.001195	140	140	140	0	0	1	-360	360	-0.9180	-0.2660	0.9180	0.1238	0.0000	0.0000	0.0000	0.0000;
	1486	1660	0.001488	0.004463	0.000513	140	140	140	0	0	1	-360	360	15.6160	-3.9615	-15.6128	3.9098	0.0000	0.0000	0.0000	0.0000;
	1485	1284	0.000909	0.002975	0.000329	140	140	140	0	0	1	-360	360	4.0161	1.0751	-4.0160	-1.1140	0.0000	0.0000	0.0000	0.0000;
	1504	1485	0.010331	0.013223	0.00241	90	90	90	0	0	1	-360	360	-2.8700	-0.8390	2.8708	0.5523	0.0000	0.0000	0.0000	0.0000;
	1486	1257	0.00843	0.025785	0.00304	140	140	140	0	0	1	-360	360	6.1988	0.5371	-6.1960	-0.8921	0.0000	0.0000	0.0000	0.0000;
	1728	1522	0.001488	0.004628	0.00053	140	140	140	0	0	1	-360	360	27.0693	5.4233	-27.0597	-5.4562	0.0000	0.0000	0.0000	0.0000;
	1495	1439	0.001983	0.006116	0.000726	140	140	140	0	0	1	-360	360	-17.9933	-2.1438	17.9989	2.0753	0.0000	0.0000	0.0000	0.0000;
	1723	974	0.00438	0.014545	0.00144	140	140	140	0	0	1	-360	360	9.6113	1.4844	-9.6079	-1.6438	0.0000	0.0000	0.0000	0.0000;
	1110	1723	0.000661	0.001983	0.000232	140	140	140	0	0	1	-360	360	11.6781	2.0522	-11.6774	-2.0774	0.0000	0.0000	0.0000	0.0000;
	1721	1723	0.000165	0.000413	5.1e-05	140	140	140	0	0	1	-360	360	-2.0660	-0.5990	2.0660	0.5930	0.0000	0.0000	0.0000	0.0000;
	1315	878	0.004628	0.014545	0.001592	140	140	140	0	0	1	-360	360	-9.7777	-1.5360	9.7815	1.3601	0.0000	0.0000	0.0000	0.0000;
	1023	878	0.000826	0.002727	0.000257	140	140	140	0	0	1	-360	360	-21.3415	-1.2541	21.3447	1.2343	0.0000	0.0000	0.0000	0.0000;
	1398	1023	0.002562	0.008595	0.00082	140	140	140	0	0	1	-360	360	-21.3316	-1.2108	21.3415	1.1473	0.0000	0.0000	0.0000	0.0000;
	1022	1023	0.000992	0.003058	0.000358	140	140	140	0	0	1	-360	360	0.0000	-0.1490	0.0000	0.1067	0.0000	0.0000	0.0000	0.0000;
	1804	977	0.005289	0.016198	0.001907	140	140	140	0	0	1	-360	360	40.5091	7.2213	-40.4359	-7.2299	0.0000	0.0000	0.0000	0.0000;
	912	945	0.000826	0.001405	0.000152	90	90	90	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0183	0.0000	0.0000	0.0000	0.0000;
	913	946	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	-9.7530	-1.4860	9.7537	1.4698	0.0000	0.0000	0.0000	0.0000;
	914	946	0.000826	0.001322	0.000145	90	90	90	0	0	1	-360	360	-16.0640	-4.4570	16.0659	4.4428	0.0000	0.0000	0.0000	0.0000;
	915	945	0.000744	0.001157	0.000128	90	90	90	0	0	1	-360	360	-14.9570	-3.8630	14.9585	3.8499	0.0000	0.0000	0.0000	0.0000;
	1352	1772	0.004959	0.015289	0.001769	140	140	140	0	0	1	-360	360	17.0429	-0.2080	-17.0308	0.0348	0.0000	0.0000	0.0000	0.0000;
	1219	981	0.00719	0.017851	0.002134	120	120	120	0	0	1	-360	360	-9.8618	2.3439	9.8681	-2.5818	0.0000	0.0000	0.0000	0.0000;
	1439	1403	0.008017	0.027769	0.002802	140	140	140	0	0	1	-360	360	-9.7266	-1.4046	9.7331	1.0966	0.0000	0.0000	0.0000	0.0000;
	1916	919	0.006033	0.018347	0.002176	140	140	140	0	0	1	-360	360	-3.7772	-0.1157	3.7779	-0.1413	0.0000	0.0000	0.0000	0.0000;
	1420	1353	0.007686	0.027273	0.003178	140	140	140	0	0	1	-360	360	-4.8634	-3.5215	4.8657	3.1484	0.0000	0.0000	0.0000	0.0000;
	1696	1178	0.001405	0.00438	0.000506	140	140	140	0	0	1	-360	360	-25.1064	-5.1648	25.1142	5.1289	0.0000	0.0000	0.0000	0.0000;
	1423	1236	0.004876	0.009256	0.001801	120	120	120	0	0	1	-360	360	3.5343	-3.6659	-3.5332	3.4555	0.0000	0.0000	0.0000	0.0000;
	1842	1793	0.003719	0.012645	0.00121	140	140	140	0	0	1	-360	360	-6.5520	-3.1270	6.5536	2.9863	0.0000	0.0000	0.0000	0.0000;
	1803	1036	0.002727	0.008347	0.000956	140	140	140	0	0	1	-360	360	-60.2818	-10.3652	60.3662	10.5077	0.0000	0.0000	0.0000	0.0000;
	1853	1769	0.001157	0.002893	0.000436	120	120	120	0	0	1	-360	360	29.1336	-3.7267	-29.1251	3.6969	0.0000	0.0000	0.0000	0.0000;
	1389	1792	0.007686	0.02405	0.002703	140	140	140	0	0	1	-360	360	4.5699	-12.1546	-4.5594	11.8602	0.0000	0.0000	0.0000	0.0000;
	1833	1792	0.01124	0.032562	0.003272	120	120	120	0	0	1	-360	360	-8.6828	-16.2564	8.7140	15.9521	0.0000	0.0000	0.0000	0.0000;
	1442	1846	0.005868	0.01595	0.00174	120	120	120	0	0	1	-360	360	-20.9303	-4.2233	20.9521	4.0692	0.0000	0.0000	0.0000	0.0000;
	1804	1442	0.000165	0.000331	3.2e-05	120	120	120	0	0	1	-360	360	-20.9297	-4.3175	20.9303	4.3149	0.0000	0.0000	0.0000	0.0000;
	1442	1441	0.001983	0.005207	0.000748	120	120	120	0	0	1	-360	360	0.0000	-0.0916	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1092	1079	0.063554	0.129835	0.012678	90	90	90	0	0	1	-360	360	16.3027	-0.1064	-16.1607	-1.1011	0.0000	0.0000	0.0000	0.0000;
	1658	1111	0.030413	0.056942	0.00521	57	57	57	0	0	1	-360	360	7.2266	-1.8254	-7.2123	1.2478	0.0000	0.0000	0.0000	0.0000;
	1895	1658	0.099008	0.200248	0.017475	90	90	90	0	0	1	-360	360	11.4691	-1.9933	-11.3579	0.1729	0.0000	0.0000	0.0000	0.0000;
	1657	1658	0.001983	0.003306	0.000353	19	19	19	0	0	1	-360	360	-4.1310	-1.6930	4.1313	1.6525	0.0000	0.0000	0.0000	0.0000;
	1345	1894	0.016116	0.028512	0.002735	90	90	90	0	0	1	-360	360	-5.0570	0.0830	5.0605	-0.3991	0.0000	0.0000	0.0000	0.0000;
	1745	899	0.022893	0.056694	0.006297	114	114	114	0	0	1	-360	360	6.6721	-2.8586	-6.6623	2.1408	0.0000	0.0000	0.0000	0.0000;
	1735	899	0.024793	0.061322	0.006817	114	114	114	0	0	1	-360	360	1.2831	0.6047	-1.2825	-1.4074	0.0000	0.0000	0.0000	0.0000;
	1895	1069	0.022727	0.072645	0.007749	57	57	57	0	0	1	-360	360	-7.3154	-2.4933	7.3265	1.6123	0.0000	0.0000	0.0000	0.0000;
	1343	899	0.014711	0.045207	0.005198	114	114	114	0	0	1	-360	360	-2.8324	0.7774	2.8336	-1.3866	0.0000	0.0000	0.0000	0.0000;
	1091	1148	0.096446	0.194711	0.017877	90	90	90	0	0	1	-360	360	3.2263	0.2967	-3.2164	-2.3993	0.0000	0.0000	0.0000	0.0000;
	1346	900	0.015124	0.040496	0.004627	114	114	114	0	0	1	-360	360	-25.9449	-3.9766	26.0343	3.6759	0.0000	0.0000	0.0000	0.0000;
	966	1346	0.037273	0.075454	0.006638	90	90	90	0	0	1	-360	360	-20.6297	-3.4747	20.7717	2.9978	0.0000	0.0000	0.0000	0.0000;
	1344	1346	0.000579	0.000992	8.9e-05	29	29	29	0	0	1	-360	360	-5.1730	-0.9890	5.1731	0.9788	0.0000	0.0000	0.0000	0.0000;
	881	1058	0.018017	0.054711	0.006486	57	57	57	0	0	1	-360	360	-14.9975	0.6229	15.0325	-1.2703	0.0000	0.0000	0.0000	0.0000;
	1111	881	0.012397	0.037603	0.004441	57	57	57	0	0	1	-360	360	-10.7262	1.1459	10.7387	-1.6228	0.0000	0.0000	0.0000	0.0000;
	881	880	0.016529	0.027273	0.002948	19	19	19	0	0	1	-360	360	4.2588	0.9999	-4.2560	-1.3370	0.0000	0.0000	0.0000	0.0000;
	1111	1493	0.014545	0.025124	0.003572	57	57	57	0	0	1	-360	360	6.7804	-0.3593	-6.7746	-0.0442	0.0000	0.0000	0.0000	0.0000;
	1247	900	0.00719	0.022149	0.002522	114	114	114	0	0	1	-360	360	-7.1712	-15.3443	7.1886	15.1033	0.0000	0.0000	0.0000	0.0000;
	1246	901	0.00719	0.022231	0.002534	114	114	114	0	0	1	-360	360	0.3956	-3.6371	-0.3949	3.3388	0.0000	0.0000	0.0000	0.0000;
	1092	1086	0.006612	0.021074	0.002248	114	114	114	0	0	1	-360	360	-44.8758	7.8165	44.9910	-7.7176	0.0000	0.0000	0.0000	0.0000;
	1117	1091	0.016364	0.052149	0.005588	140	140	140	0	0	1	-360	360	48.1774	-3.2157	-47.8611	3.5535	0.0000	0.0000	0.0000	0.0000;
	1500	1091	0.019504	0.035537	0.009019	114	114	114	0	0	1	-360	360	-8.3855	-2.8348	8.3979	1.7835	0.0000	0.0000	0.0000	0.0000;
	1053	1092	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	-3.4420	-0.4460	3.4421	0.4174	0.0000	0.0000	0.0000	0.0000;
	1054	1091	0.001322	0.002314	0.000242	57	57	57	0	0	1	-360	360	-0.0000	-0.1110	0.0000	0.0821	0.0000	0.0000	0.0000	0.0000;
	1534	1092	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-12.8733	0.0851	12.9131	-0.7839	0.0000	0.0000	0.0000	0.0000;
	1894	1534	0.037769	0.073802	0.00657	90	90	90	0	0	1	-360	360	-7.2337	-0.6524	7.2505	-0.0917	0.0000	0.0000	0.0000	0.0000;
	1534	1532	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	5.6229	0.0066	-5.6220	-0.0740	0.0000	0.0000	0.0000	0.0000;
	1895	1297	0.038182	0.074876	0.00666	90	90	90	0	0	1	-360	360	-2.4391	-0.7105	2.4410	-0.0720	0.0000	0.0000	0.0000	0.0000;
	1533	1091	0.02843	0.074132	0.006752	90	90	90	0	0	1	-360	360	-13.3610	-1.5945	13.4043	0.9049	0.0000	0.0000	0.0000	0.0000;
	1298	1533	0.005207	0.009835	0.000956	90	90	90	0	0	1	-360	360	-13.3531	-1.7613	13.3610	1.6633	0.0000	0.0000	0.0000	0.0000;
	1533	1531	0.003306	0.005455	0.000581	19	19	19	0	0	1	-360	360	0.0000	-0.0687	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1292	1267	0.040496	0.066694	0.007214	57	57	57	0	0	1	-360	360	-13.7649	7.7836	13.8535	-8.4843	0.0000	0.0000	0.0000	0.0000;
	1888	1302	0.025785	0.06843	0.007802	114	114	114	0	0	1	-360	360	0.0009	-0.7669	-0.0009	-0.1474	0.0000	0.0000	0.0000	0.0000;
	1889	1500	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-10.5081	-3.2990	10.5327	2.5566	0.0000	0.0000	0.0000	0.0000;
	1889	1501	0.024463	0.061322	0.006793	114	114	114	0	0	1	-360	360	-16.0166	5.3782	16.0768	-6.0290	0.0000	0.0000	0.0000	0.0000;
	927	1334	0.024793	0.065454	0.006614	114	114	114	0	0	1	-360	360	21.6548	-3.7120	-21.5541	3.1992	0.0000	0.0000	0.0000	0.0000;
	1888	1692	0.001653	0.003471	0.00038	90	90	90	0	0	1	-360	360	1.8360	-0.2444	-1.8360	0.2000	0.0000	0.0000	0.0000	0.0000;
	1889	1693	0.001074	0.003471	0.00037	114	114	114	0	0	1	-360	360	2.5241	0.9965	-2.5240	-1.0400	0.0000	0.0000	0.0000	0.0000;
	1825	1266	0.030744	0.050661	0.005474	57	57	57	0	0	1	-360	360	12.2555	-10.3483	-12.1897	9.8151	0.0000	0.0000	0.0000	0.0000;
	1342	1894	0.002314	0.007438	0.000799	114	114	114	0	0	1	-360	360	3.7924	-5.6926	-3.7915	5.6014	0.0000	0.0000	0.0000	0.0000;
	1091	1070	0.01124	0.036116	0.003816	114	114	114	0	0	1	-360	360	22.0604	2.9445	-22.0136	-3.2481	0.0000	0.0000	0.0000	0.0000;
	1333	1266	0.007769	0.021736	0.002362	114	114	114	0	0	1	-360	360	16.4968	-3.9590	-16.4778	3.7347	0.0000	0.0000	0.0000	0.0000;
	1826	1454	0.05	0.082397	0.008901	57	57	57	0	0	1	-360	360	-19.9538	8.0169	20.1549	-8.7303	0.0000	0.0000	0.0000	0.0000;
	1501	964	0.026033	0.065702	0.007335	114	114	114	0	0	1	-360	360	10.4901	-3.4519	-10.4639	2.6529	0.0000	0.0000	0.0000	0.0000;
	1556	1453	0.042397	0.069917	0.00755	57	57	57	0	0	1	-360	360	32.8472	-6.5538	-32.4514	6.3107	0.0000	0.0000	0.0000	0.0000;
	891	1001	0.00438	0.014876	0.001423	114	114	114	0	0	1	-360	360	-37.9260	5.3360	37.9789	-5.3289	0.0000	0.0000	0.0000	0.0000;
	1108	899	0.032479	0.102314	0.011265	114	114	114	0	0	1	-360	360	5.7988	1.0175	-5.7888	-2.3178	0.0000	0.0000	0.0000	0.0000;
	1577	1064	0.050248	0.08281	0.008956	57	57	57	0	0	1	-360	360	-11.0638	1.6960	11.1221	-2.5842	0.0000	0.0000	0.0000	0.0000;
	1734	1500	0.025372	0.062562	0.006924	114	114	114	0	0	1	-360	360	-12.2992	-1.4857	12.3319	0.7465	0.0000	0.0000	0.0000	0.0000;
	1807	1080	0.013306	0.040413	0.004804	57	57	57	0	0	1	-360	360	-2.5270	-0.0090	2.5277	-0.5508	0.0000	0.0000	0.0000	0.0000;
	1001	1092	0.01	0.068512	0.007647	232	232	232	0	0	1	-360	360	69.0931	7.6248	-68.6949	-5.8165	0.0000	0.0000	0.0000	0.0000;
	1002	1754	0.005868	0.040083	0.004518	232	232	232	0	0	1	-360	360	80.4538	3.2338	-80.1396	-1.6323	0.0000	0.0000	0.0000	0.0000;
	1075	1085	0.006281	0.019835	0.00218	114	114	114	0	0	1	-360	360	61.3930	-5.5808	-61.1942	5.9475	0.0000	0.0000	0.0000	0.0000;
	1002	1076	0.009421	0.041736	0.004576	114	114	114	0	0	1	-360	360	70.1691	-2.0211	-69.7858	3.1671	0.0000	0.0000	0.0000	0.0000;
	963	1744	0.005207	0.014215	0.001614	114	114	114	0	0	1	-360	360	8.6278	-2.9505	-8.6242	2.7702	0.0000	0.0000	0.0000	0.0000;
	1759	1085	0.002149	0.007273	0.000758	57	57	57	0	0	1	-360	360	-8.1630	-0.6780	8.1642	0.5916	0.0000	0.0000	0.0000	0.0000;
	1758	1086	0.002149	0.00719	0.000753	57	57	57	0	0	1	-360	360	-3.1000	-0.5640	3.1002	0.4747	0.0000	0.0000	0.0000	0.0000;
	1555	890	0.033058	0.05686	0.006142	90	90	90	0	0	1	-360	360	-36.0640	5.4631	36.4330	-5.5683	0.0000	0.0000	0.0000	0.0000;
	1578	906	0.017769	0.058016	0.005917	57	57	57	0	0	1	-360	360	0.8517	-4.3713	-0.8490	3.7310	0.0000	0.0000	0.0000	0.0000;
	1500	926	0.022479	0.054545	0.00621	114	114	114	0	0	1	-360	360	25.1106	-3.6646	-24.9893	3.2236	0.0000	0.0000	0.0000	0.0000;
	1057	1079	0.014545	0.04405	0.00522	57	57	57	0	0	1	-360	360	-22.0467	0.8447	22.1076	-1.2697	0.0000	0.0000	0.0000	0.0000;
	1520	1111	0.029917	0.096116	0.010188	57	57	57	0	0	1	-360	360	-6.7840	0.1730	6.7961	-1.3133	0.0000	0.0000	0.0000	0.0000;
	1092	1789	0.011157	0.034545	0.003903	114	114	114	0	0	1	-360	360	9.2623	0.2817	-9.2542	-0.7216	0.0000	0.0000	0.0000	0.0000;
	1518	1678	0.034628	0.108843	0.01203	114	114	114	0	0	1	-360	360	-31.8506	1.9950	32.1491	-2.4926	0.0000	0.0000	0.0000	0.0000;
	1616	1001	0.021074	0.067686	0.007149	114	114	114	0	0	1	-360	360	-34.2687	1.3333	34.4751	-1.5346	0.0000	0.0000	0.0000	0.0000;
	1149	1616	0.030413	0.09438	0.010721	114	114	114	0	0	1	-360	360	-32.2743	-0.8606	32.5424	0.4147	0.0000	0.0000	0.0000	0.0000;
	1615	1616	0.007603	0.036364	0.006795	114	114	114	0	0	1	-360	360	-1.7260	0.9320	1.7263	-1.7480	0.0000	0.0000	0.0000	0.0000;
	1677	1002	0.014711	0.046529	0.005092	114	114	114	0	0	1	-360	360	-36.0600	1.9796	36.2197	-2.0889	0.0000	0.0000	0.0000	0.0000;
	1517	1148	0.010248	0.03124	0.003698	57	57	57	0	0	1	-360	360	21.5140	-1.6672	-21.4738	1.3522	0.0000	0.0000	0.0000	0.0000;
	1755	1091	0.004628	0.031736	0.003586	232	232	232	0	0	1	-360	360	71.6358	0.3244	-71.4379	0.6041	0.0000	0.0000	0.0000	0.0000;
	1881	1116	0.003388	0.010331	0.00121	114	114	114	0	0	1	-360	360	56.0764	-0.5803	-55.9882	0.7029	0.0000	0.0000	0.0000	0.0000;
	1001	1880	0.003306	0.022479	0.002502	114	114	114	0	0	1	-360	360	74.5064	2.6077	-74.3552	-1.8826	0.0000	0.0000	0.0000	0.0000;
	1500	1001	0.03438	0.110579	0.011626	114	114	114	0	0	1	-360	360	-45.5589	2.3973	46.1622	-1.8537	0.0000	0.0000	0.0000	0.0000;
	1501	1002	0.03438	0.110579	0.011628	114	114	114	0	0	1	-360	360	-46.5374	0.9519	47.1690	-0.3108	0.0000	0.0000	0.0000	0.0000;
	1331	1065	0.053471	0.074876	0.006638	57	57	57	0	0	1	-360	360	19.8264	-0.3406	-19.6394	-0.1367	0.0000	0.0000	0.0000	0.0000;
	971	901	0.008678	0.022066	0.002524	114	114	114	0	0	1	-360	360	-23.7866	-2.3531	23.8284	2.1606	0.0000	0.0000	0.0000	0.0000;
	1788	1107	0.017025	0.053058	0.005936	114	114	114	0	0	1	-360	360	8.4511	0.5110	-8.4408	-1.1839	0.0000	0.0000	0.0000	0.0000;
	1112	965	0.082314	0.150413	0.014297	57	57	57	0	0	1	-360	360	-15.7281	-3.4510	15.9173	2.1895	0.0000	0.0000	0.0000	0.0000;
	1149	1079	0.04719	0.089008	0.008707	57	57	57	0	0	1	-360	360	14.3027	-1.5613	-14.2206	0.6924	0.0000	0.0000	0.0000	0.0000;
	961	972	0.058099	0.089008	0.008833	75	75	75	0	0	1	-360	360	-15.0563	-2.2760	15.1713	1.4172	0.0000	0.0000	0.0000	0.0000;
	906	1112	0.013636	0.043967	0.004617	114	114	114	0	0	1	-360	360	-11.5750	-4.7060	11.5941	4.2580	0.0000	0.0000	0.0000	0.0000;
	1399	1500	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-2.0650	-0.6690	2.0650	0.6691	0.0000	0.0000	0.0000	0.0000;
	1400	1501	0.000826	0.001653	0	229	229	229	0	0	1	-360	360	-16.9820	-8.0230	16.9845	8.0279	0.0000	0.0000	0.0000	0.0000;
	1401	1500	0.001157	0.002066	0	229	229	229	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1685	956	0.023719	0.058264	0.006457	120	120	120	0	0	1	-360	360	41.9871	4.5317	-41.6293	-4.4098	0.0000	0.0000	0.0000	0.0000;
	1168	1394	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	6.2417	5.6330	-6.2392	-5.7581	0.0000	0.0000	0.0000	0.0000;
	1290	1168	0.03595	0.089835	0.009932	120	120	120	0	0	1	-360	360	5.5585	4.3510	-5.5417	-5.4771	0.0000	0.0000	0.0000	0.0000;
	1166	1168	0.000248	0.000496	0.000102	120	120	120	0	0	1	-360	360	0.7000	0.1440	-0.7000	-0.1559	0.0000	0.0000	0.0000	0.0000;
	1684	916	0.017851	0.041984	0.006072	120	120	120	0	0	1	-360	360	47.2062	1.8926	-46.8699	-1.8161	0.0000	0.0000	0.0000	0.0000;
	1684	863	0.018182	0.06281	0.0065	114	114	114	0	0	1	-360	360	39.7998	5.8731	-39.5509	-5.7769	0.0000	0.0000	0.0000	0.0000;
	1685	1572	0.025124	0.089339	0.008877	114	114	114	0	0	1	-360	360	6.1596	3.5663	-6.1481	-4.5721	0.0000	0.0000	0.0000	0.0000;
	1684	1275	0.01157	0.025785	0.003778	120	120	120	0	0	1	-360	360	0.0000	-0.3889	0.0000	-0.0590	0.0000	0.0000	0.0000	0.0000;
	1705	1394	0.02438	0.043802	0.009111	120	120	120	0	0	1	-360	360	2.9163	-6.7753	-2.9063	5.7307	0.0000	0.0000	0.0000	0.0000;
	1169	1394	0.004132	0.010165	0.001123	120	120	120	0	0	1	-360	360	-16.8172	5.3019	16.8282	-5.4059	0.0000	0.0000	0.0000	0.0000;
	1817	1169	0.005702	0.017438	0.001672	120	120	120	0	0	1	-360	360	-13.7022	5.8949	13.7131	-6.0568	0.0000	0.0000	0.0000	0.0000;
	1169	1167	0.000331	0.000579	0.000121	120	120	120	0	0	1	-360	360	3.1040	0.7549	-3.1040	-0.7690	0.0000	0.0000	0.0000	0.0000;
	1818	1614	0.019174	0.052562	0.005515	120	120	120	0	0	1	-360	360	-8.6087	-4.6679	8.6240	4.0672	0.0000	0.0000	0.0000	0.0000;
	1817	1162	0.000826	0.002397	0.000315	114	114	114	0	0	1	-360	360	10.4538	2.6796	-10.4530	-2.7140	0.0000	0.0000	0.0000	0.0000;
	1818	1163	0.000909	0.002645	0.00037	114	114	114	0	0	1	-360	360	7.3495	1.9093	-7.3490	-1.9510	0.0000	0.0000	0.0000	0.0000;
	1818	1157	0.001818	0.005537	0.000653	114	114	114	0	0	1	-360	360	23.4559	8.9322	-23.4460	-8.9780	0.0000	0.0000	0.0000	0.0000;
	1817	1158	0.001901	0.005702	0.000673	114	114	114	0	0	1	-360	360	2.1801	1.3517	-2.1800	-1.4300	0.0000	0.0000	0.0000	0.0000;
	1824	1572	0.004628	0.014876	0.001563	114	114	114	0	0	1	-360	360	-22.5725	-3.0287	22.5930	2.9112	0.0000	0.0000	0.0000	0.0000;
	1376	1571	0.008264	0.026612	0.0028	114	114	114	0	0	1	-360	360	-2.9428	-3.2244	2.9441	2.9038	0.0000	0.0000	0.0000	0.0000;
	1818	1155	0.005372	0.01281	0.002529	114	114	114	0	0	1	-360	360	-0.9886	1.4591	0.9888	-1.7524	0.0000	0.0000	0.0000	0.0000;
	1393	1152	0.003471	0.006529	0.000605	90	90	90	0	0	1	-360	360	5.2778	-0.3907	-5.2770	0.3220	0.0000	0.0000	0.0000	0.0000;
	1393	1153	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	2.8783	-0.8881	-2.8780	0.8200	0.0000	0.0000	0.0000	0.0000;
	1394	1154	0.003636	0.006446	0.00059	90	90	90	0	0	1	-360	360	5.3369	-0.6014	-5.3360	0.5340	0.0000	0.0000	0.0000	0.0000;
	1394	1159	0.001074	0.002231	0.000414	114	114	114	0	0	1	-360	360	11.4873	2.5463	-11.4860	-2.5920	0.0000	0.0000	0.0000	0.0000;
	1393	1160	0.001157	0.002066	0.000426	114	114	114	0	0	1	-360	360	1.0330	0.3135	-1.0330	-0.3630	0.0000	0.0000	0.0000	0.0000;
	1818	1165	0.001818	0.005124	0.000716	114	114	114	0	0	1	-360	360	11.0353	4.7309	-11.0330	-4.8077	0.0000	0.0000	0.0000	0.0000;
	1393	1156	0.002479	0.006364	0.001108	114	114	114	0	0	1	-360	360	9.5978	0.4433	-9.5958	-0.5669	0.0000	0.0000	0.0000	0.0000;
	1393	870	0.017934	0.04438	0.004813	120	120	120	0	0	1	-360	360	0.6176	-5.7091	-0.6130	5.1603	0.0000	0.0000	0.0000	0.0000;
	994	871	0.006281	0.019091	0.001994	114	114	114	0	0	1	-360	360	9.9756	2.0448	-9.9700	-2.2606	0.0000	0.0000	0.0000	0.0000;
	1558	1073	0.013223	0.036364	0.003872	114	114	114	0	0	1	-360	360	21.7323	1.1120	-21.6786	-1.4159	0.0000	0.0000	0.0000	0.0000;
	1823	1374	0.003719	0.012066	0.001268	140	140	140	0	0	1	-360	360	-1.0066	-2.9059	1.0068	2.7582	0.0000	0.0000	0.0000	0.0000;
	1541	1376	0.002066	0.006446	0.000748	140	140	140	0	0	1	-360	360	-11.4586	-2.8679	11.4611	2.7891	0.0000	0.0000	0.0000	0.0000;
	956	1542	0.011983	0.034132	0.003741	120	120	120	0	0	1	-360	360	3.6699	0.7279	-3.6684	-1.1572	0.0000	0.0000	0.0000	0.0000;
	1684	1762	0.012314	0.037521	0.004424	114	114	114	0	0	1	-360	360	41.1109	9.5608	-40.9254	-9.5162	0.0000	0.0000	0.0000	0.0000;
	1691	938	0.003884	0.009174	0.001317	120	120	120	0	0	1	-360	360	5.0303	0.4746	-5.0295	-0.6287	0.0000	0.0000	0.0000	0.0000;
	1691	1684	0.000661	0.00438	0.000586	152	152	152	0	0	1	-360	360	-21.6009	0.1347	21.6035	-0.1868	0.0000	0.0000	0.0000	0.0000;
	1690	1685	0.000909	0.006281	0.000755	152	152	152	0	0	1	-360	360	-10.6503	-6.1192	10.6515	6.0378	0.0000	0.0000	0.0000	0.0000;
	1228	1774	0.043223	0.057851	0.005162	57	57	57	0	0	1	-360	360	-7.6583	-0.3982	7.6803	-0.1679	0.0000	0.0000	0.0000	0.0000;
	1686	1228	0.009256	0.029752	0.003134	57	57	57	0	0	1	-360	360	-2.5990	0.1190	2.5995	-0.4777	0.0000	0.0000	0.0000	0.0000;
	1226	1228	0.007686	0.010165	0.000908	75	75	75	0	0	1	-360	360	-5.0570	-0.9780	5.0588	0.8760	0.0000	0.0000	0.0000	0.0000;
	1229	1775	0.034793	0.040248	0.007214	57	57	57	0	0	1	-360	360	-9.5857	-0.1620	9.6135	-0.6386	0.0000	0.0000	0.0000	0.0000;
	1687	1229	0.009091	0.029174	0.003078	57	57	57	0	0	1	-360	360	-4.8720	0.0240	4.8739	-0.3722	0.0000	0.0000	0.0000	0.0000;
	1227	1229	0.004132	0.007438	0.001149	62	62	62	0	0	1	-360	360	-4.7110	-0.6650	4.7118	0.5342	0.0000	0.0000	0.0000	0.0000;
	1691	1603	0.087769	0.169835	0.016066	90	90	90	0	0	1	-360	360	16.5705	-0.6093	-16.3671	-0.8781	0.0000	0.0000	0.0000	0.0000;
	1685	1437	0.02	0.046694	0.009535	114	114	114	0	0	1	-360	360	46.6278	1.0214	-46.2604	-1.2839	0.0000	0.0000	0.0000	0.0000;
	1438	1391	0.039339	0.090413	0.018963	114	114	114	0	0	1	-360	360	25.2204	-4.0217	-25.0028	2.3258	0.0000	0.0000	0.0000	0.0000;
	1182	1214	0.043223	0.103058	0.011205	90	90	90	0	0	1	-360	360	1.0815	2.6228	-1.0771	-3.8859	0.0000	0.0000	0.0000	0.0000;
	1774	1354	0.015703	0.024793	0.004015	90	90	90	0	0	1	-360	360	2.2628	3.1315	-2.2605	-3.5922	0.0000	0.0000	0.0000	0.0000;
	1644	882	0.036777	0.09157	0.00974	120	120	120	0	0	1	-360	360	24.0604	-0.6682	-23.8766	0.0061	0.0000	0.0000	0.0000	0.0000;
	1078	1540	0.009339	0.017355	0.001779	90	90	90	0	0	1	-360	360	4.3626	0.8851	-4.3610	-1.0850	0.0000	0.0000	0.0000	0.0000;
	1077	1306	0.032645	0.099504	0.011696	76	76	76	0	0	1	-360	360	8.4920	-0.5082	-8.4714	-0.7606	0.0000	0.0000	0.0000	0.0000;
	1604	1355	0.026529	0.034463	0.006389	90	90	90	0	0	1	-360	360	4.8770	-2.5878	-4.8705	1.8581	0.0000	0.0000	0.0000	0.0000;
	1374	993	0.003884	0.012479	0.001309	114	114	114	0	0	1	-360	360	32.9768	4.6337	-32.9400	-4.6687	0.0000	0.0000	0.0000	0.0000;
	1096	1739	0.035785	0.070331	0.00718	90	90	90	0	0	1	-360	360	5.2602	1.1616	-5.2506	-1.9494	0.0000	0.0000	0.0000	0.0000;
	1738	1063	0.003967	0.00719	0.001026	57	57	57	0	0	1	-360	360	2.0682	0.3983	-2.0680	-0.5130	0.0000	0.0000	0.0000	0.0000;
	1738	1860	0.007107	0.011818	0.001256	90	90	90	0	0	1	-360	360	3.1447	1.1351	-3.1440	-1.2746	0.0000	0.0000	0.0000	0.0000;
	1739	1861	0.007025	0.011653	0.001244	90	90	90	0	0	1	-360	360	3.7510	1.0707	-3.7500	-1.2084	0.0000	0.0000	0.0000	0.0000;
	893	1461	0.019091	0.057934	0.006878	114	114	114	0	0	1	-360	360	-19.4154	-1.7134	19.4777	1.1014	0.0000	0.0000	0.0000	0.0000;
	1775	893	0.006529	0.019835	0.002357	114	114	114	0	0	1	-360	360	-16.2954	-1.5790	16.3105	1.3517	0.0000	0.0000	0.0000	0.0000;
	892	893	0.01	0.030331	0.003603	57	57	57	0	0	1	-360	360	-3.1040	-0.7770	3.1049	0.3617	0.0000	0.0000	0.0000	0.0000;
	1077	1392	0.038678	0.119669	0.013649	114	114	114	0	0	1	-360	360	-6.5569	-2.5955	6.5726	1.0795	0.0000	0.0000	0.0000	0.0000;
	1077	905	0.002645	0.008182	0.000961	114	114	114	0	0	1	-360	360	0.7069	5.5492	-0.7062	-5.6565	0.0000	0.0000	0.0000	0.0000;
	1843	955	0.01405	0.026033	0.003528	90	90	90	0	0	1	-360	360	-39.7476	-4.8363	39.9440	4.7933	0.0000	0.0000	0.0000	0.0000;
	1571	864	0.012727	0.043388	0.004581	114	114	114	0	0	1	-360	360	-10.3290	-0.1872	10.3407	-0.3055	0.0000	0.0000	0.0000	0.0000;
	997	1374	0.002149	0.014711	0.00167	152	152	152	0	0	1	-360	360	-13.2080	-3.3130	13.2114	3.1406	0.0000	0.0000	0.0000	0.0000;
	1289	1684	0.007686	0.020496	0.002246	120	120	120	0	0	1	-360	360	-22.2247	0.8875	22.2569	-1.0677	0.0000	0.0000	0.0000	0.0000;
	1817	1375	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	1.0683	-9.9262	-1.0661	9.7136	0.0000	0.0000	0.0000	0.0000;
	1818	1376	0.002645	0.01876	0.001951	152	152	152	0	0	1	-360	360	54.8380	-1.4277	-54.7695	1.6874	0.0000	0.0000	0.0000	0.0000;
	1893	1572	0.015124	0.041157	0.004104	114	114	114	0	0	1	-360	360	40.3118	-4.0103	-40.1023	4.0967	0.0000	0.0000	0.0000	0.0000;
	917	1535	0.008926	0.023719	0.003146	114	114	114	0	0	1	-360	360	27.1231	0.0458	-27.0669	-0.2628	0.0000	0.0000	0.0000	0.0000;
	1078	1095	0.04124	0.076446	0.007979	90	90	90	0	0	1	-360	360	13.4847	2.3253	-13.4162	-3.1031	0.0000	0.0000	0.0000	0.0000;
	1393	1164	0.005207	0.012231	0.002452	114	114	114	0	0	1	-360	360	11.0264	-0.0435	-11.0210	-0.2284	0.0000	0.0000	0.0000	0.0000;
	1074	1571	0.015207	0.040083	0.004366	120	120	120	0	0	1	-360	360	7.2025	-1.4745	-7.1955	0.9857	0.0000	0.0000	0.0000	0.0000;
	1613	1374	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-13.0082	-5.2176	13.0160	5.0553	0.0000	0.0000	0.0000	0.0000;
	1455	1077	0.010909	0.035289	0.003691	114	114	114	0	0	1	-360	360	-9.6130	1.5513	9.6221	-1.9429	0.0000	0.0000	0.0000	0.0000;
	1527	1456	0.031901	0.106364	0.011251	114	114	114	0	0	1	-360	360	-4.2089	-1.2501	4.2139	-0.0140	0.0000	0.0000	0.0000	0.0000;
	1330	1376	0.001653	0.011157	0.001239	152	152	152	0	0	1	-360	360	-42.5502	2.9687	42.5762	-2.9370	0.0000	0.0000	0.0000	0.0000;
	1448	1305	0.006529	0.020909	0.002214	114	114	114	0	0	1	-360	360	0.5380	0.6714	-0.5379	-0.9227	0.0000	0.0000	0.0000	0.0000;
	1528	1306	0.021984	0.070744	0.007439	114	114	114	0	0	1	-360	360	0.7609	-0.0029	-0.7607	-0.8419	0.0000	0.0000	0.0000	0.0000;
	1775	1690	0.045124	0.233802	0.024389	114	114	114	0	0	1	-360	360	-11.2781	-4.7094	11.3320	2.1331	0.0000	0.0000	0.0000	0.0000;
	1775	1684	0.045703	0.237025	0.024841	114	114	114	0	0	1	-360	360	-13.6659	-4.5294	13.7434	2.0209	0.0000	0.0000	0.0000	0.0000;
	1394	1161	0.000826	0.002645	0.000312	140	140	140	0	0	1	-360	360	15.8589	3.5275	-15.8570	-3.5580	0.0000	0.0000	0.0000	0.0000;
	1635	998	0.004298	0.00719	0.01602	120	120	120	0	0	1	-360	360	-25.0614	4.6900	25.0859	-6.5033	0.0000	0.0000	0.0000	0.0000;
	1774	1181	0.058099	0.13124	0.012928	90	90	90	0	0	1	-360	360	5.4734	3.1950	-5.4505	-4.6288	0.0000	0.0000	0.0000	0.0000;
	1375	1557	0.003884	0.012562	0.001326	114	114	114	0	0	1	-360	360	32.2272	1.1633	-32.1928	-1.2070	0.0000	0.0000	0.0000	0.0000;
	1385	1571	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-5.7390	1.4120	5.7395	-1.4103	0.0000	0.0000	0.0000	0.0000;
	1386	1572	0.001653	0.005793	0	97	97	97	0	0	1	-360	360	-12.6320	2.8960	12.6344	-2.8877	0.0000	0.0000	0.0000	0.0000;
	883	904	0.003967	0.012149	0.001391	114	114	114	0	0	1	-360	360	14.4633	-2.3609	-14.4558	2.2250	0.0000	0.0000	0.0000	0.0000;
	1576	1394	0.018017	0.054793	0.006483	114	114	114	0	0	1	-360	360	-26.1965	1.0539	26.3034	-1.4835	0.0000	0.0000	0.0000	0.0000;
	1844	1464	0.017851	0.03438	0.004874	90	90	90	0	0	1	-360	360	25.3802	-0.1184	-25.2798	-0.2446	0.0000	0.0000	0.0000	0.0000;
	1536	955	0.006777	0.01595	0.002253	114	114	114	0	0	1	-360	360	17.6385	0.8053	-17.6203	-1.0241	0.0000	0.0000	0.0000	0.0000;
	1303	1462	0.006612	0.021074	0.002294	97	97	97	0	0	1	-360	360	-22.4015	-0.2884	22.4299	0.1112	0.0000	0.0000	0.0000	0.0000;
	1852	1892	0.02	0.056529	0.005397	120	120	120	0	0	1	-360	360	40.5903	-3.5357	-40.3130	3.6779	0.0000	0.0000	0.0000	0.0000;
	998	1329	0.000579	0.003884	0.000452	152	152	152	0	0	1	-360	360	-37.7189	3.5853	37.7261	-3.5896	0.0000	0.0000	0.0000	0.0000;
	1308	1393	0.043719	0.115041	0.011948	120	120	120	0	0	1	-360	360	37.3877	-4.7948	-36.8650	4.7696	0.0000	0.0000	0.0000	0.0000;
	1447	1748	0.032562	0.104628	0.011026	114	114	114	0	0	1	-360	360	-2.4900	-0.9734	2.4918	-0.2747	0.0000	0.0000	0.0000	0.0000;
	1078	1304	0.049422	0.164628	0.016129	114	114	114	0	0	1	-360	360	-22.1879	-1.3617	22.4011	0.2108	0.0000	0.0000	0.0000	0.0000;
	1009	1763	0.011735	0.03562	0.004228	114	114	114	0	0	1	-360	360	-37.5528	-7.9548	37.7023	7.9177	0.0000	0.0000	0.0000	0.0000;
	1274	1634	0.002645	0.008264	0.0009	120	120	120	0	0	1	-360	360	-3.2130	-0.0590	3.2132	-0.0444	0.0000	0.0000	0.0000	0.0000;
	1790	1764	0.010578	0.029091	0.003349	114	114	114	0	0	1	-360	360	1.8240	10.1527	-1.8139	-10.5102	0.0000	0.0000	0.0000	0.0000;
	1764	862	0.005207	0.015785	0.001868	140	140	140	0	0	1	-360	360	12.6296	2.7799	-12.6220	-2.9710	0.0000	0.0000	0.0000	0.0000;
	1765	842	0.00157	0.001983	0.00037	90	90	90	0	0	1	-360	360	0.0000	0.0316	-0.0000	-0.0740	0.0000	0.0000	0.0000	0.0000;
	1764	843	0.001488	0.001818	0.000353	90	90	90	0	0	1	-360	360	0.0000	-0.0405	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1765	844	0.000496	0.000579	0.000111	90	90	90	0	0	1	-360	360	39.0200	18.3126	-39.0120	-18.3160	0.0000	0.0000	0.0000	0.0000;
	1765	845	0.001074	0.001322	0.000252	90	90	90	0	0	1	-360	360	-30.0116	-0.0385	30.0200	0.0200	0.0000	0.0000	0.0000	0.0000;
	1791	1765	0.009917	0.030331	0.003557	102	102	102	0	0	1	-360	360	-15.3882	16.4071	15.4323	-16.6812	0.0000	0.0000	0.0000	0.0000;
	930	1862	0.023141	0.028926	0.005498	77	77	77	0	0	1	-360	360	-4.9663	4.0853	4.9754	-4.6930	0.0000	0.0000	0.0000	0.0000;
	1255	1349	0.022149	0.04281	0.008245	102	102	102	0	0	1	-360	360	30.9776	4.7386	-30.7870	-5.3081	0.0000	0.0000	0.0000	0.0000;
	874	931	0.020827	0.026446	0.004884	77	77	77	0	0	1	-360	360	10.2345	4.6793	-10.2107	-5.2007	0.0000	0.0000	0.0000	0.0000;
	1011	874	0.018512	0.058347	0.006326	90	90	90	0	0	1	-360	360	12.4445	4.5580	-12.4155	-5.1865	0.0000	0.0000	0.0000	0.0000;
	872	874	0.000496	0.000826	8.7e-05	90	90	90	0	0	1	-360	360	-2.1810	-0.5170	2.1810	0.5072	0.0000	0.0000	0.0000	0.0000;
	1764	1255	0.006942	0.019091	0.001938	102	102	102	0	0	1	-360	360	-13.6857	7.3279	13.7004	-7.5099	0.0000	0.0000	0.0000	0.0000;
	1786	1255	0.00686	0.010165	0.001747	76	76	76	0	0	1	-360	360	-16.0109	6.2917	16.0287	-6.4656	0.0000	0.0000	0.0000	0.0000;
	1120	1862	0.000496	0.00157	0.000186	57	57	57	0	0	1	-360	360	-8.8350	-5.5710	8.8355	5.5516	0.0000	0.0000	0.0000	0.0000;
	1790	1601	0.005702	0.018512	0.001909	114	114	114	0	0	1	-360	360	-1.9808	10.2431	1.9863	-10.4453	0.0000	0.0000	0.0000	0.0000;
	1790	873	0.021322	0.06843	0.007265	77	77	77	0	0	1	-360	360	2.2960	-0.8349	-2.2950	0.0000	0.0000	0.0000	0.0000	0.0000;
	1742	1360	0.002562	0.005868	0.000794	57	57	57	0	0	1	-360	360	-10.3270	-2.2290	10.3296	2.1468	0.0000	0.0000	0.0000	0.0000;
	1743	1361	0.001983	0.005041	0.000649	57	57	57	0	0	1	-360	360	-8.0320	-1.4860	8.0332	1.4171	0.0000	0.0000	0.0000	0.0000;
	1121	1863	0.000579	0.001818	0.00022	57	57	57	0	0	1	-360	360	-0.6880	-0.0000	0.6880	-0.0248	0.0000	0.0000	0.0000	0.0000;
	1863	1338	0.005124	0.01562	0.001849	114	114	114	0	0	1	-360	360	-1.0889	-0.1154	1.0889	-0.0926	0.0000	0.0000	0.0000	0.0000;
	1474	1561	0.003636	0.011074	0.001314	114	114	114	0	0	1	-360	360	-0.5367	-9.9006	0.5397	9.7591	0.0000	0.0000	0.0000	0.0000;
	1791	1562	0.00595	0.019917	0.001953	114	114	114	0	0	1	-360	360	2.1513	9.9333	-2.1458	-10.1399	0.0000	0.0000	0.0000	0.0000;
	1245	1360	0.01	0.016529	0.001783	76	76	76	0	0	1	-360	360	28.8081	-3.5854	-28.7325	3.5120	0.0000	0.0000	0.0000	0.0000;
	1591	1244	0.023388	0.032562	0.005065	77	77	77	0	0	1	-360	360	42.6259	-0.1015	-42.2512	0.0538	0.0000	0.0000	0.0000	0.0000;
	1602	1088	0.006612	0.021488	0.002222	114	114	114	0	0	1	-360	360	-14.5044	6.3994	14.5189	-6.6076	0.0000	0.0000	0.0000	0.0000;
	1254	1581	0.003636	0.011074	0.001317	114	114	114	0	0	1	-360	360	22.9331	-3.8351	-22.9160	3.7358	0.0000	0.0000	0.0000	0.0000;
	1254	1460	0.008017	0.024215	0.00287	76	76	76	0	0	1	-360	360	5.2809	-0.6368	-5.2789	0.3126	0.0000	0.0000	0.0000	0.0000;
	1498	1459	0.012645	0.037025	0.003359	102	102	102	0	0	1	-360	360	1.3939	2.2028	-1.3931	-2.5868	0.0000	0.0000	0.0000	0.0000;
	1582	1087	0.005868	0.017851	0.00212	114	114	114	0	0	1	-360	360	17.8648	-5.2235	-17.8471	5.0334	0.0000	0.0000	0.0000	0.0000;
	1255	1661	0.027355	0.092066	0.008835	114	114	114	0	0	1	-360	360	3.4541	0.5511	-3.4510	-1.5520	0.0000	0.0000	0.0000	0.0000;
	1094	1499	0.001736	0.005124	0.000472	102	102	102	0	0	1	-360	360	3.1162	2.2201	-3.1159	-2.2738	0.0000	0.0000	0.0000	0.0000;
	1653	1094	0.02157	0.061322	0.005	102	102	102	0	0	1	-360	360	8.3003	3.3807	-8.2850	-3.9153	0.0000	0.0000	0.0000	0.0000;
	1094	1093	0.003141	0.003884	0.000745	57	57	57	0	0	1	-360	360	5.1688	1.6951	-5.1680	-1.7800	0.0000	0.0000	0.0000	0.0000;
	1806	1790	0.011901	0.037686	0.00409	114	114	114	0	0	1	-360	360	-23.9173	-6.6009	23.9811	6.3331	0.0000	0.0000	0.0000	0.0000;
	1765	1254	0.006777	0.020579	0.001953	102	102	102	0	0	1	-360	360	-24.4407	-1.6245	24.4762	1.5079	0.0000	0.0000	0.0000	0.0000;
	1350	1360	0.025289	0.04719	0.009431	102	102	102	0	0	1	-360	360	28.4894	4.3990	-28.3021	-5.1048	0.0000	0.0000	0.0000	0.0000;
	1787	1473	0.003141	0.009504	0.00113	114	114	114	0	0	1	-360	360	10.2638	-7.3788	-10.2594	7.2625	0.0000	0.0000	0.0000	0.0000;
	959	1791	0.034298	0.109421	0.011715	114	114	114	0	0	1	-360	360	-19.0362	-4.5742	19.1507	3.6013	0.0000	0.0000	0.0000	0.0000;
	1791	1012	0.014545	0.045785	0.005055	114	114	114	0	0	1	-360	360	15.3562	5.8501	-15.3217	-6.3220	0.0000	0.0000	0.0000	0.0000;
	1790	1488	0.019587	0.062975	0.006621	119	119	119	0	0	1	-360	360	-2.7634	0.0997	2.7648	-0.8596	0.0000	0.0000	0.0000	0.0000;
	1838	1171	0.003554	0.011157	0.001258	140	140	140	0	0	1	-360	360	93.5883	21.1457	-93.3230	-20.4670	0.0000	0.0000	0.0000	0.0000;
	1276	1368	0.001983	0.006364	0.000668	114	114	114	0	0	1	-360	360	64.1881	15.4869	-64.1155	-15.3337	0.0000	0.0000	0.0000	0.0000;
	1359	1288	0.000909	0.006446	0.000665	152	152	152	0	0	1	-360	360	-41.6687	-15.9375	41.6839	15.9659	0.0000	0.0000	0.0000	0.0000;
	1626	1359	0.004298	0.030083	0.003228	232	232	232	0	0	1	-360	360	-28.1768	-12.8447	28.2116	12.7055	0.0000	0.0000	0.0000	0.0000;
	1357	1359	0.003141	0.005868	0.000559	90	90	90	0	0	1	-360	360	-13.4520	-3.2890	13.4571	3.2320	0.0000	0.0000	0.0000	0.0000;
	1597	1414	0.009587	0.02595	0.002885	120	120	120	0	0	1	-360	360	-4.2900	1.5000	4.2917	-1.8334	0.0000	0.0000	0.0000	0.0000;
	910	884	0.010413	0.03157	0.003734	140	140	140	0	0	1	-360	360	-1.6060	-0.1490	1.6062	-0.3013	0.0000	0.0000	0.0000	0.0000;
	1627	1801	0.002645	0.007934	0.000941	140	140	140	0	0	1	-360	360	29.6513	0.6106	-29.6314	-0.6616	0.0000	0.0000	0.0000	0.0000;
	911	885	0.010083	0.030579	0.00362	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.4374	0.0000	0.0000	0.0000	0.0000;
	1631	1872	0.012314	0.03157	0.003463	120	120	120	0	0	1	-360	360	-3.0632	10.2844	3.0756	-10.6611	0.0000	0.0000	0.0000	0.0000;
	1566	1452	0.001901	0.006033	0.000632	114	114	114	0	0	1	-360	360	-8.9390	-3.0670	8.9405	2.9978	0.0000	0.0000	0.0000	0.0000;
	1737	1566	0.003554	0.011488	0.001205	114	114	114	0	0	1	-360	360	-0.8992	-1.6459	0.8993	1.5056	0.0000	0.0000	0.0000	0.0000;
	1566	1564	0.001322	0.003223	0.000322	90	90	90	0	0	1	-360	360	8.0398	1.5613	-8.0390	-1.5970	0.0000	0.0000	0.0000	0.0000;
	928	1045	0.003471	0.011074	0.001159	140	140	140	0	0	1	-360	360	15.1699	1.7062	-15.1630	-1.8200	0.0000	0.0000	0.0000	0.0000;
	929	1046	0.003388	0.011074	0.001154	140	140	140	0	0	1	-360	360	0.0000	-0.1375	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1838	1377	0.009421	0.029917	0.003214	140	140	140	0	0	1	-360	360	34.5428	9.1901	-34.4449	-9.2737	0.0000	0.0000	0.0000	0.0000;
	1643	1472	0.007107	0.022066	0.002517	140	140	140	0	0	1	-360	360	-17.2411	-0.8004	17.2587	0.5505	0.0000	0.0000	0.0000	0.0000;
	1620	1643	0.000992	0.003058	0.000351	114	114	114	0	0	1	-360	360	-16.4359	-0.6656	16.4381	0.6300	0.0000	0.0000	0.0000	0.0000;
	1642	1643	0.00124	0.003636	0.000436	140	140	140	0	0	1	-360	360	-0.8030	-0.2230	0.8030	0.1704	0.0000	0.0000	0.0000	0.0000;
	1412	988	0.000826	0.002479	0.000295	140	140	140	0	0	1	-360	360	10.5518	0.0521	-10.5510	-0.0844	0.0000	0.0000	0.0000	0.0000;
	1066	1068	0.001818	0.005455	0.000651	29	29	29	0	0	1	-360	360	-1.3770	-0.2230	1.3770	0.1465	0.0000	0.0000	0.0000	0.0000;
	1552	1207	0.003223	0.010413	0.001079	140	140	140	0	0	1	-360	360	-31.6714	3.3913	31.6993	-3.4280	0.0000	0.0000	0.0000	0.0000;
	1617	1552	0.003719	0.011735	0.001309	140	140	140	0	0	1	-360	360	-25.2144	5.4252	25.2355	-5.5122	0.0000	0.0000	0.0000	0.0000;
	1550	1552	0.002397	0.00719	0.00075	120	120	120	0	0	1	-360	360	-6.4350	-2.2060	6.4359	2.1208	0.0000	0.0000	0.0000	0.0000;
	1760	987	0.01281	0.039008	0.004576	140	140	140	0	0	1	-360	360	0.6945	1.6825	-0.6940	-2.2189	0.0000	0.0000	0.0000	0.0000;
	1922	1287	0.011983	0.038595	0.004056	140	140	140	0	0	1	-360	360	-40.2423	-6.8977	40.4039	6.9145	0.0000	0.0000	0.0000	0.0000;
	1114	1059	0.004959	0.016694	0.001597	140	140	140	0	0	1	-360	360	5.1642	1.3757	-5.1630	-1.5600	0.0000	0.0000	0.0000	0.0000;
	1114	1060	0.001074	0.003397	0	140	140	140	0	0	1	-360	360	3.9011	0.5204	-3.9010	-0.5200	0.0000	0.0000	0.0000	0.0000;
	1708	1683	0.003388	0.011488	0.001096	140	140	140	0	0	1	-360	360	-26.1544	-6.1156	26.1745	6.0510	0.0000	0.0000	0.0000	0.0000;
	1310	1777	0.000165	0.000496	6.1e-05	140	140	140	0	0	1	-360	360	9.0551	4.8085	-9.0550	-4.8152	0.0000	0.0000	0.0000	0.0000;
	1415	1310	0.005289	0.016198	0.001854	140	140	140	0	0	1	-360	360	9.0598	4.5271	-9.0551	-4.7298	0.0000	0.0000	0.0000	0.0000;
	1309	1310	0.004215	0.007603	0.000673	90	90	90	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0787	0.0000	0.0000	0.0000	0.0000;
	867	1543	0.010992	0.027851	0.003979	120	120	120	0	0	1	-360	360	30.2640	13.2860	-30.1613	-13.4908	0.0000	0.0000	0.0000	0.0000;
	867	1757	0.005785	0.020496	0.002033	114	114	114	0	0	1	-360	360	-30.2640	-13.2746	30.3175	13.2245	0.0000	0.0000	0.0000	0.0000;
	866	867	0.000248	0.000826	9.7e-05	140	140	140	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0114	0.0000	0.0000	0.0000	0.0000;
	925	1114	0.000413	0.00124	0.000133	114	114	114	0	0	1	-360	360	-10.7986	-2.4771	10.7990	2.4627	0.0000	0.0000	0.0000	0.0000;
	937	925	0.002727	0.007686	0.000794	120	120	120	0	0	1	-360	360	-10.7957	-2.6161	10.7986	2.5305	0.0000	0.0000	0.0000	0.0000;
	1106	937	0.00438	0.014132	0.001486	114	114	114	0	0	1	-360	360	-10.7911	-2.9046	10.7957	2.7445	0.0000	0.0000	0.0000	0.0000;
	1270	1106	0.000331	0.001074	0.000123	114	114	114	0	0	1	-360	360	-3.5570	-1.4110	3.5570	1.3966	0.0000	0.0000	0.0000	0.0000;
	923	925	0.00124	0.003884	0.000452	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0534	0.0000	0.0000	0.0000	0.0000;
	937	936	0.003388	0.011405	0.001089	114	114	114	0	0	1	-360	360	0.0000	-0.1284	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1104	1106	0.002231	0.006942	0.000784	114	114	114	0	0	1	-360	360	-7.2330	-1.5970	7.2340	1.5080	0.0000	0.0000	0.0000	0.0000;
	1425	1835	0.005289	0.016116	0.001871	140	140	140	0	0	1	-360	360	-10.9815	0.3083	10.9869	-0.5122	0.0000	0.0000	0.0000	0.0000;
	1872	1425	0.002397	0.007273	0.000835	140	140	140	0	0	1	-360	360	-10.9790	0.1890	10.9815	-0.2799	0.0000	0.0000	0.0000	0.0000;
	1425	1424	0.000992	0.00124	0.000242	90	90	90	0	0	1	-360	360	0.0000	-0.0285	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1043	1258	0.004959	0.015124	0.001793	140	140	140	0	0	1	-360	360	-2.5252	-0.3338	2.5254	0.1137	0.0000	0.0000	0.0000	0.0000;
	1717	1580	0.002314	0.007355	0.000784	140	140	140	0	0	1	-360	360	-49.7144	-3.2286	49.7632	3.2913	0.0000	0.0000	0.0000	0.0000;
	1199	1641	0.008182	0.020331	0.002188	120	120	120	0	0	1	-360	360	-26.5593	-4.1533	26.6090	4.0166	0.0000	0.0000	0.0000	0.0000;
	1849	1199	0.004711	0.011735	0.001341	120	120	120	0	0	1	-360	360	-24.2404	-3.7238	24.2643	3.6244	0.0000	0.0000	0.0000	0.0000;
	1197	1199	0.000909	0.002066	0.000237	120	120	120	0	0	1	-360	360	-2.2950	-0.5570	2.2950	0.5289	0.0000	0.0000	0.0000	0.0000;
	1633	850	0.006529	0.020661	0.002234	140	140	140	0	0	1	-360	360	44.1424	-1.2642	-44.0343	1.3438	0.0000	0.0000	0.0000	0.0000;
	1802	1282	0.012314	0.041653	0.003976	140	140	140	0	0	1	-360	360	23.4340	-0.6059	-23.3763	0.3360	0.0000	0.0000	0.0000	0.0000;
	948	1631	0.025868	0.067107	0.007543	120	120	120	0	0	1	-360	360	-17.0805	-3.8459	17.1476	3.1330	0.0000	0.0000	0.0000	0.0000;
	1526	976	0.004959	0.015124	0.001769	140	140	140	0	0	1	-360	360	-25.6447	-6.1891	25.6734	6.0638	0.0000	0.0000	0.0000	0.0000;
	1546	1907	0.001405	0.003471	0.000506	120	120	120	0	0	1	-360	360	18.5633	5.4384	-18.5589	-5.4866	0.0000	0.0000	0.0000	0.0000;
	1847	1231	0.004132	0.012975	0.00144	140	140	140	0	0	1	-360	360	11.4109	5.7228	-11.4052	-5.8759	0.0000	0.0000	0.0000	0.0000;
	1836	1671	0.017603	0.056281	0.005973	140	140	140	0	0	1	-360	360	55.6988	5.8361	-55.2470	-5.1151	0.0000	0.0000	0.0000	0.0000;
	1589	929	0.006364	0.020165	0.002188	114	114	114	0	0	1	-360	360	-14.7959	-4.0547	14.8084	3.8342	0.0000	0.0000	0.0000	0.0000;
	920	1543	0.008595	0.027603	0.002909	140	140	140	0	0	1	-360	360	40.2168	7.9162	-40.0935	-7.8597	0.0000	0.0000	0.0000	0.0000;
	1837	1544	0.026198	0.08405	0.008869	114	114	114	0	0	1	-360	360	48.0666	16.3737	-47.5054	-15.6252	0.0000	0.0000	0.0000	0.0000;
	1682	979	0.006364	0.02124	0.002072	140	140	140	0	0	1	-360	360	-30.7652	-7.5438	30.8177	7.4667	0.0000	0.0000	0.0000	0.0000;
	1631	1347	0.019752	0.052975	0.005779	120	120	120	0	0	1	-360	360	20.1546	4.1683	-20.0833	-4.6571	0.0000	0.0000	0.0000	0.0000;
	1816	1347	0.001901	0.005868	0.00069	114	114	114	0	0	1	-360	360	-18.4715	-4.2447	18.4773	4.1821	0.0000	0.0000	0.0000	0.0000;
	1145	1816	0.002645	0.008678	0.000895	114	114	114	0	0	1	-360	360	-18.4634	-4.3246	18.4715	4.2467	0.0000	0.0000	0.0000	0.0000;
	1815	1816	8.3e-05	0.000165	1.7e-05	90	90	90	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0020	0.0000	0.0000	0.0000	0.0000;
	1259	1838	0.011735	0.037107	0.004029	114	114	114	0	0	1	-360	360	-6.5465	-0.2360	6.5506	-0.2477	0.0000	0.0000	0.0000	0.0000;
	895	1018	0.00562	0.017355	0.001943	120	120	120	0	0	1	-360	360	26.1710	-6.2953	-26.1363	6.1753	0.0000	0.0000	0.0000	0.0000;
	1877	996	0.001901	0.006198	0.000651	114	114	114	0	0	1	-360	360	-11.4538	-3.4807	11.4561	3.4104	0.0000	0.0000	0.0000	0.0000;
	1596	1877	0.003802	0.011983	0.001283	140	140	140	0	0	1	-360	360	-9.1540	-2.2698	9.1568	2.1257	0.0000	0.0000	0.0000	0.0000;
	929	1596	0.002645	0.008182	0.000946	114	114	114	0	0	1	-360	360	-7.4316	-2.1345	7.4329	2.0258	0.0000	0.0000	0.0000	0.0000;
	1875	1877	8.3e-05	0.000165	1.7e-05	140	140	140	0	0	1	-360	360	-2.2970	-1.3570	2.2970	1.3550	0.0000	0.0000	0.0000	0.0000;
	1596	1595	0.00124	0.003802	0.000445	57	57	57	0	0	1	-360	360	1.7210	0.2440	-1.7210	-0.2970	0.0000	0.0000	0.0000	0.0000;
	1368	1476	0.002397	0.007438	0.000859	114	114	114	0	0	1	-360	360	45.4756	11.5681	-45.4312	-11.5321	0.0000	0.0000	0.0000	0.0000;
	1829	941	0.004132	0.013306	0.001411	114	114	114	0	0	1	-360	360	-2.6374	-3.9919	2.6381	3.8273	0.0000	0.0000	0.0000	0.0000;
	975	1829	0.007107	0.023058	0.002403	140	140	140	0	0	1	-360	360	6.3227	-1.3637	-6.3202	1.0873	0.0000	0.0000	0.0000	0.0000;
	1828	1829	0.000744	0.002397	0.000264	114	114	114	0	0	1	-360	360	-8.9570	-2.9340	8.9576	2.9046	0.0000	0.0000	0.0000	0.0000;
	1857	1008	0.000909	0.00281	0.000319	114	114	114	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0382	0.0000	0.0000	0.0000	0.0000;
	1232	1008	0.003141	0.013306	0.001379	162	162	162	0	0	1	-360	360	-0.5023	-3.0991	0.5026	2.9350	0.0000	0.0000	0.0000	0.0000;
	908	1232	0.000413	0.00124	0.000131	140	140	140	0	0	1	-360	360	-8.6110	-1.5970	8.6113	1.5822	0.0000	0.0000	0.0000	0.0000;
	909	1233	0.000413	0.001322	0.000135	140	140	140	0	0	1	-360	360	-4.5910	-0.8540	4.5911	0.8383	0.0000	0.0000	0.0000	0.0000;
	1203	1007	0.000661	0.002562	0.0003	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0359	0.0000	0.0000	0.0000	0.0000;
	1363	1890	0.012893	0.046446	0.004487	114	114	114	0	0	1	-360	360	26.7665	13.3053	-26.6704	-13.4967	0.0000	0.0000	0.0000	0.0000;
	1432	1524	0.019422	0.062397	0.006585	114	114	114	0	0	1	-360	360	46.2540	16.8740	-45.8536	-16.3535	0.0000	0.0000	0.0000	0.0000;
	1523	1543	0.020827	0.067025	0.007069	140	140	140	0	0	1	-360	360	-20.2420	-7.5086	20.3258	6.9635	0.0000	0.0000	0.0000	0.0000;
	1821	1415	0.001736	0.004959	0.00053	120	120	120	0	0	1	-360	360	-10.3106	0.9726	10.3122	-1.0302	0.0000	0.0000	0.0000	0.0000;
	1115	968	0.007603	0.023141	0.002713	140	140	140	0	0	1	-360	360	-13.9269	0.8487	13.9392	-1.1384	0.0000	0.0000	0.0000	0.0000;
	1647	1287	0.001736	0.005372	0.000634	140	140	140	0	0	1	-360	360	-0.2290	0.0000	0.2290	-0.0792	0.0000	0.0000	0.0000	0.0000;
	1044	1911	0.004132	0.012645	0.001498	140	140	140	0	0	1	-360	360	2.2962	0.3501	-2.2960	-0.5340	0.0000	0.0000	0.0000	0.0000;
	1324	857	0.012479	0.039669	0.004279	140	140	140	0	0	1	-360	360	12.0545	-0.2800	-12.0394	-0.1862	0.0000	0.0000	0.0000	0.0000;
	1191	1062	0.003471	0.010661	0.001246	140	140	140	0	0	1	-360	360	-1.4921	-0.4150	1.4921	0.2686	0.0000	0.0000	0.0000	0.0000;
	1731	1191	0.003636	0.013388	0.001203	140	140	140	0	0	1	-360	360	-1.4920	-0.5570	1.4921	0.4159	0.0000	0.0000	0.0000	0.0000;
	1189	1191	0	0.000826	7e-06	140	140	140	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.0009	0.0000	0.0000	0.0000	0.0000;
	1512	1921	0.004711	0.015289	0.001605	140	140	140	0	0	1	-360	360	-32.7356	-4.3386	32.7774	4.2765	0.0000	0.0000	0.0000	0.0000;
	1780	1233	0.004463	0.012893	0.001735	140	140	140	0	0	1	-360	360	-5.3139	-4.1689	5.3156	3.9692	0.0000	0.0000	0.0000	0.0000;
	1363	1481	0.027686	0.071488	0.007393	120	120	120	0	0	1	-360	360	33.5628	7.2099	-33.2912	-7.3911	0.0000	0.0000	0.0000	0.0000;
	856	1507	0.000826	0.002645	0.000305	140	140	140	0	0	1	-360	360	5.7372	1.0782	-5.7370	-1.1140	0.0000	0.0000	0.0000	0.0000;
	857	1508	0.000826	0.002645	0.00031	140	140	140	0	0	1	-360	360	3.7861	0.7801	-3.7860	-0.8170	0.0000	0.0000	0.0000	0.0000;
	1872	1882	0.005537	0.016942	0.00196	140	140	140	0	0	1	-360	360	-3.6246	3.8230	3.6259	-4.0495	0.0000	0.0000	0.0000	0.0000;
	1586	1641	0.006116	0.016612	0.001842	120	120	120	0	0	1	-360	360	-23.4747	-5.9200	23.5048	5.7825	0.0000	0.0000	0.0000	0.0000;
	1503	1543	0.003141	0.009421	0.001118	140	140	140	0	0	1	-360	360	-30.3974	-4.7828	30.4230	4.7300	0.0000	0.0000	0.0000	0.0000;
	858	1585	0.000744	0.002314	0.000254	114	114	114	0	0	1	-360	360	-5.1650	-3.0670	5.1652	3.0375	0.0000	0.0000	0.0000	0.0000;
	859	1586	0.000661	0.002149	0.000237	114	114	114	0	0	1	-360	360	-3.4420	-1.4860	3.4421	1.4581	0.0000	0.0000	0.0000	0.0000;
	1089	1670	0.000331	0.000992	0.000121	114	114	114	0	0	1	-360	360	-5.7370	-0.7430	5.7371	0.7288	0.0000	0.0000	0.0000	0.0000;
	1090	1671	0.000331	0.000992	0.000119	114	114	114	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0142	0.0000	0.0000	0.0000	0.0000;
	1280	856	0.000331	0.000992	0.000114	114	114	114	0	0	1	-360	360	-7.3430	-1.9170	7.3432	1.9038	0.0000	0.0000	0.0000	0.0000;
	1281	857	0.000413	0.001322	0.000157	114	114	114	0	0	1	-360	360	-1.3780	-0.2900	1.3780	0.2711	0.0000	0.0000	0.0000	0.0000;
	1733	1760	0.004298	0.013306	0.001496	114	114	114	0	0	1	-360	360	-1.1470	-0.3710	1.1471	0.1953	0.0000	0.0000	0.0000	0.0000;
	1037	1043	0.000165	0.000579	6.5e-05	114	114	114	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0080	0.0000	0.0000	0.0000	0.0000;
	1038	1044	0.000165	0.000579	6.8e-05	114	114	114	0	0	1	-360	360	-0.2290	-0.0000	0.2290	-0.0083	0.0000	0.0000	0.0000	0.0000;
	1030	1007	0.000661	0.002149	0.000215	114	114	114	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0258	0.0000	0.0000	0.0000	0.0000;
	1031	1008	0.000661	0.002066	0.00021	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0252	0.0000	0.0000	0.0000	0.0000;
	1232	996	0.003554	0.011405	0.001183	114	114	114	0	0	1	-360	360	15.7161	4.7858	-15.7081	-4.9014	0.0000	0.0000	0.0000	0.0000;
	1797	1795	0.004132	0.013306	0.001396	114	114	114	0	0	1	-360	360	20.2063	-0.7273	-20.1925	0.6009	0.0000	0.0000	0.0000	0.0000;
	1339	1839	0.001488	0.004959	0.000469	114	114	114	0	0	1	-360	360	0.0000	-0.1180	0.0000	0.0620	0.0000	0.0000	0.0000	0.0000;
	1925	1382	0.000744	0.002479	0.000286	114	114	114	0	0	1	-360	360	4.9743	3.7989	-4.9741	-3.8319	0.0000	0.0000	0.0000	0.0000;
	1230	1925	0.00438	0.013554	0.001541	140	140	140	0	0	1	-360	360	5.8941	3.6088	-5.8923	-3.7860	0.0000	0.0000	0.0000	0.0000;
	1923	1925	0.000331	0.000909	0.000109	114	114	114	0	0	1	-360	360	-0.9180	-0.0000	0.9180	-0.0129	0.0000	0.0000	0.0000	0.0000;
	928	1380	0.004876	0.01719	0.001917	114	114	114	0	0	1	-360	360	-7.1054	-6.2354	7.1091	6.0233	0.0000	0.0000	0.0000	0.0000;
	1991	2103	0.000636	0.004826	0.000469	123	123	123	0	0	1	-360	360	-42.4589	-3.6201	42.4681	3.6311	0.0000	0.0000	0.0000	0.0000;
	2307	2167	0.033471	0.058934	0.005779	78	78	78	0	0	1	-360	360	-0.0866	-3.5131	0.0895	2.8395	0.0000	0.0000	0.0000	0.0000;
	2434	2167	0.029587	0.054711	0.005031	78	78	78	0	0	1	-360	360	4.0815	2.4155	-4.0755	-2.9975	0.0000	0.0000	0.0000	0.0000;
	2434	2168	0.033058	0.058603	0.005571	78	78	78	0	0	1	-360	360	-8.0595	-2.4295	8.0789	1.8035	0.0000	0.0000	0.0000	0.0000;
	2272	2180	0.048016	0.102636	0.013441	55	55	55	0	0	1	-360	360	-3.9625	3.8186	3.9773	-5.4036	0.0000	0.0000	0.0000	0.0000;
	2180	1943	0.013802	0.024207	0.002299	55	55	55	0	0	1	-360	360	-7.0713	4.5746	7.0796	-4.8359	0.0000	0.0000	0.0000	0.0000;
	1995	1988	0.056364	0.105207	0.01021	78	78	78	0	0	1	-360	360	8.4171	-5.4861	-8.3720	4.3639	0.0000	0.0000	0.0000	0.0000;
	2380	2038	0.058934	0.123967	0.011969	78	78	78	0	0	1	-360	360	-16.6933	4.8932	16.8510	-5.9514	0.0000	0.0000	0.0000	0.0000;
	1990	1979	0.021744	0.05	0.005009	76	76	76	0	0	1	-360	360	4.6208	2.4937	-4.6155	-3.0782	0.0000	0.0000	0.0000	0.0000;
	2136	1979	0.034711	0.067438	0.006631	76	76	76	0	0	1	-360	360	0.6947	-3.6109	-0.6915	2.8302	0.0000	0.0000	0.0000	0.0000;
	1989	1938	0.019711	0.06676	0.006609	120	120	120	0	0	1	-360	360	-15.6409	-7.5787	15.6903	6.9596	0.0000	0.0000	0.0000	0.0000;
	2274	2437	0.03843	0.06562	0.006609	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2316	1945	0.02486	0.043479	0.00415	120	120	120	0	0	1	-360	360	-1.4730	0.3960	1.4735	-0.9035	0.0000	0.0000	0.0000	0.0000;
	2395	2316	0.022628	0.03957	0.00378	120	120	120	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.4630	0.0000	0.0000	0.0000	0.0000;
	2282	1981	0.022281	0.075446	0.00747	123	123	123	0	0	1	-360	360	-26.5943	0.2276	26.7270	-0.6703	0.0000	0.0000	0.0000	0.0000;
	2317	1986	0.025207	0.082636	0.00847	123	123	123	0	0	1	-360	360	-19.1782	3.9317	19.2584	-4.7012	0.0000	0.0000	0.0000	0.0000;
	2310	2346	0.020661	0.06686	0.006921	82	82	82	0	0	1	-360	360	-2.5797	3.9772	2.5842	-4.7934	0.0000	0.0000	0.0000	0.0000;
	2126	2174	0.059669	0.104554	0.009951	59	59	59	0	0	1	-360	360	-17.2138	4.8158	17.3795	-5.6971	0.0000	0.0000	0.0000	0.0000;
	1961	2445	0.027107	0.046124	0.00445	78	78	78	0	0	1	-360	360	-28.6468	12.3368	28.8775	-12.4573	0.0000	0.0000	0.0000	0.0000;
	2302	2445	0.033661	0.114017	0.011289	123	123	123	0	0	1	-360	360	-21.8575	5.7760	22.0089	-6.5665	0.0000	0.0000	0.0000	0.0000;
	2425	2193	0.024132	0.078512	0.008199	123	123	123	0	0	1	-360	360	10.4262	-1.9998	-10.4040	1.0826	0.0000	0.0000	0.0000	0.0000;
	1995	1993	0.018347	0.062562	0.00605	123	123	123	0	0	1	-360	360	-14.8287	-0.6261	14.8628	0.0262	0.0000	0.0000	0.0000	0.0000;
	2123	2223	0.024967	0.08457	0.008371	105	105	105	0	0	1	-360	360	33.6754	-3.2097	-33.4313	3.0637	0.0000	0.0000	0.0000	0.0000;
	2381	2305	0.022355	0.075727	0.007497	105	105	105	0	0	1	-360	360	-41.5322	-16.9611	41.9414	17.5115	0.0000	0.0000	0.0000	0.0000;
	2396	2215	0.016537	0.056008	0.005539	105	105	105	0	0	1	-360	360	-69.9230	-1.7907	70.5875	3.3594	0.0000	0.0000	0.0000	0.0000;
	2362	2396	0.026793	0.090719	0.008981	105	105	105	0	0	1	-360	360	-57.3642	2.9711	58.1075	-1.5356	0.0000	0.0000	0.0000	0.0000;
	2362	2010	0.014446	0.048942	0.00484	105	105	105	0	0	1	-360	360	52.7912	-4.0361	-52.4513	4.6140	0.0000	0.0000	0.0000	0.0000;
	2068	2396	0.020421	0.036157	0.003451	105	105	105	0	0	1	-360	360	-11.7900	-3.7000	11.8155	3.3263	0.0000	0.0000	0.0000	0.0000;
	2327	2204	0.032041	0.108521	0.01074	105	105	105	0	0	1	-360	360	-15.3883	2.0537	15.4539	-3.1143	0.0000	0.0000	0.0000	0.0000;
	2329	2243	0.016124	0.05281	0.005411	114	114	114	0	0	1	-360	360	-27.6120	3.5513	27.7202	-3.8257	0.0000	0.0000	0.0000	0.0000;
	2046	2286	0.016603	0.056231	0.005571	10	10	10	0	0	1	-360	360	4.5768	-0.1342	-4.5740	-0.5520	0.0000	0.0000	0.0000	0.0000;
	2217	2131	0.104132	0.168512	0.01897	78	78	78	0	0	1	-360	360	2.0665	-2.0877	-2.0620	-0.1640	0.0000	0.0000	0.0000	0.0000;
	2216	2394	0.033058	0.049587	0.00605	76	76	76	0	0	1	-360	360	4.0543	2.4140	-4.0476	-3.1231	0.0000	0.0000	0.0000	0.0000;
	2394	2077	0.1	0.165289	0.01822	76	76	76	0	0	1	-360	360	-9.6230	-0.3513	9.7016	-1.6953	0.0000	0.0000	0.0000	0.0000;
	2148	2394	0.015703	0.046281	0.005009	76	76	76	0	0	1	-360	360	-13.6440	-3.9880	13.6706	3.4744	0.0000	0.0000	0.0000	0.0000;
	2203	1964	0.033802	0.055372	0.005951	67	67	67	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2203	2050	0.015703	0.046281	0.005009	69	69	69	0	0	1	-360	360	8.7819	0.7926	-8.7713	-1.3397	0.0000	0.0000	0.0000	0.0000;
	2132	2076	0.028934	0.047107	0.0053	78	78	78	0	0	1	-360	360	-8.2640	-1.8050	8.2811	1.2000	0.0000	0.0000	0.0000	0.0000;
	2391	2386	0.000554	0.001818	0.026831	118	118	118	0	0	1	-360	360	-13.1100	-4.3400	13.1108	1.1632	0.0000	0.0000	0.0000	0.0000;
	2323	1965	0.011983	0.040562	0.00401	123	123	123	0	0	1	-360	360	-0.0290	6.9238	0.0341	-7.3878	0.0000	0.0000	0.0000	0.0000;
	2269	2378	0.002661	0.009017	0.000891	123	123	123	0	0	1	-360	360	-6.3300	-1.0520	6.3309	0.9485	0.0000	0.0000	0.0000	0.0000;
	2270	2379	0.002661	0.009017	0.000891	123	123	123	0	0	1	-360	360	-5.4490	-0.1440	5.4497	0.0399	0.0000	0.0000	0.0000	0.0000;
	2376	2077	0.003314	0.005793	0.00061	78	78	78	0	0	1	-360	360	-12.6716	-1.3000	12.6761	1.2345	0.0000	0.0000	0.0000	0.0000;
	2387	2376	0.009917	0.022314	0.00242	78	78	78	0	0	1	-360	360	-8.2440	-0.5200	8.2496	0.2420	0.0000	0.0000	0.0000	0.0000;
	2378	2076	0.02562	0.043802	0.00455	78	78	78	0	0	1	-360	360	-27.3710	15.2982	27.5833	-15.4799	0.0000	0.0000	0.0000	0.0000;
	2378	1965	0.004132	0.006612	0.000731	78	78	78	0	0	1	-360	360	16.6221	-16.2468	-16.6034	16.1891	0.0000	0.0000	0.0000	0.0000;
	2386	2379	0.018182	0.035537	0.003901	78	78	78	0	0	1	-360	360	-21.3548	-1.2672	21.4250	0.9402	0.0000	0.0000	0.0000	0.0000;
	2379	1964	0.004132	0.006612	0.000731	78	78	78	0	0	1	-360	360	-33.6536	-1.7592	33.6929	1.7347	0.0000	0.0000	0.0000	0.0000;
	2414	2213	0.008769	0.029686	0.00294	123	123	123	0	0	1	-360	360	-16.9209	-8.9596	16.9474	8.6933	0.0000	0.0000	0.0000	0.0000;
	2323	2414	0.004446	0.01505	0.001491	123	123	123	0	0	1	-360	360	-3.6530	-7.5388	3.6556	7.3678	0.0000	0.0000	0.0000	0.0000;
	2385	2414	0.004967	0.016827	0.00167	123	123	123	0	0	1	-360	360	-13.2580	-1.7680	13.2654	1.5918	0.0000	0.0000	0.0000	0.0000;
	2265	1964	0.015703	0.047934	0.00515	123	123	123	0	0	1	-360	360	22.8791	-3.2443	-22.8096	2.8392	0.0000	0.0000	0.0000	0.0000;
	2265	2212	0.007438	0.023967	0.00257	123	123	123	0	0	1	-360	360	-39.5011	0.7643	39.5978	-0.7621	0.0000	0.0000	0.0000	0.0000;
	2392	2354	0.015703	0.027273	0.00264	123	123	123	0	0	1	-360	360	-19.4721	4.9984	19.5252	-5.2234	0.0000	0.0000	0.0000	0.0000;
	2384	2212	0.007438	0.02562	0.002781	123	123	123	0	0	1	-360	360	-4.1054	-8.7667	4.1111	8.4512	0.0000	0.0000	0.0000	0.0000;
	2384	2368	0.001653	0.004132	0.000409	123	123	123	0	0	1	-360	360	-4.1416	6.3787	4.1424	-6.4258	0.0000	0.0000	0.0000	0.0000;
	2392	2368	0.009091	0.028099	0.003071	123	123	123	0	0	1	-360	360	10.0501	-5.4304	-10.0404	5.0918	0.0000	0.0000	0.0000	0.0000;
	2369	2213	0.009091	0.029752	0.00319	123	123	123	0	0	1	-360	360	-28.0197	-5.1198	28.0807	4.9335	0.0000	0.0000	0.0000	0.0000;
	2369	2355	0.009091	0.028099	0.003071	123	123	123	0	0	1	-360	360	21.6887	3.3998	-21.6522	-3.6566	0.0000	0.0000	0.0000	0.0000;
	2212	2200	0.023141	0.058678	0.00574	102	102	102	0	0	1	-360	360	11.6776	-0.6794	-11.6514	0.0546	0.0000	0.0000	0.0000	0.0000;
	2333	2213	0.013719	0.044463	0.00439	123	123	123	0	0	1	-360	360	-35.4580	2.1289	35.6017	-2.1946	0.0000	0.0000	0.0000	0.0000;
	2213	2204	0.022314	0.071818	0.00702	123	123	123	0	0	1	-360	360	30.2073	2.6895	-30.0378	-2.9902	0.0000	0.0000	0.0000	0.0000;
	2415	2213	0.024893	0.084322	0.008349	120	120	120	0	0	1	-360	360	-17.6470	4.1352	17.7154	-4.9168	0.0000	0.0000	0.0000	0.0000;
	2366	2415	0.01362	0.046124	0.004569	120	120	120	0	0	1	-360	360	-17.6104	3.7054	17.6470	-4.1352	0.0000	0.0000	0.0000	0.0000;
	2280	2212	0.029496	0.099901	0.009891	123	123	123	0	0	1	-360	360	-52.4731	-5.0923	53.1760	6.3008	0.0000	0.0000	0.0000	0.0000;
	2050	2176	0.007521	0.012562	0.0013	57	57	57	0	0	1	-360	360	2.1413	-0.1033	-2.1410	-0.0460	0.0000	0.0000	0.0000	0.0000;
	2333	2174	0.062149	0.105041	0.01058	78	78	78	0	0	1	-360	360	27.0490	-4.7229	-26.6635	4.1111	0.0000	0.0000	0.0000	0.0000;
	2437	2200	0.039669	0.069421	0.00666	78	78	78	0	0	1	-360	360	-5.6010	-0.1640	5.6114	-0.6166	0.0000	0.0000	0.0000	0.0000;
	2390	2354	0.004959	0.015703	0.000801	78	78	78	0	0	1	-360	360	-20.8032	-1.6780	20.8212	1.6387	0.0000	0.0000	0.0000	0.0000;
	2405	1965	0.01438	0.02405	0.00249	78	78	78	0	0	1	-360	360	-16.5274	8.5733	16.5694	-8.8012	0.0000	0.0000	0.0000	0.0000;
	2204	2405	0.03876	0.064628	0.006679	78	78	78	0	0	1	-360	360	-13.8176	7.6963	13.9007	-8.3571	0.0000	0.0000	0.0000	0.0000;
	2405	2175	0.011653	0.02124	0.00221	78	78	78	0	0	1	-360	360	2.6267	-0.2162	-2.6260	-0.0470	0.0000	0.0000	0.0000	0.0000;
	2077	2044	0.01157	0.019826	0.001941	78	78	78	0	0	1	-360	360	5.7126	1.9226	-5.7090	-2.1499	0.0000	0.0000	0.0000	0.0000;
	2044	2355	0.007942	0.015909	0.001529	78	78	78	0	0	1	-360	360	2.4660	1.3799	-2.4655	-1.5624	0.0000	0.0000	0.0000	0.0000;
	2375	2076	0.003314	0.005793	0.000549	78	78	78	0	0	1	-360	360	5.8608	-1.9986	-5.8597	1.9347	0.0000	0.0000	0.0000	0.0000;
	2375	2225	0.009091	0.017364	0.00165	78	78	78	0	0	1	-360	360	-10.5788	0.5226	10.5873	-0.7041	0.0000	0.0000	0.0000	0.0000;
	2389	2077	0.01157	0.018934	0.002011	78	78	78	0	0	1	-360	360	-20.2767	-2.0201	20.3168	1.8443	0.0000	0.0000	0.0000	0.0000;
	2390	2076	0.01157	0.018934	0.001909	78	78	78	0	0	1	-360	360	13.4402	0.7395	-13.4227	-0.9399	0.0000	0.0000	0.0000	0.0000;
	2390	2043	0.000826	0.002479	0.000271	78	78	78	0	0	1	-360	360	0.7370	0.2185	-0.7370	-0.2510	0.0000	0.0000	0.0000	0.0000;
	2374	2354	0.015231	0.048397	0.00476	123	123	123	0	0	1	-360	360	-8.8370	-1.7220	8.8472	1.1825	0.0000	0.0000	0.0000	0.0000;
	2371	2355	0.01157	0.036364	0.003991	102	102	102	0	0	1	-360	360	-17.7562	-3.4893	17.7877	3.1110	0.0000	0.0000	0.0000	0.0000;
	2370	2373	0.007066	0.02395	0.002369	123	123	123	0	0	1	-360	360	8.6935	0.8048	-8.6890	-1.0720	0.0000	0.0000	0.0000	0.0000;
	2371	2309	0.02562	0.082636	0.00854	123	123	123	0	0	1	-360	360	9.0564	0.3197	-9.0386	-1.2792	0.0000	0.0000	0.0000	0.0000;
	2309	2264	0.021488	0.069421	0.00711	120	120	120	0	0	1	-360	360	-3.6444	3.6162	3.6497	-4.4418	0.0000	0.0000	0.0000	0.0000;
	2354	2224	0.009917	0.017364	0.001721	78	78	78	0	0	1	-360	360	19.0364	0.9142	-19.0065	-1.0685	0.0000	0.0000	0.0000	0.0000;
	2389	2370	0.019826	0.033802	0.003291	78	78	78	0	0	1	-360	360	10.7087	-0.3799	-10.6897	0.0188	0.0000	0.0000	0.0000	0.0000;
	2077	1964	0.025612	0.044149	0.004293	78	78	78	0	0	1	-360	360	-0.3622	7.0786	0.3737	-7.5739	0.0000	0.0000	0.0000	0.0000;
	1939	2077	0.005	0.008793	0.00084	78	78	78	0	0	1	-360	360	-6.3042	-0.5799	6.3058	0.4818	0.0000	0.0000	0.0000	0.0000;
	2446	2300	0.028099	0.04876	0.00477	78	78	78	0	0	1	-360	360	-19.5469	-4.5430	19.6397	4.1224	0.0000	0.0000	0.0000	0.0000;
	1939	2446	0.023	0.040273	0.003841	78	78	78	0	0	1	-360	360	-14.6388	-3.5561	14.6819	3.1680	0.0000	0.0000	0.0000	0.0000;
	2346	2204	0.025463	0.084959	0.00635	123	123	123	0	0	1	-360	360	-11.4272	3.7404	11.4585	-4.3958	0.0000	0.0000	0.0000	0.0000;
	2027	2145	0.037711	0.127744	0.012649	123	123	123	0	0	1	-360	360	0.7129	-7.4101	-0.6980	6.0028	0.0000	0.0000	0.0000	0.0000;
	2223	2027	0.028959	0.100876	0.00999	123	123	123	0	0	1	-360	360	26.8053	-1.9017	-26.6249	1.3811	0.0000	0.0000	0.0000	0.0000;
	2246	2238	0.080661	0.142066	0.013479	120	120	120	0	0	1	-360	360	-33.0810	6.6709	33.8718	-6.8827	0.0000	0.0000	0.0000	0.0000;
	2372	1995	0.041157	0.104463	0.01043	102	102	102	0	0	1	-360	360	3.1782	-7.7967	-3.1565	6.6263	0.0000	0.0000	0.0000	0.0000;
	2438	2372	0.058083	0.103752	0.00991	78	78	78	0	0	1	-360	360	-9.8596	-4.4478	9.9163	3.4006	0.0000	0.0000	0.0000	0.0000;
	2381	2188	0.025041	0.042893	0.004281	120	120	120	0	0	1	-360	360	5.7285	-38.9958	-5.3765	39.1246	0.0000	0.0000	0.0000	0.0000;
	2332	2304	0.016612	0.053802	0.005571	91	91	91	0	0	1	-360	360	26.6893	-4.8859	-26.5858	4.5665	0.0000	0.0000	0.0000	0.0000;
	1984	2335	0.015703	0.05157	0.00528	123	123	123	0	0	1	-360	360	-11.7048	4.1561	11.7263	-4.6913	0.0000	0.0000	0.0000	0.0000;
	2233	2335	0.024793	0.081322	0.008339	120	120	120	0	0	1	-360	360	17.8357	-5.1661	-17.7623	4.4503	0.0000	0.0000	0.0000	0.0000;
	2404	2145	0.038909	0.068058	0.006493	78	78	78	0	0	1	-360	360	4.1667	-4.5700	-4.1550	3.8377	0.0000	0.0000	0.0000	0.0000;
	2404	2380	0.001025	0.003471	0.000344	78	78	78	0	0	1	-360	360	-10.6559	6.1220	10.6573	-6.1572	0.0000	0.0000	0.0000	0.0000;
	2404	2013	0.032372	0.058876	0.005827	78	78	78	0	0	1	-360	360	6.4892	-1.5520	-6.4770	0.9000	0.0000	0.0000	0.0000	0.0000;
	2183	2002	0.002917	0.009876	0.00098	102	102	102	0	0	1	-360	360	-5.8880	-2.4260	5.8890	2.3118	0.0000	0.0000	0.0000	0.0000;
	2001	1983	0.006033	0.017851	0.00183	102	102	102	0	0	1	-360	360	41.6637	25.0957	-41.5465	-24.9713	0.0000	0.0000	0.0000	0.0000;
	2349	2012	0.042066	0.141322	0.013939	120	120	120	0	0	1	-360	360	-21.2209	1.3619	21.3854	-2.4404	0.0000	0.0000	0.0000	0.0000;
	2349	1967	0.029917	0.101364	0.010031	120	120	120	0	0	1	-360	360	14.6142	0.8206	-14.5588	-1.7946	0.0000	0.0000	0.0000	0.0000;
	2234	1967	0.011653	0.03957	0.00392	91	91	91	0	0	1	-360	360	-0.2773	-2.3365	0.2778	1.8866	0.0000	0.0000	0.0000	0.0000;
	1949	2227	0.003719	0.012479	0.001159	102	102	102	0	0	1	-360	360	-6.7212	-3.0404	6.7229	2.9075	0.0000	0.0000	0.0000	0.0000;
	1982	1973	0.005372	0.015124	0.001529	102	102	102	0	0	1	-360	360	44.7692	6.6094	-44.6780	-6.5367	0.0000	0.0000	0.0000	0.0000;
	2352	2261	0.004132	0.01405	0.001379	123	123	123	0	0	1	-360	360	-1.0459	-0.6715	1.0460	0.5054	0.0000	0.0000	0.0000	0.0000;
	2002	1973	0.000744	0.002314	0.00024	123	123	123	0	0	1	-360	360	-43.4878	-8.6275	43.5000	8.6367	0.0000	0.0000	0.0000	0.0000;
	2427	2266	0.007107	0.019422	0.002011	102	102	102	0	0	1	-360	360	-58.4251	3.4228	58.6249	-3.1225	0.0000	0.0000	0.0000	0.0000;
	1932	2001	0.004992	0.016909	0.001469	123	123	123	0	0	1	-360	360	18.0337	-12.3998	-18.0142	12.2867	0.0000	0.0000	0.0000	0.0000;
	2408	2233	0.019174	0.063876	0.00598	123	123	123	0	0	1	-360	360	-11.2863	-0.9311	11.3077	0.3178	0.0000	0.0000	0.0000	0.0000;
	2408	2259	0.003802	0.012636	0.001191	123	123	123	0	0	1	-360	360	16.3533	2.9044	-16.3441	-3.0098	0.0000	0.0000	0.0000	0.0000;
	2408	2231	0.001157	0.003802	0.00038	123	123	123	0	0	1	-360	360	-5.0670	-1.9733	5.0673	1.9308	0.0000	0.0000	0.0000	0.0000;
	2436	2056	0.014554	0.053141	0.00523	123	123	123	0	0	1	-360	360	4.0097	-0.8758	-4.0076	0.2918	0.0000	0.0000	0.0000	0.0000;
	2173	2388	0.020083	0.068182	0.00674	10	10	10	0	0	1	-360	360	-1.1780	-0.2070	1.1782	-0.6276	0.0000	0.0000	0.0000	0.0000;
	2202	2056	0.017107	0.057686	0.00567	123	123	123	0	0	1	-360	360	-1.5190	0.8780	1.5196	-1.5178	0.0000	0.0000	0.0000	0.0000;
	2303	2145	0.031959	0.055893	0.005329	78	78	78	0	0	1	-360	360	-3.8531	6.3483	3.8693	-6.9398	0.0000	0.0000	0.0000	0.0000;
	2303	2067	0.018479	0.032322	0.003081	78	78	78	0	0	1	-360	360	-5.1279	-8.5483	5.1432	8.2148	0.0000	0.0000	0.0000	0.0000;
	2067	2045	0.029008	0.051653	0.004891	78	78	78	0	0	1	-360	360	-25.7466	-4.6150	25.9152	4.3367	0.0000	0.0000	0.0000	0.0000;
	2179	2045	0.016612	0.029496	0.00288	78	78	78	0	0	1	-360	360	35.6665	7.6983	-35.4832	-7.7187	0.0000	0.0000	0.0000	0.0000;
	2259	2228	0.007934	0.026777	0.00264	123	123	123	0	0	1	-360	360	0.5911	0.4618	-0.5910	-0.7627	0.0000	0.0000	0.0000	0.0000;
	2231	2228	0.008636	0.017298	0.00166	78	78	78	0	0	1	-360	360	13.4337	0.9553	-13.4200	-1.1173	0.0000	0.0000	0.0000	0.0000;
	2199	1942	0.037603	0.067603	0.00651	78	78	78	0	0	1	-360	360	-20.8390	-1.8679	20.9778	1.3415	0.0000	0.0000	0.0000	0.0000;
	2232	2072	0.014132	0.046281	0.004751	123	123	123	0	0	1	-360	360	33.9358	5.4277	-33.7963	-5.5376	0.0000	0.0000	0.0000	0.0000;
	2205	2020	0.01	0.034793	0.00317	120	120	120	0	0	1	-360	360	9.3433	-2.7057	-9.3355	2.3516	0.0000	0.0000	0.0000	0.0000;
	2427	1932	0.006099	0.020653	0.00204	123	123	123	0	0	1	-360	360	31.0411	-10.2288	-30.9877	10.1608	0.0000	0.0000	0.0000	0.0000;
	2151	1952	0.022132	0.07514	0.00742	91	91	91	0	0	1	-360	360	22.7477	4.5381	-22.6440	-5.0376	0.0000	0.0000	0.0000	0.0000;
	2273	1952	0.046777	0.057934	0.00462	91	91	91	0	0	1	-360	360	-15.1820	-3.9565	15.2840	3.5606	0.0000	0.0000	0.0000	0.0000;
	2308	2306	0.053876	0.094298	0.008981	78	78	78	0	0	1	-360	360	-0.9260	-24.3830	1.2310	23.9860	0.0000	0.0000	0.0000	0.0000;
	2193	2020	0.041397	0.083554	0.00786	78	78	78	0	0	1	-360	360	2.0030	0.2544	-2.0015	-1.1976	0.0000	0.0000	0.0000	0.0000;
	2255	2226	0.009678	0.032793	0.00325	123	123	123	0	0	1	-360	360	-13.8904	-0.6926	13.9060	0.3567	0.0000	0.0000	0.0000	0.0000;
	1983	1941	0.011653	0.034628	0.00356	78	78	78	0	0	1	-360	360	27.3805	0.1440	-27.3081	-0.3576	0.0000	0.0000	0.0000	0.0000;
	2249	1983	0.022041	0.074669	0.007391	91	91	91	0	0	1	-360	360	-10.3160	-7.8906	10.3459	7.1056	0.0000	0.0000	0.0000	0.0000;
	2003	2249	0.012141	0.041124	0.00407	91	91	91	0	0	1	-360	360	-4.5631	-8.9404	4.5730	8.4906	0.0000	0.0000	0.0000	0.0000;
	2318	2188	0.040331	0.068934	0.006921	91	91	91	0	0	1	-360	360	2.4173	40.7184	-1.8375	-40.5246	0.0000	0.0000	0.0000	0.0000;
	2372	2246	0.033636	0.085446	0.008741	91	91	91	0	0	1	-360	360	-13.5067	2.4241	13.5617	-3.3080	0.0000	0.0000	0.0000	0.0000;
	2410	2233	0.016686	0.035289	0.00341	78	78	78	0	0	1	-360	360	-17.1079	-0.4499	17.1507	0.1500	0.0000	0.0000	0.0000	0.0000;
	2410	2365	0.057603	0.122149	0.01179	78	78	78	0	0	1	-360	360	17.1079	0.4499	-16.9597	-1.4687	0.0000	0.0000	0.0000	0.0000;
	2410	2231	8e-06	8.3e-05	0	78	78	78	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2372	2304	0.035289	0.060331	0.00605	78	78	78	0	0	1	-360	360	-11.3658	2.8160	11.4078	-3.4525	0.0000	0.0000	0.0000	0.0000;
	2034	2145	0.068083	0.124397	0.01294	78	78	78	0	0	1	-360	360	-20.1153	-26.6975	20.8053	26.5172	0.0000	0.0000	0.0000	0.0000;
	2306	2034	0.004298	0.010281	0.00143	78	78	78	0	0	1	-360	360	-15.5120	-26.5860	15.5503	26.5255	0.0000	0.0000	0.0000	0.0000;
	2237	2072	0.016124	0.05405	0.005319	120	120	120	0	0	1	-360	360	29.1969	-6.8498	-29.0753	6.6262	0.0000	0.0000	0.0000	0.0000;
	2381	2164	0.039669	0.069339	0.006631	78	78	78	0	0	1	-360	360	23.1417	55.2590	-21.8235	-53.6482	0.0000	0.0000	0.0000	0.0000;
	2292	2237	0.023967	0.042231	0.004141	78	78	78	0	0	1	-360	360	-0.6367	-9.9215	0.6558	9.4652	0.0000	0.0000	0.0000	0.0000;
	2292	2067	0.046446	0.081744	0.00801	78	78	78	0	0	1	-360	360	-6.7233	7.0585	6.7634	-7.9298	0.0000	0.0000	0.0000	0.0000;
	1960	2238	0.02276	0.077099	0.00763	120	120	120	0	0	1	-360	360	-22.9202	3.4417	23.0224	-4.0151	0.0000	0.0000	0.0000	0.0000;
	2318	2185	0.01124	0.038182	0.00378	91	91	91	0	0	1	-360	360	11.8965	-0.7824	-11.8830	0.3824	0.0000	0.0000	0.0000	0.0000;
	2307	2246	0.023471	0.057851	0.005929	91	91	91	0	0	1	-360	360	-10.5134	3.3921	10.5383	-4.0259	0.0000	0.0000	0.0000	0.0000;
	2234	2231	0.009826	0.033223	0.003279	123	123	123	0	0	1	-360	360	28.5949	3.3518	-28.5240	-3.4881	0.0000	0.0000	0.0000	0.0000;
	2012	2003	0.013934	0.047207	0.004671	91	91	91	0	0	1	-360	360	1.6344	-8.0611	-1.6269	7.5354	0.0000	0.0000	0.0000	0.0000;
	2011	2010	0.006876	0.023281	0.002299	120	120	120	0	0	1	-360	360	-44.2376	6.1503	44.3543	-6.0260	0.0000	0.0000	0.0000	0.0000;
	2308	2164	0.034298	0.06	0.00574	78	78	78	0	0	1	-360	360	-15.2680	20.5200	15.4935	-20.7028	0.0000	0.0000	0.0000	0.0000;
	2151	2145	0.003893	0.013223	0.0013	91	91	91	0	0	1	-360	360	-35.1227	-5.2931	35.1651	5.2867	0.0000	0.0000	0.0000	0.0000;
	2436	2234	0.060496	0.118182	0.011589	78	78	78	0	0	1	-360	360	-14.0347	-1.3442	14.1402	0.2277	0.0000	0.0000	0.0000	0.0000;
	2291	2072	0.006149	0.020827	0.002062	91	91	91	0	0	1	-360	360	-47.0025	4.6851	47.1187	-4.5356	0.0000	0.0000	0.0000	0.0000;
	2332	2291	0.007587	0.025686	0.002543	91	91	91	0	0	1	-360	360	-46.8593	4.8699	47.0025	-4.6851	0.0000	0.0000	0.0000	0.0000;
	2250	2001	0.00519	0.014132	0.00143	102	102	102	0	0	1	-360	360	-59.0666	-16.6945	59.2280	16.9602	0.0000	0.0000	0.0000	0.0000;
	2365	2172	0.067438	0.118017	0.01126	10	10	10	0	0	1	-360	360	6.6527	-0.6723	-6.6260	-0.5370	0.0000	0.0000	0.0000	0.0000;
	1960	2205	0.014521	0.049174	0.004869	78	78	78	0	0	1	-360	360	14.9702	-4.1417	-14.9413	3.6537	0.0000	0.0000	0.0000	0.0000;
	2250	2184	0.001818	0.004554	0.00046	91	91	91	0	0	1	-360	360	2.5021	0.0446	-2.5020	-0.1000	0.0000	0.0000	0.0000	0.0000;
	2226	2002	0.002587	0.00876	0.000871	123	123	123	0	0	1	-360	360	-16.8520	-1.3717	16.8582	1.2882	0.0000	0.0000	0.0000	0.0000;
	2232	2256	0.001901	0.006033	0.00061	123	123	123	0	0	1	-360	360	-7.0219	-3.5688	7.0229	3.4987	0.0000	0.0000	0.0000	0.0000;
	2227	2125	0.001744	0.004793	0.000479	102	102	102	0	0	1	-360	360	-13.6499	-3.7965	13.6528	3.7472	0.0000	0.0000	0.0000	0.0000;
	2232	1982	0.00686	0.021984	0.00228	123	123	123	0	0	1	-360	360	-38.8379	-3.9119	38.9249	3.9165	0.0000	0.0000	0.0000	0.0000;
	2279	2199	0.017017	0.055124	0.005711	123	123	123	0	0	1	-360	360	-17.2629	-2.8541	17.3070	2.3239	0.0000	0.0000	0.0000	0.0000;
	2266	2257	0.010281	0.021636	0.002101	78	78	78	0	0	1	-360	360	-67.6059	1.9225	67.9897	-1.3737	0.0000	0.0000	0.0000	0.0000;
	2318	2001	0.011256	0.038141	0.00378	91	91	91	0	0	1	-360	360	-31.6868	-43.6780	31.9625	44.1584	0.0000	0.0000	0.0000	0.0000;
	2411	2255	0.003033	0.010289	0.001019	102	102	102	0	0	1	-360	360	-4.4679	0.5934	4.4684	-0.7134	0.0000	0.0000	0.0000	0.0000;
	1949	2411	0.006174	0.017364	0.00174	102	102	102	0	0	1	-360	360	-4.4668	0.3884	4.4679	-0.5934	0.0000	0.0000	0.0000	0.0000;
	2427	2411	4.1e-05	0.000141	1e-05	102	102	102	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2238	2005	0.007314	0.012793	0.00122	78	78	78	0	0	1	-360	360	5.1587	0.7556	-5.1570	-0.9000	0.0000	0.0000	0.0000	0.0000;
	2237	2260	0.009587	0.024744	0.00251	102	102	102	0	0	1	-360	360	6.6296	0.3114	-6.6260	-0.6000	0.0000	0.0000	0.0000	0.0000;
	2238	2261	0.009587	0.024744	0.00251	102	102	102	0	0	1	-360	360	8.1184	1.5167	-8.1130	-1.8054	0.0000	0.0000	0.0000	0.0000;
	2155	2237	0.013438	0.023826	0.00227	78	78	78	0	0	1	-360	360	-8.8887	-4.4550	8.8998	4.2057	0.0000	0.0000	0.0000	0.0000;
	2258	2155	0.006983	0.012793	0.00098	78	78	78	0	0	1	-360	360	-7.8538	-4.5620	7.8587	4.4550	0.0000	0.0000	0.0000	0.0000;
	2238	2052	0.005744	0.019438	0.001919	123	123	123	0	0	1	-360	360	37.3009	8.1563	-37.2315	-8.1525	0.0000	0.0000	0.0000	0.0000;
	2256	2186	0.003388	0.010992	0.00114	123	123	123	0	0	1	-360	360	3.4050	5.1075	-3.4039	-5.2407	0.0000	0.0000	0.0000	0.0000;
	2186	2002	0.00281	0.009091	0.000939	123	123	123	0	0	1	-360	360	-7.4891	2.8647	7.4906	-2.9725	0.0000	0.0000	0.0000	0.0000;
	2258	2185	0.014752	0.049984	0.004949	78	78	78	0	0	1	-360	360	-3.7827	3.1878	3.7860	-3.7604	0.0000	0.0000	0.0000	0.0000;
	2352	2256	0.00405	0.013388	0.001379	123	123	123	0	0	1	-360	360	21.9344	9.9950	-21.9149	-10.0962	0.0000	0.0000	0.0000	0.0000;
	2438	1984	0.010314	0.017967	0.001711	78	78	78	0	0	1	-360	360	-1.1024	4.9478	1.1048	-5.1401	0.0000	0.0000	0.0000	0.0000;
	2349	2279	0.039504	0.072314	0.007279	78	78	78	0	0	1	-360	360	-7.3783	-3.4645	7.3999	2.6531	0.0000	0.0000	0.0000	0.0000;
	2250	1980	0.001653	0.005372	0.000549	123	123	123	0	0	1	-360	360	44.7855	12.5649	-44.7559	-12.5353	0.0000	0.0000	0.0000	0.0000;
	2352	1980	0.001818	0.00595	0.000629	123	123	123	0	0	1	-360	360	-31.1955	-10.7765	31.2119	10.7543	0.0000	0.0000	0.0000	0.0000;
	2125	2052	0.00405	0.013314	0.001379	123	123	123	0	0	1	-360	360	-25.1358	-6.2892	25.1585	6.1985	0.0000	0.0000	0.0000	0.0000;
	2258	2006	0.020347	0.035578	0.0034	78	78	78	0	0	1	-360	360	4.4225	0.8051	-4.4190	-1.2000	0.0000	0.0000	0.0000	0.0000;
	2257	2179	0.022719	0.039727	0.00379	78	78	78	0	0	1	-360	360	46.8400	10.9986	-46.4145	-10.7183	0.0000	0.0000	0.0000	0.0000;
	2435	1929	0.001289	0.003744	0.00038	76	76	76	0	0	1	-360	360	-65.5894	-2.2844	65.6338	2.3655	0.0000	0.0000	0.0000	0.0000;
	1966	2435	0.028331	0.073488	0.007451	62	62	62	0	0	1	-360	360	-54.7208	1.9541	55.4154	-1.0746	0.0000	0.0000	0.0000	0.0000;
	2063	1966	0.029669	0.076612	0.007771	62	62	62	0	0	1	-360	360	-51.1358	2.8015	51.7868	-2.0611	0.0000	0.0000	0.0000	0.0000;
	2327	2073	0.028256	0.095702	0.00947	105	105	105	0	0	1	-360	360	10.3773	-2.3317	-10.3511	1.2928	0.0000	0.0000	0.0000	0.0000;
	2211	2019	0.017289	0.058554	0.005801	105	105	105	0	0	1	-360	360	-10.4469	-3.8482	10.4645	3.2151	0.0000	0.0000	0.0000	0.0000;
	2398	2064	0.007017	0.017521	0.000779	82	82	82	0	0	1	-360	360	9.1331	1.3072	-9.1281	-1.3890	0.0000	0.0000	0.0000	0.0000;
	2398	2209	0.023876	0.067107	0.00621	82	82	82	0	0	1	-360	360	-9.1331	-1.2103	9.1497	0.5040	0.0000	0.0000	0.0000	0.0000;
	2398	2138	0.003554	0.009587	0.000801	82	82	82	0	0	1	-360	360	0.0000	-0.0969	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2019	2210	0.027372	0.092132	0.009121	105	105	105	0	0	1	-360	360	-17.4055	-4.2831	17.4779	3.4262	0.0000	0.0000	0.0000	0.0000;
	2211	2073	0.017917	0.061438	0.006009	105	105	105	0	0	1	-360	360	-3.2681	1.1332	3.2701	-1.8418	0.0000	0.0000	0.0000	0.0000;
	2210	2126	0.037934	0.097521	0.00999	62	62	62	0	0	1	-360	360	41.1152	5.9774	-40.5739	-5.7782	0.0000	0.0000	0.0000	0.0000;
	2195	2090	0.013223	0.032893	0.00347	76	76	76	0	0	1	-360	360	33.7897	-14.8992	-33.6433	14.8373	0.0000	0.0000	0.0000	0.0000;
	2334	1928	0.005041	0.014132	0.00145	62	62	62	0	0	1	-360	360	-60.0198	4.8797	60.1661	-4.6510	0.0000	0.0000	0.0000	0.0000;
	2156	2433	0.037438	0.096529	0.009891	62	62	62	0	0	1	-360	360	-13.0869	-5.8409	13.1496	4.8184	0.0000	0.0000	0.0000	0.0000;
	2156	2055	0.020174	0.049587	0.00508	62	62	62	0	0	1	-360	360	11.6139	5.4789	-11.5853	-6.0091	0.0000	0.0000	0.0000	0.0000;
	2085	2054	0.015289	0.049669	0.005179	91	91	91	0	0	1	-360	360	-2.9624	-2.1805	2.9640	1.5778	0.0000	0.0000	0.0000	0.0000;
	2091	1971	0.033314	0.079818	0.007831	62	62	62	0	0	1	-360	360	57.7802	22.4822	-56.7401	-20.9312	14.2739	0.0000	0.0000	0.0000;
	2397	2214	0.038141	0.066711	0.00636	48	48	48	0	0	1	-360	360	-11.4969	-4.6872	11.5432	3.9751	0.0000	0.0000	0.0000	0.0000;
	2069	2397	0.000686	0.002347	0.00023	48	48	48	0	0	1	-360	360	-11.4960	-4.7140	11.4969	4.6884	0.0000	0.0000	0.0000	0.0000;
	2088	2397	8.3e-05	0.000141	1e-05	48	48	48	0	0	1	-360	360	0.0000	-0.0000	-0.0000	-0.0012	0.0000	0.0000	0.0000	0.0000;
	2053	2215	0.013636	0.023802	0.00227	69	69	69	0	0	1	-360	360	-30.3910	-8.9530	30.5019	8.8657	0.0000	0.0000	0.0000	0.0000;
	2066	2215	0.008678	0.015124	0.00145	69	69	69	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.1803	0.0000	0.0000	0.0000	0.0000;
	2215	2091	0.005372	0.015446	0.00181	103	103	103	0	0	1	-360	360	54.3949	-1.5529	-54.2670	1.6961	0.0000	0.0000	0.0000	0.0000;
	2094	2054	0.02843	0.052066	0.00498	59	59	59	0	0	1	-360	360	10.6211	-1.9873	-10.5932	1.4520	0.0000	0.0000	0.0000	0.0000;
	2268	2094	0.02843	0.052066	0.00498	59	59	59	0	0	1	-360	360	13.1714	-1.9437	-13.1291	1.4323	0.0000	0.0000	0.0000	0.0000;
	2210	2206	0.003876	0.006686	0.000629	59	59	59	0	0	1	-360	360	4.7157	0.8368	-4.7150	-0.9120	0.0000	0.0000	0.0000	0.0000;
	2209	2208	0.007603	0.018017	0.001791	59	59	59	0	0	1	-360	360	25.8531	-0.9372	-25.8113	0.8191	0.0000	0.0000	0.0000	0.0000;
	2305	1971	0.011686	0.03957	0.003918	105	105	105	0	0	1	-360	360	-53.7514	-19.6385	54.0871	20.3242	0.0000	0.0000	0.0000	0.0000;
	2351	2214	0.003967	0.029174	0.002829	196	196	196	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2350	2041	0.000992	0.007934	0.00077	171	171	171	0	0	1	-360	360	-8.0970	-2.7490	8.0976	2.6592	0.0000	0.0000	0.0000	0.0000;
	2142	1933	0.02676	0.076893	0.00772	87	87	87	0	0	1	-360	360	44.4066	-8.5898	-43.9508	8.9795	0.0000	0.0000	0.0000	0.0000;
	2090	2041	0.000504	0.003967	0.000559	168	168	168	0	0	1	-360	360	4.6892	-12.6276	-4.6884	12.5648	0.0000	0.0000	0.0000	0.0000;
	2092	2041	0.000504	0.003967	0.000559	160	160	160	0	0	1	-360	360	30.5760	-16.1270	-30.5711	16.0970	0.0000	0.0000	0.0000	0.0000;
	1930	1931	0.00276	0.004826	0.00046	69	69	69	0	0	1	-360	360	-15.3570	-6.2100	15.3631	6.1637	0.0000	0.0000	0.0000	0.0000;
	1931	1929	0.013512	0.023488	0.002241	69	69	69	0	0	1	-360	360	-31.6091	-11.6637	31.7324	11.5985	0.0000	0.0000	0.0000	0.0000;
	2100	2082	0.009091	0.026446	0.002691	69	69	69	0	0	1	-360	360	13.2300	1.8117	-13.2166	-2.0988	0.0000	0.0000	0.0000	0.0000;
	2089	1929	0.031983	0.081066	0.008279	69	69	69	0	0	1	-360	360	-28.4805	-5.3272	28.6979	4.8506	0.0000	0.0000	0.0000	0.0000;
	2133	2089	0.006917	0.019223	0.001941	69	69	69	0	0	1	-360	360	-18.7345	-2.0975	18.7545	1.9152	0.0000	0.0000	0.0000	0.0000;
	2063	2061	0.005041	0.014207	0.0015	76	76	76	0	0	1	-360	360	42.8208	-3.8015	-42.7430	3.8415	0.0000	0.0000	0.0000	0.0000;
	1935	2133	0.01395	0.039983	0.00401	69	69	69	0	0	1	-360	360	-13.9939	-1.2970	14.0165	0.8715	0.0000	0.0000	0.0000	0.0000;
	2100	1935	0.01657	0.048901	0.004901	69	69	69	0	0	1	-360	360	-13.9670	-1.8137	13.9939	1.2970	0.0000	0.0000	0.0000	0.0000;
	2055	2054	0.003802	0.012149	0.001229	62	62	62	0	0	1	-360	360	3.6213	5.7681	-3.6197	-5.9078	0.0000	0.0000	0.0000	0.0000;
	1930	1928	0.00157	0.002727	0.000259	39	39	39	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2210	2201	0.017934	0.058182	0.006031	82	82	82	0	0	1	-360	360	9.3739	4.4834	-9.3575	-5.1600	0.0000	0.0000	0.0000	0.0000;
	2268	2209	0.06438	0.113802	0.01096	48	48	48	0	0	1	-360	360	-22.7504	-0.7063	23.0315	-0.1121	0.0000	0.0000	0.0000	0.0000;
	2126	2124	0.002397	0.004132	0.00039	67	67	67	0	0	1	-360	360	8.5417	-1.4302	-8.5401	1.3871	0.0000	0.0000	0.0000	0.0000;
	2057	1928	0.014711	0.037364	0.003821	51	51	51	0	0	1	-360	360	-28.4157	-5.8021	28.5150	5.5774	0.0000	0.0000	0.0000	0.0000;
	2117	2057	0.025041	0.063636	0.007241	51	51	51	0	0	1	-360	360	-28.2450	-6.2594	28.4157	5.8021	0.0000	0.0000	0.0000	0.0000;
	2208	2207	0.016612	0.029174	0.002781	39	39	39	0	0	1	-360	360	7.9673	1.8959	-7.9580	-2.2160	0.0000	0.0000	0.0000	0.0000;
	2310	2201	0.01438	0.046529	0.004811	82	82	82	0	0	1	-360	360	1.1067	-4.4382	-1.1045	3.8660	0.0000	0.0000	0.0000	0.0000;
	2356	2195	0.036686	0.094298	0.009849	51	51	51	0	0	1	-360	360	47.1705	-10.7854	-46.4817	11.3412	0.0000	0.0000	0.0000	0.0000;
	2377	2074	0.029826	0.054628	0.00552	59	59	59	0	0	1	-360	360	-1.5618	8.2506	1.5810	-8.8667	0.0000	0.0000	0.0000	0.0000;
	2137	1987	0.003017	0.01	0.001019	82	82	82	0	0	1	-360	360	-11.2060	-2.7710	11.2094	2.6617	0.0000	0.0000	0.0000	0.0000;
	2065	1987	0.001612	0.005289	0.00054	82	82	82	0	0	1	-360	360	16.1671	3.8041	-16.1634	-3.8557	0.0000	0.0000	0.0000	0.0000;
	2065	2061	0.016446	0.042984	0.004431	76	76	76	0	0	1	-360	360	-33.7485	2.9735	33.9080	-3.0835	0.0000	0.0000	0.0000	0.0000;
	2220	2090	0.010331	0.03405	0.00348	76	76	76	0	0	1	-360	360	-16.0879	-11.3558	16.1204	11.0377	0.0000	0.0000	0.0000	0.0000;
	2356	2334	0.022893	0.062149	0.00636	51	51	51	0	0	1	-360	360	-48.2005	10.3854	48.6508	-9.9547	0.0000	0.0000	0.0000	0.0000;
	2124	2085	0.017521	0.05438	0.005641	91	91	91	0	0	1	-360	360	2.9381	-1.4821	-2.9366	0.8255	0.0000	0.0000	0.0000	0.0000;
	2276	2220	0.014628	0.047934	0.00491	82	82	82	0	0	1	-360	360	-7.8162	-9.5143	7.8339	8.9778	0.0000	0.0000	0.0000	0.0000;
	2326	2276	0.022066	0.071488	0.00747	82	82	82	0	0	1	-360	360	-3.2259	-8.2850	3.2392	7.4323	0.0000	0.0000	0.0000	0.0000;
	2326	2065	0.017603	0.056942	0.00575	82	82	82	0	0	1	-360	360	-2.9781	7.4180	2.9883	-8.0686	0.0000	0.0000	0.0000	0.0000;
	2298	2090	0.016223	0.041793	0.00424	87	87	87	0	0	1	-360	360	-62.3118	2.0755	62.8337	-1.2474	0.0000	0.0000	0.0000	0.0000;
	2187	2091	0.009752	0.032066	0.003291	62	62	62	0	0	1	-360	360	-23.4065	-7.2345	23.4539	6.9843	0.0000	0.0000	0.0000	0.0000;
	2433	2187	0.034876	0.094876	0.009721	62	62	62	0	0	1	-360	360	-16.5356	-5.8184	16.6225	4.8705	0.0000	0.0000	0.0000	0.0000;
	2126	2123	0.006529	0.022066	0.002161	91	91	91	0	0	1	-360	360	39.6620	-0.9604	-39.5744	1.0037	0.0000	0.0000	0.0000	0.0000;
	2298	2142	0.013479	0.039289	0.00394	87	87	87	0	0	1	-360	360	56.5598	-3.8225	-56.2016	4.3928	0.0000	0.0000	0.0000	0.0000;
	2298	2089	0.026198	0.08595	0.008809	82	82	82	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2136	1988	0.046686	0.095446	0.00939	76	76	76	0	0	1	-360	360	-5.1127	3.3429	5.1290	-4.4209	0.0000	0.0000	0.0000	0.0000;
	2118	1989	0.033967	0.059422	0.00567	78	78	78	0	0	1	-360	360	-22.0339	-9.3763	22.2006	9.0051	0.0000	0.0000	0.0000	0.0000;
	2296	2014	0.027364	0.091818	0.00907	78	78	78	0	0	1	-360	360	-22.5328	-1.3072	22.6489	0.6040	0.0000	0.0000	0.0000	0.0000;
	2315	2015	0.02719	0.087934	0.009099	123	123	123	0	0	1	-360	360	-26.4433	-0.8646	26.6022	0.2826	0.0000	0.0000	0.0000	0.0000;
	2118	2031	0.029669	0.049256	0.004859	78	78	78	0	0	1	-360	360	-13.9571	-0.8087	14.0072	0.3279	0.0000	0.0000	0.0000	0.0000;
	2315	1993	0.025207	0.081818	0.009169	123	123	123	0	0	1	-360	360	19.6593	-0.6564	-19.5778	-0.1722	0.0000	0.0000	0.0000	0.0000;
	2406	2049	0.059446	0.103983	0.00992	76	76	76	0	0	1	-360	360	-17.8705	4.9803	18.0439	-5.8738	0.0000	0.0000	0.0000	0.0000;
	1943	2406	0.018769	0.032818	0.003129	76	76	76	0	0	1	-360	360	-12.6786	4.2549	12.7068	-4.5812	0.0000	0.0000	0.0000	0.0000;
	2181	2406	0.021107	0.071504	0.007081	76	76	76	0	0	1	-360	360	-5.1590	-0.4350	5.1637	-0.3991	0.0000	0.0000	0.0000	0.0000;
	2403	2014	0.024727	0.054	0.00523	78	78	78	0	0	1	-360	360	8.4851	-4.0121	-8.4677	3.4165	0.0000	0.0000	0.0000	0.0000;
	2317	2403	0.053826	0.110008	0.010609	78	78	78	0	0	1	-360	360	13.1342	-4.4317	-13.0516	3.3116	0.0000	0.0000	0.0000	0.0000;
	2158	2403	0.00257	0.004488	0.000431	78	78	78	0	0	1	-360	360	-4.5660	-0.7520	4.5665	0.7006	0.0000	0.0000	0.0000	0.0000;
	2049	2014	0.001397	0.004628	0.00046	76	76	76	0	0	1	-360	360	-28.3629	4.3378	28.3724	-4.3621	0.0000	0.0000	0.0000	0.0000;
	2283	2282	0.026612	0.086612	0.00899	123	123	123	0	0	1	-360	360	-23.8139	0.3794	23.9423	-1.0246	0.0000	0.0000	0.0000	0.0000;
	2296	2168	0.021984	0.073802	0.007359	78	78	78	0	0	1	-360	360	17.2718	0.2362	-17.2169	-0.9305	0.0000	0.0000	0.0000	0.0000;
	2402	2015	0.03224	0.069984	0.006778	78	78	78	0	0	1	-360	360	-18.2887	0.1885	18.3786	-0.8112	0.0000	0.0000	0.0000	0.0000;
	2157	2402	0.001975	0.003455	0.000329	78	78	78	0	0	1	-360	360	-5.7440	0.2000	5.7445	-0.2386	0.0000	0.0000	0.0000	0.0000;
	1989	2402	0.069529	0.121603	0.011602	78	78	78	0	0	1	-360	360	-12.4527	-1.2724	12.5442	0.0501	0.0000	0.0000	0.0000	0.0000;
	2283	2031	0.031488	0.052149	0.00515	76	76	76	0	0	1	-360	360	17.3309	0.8356	-17.2502	-1.3049	0.0000	0.0000	0.0000	0.0000;
	2026	2014	0.010397	0.037041	0.002819	78	78	78	0	0	1	-360	360	-10.7638	-2.2457	10.7742	1.9414	0.0000	0.0000	0.0000	0.0000;
	2025	2026	0.003752	0.006562	0.000629	78	78	78	0	0	1	-360	360	-4.5731	-1.1435	4.5738	1.0687	0.0000	0.0000	0.0000	0.0000;
	2018	2025	0.007107	0.012438	0.001191	78	78	78	0	0	1	-360	360	4.2709	-0.0554	-4.2699	-0.0865	0.0000	0.0000	0.0000	0.0000;
	2030	2015	0.004149	0.007256	0.00069	78	78	78	0	0	1	-360	360	-15.7780	-2.4882	15.7868	2.4200	0.0000	0.0000	0.0000	0.0000;
	2017	2030	0.006521	0.011397	0.001089	78	78	78	0	0	1	-360	360	-12.8200	-1.9341	12.8290	1.8182	0.0000	0.0000	0.0000	0.0000;
	2177	1985	0.019826	0.055041	0.005951	76	76	76	0	0	1	-360	360	15.3481	4.0063	-15.3069	-4.6179	0.0000	0.0000	0.0000	0.0000;
	2413	2328	0.010934	0.030479	0.003071	102	102	102	0	0	1	-360	360	15.9033	-6.5301	-15.8770	6.2307	0.0000	0.0000	0.0000	0.0000;
	1985	2413	0.003752	0.010248	0.001031	102	102	102	0	0	1	-360	360	21.8184	-6.3105	-21.8025	6.2287	0.0000	0.0000	0.0000	0.0000;
	2426	2413	0.003826	0.006686	0.000639	102	102	102	0	0	1	-360	360	-5.8980	-0.3770	5.8991	0.3014	0.0000	0.0000	0.0000	0.0000;
	2447	2254	0.011727	0.030521	0.00303	78	78	78	0	0	1	-360	360	5.6643	3.7420	-5.6597	-4.0988	0.0000	0.0000	0.0000	0.0000;
	2447	2178	0.040231	0.102769	0.01021	78	78	78	0	0	1	-360	360	-6.4013	-3.9420	6.4185	2.7352	0.0000	0.0000	0.0000	0.0000;
	2325	2178	0.028603	0.053223	0.00515	76	76	76	0	0	1	-360	360	-23.1211	-5.3046	23.2531	4.9212	0.0000	0.0000	0.0000	0.0000;
	1959	1991	9.1e-05	0.000686	7e-05	120	120	120	0	0	1	-360	360	-87.9146	-3.2242	87.9202	3.2577	0.0000	0.0000	0.0000	0.0000;
	2022	1959	0.005554	0.018182	0.001861	120	120	120	0	0	1	-360	360	-87.5716	-2.3335	87.9146	3.2242	0.0000	0.0000	0.0000	0.0000;
	2253	2008	0.025603	0.078397	0.008061	78	78	78	0	0	1	-360	360	-0.7751	-0.2860	0.7752	-0.6933	0.0000	0.0000	0.0000	0.0000;
	2254	2029	0.006612	0.018256	0.001941	102	102	102	0	0	1	-360	360	26.6290	4.9350	-26.5890	-5.0599	0.0000	0.0000	0.0000	0.0000;
	2330	2008	0.009603	0.024744	0.00251	69	69	69	0	0	1	-360	360	-4.5650	-1.3110	4.5668	1.0107	0.0000	0.0000	0.0000	0.0000;
	2236	2330	0.001711	0.005157	0.00052	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2294	2008	0.006281	0.010578	0.001079	78	78	78	0	0	1	-360	360	-12.8460	3.0000	12.8550	-3.1159	0.0000	0.0000	0.0000	0.0000;
	2428	2009	0.017769	0.03157	0.003011	78	78	78	0	0	1	-360	360	-25.6070	-2.8518	25.7048	2.6613	0.0000	0.0000	0.0000	0.0000;
	2178	2162	0.027058	0.091636	0.00907	78	78	78	0	0	1	-360	360	28.7293	-2.9582	-28.5466	2.4653	0.0000	0.0000	0.0000	0.0000;
	2196	2162	0.020777	0.038017	0.00364	78	78	78	0	0	1	-360	360	-22.6994	2.0427	22.7886	-2.3223	0.0000	0.0000	0.0000	0.0000;
	2196	2004	0.041521	0.074289	0.0071	78	78	78	0	0	1	-360	360	17.3924	-1.8867	-17.2881	1.2167	0.0000	0.0000	0.0000	0.0000;
	2278	2004	0.050174	0.087744	0.008371	78	78	78	0	0	1	-360	360	-17.1630	0.4373	17.2881	-1.2167	0.0000	0.0000	0.0000	0.0000;
	2325	1990	0.044628	0.094207	0.009629	76	76	76	0	0	1	-360	360	11.9151	3.7726	-11.8558	-4.8057	0.0000	0.0000	0.0000	0.0000;
	2383	2277	0.024793	0.080413	0.00832	123	123	123	0	0	1	-360	360	-16.9647	-0.7591	17.0308	0.0714	0.0000	0.0000	0.0000	0.0000;
	2277	2166	0.037686	0.065537	0.006241	78	78	78	0	0	1	-360	360	-27.2978	-2.4164	27.5572	2.1805	0.0000	0.0000	0.0000	0.0000;
	2166	2016	0.065372	0.114876	0.01096	78	78	78	0	0	1	-360	360	-28.5892	-2.5415	29.0717	2.1462	0.0000	0.0000	0.0000	0.0000;
	2235	2009	0.011438	0.030231	0.003059	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2022	1985	0.020579	0.067603	0.005689	123	123	123	0	0	1	-360	360	75.7726	-1.0565	-74.8217	3.4815	0.0000	0.0000	0.0000	0.0000;
	2419	2245	0.01314	0.025537	0.002461	78	78	78	0	0	1	-360	360	-44.5566	-4.7295	44.7786	4.8668	0.0000	0.0000	0.0000	0.0000;
	2190	2331	0.019471	0.06595	0.006529	123	123	123	0	0	1	-360	360	-15.8970	-3.9900	15.9450	3.4447	0.0000	0.0000	0.0000	0.0000;
	2353	1968	0.021818	0.071066	0.007369	123	123	123	0	0	1	-360	360	25.9642	5.8401	-25.8388	-6.3391	0.0000	0.0000	0.0000	0.0000;
	2345	2254	0.00486	0.016446	0.001631	120	120	120	0	0	1	-360	360	-15.0092	-3.1291	15.0186	2.9629	0.0000	0.0000	0.0000	0.0000;
	1940	2253	0.002281	0.007719	0.00076	123	123	123	0	0	1	-360	360	-11.9428	-1.7550	11.9456	1.6719	0.0000	0.0000	0.0000	0.0000;
	2278	2182	0.023058	0.057364	0.005871	102	102	102	0	0	1	-360	360	9.7471	-2.0370	-9.7281	1.3897	0.0000	0.0000	0.0000	0.0000;
	2139	2009	0.003893	0.01319	0.001307	123	123	123	0	0	1	-360	360	-4.2664	0.1350	4.2670	-0.2918	0.0000	0.0000	0.0000	0.0000;
	1940	2139	0.010107	0.034248	0.00339	123	123	123	0	0	1	-360	360	-1.7632	-0.4680	1.7634	0.0570	0.0000	0.0000	0.0000	0.0000;
	2191	2008	0.007802	0.026413	0.002621	123	123	123	0	0	1	-360	360	-10.2030	-0.9706	10.2098	0.6751	0.0000	0.0000	0.0000	0.0000;
	2345	2191	0.003174	0.010727	0.00106	123	123	123	0	0	1	-360	360	-6.8128	-1.3629	6.8140	1.2386	0.0000	0.0000	0.0000	0.0000;
	2328	2253	0.00595	0.020157	0.001999	120	120	120	0	0	1	-360	360	8.4550	-4.2307	-8.4506	4.0025	0.0000	0.0000	0.0000	0.0000;
	2244	2029	0.012893	0.033719	0.00333	102	102	102	0	0	1	-360	360	-10.3465	-3.4091	10.3590	3.0399	0.0000	0.0000	0.0000	0.0000;
	2278	2086	0.033967	0.058099	0.00559	72	72	72	0	0	1	-360	360	38.7723	5.9135	-38.3300	-5.8101	0.0000	0.0000	0.0000	0.0000;
	2086	2007	0.069256	0.12157	0.011739	78	78	78	0	0	1	-360	360	27.5520	4.5281	-27.0792	-5.0210	0.0000	0.0000	0.0000	0.0000;
	2419	2016	0.039826	0.069669	0.00666	78	78	78	0	0	1	-360	360	36.4506	2.3105	-36.0027	-2.3072	0.0000	0.0000	0.0000	0.0000;
	2383	2321	0.007521	0.018347	0.00196	78	78	78	0	0	1	-360	360	13.8707	2.1001	-13.8570	-2.2780	0.0000	0.0000	0.0000	0.0000;
	2324	2322	0.007521	0.018347	0.00196	78	78	78	0	0	1	-360	360	0.0000	-0.2317	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2331	2007	0.018182	0.058843	0.00612	123	123	123	0	0	1	-360	360	-22.4760	-3.7447	22.5622	3.3530	0.0000	0.0000	0.0000	0.0000;
	2245	1985	0.009256	0.018603	0.00181	78	78	78	0	0	1	-360	360	-57.1456	-5.4008	57.3992	5.6918	0.0000	0.0000	0.0000	0.0000;
	2272	2177	0.069421	0.140496	0.01368	78	78	78	0	0	1	-360	360	-2.6775	-6.5346	2.7004	4.9181	0.0000	0.0000	0.0000	0.0000;
	2324	2182	0.011066	0.027438	0.00281	102	102	102	0	0	1	-360	360	-0.7370	0.0297	0.7371	-0.3617	0.0000	0.0000	0.0000	0.0000;
	2353	1991	0.012893	0.041984	0.004361	123	123	123	0	0	1	-360	360	-27.4352	-5.8911	27.5167	5.6123	0.0000	0.0000	0.0000	0.0000;
	2293	2165	0.008017	0.021744	0.0022	78	78	78	0	0	1	-360	360	-13.8430	3.1700	13.8564	-3.4005	0.0000	0.0000	0.0000	0.0000;
	2165	2009	0.00843	0.022984	0.002321	78	78	78	0	0	1	-360	360	-17.6874	2.3955	17.7096	-2.6169	0.0000	0.0000	0.0000	0.0000;
	2177	2152	0.022636	0.073554	0.007621	123	123	123	0	0	1	-360	360	2.6093	-0.6404	-2.6080	-0.2890	0.0000	0.0000	0.0000	0.0000;
	1968	1938	0.031802	0.079793	0.00779	123	123	123	0	0	1	-360	360	20.6778	6.3711	-20.5543	-7.0036	0.0000	0.0000	0.0000	0.0000;
	2178	1970	0.050331	0.133876	0.01203	78	78	78	0	0	1	-360	360	9.4773	-2.3953	-9.4395	1.0182	0.0000	0.0000	0.0000	0.0000;
	2357	1970	0.028512	0.09843	0.008959	123	123	123	0	0	1	-360	360	-3.2430	-0.1870	3.2455	-0.9022	0.0000	0.0000	0.0000	0.0000;
	2278	2177	0.034298	0.245446	0.024079	120	120	120	0	0	1	-360	360	-31.3564	-4.3137	31.6434	3.4665	0.0000	0.0000	0.0000	0.0000;
	2428	2244	0.008182	0.021488	0.00212	102	102	102	0	0	1	-360	360	2.0390	-1.9922	-2.0385	1.7381	0.0000	0.0000	0.0000	0.0000;
	2423	2143	0.04876	0.069421	0.01254	120	120	120	0	0	1	-360	360	14.7465	-2.6538	-14.6606	1.2103	0.0000	0.0000	0.0000	0.0000;
	2271	2424	0.019793	0.036289	0.00348	78	78	78	0	0	1	-360	360	-1.3260	-0.3400	1.3263	-0.0959	0.0000	0.0000	0.0000	0.0000;
	2393	2424	0.023636	0.059917	0.006181	120	120	120	0	0	1	-360	360	-13.1070	-1.3731	13.1397	0.6831	0.0000	0.0000	0.0000	0.0000;
	2393	2000	0.001818	0.004628	0.000469	120	120	120	0	0	1	-360	360	5.6015	0.9217	-5.6010	-0.9790	0.0000	0.0000	0.0000	0.0000;
	1947	2393	0.00405	0.013058	0.00136	120	120	120	0	0	1	-360	360	-7.5037	-0.6150	7.5055	0.4514	0.0000	0.0000	0.0000	0.0000;
	2424	2421	0.022314	0.07557	0.00748	123	123	123	0	0	1	-360	360	7.3848	0.3457	-7.3750	-1.2490	0.0000	0.0000	0.0000	0.0000;
	2300	2423	0.028347	0.095041	0.00937	123	123	123	0	0	1	-360	360	-28.9267	-5.9924	29.1268	5.5007	0.0000	0.0000	0.0000	0.0000;
	2423	2197	0.030248	0.101653	0.010019	120	120	120	0	0	1	-360	360	9.9484	-0.8734	-9.9245	-0.3004	0.0000	0.0000	0.0000	0.0000;
	2320	2440	0.015703	0.027273	0.00286	69	69	69	0	0	1	-360	360	12.2793	-0.5693	-12.2604	0.2438	0.0000	0.0000	0.0000	0.0000;
	2347	2229	0.012008	0.026711	0.002589	120	120	120	0	0	1	-360	360	-7.3984	1.9823	7.4041	-2.2938	0.0000	0.0000	0.0000	0.0000;
	2319	2347	0.011273	0.025479	0.002471	78	78	78	0	0	1	-360	360	2.7722	2.9889	-2.7706	-3.2948	0.0000	0.0000	0.0000	0.0000;
	2319	2301	0.008099	0.027422	0.00272	120	120	120	0	0	1	-360	360	10.3479	1.6692	-10.3408	-1.9857	0.0000	0.0000	0.0000	0.0000;
	2319	2313	0.029752	0.042066	0.004039	69	69	69	0	0	1	-360	360	34.5071	2.3953	-34.2228	-2.4952	0.0000	0.0000	0.0000	0.0000;
	2320	2267	0.049587	0.086777	0.009	69	69	69	0	0	1	-360	360	34.8225	0.5034	-34.3427	-0.7768	0.0000	0.0000	0.0000	0.0000;
	2267	2217	0.042066	0.070248	0.00733	69	69	69	0	0	1	-360	360	31.6907	0.6278	-31.3437	-0.9318	0.0000	0.0000	0.0000	0.0000;
	1947	2320	0.038983	0.103132	0.01043	102	102	102	0	0	1	-360	360	-6.2813	-2.2551	6.2945	0.9858	0.0000	0.0000	0.0000	0.0000;
	2289	2319	0.014669	0.040397	0.00628	102	102	102	0	0	1	-360	360	-10.4783	-0.2971	10.4912	-0.4539	0.0000	0.0000	0.0000	0.0000;
	2313	2058	0.05124	0.081818	0.009489	78	78	78	0	0	1	-360	360	23.9018	0.4582	-23.6636	-1.2339	0.0000	0.0000	0.0000	0.0000;
	1950	1936	0.006612	0.019826	0.002299	123	123	123	0	0	1	-360	360	11.3933	-3.2211	-11.3860	2.9551	0.0000	0.0000	0.0000	0.0000;
	2319	2221	0.01405	0.027273	0.002781	78	78	78	0	0	1	-360	360	-1.6221	4.3646	1.6247	-4.7079	0.0000	0.0000	0.0000	0.0000;
	2221	1951	0.024793	0.042984	0.00423	78	78	78	0	0	1	-360	360	-11.0557	3.7927	11.0832	-4.2750	0.0000	0.0000	0.0000	0.0000;
	2161	1950	0.032231	0.055372	0.003071	78	78	78	0	0	1	-360	360	-4.3370	-1.7501	4.3425	1.3754	0.0000	0.0000	0.0000	0.0000;
	2320	1936	0.01762	0.041347	0.00402	78	78	78	0	0	1	-360	360	-4.0188	3.4350	4.0230	-3.9291	0.0000	0.0000	0.0000	0.0000;
	1951	2229	0.011347	0.035091	0.003461	123	123	123	0	0	1	-360	360	13.4589	-2.2695	-13.4421	1.8878	0.0000	0.0000	0.0000	0.0000;
	2358	1951	0.009917	0.020661	0.00218	91	91	91	0	0	1	-360	360	-9.3581	2.4766	9.3656	-2.7343	0.0000	0.0000	0.0000	0.0000;
	2062	1951	0.017529	0.059364	0.005881	123	123	123	0	0	1	-360	360	-2.1813	-4.5891	2.1845	3.8643	0.0000	0.0000	0.0000	0.0000;
	2358	2281	0.009917	0.023141	0.002611	91	91	91	0	0	1	-360	360	9.3581	-2.4766	-9.3508	2.1667	0.0000	0.0000	0.0000	0.0000;
	2281	2197	0.033802	0.080992	0.009271	91	91	91	0	0	1	-360	360	6.4028	-1.2567	-6.3916	0.1241	0.0000	0.0000	0.0000	0.0000;
	2297	2023	0.028099	0.089256	0.00924	114	114	114	0	0	1	-360	360	-7.1192	0.2766	7.1308	-1.3917	0.0000	0.0000	0.0000	0.0000;
	2163	2023	0.01405	0.044628	0.0046	120	120	120	0	0	1	-360	360	10.5325	-1.6549	-10.5198	1.1207	0.0000	0.0000	0.0000	0.0000;
	2297	2197	0.018182	0.041322	0.004649	114	114	114	0	0	1	-360	360	-10.4023	0.0420	10.4181	-0.5859	0.0000	0.0000	0.0000	0.0000;
	2163	1950	0.01157	0.028099	0.00286	102	102	102	0	0	1	-360	360	-16.8675	0.7969	16.8939	-1.0906	0.0000	0.0000	0.0000	0.0000;
	2297	2070	0.024793	0.034711	0.004189	78	78	78	0	0	1	-360	360	13.1015	-0.2346	-13.0673	-0.2379	0.0000	0.0000	0.0000	0.0000;
	2071	1962	0.037934	0.066124	0.006411	78	78	78	0	0	1	-360	360	-4.2847	0.7460	4.2907	-1.5303	0.0000	0.0000	0.0000	0.0000;
	1996	2071	0.038529	0.068058	0.0065	78	78	78	0	0	1	-360	360	-6.6388	0.6544	6.6529	-1.4336	0.0000	0.0000	0.0000	0.0000;
	2127	1996	0.025149	0.045496	0.004371	120	120	120	0	0	1	-360	360	-3.6870	0.0999	3.6898	-0.6344	0.0000	0.0000	0.0000	0.0000;
	2143	1962	0.01405	0.044628	0.00484	120	120	120	0	0	1	-360	360	10.2416	-1.1993	-10.2297	0.6363	0.0000	0.0000	0.0000	0.0000;
	2046	2301	0.008256	0.016529	0.001941	120	120	120	0	0	1	-360	360	-5.9184	-1.2786	5.9208	1.0407	0.0000	0.0000	0.0000	0.0000;
	1999	2289	0.037636	0.097041	0.00984	102	102	102	0	0	1	-360	360	-6.3390	-1.3070	6.3513	0.1111	0.0000	0.0000	0.0000	0.0000;
	2046	2440	0.01676	0.056777	0.005619	120	120	120	0	0	1	-360	360	-7.0964	0.8118	7.1034	-1.4908	0.0000	0.0000	0.0000	0.0000;
	2134	2424	0.013347	0.045198	0.00447	120	120	120	0	0	1	-360	360	-5.1590	-0.8492	5.1619	0.2987	0.0000	0.0000	0.0000	0.0000;
	2432	2170	0.013173	0.044603	0.004419	123	123	123	0	0	1	-360	360	-23.4620	0.5988	23.5208	-0.9467	0.0000	0.0000	0.0000	0.0000;
	1978	1945	0.042827	0.097868	0.00953	78	78	78	0	0	1	-360	360	7.3744	-0.7726	-7.3555	-0.3544	0.0000	0.0000	0.0000	0.0000;
	2170	1946	0.054893	0.14743	0.01489	102	102	102	0	0	1	-360	360	21.6850	-3.2810	-21.4745	2.0109	0.0000	0.0000	0.0000	0.0000;
	2171	1944	0.049016	0.127529	0.01292	102	102	102	0	0	1	-360	360	26.1379	-7.3557	-25.8492	6.5191	0.0000	0.0000	0.0000	0.0000;
	2343	2170	0.005141	0.035124	0.007899	196	196	196	0	0	1	-360	360	72.5702	-11.9098	-72.3464	12.4596	0.0000	0.0000	0.0000	0.0000;
	2343	2171	0.005141	0.035124	0.007899	196	196	196	0	0	1	-360	360	50.1408	2.0486	-50.0363	-2.3108	0.0000	0.0000	0.0000	0.0000;
	2170	2140	0.032231	0.077686	0.0044	123	123	123	0	0	1	-360	360	23.3440	-2.9422	-23.2006	2.7444	0.0000	0.0000	0.0000	0.0000;
	2171	1957	0.027273	0.068603	0.00666	102	102	102	0	0	1	-360	360	4.5105	-0.8030	-4.5060	-0.0060	0.0000	0.0000	0.0000	0.0000;
	2339	2337	0.003314	0.009917	0.00099	123	123	123	0	0	1	-360	360	2.9462	-0.1218	-2.9460	0.0000	0.0000	0.0000	0.0000	0.0000;
	2344	2336	0.004132	0.009091	0.000939	123	123	123	0	0	1	-360	360	16.2280	8.1190	-16.2170	-8.2110	0.0000	0.0000	0.0000	0.0000;
	2343	2339	0.004132	0.009917	0.00099	123	123	123	0	0	1	-360	360	12.2199	3.9010	-12.2144	-4.0104	0.0000	0.0000	0.0000	0.0000;
	2343	2340	0.004132	0.010744	0.00099	123	123	123	0	0	1	-360	360	8.7031	3.6668	-8.7001	-3.7816	0.0000	0.0000	0.0000	0.0000;
	2340	2338	0.004132	0.01157	0.001041	123	123	123	0	0	1	-360	360	0.8830	-0.0247	-0.8830	-0.1040	0.0000	0.0000	0.0000	0.0000;
	2106	1946	0.010744	0.034711	0.00356	114	114	114	0	0	1	-360	360	-36.5664	8.2083	36.6901	-8.2441	0.0000	0.0000	0.0000	0.0000;
	2364	1944	0.009446	0.028463	0.0028	78	78	78	0	0	1	-360	360	-1.1780	0.0000	1.1781	-0.3427	0.0000	0.0000	0.0000	0.0000;
	2363	1946	0.004512	0.015289	0.00151	123	123	123	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.1849	0.0000	0.0000	0.0000	0.0000;
	1946	1945	0.006504	0.022017	0.00218	120	120	120	0	0	1	-360	360	-20.6646	5.1391	20.6888	-5.3244	0.0000	0.0000	0.0000	0.0000;
	2248	1978	0.01319	0.044669	0.004419	123	123	123	0	0	1	-360	360	9.8880	-1.1933	-9.8774	0.6846	0.0000	0.0000	0.0000	0.0000;
	2432	2248	0.012603	0.042653	0.004221	123	123	123	0	0	1	-360	360	13.5890	-1.4858	-13.5700	1.0293	0.0000	0.0000	0.0000	0.0000;
	2160	2140	0.02562	0.078512	0.008419	123	123	123	0	0	1	-360	360	-21.3107	3.2332	21.4086	-3.9664	0.0000	0.0000	0.0000	0.0000;
	2275	2160	0.012397	0.041322	0.004189	120	120	120	0	0	1	-360	360	-17.1528	2.9494	17.1837	-3.3592	0.0000	0.0000	0.0000	0.0000;
	1958	1974	0.036686	0.091653	0.009399	102	102	102	0	0	1	-360	360	-4.4200	-0.1210	4.4258	-1.0380	0.0000	0.0000	0.0000	0.0000;
	2360	2060	0.006612	0.015703	0.00165	102	102	102	0	0	1	-360	360	4.1309	-0.0670	-4.1300	-0.1370	0.0000	0.0000	0.0000	0.0000;
	2059	1974	0.005917	0.01857	0.001989	78	78	78	0	0	1	-360	360	-11.9838	0.2571	11.9906	-0.4842	0.0000	0.0000	0.0000	0.0000;
	2360	1974	0.00157	0.005124	0.00053	120	120	120	0	0	1	-360	360	-12.4999	-2.1860	12.5019	2.1264	0.0000	0.0000	0.0000	0.0000;
	2361	1974	0.001529	0.004934	0.000501	120	120	120	0	0	1	-360	360	-8.8530	-2.0620	8.8540	2.0027	0.0000	0.0000	0.0000	0.0000;
	2059	2051	0.005793	0.013223	0.001379	78	78	78	0	0	1	-360	360	7.5618	-1.7201	-7.5590	1.5543	0.0000	0.0000	0.0000	0.0000;
	2095	1974	0.02719	0.049174	0.004779	78	78	78	0	0	1	-360	360	-9.7971	1.4552	9.8187	-2.0125	0.0000	0.0000	0.0000	0.0000;
	2218	1974	0.012901	0.022744	0.0022	78	78	78	0	0	1	-360	360	-4.5095	0.2061	4.5116	-0.4772	0.0000	0.0000	0.0000	0.0000;
	2219	1974	0.012041	0.024719	0.002439	78	78	78	0	0	1	-360	360	-4.7220	-0.1620	4.7242	-0.1383	0.0000	0.0000	0.0000	0.0000;
	2169	2051	0.028934	0.05124	0.00469	78	78	78	0	0	1	-360	360	-3.7268	1.7324	3.7310	-2.3103	0.0000	0.0000	0.0000	0.0000;
	2169	2161	0.015703	0.027273	0.002519	78	78	78	0	0	1	-360	360	1.9598	-2.3904	-1.9587	2.0779	0.0000	0.0000	0.0000	0.0000;
	2095	2062	0.018934	0.059504	0.006561	120	120	120	0	0	1	-360	360	2.7241	-2.8262	-2.7221	2.0144	0.0000	0.0000	0.0000	0.0000;
	2161	2062	0.01405	0.023141	0.002321	78	78	78	0	0	1	-360	360	2.6137	-0.4948	-2.6129	0.2064	0.0000	0.0000	0.0000	0.0000;
	2141	2062	0.009	0.030479	0.00302	69	69	69	0	0	1	-360	360	-2.2120	-0.1450	2.2124	-0.2307	0.0000	0.0000	0.0000	0.0000;
	2341	2339	0.009091	0.031397	0.003269	123	123	123	0	0	1	-360	360	-6.0241	-4.5153	6.0281	4.1252	0.0000	0.0000	0.0000	0.0000;
	2342	2340	0.012397	0.040496	0.00416	123	123	123	0	0	1	-360	360	-5.4579	-3.6968	5.4621	3.1964	0.0000	0.0000	0.0000	0.0000;
	2295	2218	0.006364	0.021554	0.00213	91	91	91	0	0	1	-360	360	-3.1830	0.0020	3.1835	-0.2661	0.0000	0.0000	0.0000	0.0000;
	2083	2252	0.010281	0.01795	0.001711	102	102	102	0	0	1	-360	360	-12.3880	-2.0540	12.4022	1.8834	0.0000	0.0000	0.0000	0.0000;
	2079	2251	0.013339	0.033901	0.003429	102	102	102	0	0	1	-360	360	-22.5890	-5.8340	22.6523	5.6019	0.0000	0.0000	0.0000	0.0000;
	2407	2252	0.012488	0.03219	0.00326	102	102	102	0	0	1	-360	360	22.4641	-4.2289	-22.4074	4.0019	0.0000	0.0000	0.0000	0.0000;
	2080	2407	0.000603	0.001033	9.9e-05	102	102	102	0	0	1	-360	360	-23.6330	-9.1580	23.6364	9.1524	0.0000	0.0000	0.0000	0.0000;
	2400	2407	0.004347	0.007603	0.000731	102	102	102	0	0	1	-360	360	46.1820	4.9821	-46.1005	-4.9235	0.0000	0.0000	0.0000	0.0000;
	2130	2400	0.000397	0.000686	7e-05	102	102	102	0	0	1	-360	360	-7.2330	-2.8470	7.2332	2.8393	0.0000	0.0000	0.0000	0.0000;
	2409	2400	0.002207	0.007463	0.00074	102	102	102	0	0	1	-360	360	53.4711	7.9249	-53.4152	-7.8214	0.0000	0.0000	0.0000	0.0000;
	2311	2409	0.008504	0.014851	0.001421	102	102	102	0	0	1	-360	360	-4.7160	0.9890	4.7177	-1.1500	0.0000	0.0000	0.0000	0.0000;
	2263	2409	0.008198	0.027769	0.002749	102	102	102	0	0	1	-360	360	58.4323	7.2803	-58.1888	-6.7749	0.0000	0.0000	0.0000	0.0000;
	2096	2251	0.00257	0.004488	0.000431	102	102	102	0	0	1	-360	360	-24.9160	-8.2230	24.9314	8.2003	0.0000	0.0000	0.0000	0.0000;
	2078	2084	0.004554	0.012628	0.00127	102	102	102	0	0	1	-360	360	-0.0000	-0.0000	0.0000	-0.1445	0.0000	0.0000	0.0000	0.0000;
	2097	2251	0.00257	0.004488	0.000431	102	102	102	0	0	1	-360	360	-22.1470	-9.0280	22.1598	9.0008	0.0000	0.0000	0.0000	0.0000;
	2109	2114	0.01176	0.021074	0.002016	78	78	78	0	0	1	-360	360	11.6440	2.7388	-11.6293	-2.9451	0.0000	0.0000	0.0000	0.0000;
	2098	2252	0.00257	0.004488	0.000431	102	102	102	0	0	1	-360	360	-22.1450	-3.8350	22.1564	3.8056	0.0000	0.0000	0.0000	0.0000;
	2439	2113	0.018033	0.061091	0.006048	78	78	78	0	0	1	-360	360	-7.5961	9.8357	7.6211	-10.4537	0.0000	0.0000	0.0000	0.0000;
	2242	2251	0.001537	0.005207	0.00052	123	123	123	0	0	1	-360	360	-23.5171	4.1110	23.5247	-4.1451	0.0000	0.0000	0.0000	0.0000;
	2252	2108	0.002479	0.006612	0.00068	123	123	123	0	0	1	-360	360	8.8529	16.9355	-8.8450	-16.9920	0.0000	0.0000	0.0000	0.0000;
	2251	2107	0.002479	0.006612	0.00068	123	123	123	0	0	1	-360	360	-11.0195	0.0059	11.0222	-0.0773	0.0000	0.0000	0.0000	0.0000;
	2242	2119	0.006967	0.023603	0.00234	123	123	123	0	0	1	-360	360	14.3891	-3.7110	-14.3758	3.4867	0.0000	0.0000	0.0000	0.0000;
	2252	2115	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	0.0002	2.4413	0.0000	-2.5470	0.0000	0.0000	0.0000	0.0000;
	2114	2251	0.002769	0.009372	0.000929	120	120	120	0	0	1	-360	360	9.1263	-1.4109	-9.1243	1.3108	0.0000	0.0000	0.0000	0.0000;
	2239	2252	0.000124	0.000397	4.1e-05	123	123	123	0	0	1	-360	360	-11.8140	3.5330	11.8142	-3.5372	0.0000	0.0000	0.0000	0.0000;
	2240	2251	9.9e-05	0.000314	2.9e-05	123	123	123	0	0	1	-360	360	-2.9060	-0.2300	2.9060	0.2267	0.0000	0.0000	0.0000	0.0000;
	2252	2110	0.005793	0.018182	0.001861	120	120	120	0	0	1	-360	360	-58.6603	-3.5211	58.8352	3.8565	0.0000	0.0000	0.0000	0.0000;
	2401	1977	0.020702	0.070124	0.006941	123	123	123	0	0	1	-360	360	-12.7453	4.3261	12.7776	-5.0379	0.0000	0.0000	0.0000	0.0000;
	2149	2401	0.003488	0.011802	0.001169	123	123	123	0	0	1	-360	360	1.8595	4.3919	-1.8588	-4.5280	0.0000	0.0000	0.0000	0.0000;
	2147	2401	0.006149	0.020827	0.002059	123	123	123	0	0	1	-360	360	-14.5930	-0.4080	14.6041	0.2019	0.0000	0.0000	0.0000	0.0000;
	2366	2287	0.024793	0.076859	0.008349	120	120	120	0	0	1	-360	360	13.4484	-4.4304	-13.4082	3.5434	0.0000	0.0000	0.0000	0.0000;
	2288	2032	0.028934	0.08843	0.009731	120	120	120	0	0	1	-360	360	34.1404	-2.8995	-33.8606	2.5830	0.0000	0.0000	0.0000	0.0000;
	2104	2081	0.00676	0.022909	0.00227	120	120	120	0	0	1	-360	360	-71.9667	-6.7113	72.2702	7.4739	0.0000	0.0000	0.0000	0.0000;
	2112	2104	0.003686	0.012496	0.001237	123	123	123	0	0	1	-360	360	-70.4815	-5.5050	70.6407	5.9013	0.0000	0.0000	0.0000	0.0000;
	2112	2107	0.005223	0.017702	0.001752	123	123	123	0	0	1	-360	360	25.0577	6.9251	-25.0272	-7.0237	0.0000	0.0000	0.0000	0.0000;
	2399	2252	0.000612	0.002083	0.00021	120	120	120	0	0	1	-360	360	-68.1037	4.8747	68.1286	-4.8138	0.0000	0.0000	0.0000	0.0000;
	2099	2399	0.001017	0.003471	0.000339	120	120	120	0	0	1	-360	360	-14.7230	-2.0000	14.7250	1.9680	0.0000	0.0000	0.0000	0.0000;
	2102	2399	0.004314	0.013876	0.001159	120	120	120	0	0	1	-360	360	-53.2694	7.0619	53.3787	-6.8427	0.0000	0.0000	0.0000	0.0000;
	2122	2251	0.009421	0.031934	0.003161	120	120	120	0	0	1	-360	360	-7.8880	-1.9250	7.8934	1.5797	0.0000	0.0000	0.0000	0.0000;
	2121	2101	0.006446	0.021868	0.002161	120	120	120	0	0	1	-360	360	-39.7002	15.8734	39.8036	-15.7692	0.0000	0.0000	0.0000	0.0000;
	2105	1972	0.024388	0.063587	0.01204	123	123	123	0	0	1	-360	360	51.3503	-11.4242	-50.8015	11.3893	0.0000	0.0000	0.0000	0.0000;
	2443	2217	0.019016	0.041529	0.008639	78	78	78	0	0	1	-360	360	0.0000	-0.0000	0.0000	-1.0294	0.0000	0.0000	0.0000	0.0000;
	2275	2105	0.005793	0.018934	0.001909	76	76	76	0	0	1	-360	360	14.7958	-3.4044	-14.7849	3.2065	0.0000	0.0000	0.0000	0.0000;
	2217	2150	0.015703	0.02562	0.00227	120	120	120	0	0	1	-360	360	10.2138	4.0924	-10.1977	-4.3360	0.0000	0.0000	0.0000	0.0000;
	2150	2149	0.008256	0.012397	0.00128	120	120	120	0	0	1	-360	360	-0.7063	4.0820	0.7075	-4.2319	0.0000	0.0000	0.0000	0.0000;
	2442	2216	0.022091	0.057744	0.005651	76	76	76	0	0	1	-360	360	-5.8980	-0.7560	5.9045	0.1007	0.0000	0.0000	0.0000	0.0000;
	2039	2216	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	-20.4880	-7.9350	20.5056	7.8800	0.0000	0.0000	0.0000	0.0000;
	2040	2217	0.004347	0.007603	0.000721	69	69	69	0	0	1	-360	360	-0.6500	-0.1400	0.6500	0.0541	0.0000	0.0000	0.0000	0.0000;
	2216	2058	0.046281	0.076859	0.00755	76	76	76	0	0	1	-360	360	-18.0803	1.3953	18.2086	-2.0871	0.0000	0.0000	0.0000	0.0000;
	2036	2445	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	-0.0420	-0.2200	0.0420	0.1241	0.0000	0.0000	0.0000	0.0000;
	2035	2444	0.002446	0.008331	0.00083	114	114	114	0	0	1	-360	360	-8.9290	-0.4490	8.9307	0.3573	0.0000	0.0000	0.0000	0.0000;
	2444	1955	0.006612	0.009091	0.001159	120	120	120	0	0	1	-360	360	2.8829	10.3896	-2.8763	-10.5163	0.0000	0.0000	0.0000	0.0000;
	2439	1955	0.007438	0.023967	0.002439	120	120	120	0	0	1	-360	360	4.3531	-9.9717	-4.3457	9.7103	0.0000	0.0000	0.0000	0.0000;
	2444	2038	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	53.7847	11.2366	-53.6570	-11.0486	0.0000	0.0000	0.0000	0.0000;
	2445	2037	0.004959	0.014876	0.00167	120	120	120	0	0	1	-360	360	37.0064	12.3431	-36.9410	-12.3390	0.0000	0.0000	0.0000	0.0000;
	2445	2120	0.013223	0.042066	0.0046	120	120	120	0	0	1	-360	360	-7.3317	6.8708	7.3437	-7.3630	0.0000	0.0000	0.0000	0.0000;
	2445	2116	0.009091	0.027273	0.002899	120	120	120	0	0	1	-360	360	-15.6616	19.8537	15.7124	-20.0348	0.0000	0.0000	0.0000	0.0000;
	2121	2116	0.009917	0.030579	0.003291	120	120	120	0	0	1	-360	360	32.0362	-18.0364	-31.9194	18.0198	0.0000	0.0000	0.0000	0.0000;
	2444	2243	0.024793	0.080083	0.008301	114	114	114	0	0	1	-360	360	29.8256	-3.8626	-29.6352	3.5077	0.0000	0.0000	0.0000	0.0000;
	1953	2445	0.014992	0.031537	0.0031	78	78	78	0	0	1	-360	360	-4.7150	-0.1500	4.7179	-0.2017	0.0000	0.0000	0.0000	0.0000;
	2444	2033	0.042984	0.102479	0.0105	78	78	78	0	0	1	-360	360	-33.1536	2.4544	33.5599	-2.7298	0.0000	0.0000	0.0000	0.0000;
	2109	2113	0.002868	0.009719	0.000963	114	114	114	0	0	1	-360	360	-16.8050	-2.8198	16.8122	2.7328	0.0000	0.0000	0.0000	0.0000;
	2216	1976	0.03719	0.119008	0.012199	114	114	114	0	0	1	-360	360	-2.3230	-9.3035	2.3477	7.9155	0.0000	0.0000	0.0000	0.0000;
	1972	1977	0.064628	0.109917	0.01059	123	123	123	0	0	1	-360	360	44.4655	-12.0343	-43.3422	12.6767	0.0000	0.0000	0.0000	0.0000;
	1976	1969	0.033223	0.056612	0.00545	120	120	120	0	0	1	-360	360	8.8825	2.2629	-8.8591	-2.8820	0.0000	0.0000	0.0000	0.0000;
	1977	2129	0.017826	0.060207	0.00596	120	120	120	0	0	1	-360	360	10.9417	4.5985	-10.9200	-5.2270	0.0000	0.0000	0.0000	0.0000;
	2262	1977	0.007587	0.025686	0.002541	120	120	120	0	0	1	-360	360	-68.7517	-6.8178	69.0615	7.5680	0.0000	0.0000	0.0000	0.0000;
	2412	2111	0.012091	0.040959	0.004061	120	120	120	0	0	1	-360	360	59.7996	6.5176	-59.4258	-5.7228	0.0000	0.0000	0.0000	0.0000;
	1977	2412	0.006868	0.023256	0.002299	120	120	120	0	0	1	-360	360	60.0116	6.8571	-59.7996	-6.4099	0.0000	0.0000	0.0000	0.0000;
	2312	2412	0.005529	0.009669	0.00092	120	120	120	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.1077	0.0000	0.0000	0.0000	0.0000;
	2081	1976	0.015703	0.049587	0.005111	120	120	120	0	0	1	-360	360	-82.4362	-9.9239	83.3555	12.2162	0.0000	0.0000	0.0000	0.0000;
	2288	1976	0.004132	0.031397	0.003001	137	137	137	0	0	1	-360	360	-23.5282	-0.7678	23.5471	0.5475	0.0000	0.0000	0.0000	0.0000;
	2280	1976	0.065826	0.222983	0.02208	123	123	123	0	0	1	-360	360	-8.1829	-9.8477	8.2622	7.4916	0.0000	0.0000	0.0000	0.0000;
	2264	1977	0.020661	0.066124	0.006781	120	120	120	0	0	1	-360	360	-5.4187	2.0108	5.4249	-2.7934	0.0000	0.0000	0.0000	0.0000;
	2084	2102	0.016421	0.055628	0.00551	123	123	123	0	0	1	-360	360	-5.4280	-1.1005	5.4323	0.4876	0.0000	0.0000	0.0000	0.0000;
	2021	1969	0.012141	0.041124	0.00407	123	123	123	0	0	1	-360	360	-4.4260	-1.1660	4.4281	0.6830	0.0000	0.0000	0.0000	0.0000;
	2075	2418	0.03124	0.102314	0.010481	123	123	123	0	0	1	-360	360	6.5039	-4.7584	-6.4877	3.6051	0.0000	0.0000	0.0000	0.0000;
	1997	1981	0.044207	0.113669	0.01112	91	91	91	0	0	1	-360	360	28.6770	-0.6042	-28.3800	0.0203	0.0000	0.0000	0.0000	0.0000;
	2087	1997	0.010331	0.018017	0.001721	78	78	78	0	0	1	-360	360	18.0380	-7.0766	-18.0065	6.9209	0.0000	0.0000	0.0000	0.0000;
	2430	2159	0.012562	0.021901	0.00212	78	78	78	0	0	1	-360	360	-11.1442	-0.7045	11.1569	0.4649	0.0000	0.0000	0.0000	0.0000;
	2431	2429	0.010083	0.017364	0.001721	78	78	78	0	0	1	-360	360	1.3377	5.7767	-1.3347	-5.9834	0.0000	0.0000	0.0000	0.0000;
	2241	2154	0.02	0.037438	0.003649	78	78	78	0	0	1	-360	360	-9.7408	8.3410	9.7682	-8.7376	0.0000	0.0000	0.0000	0.0000;
	2429	2241	0.007934	0.015372	0.0015	78	78	78	0	0	1	-360	360	-5.0183	6.6054	5.0228	-6.7810	0.0000	0.0000	0.0000	0.0000;
	2431	2430	0.010826	0.018934	0.00181	78	78	78	0	0	1	-360	360	0.7993	-2.4266	-0.7988	2.2045	0.0000	0.0000	0.0000	0.0000;
	2159	2153	0.028182	0.058182	0.0059	78	78	78	0	0	1	-360	360	-19.5809	2.0441	19.6696	-2.5924	0.0000	0.0000	0.0000	0.0000;
	2028	1997	0.057016	0.113314	0.010909	78	78	78	0	0	1	-360	360	-16.2376	-2.5927	16.3645	1.5223	0.0000	0.0000	0.0000	0.0000;
	2284	2153	0.039339	0.129174	0.013201	123	123	123	0	0	1	-360	360	-35.9930	1.9884	36.4128	-2.2371	0.0000	0.0000	0.0000	0.0000;
	2285	2284	0.00595	0.019174	0.00198	123	123	123	0	0	1	-360	360	-29.0207	1.4159	29.0620	-1.5244	0.0000	0.0000	0.0000	0.0000;
	2153	2087	0.036198	0.063388	0.00612	78	78	78	0	0	1	-360	360	32.2424	-3.5326	-31.9370	3.3116	0.0000	0.0000	0.0000	0.0000;
	2285	2425	0.02743	0.088851	0.00915	123	123	123	0	0	1	-360	360	22.9177	-1.6289	-22.7992	0.9028	0.0000	0.0000	0.0000	0.0000;
	2382	2299	0.040331	0.136612	0.01353	123	123	123	0	0	1	-360	360	-9.2363	-8.5459	9.2869	7.1268	0.0000	0.0000	0.0000	0.0000;
	2420	2048	0.01157	0.039421	0.003901	123	123	123	0	0	1	-360	360	-11.7163	5.2808	11.7331	-5.6735	0.0000	0.0000	0.0000	0.0000;
	2028	1934	0.035066	0.118777	0.011761	123	123	123	0	0	1	-360	360	11.8306	3.9347	-11.7834	-5.1760	0.0000	0.0000	0.0000	0.0000;
	2154	1934	0.041066	0.139091	0.01377	123	123	123	0	0	1	-360	360	36.2274	5.2125	-35.7755	-5.3397	0.0000	0.0000	0.0000	0.0000;
	2192	1961	0.029496	0.050174	0.00484	78	78	78	0	0	1	-360	360	-24.4405	10.8381	24.6258	-11.0788	0.0000	0.0000	0.0000	0.0000;
	2418	2048	0.011322	0.037438	0.0037	123	123	123	0	0	1	-360	360	20.7832	-5.4399	-20.7381	5.1625	0.0000	0.0000	0.0000	0.0000;
	2417	2154	0.014207	0.046612	0.00477	123	123	123	0	0	1	-360	360	-32.5302	-8.0913	32.6617	7.9419	0.0000	0.0000	0.0000	0.0000;
	2417	2299	0.017769	0.058182	0.005951	123	123	123	0	0	1	-360	360	29.7742	7.5083	-29.6349	-7.7658	0.0000	0.0000	0.0000	0.0000;
	2194	2075	0.022686	0.062207	0.00629	78	78	78	0	0	1	-360	360	11.9620	-5.7491	-11.9279	5.1204	0.0000	0.0000	0.0000	0.0000;
	2154	1956	0.020992	0.069339	0.006989	123	123	123	0	0	1	-360	360	23.5869	-5.2377	-23.4877	4.7096	0.0000	0.0000	0.0000	0.0000;
	1986	1956	0.017107	0.05562	0.004799	123	123	123	0	0	1	-360	360	-22.7074	4.3452	22.7827	-4.6866	0.0000	0.0000	0.0000	0.0000;
	2418	2329	0.024959	0.084463	0.00847	123	123	123	0	0	1	-360	360	-21.7565	2.6228	21.8610	-3.2483	0.0000	0.0000	0.0000	0.0000;
	2382	2302	0.031744	0.107504	0.010641	123	123	123	0	0	1	-360	360	-7.9717	4.9499	7.9975	-6.0940	0.0000	0.0000	0.0000	0.0000;
	2189	2153	0.02595	0.085124	0.008741	123	123	123	0	0	1	-360	360	-2.9330	0.3390	2.9350	-1.4201	0.0000	0.0000	0.0000	0.0000;
	2194	2192	0.00943	0.018893	0.001849	78	78	78	0	0	1	-360	360	-19.3900	10.1371	19.4295	-10.2701	0.0000	0.0000	0.0000	0.0000;
	2420	1934	0.017686	0.057438	0.00596	123	123	123	0	0	1	-360	360	-41.8224	-11.0186	42.1079	11.2497	0.0000	0.0000	0.0000	0.0000;
	1954	2420	0.052339	0.091554	0.008729	69	69	69	0	0	1	-360	360	-1.0350	1.1320	1.0367	-2.1372	0.0000	0.0000	0.0000	0.0000;
	2664	2719	0.03562	0.109421	0.011461	69	69	69	0	0	1	-360	360	16.3291	3.6064	-16.2474	-4.7678	0.0000	0.0000	0.0000	0.0000;
	2570	2699	0.036777	0.093967	0.009511	120	120	120	0	0	1	-360	360	-18.2527	-8.1640	18.3730	7.3215	0.0000	0.0000	0.0000	0.0000;
	2675	2629	0.002066	0.007273	0.000699	126	126	126	0	0	1	-360	360	-8.6029	1.3597	8.6042	-1.4416	0.0000	0.0000	0.0000	0.0000;
	2629	2475	0.018512	0.059504	0.00627	126	126	126	0	0	1	-360	360	-13.4622	-0.5584	13.4894	-0.1308	0.0000	0.0000	0.0000	0.0000;
	2563	2457	0.021	0.067901	0.00696	123	123	123	0	0	1	-360	360	-18.5656	4.1821	18.6280	-4.8384	0.0000	0.0000	0.0000	0.0000;
	2654	2658	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	-12.4275	1.3973	12.4701	-2.0487	0.0000	0.0000	0.0000	0.0000;
	2453	2720	0.066446	0.17719	0.01791	70	70	70	0	0	1	-360	360	-0.7572	-6.2687	0.7719	4.0821	0.0000	0.0000	0.0000	0.0000;
	2649	2720	0.039835	0.129091	0.013145	114	114	114	0	0	1	-360	360	-63.4223	-4.4926	64.7778	7.2826	0.0000	0.0000	0.0000	0.0000;
	2473	2509	0.033802	0.107438	0.011541	69	69	69	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2576	2615	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	6.2312	3.2825	-6.2219	-4.0371	0.0000	0.0000	0.0000	0.0000;
	2554	2519	0.04	0.129587	0.013291	114	114	114	0	0	1	-360	360	-56.0550	-23.4244	57.3341	25.9760	0.0000	0.0000	0.0000	0.0000;
	2524	2611	0.009917	0.033223	0.004189	107	107	107	0	0	1	-360	360	-29.7458	-10.8808	29.8306	10.6729	0.0000	0.0000	0.0000	0.0000;
	2554	2520	0.040248	0.130248	0.013361	107	107	107	0	0	1	-360	360	-56.2125	-23.3976	57.5053	25.9799	0.0000	0.0000	0.0000	0.0000;
	2613	2548	0.035446	0.087364	0.008821	114	114	114	0	0	1	-360	360	48.3668	-0.1436	-47.6692	0.8291	0.0000	0.0000	0.0000	0.0000;
	2722	2721	0.012636	0.038017	0.00273	114	114	114	0	0	1	-360	360	-11.7444	0.3174	11.7584	-0.6170	0.0000	0.0000	0.0000	0.0000;
	2523	2722	0.033058	0.082636	0.00968	69	69	69	0	0	1	-360	360	-10.2156	-0.3200	10.2434	-0.8174	0.0000	0.0000	0.0000	0.0000;
	2585	2524	0.046686	0.081818	0.007739	90	90	90	0	0	1	-360	360	0.6084	-4.4129	-0.6019	3.5228	0.0000	0.0000	0.0000	0.0000;
	2478	2469	0.034132	0.059917	0.00566	48	48	48	0	0	1	-360	360	-15.8199	-0.4820	15.8938	-0.0457	0.0000	0.0000	0.0000	0.0000;
	2491	2586	0.035868	0.058678	0.006459	90	90	90	0	0	1	-360	360	-16.9991	-0.9128	17.0903	0.3227	0.0000	0.0000	0.0000	0.0000;
	2491	2498	0.1	0.159496	0.01597	86	86	86	0	0	1	-360	360	-26.9867	-2.3112	27.6284	1.4687	0.0000	0.0000	0.0000	0.0000;
	2695	2599	0.039504	0.128099	0.013141	137	137	137	0	0	1	-360	360	-17.4995	2.0098	17.6001	-3.3096	0.0000	0.0000	0.0000	0.0000;
	2586	2468	0.03124	0.056033	0.005629	84	84	84	0	0	1	-360	360	-28.7152	-2.1712	28.9400	1.9207	0.0000	0.0000	0.0000	0.0000;
	2706	2488	0.021397	0.068868	0.007081	69	69	69	0	0	1	-360	360	6.3046	-1.3211	-6.2976	0.4613	0.0000	0.0000	0.0000	0.0000;
	2690	2706	0.016859	0.054273	0.005581	69	69	69	0	0	1	-360	360	9.3185	-1.4877	-9.3066	0.8298	0.0000	0.0000	0.0000	0.0000;
	2612	2706	0.000256	0.000661	7e-05	69	69	69	0	0	1	-360	360	-3.0020	-0.5000	3.0020	0.4913	0.0000	0.0000	0.0000	0.0000;
	2477	2476	0.012231	0.038603	0.004201	30	30	30	0	0	1	-360	360	6.6304	2.0495	-6.6250	-2.5000	0.0000	0.0000	0.0000	0.0000;
	2602	2484	0.028827	0.093223	0.009564	69	69	69	0	0	1	-360	360	-7.7105	-4.0982	7.7284	3.0401	0.0000	0.0000	0.0000	0.0000;
	2649	2481	0.01824	0.058992	0.00605	123	123	123	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2524	2674	0.024554	0.079917	0.00823	137	137	137	0	0	1	-360	360	9.1320	2.5140	-9.1126	-3.4081	0.0000	0.0000	0.0000	0.0000;
	2469	2688	0.06843	0.09157	0.0084	69	69	69	0	0	1	-360	360	-11.2033	-0.1553	11.2769	-0.7326	0.0000	0.0000	0.0000	0.0000;
	2688	2719	0.086529	0.11405	0.010191	57	57	57	0	0	1	-360	360	-20.6629	-2.2674	20.9776	1.4573	0.0000	0.0000	0.0000	0.0000;
	2571	2550	0.007851	0.019826	0.00203	120	120	120	0	0	1	-360	360	-36.4219	4.7100	36.5144	-4.7097	0.0000	0.0000	0.0000	0.0000;
	2609	2631	0.010331	0.026529	0.002691	109	109	109	0	0	1	-360	360	4.7507	7.3826	-4.7436	-7.6737	0.0000	0.0000	0.0000	0.0000;
	2588	2609	0.022314	0.057016	0.00576	120	120	120	0	0	1	-360	360	-3.7540	-1.2000	3.7569	0.5446	0.0000	0.0000	0.0000	0.0000;
	2587	2647	0.030992	0.079008	0.00801	120	120	120	0	0	1	-360	360	-1.9880	-0.7000	1.9890	-0.2937	0.0000	0.0000	0.0000	0.0000;
	2451	2553	0.002636	0.007521	0.00075	120	120	120	0	0	1	-360	360	-10.9048	-7.7172	10.9085	7.6341	0.0000	0.0000	0.0000	0.0000;
	2545	2527	0.030248	0.06281	0.00061	99	99	99	0	0	1	-360	360	-22.8776	-1.8155	23.0063	2.0067	0.0000	0.0000	0.0000	0.0000;
	2526	2458	0.003314	0.010826	0.001089	137	137	137	0	0	1	-360	360	-7.0148	0.0608	7.0161	-0.1925	0.0000	0.0000	0.0000	0.0000;
	2536	2528	0.04124	0.072314	0.00687	69	69	69	0	0	1	-360	360	-18.1360	-0.9839	18.2456	0.3198	0.0000	0.0000	0.0000	0.0000;
	2526	2466	0.018603	0.056198	0.00581	81	81	81	0	0	1	-360	360	-4.4442	-3.0608	4.4482	2.3465	0.0000	0.0000	0.0000	0.0000;
	2583	2604	0.024793	0.08	0.00823	137	137	137	0	0	1	-360	360	-18.0939	0.5226	18.1597	-1.3325	0.0000	0.0000	0.0000	0.0000;
	2451	2647	0.01314	0.041818	0.004479	137	137	137	0	0	1	-360	360	10.0611	1.6830	-10.0500	-2.2063	0.0000	0.0000	0.0000	0.0000;
	2646	2608	0.009421	0.030661	0.003151	103	103	103	0	0	1	-360	360	-24.2516	5.8412	24.3027	-6.0378	0.0000	0.0000	0.0000	0.0000;
	2646	2578	0.029008	0.09438	0.009661	76	76	76	0	0	1	-360	360	0.1771	-12.6350	-0.1404	11.6315	0.0000	0.0000	0.0000	0.0000;
	2464	2528	0.004207	0.010578	0.00106	120	120	120	0	0	1	-360	360	-30.2152	-6.2195	30.2472	6.1672	0.0000	0.0000	0.0000	0.0000;
	2708	2527	0.007364	0.023802	0.002439	90	90	90	0	0	1	-360	360	-14.6766	-8.0132	14.6930	7.7608	0.0000	0.0000	0.0000	0.0000;
	2708	2451	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-10.8802	-1.4934	10.8817	1.4344	0.0000	0.0000	0.0000	0.0000;
	2708	2451	0.00157	0.004959	0.000511	137	137	137	0	0	1	-360	360	-10.8802	-1.4934	10.8817	1.4344	0.0000	0.0000	0.0000	0.0000;
	2458	2464	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	-21.9221	-3.8075	21.9342	3.7195	0.0000	0.0000	0.0000	0.0000;
	2582	2571	0.008256	0.026281	0.00286	69	69	69	0	0	1	-360	360	-17.1250	-1.9245	17.1464	1.6653	0.0000	0.0000	0.0000	0.0000;
	2509	2582	0.018099	0.057016	0.0062	69	69	69	0	0	1	-360	360	-7.7290	-2.1000	7.7390	1.4245	0.0000	0.0000	0.0000	0.0000;
	2553	2528	0.00405	0.010578	0.001089	95	95	95	0	0	1	-360	360	-20.8455	-10.2341	20.8629	10.1433	0.0000	0.0000	0.0000	0.0000;
	2455	2451	0.002314	0.007521	0.00077	137	137	137	0	0	1	-360	360	-32.6222	-7.8822	32.6431	7.8542	0.0000	0.0000	0.0000	0.0000;
	2642	2455	0.003967	0.012984	0.001309	137	137	137	0	0	1	-360	360	-25.4233	-6.3735	25.4452	6.2822	0.0000	0.0000	0.0000	0.0000;
	2543	2536	0.008099	0.014207	0.00136	57	57	57	0	0	1	-360	360	-28.0839	-2.0607	28.1360	1.9839	0.0000	0.0000	0.0000	0.0000;
	2652	2543	0.064711	0.113388	0.010769	57	57	57	0	0	1	-360	360	-20.1375	-0.4936	20.3549	-0.4393	0.0000	0.0000	0.0000	0.0000;
	2474	2652	0.066612	0.113058	0.01118	69	69	69	0	0	1	-360	360	-22.3732	-3.9595	22.6646	3.1260	0.0000	0.0000	0.0000	0.0000;
	2630	2545	0.013223	0.033058	0.003269	114	114	114	0	0	1	-360	360	-17.7648	-0.1349	17.7986	-0.1845	0.0000	0.0000	0.0000	0.0000;
	2719	2630	0.05686	0.093388	0.00944	114	114	114	0	0	1	-360	360	-11.6282	0.6105	11.6918	-1.6651	0.0000	0.0000	0.0000	0.0000;
	2675	2527	0.037603	0.121653	0.01249	80	80	80	0	0	1	-360	360	-28.0431	0.6403	28.2830	-1.4188	0.0000	0.0000	0.0000	0.0000;
	2686	2578	0.030579	0.053719	0.00508	78	78	78	0	0	1	-360	360	-8.2810	-2.5000	8.3002	1.9393	0.0000	0.0000	0.0000	0.0000;
	2609	2529	0.008512	0.020744	0.002321	114	114	114	0	0	1	-360	360	-46.6401	2.4889	46.8013	-2.3642	0.0000	0.0000	0.0000	0.0000;
	2529	2672	0.040496	0.096686	0.010159	120	120	120	0	0	1	-360	360	-56.9263	2.3642	58.0616	-0.8530	0.0000	0.0000	0.0000	0.0000;
	2463	2642	0.001983	0.006281	0.000651	137	137	137	0	0	1	-360	360	-12.1709	-1.4467	12.1733	1.3735	0.0000	0.0000	0.0000	0.0000;
	2450	2463	0.006529	0.021157	0.0022	137	137	137	0	0	1	-360	360	4.3941	4.2864	-4.3921	-4.5533	0.0000	0.0000	0.0000	0.0000;
	2631	2571	0.009256	0.023802	0.00242	120	120	120	0	0	1	-360	360	-7.4024	4.1737	7.4084	-4.4360	0.0000	0.0000	0.0000	0.0000;
	2716	2608	0.062231	0.104132	0.010721	63	63	63	0	0	1	-360	360	-15.3512	-3.0957	15.4847	2.0970	0.0000	0.0000	0.0000	0.0000;
	2534	2716	0.047017	0.078512	0.00808	69	69	69	0	0	1	-360	360	-2.6500	-1.2000	2.6532	0.2957	0.0000	0.0000	0.0000	0.0000;
	2469	2474	0.005446	0.007603	0.00077	69	69	69	0	0	1	-360	360	-15.7364	-2.0330	15.7482	1.9595	0.0000	0.0000	0.0000	0.0000;
	2608	2571	0.016198	0.033802	0.003509	90	90	90	0	0	1	-360	360	-1.3958	9.0619	1.4081	-9.4394	0.0000	0.0000	0.0000	0.0000;
	2624	2465	0.007917	0.025612	0.005261	114	114	114	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2646	2624	0.02781	0.089942	0.01845	114	114	114	0	0	1	-360	360	4.1994	-0.2062	-4.1950	-1.9000	0.0000	0.0000	0.0000	0.0000;
	2450	2466	0.013967	0.044628	0.00462	126	126	126	0	0	1	-360	360	-11.0191	-6.2864	11.0368	5.7662	0.0000	0.0000	0.0000	0.0000;
	2604	2465	0.008678	0.028099	0.00295	88	88	88	0	0	1	-360	360	-31.4097	-2.6675	31.4788	2.5230	0.0000	0.0000	0.0000	0.0000;
	2641	2652	0.016066	0.052793	0.01083	69	69	69	0	0	1	-360	360	9.0548	3.9660	-9.0412	-5.2324	0.0000	0.0000	0.0000	0.0000;
	2626	2641	0.034	0.10995	0.022559	69	69	69	0	0	1	-360	360	12.0806	2.6513	-12.0358	-5.2660	0.0000	0.0000	0.0000	0.0000;
	2495	2527	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	-9.3860	-3.5000	9.3905	3.2782	0.0000	0.0000	0.0000	0.0000;
	2496	2528	0.00562	0.018934	0.00189	32	32	32	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.2371	0.0000	0.0000	0.0000	0.0000;
	2709	2451	0.002149	0.00719	0.000721	57	57	57	0	0	1	-360	360	-3.3130	-1.0000	3.3132	0.9106	0.0000	0.0000	0.0000	0.0000;
	2638	2528	0.000909	0.003058	0.00031	46	46	46	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0389	0.0000	0.0000	0.0000	0.0000;
	2548	2550	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	44.3562	-2.1291	-44.2434	2.2097	0.0000	0.0000	0.0000	0.0000;
	2677	2466	0.020496	0.06876	0.00688	137	137	137	0	0	1	-360	360	-17.9668	-3.6676	18.0218	2.9946	0.0000	0.0000	0.0000	0.0000;
	2462	2469	0.037397	0.120661	0.01272	140	140	140	0	0	1	-360	360	-3.8640	-1.2000	3.8689	-0.2660	0.0000	0.0000	0.0000	0.0000;
	2677	2626	0.019281	0.062364	0.006398	137	137	137	0	0	1	-360	360	14.3228	2.4676	-14.2896	-3.1513	0.0000	0.0000	0.0000	0.0000;
	2487	2702	0.004959	0.016364	0.00166	114	114	114	0	0	1	-360	360	-44.4970	-0.4168	44.5801	0.4942	0.0000	0.0000	0.0000	0.0000;
	2700	2487	0.001653	0.005372	0.000542	114	114	114	0	0	1	-360	360	-32.7646	5.5693	32.7800	-5.5832	0.0000	0.0000	0.0000	0.0000;
	2532	2701	0.057686	0.145446	0.014999	76	76	76	0	0	1	-360	360	-20.1373	5.4262	20.3548	-6.6542	0.0000	0.0000	0.0000	0.0000;
	2566	2702	0.031983	0.07876	0.00786	90	90	90	0	0	1	-360	360	-35.3983	7.8910	35.7578	-7.9345	0.0000	0.0000	0.0000	0.0000;
	2698	2701	0.01843	0.06	0.006149	137	137	137	0	0	1	-360	360	-24.8838	8.5831	24.9923	-8.9605	0.0000	0.0000	0.0000	0.0000;
	2682	2683	0.005537	0.017934	0.001839	137	137	137	0	0	1	-360	360	-6.7418	1.1234	6.7440	-1.3341	0.0000	0.0000	0.0000	0.0000;
	2585	2456	0.036364	0.120661	0.01181	114	114	114	0	0	1	-360	360	-12.6254	1.3129	12.6765	-2.5179	0.0000	0.0000	0.0000	0.0000;
	2683	2679	0.003058	0.009917	0.001019	114	114	114	0	0	1	-360	360	-19.6950	-11.5368	19.7084	11.4595	0.0000	0.0000	0.0000	0.0000;
	2510	2566	0.067603	0.119008	0.0112	69	69	69	0	0	1	-360	360	-3.5702	6.9525	3.6104	-8.2070	0.0000	0.0000	0.0000	0.0000;
	2692	2510	0.038678	0.068099	0.006389	69	69	69	0	0	1	-360	360	1.8575	7.4250	-1.8368	-8.1525	0.0000	0.0000	0.0000	0.0000;
	2627	2566	0.050422	0.104868	0.0102	69	69	69	0	0	1	-360	360	-17.2348	2.6660	17.3678	-3.5840	0.0000	0.0000	0.0000	0.0000;
	2644	2627	0.01976	0.051397	0.00515	69	69	69	0	0	1	-360	360	-17.0353	2.2981	17.0858	-2.7660	0.0000	0.0000	0.0000	0.0000;
	2569	2521	0.02781	0.079678	0.008071	69	69	69	0	0	1	-360	360	-19.9222	-16.3799	20.0706	15.8085	0.0000	0.0000	0.0000	0.0000;
	2692	2569	0.014669	0.032388	0.003279	69	69	69	0	0	1	-360	360	-15.8070	-15.5457	15.8662	15.2799	0.0000	0.0000	0.0000	0.0000;
	2461	2525	0.022314	0.072314	0.014929	75	75	75	0	0	1	-360	360	-22.3729	-14.5007	22.5032	13.1466	0.0000	0.0000	0.0000	0.0000;
	2456	2461	0.013223	0.017769	0.001909	62	62	62	0	0	1	-360	360	-14.5181	-13.3654	14.5619	13.2007	0.0000	0.0000	0.0000	0.0000;
	2676	2521	0.008835	0.027917	0.003049	137	137	137	0	0	1	-360	360	-18.0236	-5.0069	18.0483	4.7035	0.0000	0.0000	0.0000	0.0000;
	2508	2676	0.006876	0.021579	0.002398	137	137	137	0	0	1	-360	360	-14.7057	-4.2652	14.7186	4.0069	0.0000	0.0000	0.0000	0.0000;
	2623	2685	0.015537	0.054554	0.005571	137	137	137	0	0	1	-360	360	1.3228	2.9714	-1.3211	-3.6199	0.0000	0.0000	0.0000	0.0000;
	2486	2639	0.008512	0.021744	0.0022	120	120	120	0	0	1	-360	360	12.9027	-6.2556	-12.8881	6.0330	0.0000	0.0000	0.0000	0.0000;
	2639	2683	0.00281	0.007017	0.00059	114	114	114	0	0	1	-360	360	-5.1369	-10.2330	5.1400	10.1709	0.0000	0.0000	0.0000	0.0000;
	2473	2697	0.027686	0.089504	0.009169	95	95	95	0	0	1	-360	360	-28.1378	-0.4128	28.3247	-0.0657	0.0000	0.0000	0.0000	0.0000;
	2685	2473	0.021322	0.069421	0.007069	137	137	137	0	0	1	-360	360	-9.7939	2.4199	9.8128	-3.1872	0.0000	0.0000	0.0000	0.0000;
	2697	2703	0.015041	0.041322	0.004259	90	90	90	0	0	1	-360	360	-3.8763	10.4622	3.8928	-10.9218	0.0000	0.0000	0.0000	0.0000;
	2684	2682	0.017769	0.057364	0.005881	137	137	137	0	0	1	-360	360	-10.2338	-2.6699	10.2504	2.0291	0.0000	0.0000	0.0000	0.0000;
	2645	2519	0.007364	0.023802	0.00251	114	114	114	0	0	1	-360	360	-18.0992	-4.0273	18.1194	3.7788	0.0000	0.0000	0.0000	0.0000;
	2664	2577	0.004207	0.010744	0.00121	114	114	114	0	0	1	-360	360	-12.9724	-3.6768	12.9786	3.5419	0.0000	0.0000	0.0000	0.0000;
	2456	2644	0.023314	0.078934	0.007451	69	69	69	0	0	1	-360	360	-6.5080	4.4757	6.5213	-5.2981	0.0000	0.0000	0.0000	0.0000;
	2664	2518	0.002727	0.008256	0.000849	120	120	120	0	0	1	-360	360	1.5161	-1.9275	-1.5160	1.8223	0.0000	0.0000	0.0000	0.0000;
	2518	2508	0.001488	0.004959	0.000479	137	137	137	0	0	1	-360	360	-7.1950	-3.3223	7.1957	3.2652	0.0000	0.0000	0.0000	0.0000;
	2475	2521	0.028678	0.092562	0.009511	57	57	57	0	0	1	-360	360	-20.2494	-0.8692	20.3441	-0.0110	0.0000	0.0000	0.0000	0.0000;
	2486	2532	0.013636	0.035537	0.0037	120	120	120	0	0	1	-360	360	-13.5037	6.0556	13.5293	-6.4262	0.0000	0.0000	0.0000	0.0000;
	2682	2679	0.004207	0.013554	0.001401	131	131	131	0	0	1	-360	360	-23.3395	-6.7893	23.3605	6.6906	0.0000	0.0000	0.0000	0.0000;
	2623	2684	0.005289	0.010744	0.001111	90	90	90	0	0	1	-360	360	-6.3738	-2.3964	6.3758	2.2699	0.0000	0.0000	0.0000	0.0000;
	2703	2700	0.009339	0.016529	0.00174	90	90	90	0	0	1	-360	360	-18.7628	7.8218	18.7956	-7.9693	0.0000	0.0000	0.0000	0.0000;
	2702	2559	0.034793	0.10281	0.01045	99	99	99	0	0	1	-360	360	-27.5614	11.5877	27.8277	-12.0385	0.0000	0.0000	0.0000	0.0000;
	2558	2520	0.02124	0.068603	0.00704	99	99	99	0	0	1	-360	360	-33.7201	-11.1634	33.9374	10.9933	0.0000	0.0000	0.0000	0.0000;
	2525	2519	0.031397	0.098843	0.01074	126	126	126	0	0	1	-360	360	-29.8632	-14.8466	30.1481	14.4238	0.0000	0.0000	0.0000	0.0000;
	2560	2679	0.008512	0.02686	0.002899	40	40	40	0	0	1	-360	360	-2.2808	4.6504	2.2828	-4.9886	0.0000	0.0000	0.0000	0.0000;
	2555	2560	0.018099	0.057016	0.0062	40	40	40	0	0	1	-360	360	-2.2772	3.9226	2.2808	-4.6504	0.0000	0.0000	0.0000	0.0000;
	2472	2679	0.01719	0.057769	0.005779	69	69	69	0	0	1	-360	360	-17.1800	-4.1299	17.2252	3.5984	0.0000	0.0000	0.0000	0.0000;
	2561	2701	0.015793	0.040174	0.00408	102	102	102	0	0	1	-360	360	58.3945	-12.6360	-57.9235	13.3479	0.0000	0.0000	0.0000	0.0000;
	2611	2558	0.033636	0.107438	0.010159	107	107	107	0	0	1	-360	360	-29.9796	-10.7729	30.2651	10.4634	0.0000	0.0000	0.0000	0.0000;
	2645	2577	0.008256	0.016529	0.001941	114	114	114	0	0	1	-360	360	13.8942	3.4273	-13.8806	-3.6419	0.0000	0.0000	0.0000	0.0000;
	2697	2712	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	50.1640	4.8723	-50.0580	-4.8000	0.0000	0.0000	0.0000	0.0000;
	2697	2713	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	50.1467	4.3719	-50.0410	-4.3000	0.0000	0.0000	0.0000	0.0000;
	2514	2679	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	0.0000	-0.0000	0.0000	-0.0868	0.0000	0.0000	0.0000	0.0000;
	2515	2680	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-0.3000	-0.1000	0.3000	0.0132	0.0000	0.0000	0.0000	0.0000;
	2687	2682	0.004959	0.007438	0.000731	114	114	114	0	0	1	-360	360	-7.7350	-1.2034	7.7375	1.1208	0.0000	0.0000	0.0000	0.0000;
	2689	2623	0.025405	0.082157	0.008429	123	123	123	0	0	1	-360	360	-1.4465	-0.2150	1.4470	-0.7750	0.0000	0.0000	0.0000	0.0000;
	2689	2472	0.016364	0.052893	0.005581	140	140	140	0	0	1	-360	360	-1.8585	-0.8850	1.8590	0.2299	0.0000	0.0000	0.0000	0.0000;
	2555	2692	0.020413	0.06843	0.006851	123	123	123	0	0	1	-360	360	-3.1298	-5.2226	3.1355	4.4207	0.0000	0.0000	0.0000	0.0000;
	2687	2682	0.009917	0.034876	0.00407	76	76	76	0	0	1	-360	360	-1.7280	-1.0966	1.7284	0.6159	0.0000	0.0000	0.0000	0.0000;
	2699	2664	0.020174	0.052231	0.00545	120	120	120	0	0	1	-360	360	-24.4460	-9.7215	24.5591	9.3424	0.0000	0.0000	0.0000	0.0000;
	2664	2520	0.009504	0.024554	0.00256	114	114	114	0	0	1	-360	360	-34.8389	-8.0445	34.9365	7.9770	0.0000	0.0000	0.0000	0.0000;
	2668	2653	0.01405	0.023141	0.00234	90	90	90	0	0	1	-360	360	-27.4840	5.4566	27.5728	-5.6022	0.0000	0.0000	0.0000	0.0000;
	2661	2663	0.03286	0.076678	0.00771	69	69	69	0	0	1	-360	360	25.6644	-4.3747	-25.4879	3.8235	0.0000	0.0000	0.0000	0.0000;
	2658	2660	0.042231	0.098959	0.00974	69	69	69	0	0	1	-360	360	-17.9751	1.0487	18.0859	-2.0050	0.0000	0.0000	0.0000	0.0000;
	2662	2720	0.073058	0.191901	0.018319	69	69	69	0	0	1	-360	360	11.3548	-7.5760	-11.2548	5.5524	0.0000	0.0000	0.0000	0.0000;
	2663	2589	0.030909	0.081066	0.007739	69	69	69	0	0	1	-360	360	12.1326	-7.2958	-12.0844	6.4579	0.0000	0.0000	0.0000	0.0000;
	2589	2721	0.042066	0.110744	0.010529	69	69	69	0	0	1	-360	360	10.5824	-6.8579	-10.5317	5.6752	0.0000	0.0000	0.0000	0.0000;
	2659	2662	0.016529	0.033058	0.00242	69	69	69	0	0	1	-360	360	1.9066	-7.9699	-1.8979	7.6867	0.0000	0.0000	0.0000	0.0000;
	2563	2482	0.040496	0.071066	0.00673	90	90	90	0	0	1	-360	360	10.7183	-8.5676	-10.6586	7.8422	0.0000	0.0000	0.0000	0.0000;
	2482	2659	0.046281	0.071066	0.007599	78	78	78	0	0	1	-360	360	7.4556	-8.3422	-7.4116	7.4699	0.0000	0.0000	0.0000	0.0000;
	2662	2668	0.004959	0.008256	0.000849	78	78	78	0	0	1	-360	360	-20.4596	6.3814	20.4780	-6.4566	0.0000	0.0000	0.0000	0.0000;
	2564	2563	0.004132	0.013719	0.001379	137	137	137	0	0	1	-360	360	2.0612	-3.5536	-2.0607	3.3855	0.0000	0.0000	0.0000	0.0000;
	2660	2690	0.013364	0.029686	0.00296	69	69	69	0	0	1	-360	360	20.8749	0.2450	-20.8285	-0.5123	0.0000	0.0000	0.0000	0.0000;
	2653	2661	0.008678	0.027769	0.004777	69	69	69	0	0	1	-360	360	-40.8848	4.6022	41.0025	-4.8237	0.0000	0.0000	0.0000	0.0000;
	2573	2721	0.04438	0.078256	0.007391	46	46	46	0	0	1	-360	360	-6.5815	-3.4224	6.6001	2.5334	0.0000	0.0000	0.0000	0.0000;
	2603	2573	0.056612	0.099826	0.009431	46	46	46	0	0	1	-360	360	1.0301	-3.5833	-1.0255	2.4224	0.0000	0.0000	0.0000	0.0000;
	2467	2603	0.019752	0.062149	0.006749	90	90	90	0	0	1	-360	360	3.0350	-3.4083	-3.0321	2.5833	0.0000	0.0000	0.0000	0.0000;
	2497	2467	0.036686	0.064711	0.00611	90	90	90	0	0	1	-360	360	11.2818	-3.0939	-11.2420	2.4083	0.0000	0.0000	0.0000	0.0000;
	2483	2663	0.035868	0.071322	0.006241	38	38	38	0	0	1	-360	360	-9.8143	3.3077	9.8460	-4.0203	0.0000	0.0000	0.0000	0.0000;
	2695	2564	0.03438	0.060992	0.005689	137	137	137	0	0	1	-360	360	9.0925	-3.2098	-9.0672	2.5536	0.0000	0.0000	0.0000	0.0000;
	2497	2483	0.035868	0.071322	0.006241	90	90	90	0	0	1	-360	360	-9.7838	2.6939	9.8143	-3.4077	0.0000	0.0000	0.0000	0.0000;
	2481	2522	0.020397	0.06595	0.006771	90	90	90	0	0	1	-360	360	-2.8020	1.0000	2.8037	-1.7769	0.0000	0.0000	0.0000	0.0000;
	2478	2522	0.014554	0.047471	0.00483	120	120	120	0	0	1	-360	360	6.3119	-1.5180	-6.3067	0.9769	0.0000	0.0000	0.0000	0.0000;
	2501	2610	0.006612	0.015703	0.001689	103	103	103	0	0	1	-360	360	21.6159	0.6849	-21.5900	-0.8243	0.0000	0.0000	0.0000	0.0000;
	2506	2470	0.009826	0.017364	0.0016	137	137	137	0	0	1	-360	360	-57.6489	-0.4137	57.9253	0.7122	0.0000	0.0000	0.0000	0.0000;
	2470	2502	0.030248	0.097521	0.010019	86	86	86	0	0	1	-360	360	6.9778	-3.1617	-6.9638	2.0111	0.0000	0.0000	0.0000	0.0000;
	2538	2503	0.011488	0.034711	0.002931	120	120	120	0	0	1	-360	360	-0.9791	-7.8324	0.9849	7.5029	0.0000	0.0000	0.0000	0.0000;
	2696	2538	0.008256	0.028934	0.00363	120	120	120	0	0	1	-360	360	7.6566	-6.2375	-7.6499	5.8324	0.0000	0.0000	0.0000	0.0000;
	2567	2498	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-20.2339	-8.0944	20.2389	8.0641	0.0000	0.0000	0.0000	0.0000;
	2567	2579	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	3.9992	0.9539	-3.9990	-1.0000	0.0000	0.0000	0.0000	0.0000;
	2567	2579	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	3.9992	0.9539	-3.9990	-1.0000	0.0000	0.0000	0.0000	0.0000;
	2505	2696	0.010826	0.034711	0.003579	137	137	137	0	0	1	-360	360	22.1193	-3.4132	-22.0736	3.1375	0.0000	0.0000	0.0000	0.0000;
	2513	2505	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-9.6250	-3.6011	9.6262	3.5588	0.0000	0.0000	0.0000	0.0000;
	2671	2513	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	4.6872	0.5536	-4.6870	-0.5989	0.0000	0.0000	0.0000	0.0000;
	2506	2671	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	9.9493	1.8112	-9.9482	-1.8536	0.0000	0.0000	0.0000	0.0000;
	2470	2717	0.036686	0.118182	0.01217	95	95	95	0	0	1	-360	360	-47.6127	-5.0732	48.3155	5.8559	0.0000	0.0000	0.0000	0.0000;
	2694	2717	0.017364	0.05686	0.005779	137	137	137	0	0	1	-360	360	-52.8706	-7.7980	53.2784	8.4242	0.0000	0.0000	0.0000	0.0000;
	2678	2499	0.032479	0.108099	0.01445	137	137	137	0	0	1	-360	360	-21.5875	-3.8957	21.7182	2.6093	0.0000	0.0000	0.0000	0.0000;
	2667	2498	0.054554	0.180174	0.0242	99	99	99	0	0	1	-360	360	-35.8599	-8.8473	36.5086	8.1737	0.0000	0.0000	0.0000	0.0000;
	2500	2502	0.019174	0.02595	0.004671	69	69	69	0	0	1	-360	360	-1.9564	2.4851	1.9583	-3.0405	0.0000	0.0000	0.0000	0.0000;
	2610	2503	0.01405	0.036364	0.003991	103	103	103	0	0	1	-360	360	9.6980	-1.1757	-9.6868	0.7307	0.0000	0.0000	0.0000	0.0000;
	2635	2502	0.035868	0.090083	0.00924	114	114	114	0	0	1	-360	360	-7.6509	-4.9600	7.6746	3.9226	0.0000	0.0000	0.0000	0.0000;
	2707	2503	0.015	0.047141	0.004661	114	114	114	0	0	1	-360	360	-2.4974	-3.2794	2.4993	2.7331	0.0000	0.0000	0.0000	0.0000;
	2665	2707	0.005248	0.016504	0.001631	114	114	114	0	0	1	-360	360	1.8181	-2.6791	-1.8176	2.4876	0.0000	0.0000	0.0000	0.0000;
	2704	2707	0.000256	0.000661	7e-05	114	114	114	0	0	1	-360	360	-4.3150	-0.8000	4.3150	0.7918	0.0000	0.0000	0.0000	0.0000;
	2636	2693	0.041744	0.073223	0.006921	90	90	90	0	0	1	-360	360	-18.8866	-0.2311	19.0107	-0.3873	0.0000	0.0000	0.0000	0.0000;
	2693	2718	0.023058	0.07438	0.00765	137	137	137	0	0	1	-360	360	-40.0567	-4.7127	40.3644	4.7655	0.0000	0.0000	0.0000	0.0000;
	2505	2681	0.000992	0.003471	0.000361	137	137	137	0	0	1	-360	360	-9.5580	-2.0606	9.5588	2.0208	0.0000	0.0000	0.0000	0.0000;
	2618	2665	0.003636	0.010744	0.00106	114	114	114	0	0	1	-360	360	16.9810	0.8217	-16.9721	-0.9209	0.0000	0.0000	0.0000	0.0000;
	2500	2622	0.004628	0.014876	0.00152	137	137	137	0	0	1	-360	360	45.3079	6.7365	-45.2265	-6.6562	0.0000	0.0000	0.0000	0.0000;
	2512	2635	0.003719	0.009339	0.000939	120	120	120	0	0	1	-360	360	5.3994	-3.6675	-5.3981	3.5600	0.0000	0.0000	0.0000	0.0000;
	2506	2512	0.004959	0.012727	0.00128	95	95	95	0	0	1	-360	360	16.9876	-1.1874	-16.9754	1.0675	0.0000	0.0000	0.0000	0.0000;
	2479	2567	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	-7.2822	-5.3052	7.2896	4.9866	0.0000	0.0000	0.0000	0.0000;
	2502	2479	0.011157	0.015289	0.002749	114	114	114	0	0	1	-360	360	3.4544	-4.1299	-3.4518	3.8052	0.0000	0.0000	0.0000	0.0000;
	2503	2666	0.014959	0.043802	0.00445	114	114	114	0	0	1	-360	360	-4.4718	1.1239	4.4746	-1.6440	0.0000	0.0000	0.0000	0.0000;
	2504	2499	0.007603	0.019826	0.002059	120	120	120	0	0	1	-360	360	-27.8743	-5.7401	27.9258	5.6273	0.0000	0.0000	0.0000	0.0000;
	2575	2503	0.034793	0.111901	0.011761	76	76	76	0	0	1	-360	360	-5.1170	-2.4201	5.1256	1.0563	0.0000	0.0000	0.0000	0.0000;
	2678	2575	0.007017	0.022397	0.002369	123	123	123	0	0	1	-360	360	5.7241	1.3069	-5.7220	-1.5799	0.0000	0.0000	0.0000	0.0000;
	2616	2673	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	-2.3420	-2.7569	2.3429	2.5035	0.0000	0.0000	0.0000	0.0000;
	2678	2616	0.00843	0.021488	0.002161	120	120	120	0	0	1	-360	360	-0.2366	-2.4112	0.2370	2.1569	0.0000	0.0000	0.0000	0.0000;
	2565	2570	0.019917	0.052446	0.005191	120	120	120	0	0	1	-360	360	-7.7162	-4.1496	7.7287	3.5640	0.0000	0.0000	0.0000	0.0000;
	2673	2565	0.011868	0.03176	0.003151	120	120	120	0	0	1	-360	360	-7.3939	-4.5035	7.4012	4.1496	0.0000	0.0000	0.0000	0.0000;
	2621	2500	0.005041	0.016859	0.00174	137	137	137	0	0	1	-360	360	0.2593	2.0940	-0.2591	-2.3012	0.0000	0.0000	0.0000	0.0000;
	2448	2500	0.003314	0.010909	0.001111	137	137	137	0	0	1	-360	360	16.6141	4.3381	-16.6059	-4.4440	0.0000	0.0000	0.0000	0.0000;
	2666	2628	0.007769	0.024793	0.00257	137	137	137	0	0	1	-360	360	-4.5796	1.6440	4.5812	-1.9440	0.0000	0.0000	0.0000	0.0000;
	2590	2471	0.007107	0.023141	0.00234	124	124	124	0	0	1	-360	360	-30.8620	-6.1956	30.9213	6.1104	0.0000	0.0000	0.0000	0.0000;
	2622	2591	0.003058	0.009917	0.001019	137	137	137	0	0	1	-360	360	36.1765	3.8562	-36.1425	-3.8666	0.0000	0.0000	0.0000	0.0000;
	2640	2636	0.006446	0.020661	0.00213	137	137	137	0	0	1	-360	360	-41.3117	-0.3588	41.4038	0.3989	0.0000	0.0000	0.0000	0.0000;
	2632	2498	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	-19.2255	-1.1392	19.2294	1.1029	0.0000	0.0000	0.0000	0.0000;
	2633	2499	0.00124	0.004132	0.000409	137	137	137	0	0	1	-360	360	0.0000	0.0000	0.0000	-0.0492	0.0000	0.0000	0.0000	0.0000;
	2499	2501	0.020744	0.067273	0.00682	137	137	137	0	0	1	-360	360	17.6163	1.6726	-17.5620	-2.3128	0.0000	0.0000	0.0000	0.0000;
	2632	2517	0.005446	0.017364	0.001769	137	137	137	0	0	1	-360	360	2.3645	2.1392	-2.3640	-2.3495	0.0000	0.0000	0.0000	0.0000;
	2499	2448	0.006124	0.015703	0.001571	120	120	120	0	0	1	-360	360	26.2583	6.3453	-26.2211	-6.4381	0.0000	0.0000	0.0000	0.0000;
	2597	2501	0.001322	0.004207	0.00044	137	137	137	0	0	1	-360	360	16.5822	0.3521	-16.5792	-0.3949	0.0000	0.0000	0.0000	0.0000;
	2498	2597	0.007934	0.022314	0.002149	123	123	123	0	0	1	-360	360	31.0638	3.1768	-30.9992	-3.2521	0.0000	0.0000	0.0000	0.0000;
	2517	2621	0.009091	0.028934	0.002899	137	137	137	0	0	1	-360	360	1.9430	2.2495	-1.9423	-2.5940	0.0000	0.0000	0.0000	0.0000;
	2628	2669	0.007364	0.023719	0.00242	137	137	137	0	0	1	-360	360	-13.3202	-2.2560	13.3314	2.0048	0.0000	0.0000	0.0000	0.0000;
	2471	2640	0.003314	0.010744	0.001089	137	137	137	0	0	1	-360	360	-33.2828	2.6116	33.3137	-2.6412	0.0000	0.0000	0.0000	0.0000;
	2681	2540	0.002066	0.006942	0.000699	137	137	137	0	0	1	-360	360	-15.4778	-4.4208	15.4823	4.3533	0.0000	0.0000	0.0000	0.0000;
	2694	2636	0.011322	0.036364	0.003751	137	137	137	0	0	1	-360	360	39.6106	6.2980	-39.4602	-6.2678	0.0000	0.0000	0.0000	0.0000;
	2540	2590	0.002893	0.009256	0.000939	137	137	137	0	0	1	-360	360	-25.4793	-6.0533	25.4960	5.9956	0.0000	0.0000	0.0000	0.0000;
	2591	2618	0.002479	0.007438	0.000731	120	120	120	0	0	1	-360	360	22.2525	2.5666	-22.2420	-2.6217	0.0000	0.0000	0.0000	0.0000;
	2541	2504	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-17.5480	-3.9594	17.5613	3.7401	0.0000	0.0000	0.0000	0.0000;
	2669	2541	0.004917	0.023016	0.00236	120	120	120	0	0	1	-360	360	-13.4364	-2.0048	13.4440	1.7594	0.0000	0.0000	0.0000	0.0000;
	2599	2718	0.001653	0.004959	0.00053	137	137	137	0	0	1	-360	360	-23.4931	2.1096	23.5005	-2.1531	0.0000	0.0000	0.0000	0.0000;
	2477	2667	0.039504	0.124554	0.011761	38	38	38	0	0	1	-360	360	-10.3134	-2.9495	10.3530	1.7553	0.0000	0.0000	0.0000	0.0000;
	2537	2503	0.039504	0.069587	0.00657	72	72	72	0	0	1	-360	360	-37.2655	-6.9836	37.7586	7.0855	0.0000	0.0000	0.0000	0.0000;
	2535	2537	0.053058	0.093554	0.00884	72	72	72	0	0	1	-360	360	-26.9169	-3.9622	27.2685	3.5836	0.0000	0.0000	0.0000	0.0000;
	2657	2535	0.032934	0.106504	0.010926	137	137	137	0	0	1	-360	360	-0.7762	2.5662	0.7794	-3.7740	0.0000	0.0000	0.0000	0.0000;
	2656	2535	0.058066	0.103058	0.00937	76	76	76	0	0	1	-360	360	-7.8930	-4.0000	7.9325	3.0362	0.0000	0.0000	0.0000	0.0000;
	2667	2657	0.024438	0.079025	0.008107	137	137	137	0	0	1	-360	360	4.9180	4.7919	-4.9068	-5.6662	0.0000	0.0000	0.0000	0.0000;
	2457	2717	0.021388	0.069537	0.007289	120	120	120	0	0	1	-360	360	-24.9420	1.8384	25.0507	-2.3867	0.0000	0.0000	0.0000	0.0000;
	2643	2503	0.00124	0.004132	0.00039	128	128	128	0	0	1	-360	360	-5.4880	-1.4000	5.4883	1.3549	0.0000	0.0000	0.0000	0.0000;
	2500	2711	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	6.3156	1.0236	-6.3140	-1.2000	0.0000	0.0000	0.0000	0.0000;
	2501	2710	0.004628	0.014876	0.00152	120	120	120	0	0	1	-360	360	5.4742	0.9228	-5.4730	-1.1000	0.0000	0.0000	0.0000	0.0000;
	2617	2499	0.01281	0.021488	0.00212	78	78	78	0	0	1	-360	360	-35.5886	-4.0935	35.7265	4.0712	0.0000	0.0000	0.0000	0.0000;
	2468	2617	0.026198	0.043967	0.004339	78	78	78	0	0	1	-360	360	-31.8860	-3.4207	32.1156	3.2935	0.0000	0.0000	0.0000	0.0000;
	2580	2452	0.038843	0.12562	0.012901	95	95	95	0	0	1	-360	360	-18.8671	0.3413	18.9875	-1.4463	0.0000	0.0000	0.0000	0.0000;
	2705	2595	0.011653	0.037686	0.00387	137	137	137	0	0	1	-360	360	-31.6330	-1.9469	31.7324	1.8114	0.0000	0.0000	0.0000	0.0000;
	2452	2705	0.021397	0.069174	0.0071	137	137	137	0	0	1	-360	360	-26.9945	-0.4537	27.1284	0.0554	0.0000	0.0000	0.0000	0.0000;
	2460	2705	0.00281	0.009174	0.000939	123	123	123	0	0	1	-360	360	-4.5040	-2.0000	4.5046	1.8914	0.0000	0.0000	0.0000	0.0000;
	2670	2594	0.158017	0.182727	0.016429	46	46	46	0	0	1	-360	360	-11.2250	-0.9901	11.3983	-0.7271	0.0000	0.0000	0.0000	0.0000;
	2607	2595	0.009826	0.017521	0.0016	80	80	80	0	0	1	-360	360	-24.0071	-5.9513	24.0580	5.8530	0.0000	0.0000	0.0000	0.0000;
	2507	2592	0.010388	0.050826	0.004939	133	133	133	0	0	1	-360	360	-24.4149	-3.1252	24.4680	2.7996	0.0000	0.0000	0.0000	0.0000;
	2568	2592	0.036033	0.128934	0.012509	69	69	69	0	0	1	-360	360	-26.7901	0.1358	27.0111	-0.8216	0.0000	0.0000	0.0000	0.0000;
	2484	2594	0.022339	0.074959	0.00748	69	69	69	0	0	1	-360	360	-13.2334	-5.0401	13.2708	4.2838	0.0000	0.0000	0.0000	0.0000;
	2449	2568	0.041397	0.069421	0.00711	69	69	69	0	0	1	-360	360	-18.3609	0.7651	18.4819	-1.3900	0.0000	0.0000	0.0000	0.0000;
	2516	2568	0.033141	0.061157	0.006389	69	69	69	0	0	1	-360	360	-2.0020	-0.5000	2.0031	-0.2458	0.0000	0.0000	0.0000	0.0000;
	2549	2449	0.037686	0.121488	0.01249	69	69	69	0	0	1	-360	360	-10.3184	0.7364	10.3539	-2.0651	0.0000	0.0000	0.0000	0.0000;
	2551	2549	0.019422	0.06281	0.00649	69	69	69	0	0	1	-360	360	-7.3070	1.0185	7.3164	-1.7364	0.0000	0.0000	0.0000	0.0000;
	2596	2592	0.035868	0.115702	0.012199	140	140	140	0	0	1	-360	360	-3.4171	-4.1960	3.4243	2.7747	0.0000	0.0000	0.0000	0.0000;
	2530	2593	0.030248	0.097521	0.01028	140	140	140	0	0	1	-360	360	-10.6043	-2.1688	10.6337	1.0456	0.0000	0.0000	0.0000	0.0000;
	2562	2524	0.009826	0.017273	0.001631	69	69	69	0	0	1	-360	360	-6.6996	-2.0271	6.7037	1.8440	0.0000	0.0000	0.0000	0.0000;
	2601	2562	0.053223	0.093471	0.008821	69	69	69	0	0	1	-360	360	3.3134	-0.3483	-3.3084	-0.6729	0.0000	0.0000	0.0000	0.0000;
	2605	2598	0.006612	0.013719	0.001331	69	69	69	0	0	1	-360	360	6.0771	-0.2217	-6.0750	0.0694	0.0000	0.0000	0.0000	0.0000;
	2598	2606	0.005372	0.017364	0.001791	69	69	69	0	0	1	-360	360	-5.9350	-3.0694	5.9370	2.8652	0.0000	0.0000	0.0000	0.0000;
	2580	2551	0.023388	0.075868	0.007841	34	34	34	0	0	1	-360	360	3.6255	-1.5527	-3.6226	0.6588	0.0000	0.0000	0.0000	0.0000;
	2606	2594	0.01157	0.037686	0.00387	69	69	69	0	0	1	-360	360	-15.2450	-5.7652	15.2708	5.3922	0.0000	0.0000	0.0000	0.0000;
	2581	2593	0.033099	0.111066	0.011059	114	114	114	0	0	1	-360	360	-22.2637	-8.5558	22.4235	7.7944	0.0000	0.0000	0.0000	0.0000;
	2584	2596	0.028182	0.091157	0.009341	69	69	69	0	0	1	-360	360	3.5945	-3.7774	-3.5889	2.6960	0.0000	0.0000	0.0000	0.0000;
	2601	2507	0.024463	0.043471	0.004039	69	69	69	0	0	1	-360	360	-19.8274	-2.6517	19.9109	2.3252	0.0000	0.0000	0.0000	0.0000;
	2600	2595	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	-8.0070	-2.0000	8.0108	1.8502	0.0000	0.0000	0.0000	0.0000;
	2607	2605	0.006612	0.013719	0.001331	114	114	114	0	0	1	-360	360	11.0881	1.3361	-11.0811	-1.4783	0.0000	0.0000	0.0000	0.0000;
	2581	2576	0.020496	0.06876	0.00688	69	69	69	0	0	1	-360	360	9.2527	4.5558	-9.2332	-5.2825	0.0000	0.0000	0.0000	0.0000;
	2637	2551	0.058182	0.094207	0.00944	84	84	84	0	0	1	-360	360	-4.0030	-1.0000	4.0112	-0.0717	0.0000	0.0000	0.0000	0.0000;
	2592	2594	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	19.2944	-1.0389	-19.2542	0.6653	0.0000	0.0000	0.0000	0.0000;
	2593	2595	0.01281	0.042984	0.004281	114	114	114	0	0	1	-360	360	20.8106	-1.2671	-20.7639	0.9156	0.0000	0.0000	0.0000	0.0000;
	2530	2607	0.014463	0.055537	0.004479	69	69	69	0	0	1	-360	360	5.0993	-0.1312	-5.0961	-0.3849	0.0000	0.0000	0.0000	0.0000;
	2453	2490	0.023554	0.062149	0.006389	82	82	82	0	0	1	-360	360	-28.2871	2.5968	28.4416	-2.9800	0.0000	0.0000	0.0000	0.0000;
	2531	2453	0.027603	0.049504	0.004479	69	69	69	0	0	1	-360	360	-10.0743	-0.7914	10.0972	0.2815	0.0000	0.0000	0.0000	0.0000;
	2511	2531	0.039669	0.07157	0.006411	69	69	69	0	0	1	-360	360	-6.5572	-1.0505	6.5713	0.2914	0.0000	0.0000	0.0000	0.0000;
	2542	2511	0.029826	0.057934	0.005469	69	69	69	0	0	1	-360	360	-3.0518	-1.2126	3.0542	0.5505	0.0000	0.0000	0.0000	0.0000;
	2547	2489	0.009256	0.030083	0.003071	119	119	119	0	0	1	-360	360	-21.8554	-6.0151	21.8937	5.7591	0.0000	0.0000	0.0000	0.0000;
	2655	2649	0.053141	0.093388	0.008901	69	69	69	0	0	1	-360	360	-15.2420	2.1263	15.3503	-2.9867	0.0000	0.0000	0.0000	0.0000;
	2544	2547	0.001322	0.004207	0.00044	99	99	99	0	0	1	-360	360	-7.3417	-3.5673	7.3424	3.5151	0.0000	0.0000	0.0000	0.0000;
	2546	2490	0.009091	0.029752	0.00302	137	137	137	0	0	1	-360	360	-14.2776	-2.6766	14.2930	2.3523	0.0000	0.0000	0.0000	0.0000;
	2488	2489	0.055041	0.164298	0.016819	69	69	69	0	0	1	-360	360	6.2946	-2.4613	-6.2762	0.4237	0.0000	0.0000	0.0000	0.0000;
	2714	2485	0.036529	0.064132	0.00605	69	69	69	0	0	1	-360	360	3.3065	-0.6932	-3.3030	0.0000	0.0000	0.0000	0.0000	0.0000;
	2557	2546	0.01595	0.05124	0.0053	137	137	137	0	0	1	-360	360	-3.2651	-3.3240	3.2676	2.6766	0.0000	0.0000	0.0000	0.0000;
	2557	2544	0.007438	0.023967	0.002461	126	126	126	0	0	1	-360	360	2.6668	-1.3695	-2.6663	1.0673	0.0000	0.0000	0.0000	0.0000;
	2620	2523	0.036686	0.116686	0.012509	69	69	69	0	0	1	-360	360	-4.7041	-0.3531	4.7106	-1.1800	0.0000	0.0000	0.0000	0.0000;
	2714	2655	0.083141	0.146281	0.01392	69	69	69	0	0	1	-360	360	-13.1147	0.7241	13.2400	-2.1263	0.0000	0.0000	0.0000	0.0000;
	2691	2489	0.026612	0.089422	0.008949	137	137	137	0	0	1	-360	360	-22.7136	-3.0053	22.8269	2.2811	0.0000	0.0000	0.0000	0.0000;
	2557	2654	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	-6.9078	2.1935	6.9225	-2.8973	0.0000	0.0000	0.0000	0.0000;
	2539	2542	0.005207	0.014132	0.001401	90	90	90	0	0	1	-360	360	-10.0080	-1.0000	10.0123	0.8412	0.0000	0.0000	0.0000	0.0000;
	2542	2691	0.01843	0.061901	0.0062	137	137	137	0	0	1	-360	360	-16.1686	-2.1285	16.2086	1.5053	0.0000	0.0000	0.0000	0.0000;
	2480	2714	0.001818	0.003876	0.000271	76	76	76	0	0	1	-360	360	-3.8030	-0.0000	3.8032	-0.0309	0.0000	0.0000	0.0000	0.0000;
	2648	2649	0.003471	0.012636	0.001191	123	123	123	0	0	1	-360	360	-33.0270	-6.0000	33.0601	5.9793	0.0000	0.0000	0.0000	0.0000;
	2454	2651	0.037603	0.091744	0.00968	99	99	99	0	0	1	-360	360	10.0399	1.3897	-10.0080	-2.5000	0.0000	0.0000	0.0000	0.0000;
	2620	2650	0.019669	0.086124	0.00924	57	57	57	0	0	1	-360	360	0.0001	-1.1469	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2494	2715	0.003314	0.010578	0.001089	137	137	137	0	0	1	-360	360	-14.3138	-1.0277	14.3198	0.9231	0.0000	0.0000	0.0000	0.0000;
	2634	2494	0.029752	0.095868	0.01007	137	137	137	0	0	1	-360	360	-7.8924	-0.4159	7.9088	-0.6723	0.0000	0.0000	0.0000	0.0000;
	2572	2634	0.005124	0.016529	0.00174	137	137	137	0	0	1	-360	360	-0.5863	0.9875	0.5864	-1.1841	0.0000	0.0000	0.0000	0.0000;
	2552	2586	0.033471	0.065289	0.005929	21	21	21	0	0	1	-360	360	-7.1060	-1.2000	7.1210	0.5485	0.0000	0.0000	0.0000	0.0000;
	2459	2619	0.016529	0.031397	0.002899	48	48	48	0	0	1	-360	360	0.0815	4.7990	-0.0779	-5.1232	0.0000	0.0000	0.0000	0.0000;
	2625	2459	0.033471	0.065289	0.005929	69	69	69	0	0	1	-360	360	4.7983	4.2433	-4.7855	-4.8990	0.0000	0.0000	0.0000	0.0000;
	2619	2492	0.016529	0.031397	0.003151	48	48	48	0	0	1	-360	360	-2.2241	4.3232	2.2277	-4.6752	0.0000	0.0000	0.0000	0.0000;
	2602	2625	0.022884	0.074	0.007592	69	69	69	0	0	1	-360	360	5.9095	3.6982	-5.8993	-4.5433	0.0000	0.0000	0.0000	0.0000;
	2715	2491	0.001653	0.005289	0.00053	137	137	137	0	0	1	-360	360	-27.9308	-5.3231	27.9425	5.3005	0.0000	0.0000	0.0000	0.0000;
	2493	2492	0.009091	0.028099	0.00288	133	133	133	0	0	1	-360	360	-10.5933	0.3045	10.6023	-0.6042	0.0000	0.0000	0.0000	0.0000;
	2556	2554	0.00405	0.013314	0.001379	95	95	95	0	0	1	-360	360	-8.3143	4.0647	8.3173	-4.2124	0.0000	0.0000	0.0000	0.0000;
	2574	2556	0.020744	0.066281	0.006989	126	126	126	0	0	1	-360	360	-1.9050	4.0772	1.9093	-4.8647	0.0000	0.0000	0.0000	0.0000;
	2674	2574	0.028347	0.092231	0.009511	137	137	137	0	0	1	-360	360	4.5086	3.3081	-4.5000	-4.3772	0.0000	0.0000	0.0000	0.0000;
	2554	2572	0.040331	0.130413	0.013361	137	137	137	0	0	1	-360	360	7.2402	1.6343	-7.2197	-3.0875	0.0000	0.0000	0.0000	0.0000;
	2614	2493	0.020413	0.066124	0.006781	95	95	95	0	0	1	-360	360	-1.3842	1.6367	1.3853	-2.4045	0.0000	0.0000	0.0000	0.0000;
	2730	824	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	60.0000	-5.0209	-59.2606	6.4111	0.0000	0.0000	0.0000	0.0000;
	2730	824	0.02562	0.084711	0.008477	123	123	123	0	0	1	-360	360	60.0000	-5.0209	-59.2606	6.4111	0.0000	0.0000	0.0000	0.0000;
	2735	1429	0.010413	0.033554	0.003543	114	114	114	0	0	1	-360	360	-25.0000	-10.0000	25.0680	9.8256	0.0000	0.0000	0.0000	0.0000;
	2736	1871	0.009752	0.030496	0.003151	140	140	140	0	0	1	-360	360	-65.0000	-26.0000	65.4397	27.0286	0.0000	0.0000	0.0000	0.0000;
	2732	1523	0.002562	0.008264	0.000874	114	114	114	0	0	1	-360	360	-37.1844	-13.5525	37.2196	13.5663	0.0000	0.0000	0.0000	0.0000;
	2734	2732	0.003058	0.01	0.001048	114	114	114	0	0	1	-360	360	-20.1712	-7.6380	20.1837	7.5596	0.0000	0.0000	0.0000	0.0000;
	2731	2732	0.000248	0.000909	8.5e-05	114	114	114	0	0	1	-360	360	-17.0000	-6.0000	17.0007	5.9929	0.0000	0.0000	0.0000	0.0000;
	2733	1524	0.005702	0.018264	0.001922	114	114	114	0	0	1	-360	360	-28.8288	-10.3622	28.8758	10.2935	0.0000	0.0000	0.0000	0.0000;
	5	4	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-12.6370	17.6909	12.6371	-17.6901	0.0000	0.0000	0.0000	0.0000;
	7	6	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	124.4830	46.8309	-124.4798	-46.7987	0.0000	0.0000	0.0000	0.0000;
	9	8	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	175.4671	1.5197	-175.4653	-1.5014	0.0000	0.0000	0.0000	0.0000;
	11	10	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-50.6367	-36.9735	50.6375	36.9808	0.0000	0.0000	0.0000	0.0000;
	12	11	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	58.6111	-30.7663	-58.6103	30.7744	0.0000	0.0000	0.0000	0.0000;
	16	15	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	18	17	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-2.7001	27.8554	2.7002	-27.8540	0.0000	0.0000	0.0000	0.0000;
	20	19	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	25.6733	18.6522	-25.6732	-18.6504	0.0000	0.0000	0.0000	0.0000;
	22	21	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	29	28	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	170.0763	1.1346	-170.0747	-1.1181	0.0000	0.0000	0.0000	0.0000;
	37	36	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-19.8517	-4.0016	19.8518	4.0024	0.0000	0.0000	0.0000	0.0000;
	40	39	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-1.9052	-60.4890	1.9058	60.4951	0.0000	0.0000	0.0000	0.0000;
	43	42	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	178.8672	-66.4705	-178.8609	66.5337	0.0000	0.0000	0.0000	0.0000;
	45	44	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-84.6784	-67.3813	84.6790	67.3882	0.0000	0.0000	0.0000	0.0000;
	48	47	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-175.8217	-32.6841	175.8236	32.7026	0.0000	0.0000	0.0000	0.0000;
	51	50	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	26.1405	-11.7253	-26.1403	11.7268	0.0000	0.0000	0.0000	0.0000;
	53	52	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	64.3546	27.5499	-64.3543	-27.5470	0.0000	0.0000	0.0000	0.0000;
	55	54	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-32.7639	-16.7469	32.7641	16.7492	0.0000	0.0000	0.0000	0.0000;
	57	56	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-111.0589	-34.6770	111.0596	34.6847	0.0000	0.0000	0.0000	0.0000;
	59	58	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	16.0332	4.1409	-16.0331	-4.1404	0.0000	0.0000	0.0000	0.0000;
	62	61	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-29.7592	-16.3059	29.7594	16.3079	0.0000	0.0000	0.0000	0.0000;
	64	63	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-356.7863	-47.7836	356.7936	47.8573	0.0000	0.0000	0.0000	0.0000;
	72	71	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	122.6448	4.2784	-122.6422	-4.2527	0.0000	0.0000	0.0000	0.0000;
	74	73	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-49.0936	-5.8763	49.0940	5.8806	0.0000	0.0000	0.0000	0.0000;
	76	75	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-76.7276	-51.7284	76.7290	51.7430	0.0000	0.0000	0.0000	0.0000;
	78	77	2.1e-05	0.000207	0	876	876	876	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	80	79	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	11.8896	8.2199	-11.8896	-8.2195	0.0000	0.0000	0.0000	0.0000;
	84	83	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	51.1445	-4.9755	-51.1440	4.9800	0.0000	0.0000	0.0000	0.0000;
	86	85	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-54.2536	-7.4651	54.2541	7.4702	0.0000	0.0000	0.0000	0.0000;
	88	87	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	55.4377	-12.1773	-55.4371	12.1829	0.0000	0.0000	0.0000	0.0000;
	90	89	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-45.0283	3.0635	45.0286	-3.0601	0.0000	0.0000	0.0000	0.0000;
	92	91	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-52.8784	-3.3967	52.8785	3.3983	0.0000	0.0000	0.0000	0.0000;
	94	93	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-44.7320	16.8412	44.7324	-16.8372	0.0000	0.0000	0.0000	0.0000;
	96	95	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-25.9754	-4.6875	25.9755	4.6887	0.0000	0.0000	0.0000	0.0000;
	98	97	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-66.9568	4.8221	66.9575	-4.8144	0.0000	0.0000	0.0000	0.0000;
	100	99	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-1.5627	3.8345	1.5627	-3.8344	0.0000	0.0000	0.0000	0.0000;
	102	101	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	1.2868	-16.6892	-1.2867	16.6897	0.0000	0.0000	0.0000	0.0000;
	104	103	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-276.1123	-0.2449	276.1253	0.3752	0.0000	0.0000	0.0000	0.0000;
	106	105	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-28.8028	-24.4046	28.8030	24.4071	0.0000	0.0000	0.0000	0.0000;
	108	107	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-95.2733	16.9675	95.2749	-16.9515	0.0000	0.0000	0.0000	0.0000;
	111	110	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	6.9442	14.9271	-6.9442	-14.9267	0.0000	0.0000	0.0000	0.0000;
	113	112	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	94.0780	20.3926	-94.0764	-20.3766	0.0000	0.0000	0.0000	0.0000;
	116	115	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	24.5245	4.5603	-24.5244	-4.5592	0.0000	0.0000	0.0000	0.0000;
	118	117	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-88.5308	20.4105	88.5322	-20.3964	0.0000	0.0000	0.0000	0.0000;
	120	119	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	150.6013	42.3088	-150.5999	-42.2949	0.0000	0.0000	0.0000	0.0000;
	122	121	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	160.1225	18.6149	-160.1211	-18.6002	0.0000	0.0000	0.0000	0.0000;
	125	124	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	171.0506	-70.4488	-171.0448	70.5073	0.0000	0.0000	0.0000	0.0000;
	127	126	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	14.1863	-21.5795	-14.1863	21.5799	0.0000	0.0000	0.0000	0.0000;
	129	128	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	20.7523	-17.6178	-20.7522	17.6190	0.0000	0.0000	0.0000	0.0000;
	134	133	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-30.6584	-33.7514	30.6587	33.7549	0.0000	0.0000	0.0000	0.0000;
	138	137	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	2.5851	28.6288	-2.5851	-28.6283	0.0000	0.0000	0.0000	0.0000;
	141	140	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	144	143	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	146	145	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-11.5890	-8.2539	11.5891	8.2542	0.0000	0.0000	0.0000	0.0000;
	148	147	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	44.5133	-37.9892	-44.5127	37.9949	0.0000	0.0000	0.0000	0.0000;
	150	149	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	28.2894	-22.7300	-28.2893	22.7307	0.0000	0.0000	0.0000	0.0000;
	153	152	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-46.5409	-20.4614	46.5413	20.4659	0.0000	0.0000	0.0000	0.0000;
	155	154	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-80.7057	26.1623	80.7070	-26.1497	0.0000	0.0000	0.0000	0.0000;
	157	156	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	158.2579	-25.1552	-158.2563	25.1711	0.0000	0.0000	0.0000	0.0000;
	159	158	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	162	161	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-117.9316	-17.2400	117.9325	17.2486	0.0000	0.0000	0.0000	0.0000;
	164	163	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-89.0356	8.9099	89.0369	-8.8965	0.0000	0.0000	0.0000	0.0000;
	165	164	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	169	168	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-78.6032	-2.7146	78.6043	2.7253	0.0000	0.0000	0.0000	0.0000;
	171	170	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	173	172	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	58.5325	-13.2380	-58.5319	13.2445	0.0000	0.0000	0.0000	0.0000;
	176	175	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	88.1824	-6.4182	-88.1810	6.4320	0.0000	0.0000	0.0000	0.0000;
	178	177	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	184	183	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-51.8317	42.3916	51.8319	-42.3890	0.0000	0.0000	0.0000	0.0000;
	186	185	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-108.8763	37.4772	108.8770	-37.4695	0.0000	0.0000	0.0000	0.0000;
	188	187	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-10.0295	18.1799	10.0296	-18.1791	0.0000	0.0000	0.0000	0.0000;
	190	189	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	23.2963	-19.7019	-23.2961	19.7035	0.0000	0.0000	0.0000	0.0000;
	193	192	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	24.3978	-13.9773	-24.3976	13.9787	0.0000	0.0000	0.0000	0.0000;
	195	194	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-128.2099	-19.8669	128.2109	19.8768	0.0000	0.0000	0.0000	0.0000;
	197	196	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-0.3463	8.5051	0.3463	-8.5050	0.0000	0.0000	0.0000	0.0000;
	199	198	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	-120.5912	87.2936	120.5925	-87.2806	0.0000	0.0000	0.0000	0.0000;
	201	200	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	30.9498	-11.7435	-30.9496	11.7455	0.0000	0.0000	0.0000	0.0000;
	203	202	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	-121.0978	-13.8839	121.1004	13.9106	0.0000	0.0000	0.0000	0.0000;
	205	204	6e-06	6.3e-05	0	1593	1593	1593	0	0	1	-360	360	29.5998	4.4430	-29.5997	-4.4425	0.0000	0.0000	0.0000	0.0000;
	207	206	2.1e-05	0.000207	0	876	876	876	0	0	1	-360	360	41.1137	0.2319	-41.1134	-0.2289	0.0000	0.0000	0.0000	0.0000;
	213	212	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	221	220	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	228	227	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.9269	3.1155	-18.9266	-3.1129	0.0000	0.0000	0.0000	0.0000;
	243	242	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.4485	9.0180	-36.4475	-9.0086	0.0000	0.0000	0.0000	0.0000;
	249	248	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	258	257	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.3182	-3.7619	30.3189	3.7684	0.0000	0.0000	0.0000	0.0000;
	265	264	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	282	281	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	284	283	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.2350	-35.6750	-8.2340	35.6845	0.0000	0.0000	0.0000	0.0000;
	286	285	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	298	297	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	311	310	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	319	318	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.4860	-7.8707	-6.4859	7.8714	0.0000	0.0000	0.0000	0.0000;
	326	325	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	335	334	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	343	342	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	345	344	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.4282	18.3688	11.4285	-18.3655	0.0000	0.0000	0.0000	0.0000;
	355	354	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	356	355	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	72.4979	18.7176	-72.4940	-18.6785	0.0000	0.0000	0.0000	0.0000;
	362	361	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-116.8124	-46.0924	116.8231	46.2000	0.0000	0.0000	0.0000	0.0000;
	376	375	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	380	379	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-39.5525	8.8541	39.5537	-8.8423	0.0000	0.0000	0.0000	0.0000;
	386	385	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	394	393	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	405	404	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	407	406	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	422	421	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.7782	-4.1750	20.7785	4.1782	0.0000	0.0000	0.0000	0.0000;
	430	429	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.4925	0.8342	1.4925	-0.8342	0.0000	0.0000	0.0000	0.0000;
	437	436	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	439	438	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	442	441	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.5113	-7.0092	24.5117	7.0137	0.0000	0.0000	0.0000	0.0000;
	458	457	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	465	464	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	49.7252	0.0798	-49.7235	-0.0628	0.0000	0.0000	0.0000	0.0000;
	476	475	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	486	485	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	488	487	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	490	489	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	495	494	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	45.0963	7.9808	-45.0948	-7.9660	0.0000	0.0000	0.0000	0.0000;
	508	507	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	510	509	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.0597	-1.8558	25.0602	1.8601	0.0000	0.0000	0.0000	0.0000;
	516	515	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.9036	4.1133	-17.9033	-4.1109	0.0000	0.0000	0.0000	0.0000;
	518	517	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	521	520	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	525	524	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.7037	5.0977	-27.7032	-5.0921	0.0000	0.0000	0.0000	0.0000;
	531	530	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	533	532	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	537	536	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	539	538	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	542	541	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	38.8607	9.6094	-38.8596	-9.5981	0.0000	0.0000	0.0000	0.0000;
	548	547	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	552	551	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	557	556	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.6305	0.5028	1.6305	-0.5028	0.0000	0.0000	0.0000	0.0000;
	575	574	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	578	577	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	588	587	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.6907	12.0172	4.6908	-12.0161	0.0000	0.0000	0.0000	0.0000;
	594	593	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.5847	-8.0767	3.5848	8.0772	0.0000	0.0000	0.0000	0.0000;
	614	613	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	618	617	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.0230	-3.2532	21.0234	3.2564	0.0000	0.0000	0.0000	0.0000;
	665	664	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.7648	-58.0998	19.7673	58.1255	0.0000	0.0000	0.0000	0.0000;
	686	685	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-44.5517	-3.2533	44.5531	3.2669	0.0000	0.0000	0.0000	0.0000;
	697	696	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.7098	5.9825	34.7106	-5.9739	0.0000	0.0000	0.0000	0.0000;
	715	714	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.6163	2.1457	-14.6162	-2.1442	0.0000	0.0000	0.0000	0.0000;
	731	730	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	62.3615	16.4052	-62.3586	-16.3760	0.0000	0.0000	0.0000	0.0000;
	741	740	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.8007	8.2714	24.8012	-8.2666	0.0000	0.0000	0.0000	0.0000;
	759	758	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.2657	2.9806	-29.2651	-2.9745	0.0000	0.0000	0.0000	0.0000;
	769	768	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.9623	-2.7495	11.9624	2.7506	0.0000	0.0000	0.0000	0.0000;
	779	778	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.6397	-1.7690	20.6400	1.7720	0.0000	0.0000	0.0000	0.0000;
	808	807	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	847	846	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.7445	0.0416	-29.7439	-0.0353	0.0000	0.0000	0.0000	0.0000;
	850	849	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.2993	-3.2568	-35.2984	3.2657	0.0000	0.0000	0.0000	0.0000;
	852	851	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.7728	2.2364	-20.7725	-2.2333	0.0000	0.0000	0.0000	0.0000;
	853	852	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.7731	2.2395	-20.7728	-2.2364	0.0000	0.0000	0.0000	0.0000;
	855	854	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.1431	-1.0100	29.1437	1.0158	0.0000	0.0000	0.0000	0.0000;
	857	856	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.8753	-0.8650	-6.8753	0.8654	0.0000	0.0000	0.0000	0.0000;
	861	860	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.5884	0.7886	6.5884	-0.7883	0.0000	0.0000	0.0000	0.0000;
	864	863	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-39.5497	-5.6825	39.5509	5.6939	0.0000	0.0000	0.0000	0.0000;
	866	865	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	869	868	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.2614	-3.4460	12.2615	3.4472	0.0000	0.0000	0.0000	0.0000;
	871	870	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.3720	3.5466	-5.3720	-3.5463	0.0000	0.0000	0.0000	0.0000;
	873	872	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	876	875	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.9079	-6.2503	30.9086	6.2573	0.0000	0.0000	0.0000	0.0000;
	878	877	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	883	882	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.8573	0.9939	19.8576	-0.9911	0.0000	0.0000	0.0000	0.0000;
	885	884	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.5095	3.0283	-6.5094	-3.0280	0.0000	0.0000	0.0000	0.0000;
	891	890	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.4340	-5.5590	-36.4330	5.5683	0.0000	0.0000	0.0000	0.0000;
	895	894	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.1710	6.2953	26.1715	-6.2902	0.0000	0.0000	0.0000	0.0000;
	897	896	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	900	899	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	901	900	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	899	901	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	903	902	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.7377	-4.2776	8.7378	4.2782	0.0000	0.0000	0.0000	0.0000;
	905	904	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.2178	3.8365	7.2178	-3.8360	0.0000	0.0000	0.0000	0.0000;
	907	906	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	911	910	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	917	916	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.1251	-2.0158	34.1259	2.0241	0.0000	0.0000	0.0000	0.0000;
	919	918	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.6519	-0.6977	6.6519	0.6980	0.0000	0.0000	0.0000	0.0000;
	921	920	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	923	922	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	927	926	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.9888	3.2280	24.9893	-3.2236	0.0000	0.0000	0.0000	0.0000;
	929	928	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	931	930	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.7337	6.4127	-2.7337	-6.4123	0.0000	0.0000	0.0000	0.0000;
	933	932	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.2419	-0.7537	14.2421	0.7551	0.0000	0.0000	0.0000	0.0000;
	935	934	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.8256	6.9946	-10.8255	-6.9934	0.0000	0.0000	0.0000	0.0000;
	939	938	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.3755	-0.4045	4.3755	0.4047	0.0000	0.0000	0.0000	0.0000;
	941	940	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.6381	-3.8273	2.6382	3.8274	0.0000	0.0000	0.0000	0.0000;
	943	942	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	946	945	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	948	947	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.5185	2.9889	-13.5183	-2.9876	0.0000	0.0000	0.0000	0.0000;
	954	953	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.8984	4.4188	-20.8980	-4.4156	0.0000	0.0000	0.0000	0.0000;
	956	955	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	32.2874	5.6859	-32.2867	-5.6783	0.0000	0.0000	0.0000	0.0000;
	960	959	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.9320	-3.8003	15.9322	3.8022	0.0000	0.0000	0.0000	0.0000;
	962	961	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.6432	-2.0528	12.6433	2.0540	0.0000	0.0000	0.0000	0.0000;
	964	963	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.6279	-2.9499	-8.6278	2.9505	0.0000	0.0000	0.0000	0.0000;
	966	965	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.6297	3.4747	-20.6293	-3.4715	0.0000	0.0000	0.0000	0.0000;
	968	967	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.9392	1.1384	13.9393	-1.1370	0.0000	0.0000	0.0000	0.0000;
	970	969	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.7565	3.2223	-19.7563	-3.2195	0.0000	0.0000	0.0000	0.0000;
	972	971	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.1113	-2.0362	20.1116	2.0391	0.0000	0.0000	0.0000	0.0000;
	974	973	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.2469	0.4178	-5.2468	-0.4176	0.0000	0.0000	0.0000	0.0000;
	976	975	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	978	977	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.1060	-6.2173	37.1069	6.2269	0.0000	0.0000	0.0000	0.0000;
	980	979	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	43.0961	13.7415	-43.0947	-13.7277	0.0000	0.0000	0.0000	0.0000;
	982	981	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.3663	-0.3134	-18.3661	0.3158	0.0000	0.0000	0.0000	0.0000;
	986	985	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.1009	1.4594	-21.1006	-1.4564	0.0000	0.0000	0.0000	0.0000;
	988	987	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.5350	-1.2526	-6.5350	1.2529	0.0000	0.0000	0.0000	0.0000;
	990	989	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.2146	3.2558	-15.2144	-3.2540	0.0000	0.0000	0.0000	0.0000;
	994	993	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.4116	-3.1438	23.4120	3.1477	0.0000	0.0000	0.0000	0.0000;
	996	995	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	998	997	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1000	999	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.2074	3.0838	-3.2074	-3.0837	0.0000	0.0000	0.0000	0.0000;
	1001	1002	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1004	1003	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.2390	-3.6931	-16.2388	3.6950	0.0000	0.0000	0.0000	0.0000;
	1006	1005	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.3147	-1.4042	14.3149	1.4056	0.0000	0.0000	0.0000	0.0000;
	1008	1007	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.6495	0.0868	-0.6495	-0.0868	0.0000	0.0000	0.0000	0.0000;
	1010	1009	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.2569	-7.3385	35.2578	7.3478	0.0000	0.0000	0.0000	0.0000;
	1012	1011	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.3217	6.3220	-15.3215	-6.3200	0.0000	0.0000	0.0000	0.0000;
	1014	1013	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1015	1014	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1013	1015	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1019	1018	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.5459	7.2930	21.5463	-7.2893	0.0000	0.0000	0.0000	0.0000;
	1025	1024	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.7344	0.6244	-40.7332	-0.6125	0.0000	0.0000	0.0000	0.0000;
	1026	1025	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.0341	-5.9805	-9.0340	5.9814	0.0000	0.0000	0.0000	0.0000;
	1036	1035	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-61.0542	-10.6437	61.0568	10.6698	0.0000	0.0000	0.0000	0.0000;
	1042	1041	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0680	0.3436	0.0680	-0.3436	0.0000	0.0000	0.0000	0.0000;
	1044	1043	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.5252	-0.3418	2.5252	0.3418	0.0000	0.0000	0.0000	0.0000;
	1046	1045	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1048	1047	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.3827	10.6684	-27.3821	-10.6622	0.0000	0.0000	0.0000	0.0000;
	1050	1049	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.3261	6.1622	-36.3252	-6.1529	0.0000	0.0000	0.0000	0.0000;
	1052	1051	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.3180	-7.2355	-6.3179	7.2361	0.0000	0.0000	0.0000	0.0000;
	1058	1057	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.0325	1.2703	15.0327	-1.2687	0.0000	0.0000	0.0000	0.0000;
	1060	1059	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1062	1061	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.2621	-1.5316	8.2622	1.5321	0.0000	0.0000	0.0000	0.0000;
	1065	1064	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.6394	0.1367	-19.6391	-0.1338	0.0000	0.0000	0.0000	0.0000;
	1068	1067	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.7964	-4.8592	21.7967	4.8627	0.0000	0.0000	0.0000	0.0000;
	1070	1069	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.5396	2.0591	-10.5395	-2.0583	0.0000	0.0000	0.0000	0.0000;
	1072	1071	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.2128	4.8450	-24.2124	-4.8408	0.0000	0.0000	0.0000	0.0000;
	1074	1073	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.0955	0.0895	14.0956	-0.0881	0.0000	0.0000	0.0000	0.0000;
	1076	1075	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	64.3828	-4.7851	-64.3800	4.8138	0.0000	0.0000	0.0000	0.0000;
	1078	1077	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.2643	0.5036	-12.2642	-0.5025	0.0000	0.0000	0.0000	0.0000;
	1080	1079	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.3647	0.4038	4.3647	-0.4036	0.0000	0.0000	0.0000	0.0000;
	1082	1081	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1086	1085	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-50.2722	6.8679	50.2739	-6.8501	0.0000	0.0000	0.0000	0.0000;
	1088	1087	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.1249	5.8636	16.1251	-5.8614	0.0000	0.0000	0.0000	0.0000;
	1092	1091	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1096	1095	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.9042	-1.8426	7.9042	1.8431	0.0000	0.0000	0.0000	0.0000;
	1102	1101	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.4129	2.4928	8.4130	-2.4923	0.0000	0.0000	0.0000	0.0000;
	1104	1103	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1108	1107	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.4068	-0.6905	7.4068	0.6909	0.0000	0.0000	0.0000	0.0000;
	1110	1109	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.6781	-2.0522	11.6782	2.0531	0.0000	0.0000	0.0000	0.0000;
	1112	1111	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1114	1113	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1115	1114	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1113	1115	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1117	1116	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-52.3114	2.3737	52.3132	-2.3549	0.0000	0.0000	0.0000	0.0000;
	1119	1118	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	43.0893	18.5336	-43.0877	-18.5174	0.0000	0.0000	0.0000	0.0000;
	1123	1122	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1133	1132	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.0504	2.5842	3.0504	-2.5841	0.0000	0.0000	0.0000	0.0000;
	1135	1134	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.7492	-0.8725	19.7494	0.8753	0.0000	0.0000	0.0000	0.0000;
	1138	1137	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1139	1138	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1144	1143	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-6.6274	-1.2757	6.6274	1.2760	0.0000	0.0000	0.0000	0.0000;
	1145	1144	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.3772	1.7432	-16.3770	-1.7413	0.0000	0.0000	0.0000	0.0000;
	1149	1148	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.6400	-1.8556	16.6402	1.8575	0.0000	0.0000	0.0000	0.0000;
	1151	1150	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.1029	2.7831	-13.1028	-2.7819	0.0000	0.0000	0.0000	0.0000;
	1156	1155	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.7268	-0.2061	-6.7268	0.2064	0.0000	0.0000	0.0000	0.0000;
	1165	1164	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0060	2.2897	-0.0060	-2.2896	0.0000	0.0000	0.0000	0.0000;
	1167	1166	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1171	1170	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	92.5200	20.3180	-92.5139	-20.2574	0.0000	0.0000	0.0000	0.0000;
	1173	1172	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1178	1177	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1180	1179	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1182	1181	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.0815	-2.6598	1.0815	2.6598	0.0000	0.0000	0.0000	0.0000;
	1186	1185	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-57.6401	-11.6931	57.6425	11.7169	0.0000	0.0000	0.0000	0.0000;
	1188	1187	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1195	1194	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.6040	4.8372	-1.6040	-4.8371	0.0000	0.0000	0.0000	0.0000;
	1202	1201	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.1472	1.7863	-11.1471	-1.7854	0.0000	0.0000	0.0000	0.0000;
	1205	1204	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.8166	2.1610	20.8169	-2.1579	0.0000	0.0000	0.0000	0.0000;
	1207	1206	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-35.1413	3.2050	35.1422	-3.1962	0.0000	0.0000	0.0000	0.0000;
	1209	1208	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.7747	3.0580	-19.7744	-3.0552	0.0000	0.0000	0.0000	0.0000;
	1211	1210	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.6775	-3.1496	25.6780	3.1542	0.0000	0.0000	0.0000	0.0000;
	1213	1212	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.0118	0.0978	-1.0118	-0.0978	0.0000	0.0000	0.0000	0.0000;
	1215	1214	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.0340	-1.1627	-5.0339	1.1629	0.0000	0.0000	0.0000	0.0000;
	1219	1218	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1221	1220	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.3248	-1.0369	17.3250	1.0390	0.0000	0.0000	0.0000	0.0000;
	1223	1222	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1225	1224	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.4963	-4.5520	14.4964	4.5536	0.0000	0.0000	0.0000	0.0000;
	1231	1230	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.4052	5.8759	-11.4051	-5.8748	0.0000	0.0000	0.0000	0.0000;
	1233	1232	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1235	1234	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.4572	-0.6999	4.4572	0.7000	0.0000	0.0000	0.0000	0.0000;
	1237	1236	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.9272	4.0126	1.9272	-4.0125	0.0000	0.0000	0.0000	0.0000;
	1241	1240	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.3617	-1.6697	33.3625	1.6775	0.0000	0.0000	0.0000	0.0000;
	1243	1242	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.4031	-0.8273	-2.4031	0.8273	0.0000	0.0000	0.0000	0.0000;
	1245	1244	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.7741	1.2824	37.7752	-1.2718	0.0000	0.0000	0.0000	0.0000;
	1247	1246	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1249	1248	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.9155	2.4515	14.9157	-2.4499	0.0000	0.0000	0.0000	0.0000;
	1255	1254	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1257	1256	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.9830	0.4461	-2.9830	-0.4460	0.0000	0.0000	0.0000	0.0000;
	1259	1258	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.5465	0.2360	-6.5464	-0.2357	0.0000	0.0000	0.0000	0.0000;
	1263	1262	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.2926	9.9050	-16.2923	-9.9026	0.0000	0.0000	0.0000	0.0000;
	1265	1264	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.4244	2.7796	-10.4244	-2.7788	0.0000	0.0000	0.0000	0.0000;
	1267	1266	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.3349	14.6378	25.3355	-14.6318	0.0000	0.0000	0.0000	0.0000;
	1269	1268	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1270	1269	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1277	1276	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	70.3907	17.5664	-70.3871	-17.5299	0.0000	0.0000	0.0000	0.0000;
	1279	1278	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	10.2528	-0.5862	-10.2527	0.5869	0.0000	0.0000	0.0000	0.0000;
	1283	1282	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.5681	2.7518	15.5683	-2.7500	0.0000	0.0000	0.0000	0.0000;
	1286	1285	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1288	1287	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1290	1289	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.6405	-1.6720	14.6407	1.6735	0.0000	0.0000	0.0000	0.0000;
	1292	1291	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.6999	-9.0456	-8.6998	9.0467	0.0000	0.0000	0.0000	0.0000;
	1294	1293	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-29.3067	4.0733	29.3073	-4.0672	0.0000	0.0000	0.0000	0.0000;
	1296	1295	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.4189	1.7868	-11.4189	-1.7858	0.0000	0.0000	0.0000	0.0000;
	1298	1297	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.3451	0.5743	-6.3450	-0.5740	0.0000	0.0000	0.0000	0.0000;
	1300	1299	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.4443	-2.8724	-8.4442	2.8729	0.0000	0.0000	0.0000	0.0000;
	1302	1301	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.5731	-0.0286	0.5731	0.0286	0.0000	0.0000	0.0000	0.0000;
	1304	1303	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.4011	-0.2108	22.4015	0.2144	0.0000	0.0000	0.0000	0.0000;
	1306	1305	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.9021	0.7375	-5.9021	-0.7373	0.0000	0.0000	0.0000	0.0000;
	1308	1307	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-44.9937	2.7178	44.9951	-2.7037	0.0000	0.0000	0.0000	0.0000;
	1312	1311	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.6290	-0.3642	5.6290	0.3644	0.0000	0.0000	0.0000	0.0000;
	1314	1313	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-58.6992	-4.0785	58.7016	4.1025	0.0000	0.0000	0.0000	0.0000;
	1316	1315	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.7776	-1.5353	9.7777	1.5360	0.0000	0.0000	0.0000	0.0000;
	1320	1319	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1324	1323	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.8245	-1.2060	18.8248	1.2084	0.0000	0.0000	0.0000	0.0000;
	1330	1329	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	40.5982	-3.2647	-40.5971	3.2766	0.0000	0.0000	0.0000	0.0000;
	1332	1331	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	25.1209	0.2431	-25.1204	-0.2384	0.0000	0.0000	0.0000	0.0000;
	1334	1333	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.4861	-3.2642	-19.4858	3.2670	0.0000	0.0000	0.0000	0.0000;
	1336	1335	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.6478	1.8027	20.6481	-1.7996	0.0000	0.0000	0.0000	0.0000;
	1338	1337	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.0889	0.0926	1.0889	-0.0926	0.0000	0.0000	0.0000	0.0000;
	1343	1342	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.8124	-2.7444	-5.8124	2.7446	0.0000	0.0000	0.0000	0.0000;
	1345	1344	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1348	1347	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1350	1349	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.4894	-4.3990	28.4900	4.4051	0.0000	0.0000	0.0000	0.0000;
	1352	1351	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1353	1352	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1351	1353	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1355	1354	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.9965	-2.5381	-1.9965	2.5382	0.0000	0.0000	0.0000	0.0000;
	1357	1356	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1361	1360	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.2838	1.9549	17.2841	-1.9526	0.0000	0.0000	0.0000	0.0000;
	1363	1362	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1365	1364	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.3537	-2.0825	-9.3537	2.0832	0.0000	0.0000	0.0000	0.0000;
	1367	1366	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.5437	12.9228	4.5439	-12.9215	0.0000	0.0000	0.0000	0.0000;
	1369	1368	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.5949	-0.1976	3.5949	0.1977	0.0000	0.0000	0.0000	0.0000;
	1375	1374	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.1612	-10.8769	31.1619	10.8846	0.0000	0.0000	0.0000	0.0000;
	1376	1375	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1374	1376	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1378	1377	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.4222	-8.2460	30.4229	8.2527	0.0000	0.0000	0.0000	0.0000;
	1380	1379	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.1091	-6.0823	7.1091	6.0829	0.0000	0.0000	0.0000	0.0000;
	1382	1381	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.9741	3.8319	-4.9740	-3.8316	0.0000	0.0000	0.0000	0.0000;
	1384	1383	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.5334	1.6991	-11.5333	-1.6982	0.0000	0.0000	0.0000	0.0000;
	1386	1385	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1388	1387	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.7750	-1.7895	-35.7741	1.7984	0.0000	0.0000	0.0000	0.0000;
	1390	1389	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.4771	-11.0602	-8.4769	11.0616	0.0000	0.0000	0.0000	0.0000;
	1392	1391	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.2156	-1.0755	15.2158	1.0772	0.0000	0.0000	0.0000	0.0000;
	1394	1393	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1398	1397	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.0596	-0.9642	-13.0594	0.9654	0.0000	0.0000	0.0000	0.0000;
	1403	1402	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-21.6661	-7.8566	21.6665	7.8603	0.0000	0.0000	0.0000	0.0000;
	1409	1408	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-49.3157	-1.7592	49.3174	1.7761	0.0000	0.0000	0.0000	0.0000;
	1411	1410	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	45.4502	16.2398	-45.4485	-16.2232	0.0000	0.0000	0.0000	0.0000;
	1413	1412	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1415	1414	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1417	1416	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.0642	-0.9988	-3.0642	0.9989	0.0000	0.0000	0.0000	0.0000;
	1419	1418	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.6420	-2.7856	0.6420	2.7856	0.0000	0.0000	0.0000	0.0000;
	1421	1420	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.7974	-3.1384	2.7974	3.1385	0.0000	0.0000	0.0000	0.0000;
	1423	1422	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-4.2223	3.5629	4.2223	-3.5627	0.0000	0.0000	0.0000	0.0000;
	1427	1426	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.6973	3.1611	18.6975	-3.1585	0.0000	0.0000	0.0000	0.0000;
	1429	1428	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.4274	-1.1245	-3.4273	1.1246	0.0000	0.0000	0.0000	0.0000;
	1433	1432	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1438	1437	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-36.7224	1.1317	36.7234	-1.1221	0.0000	0.0000	0.0000	0.0000;
	1440	1439	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.8825	-2.2003	13.8826	2.2017	0.0000	0.0000	0.0000	0.0000;
	1444	1443	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1448	1447	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.4900	-0.9294	2.4900	0.9294	0.0000	0.0000	0.0000	0.0000;
	1450	1449	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.8685	1.1985	3.8686	-1.1984	0.0000	0.0000	0.0000	0.0000;
	1452	1451	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.6615	-3.3318	10.6616	3.3327	0.0000	0.0000	0.0000	0.0000;
	1454	1453	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-24.4059	7.7803	24.4064	-7.7757	0.0000	0.0000	0.0000	0.0000;
	1456	1455	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.6129	1.6230	9.6130	-1.6223	0.0000	0.0000	0.0000	0.0000;
	1458	1457	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.0885	-7.5495	20.0888	7.5527	0.0000	0.0000	0.0000	0.0000;
	1460	1459	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.2789	-0.3126	-5.2789	0.3128	0.0000	0.0000	0.0000	0.0000;
	1462	1461	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.5569	1.3278	23.5573	-1.3239	0.0000	0.0000	0.0000	0.0000;
	1464	1463	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.7648	2.9066	-16.7646	-2.9045	0.0000	0.0000	0.0000	0.0000;
	1468	1467	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1472	1471	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.2587	-0.6215	17.2589	0.6235	0.0000	0.0000	0.0000	0.0000;
	1474	1473	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.2593	7.2636	10.2594	-7.2625	0.0000	0.0000	0.0000	0.0000;
	1476	1475	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.0072	8.7631	-36.0062	-8.7535	0.0000	0.0000	0.0000	0.0000;
	1478	1477	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.8794	-7.6842	27.8799	7.6899	0.0000	0.0000	0.0000	0.0000;
	1480	1479	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1482	1481	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.7776	-6.1994	27.7782	6.2051	0.0000	0.0000	0.0000	0.0000;
	1484	1483	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.8604	-3.2248	-9.8603	3.2256	0.0000	0.0000	0.0000	0.0000;
	1486	1485	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1488	1487	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.7648	0.8596	2.7648	-0.8596	0.0000	0.0000	0.0000	0.0000;
	1490	1489	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1493	1492	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.4786	-0.1158	-4.4786	0.1159	0.0000	0.0000	0.0000	0.0000;
	1495	1494	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.3633	-1.1072	-5.3633	1.1074	0.0000	0.0000	0.0000	0.0000;
	1497	1496	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.4178	5.6808	-24.4173	-5.6763	0.0000	0.0000	0.0000	0.0000;
	1499	1498	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.3939	2.2028	-1.3939	-2.2028	0.0000	0.0000	0.0000	0.0000;
	1501	1500	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1503	1502	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.3974	4.7828	-30.3967	-4.7760	0.0000	0.0000	0.0000	0.0000;
	1505	1504	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1510	1509	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1238	10.0672	2.1239	-10.0665	0.0000	0.0000	0.0000	0.0000;
	1512	1511	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1518	1517	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.3726	-2.4270	-27.3720	2.4322	0.0000	0.0000	0.0000	0.0000;
	1520	1519	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1522	1521	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.3047	4.6422	-24.3043	-4.6379	0.0000	0.0000	0.0000	0.0000;
	1524	1523	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.9778	6.0600	-16.9776	-6.0577	0.0000	0.0000	0.0000	0.0000;
	1526	1525	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.9987	3.0321	-15.9985	-3.0303	0.0000	0.0000	0.0000	0.0000;
	1528	1527	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.4489	-0.1781	1.4489	0.1781	0.0000	0.0000	0.0000	0.0000;
	1536	1535	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.0105	-1.6313	22.0109	1.6348	0.0000	0.0000	0.0000	0.0000;
	1538	1537	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1542	1541	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.0446	-1.2858	5.0446	1.2859	0.0000	0.0000	0.0000	0.0000;
	1544	1543	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1546	1545	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.5633	-5.4384	18.5636	5.4410	0.0000	0.0000	0.0000	0.0000;
	1548	1547	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	21.4424	4.0743	-21.4421	-4.0710	0.0000	0.0000	0.0000	0.0000;
	1554	1553	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.7409	-2.1425	-6.7409	2.1429	0.0000	0.0000	0.0000	0.0000;
	1556	1555	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.8002	5.8918	34.8010	-5.8831	0.0000	0.0000	0.0000	0.0000;
	1558	1557	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.6743	-2.2250	26.6748	2.2300	0.0000	0.0000	0.0000	0.0000;
	1562	1561	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.4578	9.9509	-1.4577	-9.9501	0.0000	0.0000	0.0000	0.0000;
	1564	1563	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1568	1567	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.7408	-9.1922	-12.7406	9.1939	0.0000	0.0000	0.0000	0.0000;
	1570	1569	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-34.0042	-4.2956	34.0050	4.3038	0.0000	0.0000	0.0000	0.0000;
	1572	1571	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1574	1573	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.1499	3.5235	-6.1498	-3.5232	0.0000	0.0000	0.0000	0.0000;
	1576	1575	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.2565	-3.4609	-18.2562	3.4633	0.0000	0.0000	0.0000	0.0000;
	1578	1577	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.3267	4.2223	5.3268	-4.2220	0.0000	0.0000	0.0000	0.0000;
	1580	1579	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-51.5992	-4.3313	51.6011	4.3501	0.0000	0.0000	0.0000	0.0000;
	1582	1581	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-18.8978	4.8895	18.8980	-4.8868	0.0000	0.0000	0.0000	0.0000;
	1584	1583	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.0188	-2.8898	14.0189	2.8912	0.0000	0.0000	0.0000	0.0000;
	1586	1585	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.0326	4.4620	-20.0323	-4.4590	0.0000	0.0000	0.0000	0.0000;
	1588	1587	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-65.8625	-6.3030	65.8655	6.3330	0.0000	0.0000	0.0000	0.0000;
	1590	1589	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.7298	-3.2975	12.7299	3.2987	0.0000	0.0000	0.0000	0.0000;
	1592	1591	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	42.6272	-0.0883	-42.6259	0.1015	0.0000	0.0000	0.0000	0.0000;
	1594	1593	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.7470	3.0183	-36.7461	-3.0085	0.0000	0.0000	0.0000	0.0000;
	1598	1597	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.5980	2.2061	-2.5980	-2.2060	0.0000	0.0000	0.0000	0.0000;
	1602	1601	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.4314	-9.6304	-5.4313	9.6313	0.0000	0.0000	0.0000	0.0000;
	1604	1603	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.9660	0.5708	10.9661	-0.5699	0.0000	0.0000	0.0000	0.0000;
	1606	1605	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-39.3236	0.2624	39.3246	-0.2516	0.0000	0.0000	0.0000	0.0000;
	1608	1607	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.8379	-0.7489	-2.8379	0.7490	0.0000	0.0000	0.0000	0.0000;
	1612	1611	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.6451	4.1643	-23.6447	-4.1602	0.0000	0.0000	0.0000	0.0000;
	1614	1613	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.0080	-5.1922	13.0082	5.1936	0.0000	0.0000	0.0000	0.0000;
	1618	1617	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.8369	5.7635	23.8374	-5.7592	0.0000	0.0000	0.0000	0.0000;
	1620	1619	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	55.1436	10.8997	-55.1414	-10.8780	0.0000	0.0000	0.0000	0.0000;
	1624	1623	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-16.8089	-1.2633	16.8091	1.2653	0.0000	0.0000	0.0000	0.0000;
	1626	1625	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.1768	12.8447	-28.1762	-12.8380	0.0000	0.0000	0.0000	0.0000;
	1628	1627	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	35.4011	1.9324	-35.4003	-1.9236	0.0000	0.0000	0.0000	0.0000;
	1630	1629	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.6190	-18.7003	22.6196	18.7064	0.0000	0.0000	0.0000	0.0000;
	1631	1630	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1629	1631	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1633	1632	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-44.1424	1.2642	44.1437	-1.2505	0.0000	0.0000	0.0000	0.0000;
	1635	1634	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.9074	-2.6180	-13.9072	2.6194	0.0000	0.0000	0.0000	0.0000;
	1637	1636	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.1484	-1.2094	-4.1484	1.2095	0.0000	0.0000	0.0000	0.0000;
	1641	1640	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1645	1644	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.8725	0.2424	8.8726	-0.2418	0.0000	0.0000	0.0000	0.0000;
	1647	1646	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1650	1649	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	13.2131	3.5682	-13.2130	-3.5669	0.0000	0.0000	0.0000	0.0000;
	1654	1653	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.3003	3.3813	-8.3003	-3.3807	0.0000	0.0000	0.0000	0.0000;
	1660	1659	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.4338	-5.3958	-6.4337	5.3963	0.0000	0.0000	0.0000	0.0000;
	1663	1662	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.6179	-3.1211	13.6181	3.1225	0.0000	0.0000	0.0000	0.0000;
	1665	1664	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.0087	8.0016	-4.0086	-8.0010	0.0000	0.0000	0.0000	0.0000;
	1669	1668	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	3.7791	1.3194	-3.7791	-1.3193	0.0000	0.0000	0.0000	0.0000;
	1671	1670	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	46.0600	3.2353	-46.0586	-3.2206	0.0000	0.0000	0.0000	0.0000;
	1673	1672	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1674	1673	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1672	1674	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1676	1675	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.4487	1.1803	-19.4485	-1.1776	0.0000	0.0000	0.0000	0.0000;
	1678	1677	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-36.0591	1.9886	36.0600	-1.9796	0.0000	0.0000	0.0000	0.0000;
	1680	1679	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-9.7711	6.5898	9.7712	-6.5889	0.0000	0.0000	0.0000	0.0000;
	1683	1682	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.7645	-7.5370	30.7652	7.5438	0.0000	0.0000	0.0000	0.0000;
	1685	1684	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1687	1686	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.4150	-0.1870	0.4150	0.1870	0.0000	0.0000	0.0000	0.0000;
	1689	1688	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.4194	-4.5699	-30.4188	4.5765	0.0000	0.0000	0.0000	0.0000;
	1691	1690	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1695	1694	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-45.1845	-12.0364	45.1860	12.0522	0.0000	0.0000	0.0000	0.0000;
	1697	1696	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.8110	-4.5671	22.8114	4.5708	0.0000	0.0000	0.0000	0.0000;
	1699	1698	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1703	1702	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1706	1705	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.6603	-5.4096	-8.6603	5.4103	0.0000	0.0000	0.0000	0.0000;
	1708	1707	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.1544	6.1156	-26.1539	-6.1106	0.0000	0.0000	0.0000	0.0000;
	1710	1709	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1714	1713	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.9163	5.1164	-15.9161	-5.1145	0.0000	0.0000	0.0000	0.0000;
	1716	1715	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	12.5960	-5.9288	-12.5958	5.9301	0.0000	0.0000	0.0000	0.0000;
	1718	1717	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1720	1719	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.4091	3.5196	12.4092	-3.5184	0.0000	0.0000	0.0000	0.0000;
	1726	1725	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-23.2710	-5.5440	23.2714	5.5481	0.0000	0.0000	0.0000	0.0000;
	1728	1727	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.9713	-6.5743	30.9720	6.5813	0.0000	0.0000	0.0000	0.0000;
	1730	1729	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.2993	-5.8486	-14.2991	5.8502	0.0000	0.0000	0.0000	0.0000;
	1732	1731	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1735	1734	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.2991	-1.4847	12.2992	1.4857	0.0000	0.0000	0.0000	0.0000;
	1737	1736	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.9777	2.2587	0.9777	-2.2586	0.0000	0.0000	0.0000	0.0000;
	1739	1738	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.7966	2.0383	-7.7966	-2.0378	0.0000	0.0000	0.0000	0.0000;
	1745	1744	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.4751	2.8166	7.4752	-2.8162	0.0000	0.0000	0.0000	0.0000;
	1747	1746	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-17.3381	-1.9468	17.3383	1.9490	0.0000	0.0000	0.0000	0.0000;
	1749	1748	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.3509	1.9058	-8.3508	-1.9053	0.0000	0.0000	0.0000	0.0000;
	1751	1750	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	19.6739	-1.3390	-19.6736	1.3419	0.0000	0.0000	0.0000	0.0000;
	1753	1752	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.8055	1.6774	-15.8053	-1.6756	0.0000	0.0000	0.0000	0.0000;
	1755	1754	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-74.1608	-0.5934	74.1646	0.6313	0.0000	0.0000	0.0000	0.0000;
	1757	1756	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-30.3175	-13.2245	30.3183	13.2321	0.0000	0.0000	0.0000	0.0000;
	1761	1760	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.2817	2.9813	-14.2816	-2.9798	0.0000	0.0000	0.0000	0.0000;
	1763	1762	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-37.7023	-7.9537	37.7034	7.9642	0.0000	0.0000	0.0000	0.0000;
	1765	1764	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1767	1766	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.3011	-4.2201	-4.3010	4.2203	0.0000	0.0000	0.0000	0.0000;
	1769	1768	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	29.1251	-3.7559	-29.1245	3.7620	0.0000	0.0000	0.0000	0.0000;
	1771	1770	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.4692	-1.5890	-6.4692	1.5893	0.0000	0.0000	0.0000	0.0000;
	1773	1772	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-13.0137	1.0390	13.0138	-1.0378	0.0000	0.0000	0.0000	0.0000;
	1775	1774	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	24.6150	8.9194	-24.6145	-8.9146	0.0000	0.0000	0.0000	0.0000;
	1777	1776	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.4803	8.3353	-7.4802	-8.3345	0.0000	0.0000	0.0000	0.0000;
	1781	1780	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.4909	-2.5378	0.4909	2.5379	0.0000	0.0000	0.0000	0.0000;
	1787	1786	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.2638	7.3788	10.2639	-7.3777	0.0000	0.0000	0.0000	0.0000;
	1789	1788	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.2542	0.7216	-9.2541	-0.7210	0.0000	0.0000	0.0000	0.0000;
	1791	1790	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-31.1593	-35.3828	31.1609	35.3987	0.0000	0.0000	0.0000	0.0000;
	1792	1793	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1795	1794	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-38.5325	-14.1628	38.5336	14.1742	0.0000	0.0000	0.0000	0.0000;
	1797	1796	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-28.1473	-2.1607	28.1478	2.1661	0.0000	0.0000	0.0000	0.0000;
	1802	1801	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.2700	0.2719	25.2704	-0.2674	0.0000	0.0000	0.0000	0.0000;
	1804	1803	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1806	1805	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.1683	3.4309	-18.1681	-3.4285	0.0000	0.0000	0.0000	0.0000;
	1808	1807	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.0000	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1810	1809	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-62.7033	-14.7489	62.7062	14.7771	0.0000	0.0000	0.0000	0.0000;
	1812	1811	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-42.4110	-15.0660	42.4125	15.0808	0.0000	0.0000	0.0000	0.0000;
	1818	1817	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1820	1819	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-36.3301	-1.7766	36.3310	1.7860	0.0000	0.0000	0.0000	0.0000;
	1822	1821	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.8796	3.0498	3.8796	-3.0496	0.0000	0.0000	0.0000	0.0000;
	1824	1823	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.2265	-0.6283	-9.2264	0.6289	0.0000	0.0000	0.0000	0.0000;
	1826	1825	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	16.2778	-9.1749	-16.2775	9.1773	0.0000	0.0000	0.0000	0.0000;
	1828	1827	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1831	1830	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.8392	-1.2868	-2.8392	1.2868	0.0000	0.0000	0.0000	0.0000;
	1833	1832	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.4408	14.2814	-1.4407	-14.2800	0.0000	0.0000	0.0000	0.0000;
	1835	1834	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-14.0849	0.0662	14.0851	-0.0648	0.0000	0.0000	0.0000	0.0000;
	1837	1836	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1838	1837	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1836	1838	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1840	1839	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	14.1480	4.2101	-14.1479	-4.2086	0.0000	0.0000	0.0000	0.0000;
	1844	1843	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.3802	0.1184	25.3806	-0.1137	0.0000	0.0000	0.0000	0.0000;
	1846	1845	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.9521	-4.1802	20.9524	4.1833	0.0000	0.0000	0.0000	0.0000;
	1848	1847	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	11.4110	5.7239	-11.4109	-5.7228	0.0000	0.0000	0.0000	0.0000;
	1850	1849	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.0452	-1.9402	15.0454	1.9418	0.0000	0.0000	0.0000	0.0000;
	1852	1851	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-43.2343	2.7777	43.2356	-2.7647	0.0000	0.0000	0.0000	0.0000;
	1854	1853	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.3675	-1.7484	-36.3666	1.7577	0.0000	0.0000	0.0000	0.0000;
	1859	1858	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1861	1860	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.0780	-0.7516	1.0780	0.7516	0.0000	0.0000	0.0000	0.0000;
	1863	1862	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	20.2462	3.3847	-20.2459	-3.3816	0.0000	0.0000	0.0000	0.0000;
	1865	1864	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-11.7731	-8.3068	11.7733	8.3083	0.0000	0.0000	0.0000	0.0000;
	1867	1866	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1873	1872	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1879	1878	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	9.4265	-0.3737	-9.4264	0.3743	0.0000	0.0000	0.0000	0.0000;
	1881	1880	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-63.8904	0.0383	63.8932	-0.0104	0.0000	0.0000	0.0000	0.0000;
	1883	1882	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	17.5101	-0.4814	-17.5099	0.4835	0.0000	0.0000	0.0000	0.0000;
	1885	1884	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	18.2268	2.1463	-18.2266	-2.1440	0.0000	0.0000	0.0000	0.0000;
	1887	1886	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	5.0393	1.1290	-5.0392	-1.1288	0.0000	0.0000	0.0000	0.0000;
	1889	1888	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1891	1890	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-25.5228	-12.7481	25.5234	12.7537	0.0000	0.0000	0.0000	0.0000;
	1893	1892	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-40.3118	3.6893	40.3130	-3.6779	0.0000	0.0000	0.0000	0.0000;
	1895	1894	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.0916	5.0861	3.0917	-5.0858	0.0000	0.0000	0.0000	0.0000;
	1897	1896	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.2983	2.0828	-0.2983	-2.0828	0.0000	0.0000	0.0000	0.0000;
	1901	1900	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.0844	-4.4268	19.0847	4.4295	0.0000	0.0000	0.0000	0.0000;
	1903	1902	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	30.5830	1.2816	-30.5823	-1.2750	0.0000	0.0000	0.0000	0.0000;
	1905	1904	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.5881	-0.8150	-6.5881	0.8153	0.0000	0.0000	0.0000	0.0000;
	1907	1906	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-0.6611	-3.1064	0.6612	3.1065	0.0000	0.0000	0.0000	0.0000;
	1911	1910	0	0.0001	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1914	1913	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	7.7332	-2.1460	-7.7332	2.1465	0.0000	0.0000	0.0000	0.0000;
	1916	1915	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4718	-1.9993	3.4718	1.9994	0.0000	0.0000	0.0000	0.0000;
	1918	1917	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	27.6867	-4.0854	-27.6861	4.0908	0.0000	0.0000	0.0000	0.0000;
	1922	1921	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.6833	5.6707	-36.6824	-5.6615	0.0000	0.0000	0.0000	0.0000;
	1924	1923	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1927	1926	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1929	1928	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.6818	2.0695	20.6821	-2.0666	0.0000	0.0000	0.0000	0.0000;
	1937	1936	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1942	1941	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-20.9778	-1.3415	20.9781	1.3446	0.0000	0.0000	0.0000	0.0000;
	1945	1944	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.9678	5.9384	19.9681	-5.9355	0.0000	0.0000	0.0000	0.0000;
	1948	1947	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.6840	-0.5270	3.6840	0.5271	0.0000	0.0000	0.0000	0.0000;
	1951	1950	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1958	1957	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1963	1962	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1965	1964	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1975	1974	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1977	1976	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	1983	1982	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.5252	17.1457	-1.5250	-17.1436	0.0000	0.0000	0.0000	0.0000;
	1992	1991	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	1994	1993	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.1410	-0.0700	2.1410	0.0700	0.0000	0.0000	0.0000	0.0000;
	1998	1997	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2000	1999	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2002	2001	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2006	2005	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2009	2008	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-47.6814	0.2474	47.6829	-0.2319	0.0000	0.0000	0.0000	0.0000;
	2012	2011	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.1868	8.6696	33.1876	-8.6613	0.0000	0.0000	0.0000	0.0000;
	2015	2014	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2018	2017	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.6929	-1.3486	8.6930	1.3491	0.0000	0.0000	0.0000	0.0000;
	2024	2023	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2033	2032	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-33.5599	2.7298	33.5606	-2.7220	0.0000	0.0000	0.0000	0.0000;
	2038	2037	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2042	2041	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2044	2043	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2047	2046	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.2110	-0.3010	2.2110	0.3010	0.0000	0.0000	0.0000	0.0000;
	2060	2059	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2064	2063	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2069	2068	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2071	2070	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.5612	-0.3144	8.5613	0.3149	0.0000	0.0000	0.0000	0.0000;
	2074	2073	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2077	2076	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2091	2090	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2102	2101	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	44.2291	-8.6215	-44.2276	8.6362	0.0000	0.0000	0.0000	0.0000;
	2106	2105	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	36.5664	-8.2083	-36.5654	8.2178	0.0000	0.0000	0.0000	0.0000;
	2108	2107	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2111	2110	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	59.1318	5.7228	-59.1292	-5.6975	0.0000	0.0000	0.0000	0.0000;
	2113	2112	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.7122	6.5569	27.7128	-6.5511	0.0000	0.0000	0.0000	0.0000;
	2120	2119	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-12.7557	3.7670	12.7558	-3.7657	0.0000	0.0000	0.0000	0.0000;
	2122	2121	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2128	2127	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.6870	0.1000	3.6870	-0.0999	0.0000	0.0000	0.0000	0.0000;
	2130	2129	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2132	2131	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2135	2134	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.1590	-0.8490	5.1590	0.8492	0.0000	0.0000	0.0000	0.0000;
	2138	2137	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2144	2143	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2146	2145	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2148	2147	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2154	2153	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2158	2157	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2171	2170	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2176	2175	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2178	2177	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2184	2183	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2198	2197	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.8980	-0.7620	5.8980	0.7622	0.0000	0.0000	0.0000	0.0000;
	2207	2206	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2210	2209	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-72.6828	-14.7239	72.6865	14.7613	0.0000	0.0000	0.0000	0.0000;
	2213	2212	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2215	2214	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2217	2216	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	15.9553	-0.2357	-15.9551	0.2375	0.0000	0.0000	0.0000	0.0000;
	2219	2218	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2222	2221	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-5.3070	-0.3710	5.3070	0.3712	0.0000	0.0000	0.0000	0.0000;
	2225	2224	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-15.1793	0.1851	15.1795	-0.1835	0.0000	0.0000	0.0000	0.0000;
	2230	2229	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2234	2233	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2236	2235	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2238	2237	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2247	2246	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2252	2251	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2254	2253	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-42.0239	-7.8991	42.0251	7.9115	0.0000	0.0000	0.0000	0.0000;
	2258	2257	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2261	2260	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2263	2262	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-58.4323	-7.2803	58.4347	7.3048	0.0000	0.0000	0.0000	0.0000;
	2274	2273	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-7.6640	-2.0320	7.6640	2.0325	0.0000	0.0000	0.0000	0.0000;
	2278	2277	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2288	2287	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.6121	3.6673	10.6122	-3.6664	0.0000	0.0000	0.0000	0.0000;
	2290	2289	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2294	2293	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2312	2311	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2314	2313	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2320	2319	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2342	2341	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.4921	-3.4982	2.4921	3.4983	0.0000	0.0000	0.0000	0.0000;
	2344	2343	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-26.1010	-12.3190	26.1016	12.3245	0.0000	0.0000	0.0000	0.0000;
	2348	2347	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.1080	-1.0750	8.1080	1.0754	0.0000	0.0000	0.0000	0.0000;
	2351	2350	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2355	2354	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2359	2358	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2361	2360	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2364	2363	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2367	2366	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-1.4270	-0.3600	1.4270	0.3600	0.0000	0.0000	0.0000	0.0000;
	2369	2368	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2371	2370	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.6568	1.8356	-2.6568	-1.8356	0.0000	0.0000	0.0000	0.0000;
	2374	2373	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2376	2375	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2379	2378	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2385	2384	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2387	2386	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2390	2389	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2422	2421	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000;
	2424	2423	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-27.0127	-1.2316	27.0132	1.2364	0.0000	0.0000	0.0000	0.0000;
	2441	2440	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	0.0000	0.0000	-0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2443	2442	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2445	2444	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2454	2453	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-10.0399	-1.3897	10.0400	1.3904	0.0000	0.0000	0.0000	0.0000;
	2466	2465	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.4795	2.5296	-31.4788	-2.5230	0.0000	0.0000	0.0000	0.0000;
	2471	2470	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-2.2386	-10.1220	2.2386	10.1227	0.0000	0.0000	0.0000	0.0000;
	2490	2489	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-42.7346	0.6277	42.7358	-0.6155	0.0000	0.0000	0.0000	0.0000;
	2492	2491	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-19.8360	2.2794	19.8363	-2.2765	0.0000	0.0000	0.0000	0.0000;
	2499	2498	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2501	2500	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2503	2502	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2506	2505	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	26.7130	-1.0100	-26.7125	1.0150	0.0000	0.0000	0.0000	0.0000;
	2520	2519	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	68.8027	36.2024	-68.7987	-36.1625	0.0000	0.0000	0.0000	0.0000;
	2521	2520	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-22.0504	-3.3483	22.0507	3.3516	0.0000	0.0000	0.0000	0.0000;
	2528	2527	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	2.5073	8.4525	-2.5072	-8.4520	0.0000	0.0000	0.0000	0.0000;
	2534	2533	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	1.1040	0.5000	-1.1040	-0.5000	0.0000	0.0000	0.0000	0.0000;
	2588	2587	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2593	2592	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	74.2016	3.7522	-74.1978	-3.7138	0.0000	0.0000	0.0000	0.0000;
	2595	2594	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-8.5067	0.9964	8.5068	-0.9959	0.0000	0.0000	0.0000	0.0000;
	2609	2608	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	33.7155	-12.2162	-33.7146	12.2254	0.0000	0.0000	0.0000	0.0000;
	2615	2614	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	6.2219	4.0371	-6.2218	-4.0367	0.0000	0.0000	0.0000	0.0000;
	2630	2629	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2651	2650	8.3e-05	0.000826	0	438	438	438	0	0	0	-360	360	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000;
	2661	2660	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-66.6669	9.1984	66.6699	-9.1685	0.0000	0.0000	0.0000	0.0000;
	2663	2662	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-3.4967	6.9926	3.4967	-6.9922	0.0000	0.0000	0.0000	0.0000;
	2680	2679	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	28.1372	12.0896	-28.1366	-12.0831	0.0000	0.0000	0.0000	0.0000;
	2698	2697	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	8.5118	-14.7831	-8.5116	14.7851	0.0000	0.0000	0.0000	0.0000;
	2702	2701	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	-52.7765	-4.1474	52.7785	4.1669	0.0000	0.0000	0.0000	0.0000;
	2718	2717	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	31.2107	4.5883	-31.2101	-4.5817	0.0000	0.0000	0.0000	0.0000;
	2721	2720	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	23.2141	2.8477	-23.2137	-2.8441	0.0000	0.0000	0.0000	0.0000;
	2734	2733	8.3e-05	0.000826	0	438	438	438	0	0	1	-360	360	4.1712	1.6380	-4.1712	-1.6378	0.0000	0.0000	0.0000	0.0000;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	18;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	76.1	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	112.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	102.05	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	105.35	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	111.63	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	90.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	94.09	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	92.78	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	95.31	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	97.12	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	99.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	91.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	92.43	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	116.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	96.42	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	89.22	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	98.84	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
